/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.rel.DruidJoinQueryRel;
import org.apache.druid.sql.calcite.rel.DruidOuterQueryRel;
import org.apache.druid.sql.calcite.rel.DruidQueryRel;
import org.apache.druid.sql.calcite.rel.DruidRel;
import org.apache.druid.sql.calcite.rel.DruidRelsTest;
import org.apache.druid.sql.calcite.rel.DruidUnionDataSourceRel;
import org.apache.druid.sql.calcite.rel.PartialDruidQuery;
import org.apache.druid.sql.calcite.rule.DruidUnionDataSourceRule;
import org.apache.druid.sql.calcite.table.DruidTable;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class DruidUnionDataSourceRuleTest {
    private final DruidTable fooDruidTable = new DruidTable((DataSource)new TableDataSource("foo"), RowSignature.builder().addTimeColumn().add("col1", ColumnType.STRING).add("col2", ColumnType.LONG).build(), null, false, false);

    @Test
    public void test_getColumnNamesIfTableOrUnion_tableScan() {
        DruidRel<?> druidRel = DruidRelsTest.mockDruidRel(DruidQueryRel.class, PartialDruidQuery.Stage.SCAN, this.fooDruidTable, null, null);
        Assert.assertEquals(Optional.of(ImmutableList.of((Object)"__time", (Object)"col1", (Object)"col2")), (Object)DruidUnionDataSourceRule.getColumnNamesIfTableOrUnion(druidRel, null));
    }

    @Test
    public void test_getColumnNamesIfTableOrUnion_tableMapping() {
        DruidRel<?> druidRel = DruidRelsTest.mockDruidRel(DruidQueryRel.class, PartialDruidQuery.Stage.SELECT_PROJECT, this.fooDruidTable, DruidRelsTest.mockMappingProject((List<Integer>)ImmutableList.of((Object)1), 3), null);
        Assert.assertEquals(Optional.of(ImmutableList.of((Object)"col1")), (Object)DruidUnionDataSourceRule.getColumnNamesIfTableOrUnion(druidRel, null));
    }

    @Test
    public void test_getColumnNamesIfTableOrUnion_tableProject() {
        DruidRel<?> druidRel = DruidRelsTest.mockDruidRel(DruidQueryRel.class, PartialDruidQuery.Stage.SELECT_PROJECT, this.fooDruidTable, DruidRelsTest.mockNonMappingProject(), null);
        Assert.assertEquals(Optional.empty(), (Object)DruidUnionDataSourceRule.getColumnNamesIfTableOrUnion(druidRel, null));
    }

    @Test
    public void test_getColumnNamesIfTableOrUnion_tableFilterPlusMapping() {
        DruidRel<?> druidRel = DruidRelsTest.mockDruidRel(DruidQueryRel.class, PartialDruidQuery.Stage.SELECT_PROJECT, this.fooDruidTable, DruidRelsTest.mockMappingProject((List<Integer>)ImmutableList.of((Object)1), 3), DruidRelsTest.mockFilter());
        Assert.assertEquals(Optional.empty(), (Object)DruidUnionDataSourceRule.getColumnNamesIfTableOrUnion(druidRel, null));
    }

    @Test
    public void test_getColumnNamesIfTableOrUnion_unionScan() {
        DruidUnionDataSourceRel druidRel = DruidRelsTest.mockDruidRel(DruidUnionDataSourceRel.class, rel -> EasyMock.expect((Object)rel.getUnionColumnNames()).andReturn((Object)this.fooDruidTable.getRowSignature().getColumnNames()), PartialDruidQuery.Stage.SCAN, null, null, null);
        Assert.assertEquals(Optional.of(ImmutableList.of((Object)"__time", (Object)"col1", (Object)"col2")), (Object)DruidUnionDataSourceRule.getColumnNamesIfTableOrUnion((DruidRel)druidRel, null));
    }

    @Test
    public void test_getColumnNamesIfTableOrUnion_unionMapping() {
        Project project = DruidRelsTest.mockMappingProject((List<Integer>)ImmutableList.of((Object)2, (Object)1), 3);
        Mappings.TargetMapping mapping = project.getMapping();
        String[] mappedColumnNames = new String[mapping.getTargetCount()];
        List columnNames = this.fooDruidTable.getRowSignature().getColumnNames();
        for (int i = 0; i < columnNames.size(); ++i) {
            mappedColumnNames[mapping.getTargetOpt((int)i)] = (String)columnNames.get(i);
        }
        DruidUnionDataSourceRel druidRel = DruidRelsTest.mockDruidRel(DruidUnionDataSourceRel.class, rel -> EasyMock.expect((Object)rel.getUnionColumnNames()).andReturn(Arrays.asList(mappedColumnNames)), PartialDruidQuery.Stage.SELECT_PROJECT, null, project, null);
        Assert.assertEquals(Optional.of(ImmutableList.of((Object)"col2", (Object)"col1")), (Object)DruidUnionDataSourceRule.getColumnNamesIfTableOrUnion((DruidRel)druidRel, null));
    }

    @Test
    public void test_getColumnNamesIfTableOrUnion_unionProject() {
        DruidUnionDataSourceRel druidRel = DruidRelsTest.mockDruidRel(DruidUnionDataSourceRel.class, rel -> EasyMock.expect((Object)rel.getUnionColumnNames()).andReturn((Object)this.fooDruidTable.getRowSignature().getColumnNames()), PartialDruidQuery.Stage.SELECT_PROJECT, null, DruidRelsTest.mockNonMappingProject(), null);
        Assert.assertEquals(Optional.of(ImmutableList.of((Object)"__time", (Object)"col1", (Object)"col2")), (Object)DruidUnionDataSourceRule.getColumnNamesIfTableOrUnion((DruidRel)druidRel, null));
    }

    @Test
    public void test_getColumnNamesIfTableOrUnion_outerQuery() {
        DruidRel<?> druidRel = DruidRelsTest.mockDruidRel(DruidOuterQueryRel.class, PartialDruidQuery.Stage.SELECT_PROJECT, null, null, null);
        Assert.assertEquals(Optional.empty(), (Object)DruidUnionDataSourceRule.getColumnNamesIfTableOrUnion(druidRel, null));
    }

    @Test
    public void test_getColumnNamesIfTableOrUnion_join() {
        DruidRel<?> druidRel = DruidRelsTest.mockDruidRel(DruidJoinQueryRel.class, PartialDruidQuery.Stage.SELECT_PROJECT, null, null, null);
        Assert.assertEquals(Optional.empty(), (Object)DruidUnionDataSourceRule.getColumnNamesIfTableOrUnion(druidRel, null));
    }
}

