/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.sql.calcite.planner.DruidTypeSystem;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.UnsupportedSQLQueryException;
import org.apache.druid.sql.calcite.rule.DruidLogicalValuesRule;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Enclosed.class)
public class DruidLogicalValuesRuleTest {
    private static final PlannerContext DEFAULT_CONTEXT = (PlannerContext)Mockito.mock(PlannerContext.class);

    public static class GetValueFromLiteralOtherTypesTest {
        private static final PlannerContext DEFAULT_CONTEXT = (PlannerContext)Mockito.mock(PlannerContext.class);
        private static final DateTimeZone TIME_ZONE = DateTimes.inferTzFromString((String)"Asia/Seoul");
        private static final RelDataTypeFactory TYPE_FACTORY = new SqlTypeFactoryImpl((RelDataTypeSystem)DruidTypeSystem.INSTANCE);
        private static final RexBuilder REX_BUILDER = new RexBuilder(TYPE_FACTORY);
        @Rule
        public ExpectedException expectedException = ExpectedException.none();

        @BeforeClass
        public static void setup() {
            Mockito.when((Object)DEFAULT_CONTEXT.getTimeZone()).thenReturn((Object)TIME_ZONE);
        }

        @Test
        public void testGetValueFromTrueLiteral() {
            RexLiteral literal = REX_BUILDER.makeLiteral(true);
            Object fromLiteral = DruidLogicalValuesRule.getValueFromLiteral((RexLiteral)literal, (PlannerContext)DEFAULT_CONTEXT);
            Assert.assertSame(Long.class, fromLiteral.getClass());
            Assert.assertEquals((Object)1L, (Object)fromLiteral);
        }

        @Test
        public void testGetValueFromFalseLiteral() {
            RexLiteral literal = REX_BUILDER.makeLiteral(false);
            Object fromLiteral = DruidLogicalValuesRule.getValueFromLiteral((RexLiteral)literal, (PlannerContext)DEFAULT_CONTEXT);
            Assert.assertSame(Long.class, fromLiteral.getClass());
            Assert.assertEquals((Object)0L, (Object)fromLiteral);
        }

        @Test
        public void testGetValueFromTimestampLiteral() {
            RexLiteral literal = REX_BUILDER.makeTimestampLiteral(new TimestampString("2021-04-01 16:54:31"), 0);
            Object fromLiteral = DruidLogicalValuesRule.getValueFromLiteral((RexLiteral)literal, (PlannerContext)DEFAULT_CONTEXT);
            Assert.assertSame(Long.class, fromLiteral.getClass());
            Assert.assertEquals((Object)new DateTime((Object)"2021-04-01T16:54:31", TIME_ZONE).getMillis(), (Object)fromLiteral);
        }

        @Test
        public void testGetValueFromDateLiteral() {
            RexLiteral literal = REX_BUILDER.makeDateLiteral(new DateString("2021-04-01"));
            Object fromLiteral = DruidLogicalValuesRule.getValueFromLiteral((RexLiteral)literal, (PlannerContext)DEFAULT_CONTEXT);
            Assert.assertSame(Long.class, fromLiteral.getClass());
            Assert.assertEquals((Object)new DateTime((Object)"2021-04-01", TIME_ZONE).getMillis(), (Object)fromLiteral);
        }

        @Test
        public void testGetValueFromTimestampWithLocalTimeZoneLiteral() {
            RexLiteral literal = REX_BUILDER.makeTimestampWithLocalTimeZoneLiteral(new TimestampString("2021-04-01 16:54:31"), 0);
            this.expectedException.expect(UnsupportedSQLQueryException.class);
            this.expectedException.expectMessage("TIMESTAMP_WITH_LOCAL_TIME_ZONE type is not supported");
            DruidLogicalValuesRule.getValueFromLiteral((RexLiteral)literal, (PlannerContext)DEFAULT_CONTEXT);
        }

        @Test
        public void testGetValueFromTimeLiteral() {
            RexLiteral literal = REX_BUILDER.makeTimeLiteral(new TimeString("16:54:31"), 0);
            this.expectedException.expect(UnsupportedSQLQueryException.class);
            this.expectedException.expectMessage("TIME type is not supported");
            DruidLogicalValuesRule.getValueFromLiteral((RexLiteral)literal, (PlannerContext)DEFAULT_CONTEXT);
        }

        @Test
        public void testGetValueFromTimeWithLocalTimeZoneLiteral() {
            RexLiteral literal = REX_BUILDER.makeTimeWithLocalTimeZoneLiteral(new TimeString("16:54:31"), 0);
            this.expectedException.expect(UnsupportedSQLQueryException.class);
            this.expectedException.expectMessage("TIME_WITH_LOCAL_TIME_ZONE type is not supported");
            DruidLogicalValuesRule.getValueFromLiteral((RexLiteral)literal, (PlannerContext)DEFAULT_CONTEXT);
        }

        @Test
        public void testGetCastedValuesFromFloatToNumeric() {
            RexLiteral literal = REX_BUILDER.makeExactLiteral(new BigDecimal("123.0"), TYPE_FACTORY.createSqlType(SqlTypeName.INTEGER));
            Object value = DruidLogicalValuesRule.getValueFromLiteral((RexLiteral)literal, (PlannerContext)DEFAULT_CONTEXT);
            Assert.assertEquals((Object)value, (Object)123L);
        }
    }

    @RunWith(value=Parameterized.class)
    public static class GetValueFromLiteralSimpleTypesTest {
        private final Comparable<?> val;
        private final SqlTypeName sqlTypeName;
        private final Class<?> javaType;

        @Parameterized.Parameters(name="{1}, {2}")
        public static Iterable<Object[]> constructorFeeder() {
            return ImmutableList.of((Object)new Object[]{"test", SqlTypeName.CHAR, String.class}, (Object)new Object[]{"test", SqlTypeName.VARCHAR, String.class}, (Object)new Object[]{0.1, SqlTypeName.DOUBLE, Double.class}, (Object)new Object[]{0.1, SqlTypeName.REAL, Double.class}, (Object)new Object[]{0.1, SqlTypeName.DECIMAL, Double.class}, (Object)new Object[]{1L, SqlTypeName.TINYINT, Long.class}, (Object)new Object[]{1L, SqlTypeName.SMALLINT, Long.class}, (Object)new Object[]{1L, SqlTypeName.INTEGER, Long.class}, (Object)new Object[]{1L, SqlTypeName.BIGINT, Long.class});
        }

        public GetValueFromLiteralSimpleTypesTest(Comparable<?> val, SqlTypeName sqlTypeName, Class<?> javaType) {
            this.val = val;
            this.sqlTypeName = sqlTypeName;
            this.javaType = javaType;
        }

        @Test
        public void testGetValueFromLiteral() {
            RexLiteral literal = GetValueFromLiteralSimpleTypesTest.makeLiteral(this.val, this.sqlTypeName, this.javaType);
            Object fromLiteral = DruidLogicalValuesRule.getValueFromLiteral((RexLiteral)literal, (PlannerContext)DEFAULT_CONTEXT);
            Assert.assertSame(this.javaType, fromLiteral.getClass());
            Assert.assertEquals(this.val, (Object)fromLiteral);
            ((RexLiteral)Mockito.verify((Object)literal, (VerificationMode)Mockito.times((int)1))).getType();
        }

        private static RexLiteral makeLiteral(Comparable<?> val, SqlTypeName typeName, Class<?> javaType) {
            RelDataType dataType = (RelDataType)Mockito.mock(RelDataType.class);
            Mockito.when((Object)dataType.getSqlTypeName()).thenReturn((Object)typeName);
            RexLiteral literal = (RexLiteral)Mockito.mock(RexLiteral.class);
            try {
                Field field = literal.getClass().getSuperclass().getDeclaredField("value");
                field.setAccessible(true);
                field.set(literal, val);
            }
            catch (Exception e) {
                Assert.fail((String)("Unable to mock the literal for test.\nException: " + e));
            }
            Mockito.when((Object)literal.getType()).thenReturn((Object)dataType);
            Mockito.when((Object)literal.getValueAs((Class)ArgumentMatchers.any())).thenReturn(javaType.cast(val));
            return literal;
        }
    }
}

