/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.util.List;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.query.QueryContext;
import org.apache.druid.sql.calcite.planner.DruidTypeSystem;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rule.DruidJoinRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class DruidJoinRuleTest {
    private final RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)new JavaTypeFactoryImpl());
    private final RelDataTypeFactory typeFactory = new SqlTypeFactoryImpl((RelDataTypeSystem)DruidTypeSystem.INSTANCE);
    private final RelDataType leftType = new SqlTypeFactoryImpl((RelDataTypeSystem)DruidTypeSystem.INSTANCE).createStructType((List)ImmutableList.of((Object)this.typeFactory.createSqlType(SqlTypeName.VARCHAR)), (List)ImmutableList.of((Object)"left"));
    private final RelDataType joinType = new SqlTypeFactoryImpl((RelDataTypeSystem)DruidTypeSystem.INSTANCE).createStructType((List)ImmutableList.of((Object)this.typeFactory.createSqlType(SqlTypeName.VARCHAR), (Object)this.typeFactory.createSqlType(SqlTypeName.VARCHAR)), (List)ImmutableList.of((Object)"left", (Object)"right"));
    private DruidJoinRule druidJoinRule;

    @Before
    public void setup() {
        PlannerContext plannerContext = (PlannerContext)Mockito.mock(PlannerContext.class);
        Mockito.when((Object)plannerContext.getQueryContext()).thenReturn(Mockito.mock(QueryContext.class));
        this.druidJoinRule = DruidJoinRule.instance((PlannerContext)plannerContext);
    }

    @Test
    public void test_canHandleCondition_leftEqRight() {
        Assert.assertTrue((boolean)this.druidJoinRule.canHandleCondition(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder.makeInputRef(this.joinType, 0), this.rexBuilder.makeInputRef(this.joinType, 1)}), this.leftType, null));
    }

    @Test
    public void test_canHandleCondition_leftFnEqRight() {
        Assert.assertTrue((boolean)this.druidJoinRule.canHandleCondition(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CONCAT, new RexNode[]{this.rexBuilder.makeLiteral("foo"), this.rexBuilder.makeInputRef(this.typeFactory.createSqlType(SqlTypeName.VARCHAR), 0)}), this.rexBuilder.makeInputRef(this.typeFactory.createSqlType(SqlTypeName.VARCHAR), 1)}), this.leftType, null));
    }

    @Test
    public void test_canHandleCondition_leftEqRightFn() {
        Assert.assertFalse((boolean)this.druidJoinRule.canHandleCondition(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder.makeInputRef(this.typeFactory.createSqlType(SqlTypeName.VARCHAR), 0), this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CONCAT, new RexNode[]{this.rexBuilder.makeLiteral("foo"), this.rexBuilder.makeInputRef(this.typeFactory.createSqlType(SqlTypeName.VARCHAR), 1)})}), this.leftType, null));
    }

    @Test
    public void test_canHandleCondition_leftEqLeft() {
        Assert.assertFalse((boolean)this.druidJoinRule.canHandleCondition(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder.makeInputRef(this.typeFactory.createSqlType(SqlTypeName.VARCHAR), 0), this.rexBuilder.makeInputRef(this.typeFactory.createSqlType(SqlTypeName.VARCHAR), 0)}), this.leftType, null));
    }

    @Test
    public void test_canHandleCondition_rightEqRight() {
        Assert.assertFalse((boolean)this.druidJoinRule.canHandleCondition(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.rexBuilder.makeInputRef(this.typeFactory.createSqlType(SqlTypeName.VARCHAR), 1), this.rexBuilder.makeInputRef(this.typeFactory.createSqlType(SqlTypeName.VARCHAR), 1)}), this.leftType, null));
    }

    @Test
    public void test_canHandleCondition_true() {
        Assert.assertTrue((boolean)this.druidJoinRule.canHandleCondition((RexNode)this.rexBuilder.makeLiteral(true), this.leftType, null));
    }

    @Test
    public void test_canHandleCondition_false() {
        Assert.assertTrue((boolean)this.druidJoinRule.canHandleCondition((RexNode)this.rexBuilder.makeLiteral(false), this.leftType, null));
    }

    @Test
    public void test_decomposeAnd_notAnAnd() {
        List rexNodes = DruidJoinRule.decomposeAnd((RexNode)this.rexBuilder.makeInputRef(this.leftType, 0));
        Assert.assertEquals((long)1L, (long)rexNodes.size());
        Assert.assertEquals((Object)this.rexBuilder.makeInputRef(this.leftType, 0), (Object)Iterables.getOnlyElement((Iterable)rexNodes));
    }

    @Test
    public void test_decomposeAnd_basic() {
        List decomposed = DruidJoinRule.decomposeAnd((RexNode)this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(1L)), this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(2L))}), this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(3L)), this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(4L))})}));
        Assert.assertEquals((Object)ImmutableList.of((Object)this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(1L)), (Object)this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(2L)), (Object)this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(3L)), (Object)this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(4L))), (Object)decomposed);
    }
}

