/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import java.util.Collections;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class DruidQueryTest {
    private final DimFilter selectorFilter = new SelectorDimFilter("column", "value", null);
    private final DimFilter otherFilter = new SelectorDimFilter("column_2", "value_2", null);
    private final DimFilter filterWithInterval = new AndDimFilter(new DimFilter[]{this.selectorFilter, new BoundDimFilter("__time", "100", "200", Boolean.valueOf(false), Boolean.valueOf(true), null, null, StringComparators.NUMERIC)});

    @Test
    public void test_filtration_noJoinAndInterval() {
        TableDataSource dataSource = new TableDataSource("test");
        Pair pair = DruidQuery.getFiltration((DataSource)dataSource, (DimFilter)this.selectorFilter, (VirtualColumnRegistry)VirtualColumnRegistry.create((RowSignature)RowSignature.empty(), (ExprMacroTable)TestExprMacroTable.INSTANCE));
        this.verify((Pair<DataSource, Filtration>)pair, (DataSource)dataSource, this.selectorFilter, Intervals.ETERNITY);
    }

    @Test
    public void test_filtration_intervalInQueryFilter() {
        TableDataSource dataSource = new TableDataSource("test");
        Pair pair = DruidQuery.getFiltration((DataSource)dataSource, (DimFilter)this.filterWithInterval, (VirtualColumnRegistry)VirtualColumnRegistry.create((RowSignature)RowSignature.empty(), (ExprMacroTable)TestExprMacroTable.INSTANCE));
        this.verify((Pair<DataSource, Filtration>)pair, (DataSource)dataSource, this.selectorFilter, Intervals.utc((long)100L, (long)200L));
    }

    @Test
    public void test_filtration_joinDataSource_intervalInQueryFilter() {
        JoinDataSource dataSource = this.join(JoinType.INNER, this.otherFilter);
        Pair pair = DruidQuery.getFiltration((DataSource)dataSource, (DimFilter)this.filterWithInterval, (VirtualColumnRegistry)VirtualColumnRegistry.create((RowSignature)RowSignature.empty(), (ExprMacroTable)TestExprMacroTable.INSTANCE));
        this.verify((Pair<DataSource, Filtration>)pair, (DataSource)dataSource, this.selectorFilter, Intervals.utc((long)100L, (long)200L));
    }

    @Test
    public void test_filtration_joinDataSource_intervalInBaseTableFilter_inner() {
        JoinDataSource dataSource = this.join(JoinType.INNER, this.filterWithInterval);
        JoinDataSource expectedDataSource = this.join(JoinType.INNER, this.selectorFilter);
        Pair pair = DruidQuery.getFiltration((DataSource)dataSource, (DimFilter)this.otherFilter, (VirtualColumnRegistry)VirtualColumnRegistry.create((RowSignature)RowSignature.empty(), (ExprMacroTable)TestExprMacroTable.INSTANCE));
        this.verify((Pair<DataSource, Filtration>)pair, (DataSource)expectedDataSource, this.otherFilter, Intervals.utc((long)100L, (long)200L));
    }

    @Test
    public void test_filtration_joinDataSource_intervalInBaseTableFilter_left() {
        JoinDataSource dataSource = this.join(JoinType.LEFT, this.filterWithInterval);
        JoinDataSource expectedDataSource = this.join(JoinType.LEFT, this.selectorFilter);
        Pair pair = DruidQuery.getFiltration((DataSource)dataSource, (DimFilter)this.otherFilter, (VirtualColumnRegistry)VirtualColumnRegistry.create((RowSignature)RowSignature.empty(), (ExprMacroTable)TestExprMacroTable.INSTANCE));
        this.verify((Pair<DataSource, Filtration>)pair, (DataSource)expectedDataSource, this.otherFilter, Intervals.utc((long)100L, (long)200L));
    }

    @Test
    public void test_filtration_joinDataSource_intervalInBaseTableFilter_right() {
        JoinDataSource dataSource = this.join(JoinType.RIGHT, this.filterWithInterval);
        JoinDataSource expectedDataSource = this.join(JoinType.RIGHT, this.selectorFilter);
        Pair pair = DruidQuery.getFiltration((DataSource)dataSource, (DimFilter)this.otherFilter, (VirtualColumnRegistry)VirtualColumnRegistry.create((RowSignature)RowSignature.empty(), (ExprMacroTable)TestExprMacroTable.INSTANCE));
        this.verify((Pair<DataSource, Filtration>)pair, (DataSource)expectedDataSource, this.otherFilter, Intervals.utc((long)100L, (long)200L));
    }

    @Test
    public void test_filtration_joinDataSource_intervalInBaseTableFilter_full() {
        JoinDataSource dataSource = this.join(JoinType.FULL, this.filterWithInterval);
        JoinDataSource expectedDataSource = this.join(JoinType.FULL, this.selectorFilter);
        Pair pair = DruidQuery.getFiltration((DataSource)dataSource, (DimFilter)this.otherFilter, (VirtualColumnRegistry)VirtualColumnRegistry.create((RowSignature)RowSignature.empty(), (ExprMacroTable)TestExprMacroTable.INSTANCE));
        this.verify((Pair<DataSource, Filtration>)pair, (DataSource)expectedDataSource, this.otherFilter, Intervals.utc((long)100L, (long)200L));
    }

    @Test
    public void test_filtration_intervalsInBothFilters() {
        JoinDataSource dataSource = this.join(JoinType.INNER, this.filterWithInterval);
        JoinDataSource expectedDataSource = this.join(JoinType.INNER, this.selectorFilter);
        AndDimFilter queryFilter = new AndDimFilter(new DimFilter[]{this.otherFilter, new BoundDimFilter("__time", "150", "250", Boolean.valueOf(false), Boolean.valueOf(true), null, null, StringComparators.NUMERIC)});
        Pair pair = DruidQuery.getFiltration((DataSource)dataSource, (DimFilter)queryFilter, (VirtualColumnRegistry)VirtualColumnRegistry.create((RowSignature)RowSignature.empty(), (ExprMacroTable)TestExprMacroTable.INSTANCE));
        this.verify((Pair<DataSource, Filtration>)pair, (DataSource)expectedDataSource, this.otherFilter, Intervals.utc((long)150L, (long)200L));
    }

    private JoinDataSource join(JoinType joinType, DimFilter filter) {
        return JoinDataSource.create((DataSource)new TableDataSource("left"), (DataSource)new TableDataSource("right"), (String)"r.", (String)"c == \"r.c\"", (JoinType)joinType, (DimFilter)filter, (ExprMacroTable)ExprMacroTable.nil());
    }

    private void verify(Pair<DataSource, Filtration> pair, DataSource dataSource, DimFilter columnFilter, Interval interval) {
        Assert.assertEquals((Object)dataSource, (Object)pair.lhs);
        Assert.assertEquals((String)("dim-filter: " + ((Filtration)pair.rhs).getDimFilter()), (Object)columnFilter, (Object)((Filtration)pair.rhs).getDimFilter());
        Assert.assertEquals(Collections.singletonList(interval), (Object)((Filtration)pair.rhs).getIntervals());
    }

    static {
        NullHandling.initializeForTests();
    }
}

