/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.google.common.collect.ImmutableSortedSet;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.junit.Assert;
import org.junit.Test;

public class CalcitesTest
extends CalciteTestBase {
    @Test
    public void testEscapeStringLiteral() {
        Assert.assertEquals((Object)"''", (Object)Calcites.escapeStringLiteral((String)""));
        Assert.assertEquals((Object)"'foo'", (Object)Calcites.escapeStringLiteral((String)"foo"));
        Assert.assertEquals((Object)"'foo bar'", (Object)Calcites.escapeStringLiteral((String)"foo bar"));
        Assert.assertEquals((Object)"U&'fo\u00f6 bar'", (Object)Calcites.escapeStringLiteral((String)"fo\u00f6 bar"));
        Assert.assertEquals((Object)"U&'foo \\0026\\0026 bar'", (Object)Calcites.escapeStringLiteral((String)"foo && bar"));
        Assert.assertEquals((Object)"U&'foo \\005C bar'", (Object)Calcites.escapeStringLiteral((String)"foo \\ bar"));
        Assert.assertEquals((Object)"U&'foo\\0027s bar'", (Object)Calcites.escapeStringLiteral((String)"foo's bar"));
        Assert.assertEquals((Object)"U&'\u0434\u0440\u0443\u0438\u0434'", (Object)Calcites.escapeStringLiteral((String)"\u0434\u0440\u0443\u0438\u0434"));
    }

    @Test
    public void testFindUnusedPrefix() {
        Assert.assertEquals((Object)"x", (Object)Calcites.findUnusedPrefixForDigits((String)"x", (Iterable)ImmutableSortedSet.of((Comparable)((Object)"foo"), (Comparable)((Object)"bar"))));
        Assert.assertEquals((Object)"x", (Object)Calcites.findUnusedPrefixForDigits((String)"x", (Iterable)ImmutableSortedSet.of((Comparable)((Object)"foo"), (Comparable)((Object)"bar"), (Comparable)((Object)"x"))));
        Assert.assertEquals((Object)"_x", (Object)Calcites.findUnusedPrefixForDigits((String)"x", (Iterable)ImmutableSortedSet.of((Comparable)((Object)"foo"), (Comparable)((Object)"bar"), (Comparable)((Object)"x0"))));
        Assert.assertEquals((Object)"_x", (Object)Calcites.findUnusedPrefixForDigits((String)"x", (Iterable)ImmutableSortedSet.of((Comparable)((Object)"foo"), (Comparable)((Object)"bar"), (Comparable)((Object)"x4"))));
        Assert.assertEquals((Object)"__x", (Object)Calcites.findUnusedPrefixForDigits((String)"x", (Iterable)ImmutableSortedSet.of((Comparable)((Object)"foo"), (Comparable)((Object)"xa"), (Comparable)((Object)"_x2xx"), (Comparable)((Object)"x0"))));
        Assert.assertEquals((Object)"x", (Object)Calcites.findUnusedPrefixForDigits((String)"x", (Iterable)ImmutableSortedSet.of((Comparable)((Object)"foo"), (Comparable)((Object)"xa"), (Comparable)((Object)"_x2xx"), (Comparable)((Object)" x"))));
        Assert.assertEquals((Object)"x", (Object)Calcites.findUnusedPrefixForDigits((String)"x", (Iterable)ImmutableSortedSet.of((Comparable)((Object)"foo"), (Comparable)((Object)"_xbxx"))));
        Assert.assertEquals((Object)"x", (Object)Calcites.findUnusedPrefixForDigits((String)"x", (Iterable)ImmutableSortedSet.of((Comparable)((Object)"foo"), (Comparable)((Object)"xa"), (Comparable)((Object)"_x"))));
        Assert.assertEquals((Object)"__x", (Object)Calcites.findUnusedPrefixForDigits((String)"x", (Iterable)ImmutableSortedSet.of((Comparable)((Object)"foo"), (Comparable)((Object)"x1a"), (Comparable)((Object)"_x90"))));
    }
}

