/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.util.Set;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.calcite.schema.Schema;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.jackson.JacksonModule;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.CalcitePlannerModule;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.schema.DruidSchemaName;
import org.apache.druid.sql.calcite.schema.NamedSchema;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class CalcitePlannerModuleTest
extends CalciteTestBase {
    private static final String SCHEMA_1 = "SCHEMA_1";
    private static final String SCHEMA_2 = "SCHEMA_2";
    private static final String DRUID_SCHEMA_NAME = "DRUID_SCHEMA_NAME";
    @Mock
    private NamedSchema druidSchema1;
    @Mock
    private NamedSchema druidSchema2;
    @Mock
    private Schema schema1;
    @Mock
    private Schema schema2;
    @Mock
    private QueryLifecycleFactory queryLifecycleFactory;
    @Mock
    private ExprMacroTable macroTable;
    @Mock
    private AuthorizerMapper authorizerMapper;
    @Mock
    private DruidSchemaCatalog rootSchema;
    private Set<SqlAggregator> aggregators;
    private Set<SqlOperatorConversion> operatorConversions;
    private CalcitePlannerModule target;
    private Injector injector;

    @Before
    public void setUp() {
        EasyMock.expect((Object)this.druidSchema1.getSchema()).andStubReturn((Object)this.schema1);
        EasyMock.expect((Object)this.druidSchema2.getSchema()).andStubReturn((Object)this.schema2);
        EasyMock.expect((Object)this.druidSchema1.getSchemaName()).andStubReturn((Object)SCHEMA_1);
        EasyMock.expect((Object)this.druidSchema2.getSchemaName()).andStubReturn((Object)SCHEMA_2);
        EasyMock.expect((Object)this.druidSchema1.getSchemaResourceType(EasyMock.anyString())).andStubReturn((Object)"DATASOURCE");
        EasyMock.expect((Object)this.druidSchema2.getSchemaResourceType(EasyMock.anyString())).andStubReturn((Object)"test");
        EasyMock.replay((Object[])new Object[]{this.druidSchema1, this.druidSchema2});
        this.aggregators = ImmutableSet.of();
        this.operatorConversions = ImmutableSet.of();
        this.target = new CalcitePlannerModule();
        this.injector = Guice.createInjector((Module[])new Module[]{new JacksonModule(), binder -> {
            binder.bind(Validator.class).toInstance((Object)Validation.buildDefaultValidatorFactory().getValidator());
            binder.bindScope(LazySingleton.class, Scopes.SINGLETON);
            binder.bind(QueryLifecycleFactory.class).toInstance((Object)this.queryLifecycleFactory);
            binder.bind(ExprMacroTable.class).toInstance((Object)this.macroTable);
            binder.bind(AuthorizerMapper.class).toInstance((Object)this.authorizerMapper);
            binder.bind(String.class).annotatedWith(DruidSchemaName.class).toInstance((Object)DRUID_SCHEMA_NAME);
            binder.bind(Key.get((TypeLiteral)new TypeLiteral<Set<SqlAggregator>>(){})).toInstance(this.aggregators);
            binder.bind(Key.get((TypeLiteral)new TypeLiteral<Set<SqlOperatorConversion>>(){})).toInstance(this.operatorConversions);
            binder.bind(DruidSchemaCatalog.class).toInstance((Object)this.rootSchema);
        }, this.target});
    }

    @Test
    public void testDruidOperatorTableIsInjectable() {
        DruidOperatorTable operatorTable = (DruidOperatorTable)this.injector.getInstance(DruidOperatorTable.class);
        Assert.assertNotNull((Object)operatorTable);
        DruidOperatorTable other = (DruidOperatorTable)this.injector.getInstance(DruidOperatorTable.class);
        Assert.assertSame((Object)other, (Object)operatorTable);
    }

    @Test
    public void testPlannerFactoryIsInjectable() {
        PlannerFactory plannerFactory = (PlannerFactory)this.injector.getInstance(PlannerFactory.class);
        Assert.assertNotNull(PlannerFactory.class);
        PlannerFactory other = (PlannerFactory)this.injector.getInstance(PlannerFactory.class);
        Assert.assertSame((Object)other, (Object)plannerFactory);
    }

    @Test
    public void testPlannerConfigIsInjected() {
        PlannerConfig plannerConfig = (PlannerConfig)this.injector.getInstance(PlannerConfig.class);
        Assert.assertNotNull((Object)plannerConfig);
    }
}

