/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.parser;

import com.google.common.collect.ImmutableList;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.sql.calcite.expression.builtin.TimeFloorOperatorConversion;
import org.apache.druid.sql.calcite.parser.DruidSqlParserUtils;
import org.apache.druid.sql.calcite.parser.ParseException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class DruidSqlParserUtilsTest {

    public static class FloorToGranularityConversionTestErrors {
        @Test
        public void testConvertSqlNodeToGranularityWithIncorrectNode() {
            SqlCharStringLiteral sqlNode = SqlLiteral.createCharString((String)"day", (SqlParserPos)SqlParserPos.ZERO);
            ParseException e = (ParseException)Assert.assertThrows(ParseException.class, () -> FloorToGranularityConversionTestErrors.lambda$testConvertSqlNodeToGranularityWithIncorrectNode$0((SqlNode)sqlNode));
            Assert.assertEquals((Object)"Encountered 'day' after PARTITIONED BY. Expected HOUR, DAY, MONTH, YEAR, ALL TIME, FLOOR function or TIME_FLOOR function", (Object)e.getMessage());
        }

        @Test
        public void testConvertSqlNodeToGranularityWithIncorrectFunctionCall() {
            SqlNodeList args = new SqlNodeList(SqlParserPos.ZERO);
            args.add((SqlNode)new SqlIdentifier("__time", SqlParserPos.ZERO));
            args.add((SqlNode)new SqlIntervalQualifier(TimeUnit.DAY, null, SqlParserPos.ZERO));
            SqlCall sqlNode = SqlStdOperatorTable.CEIL.createCall(args);
            ParseException e = (ParseException)Assert.assertThrows(ParseException.class, () -> FloorToGranularityConversionTestErrors.lambda$testConvertSqlNodeToGranularityWithIncorrectFunctionCall$1((SqlNode)sqlNode));
            Assert.assertEquals((Object)"PARTITIONED BY clause only supports FLOOR(__time TO <unit> and TIME_FLOOR(__time, period) functions", (Object)e.getMessage());
        }

        @Test
        public void testConvertSqlNodeToGranularityWithIncorrectNumberOfArguments() {
            SqlNodeList args = new SqlNodeList(SqlParserPos.ZERO);
            args.add((SqlNode)new SqlIdentifier("__time", SqlParserPos.ZERO));
            SqlCall sqlNode = SqlStdOperatorTable.FLOOR.createCall(args);
            ParseException e = (ParseException)Assert.assertThrows(ParseException.class, () -> FloorToGranularityConversionTestErrors.lambda$testConvertSqlNodeToGranularityWithIncorrectNumberOfArguments$2((SqlNode)sqlNode));
            Assert.assertEquals((Object)"FLOOR in PARTITIONED BY clause must have two arguments", (Object)e.getMessage());
        }

        @Test
        public void testConvertSqlNodeToGranularityWithWrongIdentifierInFloorFunction() {
            SqlNodeList args = new SqlNodeList(SqlParserPos.ZERO);
            args.add((SqlNode)new SqlIdentifier("timestamps", SqlParserPos.ZERO));
            args.add((SqlNode)new SqlIntervalQualifier(TimeUnit.DAY, null, SqlParserPos.ZERO));
            SqlCall sqlNode = SqlStdOperatorTable.FLOOR.createCall(args);
            ParseException e = (ParseException)Assert.assertThrows(ParseException.class, () -> FloorToGranularityConversionTestErrors.lambda$testConvertSqlNodeToGranularityWithWrongIdentifierInFloorFunction$3((SqlNode)sqlNode));
            Assert.assertEquals((Object)"First argument to FLOOR in PARTITIONED BY clause can only be __time", (Object)e.getMessage());
        }

        @Test
        public void testConvertSqlNodeToGranularityWithWrongIdentifierInTimeFloorFunction() {
            SqlNodeList args = new SqlNodeList(SqlParserPos.ZERO);
            args.add((SqlNode)new SqlIdentifier("timestamps", SqlParserPos.ZERO));
            args.add((SqlNode)SqlLiteral.createCharString((String)"PT1H", (SqlParserPos)SqlParserPos.ZERO));
            SqlCall sqlNode = TimeFloorOperatorConversion.SQL_FUNCTION.createCall(args);
            ParseException e = (ParseException)Assert.assertThrows(ParseException.class, () -> FloorToGranularityConversionTestErrors.lambda$testConvertSqlNodeToGranularityWithWrongIdentifierInTimeFloorFunction$4((SqlNode)sqlNode));
            Assert.assertEquals((Object)"First argument to TIME_FLOOR in PARTITIONED BY clause can only be __time", (Object)e.getMessage());
        }

        @Test
        public void testConvertSqlNodeToGranularityWithIncorrectIngestionGranularityInFloorFunction() {
            SqlNodeList args = new SqlNodeList(SqlParserPos.ZERO);
            args.add((SqlNode)new SqlIdentifier("__time", SqlParserPos.ZERO));
            args.add((SqlNode)new SqlIntervalQualifier(TimeUnit.ISOYEAR, null, SqlParserPos.ZERO));
            SqlCall sqlNode = SqlStdOperatorTable.FLOOR.createCall(args);
            ParseException e = (ParseException)Assert.assertThrows(ParseException.class, () -> FloorToGranularityConversionTestErrors.lambda$testConvertSqlNodeToGranularityWithIncorrectIngestionGranularityInFloorFunction$5((SqlNode)sqlNode));
            Assert.assertEquals((Object)"ISOYEAR is not a valid granularity for ingestion", (Object)e.getMessage());
        }

        @Test
        public void testConvertSqlNodeToGranularityWithIncorrectIngestionGranularityInTimeFloorFunction() {
            SqlNodeList args = new SqlNodeList(SqlParserPos.ZERO);
            args.add((SqlNode)new SqlIdentifier("__time", SqlParserPos.ZERO));
            args.add((SqlNode)SqlLiteral.createCharString((String)"abc", (SqlParserPos)SqlParserPos.ZERO));
            SqlCall sqlNode = TimeFloorOperatorConversion.SQL_FUNCTION.createCall(args);
            ParseException e = (ParseException)Assert.assertThrows(ParseException.class, () -> FloorToGranularityConversionTestErrors.lambda$testConvertSqlNodeToGranularityWithIncorrectIngestionGranularityInTimeFloorFunction$6((SqlNode)sqlNode));
            Assert.assertEquals((Object)"'abc' is an invalid period string", (Object)e.getMessage());
        }

        private static /* synthetic */ void lambda$testConvertSqlNodeToGranularityWithIncorrectIngestionGranularityInTimeFloorFunction$6(SqlNode sqlNode) throws Throwable {
            DruidSqlParserUtils.convertSqlNodeToGranularityThrowingParseExceptions((SqlNode)sqlNode);
        }

        private static /* synthetic */ void lambda$testConvertSqlNodeToGranularityWithIncorrectIngestionGranularityInFloorFunction$5(SqlNode sqlNode) throws Throwable {
            DruidSqlParserUtils.convertSqlNodeToGranularityThrowingParseExceptions((SqlNode)sqlNode);
        }

        private static /* synthetic */ void lambda$testConvertSqlNodeToGranularityWithWrongIdentifierInTimeFloorFunction$4(SqlNode sqlNode) throws Throwable {
            DruidSqlParserUtils.convertSqlNodeToGranularityThrowingParseExceptions((SqlNode)sqlNode);
        }

        private static /* synthetic */ void lambda$testConvertSqlNodeToGranularityWithWrongIdentifierInFloorFunction$3(SqlNode sqlNode) throws Throwable {
            DruidSqlParserUtils.convertSqlNodeToGranularityThrowingParseExceptions((SqlNode)sqlNode);
        }

        private static /* synthetic */ void lambda$testConvertSqlNodeToGranularityWithIncorrectNumberOfArguments$2(SqlNode sqlNode) throws Throwable {
            DruidSqlParserUtils.convertSqlNodeToGranularityThrowingParseExceptions((SqlNode)sqlNode);
        }

        private static /* synthetic */ void lambda$testConvertSqlNodeToGranularityWithIncorrectFunctionCall$1(SqlNode sqlNode) throws Throwable {
            DruidSqlParserUtils.convertSqlNodeToGranularityThrowingParseExceptions((SqlNode)sqlNode);
        }

        private static /* synthetic */ void lambda$testConvertSqlNodeToGranularityWithIncorrectNode$0(SqlNode sqlNode) throws Throwable {
            DruidSqlParserUtils.convertSqlNodeToGranularityThrowingParseExceptions((SqlNode)sqlNode);
        }
    }

    @RunWith(value=Parameterized.class)
    public static class FloorToGranularityConversionTest {
        TimeUnit timeUnit;
        Granularity expectedGranularity;

        @Parameterized.Parameters(name="{1}")
        public static Iterable<Object[]> constructorFeeder() {
            return ImmutableList.of((Object)new Object[]{TimeUnit.SECOND, Granularities.SECOND}, (Object)new Object[]{TimeUnit.MINUTE, Granularities.MINUTE}, (Object)new Object[]{TimeUnit.HOUR, Granularities.HOUR}, (Object)new Object[]{TimeUnit.DAY, Granularities.DAY}, (Object)new Object[]{TimeUnit.WEEK, Granularities.WEEK}, (Object)new Object[]{TimeUnit.MONTH, Granularities.MONTH}, (Object)new Object[]{TimeUnit.QUARTER, Granularities.QUARTER}, (Object)new Object[]{TimeUnit.YEAR, Granularities.YEAR});
        }

        public FloorToGranularityConversionTest(TimeUnit timeUnit, Granularity expectedGranularity) {
            this.timeUnit = timeUnit;
            this.expectedGranularity = expectedGranularity;
        }

        @Test
        public void testGetGranularityFromFloor() throws ParseException {
            SqlNodeList args = new SqlNodeList(SqlParserPos.ZERO);
            args.add((SqlNode)new SqlIdentifier("__time", SqlParserPos.ZERO));
            args.add((SqlNode)new SqlIntervalQualifier(this.timeUnit, null, SqlParserPos.ZERO));
            SqlCall floorCall = SqlStdOperatorTable.FLOOR.createCall(args);
            Granularity actualGranularity = DruidSqlParserUtils.convertSqlNodeToGranularityThrowingParseExceptions((SqlNode)floorCall);
            Assert.assertEquals((Object)this.expectedGranularity, (Object)actualGranularity);
        }
    }

    @RunWith(value=Parameterized.class)
    public static class TimeFloorToGranularityConversionTest {
        String periodString;
        Granularity expectedGranularity;

        @Parameterized.Parameters(name="{1}")
        public static Iterable<Object[]> constructorFeeder() {
            return ImmutableList.of((Object)new Object[]{"PT1H", Granularities.HOUR});
        }

        public TimeFloorToGranularityConversionTest(String periodString, Granularity expectedGranularity) {
            this.periodString = periodString;
            this.expectedGranularity = expectedGranularity;
        }

        @Test
        public void testGranularityFromTimeFloor() throws ParseException {
            SqlNodeList args = new SqlNodeList(SqlParserPos.ZERO);
            args.add((SqlNode)new SqlIdentifier("__time", SqlParserPos.ZERO));
            args.add((SqlNode)SqlLiteral.createCharString((String)this.periodString, (SqlParserPos)SqlParserPos.ZERO));
            SqlCall timeFloorCall = TimeFloorOperatorConversion.SQL_FUNCTION.createCall(args);
            Granularity actualGranularity = DruidSqlParserUtils.convertSqlNodeToGranularityThrowingParseExceptions((SqlNode)timeFloorCall);
            Assert.assertEquals((Object)this.expectedGranularity, (Object)actualGranularity);
        }
    }
}

