/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.external;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.tools.ValidationException;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.sql.calcite.external.ExternalTableScanRule;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.schema.DruidSchema;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.schema.NamedDruidSchema;
import org.apache.druid.sql.calcite.schema.NamedViewSchema;
import org.apache.druid.sql.calcite.schema.ViewSchema;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class ExternalTableScanRuleTest {
    @Test
    public void testMatchesWhenExternalScanUnsupported() throws ValidationException {
        PlannerContext plannerContext = PlannerContext.create((String)"DUMMY", (DruidOperatorTable)CalciteTests.createOperatorTable(), (ExprMacroTable)CalciteTests.createExprMacroTable(), (ObjectMapper)CalciteTests.getJsonMapper(), (PlannerConfig)new PlannerConfig(), (DruidSchemaCatalog)new DruidSchemaCatalog((SchemaPlus)EasyMock.createMock(SchemaPlus.class), (Map)ImmutableMap.of((Object)"druid", (Object)new NamedDruidSchema((DruidSchema)EasyMock.createMock(DruidSchema.class), "druid"), (Object)"view", (Object)new NamedViewSchema((ViewSchema)EasyMock.createMock(ViewSchema.class)))), (QueryContext)new QueryContext());
        plannerContext.setQueryMaker(CalciteTests.createMockQueryMakerFactory((QuerySegmentWalker)EasyMock.createMock(QuerySegmentWalker.class), (QueryRunnerFactoryConglomerate)EasyMock.createMock(QueryRunnerFactoryConglomerate.class)).buildForSelect((RelRoot)EasyMock.createMock(RelRoot.class), plannerContext));
        ExternalTableScanRule rule = new ExternalTableScanRule(plannerContext);
        rule.matches((RelOptRuleCall)EasyMock.createMock(RelOptRuleCall.class));
        Assert.assertEquals((Object)"SQL query requires scanning external datasources that is not suported.", (Object)plannerContext.getPlanningError());
    }
}

