/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.planner.DruidTypeSystem;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@RunWith(value=Enclosed.class)
public class OperatorConversionsTest {

    public static class DefaultOperandTypeCheckerTest {
        @Rule
        public ExpectedException expectedException = ExpectedException.none();

        @Test
        public void testGetOperandCountRange() {
            OperatorConversions.DefaultOperandTypeChecker typeChecker = new OperatorConversions.DefaultOperandTypeChecker((List)ImmutableList.of((Object)SqlTypeFamily.INTEGER, (Object)SqlTypeFamily.INTEGER, (Object)SqlTypeFamily.INTEGER), 2, (IntSet)IntSets.EMPTY_SET, null);
            SqlOperandCountRange countRange = typeChecker.getOperandCountRange();
            Assert.assertEquals((long)2L, (long)countRange.getMin());
            Assert.assertEquals((long)3L, (long)countRange.getMax());
        }

        @Test
        public void testIsOptional() {
            OperatorConversions.DefaultOperandTypeChecker typeChecker = new OperatorConversions.DefaultOperandTypeChecker((List)ImmutableList.of((Object)SqlTypeFamily.INTEGER, (Object)SqlTypeFamily.INTEGER, (Object)SqlTypeFamily.INTEGER), 2, (IntSet)IntSets.EMPTY_SET, null);
            Assert.assertFalse((boolean)typeChecker.isOptional(0));
            Assert.assertFalse((boolean)typeChecker.isOptional(1));
            Assert.assertTrue((boolean)typeChecker.isOptional(2));
        }

        @Test
        public void testAllowFullOperands() {
            SqlFunction function = OperatorConversions.operatorBuilder((String)"testAllowFullOperands").operandTypes(new SqlTypeFamily[]{SqlTypeFamily.INTEGER, SqlTypeFamily.DATE}).requiredOperands(1).returnTypeNonNull(SqlTypeName.CHAR).build();
            SqlOperandTypeChecker typeChecker = function.getOperandTypeChecker();
            Assert.assertTrue((boolean)typeChecker.checkOperandTypes(DefaultOperandTypeCheckerTest.mockCallBinding(function, (List<OperandSpec>)ImmutableList.of((Object)new OperandSpec(SqlTypeName.INTEGER, false), (Object)new OperandSpec(SqlTypeName.DATE, false))), true));
        }

        @Test
        public void testRequiredOperandsOnly() {
            SqlFunction function = OperatorConversions.operatorBuilder((String)"testRequiredOperandsOnly").operandTypes(new SqlTypeFamily[]{SqlTypeFamily.INTEGER, SqlTypeFamily.DATE}).requiredOperands(1).returnTypeNonNull(SqlTypeName.CHAR).build();
            SqlOperandTypeChecker typeChecker = function.getOperandTypeChecker();
            Assert.assertTrue((boolean)typeChecker.checkOperandTypes(DefaultOperandTypeCheckerTest.mockCallBinding(function, (List<OperandSpec>)ImmutableList.of((Object)new OperandSpec(SqlTypeName.INTEGER, false))), true));
        }

        @Test
        public void testLiteralOperandCheckLiteral() {
            SqlFunction function = OperatorConversions.operatorBuilder((String)"testLiteralOperandCheckLiteral").operandTypes(new SqlTypeFamily[]{SqlTypeFamily.INTEGER}).requiredOperands(1).literalOperands(new int[]{0}).returnTypeNonNull(SqlTypeName.CHAR).build();
            SqlOperandTypeChecker typeChecker = function.getOperandTypeChecker();
            Assert.assertFalse((boolean)typeChecker.checkOperandTypes(DefaultOperandTypeCheckerTest.mockCallBinding(function, (List<OperandSpec>)ImmutableList.of((Object)new OperandSpec(SqlTypeName.INTEGER, false))), false));
        }

        @Test
        public void testLiteralOperandCheckLiteralThrow() {
            SqlFunction function = OperatorConversions.operatorBuilder((String)"testLiteralOperandCheckLiteralThrow").operandTypes(new SqlTypeFamily[]{SqlTypeFamily.INTEGER}).requiredOperands(1).literalOperands(new int[]{0}).returnTypeNonNull(SqlTypeName.CHAR).build();
            SqlOperandTypeChecker typeChecker = function.getOperandTypeChecker();
            this.expectedException.expect(CalciteContextException.class);
            this.expectedException.expectMessage("Argument to function 'testLiteralOperandCheckLiteralThrow' must be a literal");
            typeChecker.checkOperandTypes(DefaultOperandTypeCheckerTest.mockCallBinding(function, (List<OperandSpec>)ImmutableList.of((Object)new OperandSpec(SqlTypeName.INTEGER, false))), true);
        }

        @Test
        public void testAnyTypeOperand() {
            SqlFunction function = OperatorConversions.operatorBuilder((String)"testAnyTypeOperand").operandTypes(new SqlTypeFamily[]{SqlTypeFamily.ANY}).requiredOperands(1).returnTypeNonNull(SqlTypeName.CHAR).build();
            SqlOperandTypeChecker typeChecker = function.getOperandTypeChecker();
            Assert.assertTrue((boolean)typeChecker.checkOperandTypes(DefaultOperandTypeCheckerTest.mockCallBinding(function, (List<OperandSpec>)ImmutableList.of((Object)new OperandSpec(SqlTypeName.DISTINCT, false))), true));
        }

        @Test
        public void testCastableFromDateTimestampToDatetimeFamily() {
            SqlFunction function = OperatorConversions.operatorBuilder((String)"testCastableFromDatetimeFamilyToTimestamp").operandTypes(new SqlTypeFamily[]{SqlTypeFamily.DATETIME}).requiredOperands(1).returnTypeNonNull(SqlTypeName.CHAR).build();
            SqlOperandTypeChecker typeChecker = function.getOperandTypeChecker();
            Assert.assertTrue((boolean)typeChecker.checkOperandTypes(DefaultOperandTypeCheckerTest.mockCallBinding(function, (List<OperandSpec>)ImmutableList.of((Object)new OperandSpec(SqlTypeName.DATE, false))), true));
            Assert.assertTrue((boolean)typeChecker.checkOperandTypes(DefaultOperandTypeCheckerTest.mockCallBinding(function, (List<OperandSpec>)ImmutableList.of((Object)new OperandSpec(SqlTypeName.TIMESTAMP, false))), true));
        }

        @Test
        public void testNullForNullableOperand() {
            SqlFunction function = OperatorConversions.operatorBuilder((String)"testNullForNullableOperand").operandTypes(new SqlTypeFamily[]{SqlTypeFamily.CHARACTER, SqlTypeFamily.INTERVAL_DAY_TIME}).requiredOperands(1).returnTypeNonNull(SqlTypeName.CHAR).build();
            SqlOperandTypeChecker typeChecker = function.getOperandTypeChecker();
            Assert.assertTrue((boolean)typeChecker.checkOperandTypes(DefaultOperandTypeCheckerTest.mockCallBinding(function, (List<OperandSpec>)ImmutableList.of((Object)new OperandSpec(SqlTypeName.VARCHAR, false), (Object)new OperandSpec(SqlTypeName.NULL, false))), true));
        }

        @Test
        public void testNullLiteralForNullableOperand() {
            SqlFunction function = OperatorConversions.operatorBuilder((String)"testNullLiteralForNullableOperand").operandTypes(new SqlTypeFamily[]{SqlTypeFamily.CHARACTER, SqlTypeFamily.INTERVAL_DAY_TIME}).requiredOperands(1).returnTypeNonNull(SqlTypeName.CHAR).build();
            SqlOperandTypeChecker typeChecker = function.getOperandTypeChecker();
            Assert.assertTrue((boolean)typeChecker.checkOperandTypes(DefaultOperandTypeCheckerTest.mockCallBinding(function, (List<OperandSpec>)ImmutableList.of((Object)new OperandSpec(SqlTypeName.VARCHAR, false), (Object)new OperandSpec(SqlTypeName.NULL, true))), true));
        }

        @Test
        public void testNullForNullableOperandNonNullOutput() {
            SqlFunction function = OperatorConversions.operatorBuilder((String)"testNullForNullableNonnull").operandTypes(new SqlTypeFamily[]{SqlTypeFamily.CHARACTER}).requiredOperands(1).returnTypeNonNull(SqlTypeName.CHAR).build();
            SqlOperandTypeChecker typeChecker = function.getOperandTypeChecker();
            SqlCallBinding binding = DefaultOperandTypeCheckerTest.mockCallBinding(function, (List<OperandSpec>)ImmutableList.of((Object)new OperandSpec(SqlTypeName.CHAR, false, true)));
            Assert.assertTrue((boolean)typeChecker.checkOperandTypes(binding, true));
            RelDataType returnType = function.getReturnTypeInference().inferReturnType((SqlOperatorBinding)binding);
            Assert.assertFalse((boolean)returnType.isNullable());
        }

        @Test
        public void testNullForNullableOperandCascadeNullOutput() {
            SqlFunction function = OperatorConversions.operatorBuilder((String)"testNullForNullableCascade").operandTypes(new SqlTypeFamily[]{SqlTypeFamily.CHARACTER}).requiredOperands(1).returnTypeCascadeNullable(SqlTypeName.CHAR).build();
            SqlOperandTypeChecker typeChecker = function.getOperandTypeChecker();
            SqlCallBinding binding = DefaultOperandTypeCheckerTest.mockCallBinding(function, (List<OperandSpec>)ImmutableList.of((Object)new OperandSpec(SqlTypeName.CHAR, false, true)));
            Assert.assertTrue((boolean)typeChecker.checkOperandTypes(binding, true));
            RelDataType returnType = function.getReturnTypeInference().inferReturnType((SqlOperatorBinding)binding);
            Assert.assertTrue((boolean)returnType.isNullable());
        }

        @Test
        public void testNullForNullableOperandAlwaysNullableOutput() {
            SqlFunction function = OperatorConversions.operatorBuilder((String)"testNullForNullableNonnull").operandTypes(new SqlTypeFamily[]{SqlTypeFamily.CHARACTER}).requiredOperands(1).returnTypeNullable(SqlTypeName.CHAR).build();
            SqlOperandTypeChecker typeChecker = function.getOperandTypeChecker();
            SqlCallBinding binding = DefaultOperandTypeCheckerTest.mockCallBinding(function, (List<OperandSpec>)ImmutableList.of((Object)new OperandSpec(SqlTypeName.CHAR, false, false)));
            Assert.assertTrue((boolean)typeChecker.checkOperandTypes(binding, true));
            RelDataType returnType = function.getReturnTypeInference().inferReturnType((SqlOperatorBinding)binding);
            Assert.assertTrue((boolean)returnType.isNullable());
        }

        @Test
        public void testNullForNonNullableOperand() {
            SqlFunction function = OperatorConversions.operatorBuilder((String)"testNullForNonNullableOperand").operandTypes(new SqlTypeFamily[]{SqlTypeFamily.CHARACTER, SqlTypeFamily.INTERVAL_DAY_TIME}).requiredOperands(1).returnTypeNonNull(SqlTypeName.CHAR).build();
            SqlOperandTypeChecker typeChecker = function.getOperandTypeChecker();
            this.expectedException.expect(CalciteContextException.class);
            this.expectedException.expectMessage("Exception in test for operator[testNullForNonNullableOperand]: Illegal use of 'NULL'");
            typeChecker.checkOperandTypes(DefaultOperandTypeCheckerTest.mockCallBinding(function, (List<OperandSpec>)ImmutableList.of((Object)new OperandSpec(SqlTypeName.NULL, false), (Object)new OperandSpec(SqlTypeName.INTERVAL_HOUR, false))), true);
        }

        @Test
        public void testNullLiteralForNonNullableOperand() {
            SqlFunction function = OperatorConversions.operatorBuilder((String)"testNullLiteralForNonNullableOperand").operandTypes(new SqlTypeFamily[]{SqlTypeFamily.CHARACTER, SqlTypeFamily.INTERVAL_DAY_TIME}).requiredOperands(1).returnTypeNonNull(SqlTypeName.CHAR).build();
            SqlOperandTypeChecker typeChecker = function.getOperandTypeChecker();
            this.expectedException.expect(CalciteContextException.class);
            this.expectedException.expectMessage("Exception in test for operator[testNullLiteralForNonNullableOperand]: Illegal use of 'NULL'");
            typeChecker.checkOperandTypes(DefaultOperandTypeCheckerTest.mockCallBinding(function, (List<OperandSpec>)ImmutableList.of((Object)new OperandSpec(SqlTypeName.NULL, true), (Object)new OperandSpec(SqlTypeName.INTERVAL_HOUR, false))), true);
        }

        @Test
        public void testNonCastableType() {
            SqlFunction function = OperatorConversions.operatorBuilder((String)"testNonCastableType").operandTypes(new SqlTypeFamily[]{SqlTypeFamily.CURSOR, SqlTypeFamily.INTERVAL_DAY_TIME}).requiredOperands(2).returnTypeNonNull(SqlTypeName.CHAR).build();
            SqlOperandTypeChecker typeChecker = function.getOperandTypeChecker();
            this.expectedException.expect(CalciteContextException.class);
            this.expectedException.expectMessage("Exception in test for operator[testNonCastableType]: Cannot apply 'testNonCastableType' to arguments of type");
            typeChecker.checkOperandTypes(DefaultOperandTypeCheckerTest.mockCallBinding(function, (List<OperandSpec>)ImmutableList.of((Object)new OperandSpec(SqlTypeName.INTEGER, true), (Object)new OperandSpec(SqlTypeName.INTERVAL_HOUR, false))), true);
        }

        private static SqlCallBinding mockCallBinding(SqlFunction function, List<OperandSpec> actualOperands) {
            SqlValidator validator = (SqlValidator)Mockito.mock(SqlValidator.class);
            Mockito.when((Object)validator.getTypeFactory()).thenReturn((Object)new SqlTypeFactoryImpl((RelDataTypeSystem)DruidTypeSystem.INSTANCE));
            ArrayList<SqlNode> operands = new ArrayList<SqlNode>(actualOperands.size());
            for (OperandSpec operand : actualOperands) {
                SqlNode node = operand.isLiteral ? (SqlNode)Mockito.mock(SqlLiteral.class) : (SqlNode)Mockito.mock(SqlNode.class);
                RelDataType relDataType = (RelDataType)Mockito.mock(RelDataType.class);
                if (operand.isNullable) {
                    Mockito.when((Object)relDataType.isNullable()).thenReturn((Object)true);
                } else {
                    Mockito.when((Object)relDataType.isNullable()).thenReturn((Object)false);
                }
                Mockito.when((Object)validator.deriveType((SqlValidatorScope)ArgumentMatchers.any(), (SqlNode)ArgumentMatchers.eq((Object)node))).thenReturn((Object)relDataType);
                Mockito.when((Object)relDataType.getSqlTypeName()).thenReturn((Object)operand.type);
                operands.add(node);
            }
            SqlParserPos pos = (SqlParserPos)Mockito.mock(SqlParserPos.class);
            Mockito.when((Object)pos.plusAll((Collection)ArgumentMatchers.any(Collection.class))).thenReturn((Object)pos);
            SqlCallBinding callBinding = new SqlCallBinding(validator, (SqlValidatorScope)Mockito.mock(SqlValidatorScope.class), function.createCall(pos, operands));
            Mockito.when((Object)validator.newValidationError((SqlNode)ArgumentMatchers.any(), (Resources.ExInst)ArgumentMatchers.any())).thenAnswer(invocationOnMock -> new CalciteContextException(StringUtils.format((String)"Exception in test for operator[%s]", (Object[])new Object[]{function.getName()}), (Throwable)((Resources.ExInst)invocationOnMock.getArgument(1, Resources.ExInst.class)).ex()));
            return callBinding;
        }

        private static class OperandSpec {
            private final SqlTypeName type;
            private final boolean isLiteral;
            private final boolean isNullable;

            private OperandSpec(SqlTypeName type, boolean isLiteral) {
                this(type, isLiteral, type == SqlTypeName.NULL);
            }

            private OperandSpec(SqlTypeName type, boolean isLiteral, boolean isNullable) {
                this.type = type;
                this.isLiteral = isLiteral;
                this.isNullable = isNullable;
            }
        }
    }
}

