/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rex.RexNode;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.ExpressionTestBase;
import org.apache.druid.sql.calcite.expression.ExpressionTestHelper;
import org.apache.druid.sql.calcite.expression.builtin.IPv4AddressStringifyOperatorConversion;
import org.junit.Before;
import org.junit.Test;

public class IPv4AddressStringifyExpressionTest
extends ExpressionTestBase {
    private static final long VALID = 3232235521L;
    private static final String EXPECTED = "192.168.0.1";
    private static final Object IGNORE_EXPECTED_RESULT = null;
    private static final String NULL = null;
    private static final String VAR = "f";
    private static final RowSignature ROW_SIGNATURE = RowSignature.builder().add("f", ColumnType.FLOAT).build();
    private static final Map<String, Object> BINDINGS = ImmutableMap.of((Object)"f", (Object)3.14);
    private IPv4AddressStringifyOperatorConversion target;
    private ExpressionTestHelper testHelper;

    @Before
    public void setUp() {
        this.target = new IPv4AddressStringifyOperatorConversion();
        this.testHelper = new ExpressionTestHelper(ROW_SIGNATURE, BINDINGS);
    }

    @Test
    public void testTooFewArgs() {
        this.expectException(IllegalArgumentException.class, "must have 1 argument");
        this.testExpression(Collections.emptyList(), this.buildExpectedExpression(new Object[0]), IGNORE_EXPECTED_RESULT);
    }

    @Test
    public void testTooManyArgs() {
        this.expectException(IllegalArgumentException.class, "must have 1 argument");
        this.testExpression(Arrays.asList(this.testHelper.makeLiteral(3232235521L), this.testHelper.makeLiteral(3232235521L)), this.buildExpectedExpression(3232235521L, 3232235521L), IGNORE_EXPECTED_RESULT);
    }

    @Test
    public void testNullArg() {
        this.testExpression(this.testHelper.getConstantNull(), this.buildExpectedExpression(new Object[]{null}), (Object)NULL);
    }

    @Test
    public void testInvalidArgType() {
        String variableNameWithInvalidType = VAR;
        this.testExpression(this.testHelper.makeInputRef(variableNameWithInvalidType), this.buildExpectedExpression(this.testHelper.makeVariable(variableNameWithInvalidType)), (Object)NULL);
    }

    @Test
    public void testInvalidIntegerArgTooLow() {
        long tooLow = -1L;
        this.testExpression(this.testHelper.makeLiteral(tooLow), this.buildExpectedExpression(tooLow), (Object)NULL);
    }

    @Test
    public void testValidIntegerArgLowest() {
        long lowest = 0L;
        this.testExpression(this.testHelper.makeLiteral(lowest), this.buildExpectedExpression(lowest), (Object)"0.0.0.0");
    }

    @Test
    public void testValidIntegerArgHighest() {
        long highest = 0xFFFFFFFFL;
        this.testExpression(this.testHelper.makeLiteral(highest), this.buildExpectedExpression(highest), (Object)"255.255.255.255");
    }

    @Test
    public void testInvalidIntegerArgTooHigh() {
        long tooHigh = 0x100000000L;
        this.testExpression(this.testHelper.makeLiteral(tooHigh), this.buildExpectedExpression(tooHigh), (Object)NULL);
    }

    @Test
    public void testValidIntegerArg() {
        this.testExpression(this.testHelper.makeLiteral(3232235521L), this.buildExpectedExpression(3232235521L), (Object)EXPECTED);
    }

    @Test
    public void testInvalidStringArgNotIPAddress() {
        String notIpAddress = "druid.apache.org";
        this.testExpression((RexNode)this.testHelper.makeLiteral(notIpAddress), this.buildExpectedExpression(notIpAddress), (Object)NULL);
    }

    @Test
    public void testInvalidStringArgIPv6Compatible() {
        String ipv6Compatible = "::192.168.0.1";
        this.testExpression((RexNode)this.testHelper.makeLiteral(ipv6Compatible), this.buildExpectedExpression(ipv6Compatible), (Object)NULL);
    }

    @Test
    public void testValidStringArgIPv6Mapped() {
        String ipv6Mapped = "::ffff:192.168.0.1";
        this.testExpression((RexNode)this.testHelper.makeLiteral(ipv6Mapped), this.buildExpectedExpression(ipv6Mapped), (Object)NULL);
    }

    @Test
    public void testValidStringArgIPv4() {
        this.testExpression((RexNode)this.testHelper.makeLiteral(EXPECTED), this.buildExpectedExpression(EXPECTED), (Object)EXPECTED);
    }

    @Test
    public void testValidStringArgUnsignedInt() {
        String unsignedInt = "3232235521";
        this.testExpression((RexNode)this.testHelper.makeLiteral(unsignedInt), this.buildExpectedExpression(unsignedInt), (Object)NULL);
    }

    private void testExpression(RexNode expr, DruidExpression expectedExpression, Object expectedResult) {
        this.testExpression(Collections.singletonList(expr), expectedExpression, expectedResult);
    }

    private void testExpression(List<? extends RexNode> exprs, DruidExpression expectedExpression, Object expectedResult) {
        this.testHelper.testExpressionString(this.target.calciteOperator(), exprs, expectedExpression, expectedResult);
    }

    private DruidExpression buildExpectedExpression(Object ... args) {
        return this.testHelper.buildExpectedExpression(this.target.getDruidFunctionName(), args);
    }
}

