/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.ExpressionTestBase;
import org.apache.druid.sql.calcite.expression.ExpressionTestHelper;
import org.apache.druid.sql.calcite.expression.builtin.GreatestOperatorConversion;
import org.junit.Before;
import org.junit.Test;

public class GreatestExpressionTest
extends ExpressionTestBase {
    private static final String DOUBLE_KEY = "d";
    private static final double DOUBLE_VALUE = 3.1;
    private static final String LONG_KEY = "l";
    private static final long LONG_VALUE = 2L;
    private static final String STRING_KEY = "s";
    private static final String STRING_VALUE = "foo";
    private static final RowSignature ROW_SIGNATURE = RowSignature.builder().add("d", ColumnType.DOUBLE).add("l", ColumnType.LONG).add("s", ColumnType.STRING).build();
    private static final Map<String, Object> BINDINGS = ImmutableMap.of((Object)"d", (Object)3.1, (Object)"l", (Object)2L, (Object)"s", (Object)"foo");
    private GreatestOperatorConversion target;
    private ExpressionTestHelper testHelper;

    @Before
    public void setUp() {
        this.target = new GreatestOperatorConversion();
        this.testHelper = new ExpressionTestHelper(ROW_SIGNATURE, BINDINGS);
    }

    @Test
    public void testNoArgs() {
        this.testExpression(Collections.emptyList(), this.buildExpectedExpression(new Object[0]), null);
    }

    @Test
    public void testAllNull() {
        this.testExpression(Arrays.asList(this.testHelper.getConstantNull(), this.testHelper.getConstantNull()), this.buildExpectedExpression(null, null), null);
    }

    @Test
    public void testSomeNull() {
        this.testExpression(Arrays.asList(this.testHelper.makeInputRef(DOUBLE_KEY), this.testHelper.getConstantNull(), this.testHelper.makeInputRef(STRING_KEY)), this.buildExpectedExpression(this.testHelper.makeVariable(DOUBLE_KEY), null, this.testHelper.makeVariable(STRING_KEY)), STRING_VALUE);
    }

    @Test
    public void testAllDouble() {
        this.testExpression(Arrays.asList(this.testHelper.makeLiteral(34.1), this.testHelper.makeInputRef(DOUBLE_KEY), this.testHelper.makeLiteral(5.2), this.testHelper.makeLiteral(767.3)), this.buildExpectedExpression(34.1, this.testHelper.makeVariable(DOUBLE_KEY), 5.2, 767.3), 767.3);
    }

    @Test
    public void testAllLong() {
        this.testExpression(Arrays.asList(this.testHelper.makeInputRef(LONG_KEY), this.testHelper.makeLiteral(0)), this.buildExpectedExpression(this.testHelper.makeVariable(LONG_KEY), 0), 2L);
    }

    @Test
    public void testAllString() {
        this.testExpression(Arrays.asList(this.testHelper.makeLiteral("B"), this.testHelper.makeInputRef(STRING_KEY), this.testHelper.makeLiteral("A")), this.buildExpectedExpression("B", this.testHelper.makeVariable(STRING_KEY), "A"), STRING_VALUE);
    }

    @Test
    public void testCoerceString() {
        this.testExpression(Arrays.asList(this.testHelper.makeLiteral(-1), this.testHelper.makeInputRef(DOUBLE_KEY), this.testHelper.makeLiteral("A")), this.buildExpectedExpression(-1, this.testHelper.makeVariable(DOUBLE_KEY), "A"), "A");
    }

    @Test
    public void testCoerceDouble() {
        this.testExpression(Arrays.asList(this.testHelper.makeLiteral(-1), this.testHelper.makeInputRef(DOUBLE_KEY)), this.buildExpectedExpression(-1, this.testHelper.makeVariable(DOUBLE_KEY)), 3.1);
    }

    @Test
    public void testDecimal() {
        this.testExpression(Arrays.asList(this.testHelper.makeLiteral(BigDecimal.valueOf(1.2)), this.testHelper.makeLiteral(BigDecimal.valueOf(3.4))), this.buildExpectedExpression(1.2, 3.4), 3.4);
    }

    @Test
    public void testDecimalWithNullShouldReturnString() {
        this.testExpression(Arrays.asList(this.testHelper.makeLiteral(BigDecimal.valueOf(1.2)), this.testHelper.getConstantNull(), this.testHelper.makeLiteral(BigDecimal.valueOf(3.4))), this.buildExpectedExpression(1.2, null, 3.4), "3.4");
    }

    @Test
    public void testTimestamp() {
        this.testExpression(Arrays.asList(this.testHelper.makeLiteral(DateTimes.utc((long)1000L)), this.testHelper.makeLiteral(DateTimes.utc((long)2000L))), this.buildExpectedExpression(1000, 2000), 2000L);
    }

    @Test
    public void testInvalidType() {
        this.expectException(IllegalArgumentException.class, "Argument 0 has invalid type: INTERVAL_YEAR_MONTH");
        this.testExpression(Collections.singletonList(this.testHelper.makeLiteral(new BigDecimal(13), new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, SqlParserPos.ZERO))), null, null);
    }

    private void testExpression(List<? extends RexNode> exprs, DruidExpression expectedExpression, Object expectedResult) {
        this.testHelper.testExpressionString(this.target.calciteOperator(), exprs, expectedExpression, expectedResult);
    }

    private DruidExpression buildExpectedExpression(Object ... args) {
        return this.testHelper.buildExpectedExpression(this.target.getDruidFunctionName(), args);
    }
}

