/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.RowAdapters;
import org.apache.druid.segment.RowBasedColumnSelectorFactory;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.virtual.VirtualizedColumnSelectorFactory;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;
import org.apache.druid.sql.calcite.schema.DruidSchema;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.schema.NamedDruidSchema;
import org.apache.druid.sql.calcite.schema.NamedViewSchema;
import org.apache.druid.sql.calcite.schema.ViewSchema;
import org.apache.druid.sql.calcite.table.RowSignatures;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;

class ExpressionTestHelper {
    private static final PlannerContext PLANNER_CONTEXT = PlannerContext.create((String)"SELECT 1", (DruidOperatorTable)CalciteTests.createOperatorTable(), (ExprMacroTable)CalciteTests.createExprMacroTable(), (ObjectMapper)CalciteTests.getJsonMapper(), (PlannerConfig)new PlannerConfig(), (DruidSchemaCatalog)new DruidSchemaCatalog((SchemaPlus)EasyMock.createMock(SchemaPlus.class), (Map)ImmutableMap.of((Object)"druid", (Object)new NamedDruidSchema((DruidSchema)EasyMock.createMock(DruidSchema.class), "druid"), (Object)"view", (Object)new NamedViewSchema((ViewSchema)EasyMock.createMock(ViewSchema.class)))), (QueryContext)new QueryContext());
    private final RowSignature rowSignature;
    private final Map<String, Object> bindings;
    private final RelDataTypeFactory typeFactory;
    private final RexBuilder rexBuilder;
    private final RelDataType relDataType;

    ExpressionTestHelper(RowSignature rowSignature, Map<String, Object> bindings) {
        this.rowSignature = rowSignature;
        this.bindings = bindings;
        this.typeFactory = new JavaTypeFactoryImpl();
        this.rexBuilder = new RexBuilder(this.typeFactory);
        this.relDataType = RowSignatures.toRelDataType((RowSignature)rowSignature, (RelDataTypeFactory)this.typeFactory);
    }

    RelDataType createSqlType(SqlTypeName sqlTypeName) {
        return this.typeFactory.createSqlType(sqlTypeName);
    }

    RexNode makeInputRef(String columnName) {
        int columnNumber = this.rowSignature.indexOf(columnName);
        return this.rexBuilder.makeInputRef(((RelDataTypeField)this.relDataType.getFieldList().get(columnNumber)).getType(), columnNumber);
    }

    RexNode getConstantNull() {
        return this.rexBuilder.constantNull();
    }

    RexLiteral makeFlag(Enum flag) {
        return this.rexBuilder.makeFlag(flag);
    }

    RexLiteral makeNullLiteral(SqlTypeName sqlTypeName) {
        return this.rexBuilder.makeNullLiteral(this.createSqlType(sqlTypeName));
    }

    RexLiteral makeLiteral(String s) {
        return this.rexBuilder.makeLiteral(s);
    }

    RexNode makeLiteral(DateTime timestamp) {
        return this.rexBuilder.makeTimestampLiteral(Calcites.jodaToCalciteTimestampString((DateTime)timestamp, (DateTimeZone)DateTimeZone.UTC), 0);
    }

    RexNode makeLiteral(Integer integer) {
        return this.rexBuilder.makeLiteral((Object)new BigDecimal(integer), this.createSqlType(SqlTypeName.INTEGER), true);
    }

    RexNode makeLiteral(Long bigint) {
        return this.rexBuilder.makeLiteral((Object)new BigDecimal(bigint), this.createSqlType(SqlTypeName.BIGINT), true);
    }

    RexNode makeLiteral(BigDecimal bigDecimal) {
        return this.rexBuilder.makeExactLiteral(bigDecimal);
    }

    RexNode makeLiteral(BigDecimal v, SqlIntervalQualifier intervalQualifier) {
        return this.rexBuilder.makeIntervalLiteral(v, intervalQualifier);
    }

    RexNode makeLiteral(Double d) {
        return this.rexBuilder.makeLiteral((Object)d, this.createSqlType(SqlTypeName.DOUBLE), true);
    }

    RexNode makeCall(SqlOperator op, RexNode ... exprs) {
        return this.rexBuilder.makeCall(op, exprs);
    }

    RexNode makeAbstractCast(RelDataType type, RexNode exp) {
        return this.rexBuilder.makeAbstractCast(type, exp);
    }

    Variable makeVariable(String name) {
        return new Variable(name);
    }

    DruidExpression buildExpectedExpression(String functionName, Object ... args) {
        String noDelimiter = "";
        String argsString = Arrays.stream(args).map(ExpressionTestHelper::quoteIfNeeded).collect(Collectors.joining(","));
        List<String> elements = Arrays.asList(functionName, "(", argsString, ")");
        return CalciteTestBase.makeExpression(String.join((CharSequence)noDelimiter, elements));
    }

    private static String quoteIfNeeded(@Nullable Object arg) {
        if (arg == null) {
            return "null";
        }
        if (arg instanceof String) {
            return "'" + arg + "'";
        }
        if (arg instanceof Boolean) {
            return (Boolean)arg != false ? "1" : "0";
        }
        return arg.toString();
    }

    void testExpression(SqlTypeName sqlTypeName, SqlOperator op, List<RexNode> exprs, DruidExpression expectedExpression, Object expectedResult) {
        RelDataType returnType = this.createSqlType(sqlTypeName);
        this.testExpression(this.rexBuilder.makeCall(returnType, op, exprs), expectedExpression, expectedResult);
    }

    void testExpression(SqlOperator op, RexNode expr, DruidExpression expectedExpression, Object expectedResult) {
        this.testExpression(op, Collections.singletonList(expr), expectedExpression, expectedResult);
    }

    void testExpression(SqlOperator op, List<? extends RexNode> exprs, DruidExpression expectedExpression, Object expectedResult) {
        this.testExpression(this.rexBuilder.makeCall(op, exprs), expectedExpression, expectedResult);
    }

    @Deprecated
    void testExpressionString(SqlOperator op, List<? extends RexNode> exprs, DruidExpression expectedExpression, Object expectedResult) {
        this.testExpression(this.rexBuilder.makeCall(op, exprs), expectedExpression, expectedResult, false);
    }

    void testExpression(RexNode rexNode, DruidExpression expectedExpression, Object expectedResult) {
        this.testExpression(rexNode, expectedExpression, expectedResult, true);
    }

    void testExpression(RexNode rexNode, DruidExpression expectedExpression, Object expectedResult, boolean deepCompare) {
        DruidExpression expression = Expressions.toDruidExpression((PlannerContext)PLANNER_CONTEXT, (RowSignature)this.rowSignature, (RexNode)rexNode);
        Assert.assertNotNull((Object)expression);
        if (deepCompare) {
            Assert.assertEquals((String)("Expression for: " + rexNode), (Object)expectedExpression, (Object)expression);
        } else {
            Assert.assertEquals((String)("Expression for: " + rexNode), (Object)expectedExpression.getExpression(), (Object)expression.getExpression());
        }
        ExprEval result = Parser.parse((String)expression.getExpression(), (ExprMacroTable)PLANNER_CONTEXT.getExprMacroTable()).eval(InputBindings.withMap(this.bindings));
        Assert.assertEquals((String)("Result for: " + rexNode), (Object)expectedResult, (Object)result.value());
    }

    void testFilter(SqlOperator op, List<? extends RexNode> exprs, List<VirtualColumn> expectedVirtualColumns, DimFilter expectedFilter, boolean expectedResult) {
        RexNode rexNode = this.rexBuilder.makeCall(op, exprs);
        VirtualColumnRegistry virtualColumnRegistry = VirtualColumnRegistry.create((RowSignature)this.rowSignature, (ExprMacroTable)TestExprMacroTable.INSTANCE);
        DimFilter filter = Expressions.toFilter((PlannerContext)PLANNER_CONTEXT, (RowSignature)this.rowSignature, (VirtualColumnRegistry)virtualColumnRegistry, (RexNode)rexNode);
        Assert.assertEquals((String)("Filter for: " + rexNode), (Object)expectedFilter, (Object)filter);
        List virtualColumns = filter.getRequiredColumns().stream().map(arg_0 -> ((VirtualColumnRegistry)virtualColumnRegistry).getVirtualColumn(arg_0)).filter(Objects::nonNull).sorted(Comparator.comparing(VirtualColumn::getOutputName)).collect(Collectors.toList());
        Assert.assertEquals((String)("Virtual columns for: " + rexNode), expectedVirtualColumns.stream().sorted(Comparator.comparing(VirtualColumn::getOutputName)).collect(Collectors.toList()), virtualColumns);
        ValueMatcher matcher = expectedFilter.toFilter().makeMatcher((ColumnSelectorFactory)new VirtualizedColumnSelectorFactory((ColumnSelectorFactory)RowBasedColumnSelectorFactory.create((RowAdapter)RowAdapters.standardRow(), () -> new MapBasedRow(0L, this.bindings), (ColumnInspector)this.rowSignature, (boolean)false), VirtualColumns.create(virtualColumns)));
        Assert.assertEquals((String)("Result for: " + rexNode), (Object)expectedResult, (Object)matcher.matches());
    }

    private static class Variable {
        private final String name;

        Variable(String name) {
            this.name = name;
        }

        public String toString() {
            return "\"" + this.name + "\"";
        }
    }
}

