/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.sql.calcite.TestInsertQueryMaker;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.run.NativeQueryMakerFactory;
import org.apache.druid.sql.calcite.run.QueryMaker;
import org.apache.druid.sql.calcite.run.QueryMakerFactory;
import org.apache.druid.sql.calcite.table.RowSignatures;

public class TestQueryMakerFactory
implements QueryMakerFactory {
    private final QueryLifecycleFactory queryLifecycleFactory;
    private final ObjectMapper jsonMapper;

    TestQueryMakerFactory(QueryLifecycleFactory queryLifecycleFactory, ObjectMapper jsonMapper) {
        this.queryLifecycleFactory = queryLifecycleFactory;
        this.jsonMapper = jsonMapper;
    }

    public QueryMaker buildForSelect(RelRoot relRoot, PlannerContext plannerContext) {
        return new NativeQueryMakerFactory(this.queryLifecycleFactory, this.jsonMapper).buildForSelect(relRoot, plannerContext);
    }

    public QueryMaker buildForInsert(String targetDataSource, RelRoot relRoot, PlannerContext plannerContext) {
        RowSignature signature = RowSignatures.fromRelDataType((List)relRoot.validatedRowType.getFieldNames(), (RelDataType)relRoot.validatedRowType);
        return new TestInsertQueryMaker(relRoot.rel.getCluster().getTypeFactory(), targetDataSource, signature);
    }
}

