/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.run.QueryFeature;
import org.apache.druid.sql.calcite.run.QueryMaker;

public class TestInsertQueryMaker
implements QueryMaker {
    private final RelDataType resultType;
    private final String targetDataSource;
    private final RowSignature signature;

    public TestInsertQueryMaker(RelDataTypeFactory typeFactory, String targetDataSource, RowSignature signature) {
        this.resultType = typeFactory.createStructType((List)ImmutableList.of((Object)typeFactory.createSqlType(SqlTypeName.VARCHAR), (Object)typeFactory.createSqlType(SqlTypeName.OTHER)), (List)ImmutableList.of((Object)"dataSource", (Object)"signature"));
        this.targetDataSource = targetDataSource;
        this.signature = signature;
    }

    public boolean feature(QueryFeature feature) {
        switch (feature) {
            case CAN_RUN_TIMESERIES: 
            case CAN_RUN_TOPN: {
                return false;
            }
            case CAN_READ_EXTERNAL_DATA: {
                return true;
            }
            case SCAN_CAN_ORDER_BY_NON_TIME: {
                return true;
            }
        }
        throw new IAE("Unrecognized feature: %s", new Object[]{feature});
    }

    public RelDataType getResultType() {
        return this.resultType;
    }

    public Sequence<Object[]> runQuery(DruidQuery druidQuery) {
        Hook.QUERY_PLAN.run((Object)druidQuery.getQuery());
        return Sequences.simple((Iterable)ImmutableList.of((Object)new Object[]{this.targetDataSource, this.signature}));
    }
}

