/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.junit.Assert;
import org.junit.Test;

public class DruidPlannerResourceAnalyzeTest
extends BaseCalciteQueryTest {
    @Test
    public void testTable() {
        String sql = "SELECT COUNT(*) FROM foo WHERE foo.dim1 <> 'z'";
        Set<ResourceAction> requiredResources = this.analyzeResources(PLANNER_CONFIG_DEFAULT, "SELECT COUNT(*) FROM foo WHERE foo.dim1 <> 'z'", CalciteTests.REGULAR_USER_AUTH_RESULT);
        Assert.assertEquals((Object)ImmutableSet.of((Object)new ResourceAction(new Resource("foo", "DATASOURCE"), Action.READ)), requiredResources);
    }

    @Test
    public void testConfusingTable() {
        String sql = "SELECT COUNT(*) FROM foo as druid WHERE druid.dim1 <> 'z'";
        Set<ResourceAction> requiredResources = this.analyzeResources(PLANNER_CONFIG_DEFAULT, "SELECT COUNT(*) FROM foo as druid WHERE druid.dim1 <> 'z'", CalciteTests.REGULAR_USER_AUTH_RESULT);
        Assert.assertEquals((Object)ImmutableSet.of((Object)new ResourceAction(new Resource("foo", "DATASOURCE"), Action.READ)), requiredResources);
    }

    @Test
    public void testSubquery() {
        String sql = "SELECT COUNT(*)\nFROM (\n  SELECT DISTINCT dim2\n  FROM druid.foo\n  WHERE SUBSTRING(dim2, 1, 1) IN (\n    SELECT SUBSTRING(dim1, 1, 1) FROM druid.numfoo WHERE dim1 IS NOT NULL\n  )\n)";
        Set<ResourceAction> requiredResources = this.analyzeResources(PLANNER_CONFIG_DEFAULT, "SELECT COUNT(*)\nFROM (\n  SELECT DISTINCT dim2\n  FROM druid.foo\n  WHERE SUBSTRING(dim2, 1, 1) IN (\n    SELECT SUBSTRING(dim1, 1, 1) FROM druid.numfoo WHERE dim1 IS NOT NULL\n  )\n)", CalciteTests.REGULAR_USER_AUTH_RESULT);
        Assert.assertEquals((Object)ImmutableSet.of((Object)new ResourceAction(new Resource("foo", "DATASOURCE"), Action.READ), (Object)new ResourceAction(new Resource("numfoo", "DATASOURCE"), Action.READ)), requiredResources);
    }

    @Test
    public void testSubqueryUnion() {
        String sql = "SELECT\n  SUM(cnt),\n  COUNT(*)\nFROM (\n  SELECT dim2, SUM(cnt) AS cnt\n  FROM (SELECT * FROM druid.foo UNION ALL SELECT * FROM druid.foo2)\n  GROUP BY dim2\n)";
        Set<ResourceAction> requiredResources = this.analyzeResources(PLANNER_CONFIG_DEFAULT, "SELECT\n  SUM(cnt),\n  COUNT(*)\nFROM (\n  SELECT dim2, SUM(cnt) AS cnt\n  FROM (SELECT * FROM druid.foo UNION ALL SELECT * FROM druid.foo2)\n  GROUP BY dim2\n)", CalciteTests.REGULAR_USER_AUTH_RESULT);
        Assert.assertEquals((Object)ImmutableSet.of((Object)new ResourceAction(new Resource("foo", "DATASOURCE"), Action.READ), (Object)new ResourceAction(new Resource("foo2", "DATASOURCE"), Action.READ)), requiredResources);
    }

    @Test
    public void testJoin() {
        String sql = "SELECT COUNT(*) FROM foo INNER JOIN numfoo ON foo.dim1 = numfoo.dim1 WHERE numfoo.dim1 <> 'z'";
        Set<ResourceAction> requiredResources = this.analyzeResources(PLANNER_CONFIG_DEFAULT, "SELECT COUNT(*) FROM foo INNER JOIN numfoo ON foo.dim1 = numfoo.dim1 WHERE numfoo.dim1 <> 'z'", CalciteTests.REGULAR_USER_AUTH_RESULT);
        Assert.assertEquals((Object)ImmutableSet.of((Object)new ResourceAction(new Resource("foo", "DATASOURCE"), Action.READ), (Object)new ResourceAction(new Resource("numfoo", "DATASOURCE"), Action.READ)), requiredResources);
    }

    @Test
    public void testView() {
        String sql = "SELECT COUNT(*) FROM view.aview as druid WHERE dim1_firstchar <> 'z'";
        Set<ResourceAction> requiredResources = this.analyzeResources(PLANNER_CONFIG_DEFAULT, "SELECT COUNT(*) FROM view.aview as druid WHERE dim1_firstchar <> 'z'", CalciteTests.REGULAR_USER_AUTH_RESULT);
        Assert.assertEquals((Object)ImmutableSet.of((Object)new ResourceAction(new Resource("aview", "VIEW"), Action.READ)), requiredResources);
    }

    @Test
    public void testSubqueryView() {
        String sql = "SELECT COUNT(*)\nFROM (\n  SELECT DISTINCT dim2\n  FROM druid.foo\n  WHERE SUBSTRING(dim2, 1, 1) IN (\n    SELECT SUBSTRING(dim1, 1, 1) FROM view.cview WHERE dim2 IS NOT NULL\n  )\n)";
        Set<ResourceAction> requiredResources = this.analyzeResources(PLANNER_CONFIG_DEFAULT, "SELECT COUNT(*)\nFROM (\n  SELECT DISTINCT dim2\n  FROM druid.foo\n  WHERE SUBSTRING(dim2, 1, 1) IN (\n    SELECT SUBSTRING(dim1, 1, 1) FROM view.cview WHERE dim2 IS NOT NULL\n  )\n)", CalciteTests.REGULAR_USER_AUTH_RESULT);
        Assert.assertEquals((Object)ImmutableSet.of((Object)new ResourceAction(new Resource("foo", "DATASOURCE"), Action.READ), (Object)new ResourceAction(new Resource("cview", "VIEW"), Action.READ)), requiredResources);
    }

    @Test
    public void testJoinView() {
        String sql = "SELECT COUNT(*) FROM view.cview as aview INNER JOIN numfoo ON aview.dim2 = numfoo.dim2 WHERE numfoo.dim1 <> 'z'";
        Set<ResourceAction> requiredResources = this.analyzeResources(PLANNER_CONFIG_DEFAULT, "SELECT COUNT(*) FROM view.cview as aview INNER JOIN numfoo ON aview.dim2 = numfoo.dim2 WHERE numfoo.dim1 <> 'z'", CalciteTests.REGULAR_USER_AUTH_RESULT);
        Assert.assertEquals((Object)ImmutableSet.of((Object)new ResourceAction(new Resource("cview", "VIEW"), Action.READ), (Object)new ResourceAction(new Resource("numfoo", "DATASOURCE"), Action.READ)), requiredResources);
    }

    @Test
    public void testConfusingViewIdentifiers() {
        String sql = "SELECT COUNT(*) FROM view.dview as druid WHERE druid.numfoo <> 'z'";
        Set<ResourceAction> requiredResources = this.analyzeResources(PLANNER_CONFIG_DEFAULT, "SELECT COUNT(*) FROM view.dview as druid WHERE druid.numfoo <> 'z'", CalciteTests.REGULAR_USER_AUTH_RESULT);
        Assert.assertEquals((Object)ImmutableSet.of((Object)new ResourceAction(new Resource("dview", "VIEW"), Action.READ)), requiredResources);
    }

    @Test
    public void testDynamicParameters() {
        String sql = "SELECT SUBSTRING(dim2, CAST(? as BIGINT), CAST(? as BIGINT)) FROM druid.foo LIMIT ?";
        Set<ResourceAction> requiredResources = this.analyzeResources(PLANNER_CONFIG_DEFAULT, "SELECT SUBSTRING(dim2, CAST(? as BIGINT), CAST(? as BIGINT)) FROM druid.foo LIMIT ?", CalciteTests.REGULAR_USER_AUTH_RESULT);
        Assert.assertEquals((Object)ImmutableSet.of((Object)new ResourceAction(new Resource("foo", "DATASOURCE"), Action.READ)), requiredResources);
    }

    @Test
    public void testSysTables() {
        this.testSysTable("SELECT * FROM sys.segments", null, PLANNER_CONFIG_DEFAULT);
        this.testSysTable("SELECT * FROM sys.servers", null, PLANNER_CONFIG_DEFAULT);
        this.testSysTable("SELECT * FROM sys.server_segments", null, PLANNER_CONFIG_DEFAULT);
        this.testSysTable("SELECT * FROM sys.tasks", null, PLANNER_CONFIG_DEFAULT);
        this.testSysTable("SELECT * FROM sys.supervisors", null, PLANNER_CONFIG_DEFAULT);
        this.testSysTable("SELECT * FROM sys.segments", "segments", PLANNER_CONFIG_AUTHORIZE_SYS_TABLES);
        this.testSysTable("SELECT * FROM sys.servers", "servers", PLANNER_CONFIG_AUTHORIZE_SYS_TABLES);
        this.testSysTable("SELECT * FROM sys.server_segments", "server_segments", PLANNER_CONFIG_AUTHORIZE_SYS_TABLES);
        this.testSysTable("SELECT * FROM sys.tasks", "tasks", PLANNER_CONFIG_AUTHORIZE_SYS_TABLES);
        this.testSysTable("SELECT * FROM sys.supervisors", "supervisors", PLANNER_CONFIG_AUTHORIZE_SYS_TABLES);
    }

    private void testSysTable(String sql, String name, PlannerConfig plannerConfig) {
        this.testSysTable(sql, name, (Map<String, Object>)ImmutableMap.of(), plannerConfig, new AuthConfig());
    }

    private void testSysTable(String sql, String name, Map<String, Object> context, PlannerConfig plannerConfig, AuthConfig authConfig) {
        Set<ResourceAction> requiredResources = this.analyzeResources(plannerConfig, authConfig, sql, context, CalciteTests.REGULAR_USER_AUTH_RESULT);
        HashSet<ResourceAction> expectedResources = new HashSet<ResourceAction>();
        if (name != null) {
            expectedResources.add(new ResourceAction(new Resource(name, "SYSTEM_TABLE"), Action.READ));
        }
        if (context != null && !context.isEmpty()) {
            context.forEach((k, v) -> expectedResources.add(new ResourceAction(new Resource(k, "QUERY_CONTEXT"), Action.WRITE)));
        }
        Assert.assertEquals(expectedResources, requiredResources);
    }

    @Test
    public void testSysTableWithQueryContext() {
        AuthConfig authConfig = AuthConfig.newBuilder().setAuthorizeQueryContextParams(true).build();
        ImmutableMap context = ImmutableMap.of((Object)"baz", (Object)"fo", (Object)"nested-bar", (Object)ImmutableMap.of((Object)"nested-key", (Object)"nested-val"));
        this.testSysTable("SELECT * FROM sys.segments", null, (Map<String, Object>)context, PLANNER_CONFIG_DEFAULT, authConfig);
        this.testSysTable("SELECT * FROM sys.servers", null, (Map<String, Object>)context, PLANNER_CONFIG_DEFAULT, authConfig);
        this.testSysTable("SELECT * FROM sys.server_segments", null, (Map<String, Object>)context, PLANNER_CONFIG_DEFAULT, authConfig);
        this.testSysTable("SELECT * FROM sys.tasks", null, (Map<String, Object>)context, PLANNER_CONFIG_DEFAULT, authConfig);
        this.testSysTable("SELECT * FROM sys.supervisors", null, (Map<String, Object>)context, PLANNER_CONFIG_DEFAULT, authConfig);
        this.testSysTable("SELECT * FROM sys.segments", "segments", (Map<String, Object>)context, PLANNER_CONFIG_AUTHORIZE_SYS_TABLES, authConfig);
        this.testSysTable("SELECT * FROM sys.servers", "servers", (Map<String, Object>)context, PLANNER_CONFIG_AUTHORIZE_SYS_TABLES, authConfig);
        this.testSysTable("SELECT * FROM sys.server_segments", "server_segments", (Map<String, Object>)context, PLANNER_CONFIG_AUTHORIZE_SYS_TABLES, authConfig);
        this.testSysTable("SELECT * FROM sys.tasks", "tasks", (Map<String, Object>)context, PLANNER_CONFIG_AUTHORIZE_SYS_TABLES, authConfig);
        this.testSysTable("SELECT * FROM sys.supervisors", "supervisors", (Map<String, Object>)context, PLANNER_CONFIG_AUTHORIZE_SYS_TABLES, authConfig);
    }

    @Test
    public void testQueryContext() {
        String sql = "SELECT COUNT(*) FROM foo WHERE foo.dim1 <> 'z'";
        Set<ResourceAction> requiredResources = this.analyzeResources(PLANNER_CONFIG_DEFAULT, AuthConfig.newBuilder().setAuthorizeQueryContextParams(true).build(), "SELECT COUNT(*) FROM foo WHERE foo.dim1 <> 'z'", (Map<String, Object>)ImmutableMap.of((Object)"baz", (Object)"fo", (Object)"nested-bar", (Object)ImmutableMap.of((Object)"nested-key", (Object)"nested-val")), CalciteTests.REGULAR_USER_AUTH_RESULT);
        Assert.assertEquals((Object)ImmutableSet.of((Object)new ResourceAction(new Resource("foo", "DATASOURCE"), Action.READ), (Object)new ResourceAction(new Resource("baz", "QUERY_CONTEXT"), Action.WRITE), (Object)new ResourceAction(new Resource("nested-bar", "QUERY_CONTEXT"), Action.WRITE)), requiredResources);
    }
}

