/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Query;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.LikeDimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.junit.Test;

public class CalciteSimpleQueryTest
extends BaseCalciteQueryTest {
    @Test
    public void testGroupByTimeAndDim() throws Exception {
        this.testQuery("SELECT FLOOR(__time TO MONTH), dim2, SUM(cnt)\nFROM druid.foo\nGROUP BY 1, 2", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSimpleQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteSimpleQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteSimpleQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("dim2", "d1")})).setAggregatorSpecs(CalciteSimpleQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d0", 0, Granularities.MONTH)).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{CalciteSimpleQueryTest.timestamp("2000-01-01"), "", 2L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2000-01-01"), "a", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), "", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), "a", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), "abc", 1L}) : ImmutableList.of((Object)new Object[]{CalciteSimpleQueryTest.timestamp("2000-01-01"), null, 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2000-01-01"), "", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2000-01-01"), "a", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), null, 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), "a", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), "abc", 1L})));
    }

    @Test
    public void testGroupByDimAndTime() throws Exception {
        this.testQuery("SELECT dim2, FLOOR(__time TO MONTH), SUM(cnt)\nFROM druid.foo\nGROUP BY 1, 2", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSimpleQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteSimpleQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteSimpleQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0"), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteSimpleQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"", CalciteSimpleQueryTest.timestamp("2000-01-01"), 2L}, (Object)new Object[]{"", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}) : ImmutableList.of((Object)new Object[]{null, CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{null, CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L})));
    }

    @Test
    public void testGroupByDimAndTimeWhereOnTime() throws Exception {
        this.testQuery("SELECT dim2, FLOOR(__time TO MONTH), SUM(cnt)\nFROM druid.foo\nWHERE FLOOR(__time TO MONTH) = TIMESTAMP '2001-01-01'\nGROUP BY 1, 2", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSimpleQueryTest.querySegmentSpec(Intervals.of((String)"2001-01-01/P1M"))).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteSimpleQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteSimpleQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0"), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteSimpleQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}) : ImmutableList.of((Object)new Object[]{null, CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L})));
    }

    @Test
    public void testGroupByDimAndTimeOnDim() throws Exception {
        this.testQuery("SELECT dim2, FLOOR(__time TO MONTH), SUM(cnt)\nFROM druid.foo\nWHERE dim2 LIKE 'a%'\nGROUP BY 1, 2", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSimpleQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteSimpleQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteSimpleQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0"), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG)})).setDimFilter((DimFilter)new LikeDimFilter("dim2", "a%", null, null)).setAggregatorSpecs(CalciteSimpleQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}) : ImmutableList.of((Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L})));
    }

    @Test
    public void testGroupByTimeAndDimOrderByDim() throws Exception {
        this.testQuery("SELECT FLOOR(__time TO MONTH), dim2, SUM(cnt)\nFROM druid.foo\nGROUP BY 1, 2\nORDER BY dim2", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSimpleQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteSimpleQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteSimpleQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("dim2", "d1")})).setAggregatorSpecs(CalciteSimpleQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.ASCENDING)), null)).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d0", 0, Granularities.MONTH)).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{CalciteSimpleQueryTest.timestamp("2000-01-01"), "", 2L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), "", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2000-01-01"), "a", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), "a", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), "abc", 1L}) : ImmutableList.of((Object)new Object[]{CalciteSimpleQueryTest.timestamp("2000-01-01"), null, 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), null, 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2000-01-01"), "", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2000-01-01"), "a", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), "a", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), "abc", 1L})));
    }

    @Test
    public void testGroupByTimeAndDimOrderByDimDesc() throws Exception {
        this.testQuery("SELECT FLOOR(__time TO MONTH), dim2, SUM(cnt)\nFROM druid.foo\nGROUP BY 1, 2\nORDER BY dim2 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSimpleQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteSimpleQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteSimpleQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("dim2", "d1")})).setAggregatorSpecs(CalciteSimpleQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.DESCENDING)), null)).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d0", 0, Granularities.MONTH)).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), "abc", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2000-01-01"), "a", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), "a", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2000-01-01"), "", 2L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), "", 1L}) : ImmutableList.of((Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), "abc", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2000-01-01"), "a", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), "a", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2000-01-01"), "", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2000-01-01"), null, 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), null, 1L})));
    }

    @Test
    public void testGroupByDimAndTimeOrderByTime() throws Exception {
        this.testQuery("SELECT dim2, FLOOR(__time TO MONTH), SUM(cnt)\nFROM druid.foo\nGROUP BY 1, 2\nORDER BY FLOOR(__time TO MONTH)", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSimpleQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteSimpleQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteSimpleQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0"), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteSimpleQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), null)).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"", CalciteSimpleQueryTest.timestamp("2000-01-01"), 2L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}) : ImmutableList.of((Object)new Object[]{null, CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{null, CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L})));
    }

    @Test
    public void testGroupByDimAndTimeOrderByTimeDesc() throws Exception {
        this.testQuery("SELECT dim2, FLOOR(__time TO MONTH), SUM(cnt)\nFROM druid.foo\nGROUP BY 1, 2\nORDER BY FLOOR(__time TO MONTH) DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSimpleQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteSimpleQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteSimpleQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0"), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteSimpleQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), null)).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"", CalciteSimpleQueryTest.timestamp("2000-01-01"), 2L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}) : ImmutableList.of((Object)new Object[]{null, CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{null, CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L})));
    }

    @Test
    public void testGroupByDimAndTimeOrderByTimeAndDim() throws Exception {
        this.testQuery("SELECT dim2, FLOOR(__time TO MONTH), SUM(cnt)\nFROM druid.foo\nGROUP BY 1, 2\nORDER BY FLOOR(__time TO MONTH), dim2 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSimpleQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteSimpleQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteSimpleQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0"), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteSimpleQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC), (Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.DESCENDING)), null)).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"", CalciteSimpleQueryTest.timestamp("2000-01-01"), 2L}, (Object)new Object[]{"abc", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}) : ImmutableList.of((Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{null, CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"abc", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{null, CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L})));
    }

    @Test
    public void testGroupByDimAndTimeOrderByDimAndTime() throws Exception {
        this.testQuery("SELECT dim2, FLOOR(__time TO MONTH), SUM(cnt)\nFROM druid.foo\nGROUP BY 1, 2\nORDER BY dim2, FLOOR(__time TO MONTH) DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSimpleQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteSimpleQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteSimpleQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0"), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteSimpleQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING), (Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), null)).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"", CalciteSimpleQueryTest.timestamp("2000-01-01"), 2L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"abc", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}) : ImmutableList.of((Object)new Object[]{null, CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{null, CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"abc", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L})));
    }

    @Test
    public void testGroupByDimAndTimeAndDimOrderByDimAndTimeDim() throws Exception {
        this.testQuery("SELECT dim2, FLOOR(__time TO MONTH), dim1, SUM(cnt)\nFROM druid.foo\nGROUP BY 1, 2, 3\nORDER BY dim2 DESC, FLOOR(__time TO MONTH) DESC, dim1", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSimpleQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteSimpleQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteSimpleQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0"), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG), new DefaultDimensionSpec("dim1", "d2")})).setAggregatorSpecs(CalciteSimpleQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.DESCENDING), (Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC), (Object)new OrderByColumnSpec("d2", OrderByColumnSpec.Direction.ASCENDING)), null)).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"abc", CalciteSimpleQueryTest.timestamp("2001-01-01"), "def", 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2001-01-01"), "1", 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2000-01-01"), "", 1L}, (Object)new Object[]{"", CalciteSimpleQueryTest.timestamp("2001-01-01"), "abc", 1L}, (Object)new Object[]{"", CalciteSimpleQueryTest.timestamp("2000-01-01"), "10.1", 1L}, (Object)new Object[]{"", CalciteSimpleQueryTest.timestamp("2000-01-01"), "2", 1L}) : ImmutableList.of((Object)new Object[]{"abc", CalciteSimpleQueryTest.timestamp("2001-01-01"), "def", 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2001-01-01"), "1", 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2000-01-01"), "", 1L}, (Object)new Object[]{"", CalciteSimpleQueryTest.timestamp("2000-01-01"), "2", 1L}, (Object)new Object[]{null, CalciteSimpleQueryTest.timestamp("2001-01-01"), "abc", 1L}, (Object)new Object[]{null, CalciteSimpleQueryTest.timestamp("2000-01-01"), "10.1", 1L})));
    }
}

