/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.SubstringDimExtractionFn;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.topn.DimensionTopNMetricSpec;
import org.apache.druid.query.topn.InvertedTopNMetricSpec;
import org.apache.druid.query.topn.TopNMetricSpec;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Test;

public class CalciteSelectQueryTest
extends BaseCalciteQueryTest {
    @Test
    public void testSelectConstantExpression() throws Exception {
        this.testQuery("SELECT REGEXP_EXTRACT('foo', '^(.)')", (List<Query>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{0L}), (RowSignature)RowSignature.builder().add("ZERO", ColumnType.LONG).build())).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "'f'", ColumnType.STRING, ExprMacroTable.nil())}).columns(new String[]{"v0"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false)).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"f"}));
    }

    @Test
    public void testExpressionContainingNull() throws Exception {
        this.testQuery("SELECT ARRAY ['Hello', NULL]", (List<Query>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{0L}), (RowSignature)RowSignature.builder().add("ZERO", ColumnType.LONG).build())).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "array('Hello',null)", ColumnType.STRING_ARRAY, ExprMacroTable.nil())}).columns(new String[]{"v0"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false)).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"Hello\",null]"}));
    }

    @Test
    public void testValuesContainingNull() throws Exception {
        this.testQuery("SELECT * FROM (VALUES (NULL, 'United States'))", (List<Query>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{null, "United States"}), (RowSignature)RowSignature.builder().add("EXPR$0", null).add("EXPR$1", ColumnType.STRING).build())).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0", "EXPR$1"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false)).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, "United States"}));
    }

    @Test
    public void testMultipleValuesContainingNull() throws Exception {
        this.testQuery("SELECT * FROM (VALUES (NULL, 'United States'), ('Delhi', 'India'))", (List<Query>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{null, "United States"}, (Object)new Object[]{"Delhi", "India"}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.STRING).build())).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0", "EXPR$1"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false)).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{NULL_STRING, "United States"}, (Object)new Object[]{"Delhi", "India"}));
    }

    @Test
    public void testMultipleValuesContainingNullAndIntegerValues() throws Exception {
        this.testQuery("SELECT * FROM (VALUES (NULL, 'United States'), (50, 'India'))", (List<Query>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{null, "United States"}, (Object)new Object[]{50L, "India"}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.LONG).add("EXPR$1", ColumnType.STRING).build())).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0", "EXPR$1"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false)).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, "United States"}, (Object)new Object[]{50, "India"}));
    }

    @Test
    public void testSelectNonNumericNumberLiterals() throws Exception {
        this.testQuery("SELECT CAST(1 / 0.0 AS BIGINT), CAST(1 / -0.0 AS BIGINT), CAST(-1 / 0.0 AS BIGINT), CAST(-1 / -0.0 AS BIGINT), CAST(0/ 0.0 AS BIGINT)", (List<Query>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{Long.MAX_VALUE, Long.MAX_VALUE, Long.MIN_VALUE, Long.MIN_VALUE, 0L}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.LONG).add("EXPR$1", ColumnType.LONG).add("EXPR$2", ColumnType.LONG).add("EXPR$3", ColumnType.LONG).add("EXPR$4", ColumnType.LONG).build())).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0", "EXPR$1", "EXPR$2", "EXPR$3", "EXPR$4"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Long.MAX_VALUE, Long.MAX_VALUE, Long.MIN_VALUE, Long.MIN_VALUE, 0L}));
    }

    @Test
    public void testDruidLogicalValuesRule() throws Exception {
        this.testQuery("SELECT FLOOR(123), CEIL(123), CAST(123.0 AS INTEGER)", (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{123L, 123L, 123L}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.LONG).add("EXPR$1", ColumnType.LONG).add("EXPR$2", ColumnType.LONG).build())).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.ETERNITY))).columns((List)ImmutableList.of((Object)"EXPR$0", (Object)"EXPR$1", (Object)"EXPR$2")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{123, 123, 123}));
    }

    @Test
    public void testSelectConstantExpressionFromTable() throws Exception {
        this.testQuery("SELECT 1 + 1, dim1 FROM foo LIMIT 1", (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteSelectQueryTest.expressionVirtualColumn("v0", "2", ColumnType.LONG)}).columns(new String[]{"dim1", "v0"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(1L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2, ""}));
    }

    @Test
    public void testSelectConstantExpressionEquivalentToNaN() throws Exception {
        this.expectedException.expectMessage("'(log10(0) - log10(0))' evaluates to 'NaN' that is not supported in SQL. You can either cast the expression as bigint ('cast((log10(0) - log10(0)) as bigint)') or char ('cast((log10(0) - log10(0)) as char)') or change the expression itself");
        this.testQuery("SELECT log10(0) - log10(0), dim1 FROM foo LIMIT 1", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testSelectConstantExpressionEquivalentToInfinity() throws Exception {
        this.expectedException.expectMessage("'log10(0)' evaluates to '-Infinity' that is not supported in SQL. You can either cast the expression as bigint ('cast(log10(0) as bigint)') or char ('cast(log10(0) as char)') or change the expression itself");
        this.testQuery("SELECT log10(0), dim1 FROM foo LIMIT 1", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testSelectTrimFamily() throws Exception {
        this.testQuery("SELECT\nTRIM(BOTH 'x' FROM 'xfoox'),\nTRIM(TRAILING 'x' FROM 'xfoox'),\nTRIM(' ' FROM ' foo '),\nTRIM(TRAILING FROM ' foo '),\nTRIM(' foo '),\nBTRIM(' foo '),\nBTRIM('xfoox', 'x'),\nLTRIM(' foo '),\nLTRIM('xfoox', 'x'),\nRTRIM(' foo '),\nRTRIM('xfoox', 'x'),\nCOUNT(*)\nFROM foo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteSelectQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).postAggregators(new PostAggregator[]{CalciteSelectQueryTest.expressionPostAgg("p0", "'foo'"), CalciteSelectQueryTest.expressionPostAgg("p1", "'xfoo'"), CalciteSelectQueryTest.expressionPostAgg("p2", "'foo'"), CalciteSelectQueryTest.expressionPostAgg("p3", "' foo'"), CalciteSelectQueryTest.expressionPostAgg("p4", "'foo'"), CalciteSelectQueryTest.expressionPostAgg("p5", "'foo'"), CalciteSelectQueryTest.expressionPostAgg("p6", "'foo'"), CalciteSelectQueryTest.expressionPostAgg("p7", "'foo '"), CalciteSelectQueryTest.expressionPostAgg("p8", "'foox'"), CalciteSelectQueryTest.expressionPostAgg("p9", "' foo'"), CalciteSelectQueryTest.expressionPostAgg("p10", "'xfoo'")}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"foo", "xfoo", "foo", " foo", "foo", "foo", "foo", "foo ", "foox", " foo", "xfoo", 6L}));
    }

    @Test
    public void testSelectPadFamily() throws Exception {
        this.testQuery("SELECT\nLPAD('foo', 5, 'x'),\nLPAD('foo', 2, 'x'),\nLPAD('foo', 5),\nRPAD('foo', 5, 'x'),\nRPAD('foo', 2, 'x'),\nRPAD('foo', 5),\nCOUNT(*)\nFROM foo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteSelectQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).postAggregators(new PostAggregator[]{CalciteSelectQueryTest.expressionPostAgg("p0", "'xxfoo'"), CalciteSelectQueryTest.expressionPostAgg("p1", "'fo'"), CalciteSelectQueryTest.expressionPostAgg("p2", "'  foo'"), CalciteSelectQueryTest.expressionPostAgg("p3", "'fooxx'"), CalciteSelectQueryTest.expressionPostAgg("p4", "'fo'"), CalciteSelectQueryTest.expressionPostAgg("p5", "'foo  '")}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xxfoo", "fo", "  foo", "fooxx", "fo", "foo  ", 6L}));
    }

    @Test
    public void testBitwiseExpressions() throws Exception {
        ImmutableList expected = this.useDefault ? ImmutableList.of((Object)new Object[]{0L, 7L, 7L, -8L, 28L, 1L, 0x3FF0000000000000L, 3.5E-323}, (Object)new Object[]{325323L, 325323L, 0L, -325324L, 1301292L, 81330L, 0x3FFB333333333333L, 1.60731E-318}, (Object)new Object[]{0L, 0L, 0L, -1L, 0L, 0L, 0L, 0.0}, (Object)new Object[]{0L, 0L, 0L, -1L, 0L, 0L, 0L, 0.0}, (Object)new Object[]{0L, 0L, 0L, -1L, 0L, 0L, 0L, 0.0}, (Object)new Object[]{0L, 0L, 0L, -1L, 0L, 0L, 0L, 0.0}) : ImmutableList.of((Object)new Object[]{null, null, null, -8L, 28L, 1L, 0x3FF0000000000000L, 3.5E-323}, (Object)new Object[]{325323L, 325323L, 0L, -325324L, 1301292L, 81330L, 0x3FFB333333333333L, 1.60731E-318}, (Object)new Object[]{0L, 0L, 0L, -1L, 0L, 0L, 0L, 0.0}, (Object)new Object[]{null, null, null, null, null, null, null, null}, (Object)new Object[]{null, null, null, null, null, null, null, null}, (Object)new Object[]{null, null, null, null, null, null, null, null});
        this.testQuery("SELECT\nBITWISE_AND(l1, l2),\nBITWISE_OR(l1, l2),\nBITWISE_XOR(l1, l2),\nBITWISE_COMPLEMENT(l1),\nBITWISE_SHIFT_LEFT(l1, 2),\nBITWISE_SHIFT_RIGHT(l1, 2),\nBITWISE_CONVERT_DOUBLE_TO_LONG_BITS(d1),\nBITWISE_CONVERT_LONG_BITS_TO_DOUBLE(l1)\nFROM numfoo", (List<Query>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7"}).virtualColumns(new VirtualColumn[]{CalciteSelectQueryTest.expressionVirtualColumn("v0", "bitwiseAnd(\"l1\",\"l2\")", ColumnType.LONG), CalciteSelectQueryTest.expressionVirtualColumn("v1", "bitwiseOr(\"l1\",\"l2\")", ColumnType.LONG), CalciteSelectQueryTest.expressionVirtualColumn("v2", "bitwiseXor(\"l1\",\"l2\")", ColumnType.LONG), CalciteSelectQueryTest.expressionVirtualColumn("v3", "bitwiseComplement(\"l1\")", ColumnType.LONG), CalciteSelectQueryTest.expressionVirtualColumn("v4", "bitwiseShiftLeft(\"l1\",2)", ColumnType.LONG), CalciteSelectQueryTest.expressionVirtualColumn("v5", "bitwiseShiftRight(\"l1\",2)", ColumnType.LONG), CalciteSelectQueryTest.expressionVirtualColumn("v6", "bitwiseConvertDoubleToLongBits(\"d1\")", ColumnType.LONG), CalciteSelectQueryTest.expressionVirtualColumn("v7", "bitwiseConvertLongBitsToDouble(\"l1\")", ColumnType.DOUBLE)}).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false)).build()), (List<Object[]>)expected);
    }

    @Test
    public void testSafeDivideExpressions() throws Exception {
        ImmutableList expected = this.useDefault ? ImmutableList.of((Object)new Object[]{Float.valueOf(0.0f), 0L, 0.0, Float.valueOf(7.0f)}, (Object)new Object[]{Float.valueOf(1.0f), 1L, 1.0, Float.valueOf(3253230.0f)}, (Object)new Object[]{Float.valueOf(0.0f), 0L, 0.0, Float.valueOf(0.0f)}, (Object)new Object[]{Float.valueOf(0.0f), 0L, 0.0, Float.valueOf(0.0f)}, (Object)new Object[]{Float.valueOf(0.0f), 0L, 0.0, Float.valueOf(0.0f)}, (Object)new Object[]{Float.valueOf(0.0f), 0L, 0.0, Float.valueOf(0.0f)}) : ImmutableList.of((Object)new Object[]{null, null, null, Float.valueOf(7.0f)}, (Object)new Object[]{Float.valueOf(1.0f), 1L, 1.0, Float.valueOf(3253230.0f)}, (Object)new Object[]{Float.valueOf(0.0f), 0L, 0.0, Float.valueOf(0.0f)}, (Object)new Object[]{null, null, null, null}, (Object)new Object[]{null, null, null, null}, (Object)new Object[]{null, null, null, null});
        this.testQuery("SELECT\nSAFE_DIVIDE(f1, f2),\nSAFE_DIVIDE(l1, l2),\nSAFE_DIVIDE(d2, d1),\nSAFE_DIVIDE(l1, f1)\nFROM numfoo", (List<Query>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"v0", "v1", "v2", "v3"}).virtualColumns(new VirtualColumn[]{CalciteSelectQueryTest.expressionVirtualColumn("v0", "safe_divide(\"f1\",\"f2\")", ColumnType.FLOAT), CalciteSelectQueryTest.expressionVirtualColumn("v1", "safe_divide(\"l1\",\"l2\")", ColumnType.LONG), CalciteSelectQueryTest.expressionVirtualColumn("v2", "safe_divide(\"d2\",\"d1\")", ColumnType.DOUBLE), CalciteSelectQueryTest.expressionVirtualColumn("v3", "safe_divide(\"l1\",\"f1\")", ColumnType.FLOAT)}).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false)).build()), (List<Object[]>)expected);
    }

    @Test
    public void testExplainSelectConstantExpression() throws Exception {
        this.skipVectorize();
        String query = "EXPLAIN PLAN FOR SELECT 1 + 1";
        String explanation = "[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"inline\",\"columnNames\":[\"EXPR$0\"],\"columnTypes\":[\"LONG\"],\"rows\":[[2]]},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"compactedList\",\"batchSize\":20480,\"filter\":null,\"columns\":[\"EXPR$0\"],\"legacy\":false,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false,\"granularity\":{\"type\":\"all\"}},\"signature\":[{\"name\":\"EXPR$0\",\"type\":\"LONG\"}]}]";
        String legacyExplanation = "DruidQueryRel(query=[{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"inline\",\"columnNames\":[\"EXPR$0\"],\"columnTypes\":[\"LONG\"],\"rows\":[[2]]},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"compactedList\",\"batchSize\":20480,\"filter\":null,\"columns\":[\"EXPR$0\"],\"legacy\":false,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false,\"granularity\":{\"type\":\"all\"}}], signature=[{EXPR$0:LONG}])\n";
        String resources = "[]";
        this.testQuery("EXPLAIN PLAN FOR SELECT 1 + 1", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"DruidQueryRel(query=[{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"inline\",\"columnNames\":[\"EXPR$0\"],\"columnTypes\":[\"LONG\"],\"rows\":[[2]]},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"compactedList\",\"batchSize\":20480,\"filter\":null,\"columns\":[\"EXPR$0\"],\"legacy\":false,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false,\"granularity\":{\"type\":\"all\"}}], signature=[{EXPR$0:LONG}])\n", "[]"}));
        this.testQuery(PLANNER_CONFIG_NATIVE_QUERY_EXPLAIN, "EXPLAIN PLAN FOR SELECT 1 + 1", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"inline\",\"columnNames\":[\"EXPR$0\"],\"columnTypes\":[\"LONG\"],\"rows\":[[2]]},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"compactedList\",\"batchSize\":20480,\"filter\":null,\"columns\":[\"EXPR$0\"],\"legacy\":false,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false,\"granularity\":{\"type\":\"all\"}},\"signature\":[{\"name\":\"EXPR$0\",\"type\":\"LONG\"}]}]", "[]"}));
    }

    @Test
    public void testSelectStarWithDimFilter() throws Exception {
        this.testQuery(PLANNER_CONFIG_DEFAULT_NO_COMPLEX_SERDE, QUERY_CONTEXT_DEFAULT, "SELECT * FROM druid.foo WHERE dim1 > 'd' OR dim2 = 'a'", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteSelectQueryTest.or(new DimFilter[]{CalciteSelectQueryTest.bound("dim1", "d", null, true, false, null, StringComparators.LEXICOGRAPHIC), CalciteSelectQueryTest.selector("dim2", "a", null)})).columns(new String[]{"__time", "cnt", "dim1", "dim2", "dim3", "m1", "m2", "unique_dim1"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-01"), 1L, "", "a", "[\"a\",\"b\"]", Float.valueOf(1.0f), 1.0, HLLC_STRING}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2001-01-01"), 1L, "1", "a", "", Float.valueOf(4.0f), 4.0, HLLC_STRING}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2001-01-02"), 1L, "def", "abc", NULL_STRING, Float.valueOf(5.0f), 5.0, HLLC_STRING}));
    }

    @Test
    public void testSelectDistinctWithCascadeExtractionFilter() throws Exception {
        this.testQuery("SELECT distinct dim1 FROM druid.foo WHERE substring(substring(dim1, 2), 1, 1) = 'e' OR dim2 = 'a'", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteSelectQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setDimFilter((DimFilter)CalciteSelectQueryTest.or(new DimFilter[]{CalciteSelectQueryTest.selector("dim1", "e", (ExtractionFn)CalciteSelectQueryTest.cascade(new ExtractionFn[]{new SubstringDimExtractionFn(1, null), new SubstringDimExtractionFn(0, Integer.valueOf(1))})), CalciteSelectQueryTest.selector("dim2", "a", null)})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{""}, (Object)new Object[]{"1"}, (Object)new Object[]{"def"}));
    }

    @Test
    public void testSelectDistinctWithStrlenFilter() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT distinct dim1 FROM druid.foo WHERE CHARACTER_LENGTH(dim1) = 3 OR CAST(CHARACTER_LENGTH(dim1) AS varchar) = 3", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteSelectQueryTest.expressionVirtualColumn("v0", "strlen(\"dim1\")", ColumnType.LONG), CalciteSelectQueryTest.expressionVirtualColumn("v1", "CAST(CAST(strlen(\"dim1\"), 'STRING'), 'LONG')", ColumnType.LONG)}).setDimensions(CalciteSelectQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setDimFilter((DimFilter)CalciteSelectQueryTest.or(new DimFilter[]{CalciteSelectQueryTest.selector("v0", "3", null), CalciteSelectQueryTest.selector("v1", "3", null)})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc"}, (Object)new Object[]{"def"}));
    }

    @Test
    public void testSelectDistinctWithLimit() throws Exception {
        this.testQuery("SELECT DISTINCT dim2 FROM druid.foo LIMIT 10", (List<Query>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim2", "d0")).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC)).threshold(10).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{""}, (Object)new Object[]{"a"}, (Object)new Object[]{"abc"}) : ImmutableList.of((Object)new Object[]{null}, (Object)new Object[]{""}, (Object)new Object[]{"a"}, (Object)new Object[]{"abc"})));
    }

    @Test
    public void testSelectDistinctWithSortAsOuterQuery() throws Exception {
        this.testQuery("SELECT * FROM (SELECT DISTINCT dim2 FROM druid.foo ORDER BY dim2) LIMIT 10", (List<Query>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim2", "d0")).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC)).threshold(10).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{""}, (Object)new Object[]{"a"}, (Object)new Object[]{"abc"}) : ImmutableList.of((Object)new Object[]{null}, (Object)new Object[]{""}, (Object)new Object[]{"a"}, (Object)new Object[]{"abc"})));
    }

    @Test
    public void testSelectDistinctWithSortAsOuterQuery2() throws Exception {
        this.testQuery("SELECT * FROM (SELECT DISTINCT dim2 FROM druid.foo ORDER BY dim2 LIMIT 5) LIMIT 10", (List<Query>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim2", "d0")).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC)).threshold(5).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{""}, (Object)new Object[]{"a"}, (Object)new Object[]{"abc"}) : ImmutableList.of((Object)new Object[]{null}, (Object)new Object[]{""}, (Object)new Object[]{"a"}, (Object)new Object[]{"abc"})));
    }

    @Test
    public void testSelectDistinctWithSortAsOuterQuery3() throws Exception {
        this.testQuery("SELECT * FROM (SELECT DISTINCT dim2 FROM druid.foo ORDER BY dim2 DESC LIMIT 5) LIMIT 10", (List<Query>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim2", "d0")).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC))).threshold(5).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{""}, (Object)new Object[]{"abc"}, (Object)new Object[]{"a"}) : ImmutableList.of((Object)new Object[]{null}, (Object)new Object[]{"abc"}, (Object)new Object[]{"a"}, (Object)new Object[]{""})));
    }

    @Test
    public void testSelectNonAggregatingWithLimitLiterallyZero() throws Exception {
        this.testQuery("SELECT dim2 FROM druid.foo ORDER BY dim2 LIMIT 0", (List<Query>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of(), (RowSignature)RowSignature.builder().add("dim2", ColumnType.STRING).build())).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim2"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false)).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testSelectNonAggregatingWithLimitReducedToZero() throws Exception {
        this.testQuery("SELECT * FROM (SELECT dim2 FROM druid.foo ORDER BY dim2 LIMIT 2 OFFSET 5) OFFSET 2", (List<Query>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of(), (RowSignature)RowSignature.builder().add("dim2", ColumnType.STRING).build())).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim2"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false)).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testSelectAggregatingWithLimitReducedToZero() throws Exception {
        this.testQuery("SELECT * FROM (SELECT DISTINCT dim2 FROM druid.foo ORDER BY dim2 LIMIT 2 OFFSET 5) OFFSET 2", (List<Query>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of(), (RowSignature)RowSignature.builder().add("dim2", ColumnType.STRING).build())).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim2"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false)).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testSelectCurrentTimeAndDateLosAngeles() throws Exception {
        DateTimeZone timeZone = DateTimes.inferTzFromString((String)"America/Los_Angeles");
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_LOS_ANGELES, "SELECT CURRENT_TIMESTAMP, CURRENT_DATE, CURRENT_DATE + INTERVAL '1' DAY", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{new DateTime((Object)"2000-01-01T00Z", timeZone).withZone(DateTimeZone.UTC).getMillis(), new DateTime((Object)"1999-12-31", timeZone).withZone(DateTimeZone.UTC).getMillis(), new DateTime((Object)"2000-01-01", timeZone).withZone(DateTimeZone.UTC).getMillis()}), (RowSignature)RowSignature.builder().add("CURRENT_TIMESTAMP", ColumnType.LONG).add("CURRENT_DATE", ColumnType.LONG).add("EXPR$2", ColumnType.LONG).build())).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"CURRENT_DATE", "CURRENT_TIMESTAMP", "EXPR$2"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false)).context(QUERY_CONTEXT_LOS_ANGELES).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-01T00Z", "America/Los_Angeles"), CalciteSelectQueryTest.day("1999-12-31"), CalciteSelectQueryTest.day("2000-01-01")}));
    }

    @Test
    public void testSelectCountStar() throws Exception {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_DEFAULT, "SELECT exp(count(*)) + 10, sum(m2)  FROM druid.foo WHERE  dim2 = 0", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteSelectQueryTest.bound("dim2", "0", "0", false, false, null, StringComparators.NUMERIC)).granularity(Granularities.ALL).aggregators(CalciteSelectQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0"), new DoubleSumAggregatorFactory("a1", "m2")})).postAggregators(new PostAggregator[]{CalciteSelectQueryTest.expressionPostAgg("p0", "(exp(\"a0\") + 10)")}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{11.0, NullHandling.defaultDoubleValue()}));
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_DEFAULT, "SELECT exp(count(*)) + 10, sum(m2)  FROM druid.foo WHERE  __time >= TIMESTAMP '2999-01-01 00:00:00'", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Intervals.of((String)"2999-01-01T00:00:00.000Z/146140482-04-24T15:36:27.903Z"))).granularity(Granularities.ALL).aggregators(CalciteSelectQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0"), new DoubleSumAggregatorFactory("a1", "m2")})).postAggregators(new PostAggregator[]{CalciteSelectQueryTest.expressionPostAgg("p0", "(exp(\"a0\") + 10)")}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{11.0, NullHandling.defaultDoubleValue()}));
        this.testQuery(PLANNER_CONFIG_DEFAULT, TIMESERIES_CONTEXT_BY_GRAN, "SELECT COUNT(*) FROM foo WHERE dim1 = 'nonexistent'", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteSelectQueryTest.selector("dim1", "nonexistent", null)).granularity(Granularities.ALL).aggregators(CalciteSelectQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(TIMESERIES_CONTEXT_BY_GRAN).build()), (List<Object[]>)ImmutableList.of());
        this.testQuery("SELECT COUNT(*) FROM foo WHERE dim1 = 'nonexistent' GROUP BY FLOOR(__time TO DAY)", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteSelectQueryTest.selector("dim1", "nonexistent", null)).granularity(Granularities.DAY).aggregators(CalciteSelectQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(CalciteSelectQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testSelectStarFromLookup() throws Exception {
        this.testQuery("SELECT * FROM lookup.lookyloo", (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource((DataSource)new LookupDataSource("lookyloo")).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"k", "v"}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", "xa"}, (Object)new Object[]{"abc", "xabc"}, (Object)new Object[]{"nosuchkey", "mysteryvalue"}, (Object)new Object[]{"6", "x6"}));
    }

    @Test
    public void testSelectStar() throws Exception {
        this.testQuery(PLANNER_CONFIG_DEFAULT_NO_COMPLEX_SERDE, QUERY_CONTEXT_DEFAULT, "SELECT * FROM druid.foo", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "cnt", "dim1", "dim2", "dim3", "m1", "m2", "unique_dim1"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-01"), 1L, "", "a", "[\"a\",\"b\"]", Float.valueOf(1.0f), 1.0, HLLC_STRING}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-02"), 1L, "10.1", NULL_STRING, "[\"b\",\"c\"]", Float.valueOf(2.0f), 2.0, HLLC_STRING}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-03"), 1L, "2", "", "d", Float.valueOf(3.0f), 3.0, HLLC_STRING}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2001-01-01"), 1L, "1", "a", "", Float.valueOf(4.0f), 4.0, HLLC_STRING}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2001-01-02"), 1L, "def", "abc", NULL_STRING, Float.valueOf(5.0f), 5.0, HLLC_STRING}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2001-01-03"), 1L, "abc", NULL_STRING, NULL_STRING, Float.valueOf(6.0f), 6.0, HLLC_STRING}));
    }

    @Test
    public void testSelectStarOnForbiddenTable() throws Exception {
        this.assertQueryIsForbidden("SELECT * FROM druid.forbiddenDatasource", CalciteTests.REGULAR_USER_AUTH_RESULT);
        this.testQuery(PLANNER_CONFIG_DEFAULT, "SELECT * FROM druid.forbiddenDatasource", CalciteTests.SUPER_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("forbiddenDatasource").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "cnt", "dim1", "dim2", "m1", "m2", "unique_dim1"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-01"), 1L, "forbidden", "abcd", Float.valueOf(9999.0f), NullHandling.defaultDoubleValue(), "\"AQAAAQAAAALFBA==\""}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-02"), 1L, "forbidden", "a", Float.valueOf(1234.0f), NullHandling.defaultDoubleValue(), "\"AQAAAQAAAALFBA==\""}));
    }

    @Test
    public void testSelectStarOnForbiddenView() throws Exception {
        this.assertQueryIsForbidden("SELECT * FROM view.forbiddenView", CalciteTests.REGULAR_USER_AUTH_RESULT);
        this.testQuery(PLANNER_CONFIG_DEFAULT, "SELECT * FROM view.forbiddenView", CalciteTests.SUPER_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteSelectQueryTest.expressionVirtualColumn("v0", "substring(\"dim1\", 0, 1)", ColumnType.STRING), CalciteSelectQueryTest.expressionVirtualColumn("v1", "'a'", ColumnType.STRING)}).filters((DimFilter)CalciteSelectQueryTest.selector("dim2", "a", null)).columns(new String[]{"__time", "v0", "v1"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-01"), NullHandling.defaultStringValue(), "a"}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2001-01-01"), "1", "a"}));
    }

    @Test
    public void testSelectStarOnRestrictedView() throws Exception {
        this.testQuery(PLANNER_CONFIG_DEFAULT, "SELECT * FROM view.restrictedView", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("forbiddenDatasource").filters((DimFilter)CalciteSelectQueryTest.selector("dim2", "a", null)).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "dim2", "m1"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-02"), "forbidden", "a", Float.valueOf(1234.0f)}));
        this.testQuery(PLANNER_CONFIG_DEFAULT, "SELECT * FROM view.restrictedView", CalciteTests.SUPER_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("forbiddenDatasource").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteSelectQueryTest.selector("dim2", "a", null)).columns(new String[]{"__time", "dim1", "dim2", "m1"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-02"), "forbidden", "a", Float.valueOf(1234.0f)}));
    }

    @Test
    public void testUnqualifiedTableName() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM foo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteSelectQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testExplainSelectStar() throws Exception {
        this.skipVectorize();
        String query = "EXPLAIN PLAN FOR SELECT * FROM druid.foo";
        String legacyExplanation = "DruidQueryRel(query=[{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"compactedList\",\"batchSize\":20480,\"filter\":null,\"columns\":[\"__time\",\"cnt\",\"dim1\",\"dim2\",\"dim3\",\"m1\",\"m2\",\"unique_dim1\"],\"legacy\":false,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false,\"granularity\":{\"type\":\"all\"}}], signature=[{__time:LONG, cnt:LONG, dim1:STRING, dim2:STRING, dim3:STRING, m1:FLOAT, m2:DOUBLE, unique_dim1:COMPLEX<hyperUnique>}])\n";
        String explanation = "[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"compactedList\",\"batchSize\":20480,\"filter\":null,\"columns\":[\"__time\",\"cnt\",\"dim1\",\"dim2\",\"dim3\",\"m1\",\"m2\",\"unique_dim1\"],\"legacy\":false,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false,\"granularity\":{\"type\":\"all\"}},\"signature\":[{\"name\":\"__time\",\"type\":\"LONG\"},{\"name\":\"cnt\",\"type\":\"LONG\"},{\"name\":\"dim1\",\"type\":\"STRING\"},{\"name\":\"dim2\",\"type\":\"STRING\"},{\"name\":\"dim3\",\"type\":\"STRING\"},{\"name\":\"m1\",\"type\":\"FLOAT\"},{\"name\":\"m2\",\"type\":\"DOUBLE\"},{\"name\":\"unique_dim1\",\"type\":\"COMPLEX<hyperUnique>\"}]}]";
        String resources = "[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]";
        this.testQuery("EXPLAIN PLAN FOR SELECT * FROM druid.foo", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"DruidQueryRel(query=[{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"compactedList\",\"batchSize\":20480,\"filter\":null,\"columns\":[\"__time\",\"cnt\",\"dim1\",\"dim2\",\"dim3\",\"m1\",\"m2\",\"unique_dim1\"],\"legacy\":false,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false,\"granularity\":{\"type\":\"all\"}}], signature=[{__time:LONG, cnt:LONG, dim1:STRING, dim2:STRING, dim3:STRING, m1:FLOAT, m2:DOUBLE, unique_dim1:COMPLEX<hyperUnique>}])\n", "[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]"}));
        this.testQuery(PLANNER_CONFIG_NATIVE_QUERY_EXPLAIN, "EXPLAIN PLAN FOR SELECT * FROM druid.foo", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"compactedList\",\"batchSize\":20480,\"filter\":null,\"columns\":[\"__time\",\"cnt\",\"dim1\",\"dim2\",\"dim3\",\"m1\",\"m2\",\"unique_dim1\"],\"legacy\":false,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false,\"granularity\":{\"type\":\"all\"}},\"signature\":[{\"name\":\"__time\",\"type\":\"LONG\"},{\"name\":\"cnt\",\"type\":\"LONG\"},{\"name\":\"dim1\",\"type\":\"STRING\"},{\"name\":\"dim2\",\"type\":\"STRING\"},{\"name\":\"dim3\",\"type\":\"STRING\"},{\"name\":\"m1\",\"type\":\"FLOAT\"},{\"name\":\"m2\",\"type\":\"DOUBLE\"},{\"name\":\"unique_dim1\",\"type\":\"COMPLEX<hyperUnique>\"}]}]", "[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]"}));
    }

    @Test
    public void testSelectStarWithLimit() throws Exception {
        this.testQuery(PLANNER_CONFIG_DEFAULT_NO_COMPLEX_SERDE, QUERY_CONTEXT_DEFAULT, "SELECT * FROM druid.foo LIMIT 2", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "cnt", "dim1", "dim2", "dim3", "m1", "m2", "unique_dim1"}).limit(2L).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-01"), 1L, "", "a", "[\"a\",\"b\"]", Float.valueOf(1.0f), 1.0, HLLC_STRING}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-02"), 1L, "10.1", NULL_STRING, "[\"b\",\"c\"]", Float.valueOf(2.0f), 2.0, HLLC_STRING}));
    }

    @Test
    public void testSelectStarWithLimitAndOffset() throws Exception {
        this.testQuery(PLANNER_CONFIG_DEFAULT_NO_COMPLEX_SERDE, QUERY_CONTEXT_DEFAULT, "SELECT * FROM druid.foo LIMIT 2 OFFSET 1", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "cnt", "dim1", "dim2", "dim3", "m1", "m2", "unique_dim1"}).offset(1L).limit(2L).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-02"), 1L, "10.1", NULL_STRING, "[\"b\",\"c\"]", Float.valueOf(2.0f), 2.0, HLLC_STRING}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-03"), 1L, "2", "", "d", Float.valueOf(3.0f), 3.0, HLLC_STRING}));
    }

    @Test
    public void testSelectWithProjection() throws Exception {
        this.testQuery("SELECT SUBSTRING(dim2, 1, 1) FROM druid.foo LIMIT 2", (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteSelectQueryTest.expressionVirtualColumn("v0", "substring(\"dim2\", 0, 1)", ColumnType.STRING)}).columns(new String[]{"v0"}).limit(2L).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{NULL_STRING}));
    }

    @Test
    public void testSelectWithExpressionFilter() throws Exception {
        this.testQuery("SELECT dim1 FROM druid.foo WHERE m1 + 1 = 7", (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteSelectQueryTest.expressionVirtualColumn("v0", "(\"m1\" + 1)", ColumnType.FLOAT)}).filters((DimFilter)CalciteSelectQueryTest.selector("v0", "7", null)).columns(new String[]{"dim1"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc"}));
    }

    @Test
    public void testSelectStarWithLimitTimeDescending() throws Exception {
        this.testQuery(PLANNER_CONFIG_DEFAULT_NO_COMPLEX_SERDE, QUERY_CONTEXT_DEFAULT, "SELECT * FROM druid.foo ORDER BY __time DESC LIMIT 2", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns((List)ImmutableList.of((Object)"__time", (Object)"cnt", (Object)"dim1", (Object)"dim2", (Object)"dim3", (Object)"m1", (Object)"m2", (Object)"unique_dim1")).limit(2L).order(ScanQuery.Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteSelectQueryTest.timestamp("2001-01-03"), 1L, "abc", NULL_STRING, NULL_STRING, Float.valueOf(6.0f), 6.0, HLLC_STRING}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2001-01-02"), 1L, "def", "abc", NULL_STRING, Float.valueOf(5.0f), 5.0, HLLC_STRING}));
    }

    @Test
    public void testSelectStarWithoutLimitTimeAscending() throws Exception {
        this.testQuery(PLANNER_CONFIG_DEFAULT_NO_COMPLEX_SERDE, QUERY_CONTEXT_DEFAULT, "SELECT * FROM druid.foo ORDER BY __time", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns((List)ImmutableList.of((Object)"__time", (Object)"cnt", (Object)"dim1", (Object)"dim2", (Object)"dim3", (Object)"m1", (Object)"m2", (Object)"unique_dim1")).limit(Long.MAX_VALUE).order(ScanQuery.Order.ASCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-01"), 1L, "", "a", "[\"a\",\"b\"]", Float.valueOf(1.0f), 1.0, HLLC_STRING}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-02"), 1L, "10.1", NULL_STRING, "[\"b\",\"c\"]", Float.valueOf(2.0f), 2.0, HLLC_STRING}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-03"), 1L, "2", "", "d", Float.valueOf(3.0f), 3.0, HLLC_STRING}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2001-01-01"), 1L, "1", "a", "", Float.valueOf(4.0f), 4.0, HLLC_STRING}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2001-01-02"), 1L, "def", "abc", NULL_STRING, Float.valueOf(5.0f), 5.0, HLLC_STRING}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2001-01-03"), 1L, "abc", NULL_STRING, NULL_STRING, Float.valueOf(6.0f), 6.0, HLLC_STRING}));
    }

    @Test
    public void testSelectSingleColumnTwice() throws Exception {
        this.testQuery("SELECT dim2 x, dim2 y FROM druid.foo LIMIT 2", (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim2"}).limit(2L).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", "a"}, (Object)new Object[]{NULL_STRING, NULL_STRING}));
    }

    @Test
    public void testSelectSingleColumnWithLimitDescending() throws Exception {
        this.testQuery("SELECT dim1 FROM druid.foo ORDER BY __time DESC LIMIT 2", (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns((List)ImmutableList.of((Object)"__time", (Object)"dim1")).limit(2L).order(ScanQuery.Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc"}, (Object)new Object[]{"def"}));
    }

    @Test
    public void testSelectStarFromSelectSingleColumnWithLimitDescending() throws Exception {
        this.testQuery("SELECT * FROM (SELECT dim1 FROM druid.foo ORDER BY __time DESC) LIMIT 2", (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns((List)ImmutableList.of((Object)"dim1")).limit(2L).order(ScanQuery.Order.NONE).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{""}, (Object)new Object[]{"10.1"}));
    }

    @Test
    public void testSelectLimitWrapping() throws Exception {
        this.testQuery("SELECT dim1 FROM druid.foo ORDER BY __time DESC", (Map<String, Object>)OUTER_LIMIT_CONTEXT, (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns((List)ImmutableList.of((Object)"__time", (Object)"dim1")).limit(2L).order(ScanQuery.Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(OUTER_LIMIT_CONTEXT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc"}, (Object)new Object[]{"def"}));
    }

    @Test
    public void testSelectLimitWrappingOnTopOfOffset() throws Exception {
        this.testQuery("SELECT dim1 FROM druid.foo ORDER BY __time DESC OFFSET 1", (Map<String, Object>)OUTER_LIMIT_CONTEXT, (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns((List)ImmutableList.of((Object)"__time", (Object)"dim1")).offset(1L).limit(2L).order(ScanQuery.Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(OUTER_LIMIT_CONTEXT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"def"}, (Object)new Object[]{"1"}));
    }

    @Test
    public void testSelectLimitWrappingOnTopOfOffsetAndLowLimit() throws Exception {
        this.testQuery("SELECT dim1 FROM druid.foo ORDER BY __time DESC LIMIT 1 OFFSET 1", (Map<String, Object>)OUTER_LIMIT_CONTEXT, (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns((List)ImmutableList.of((Object)"__time", (Object)"dim1")).offset(1L).limit(1L).order(ScanQuery.Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(OUTER_LIMIT_CONTEXT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"def"}));
    }

    @Test
    public void testSelectLimitWrappingOnTopOfOffsetAndHighLimit() throws Exception {
        this.testQuery("SELECT dim1 FROM druid.foo ORDER BY __time DESC LIMIT 10 OFFSET 1", (Map<String, Object>)OUTER_LIMIT_CONTEXT, (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns((List)ImmutableList.of((Object)"__time", (Object)"dim1")).offset(1L).limit(2L).order(ScanQuery.Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(OUTER_LIMIT_CONTEXT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"def"}, (Object)new Object[]{"1"}));
    }

    @Test
    public void testSelectLimitWrappingAgainAkaIDontReallyQuiteUnderstandCalciteQueryPlanning() throws Exception {
        this.testQuery("SELECT \"__time\", \"count\", \"dimHyperUnique\", \"dimMultivalEnumerated\", \"dimMultivalEnumerated2\", \"dimMultivalSequentialWithNulls\", \"dimSequential\", \"dimSequentialHalfNull\", \"dimUniform\", \"dimZipf\", \"metFloatNormal\", \"metFloatZipf\", \"metLongSequential\" FROM druid.lotsocolumns WHERE __time >= CURRENT_TIMESTAMP - INTERVAL '10' YEAR", (Map<String, Object>)OUTER_LIMIT_CONTEXT, (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("lotsocolumns").intervals(CalciteSelectQueryTest.querySegmentSpec(Intervals.of((String)"1990-01-01T00:00:00.000Z/146140482-04-24T15:36:27.903Z"))).columns((List)ImmutableList.builder().add((Object)"__time").add((Object)"count").add((Object)"dimHyperUnique").add((Object)"dimMultivalEnumerated").add((Object)"dimMultivalEnumerated2").add((Object)"dimMultivalSequentialWithNulls").add((Object)"dimSequential").add((Object)"dimSequentialHalfNull").add((Object)"dimUniform").add((Object)"dimZipf").add((Object)"metFloatNormal").add((Object)"metFloatZipf").add((Object)"metLongSequential").build()).limit(2L).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(OUTER_LIMIT_CONTEXT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1576306800000L, 1L, "0", "[\"Baz\",\"Baz\",\"Hello\",\"World\"]", this.useDefault ? "[\"\",\"Apple\",\"Orange\"]" : "[null,\"Apple\",\"Orange\"]", "[\"1\",\"2\",\"3\",\"4\",\"5\",\"6\",\"7\",\"8\"]", "0", "0", "74416", "27", "5000.0", "147.0", "0"}, (Object)new Object[]{1576306800000L, 1L, "8", "[\"Baz\",\"World\",\"\u3151 \u3153 \u3155 \u3157 \u315b \u315c \u3160 \u3161 \u3163\"]", this.useDefault ? "[\"\",\"Corundum\",\"Xylophone\"]" : "[null,\"Corundum\",\"Xylophone\"]", this.useDefault ? "" : null, "8", this.useDefault ? "" : null, "50515", "9", "4999.0", "25.0", "8"}));
        this.testQuery("SELECT \"__time\", \"count\", \"dimHyperUnique\", \"dimMultivalEnumerated\", \"dimMultivalEnumerated2\", \"dimMultivalSequentialWithNulls\", \"dimSequential\", \"dimSequentialHalfNull\", \"dimUniform\", \"dimZipf\", \"metFloatNormal\", \"metFloatZipf\", \"metLongSequential\", \"metLongUniform\" FROM druid.lotsocolumns WHERE __time >= CURRENT_TIMESTAMP - INTERVAL '10' YEAR", (Map<String, Object>)OUTER_LIMIT_CONTEXT, (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("lotsocolumns").intervals(CalciteSelectQueryTest.querySegmentSpec(Intervals.of((String)"1990-01-01T00:00:00.000Z/146140482-04-24T15:36:27.903Z"))).columns((List)ImmutableList.builder().add((Object)"__time").add((Object)"count").add((Object)"dimHyperUnique").add((Object)"dimMultivalEnumerated").add((Object)"dimMultivalEnumerated2").add((Object)"dimMultivalSequentialWithNulls").add((Object)"dimSequential").add((Object)"dimSequentialHalfNull").add((Object)"dimUniform").add((Object)"dimZipf").add((Object)"metFloatNormal").add((Object)"metFloatZipf").add((Object)"metLongSequential").add((Object)"metLongUniform").build()).limit(2L).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(OUTER_LIMIT_CONTEXT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1576306800000L, 1L, "0", "[\"Baz\",\"Baz\",\"Hello\",\"World\"]", this.useDefault ? "[\"\",\"Apple\",\"Orange\"]" : "[null,\"Apple\",\"Orange\"]", "[\"1\",\"2\",\"3\",\"4\",\"5\",\"6\",\"7\",\"8\"]", "0", "0", "74416", "27", "5000.0", "147.0", "0", "372"}, (Object)new Object[]{1576306800000L, 1L, "8", "[\"Baz\",\"World\",\"\u3151 \u3153 \u3155 \u3157 \u315b \u315c \u3160 \u3161 \u3163\"]", this.useDefault ? "[\"\",\"Corundum\",\"Xylophone\"]" : "[null,\"Corundum\",\"Xylophone\"]", this.useDefault ? "" : null, "8", this.useDefault ? "" : null, "50515", "9", "4999.0", "25.0", "8", "252"}));
    }

    @Test
    public void testSelectProjectionFromSelectSingleColumnWithInnerLimitDescending() throws Exception {
        this.testQuery("SELECT 'beep ' || dim1 FROM (SELECT dim1 FROM druid.foo ORDER BY __time DESC LIMIT 2)", (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteSelectQueryTest.expressionVirtualColumn("v0", "concat('beep ',\"dim1\")", ColumnType.STRING)}).columns((List)ImmutableList.of((Object)"__time", (Object)"v0")).limit(2L).order(ScanQuery.Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"beep abc"}, (Object)new Object[]{"beep def"}));
    }

    @Test
    public void testSelectProjectionFromSelectSingleColumnDescending() throws Exception {
        this.testQuery("SELECT 'beep ' || dim1 FROM (SELECT dim1 FROM druid.foo ORDER BY __time DESC)", (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteSelectQueryTest.expressionVirtualColumn("v0", "concat('beep ',\"dim1\")", ColumnType.STRING)}).columns((List)ImmutableList.of((Object)"v0")).order(ScanQuery.Order.NONE).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"beep "}, (Object)new Object[]{"beep 10.1"}, (Object)new Object[]{"beep 2"}, (Object)new Object[]{"beep 1"}, (Object)new Object[]{"beep def"}, (Object)new Object[]{"beep abc"}));
    }

    @Test
    public void testSelectProjectionFromSelectSingleColumnWithInnerAndOuterLimitDescending() throws Exception {
        this.testQuery("SELECT 'beep ' || dim1 FROM (SELECT dim1 FROM druid.foo ORDER BY __time DESC LIMIT 4) LIMIT 2", (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteSelectQueryTest.expressionVirtualColumn("v0", "concat('beep ',\"dim1\")", ColumnType.STRING)}).columns((List)ImmutableList.of((Object)"__time", (Object)"v0")).limit(2L).order(ScanQuery.Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"beep abc"}, (Object)new Object[]{"beep def"}));
    }

    @Test
    public void testOrderThenLimitThenFilter() throws Exception {
        this.testQuery("SELECT dim1 FROM (SELECT __time, dim1 FROM druid.foo ORDER BY __time DESC LIMIT 4) WHERE dim1 IN ('abc', 'def')", (List<Query>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource((DataSource)new QueryDataSource((Query)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns((List)ImmutableList.of((Object)"__time", (Object)"dim1")).limit(4L).order(ScanQuery.Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build())).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns((List)ImmutableList.of((Object)"dim1")).filters((DimFilter)CalciteSelectQueryTest.in("dim1", Arrays.asList("abc", "def"), null)).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc"}, (Object)new Object[]{"def"}));
    }
}

