/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.ResourceLimitExceededException;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.ExpressionLambdaAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.FloatMaxAggregatorFactory;
import org.apache.druid.query.aggregation.FloatMinAggregatorFactory;
import org.apache.druid.query.aggregation.GroupingAggregatorFactory;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.query.aggregation.LongMinAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.any.DoubleAnyAggregatorFactory;
import org.apache.druid.query.aggregation.any.FloatAnyAggregatorFactory;
import org.apache.druid.query.aggregation.any.LongAnyAggregatorFactory;
import org.apache.druid.query.aggregation.any.StringAnyAggregatorFactory;
import org.apache.druid.query.aggregation.cardinality.CardinalityAggregatorFactory;
import org.apache.druid.query.aggregation.first.DoubleFirstAggregatorFactory;
import org.apache.druid.query.aggregation.first.FloatFirstAggregatorFactory;
import org.apache.druid.query.aggregation.first.LongFirstAggregatorFactory;
import org.apache.druid.query.aggregation.first.StringFirstAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniqueFinalizingPostAggregator;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.aggregation.last.DoubleLastAggregatorFactory;
import org.apache.druid.query.aggregation.last.FloatLastAggregatorFactory;
import org.apache.druid.query.aggregation.last.LongLastAggregatorFactory;
import org.apache.druid.query.aggregation.last.StringLastAggregatorFactory;
import org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.druid.query.aggregation.post.ExpressionPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.aggregation.post.FinalizingFieldAccessPostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.RegexDimExtractionFn;
import org.apache.druid.query.extraction.SubstringDimExtractionFn;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.LikeDimFilter;
import org.apache.druid.query.filter.RegexDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.having.HavingSpec;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.lookup.RegisteredLookupExtractionFn;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.topn.DimensionTopNMetricSpec;
import org.apache.druid.query.topn.InvertedTopNMetricSpec;
import org.apache.druid.query.topn.NumericTopNMetricSpec;
import org.apache.druid.query.topn.TopNMetricSpec;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.sql.SqlPlanningException;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.rel.CannotBuildQueryException;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CalciteQueryTest
extends BaseCalciteQueryTest {
    @Test
    public void testGroupByWithPostAggregatorReferencingTimeFloorColumnOnTimeseries() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT TIME_FORMAT(\"date\", 'yyyy-MM'), SUM(x)\nFROM (\n    SELECT\n        FLOOR(__time to hour) as \"date\",\n        COUNT(*) as x\n    FROM foo\n    GROUP BY 1\n)\nGROUP BY 1", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.HOUR).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()).setInterval(CalciteQueryTest.querySegmentSpec(Intervals.ETERNITY)).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_format(\"d0\",'yyyy-MM','UTC')", ColumnType.STRING)}).setGranularity(Granularities.ALL).addDimension((DimensionSpec)new DefaultDimensionSpec("v0", "_d0")).addAggregator((AggregatorFactory)new LongSumAggregatorFactory("_a0", "a0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"2000-01", 3L}, (Object)new Object[]{"2001-01", 3L}));
    }

    @Test
    public void testInformationSchemaSchemata() throws Exception {
        this.testQuery("SELECT DISTINCT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"lookup"}, (Object)new Object[]{"view"}, (Object)new Object[]{"druid"}, (Object)new Object[]{"sys"}, (Object)new Object[]{"INFORMATION_SCHEMA"}));
    }

    @Test
    public void testInformationSchemaTables() throws Exception {
        this.testQuery("SELECT TABLE_SCHEMA, TABLE_NAME, TABLE_TYPE, IS_JOINABLE, IS_BROADCAST\nFROM INFORMATION_SCHEMA.TABLES\nWHERE TABLE_TYPE IN ('SYSTEM_TABLE', 'TABLE', 'VIEW')", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.builder().add((Object)new Object[]{"druid", "broadcast", "TABLE", "YES", "YES"}).add((Object)new Object[]{"druid", "foo", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "foo2", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "foo4", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "lotsocolumns", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "numfoo", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "some_datasource", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "somexdatasource", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "visits", "TABLE", "NO", "NO"}).add((Object)new Object[]{"INFORMATION_SCHEMA", "COLUMNS", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"INFORMATION_SCHEMA", "SCHEMATA", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"INFORMATION_SCHEMA", "TABLES", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"lookup", "lookyloo", "TABLE", "YES", "YES"}).add((Object)new Object[]{"sys", "segments", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"sys", "server_segments", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"sys", "servers", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"sys", "supervisors", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"sys", "tasks", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"view", "aview", "VIEW", "NO", "NO"}).add((Object)new Object[]{"view", "bview", "VIEW", "NO", "NO"}).add((Object)new Object[]{"view", "cview", "VIEW", "NO", "NO"}).add((Object)new Object[]{"view", "dview", "VIEW", "NO", "NO"}).add((Object)new Object[]{"view", "invalidView", "VIEW", "NO", "NO"}).add((Object)new Object[]{"view", "restrictedView", "VIEW", "NO", "NO"}).build());
        this.testQuery(PLANNER_CONFIG_DEFAULT, "SELECT TABLE_SCHEMA, TABLE_NAME, TABLE_TYPE, IS_JOINABLE, IS_BROADCAST\nFROM INFORMATION_SCHEMA.TABLES\nWHERE TABLE_TYPE IN ('SYSTEM_TABLE', 'TABLE', 'VIEW')", CalciteTests.SUPER_USER_AUTH_RESULT, (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.builder().add((Object)new Object[]{"druid", "broadcast", "TABLE", "YES", "YES"}).add((Object)new Object[]{"druid", "foo", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "foo2", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "foo4", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "forbiddenDatasource", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "lotsocolumns", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "numfoo", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "some_datasource", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "somexdatasource", "TABLE", "NO", "NO"}).add((Object)new Object[]{"druid", "visits", "TABLE", "NO", "NO"}).add((Object)new Object[]{"INFORMATION_SCHEMA", "COLUMNS", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"INFORMATION_SCHEMA", "SCHEMATA", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"INFORMATION_SCHEMA", "TABLES", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"lookup", "lookyloo", "TABLE", "YES", "YES"}).add((Object)new Object[]{"sys", "segments", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"sys", "server_segments", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"sys", "servers", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"sys", "supervisors", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"sys", "tasks", "SYSTEM_TABLE", "NO", "NO"}).add((Object)new Object[]{"view", "aview", "VIEW", "NO", "NO"}).add((Object)new Object[]{"view", "bview", "VIEW", "NO", "NO"}).add((Object)new Object[]{"view", "cview", "VIEW", "NO", "NO"}).add((Object)new Object[]{"view", "dview", "VIEW", "NO", "NO"}).add((Object)new Object[]{"view", "forbiddenView", "VIEW", "NO", "NO"}).add((Object)new Object[]{"view", "invalidView", "VIEW", "NO", "NO"}).add((Object)new Object[]{"view", "restrictedView", "VIEW", "NO", "NO"}).build());
    }

    @Test
    public void testInformationSchemaColumnsOnTable() throws Exception {
        this.testQuery("SELECT COLUMN_NAME, DATA_TYPE, IS_NULLABLE\nFROM INFORMATION_SCHEMA.COLUMNS\nWHERE TABLE_SCHEMA = 'druid' AND TABLE_NAME = 'foo'", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"__time", "TIMESTAMP", "NO"}, (Object)new Object[]{"cnt", "BIGINT", this.useDefault ? "NO" : "YES"}, (Object)new Object[]{"dim1", "VARCHAR", "YES"}, (Object)new Object[]{"dim2", "VARCHAR", "YES"}, (Object)new Object[]{"dim3", "VARCHAR", "YES"}, (Object)new Object[]{"m1", "FLOAT", this.useDefault ? "NO" : "YES"}, (Object)new Object[]{"m2", "DOUBLE", this.useDefault ? "NO" : "YES"}, (Object)new Object[]{"unique_dim1", "COMPLEX<hyperUnique>", "YES"}));
    }

    @Test
    public void testInformationSchemaColumnsOnForbiddenTable() throws Exception {
        this.testQuery("SELECT COLUMN_NAME, DATA_TYPE, IS_NULLABLE\nFROM INFORMATION_SCHEMA.COLUMNS\nWHERE TABLE_SCHEMA = 'druid' AND TABLE_NAME = 'forbiddenDatasource'", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
        this.testQuery(PLANNER_CONFIG_DEFAULT, "SELECT COLUMN_NAME, DATA_TYPE, IS_NULLABLE\nFROM INFORMATION_SCHEMA.COLUMNS\nWHERE TABLE_SCHEMA = 'druid' AND TABLE_NAME = 'forbiddenDatasource'", CalciteTests.SUPER_USER_AUTH_RESULT, (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"__time", "TIMESTAMP", "NO"}, (Object)new Object[]{"cnt", "BIGINT", this.useDefault ? "NO" : "YES"}, (Object)new Object[]{"dim1", "VARCHAR", "YES"}, (Object)new Object[]{"dim2", "VARCHAR", "YES"}, (Object)new Object[]{"m1", "FLOAT", this.useDefault ? "NO" : "YES"}, (Object)new Object[]{"m2", "DOUBLE", this.useDefault ? "NO" : "YES"}, (Object)new Object[]{"unique_dim1", "COMPLEX<hyperUnique>", "YES"}));
    }

    @Test
    public void testInformationSchemaColumnsOnView() throws Exception {
        this.testQuery("SELECT COLUMN_NAME, DATA_TYPE, IS_NULLABLE\nFROM INFORMATION_SCHEMA.COLUMNS\nWHERE TABLE_SCHEMA = 'view' AND TABLE_NAME = 'aview'", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"dim1_firstchar", "VARCHAR", "YES"}));
    }

    @Test
    public void testInformationSchemaColumnsOnAnotherView() throws Exception {
        this.testQuery("SELECT COLUMN_NAME, DATA_TYPE, IS_NULLABLE\nFROM INFORMATION_SCHEMA.COLUMNS\nWHERE TABLE_SCHEMA = 'view' AND TABLE_NAME = 'cview'", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"dim1_firstchar", "VARCHAR", "YES"}, (Object)new Object[]{"dim2", "VARCHAR", "YES"}, (Object)new Object[]{"l2", "BIGINT", this.useDefault ? "NO" : "YES"}));
    }

    @Test
    public void testExplainInformationSchemaColumns() throws Exception {
        String explanation = "BindableProject(COLUMN_NAME=[$3], DATA_TYPE=[$7])\n  BindableFilter(condition=[AND(=($1, 'druid'), =($2, 'foo'))])\n    BindableTableScan(table=[[INFORMATION_SCHEMA, COLUMNS]])\n";
        String resources = "[]";
        this.testQuery("EXPLAIN PLAN FOR\nSELECT COLUMN_NAME, DATA_TYPE\nFROM INFORMATION_SCHEMA.COLUMNS\nWHERE TABLE_SCHEMA = 'druid' AND TABLE_NAME = 'foo'", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"BindableProject(COLUMN_NAME=[$3], DATA_TYPE=[$7])\n  BindableFilter(condition=[AND(=($1, 'druid'), =($2, 'foo'))])\n    BindableTableScan(table=[[INFORMATION_SCHEMA, COLUMNS]])\n", "[]"}));
    }

    @Test
    public void testAggregatorsOnInformationSchemaColumns() throws Exception {
        this.testQuery("SELECT\n  COUNT(JDBC_TYPE),\n  SUM(JDBC_TYPE),\n  AVG(JDBC_TYPE),\n  MIN(JDBC_TYPE),\n  MAX(JDBC_TYPE)\nFROM INFORMATION_SCHEMA.COLUMNS\nWHERE TABLE_SCHEMA = 'druid' AND TABLE_NAME = 'foo'", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{8L, 1249L, 156L, -5L, 1111L}));
    }

    @Test
    public void testTopNLimitWrapping() throws Exception {
        ImmutableList expected = NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"", 1L}, (Object)new Object[]{"def", 1L}) : ImmutableList.of((Object)new Object[]{"def", 1L}, (Object)new Object[]{"abc", 1L});
        this.testQuery("SELECT dim1, COUNT(*) FROM druid.foo GROUP BY dim1 ORDER BY dim1 DESC", (Map<String, Object>)OUTER_LIMIT_CONTEXT, (List<Query>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING)).threshold(2).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC))).context(OUTER_LIMIT_CONTEXT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testTopNLimitWrappingOrderByAgg() throws Exception {
        this.testQuery("SELECT dim1, COUNT(*) FROM druid.foo GROUP BY 1 ORDER BY 2 DESC", (Map<String, Object>)OUTER_LIMIT_CONTEXT, (List<Query>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING)).threshold(2).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).metric("a0").context(OUTER_LIMIT_CONTEXT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", 1L}, (Object)new Object[]{"1", 1L}));
    }

    @Test
    public void testGroupByLimitWrapping() throws Exception {
        ImmutableList expected = NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"def", "abc", 1L}, (Object)new Object[]{"abc", "", 1L}) : ImmutableList.of((Object)new Object[]{"def", "abc", 1L}, (Object)new Object[]{"abc", null, 1L});
        this.testQuery("SELECT dim1, dim2, COUNT(*) FROM druid.foo GROUP BY dim1, dim2 ORDER BY dim1 DESC", (Map<String, Object>)OUTER_LIMIT_CONTEXT, (List<Query>)ImmutableList.of((Object)new GroupByQuery.Builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING), new DefaultDimensionSpec("dim2", "d1", ColumnType.STRING)}).setLimitSpec((LimitSpec)DefaultLimitSpec.builder().orderBy(new OrderByColumnSpec[]{new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.LEXICOGRAPHIC)}).limit(2).build()).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(OUTER_LIMIT_CONTEXT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testGroupByWithForceLimitPushDown() throws Exception {
        HashMap<String, Object> context = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        context.put("forceLimitPushDown", true);
        this.testQuery("SELECT dim1, dim2, COUNT(*) FROM druid.foo GROUP BY dim1, dim2 limit 1", context, (List<Query>)ImmutableList.of((Object)new GroupByQuery.Builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING), new DefaultDimensionSpec("dim2", "d1", ColumnType.STRING)}).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of(), Integer.valueOf(1))).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(context).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", 1L}));
    }

    @Test
    public void testGroupByLimitWrappingOrderByAgg() throws Exception {
        this.testQuery("SELECT dim1, dim2, COUNT(*) FROM druid.foo GROUP BY 1, 2 ORDER BY 3 DESC", (Map<String, Object>)OUTER_LIMIT_CONTEXT, (List<Query>)ImmutableList.of((Object)new GroupByQuery.Builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING), new DefaultDimensionSpec("dim2", "d1", ColumnType.STRING)}).setLimitSpec((LimitSpec)DefaultLimitSpec.builder().orderBy(new OrderByColumnSpec[]{new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)}).limit(2).build()).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(OUTER_LIMIT_CONTEXT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", 1L}, (Object)new Object[]{"1", "a", 1L}));
    }

    @Test
    public void testGroupBySingleColumnDescendingNoTopN() throws Exception {
        this.testQuery(PLANNER_CONFIG_DEFAULT, "SELECT dim1 FROM druid.foo GROUP BY dim1 ORDER BY dim1 DESC", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)new GroupByQuery.Builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setGranularity(Granularities.ALL).setLimitSpec((LimitSpec)DefaultLimitSpec.builder().orderBy(new OrderByColumnSpec[]{new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.LEXICOGRAPHIC)}).build()).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"def"}, (Object)new Object[]{"abc"}, (Object)new Object[]{"2"}, (Object)new Object[]{"10.1"}, (Object)new Object[]{"1"}, (Object)new Object[]{""}));
    }

    @Test
    public void testEarliestAggregators() throws Exception {
        this.skipVectorize();
        this.testQuery("SELECT EARLIEST(cnt), EARLIEST(m1), EARLIEST(dim1, 10), EARLIEST(cnt + 1), EARLIEST(m1 + 1), EARLIEST(dim1 || CAST(cnt AS VARCHAR), 10), EARLIEST_BY(cnt, MILLIS_TO_TIMESTAMP(l1)), EARLIEST_BY(m1, MILLIS_TO_TIMESTAMP(l1)), EARLIEST_BY(dim1, MILLIS_TO_TIMESTAMP(l1), 10), EARLIEST_BY(cnt + 1, MILLIS_TO_TIMESTAMP(l1)), EARLIEST_BY(m1 + 1, MILLIS_TO_TIMESTAMP(l1)), EARLIEST_BY(dim1 || CAST(cnt AS VARCHAR), MILLIS_TO_TIMESTAMP(l1), 10) FROM druid.numfoo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "(\"cnt\" + 1)", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v1", "(\"m1\" + 1)", ColumnType.FLOAT), CalciteQueryTest.expressionVirtualColumn("v2", "concat(\"dim1\",CAST(\"cnt\", 'STRING'))", ColumnType.STRING)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongFirstAggregatorFactory("a0", "cnt", null), new FloatFirstAggregatorFactory("a1", "m1", null), new StringFirstAggregatorFactory("a2", "dim1", null, Integer.valueOf(10)), new LongFirstAggregatorFactory("a3", "v0", null), new FloatFirstAggregatorFactory("a4", "v1", null), new StringFirstAggregatorFactory("a5", "v2", null, Integer.valueOf(10)), new LongFirstAggregatorFactory("a6", "cnt", "l1"), new FloatFirstAggregatorFactory("a7", "m1", "l1"), new StringFirstAggregatorFactory("a8", "dim1", "l1", Integer.valueOf(10)), new LongFirstAggregatorFactory("a9", "v0", "l1"), new FloatFirstAggregatorFactory("a10", "v1", "l1"), new StringFirstAggregatorFactory("a11", "v2", "l1", Integer.valueOf(10))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, Float.valueOf(1.0f), "", 2L, Float.valueOf(2.0f), "1", 1L, Float.valueOf(3.0f), "2", 2L, Float.valueOf(4.0f), "21"}));
    }

    @Test
    public void testLatestAggregators() throws Exception {
        this.skipVectorize();
        this.testQuery("SELECT LATEST(cnt), LATEST(m1), LATEST(dim1, 10), LATEST(cnt + 1), LATEST(m1 + 1), LATEST(dim1 || CAST(cnt AS VARCHAR), 10), LATEST_BY(cnt, MILLIS_TO_TIMESTAMP(l1)), LATEST_BY(m1, MILLIS_TO_TIMESTAMP(l1)), LATEST_BY(dim1, MILLIS_TO_TIMESTAMP(l1), 10), LATEST_BY(cnt + 1, MILLIS_TO_TIMESTAMP(l1)), LATEST_BY(m1 + 1, MILLIS_TO_TIMESTAMP(l1)), LATEST_BY(dim1 || CAST(cnt AS VARCHAR), MILLIS_TO_TIMESTAMP(l1), 10) FROM druid.numfoo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "(\"cnt\" + 1)", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v1", "(\"m1\" + 1)", ColumnType.FLOAT), CalciteQueryTest.expressionVirtualColumn("v2", "concat(\"dim1\",CAST(\"cnt\", 'STRING'))", ColumnType.STRING)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongLastAggregatorFactory("a0", "cnt", null), new FloatLastAggregatorFactory("a1", "m1", null), new StringLastAggregatorFactory("a2", "dim1", null, Integer.valueOf(10)), new LongLastAggregatorFactory("a3", "v0", null), new FloatLastAggregatorFactory("a4", "v1", null), new StringLastAggregatorFactory("a5", "v2", null, Integer.valueOf(10)), new LongLastAggregatorFactory("a6", "cnt", "l1"), new FloatLastAggregatorFactory("a7", "m1", "l1"), new StringLastAggregatorFactory("a8", "dim1", "l1", Integer.valueOf(10)), new LongLastAggregatorFactory("a9", "v0", "l1"), new FloatLastAggregatorFactory("a10", "v1", "l1"), new StringLastAggregatorFactory("a11", "v2", "l1", Integer.valueOf(10))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, Float.valueOf(6.0f), "abc", 2L, Float.valueOf(7.0f), "abc1", 1L, Float.valueOf(2.0f), "10.1", 2L, Float.valueOf(3.0f), "10.11"}));
    }

    @Test
    public void testEarliestByInvalidTimestamp() throws Exception {
        this.expectedException.expect(SqlPlanningException.class);
        this.expectedException.expectMessage("Cannot apply 'EARLIEST_BY' to arguments of type 'EARLIEST_BY(<FLOAT>, <BIGINT>)");
        this.testQuery("SELECT EARLIEST_BY(m1, l1) FROM druid.numfoo", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testLatestByInvalidTimestamp() throws Exception {
        this.expectedException.expect(SqlPlanningException.class);
        this.expectedException.expectMessage("Cannot apply 'LATEST_BY' to arguments of type 'LATEST_BY(<FLOAT>, <BIGINT>)");
        this.testQuery("SELECT LATEST_BY(m1, l1) FROM druid.numfoo", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testAnyAggregator() throws Exception {
        this.skipVectorize();
        this.testQuery("SELECT ANY_VALUE(cnt), ANY_VALUE(m1), ANY_VALUE(m2), ANY_VALUE(dim1, 10), ANY_VALUE(cnt + 1), ANY_VALUE(m1 + 1), ANY_VALUE(dim1 || CAST(cnt AS VARCHAR), 10) FROM druid.foo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "(\"cnt\" + 1)", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v1", "(\"m1\" + 1)", ColumnType.FLOAT), CalciteQueryTest.expressionVirtualColumn("v2", "concat(\"dim1\",CAST(\"cnt\", 'STRING'))", ColumnType.STRING)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongAnyAggregatorFactory("a0", "cnt"), new FloatAnyAggregatorFactory("a1", "m1"), new DoubleAnyAggregatorFactory("a2", "m2"), new StringAnyAggregatorFactory("a3", "dim1", Integer.valueOf(10)), new LongAnyAggregatorFactory("a4", "v0"), new FloatAnyAggregatorFactory("a5", "v1"), new StringAnyAggregatorFactory("a6", "v2", Integer.valueOf(10))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)new Object[]{1L, Float.valueOf(1.0f), 1.0, "", 2L, Float.valueOf(2.0f), "1"}) : ImmutableList.of((Object)new Object[]{1L, Float.valueOf(1.0f), 1.0, "", 2L, Float.valueOf(2.0f), "1"})));
    }

    @Test
    public void testAnyAggregatorsOnHeapNumericNulls() throws Exception {
        this.testQuery("SELECT ANY_VALUE(l1), ANY_VALUE(d1), ANY_VALUE(f1) FROM druid.numfoo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongAnyAggregatorFactory("a0", "l1"), new DoubleAnyAggregatorFactory("a1", "d1"), new FloatAnyAggregatorFactory("a2", "f1")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{7L, 1.0, Float.valueOf(1.0f)}));
    }

    @Test
    public void testAnyAggregatorsOffHeapNumericNulls() throws Exception {
        this.testQuery("SELECT ANY_VALUE(l1), ANY_VALUE(d1), ANY_VALUE(f1) FROM druid.numfoo GROUP BY dim2", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "_d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongAnyAggregatorFactory("a0", "l1"), new DoubleAnyAggregatorFactory("a1", "d1"), new FloatAnyAggregatorFactory("a2", "f1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)new Object[]{325323L, 1.7, Float.valueOf(0.1f)}, (Object)new Object[]{0L, 0.0, Float.valueOf(0.0f)}, (Object)new Object[]{7L, 1.0, Float.valueOf(1.0f)}, (Object)new Object[]{null, null, null}) : ImmutableList.of((Object)new Object[]{325323L, 1.7, Float.valueOf(0.1f)}, (Object)new Object[]{7L, 1.0, Float.valueOf(1.0f)}, (Object)new Object[]{0L, 0.0, Float.valueOf(0.0f)})));
    }

    @Test
    public void testPrimitiveLatestInSubquery() throws Exception {
        this.skipVectorize();
        this.testQuery("SELECT SUM(val1), SUM(val2), SUM(val3) FROM (SELECT dim2, LATEST(m1) AS val1, LATEST(cnt) AS val2, LATEST(m2) AS val3 FROM foo GROUP BY dim2)", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FloatLastAggregatorFactory("a0:a", "m1", null), new LongLastAggregatorFactory("a1:a", "cnt", null), new DoubleLastAggregatorFactory("a2:a", "m2", null)})).setPostAggregatorSpecs((List)ImmutableList.of((Object)new FinalizingFieldAccessPostAggregator("a0", "a0:a"), (Object)new FinalizingFieldAccessPostAggregator("a1", "a1:a"), (Object)new FinalizingFieldAccessPostAggregator("a2", "a2:a"))).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("_a0", "a0"), new LongSumAggregatorFactory("_a1", "a1"), new DoubleSumAggregatorFactory("_a2", "a2")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)new Object[]{18.0, 4L, 18.0}) : ImmutableList.of((Object)new Object[]{15.0, 3L, 15.0})));
    }

    @Test
    public void testPrimitiveEarliestInSubquery() throws Exception {
        this.skipVectorize();
        this.testQuery("SELECT SUM(val1), SUM(val2), SUM(val3) FROM (SELECT dim2, EARLIEST(m1) AS val1, EARLIEST(cnt) AS val2, EARLIEST(m2) AS val3 FROM foo GROUP BY dim2)", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FloatFirstAggregatorFactory("a0:a", "m1", null), new LongFirstAggregatorFactory("a1:a", "cnt", null), new DoubleFirstAggregatorFactory("a2:a", "m2", null)})).setPostAggregatorSpecs((List)ImmutableList.of((Object)new FinalizingFieldAccessPostAggregator("a0", "a0:a"), (Object)new FinalizingFieldAccessPostAggregator("a1", "a1:a"), (Object)new FinalizingFieldAccessPostAggregator("a2", "a2:a"))).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("_a0", "a0"), new LongSumAggregatorFactory("_a1", "a1"), new DoubleSumAggregatorFactory("_a2", "a2")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)new Object[]{11.0, 4L, 11.0}) : ImmutableList.of((Object)new Object[]{8.0, 3L, 8.0})));
    }

    @Test
    public void testStringLatestInSubquery() throws Exception {
        this.skipVectorize();
        this.testQuery("SELECT SUM(val) FROM (SELECT dim2, LATEST(dim1, 10) AS val FROM foo GROUP BY dim2)", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new StringLastAggregatorFactory("a0:a", "dim1", null, Integer.valueOf(10))})).setPostAggregatorSpecs((List)ImmutableList.of((Object)new FinalizingFieldAccessPostAggregator("a0", "a0:a"))).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "CAST(\"a0\", 'DOUBLE')", ColumnType.DOUBLE)}).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("_a0", "v0", null, ExprMacroTable.nil())})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{NullHandling.sqlCompatible() ? 3.0 : 1.0}));
    }

    @Test
    public void testStringEarliestInSubquery() throws Exception {
        this.skipVectorize();
        this.testQuery("SELECT SUM(val) FROM (SELECT dim2, EARLIEST(dim1, 10) AS val FROM foo GROUP BY dim2)", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new StringFirstAggregatorFactory("a0:a", "dim1", null, Integer.valueOf(10))})).setPostAggregatorSpecs((List)ImmutableList.of((Object)new FinalizingFieldAccessPostAggregator("a0", "a0:a"))).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "CAST(\"a0\", 'DOUBLE')", ColumnType.DOUBLE)}).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("_a0", "v0", null, ExprMacroTable.nil())})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{NullHandling.sqlCompatible() ? 12.1 : 10.1}));
    }

    @Test
    public void testPrimitiveAnyInSubquery() throws Exception {
        this.testQuery("SELECT SUM(val1), SUM(val2), SUM(val3) FROM (SELECT dim2, ANY_VALUE(m1) AS val1, ANY_VALUE(cnt) AS val2, ANY_VALUE(m2) AS val3 FROM foo GROUP BY dim2)", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FloatAnyAggregatorFactory("a0:a", "m1"), new LongAnyAggregatorFactory("a1:a", "cnt"), new DoubleAnyAggregatorFactory("a2:a", "m2")})).setPostAggregatorSpecs((List)ImmutableList.of((Object)new FinalizingFieldAccessPostAggregator("a0", "a0:a"), (Object)new FinalizingFieldAccessPostAggregator("a1", "a1:a"), (Object)new FinalizingFieldAccessPostAggregator("a2", "a2:a"))).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("_a0", "a0"), new LongSumAggregatorFactory("_a1", "a1"), new DoubleSumAggregatorFactory("_a2", "a2")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)new Object[]{11.0, 4L, 11.0}) : ImmutableList.of((Object)new Object[]{8.0, 3L, 8.0})));
    }

    @Test
    public void testStringAnyInSubquery() throws Exception {
        this.testQuery("SELECT SUM(val) FROM (SELECT dim2, ANY_VALUE(dim1, 10) AS val FROM foo GROUP BY dim2)", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new StringAnyAggregatorFactory("a0:a", "dim1", Integer.valueOf(10))})).setPostAggregatorSpecs((List)ImmutableList.of((Object)new FinalizingFieldAccessPostAggregator("a0", "a0:a"))).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "CAST(\"a0\", 'DOUBLE')", ColumnType.DOUBLE)}).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("_a0", "v0", null, ExprMacroTable.nil())})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{NullHandling.sqlCompatible() ? 12.1 : 10.1}));
    }

    @Test
    public void testEarliestAggregatorsNumericNulls() throws Exception {
        this.skipVectorize();
        this.testQuery("SELECT EARLIEST(l1), EARLIEST(d1), EARLIEST(f1) FROM druid.numfoo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongFirstAggregatorFactory("a0", "l1", null), new DoubleFirstAggregatorFactory("a1", "d1", null), new FloatFirstAggregatorFactory("a2", "f1", null)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{7L, 1.0, Float.valueOf(1.0f)}));
    }

    @Test
    public void testLatestAggregatorsNumericNull() throws Exception {
        this.skipVectorize();
        this.testQuery("SELECT LATEST(l1), LATEST(d1), LATEST(f1) FROM druid.numfoo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongLastAggregatorFactory("a0", "l1", null), new DoubleLastAggregatorFactory("a1", "d1", null), new FloatLastAggregatorFactory("a2", "f1", null)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{NullHandling.defaultLongValue(), NullHandling.defaultDoubleValue(), NullHandling.defaultFloatValue()}));
    }

    @Test
    public void testFirstLatestAggregatorsSkipNulls() throws Exception {
        this.skipVectorize();
        Object filter = this.useDefault ? CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", null, null)) : CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", null, null)), CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("l1", null, null)), CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("d1", null, null)), CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("f1", null, null))});
        this.testQuery("SELECT EARLIEST(dim1, 32), LATEST(l1), LATEST(d1), LATEST(f1) FROM druid.numfoo WHERE dim1 IS NOT NULL AND l1 IS NOT NULL AND d1 IS NOT NULL AND f1 is NOT NULL", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)filter).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new StringFirstAggregatorFactory("a0", "dim1", null, Integer.valueOf(32)), new LongLastAggregatorFactory("a1", "l1", null), new DoubleLastAggregatorFactory("a2", "d1", null), new FloatLastAggregatorFactory("a3", "f1", null)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{this.useDefault ? "10.1" : "", 0L, 0.0, Float.valueOf(0.0f)}));
    }

    @Test
    public void testAnyAggregatorsDoesNotSkipNulls() throws Exception {
        Object[] objectArray;
        ImmutableList immutableList = ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new StringAnyAggregatorFactory("a0", "dim1", Integer.valueOf(32)), new LongAnyAggregatorFactory("a1", "l2"), new DoubleAnyAggregatorFactory("a2", "d2"), new FloatAnyAggregatorFactory("a3", "f2")})).context(QUERY_CONTEXT_DEFAULT).build());
        if (this.useDefault) {
            Object[] objectArray2 = new Object[4];
            objectArray2[0] = "";
            objectArray2[1] = 0L;
            objectArray2[2] = 0.0;
            objectArray = objectArray2;
            objectArray2[3] = Float.valueOf(0.0f);
        } else {
            Object[] objectArray3 = new Object[4];
            objectArray3[0] = "";
            objectArray3[1] = null;
            objectArray3[2] = null;
            objectArray = objectArray3;
            objectArray3[3] = null;
        }
        this.testQuery("SELECT ANY_VALUE(dim1, 32), ANY_VALUE(l2), ANY_VALUE(d2), ANY_VALUE(f2) FROM druid.numfoo", (List<Query>)immutableList, (List<Object[]>)ImmutableList.of((Object)objectArray));
    }

    @Test
    public void testAnyAggregatorsSkipNullsWithFilter() throws Exception {
        Object filter = this.useDefault ? CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", null, null)) : CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", null, null)), CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("l2", null, null)), CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("d2", null, null)), CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("f2", null, null))});
        this.testQuery("SELECT ANY_VALUE(dim1, 32), ANY_VALUE(l2), ANY_VALUE(d2), ANY_VALUE(f2) FROM druid.numfoo WHERE dim1 IS NOT NULL AND l2 IS NOT NULL AND d2 IS NOT NULL AND f2 is NOT NULL", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)filter).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new StringAnyAggregatorFactory("a0", "dim1", Integer.valueOf(32)), new LongAnyAggregatorFactory("a1", "l2"), new DoubleAnyAggregatorFactory("a2", "d2"), new FloatAnyAggregatorFactory("a3", "f2")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", 325323L, 1.7, Float.valueOf(0.1f)}));
    }

    @Test
    public void testOrderByEarliestFloat() throws Exception {
        this.skipVectorize();
        ImmutableList expected = NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"1", Float.valueOf(0.0f)}, (Object)new Object[]{"2", Float.valueOf(0.0f)}, (Object)new Object[]{"abc", Float.valueOf(0.0f)}, (Object)new Object[]{"def", Float.valueOf(0.0f)}, (Object)new Object[]{"10.1", Float.valueOf(0.1f)}, (Object)new Object[]{"", Float.valueOf(1.0f)}) : ImmutableList.of((Object)new Object[]{"1", null}, (Object)new Object[]{"abc", null}, (Object)new Object[]{"def", null}, (Object)new Object[]{"2", Float.valueOf(0.0f)}, (Object)new Object[]{"10.1", Float.valueOf(0.1f)}, (Object)new Object[]{"", Float.valueOf(1.0f)});
        this.testQuery("SELECT dim1, EARLIEST(f1) FROM druid.numfoo GROUP BY 1 ORDER BY 2 LIMIT 10", (List<Query>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "_d0")).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FloatFirstAggregatorFactory("a0", "f1", null)})).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new NumericTopNMetricSpec("a0"))).threshold(10).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testOrderByEarliestDouble() throws Exception {
        this.skipVectorize();
        ImmutableList expected = NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"1", 0.0}, (Object)new Object[]{"2", 0.0}, (Object)new Object[]{"abc", 0.0}, (Object)new Object[]{"def", 0.0}, (Object)new Object[]{"", 1.0}, (Object)new Object[]{"10.1", 1.7}) : ImmutableList.of((Object)new Object[]{"1", null}, (Object)new Object[]{"abc", null}, (Object)new Object[]{"def", null}, (Object)new Object[]{"2", 0.0}, (Object)new Object[]{"", 1.0}, (Object)new Object[]{"10.1", 1.7});
        this.testQuery("SELECT dim1, EARLIEST(d1) FROM druid.numfoo GROUP BY 1 ORDER BY 2 LIMIT 10", (List<Query>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "_d0")).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleFirstAggregatorFactory("a0", "d1", null)})).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new NumericTopNMetricSpec("a0"))).threshold(10).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testOrderByEarliestLong() throws Exception {
        this.skipVectorize();
        ImmutableList expected = NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"1", 0L}, (Object)new Object[]{"2", 0L}, (Object)new Object[]{"abc", 0L}, (Object)new Object[]{"def", 0L}, (Object)new Object[]{"", 7L}, (Object)new Object[]{"10.1", 325323L}) : ImmutableList.of((Object)new Object[]{"1", null}, (Object)new Object[]{"abc", null}, (Object)new Object[]{"def", null}, (Object)new Object[]{"2", 0L}, (Object)new Object[]{"", 7L}, (Object)new Object[]{"10.1", 325323L});
        this.testQuery("SELECT dim1, EARLIEST(l1) FROM druid.numfoo GROUP BY 1 ORDER BY 2 LIMIT 10", (List<Query>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "_d0")).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongFirstAggregatorFactory("a0", "l1", null)})).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new NumericTopNMetricSpec("a0"))).threshold(10).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testOrderByLatestFloat() throws Exception {
        this.skipVectorize();
        ImmutableList expected = NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"1", Float.valueOf(0.0f)}, (Object)new Object[]{"2", Float.valueOf(0.0f)}, (Object)new Object[]{"abc", Float.valueOf(0.0f)}, (Object)new Object[]{"def", Float.valueOf(0.0f)}, (Object)new Object[]{"10.1", Float.valueOf(0.1f)}, (Object)new Object[]{"", Float.valueOf(1.0f)}) : ImmutableList.of((Object)new Object[]{"1", null}, (Object)new Object[]{"abc", null}, (Object)new Object[]{"def", null}, (Object)new Object[]{"2", Float.valueOf(0.0f)}, (Object)new Object[]{"10.1", Float.valueOf(0.1f)}, (Object)new Object[]{"", Float.valueOf(1.0f)});
        this.testQuery("SELECT dim1, LATEST(f1) FROM druid.numfoo GROUP BY 1 ORDER BY 2 LIMIT 10", (List<Query>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "_d0")).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FloatLastAggregatorFactory("a0", "f1", null)})).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new NumericTopNMetricSpec("a0"))).threshold(10).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testOrderByLatestDouble() throws Exception {
        this.skipVectorize();
        ImmutableList expected = NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"1", 0.0}, (Object)new Object[]{"2", 0.0}, (Object)new Object[]{"abc", 0.0}, (Object)new Object[]{"def", 0.0}, (Object)new Object[]{"", 1.0}, (Object)new Object[]{"10.1", 1.7}) : ImmutableList.of((Object)new Object[]{"1", null}, (Object)new Object[]{"abc", null}, (Object)new Object[]{"def", null}, (Object)new Object[]{"2", 0.0}, (Object)new Object[]{"", 1.0}, (Object)new Object[]{"10.1", 1.7});
        this.testQuery("SELECT dim1, LATEST(d1) FROM druid.numfoo GROUP BY 1 ORDER BY 2 LIMIT 10", (List<Query>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "_d0")).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleLastAggregatorFactory("a0", "d1", null)})).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new NumericTopNMetricSpec("a0"))).threshold(10).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testOrderByLatestLong() throws Exception {
        this.skipVectorize();
        ImmutableList expected = NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"1", 0L}, (Object)new Object[]{"2", 0L}, (Object)new Object[]{"abc", 0L}, (Object)new Object[]{"def", 0L}, (Object)new Object[]{"", 7L}, (Object)new Object[]{"10.1", 325323L}) : ImmutableList.of((Object)new Object[]{"1", null}, (Object)new Object[]{"abc", null}, (Object)new Object[]{"def", null}, (Object)new Object[]{"2", 0L}, (Object)new Object[]{"", 7L}, (Object)new Object[]{"10.1", 325323L});
        this.testQuery("SELECT dim1, LATEST(l1) FROM druid.numfoo GROUP BY 1 ORDER BY 2 LIMIT 10", (List<Query>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "_d0")).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongLastAggregatorFactory("a0", "l1", null)})).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new NumericTopNMetricSpec("a0"))).threshold(10).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testOrderByAnyFloat() throws Exception {
        ImmutableList expected = NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"1", Float.valueOf(0.0f)}, (Object)new Object[]{"2", Float.valueOf(0.0f)}, (Object)new Object[]{"abc", Float.valueOf(0.0f)}, (Object)new Object[]{"def", Float.valueOf(0.0f)}, (Object)new Object[]{"10.1", Float.valueOf(0.1f)}, (Object)new Object[]{"", Float.valueOf(1.0f)}) : ImmutableList.of((Object)new Object[]{"2", Float.valueOf(0.0f)}, (Object)new Object[]{"10.1", Float.valueOf(0.1f)}, (Object)new Object[]{"", Float.valueOf(1.0f)}, (Object)new Object[]{"1", null}, (Object)new Object[]{"abc", null}, (Object)new Object[]{"def", null});
        this.testQuery("SELECT dim1, ANY_VALUE(f1) FROM druid.numfoo GROUP BY 1 ORDER BY 2 LIMIT 10", (List<Query>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "_d0")).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FloatAnyAggregatorFactory("a0", "f1")})).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new NumericTopNMetricSpec("a0"))).threshold(10).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testOrderByAnyDouble() throws Exception {
        ImmutableList expected = NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"1", 0.0}, (Object)new Object[]{"2", 0.0}, (Object)new Object[]{"abc", 0.0}, (Object)new Object[]{"def", 0.0}, (Object)new Object[]{"", 1.0}, (Object)new Object[]{"10.1", 1.7}) : ImmutableList.of((Object)new Object[]{"2", 0.0}, (Object)new Object[]{"", 1.0}, (Object)new Object[]{"10.1", 1.7}, (Object)new Object[]{"1", null}, (Object)new Object[]{"abc", null}, (Object)new Object[]{"def", null});
        this.testQuery("SELECT dim1, ANY_VALUE(d1) FROM druid.numfoo GROUP BY 1 ORDER BY 2 LIMIT 10", (List<Query>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "_d0")).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleAnyAggregatorFactory("a0", "d1")})).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new NumericTopNMetricSpec("a0"))).threshold(10).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testOrderByAnyLong() throws Exception {
        ImmutableList expected = NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"1", 0L}, (Object)new Object[]{"2", 0L}, (Object)new Object[]{"abc", 0L}, (Object)new Object[]{"def", 0L}, (Object)new Object[]{"", 7L}, (Object)new Object[]{"10.1", 325323L}) : ImmutableList.of((Object)new Object[]{"2", 0L}, (Object)new Object[]{"", 7L}, (Object)new Object[]{"10.1", 325323L}, (Object)new Object[]{"1", null}, (Object)new Object[]{"abc", null}, (Object)new Object[]{"def", null});
        this.testQuery("SELECT dim1, ANY_VALUE(l1) FROM druid.numfoo GROUP BY 1 ORDER BY 2 LIMIT 10", (List<Query>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "_d0")).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongAnyAggregatorFactory("a0", "l1")})).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new NumericTopNMetricSpec("a0"))).threshold(10).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testGroupByLong() throws Exception {
        this.testQuery("SELECT cnt, COUNT(*) FROM druid.foo GROUP BY cnt", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("cnt", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, 6L}));
    }

    @Test
    public void testGroupByOrdinal() throws Exception {
        this.testQuery("SELECT cnt, COUNT(*) FROM druid.foo GROUP BY 1", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("cnt", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, 6L}));
    }

    @Test
    @Ignore(value="Disabled since GROUP BY alias can confuse the validator; see DruidConformance::isGroupByAlias")
    public void testGroupByAndOrderByAlias() throws Exception {
        this.testQuery("SELECT cnt AS theCnt, COUNT(*) FROM druid.foo GROUP BY theCnt ORDER BY theCnt ASC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("cnt", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)DefaultLimitSpec.builder().orderBy(new OrderByColumnSpec[]{new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)}).build()).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, 6L}));
    }

    @Test
    public void testGroupByExpressionAliasedAsOriginalColumnName() throws Exception {
        this.testQuery("SELECT\nFLOOR(__time TO MONTH) AS __time,\nCOUNT(*)\nFROM druid.foo\nGROUP BY FLOOR(__time TO MONTH)", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.MONTH).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteQueryTest.timestamp("2000-01-01"), 3L}, (Object)new Object[]{CalciteQueryTest.timestamp("2001-01-01"), 3L}));
    }

    @Test
    public void testGroupByAndOrderByOrdinalOfAlias() throws Exception {
        this.testQuery("SELECT cnt as theCnt, COUNT(*) FROM druid.foo GROUP BY 1 ORDER BY 1 ASC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("cnt", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)DefaultLimitSpec.builder().orderBy(new OrderByColumnSpec[]{new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)}).build()).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, 6L}));
    }

    @Test
    public void testGroupByFloat() throws Exception {
        this.testQuery("SELECT m1, COUNT(*) FROM druid.foo GROUP BY m1", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("m1", "d0", ColumnType.FLOAT)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(1.0f), 1L}, (Object)new Object[]{Float.valueOf(2.0f), 1L}, (Object)new Object[]{Float.valueOf(3.0f), 1L}, (Object)new Object[]{Float.valueOf(4.0f), 1L}, (Object)new Object[]{Float.valueOf(5.0f), 1L}, (Object)new Object[]{Float.valueOf(6.0f), 1L}));
    }

    @Test
    public void testGroupByDouble() throws Exception {
        this.testQuery("SELECT m2, COUNT(*) FROM druid.foo GROUP BY m2", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("m2", "d0", ColumnType.DOUBLE)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1.0, 1L}, (Object)new Object[]{2.0, 1L}, (Object)new Object[]{3.0, 1L}, (Object)new Object[]{4.0, 1L}, (Object)new Object[]{5.0, 1L}, (Object)new Object[]{6.0, 1L}));
    }

    @Test
    public void testFilterOnFloat() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE m1 = 1.0", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).filters((DimFilter)CalciteQueryTest.selector("m1", "1.0", null)).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testFilterOnDouble() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE m2 = 1.0", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).filters((DimFilter)CalciteQueryTest.selector("m2", "1.0", null)).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testHavingOnGrandTotal() throws Exception {
        this.testQuery("SELECT SUM(m1) AS m1_sum FROM foo HAVING m1_sum = 21", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1")})).setHavingSpec((HavingSpec)CalciteQueryTest.having((DimFilter)CalciteQueryTest.selector("a0", "21", null))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{21.0}));
    }

    @Test
    public void testHavingOnDoubleSum() throws Exception {
        this.testQuery("SELECT dim1, SUM(m1) AS m1_sum FROM druid.foo GROUP BY dim1 HAVING SUM(m1) > 1", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1")})).setHavingSpec((HavingSpec)CalciteQueryTest.having((DimFilter)new BoundDimFilter("a0", "1", null, Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"1", 4.0}, (Object)new Object[]{"10.1", 2.0}, (Object)new Object[]{"2", 3.0}, (Object)new Object[]{"abc", 6.0}, (Object)new Object[]{"def", 5.0}));
    }

    @Test
    public void testHavingOnApproximateCountDistinct() throws Exception {
        this.testQuery("SELECT dim2, COUNT(DISTINCT m1) FROM druid.foo GROUP BY dim2 HAVING COUNT(DISTINCT m1) > 1", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CardinalityAggregatorFactory("a0", null, (List)ImmutableList.of((Object)new DefaultDimensionSpec("m1", "m1", ColumnType.FLOAT)), false, true)})).setHavingSpec((HavingSpec)CalciteQueryTest.having((DimFilter)CalciteQueryTest.bound("a0", "1", null, true, false, null, StringComparators.NUMERIC))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"", 3L}, (Object)new Object[]{"a", 2L}) : ImmutableList.of((Object)new Object[]{null, 2L}, (Object)new Object[]{"a", 2L})));
    }

    @Test
    public void testHavingOnExactCountDistinct() throws Exception {
        this.testQuery(PLANNER_CONFIG_NO_HLL, "SELECT dim2, COUNT(DISTINCT m1) FROM druid.foo GROUP BY dim2 HAVING COUNT(DISTINCT m1) > 1", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0", ColumnType.STRING), new DefaultDimensionSpec("m1", "d1", ColumnType.FLOAT)})).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("d0", "_d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{this.useDefault ? new CountAggregatorFactory("a0") : new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("d1", null, null)))})).setHavingSpec((HavingSpec)CalciteQueryTest.having((DimFilter)CalciteQueryTest.bound("a0", "1", null, true, false, null, StringComparators.NUMERIC))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"", 3L}, (Object)new Object[]{"a", 2L}) : ImmutableList.of((Object)new Object[]{null, 2L}, (Object)new Object[]{"a", 2L})));
    }

    @Test
    public void testExactCountDistinctWithFilter() throws Exception {
        String sqlQuery = "SELECT COUNT(DISTINCT foo.dim1) FILTER(WHERE foo.cnt = 1), SUM(foo.cnt) FROM druid.foo";
        try {
            this.testQuery(PLANNER_CONFIG_NO_HLL.withOverrides(new QueryContext((Map)ImmutableMap.of((Object)"useGroupingSetForExactDistinct", (Object)"false"))), "SELECT COUNT(DISTINCT foo.dim1) FILTER(WHERE foo.cnt = 1), SUM(foo.cnt) FROM druid.foo", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
            Assert.fail((String)"query execution should fail");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Error while applying rule AggregateExpandDistinctAggregatesRule"));
        }
        this.requireMergeBuffers(3);
        this.testQuery(PLANNER_CONFIG_NO_HLL.withOverrides(new QueryContext((Map)ImmutableMap.of((Object)"useGroupingSetForExactDistinct", (Object)"true"))), "SELECT COUNT(DISTINCT foo.dim1) FILTER(WHERE foo.cnt = 1), SUM(foo.cnt) FROM druid.foo", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", NullHandling.replaceWithDefault() ? "(\"cnt\" == 1)" : "((\"cnt\" == 1) > 0)", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt"), new GroupingAggregatorFactory("a1", Arrays.asList("dim1", "v0"))})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0", (Object)"d1"), (Object)ImmutableList.of())).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("_a0"), (DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("d0", null, null)), CalciteQueryTest.selector("a1", "0", null)})), new FilteredAggregatorFactory((AggregatorFactory)new LongMinAggregatorFactory("_a1", "a0"), (DimFilter)CalciteQueryTest.selector("a1", "3", null))})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{NullHandling.replaceWithDefault() ? 5L : 6L, 6L}));
    }

    @Test
    public void testHavingOnFloatSum() throws Exception {
        this.testQuery("SELECT dim1, CAST(SUM(m1) AS FLOAT) AS m1_sum FROM druid.foo GROUP BY dim1 HAVING CAST(SUM(m1) AS FLOAT) > 1", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1")})).setHavingSpec((HavingSpec)CalciteQueryTest.having((DimFilter)new BoundDimFilter("a0", "1", null, Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, StringComparators.NUMERIC))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"1", Float.valueOf(4.0f)}, (Object)new Object[]{"10.1", Float.valueOf(2.0f)}, (Object)new Object[]{"2", Float.valueOf(3.0f)}, (Object)new Object[]{"abc", Float.valueOf(6.0f)}, (Object)new Object[]{"def", Float.valueOf(5.0f)}));
    }

    @Test
    public void testColumnComparison() throws Exception {
        this.testQuery("SELECT dim1, m1, COUNT(*) FROM druid.foo WHERE m1 - 1 = dim1 GROUP BY dim1, m1", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteQueryTest.expressionFilter("((\"m1\" - 1) == CAST(\"dim1\", 'DOUBLE'))")).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("m1", "d1", ColumnType.FLOAT)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"", Float.valueOf(1.0f), 1L}, (Object)new Object[]{"2", Float.valueOf(3.0f), 1L}) : ImmutableList.of((Object)new Object[]{"2", Float.valueOf(3.0f), 1L})));
    }

    @Test
    public void testHavingOnRatio() throws Exception {
        this.testQuery("SELECT\n  dim1,\n  COUNT(*) FILTER(WHERE dim2 <> 'a')/COUNT(*) as ratio\nFROM druid.foo\nGROUP BY dim1\nHAVING COUNT(*) FILTER(WHERE dim2 <> 'a')/COUNT(*) = 1", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim2", "a", null))), new CountAggregatorFactory("a1")})).setPostAggregatorSpecs((List)ImmutableList.of((Object)CalciteQueryTest.expressionPostAgg("p0", "(\"a0\" / \"a1\")"))).setHavingSpec((HavingSpec)CalciteQueryTest.having((DimFilter)CalciteQueryTest.expressionFilter("((\"a0\" / \"a1\") == 1)"))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", 1L}, (Object)new Object[]{"2", 1L}, (Object)new Object[]{"abc", 1L}, (Object)new Object[]{"def", 1L}));
    }

    @Test
    public void testGroupByWithSelectProjections() throws Exception {
        this.testQuery("SELECT\n  dim1,  SUBSTRING(dim1, 2)\nFROM druid.foo\nGROUP BY dim1\n", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setPostAggregatorSpecs((List)ImmutableList.of((Object)CalciteQueryTest.expressionPostAgg("p0", "substring(\"d0\", 1, -1)"))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", NULL_STRING}, (Object)new Object[]{"1", NULL_STRING}, (Object)new Object[]{"10.1", "0.1"}, (Object)new Object[]{"2", NULL_STRING}, (Object)new Object[]{"abc", "bc"}, (Object)new Object[]{"def", "ef"}));
    }

    @Test
    public void testGroupByWithSelectAndOrderByProjections() throws Exception {
        this.testQuery("SELECT\n  dim1,  SUBSTRING(dim1, 2)\nFROM druid.foo\nGROUP BY dim1\nORDER BY CHARACTER_LENGTH(dim1) DESC, dim1", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setPostAggregatorSpecs((List)ImmutableList.of((Object)CalciteQueryTest.expressionPostAgg("p0", "substring(\"d0\", 1, -1)"), (Object)CalciteQueryTest.expressionPostAgg("p1", "strlen(\"d0\")"))).setLimitSpec((LimitSpec)DefaultLimitSpec.builder().orderBy(new OrderByColumnSpec[]{new OrderByColumnSpec("p1", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC), new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC)}).build()).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", "0.1"}, (Object)new Object[]{"abc", "bc"}, (Object)new Object[]{"def", "ef"}, (Object)new Object[]{"1", NULL_STRING}, (Object)new Object[]{"2", NULL_STRING}, (Object)new Object[]{"", NULL_STRING}));
    }

    @Test
    public void testTopNWithSelectProjections() throws Exception {
        this.testQuery("SELECT\n  dim1,  SUBSTRING(dim1, 2)\nFROM druid.foo\nGROUP BY dim1\nLIMIT 10", (List<Query>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0")).postAggregators(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("s0", "substring(\"d0\", 1, -1)")}).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC)).threshold(10).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", NULL_STRING}, (Object)new Object[]{"1", NULL_STRING}, (Object)new Object[]{"10.1", "0.1"}, (Object)new Object[]{"2", NULL_STRING}, (Object)new Object[]{"abc", "bc"}, (Object)new Object[]{"def", "ef"}));
    }

    @Test
    public void testTopNWithSelectAndOrderByProjections() throws Exception {
        this.testQuery("SELECT\n  dim1,  SUBSTRING(dim1, 2)\nFROM druid.foo\nGROUP BY dim1\nORDER BY CHARACTER_LENGTH(dim1) DESC\nLIMIT 10", (List<Query>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0")).postAggregators(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("p0", "substring(\"d0\", 1, -1)"), CalciteQueryTest.expressionPostAgg("p1", "strlen(\"d0\")")}).metric((TopNMetricSpec)new NumericTopNMetricSpec("p1")).threshold(10).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", "0.1"}, (Object)new Object[]{"abc", "bc"}, (Object)new Object[]{"def", "ef"}, (Object)new Object[]{"1", NULL_STRING}, (Object)new Object[]{"2", NULL_STRING}, (Object)new Object[]{"", NULL_STRING}));
    }

    @Test
    public void testUnionAllQueries() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM foo UNION ALL SELECT SUM(cnt) FROM foo UNION ALL SELECT COUNT(*) FROM foo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build(), (Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(QUERY_CONTEXT_DEFAULT).build(), (Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}, (Object)new Object[]{6L}, (Object)new Object[]{6L}));
    }

    @Test
    public void testUnionAllQueriesWithLimit() throws Exception {
        this.testQuery("SELECT * FROM (SELECT COUNT(*) FROM foo UNION ALL SELECT SUM(cnt) FROM foo UNION ALL SELECT COUNT(*) FROM foo) LIMIT 2", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build(), (Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}, (Object)new Object[]{6L}));
    }

    @Test
    public void testUnionAllDifferentTablesWithMapping() throws Exception {
        this.testQuery("SELECT\ndim1, dim2, SUM(m1), COUNT(*)\nFROM (SELECT dim1, dim2, m1 FROM foo UNION ALL SELECT dim1, dim2, m1 FROM numfoo)\nWHERE dim2 = 'a' OR dim2 = 'def'\nGROUP BY 1, 2", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource("foo"), (Object)new TableDataSource("numfoo")))).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteQueryTest.in("dim2", (List<String>)ImmutableList.of((Object)"def", (Object)"a"), null)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")}).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1"), new CountAggregatorFactory("a1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", 2.0, 2L}, (Object)new Object[]{"1", "a", 8.0, 2L}));
    }

    @Test
    public void testJoinUnionAllDifferentTablesWithMapping() throws Exception {
        this.testQuery("SELECT\ndim1, dim2, SUM(m1), COUNT(*)\nFROM (SELECT dim1, dim2, m1 FROM foo UNION ALL SELECT dim1, dim2, m1 FROM numfoo)\nWHERE dim2 = 'a' OR dim2 = 'def'\nGROUP BY 1, 2", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource("foo"), (Object)new TableDataSource("numfoo")))).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteQueryTest.in("dim2", (List<String>)ImmutableList.of((Object)"def", (Object)"a"), null)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")}).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1"), new CountAggregatorFactory("a1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", 2.0, 2L}, (Object)new Object[]{"1", "a", 8.0, 2L}));
    }

    @Test
    public void testUnionAllTablesColumnCountMismatch() throws Exception {
        try {
            this.testQuery("SELECT\ndim1, dim2, SUM(m1), COUNT(*)\nFROM (SELECT * FROM foo UNION ALL SELECT * FROM numfoo)\nWHERE dim2 = 'a' OR dim2 = 'def'\nGROUP BY 1, 2", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
            Assert.fail((String)"query execution should fail");
        }
        catch (SqlPlanningException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Column count mismatch in UNION ALL"));
            Assert.assertEquals((Object)SqlPlanningException.PlanningError.VALIDATION_ERROR.getErrorCode(), (Object)e.getErrorCode());
            Assert.assertEquals((Object)SqlPlanningException.PlanningError.VALIDATION_ERROR.getErrorClass(), (Object)e.getErrorClass());
        }
    }

    @Test
    public void testUnionAllTablesColumnTypeMismatchFloatLong() throws Exception {
        this.testQuery("SELECT\ndim1, dim2, SUM(m1), COUNT(*)\nFROM (SELECT dim1, dim2, m1 FROM foo2 UNION ALL SELECT dim1, dim2, m1 FROM foo)\nWHERE dim2 = 'a' OR dim2 = 'en'\nGROUP BY 1, 2", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource("foo2"), (Object)new TableDataSource("foo")))).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteQueryTest.in("dim2", (List<String>)ImmutableList.of((Object)"en", (Object)"a"), null)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")}).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1"), new CountAggregatorFactory("a1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", 1.0, 1L}, (Object)new Object[]{"1", "a", 4.0, 1L}, (Object)new Object[]{"druid", "en", 1.0, 1L}));
    }

    @Test
    public void testUnionAllTablesColumnTypeMismatchStringLong() {
        this.assertQueryIsUnplannable("SELECT\ndim3, dim2, SUM(m1), COUNT(*)\nFROM (SELECT dim3, dim2, m1 FROM foo2 UNION ALL SELECT dim3, dim2, m1 FROM foo)\nWHERE dim2 = 'a' OR dim2 = 'en'\nGROUP BY 1, 2", "Possible error: SQL requires union between inputs that are not simple table scans and involve a filter or aliasing. Or column types of tables being unioned are not of same type.");
    }

    @Test
    public void testUnionAllTablesWhenMappingIsRequired() {
        this.assertQueryIsUnplannable("SELECT\nc, COUNT(*)\nFROM (SELECT dim1 AS c, m1 FROM foo UNION ALL SELECT dim2 AS c, m1 FROM numfoo)\nWHERE c = 'a' OR c = 'def'\nGROUP BY 1", "Possible error: SQL requires union between two tables and column names queried for each table are different Left: [dim1], Right: [dim2].");
    }

    @Test
    public void testUnionIsUnplannable() {
        this.assertQueryIsUnplannable("SELECT dim2, dim1, m1 FROM foo2 UNION SELECT dim1, dim2, m1 FROM foo", "Possible error: SQL requires 'UNION' but only 'UNION ALL' is supported.");
    }

    @Test
    public void testUnionAllTablesWhenCastAndMappingIsRequired() {
        this.assertQueryIsUnplannable("SELECT\nc, COUNT(*)\nFROM (SELECT dim1 AS c, m1 FROM foo UNION ALL SELECT cnt AS c, m1 FROM numfoo)\nWHERE c = 'a' OR c = 'def'\nGROUP BY 1", "Possible error: SQL requires union between inputs that are not simple table scans and involve a filter or aliasing. Or column types of tables being unioned are not of same type.");
    }

    @Test
    public void testUnionAllSameTableTwice() throws Exception {
        this.testQuery("SELECT\ndim1, dim2, SUM(m1), COUNT(*)\nFROM (SELECT * FROM foo UNION ALL SELECT * FROM foo)\nWHERE dim2 = 'a' OR dim2 = 'def'\nGROUP BY 1, 2", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource("foo"), (Object)new TableDataSource("foo")))).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteQueryTest.in("dim2", (List<String>)ImmutableList.of((Object)"def", (Object)"a"), null)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")}).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1"), new CountAggregatorFactory("a1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", 2.0, 2L}, (Object)new Object[]{"1", "a", 8.0, 2L}));
    }

    @Test
    public void testUnionAllSameTableTwiceWithSameMapping() throws Exception {
        this.testQuery("SELECT\ndim1, dim2, SUM(m1), COUNT(*)\nFROM (SELECT dim1, dim2, m1 FROM foo UNION ALL SELECT dim1, dim2, m1 FROM foo)\nWHERE dim2 = 'a' OR dim2 = 'def'\nGROUP BY 1, 2", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource("foo"), (Object)new TableDataSource("foo")))).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteQueryTest.in("dim2", (List<String>)ImmutableList.of((Object)"def", (Object)"a"), null)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")}).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1"), new CountAggregatorFactory("a1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", 2.0, 2L}, (Object)new Object[]{"1", "a", 8.0, 2L}));
    }

    @Test
    public void testUnionAllSameTableTwiceWithDifferentMapping() {
        this.assertQueryIsUnplannable("SELECT\ndim1, dim2, SUM(m1), COUNT(*)\nFROM (SELECT dim1, dim2, m1 FROM foo UNION ALL SELECT dim2, dim1, m1 FROM foo)\nWHERE dim2 = 'a' OR dim2 = 'def'\nGROUP BY 1, 2", "Possible error: SQL requires union between two tables and column names queried for each table are different Left: [dim1, dim2, m1], Right: [dim2, dim1, m1].");
    }

    @Test
    public void testUnionAllSameTableThreeTimes() throws Exception {
        this.testQuery("SELECT\ndim1, dim2, SUM(m1), COUNT(*)\nFROM (SELECT * FROM foo UNION ALL SELECT * FROM foo UNION ALL SELECT * FROM foo)\nWHERE dim2 = 'a' OR dim2 = 'def'\nGROUP BY 1, 2", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource("foo"), (Object)new TableDataSource("foo"), (Object)new TableDataSource("foo")))).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteQueryTest.in("dim2", (List<String>)ImmutableList.of((Object)"def", (Object)"a"), null)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")}).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1"), new CountAggregatorFactory("a1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", 3.0, 3L}, (Object)new Object[]{"1", "a", 12.0, 3L}));
    }

    @Test
    public void testUnionAllThreeTablesColumnCountMismatch1() throws Exception {
        try {
            this.testQuery("SELECT\ndim1, dim2, SUM(m1), COUNT(*)\nFROM (SELECT * FROM numfoo UNION ALL SELECT * FROM foo UNION ALL SELECT * from foo)\nWHERE dim2 = 'a' OR dim2 = 'def'\nGROUP BY 1, 2", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
            Assert.fail((String)"query execution should fail");
        }
        catch (SqlPlanningException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Column count mismatch in UNION ALL"));
            Assert.assertEquals((Object)SqlPlanningException.PlanningError.VALIDATION_ERROR.getErrorCode(), (Object)e.getErrorCode());
            Assert.assertEquals((Object)SqlPlanningException.PlanningError.VALIDATION_ERROR.getErrorClass(), (Object)e.getErrorClass());
        }
    }

    @Test
    public void testUnionAllThreeTablesColumnCountMismatch2() throws Exception {
        try {
            this.testQuery("SELECT\ndim1, dim2, SUM(m1), COUNT(*)\nFROM (SELECT * FROM numfoo UNION ALL SELECT * FROM foo UNION ALL SELECT * from foo)\nWHERE dim2 = 'a' OR dim2 = 'def'\nGROUP BY 1, 2", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
            Assert.fail((String)"query execution should fail");
        }
        catch (SqlPlanningException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Column count mismatch in UNION ALL"));
            Assert.assertEquals((Object)SqlPlanningException.PlanningError.VALIDATION_ERROR.getErrorCode(), (Object)e.getErrorCode());
            Assert.assertEquals((Object)SqlPlanningException.PlanningError.VALIDATION_ERROR.getErrorClass(), (Object)e.getErrorClass());
        }
    }

    @Test
    public void testUnionAllThreeTablesColumnCountMismatch3() throws Exception {
        try {
            this.testQuery("SELECT\ndim1, dim2, SUM(m1), COUNT(*)\nFROM (SELECT * FROM foo UNION ALL SELECT * FROM foo UNION ALL SELECT * from numfoo)\nWHERE dim2 = 'a' OR dim2 = 'def'\nGROUP BY 1, 2", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
            Assert.fail((String)"query execution should fail");
        }
        catch (SqlPlanningException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Column count mismatch in UNION ALL"));
            Assert.assertEquals((Object)SqlPlanningException.PlanningError.VALIDATION_ERROR.getErrorCode(), (Object)e.getErrorCode());
            Assert.assertEquals((Object)SqlPlanningException.PlanningError.VALIDATION_ERROR.getErrorClass(), (Object)e.getErrorClass());
        }
    }

    @Test
    public void testUnionAllSameTableThreeTimesWithSameMapping() throws Exception {
        this.testQuery("SELECT\ndim1, dim2, SUM(m1), COUNT(*)\nFROM (SELECT dim1, dim2, m1 FROM foo UNION ALL SELECT dim1, dim2, m1 FROM foo UNION ALL SELECT dim1, dim2, m1 FROM foo)\nWHERE dim2 = 'a' OR dim2 = 'def'\nGROUP BY 1, 2", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource("foo"), (Object)new TableDataSource("foo"), (Object)new TableDataSource("foo")))).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteQueryTest.in("dim2", (List<String>)ImmutableList.of((Object)"def", (Object)"a"), null)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")}).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1"), new CountAggregatorFactory("a1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", 3.0, 3L}, (Object)new Object[]{"1", "a", 12.0, 3L}));
    }

    @Test
    public void testPruneDeadAggregators() throws Exception {
        this.testQuery("SELECT\n  CASE 'foo'\n  WHEN 'bar' THEN SUM(cnt)\n  WHEN 'foo' THEN SUM(m1)\n  WHEN 'baz' THEN SUM(m2)\n  END\nFROM foo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{21.0}));
    }

    @Test
    public void testPruneDeadAggregatorsThroughPostProjection() throws Exception {
        this.testQuery("SELECT\n  CASE 'foo'\n  WHEN 'bar' THEN SUM(cnt) / 10\n  WHEN 'foo' THEN SUM(m1) / 10\n  WHEN 'baz' THEN SUM(m2) / 10\n  END\nFROM foo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1")})).postAggregators((List)ImmutableList.of((Object)CalciteQueryTest.expressionPostAgg("p0", "(\"a0\" / 10)"))).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2.1}));
    }

    @Test
    public void testPruneDeadAggregatorsThroughHaving() throws Exception {
        this.testQuery("SELECT\n  CASE 'foo'\n  WHEN 'bar' THEN SUM(cnt)\n  WHEN 'foo' THEN SUM(m1)\n  WHEN 'baz' THEN SUM(m2)\n  END AS theCase\nFROM foo\nHAVING theCase = 21", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1")})).setHavingSpec((HavingSpec)CalciteQueryTest.having((DimFilter)CalciteQueryTest.selector("a0", "21", null))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{21.0}));
    }

    @Test
    public void testGroupByCaseWhen() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT\n  CASE EXTRACT(DAY FROM __time)\n    WHEN m1 THEN 'match-m1'\n    WHEN cnt THEN 'match-cnt'\n    WHEN 0 THEN 'zero'    END,  COUNT(*)\nFROM druid.foo\nGROUP BY  CASE EXTRACT(DAY FROM __time)\n    WHEN m1 THEN 'match-m1'\n    WHEN cnt THEN 'match-cnt'\n    WHEN 0 THEN 'zero'    END", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "case_searched((CAST(timestamp_extract(\"__time\",'DAY','UTC'), 'DOUBLE') == \"m1\"),'match-m1',(timestamp_extract(\"__time\",'DAY','UTC') == \"cnt\"),'match-cnt',(timestamp_extract(\"__time\",'DAY','UTC') == 0),'zero'," + DruidExpression.nullLiteral() + ")", ColumnType.STRING)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{NullHandling.defaultStringValue(), 2L}, (Object)new Object[]{"match-cnt", 1L}, (Object)new Object[]{"match-m1", 3L}));
    }

    @Test
    public void testGroupByCaseWhenOfTripleAnd() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT\n  CASE WHEN m1 > 1 AND m1 < 5 AND cnt = 1 THEN 'x' ELSE NULL END,  COUNT(*)\nFROM druid.foo\nGROUP BY 1", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "case_searched(((\"m1\" > 1) && (\"m1\" < 5) && (\"cnt\" == 1)),'x',null)", ColumnType.STRING)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{NullHandling.defaultStringValue(), 3L}, (Object)new Object[]{"x", 3L}));
    }

    @Test
    public void testNullEmptyStringEquality() throws Exception {
        Object[] objectArray;
        ImmutableList immutableList = ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.or(new DimFilter[]{CalciteQueryTest.selector("dim2", "a", null), CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.selector("dim2", null, null), CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim2", "a", null))})})).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build());
        if (NullHandling.replaceWithDefault()) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = 5L;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = 4L;
        }
        this.testQuery("SELECT COUNT(*)\nFROM druid.foo\nWHERE NULLIF(dim2, 'a') IS NULL", (List<Query>)immutableList, (List<Object[]>)ImmutableList.of((Object)objectArray));
    }

    @Test
    public void testNullLongFilter() throws Exception {
        Object[] objectArray;
        ImmutableList immutableList = this.useDefault ? ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{0L}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.LONG).build())).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false)).build()) : ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.selector("l1", null, null)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build());
        if (this.useDefault) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = 0L;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = 3L;
        }
        this.testQuery("SELECT COUNT(*)\nFROM druid.numfoo\nWHERE l1 IS NULL", (List<Query>)immutableList, (List<Object[]>)ImmutableList.of((Object)objectArray));
    }

    @Test
    public void testNullDoubleFilter() throws Exception {
        Object[] objectArray;
        ImmutableList immutableList = this.useDefault ? ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{0L}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.LONG).build())).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false)).build()) : ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.selector("d1", null, null)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build());
        if (this.useDefault) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = 0L;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = 3L;
        }
        this.testQuery("SELECT COUNT(*)\nFROM druid.numfoo\nWHERE d1 IS NULL", (List<Query>)immutableList, (List<Object[]>)ImmutableList.of((Object)objectArray));
    }

    @Test
    public void testNullFloatFilter() throws Exception {
        Object[] objectArray;
        ImmutableList immutableList = this.useDefault ? ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{0L}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.LONG).build())).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false)).build()) : ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.selector("f1", null, null)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build());
        if (this.useDefault) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = 0L;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = 3L;
        }
        this.testQuery("SELECT COUNT(*)\nFROM druid.numfoo\nWHERE f1 IS NULL", (List<Query>)immutableList, (List<Object[]>)ImmutableList.of((Object)objectArray));
    }

    @Test
    public void testNullDoubleTopN() throws Exception {
        ImmutableList expected = this.useDefault ? ImmutableList.of((Object)new Object[]{1.7, 1L}, (Object)new Object[]{1.0, 1L}, (Object)new Object[]{0.0, 4L}) : ImmutableList.of((Object)new Object[]{null, 3L}, (Object)new Object[]{1.7, 1L}, (Object)new Object[]{1.0, 1L}, (Object)new Object[]{0.0, 1L});
        this.testQuery("SELECT d1, COUNT(*) FROM druid.numfoo GROUP BY d1 ORDER BY d1 DESC LIMIT 10", (Map<String, Object>)QUERY_CONTEXT_DEFAULT, (List<Query>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).dimension((DimensionSpec)new DefaultDimensionSpec("d1", "_d0", ColumnType.DOUBLE)).threshold(10).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.NUMERIC))).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testNullFloatTopN() throws Exception {
        ImmutableList expected = this.useDefault ? ImmutableList.of((Object)new Object[]{Float.valueOf(1.0f), 1L}, (Object)new Object[]{Float.valueOf(0.1f), 1L}, (Object)new Object[]{Float.valueOf(0.0f), 4L}) : ImmutableList.of((Object)new Object[]{null, 3L}, (Object)new Object[]{Float.valueOf(1.0f), 1L}, (Object)new Object[]{Float.valueOf(0.1f), 1L}, (Object)new Object[]{Float.valueOf(0.0f), 1L});
        this.testQuery("SELECT f1, COUNT(*) FROM druid.numfoo GROUP BY f1 ORDER BY f1 DESC LIMIT 10", (Map<String, Object>)QUERY_CONTEXT_DEFAULT, (List<Query>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).dimension((DimensionSpec)new DefaultDimensionSpec("f1", "_d0", ColumnType.FLOAT)).threshold(10).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.NUMERIC))).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testNullLongTopN() throws Exception {
        ImmutableList expected = this.useDefault ? ImmutableList.of((Object)new Object[]{325323L, 1L}, (Object)new Object[]{7L, 1L}, (Object)new Object[]{0L, 4L}) : ImmutableList.of((Object)new Object[]{null, 3L}, (Object)new Object[]{325323L, 1L}, (Object)new Object[]{7L, 1L}, (Object)new Object[]{0L, 1L});
        this.testQuery("SELECT l1, COUNT(*) FROM druid.numfoo GROUP BY l1 ORDER BY l1 DESC LIMIT 10", (Map<String, Object>)QUERY_CONTEXT_DEFAULT, (List<Query>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).dimension((DimensionSpec)new DefaultDimensionSpec("l1", "_d0", ColumnType.LONG)).threshold(10).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.NUMERIC))).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testLongPredicateIsNull() throws Exception {
        this.testQuery("SELECT l1 is null FROM druid.numfoo", (List<Query>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"v0"}).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", NullHandling.replaceWithDefault() ? "0" : "isnull(\"l1\")", ColumnType.LONG)}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{false}, (Object)new Object[]{false}, (Object)new Object[]{false}, (Object)new Object[]{false}, (Object)new Object[]{false}, (Object)new Object[]{false}) : ImmutableList.of((Object)new Object[]{false}, (Object)new Object[]{false}, (Object)new Object[]{false}, (Object)new Object[]{true}, (Object)new Object[]{true}, (Object)new Object[]{true})));
    }

    @Test
    public void testLongPredicateFilterNulls() throws Exception {
        this.testQuery("SELECT COUNT(*)\nFROM druid.numfoo\nWHERE l1 > 3", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.bound("l1", "3", null, true, false, null, StringComparators.NUMERIC)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}));
    }

    @Test
    public void testDoublePredicateFilterNulls() throws Exception {
        this.testQuery("SELECT COUNT(*)\nFROM druid.numfoo\nWHERE d1 > 0", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.bound("d1", "0", null, true, false, null, StringComparators.NUMERIC)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}));
    }

    @Test
    public void testFloatPredicateFilterNulls() throws Exception {
        this.testQuery("SELECT COUNT(*)\nFROM druid.numfoo\nWHERE f1 > 0", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.bound("f1", "0", null, true, false, null, StringComparators.NUMERIC)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}));
    }

    @Test
    public void testEmptyStringEquality() throws Exception {
        if (NullHandling.replaceWithDefault()) {
            this.testQuery("SELECT COUNT(*)\nFROM druid.foo\nWHERE NULLIF(dim2, 'a') = ''", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.in("dim2", (List<String>)ImmutableList.of((Object)"", (Object)"a"), null)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{5L}));
        } else {
            this.testQuery("SELECT COUNT(*)\nFROM druid.foo\nWHERE NULLIF(dim2, 'a') = ''", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.selector("dim2", "", null)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
        }
    }

    @Test
    public void testNullStringEquality() throws Exception {
        this.testQuery("SELECT COUNT(*)\nFROM druid.foo\nWHERE NULLIF(dim2, 'a') = null", (List<Query>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{0L}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.LONG).build())).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}));
    }

    @Test
    public void testCoalesceColumns() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT COALESCE(dim2, dim1), COUNT(*) FROM druid.foo GROUP BY COALESCE(dim2, dim1)\n", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "case_searched(notnull(\"dim2\"),\"dim2\",\"dim1\")", ColumnType.STRING)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"10.1", 1L}, (Object)new Object[]{"2", 1L}, (Object)new Object[]{"a", 2L}, (Object)new Object[]{"abc", 2L}) : ImmutableList.of((Object)new Object[]{"", 1L}, (Object)new Object[]{"10.1", 1L}, (Object)new Object[]{"a", 2L}, (Object)new Object[]{"abc", 2L})));
    }

    @Test
    public void testColumnIsNull() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE dim2 IS NULL\n", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.selector("dim2", null, null)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{NullHandling.replaceWithDefault() ? 3L : 2L}));
    }

    @Test
    public void testSelfJoin() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(*) FROM druid.foo x, druid.foo y\n", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns((List)ImmutableList.of((Object)"__time", (Object)"cnt", (Object)"dim1", (Object)"dim2", (Object)"dim3", (Object)"m1", (Object)"m2", (Object)"unique_dim1")).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", "1", JoinType.INNER)).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{36L}));
    }

    @Test
    public void testGroupingWithNullInFilter() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(*) FROM foo WHERE dim1 IN (NULL)", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)JoinDataSource.create((DataSource)new TableDataSource("foo"), (DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{null}), (RowSignature)RowSignature.builder().add("ROW_VALUE", ColumnType.STRING).build()), (String)"j0.", (String)"(\"dim1\" == \"j0.ROW_VALUE\")", (JoinType)JoinType.INNER, null, (ExprMacroTable)ExprMacroTable.nil())).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}));
    }

    @Test
    public void testTwoExactCountDistincts() throws Exception {
        this.testQuery(PLANNER_CONFIG_NO_HLL, "SELECT COUNT(distinct dim1), COUNT(distinct dim2) FROM druid.foo", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteQueryTest.join((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING)}).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("d0", null, null)))}).setContext(QUERY_CONTEXT_DEFAULT).build()), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0", ColumnType.STRING)}).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("d0", null, null)))}).setContext(QUERY_CONTEXT_DEFAULT).build()), "j0.", "1", JoinType.INNER)).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"a0", "j0.a0"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{NullHandling.sqlCompatible() ? 6L : 5L, NullHandling.sqlCompatible() ? 3L : 2L}));
    }

    @Test
    public void testGroupByNothingWithLiterallyFalseFilter() throws Exception {
        this.testQuery("SELECT COUNT(*), MAX(cnt) FROM druid.foo WHERE 1 = 0", (List<Query>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{0L, null}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.LONG).add("EXPR$1", ColumnType.LONG).build())).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0", "EXPR$1"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L, null}));
    }

    @Test
    public void testGroupByNothingWithImpossibleTimeFilter() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo\nWHERE FLOOR(__time TO DAY) = TIMESTAMP '2000-01-02 01:00:00'\nOR FLOOR(__time TO DAY) = TIMESTAMP '2000-01-02 02:00:00'", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(new Interval[0])).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}));
    }

    @Test
    public void testGroupByWithImpossibleTimeFilter() throws Exception {
        this.testQuery("SELECT dim1, COUNT(*) FROM druid.foo\nWHERE FLOOR(__time TO DAY) = TIMESTAMP '2000-01-02 01:00:00'\nOR FLOOR(__time TO DAY) = TIMESTAMP '2000-01-02 02:00:00'\nGROUP BY 1", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of())).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setGranularity(Granularities.ALL).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testGroupByOneColumnWithLiterallyFalseFilter() throws Exception {
        this.testQuery("SELECT COUNT(*), MAX(cnt) FROM druid.foo WHERE 1 = 0 GROUP BY dim1", (List<Query>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of(), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.LONG).add("EXPR$1", ColumnType.LONG).build())).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0", "EXPR$1"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false)).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testGroupByWithFilterMatchingNothing() throws Exception {
        this.testQuery("SELECT COUNT(*), MAX(cnt) FROM druid.foo WHERE dim1 = 'foobar'", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteQueryTest.selector("dim1", "foobar", null)).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0"), new LongMaxAggregatorFactory("a1", "cnt")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L, NullHandling.sqlCompatible() ? null : Long.valueOf(Long.MIN_VALUE)}));
    }

    @Test
    public void testGroupByWithGroupByEmpty() throws Exception {
        this.testQuery("SELECT COUNT(*), SUM(cnt), MIN(cnt) FROM druid.foo GROUP BY ()", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0"), new LongSumAggregatorFactory("a1", "cnt"), new LongMinAggregatorFactory("a2", "cnt")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L, 6L, 1L}));
    }

    @Test
    public void testGroupByWithFilterMatchingNothingWithGroupByLiteral() throws Exception {
        this.testQuery("SELECT COUNT(*), MAX(cnt) FROM druid.foo WHERE dim1 = 'foobar' GROUP BY 'dummy'", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteQueryTest.selector("dim1", "foobar", null)).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0"), new LongMaxAggregatorFactory("a1", "cnt")})).context(QUERY_CONTEXT_DO_SKIP_EMPTY_BUCKETS).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testCountNonNullColumn() throws Exception {
        this.testQuery("SELECT COUNT(cnt) FROM druid.foo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{this.useDefault ? new CountAggregatorFactory("a0") : new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("cnt", null, null)))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testCountNullableColumn() throws Exception {
        this.testQuery("SELECT COUNT(dim2) FROM druid.foo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim2", null, null)))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{3L}) : ImmutableList.of((Object)new Object[]{4L})));
    }

    @Test
    public void testCountNullableExpression() throws Exception {
        this.testQuery("SELECT COUNT(CASE WHEN dim2 = 'abc' THEN 'yes' WHEN dim2 = 'def' THEN 'yes' END) FROM druid.foo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteQueryTest.in("dim2", (List<String>)ImmutableList.of((Object)"abc", (Object)"def"), null))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testCountStar() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testCountStarOnCommonTableExpression() throws Exception {
        this.testQuery("WITH beep (dim1_firstchar) AS (SELECT SUBSTRING(dim1, 1, 1) FROM foo WHERE dim2 = 'a')\nSELECT COUNT(*) FROM beep WHERE dim1_firstchar <> 'z'", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.selector("dim2", "a", null), CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", "z", (ExtractionFn)new SubstringDimExtractionFn(0, Integer.valueOf(1))))})).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}));
    }

    @Test
    public void testCountStarOnView() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM view.aview WHERE dim1_firstchar <> 'z'", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.selector("dim2", "a", null), CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", "z", (ExtractionFn)new SubstringDimExtractionFn(0, Integer.valueOf(1))))})).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}));
    }

    @Test
    public void testConfusedView() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM view.dview as druid WHERE druid.numfoo <> 'z'", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.selector("dim2", "a", null), CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", "z", (ExtractionFn)new SubstringDimExtractionFn(0, Integer.valueOf(1))))})).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}));
    }

    @Test
    public void testViewAndJoin() throws Exception {
        this.cannotVectorize();
        Map<String, Object> queryContext = this.withLeftDirectAccessEnabled(QUERY_CONTEXT_DEFAULT);
        this.testQuery("SELECT COUNT(*) FROM view.cview as a INNER JOIN druid.foo d on d.dim2 = a.dim2 WHERE a.dim1_firstchar <> 'z' ", queryContext, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteQueryTest.join((DataSource)CalciteQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim2"}).context(queryContext).build()), "j0.", "(\"dim2\" == \"j0.dim2\")", JoinType.INNER, (DimFilter)CalciteQueryTest.bound("dim2", "a", "a", false, false, null, null)), (DataSource)new QueryDataSource((Query)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim2"}).context(queryContext).build()), "_j0.", "('a' == \"_j0.dim2\")", JoinType.INNER)).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", "z", (ExtractionFn)new SubstringDimExtractionFn(0, Integer.valueOf(1))))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(this.withLeftDirectAccessEnabled(QUERY_CONTEXT_DEFAULT)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{8L}));
    }

    @Test
    public void testExplainCountStarOnView() throws Exception {
        this.skipVectorize();
        String query = "EXPLAIN PLAN FOR SELECT COUNT(*) FROM view.aview WHERE dim1_firstchar <> 'z'";
        String legacyExplanation = "DruidQueryRel(query=[{\"queryType\":\"timeseries\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"descending\":false,\"virtualColumns\":[],\"filter\":{\"type\":\"and\",\"fields\":[{\"type\":\"selector\",\"dimension\":\"dim2\",\"value\":\"a\",\"extractionFn\":null},{\"type\":\"not\",\"field\":{\"type\":\"selector\",\"dimension\":\"dim1\",\"value\":\"z\",\"extractionFn\":{\"type\":\"substring\",\"index\":0,\"length\":1}}}]},\"granularity\":{\"type\":\"all\"},\"aggregations\":[{\"type\":\"count\",\"name\":\"a0\"}],\"postAggregations\":[],\"limit\":2147483647,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"}}], signature=[{a0:LONG}])\n";
        String explanation = "[{\"query\":{\"queryType\":\"timeseries\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"descending\":false,\"virtualColumns\":[],\"filter\":{\"type\":\"and\",\"fields\":[{\"type\":\"selector\",\"dimension\":\"dim2\",\"value\":\"a\",\"extractionFn\":null},{\"type\":\"not\",\"field\":{\"type\":\"selector\",\"dimension\":\"dim1\",\"value\":\"z\",\"extractionFn\":{\"type\":\"substring\",\"index\":0,\"length\":1}}}]},\"granularity\":{\"type\":\"all\"},\"aggregations\":[{\"type\":\"count\",\"name\":\"a0\"}],\"postAggregations\":[],\"limit\":2147483647,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"}},\"signature\":[{\"name\":\"a0\",\"type\":\"LONG\"}]}]";
        String resources = "[{\"name\":\"aview\",\"type\":\"VIEW\"}]";
        this.testQuery("EXPLAIN PLAN FOR SELECT COUNT(*) FROM view.aview WHERE dim1_firstchar <> 'z'", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"DruidQueryRel(query=[{\"queryType\":\"timeseries\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"descending\":false,\"virtualColumns\":[],\"filter\":{\"type\":\"and\",\"fields\":[{\"type\":\"selector\",\"dimension\":\"dim2\",\"value\":\"a\",\"extractionFn\":null},{\"type\":\"not\",\"field\":{\"type\":\"selector\",\"dimension\":\"dim1\",\"value\":\"z\",\"extractionFn\":{\"type\":\"substring\",\"index\":0,\"length\":1}}}]},\"granularity\":{\"type\":\"all\"},\"aggregations\":[{\"type\":\"count\",\"name\":\"a0\"}],\"postAggregations\":[],\"limit\":2147483647,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"}}], signature=[{a0:LONG}])\n", "[{\"name\":\"aview\",\"type\":\"VIEW\"}]"}));
        this.testQuery(PLANNER_CONFIG_NATIVE_QUERY_EXPLAIN, "EXPLAIN PLAN FOR SELECT COUNT(*) FROM view.aview WHERE dim1_firstchar <> 'z'", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[{\"query\":{\"queryType\":\"timeseries\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"descending\":false,\"virtualColumns\":[],\"filter\":{\"type\":\"and\",\"fields\":[{\"type\":\"selector\",\"dimension\":\"dim2\",\"value\":\"a\",\"extractionFn\":null},{\"type\":\"not\",\"field\":{\"type\":\"selector\",\"dimension\":\"dim1\",\"value\":\"z\",\"extractionFn\":{\"type\":\"substring\",\"index\":0,\"length\":1}}}]},\"granularity\":{\"type\":\"all\"},\"aggregations\":[{\"type\":\"count\",\"name\":\"a0\"}],\"postAggregations\":[],\"limit\":2147483647,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"}},\"signature\":[{\"name\":\"a0\",\"type\":\"LONG\"}]}]", "[{\"name\":\"aview\",\"type\":\"VIEW\"}]"}));
    }

    @Test
    public void testCountStarWithLikeFilter() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE dim1 like 'a%' OR dim2 like '%xb%' escape 'x'", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.or(new DimFilter[]{new LikeDimFilter("dim1", "a%", null, null), new LikeDimFilter("dim2", "%xb%", "x", null)})).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}));
    }

    @Test
    public void testCountStarWithLongColumnFilters() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE cnt >= 3 OR cnt = 1", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.or(new DimFilter[]{CalciteQueryTest.bound("cnt", "3", null, false, false, null, StringComparators.NUMERIC), CalciteQueryTest.selector("cnt", "1", null)})).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testCountStarWithLongColumnFiltersOnFloatLiterals() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE cnt > 1.1 and cnt < 100000001.0", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.bound("cnt", "1.1", "100000001.0", true, true, null, StringComparators.NUMERIC)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}));
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE cnt = 1.0", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.selector("cnt", "1.0", null)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE cnt = 100000001.0", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.selector("cnt", "100000001.0", null)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}));
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE cnt = 1.0 or cnt = 100000001.0", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.in("cnt", (List<String>)ImmutableList.of((Object)"1.0", (Object)"100000001.0"), null)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testCountStarWithLongColumnFiltersOnTwoPoints() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE cnt = 1 OR cnt = 2", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.in("cnt", (List<String>)ImmutableList.of((Object)"1", (Object)"2"), null)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testFilterOnStringAsNumber() throws Exception {
        this.testQuery("SELECT distinct dim1 FROM druid.foo WHERE dim1 = 10 OR (floor(CAST(dim1 AS float)) = 10.00 and CAST(dim1 AS float) > 9 and CAST(dim1 AS float) <= 10.5)", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "floor(CAST(\"dim1\", 'DOUBLE'))", ColumnType.DOUBLE)}).setDimFilter((DimFilter)CalciteQueryTest.or(new DimFilter[]{CalciteQueryTest.bound("dim1", "10", "10", false, false, null, StringComparators.NUMERIC), CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.selector("v0", "10.00", null), CalciteQueryTest.bound("dim1", "9", "10.5", true, false, null, StringComparators.NUMERIC)})})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1"}));
    }

    @Test
    public void testSimpleLongAggregations() throws Exception {
        this.testQuery("SELECT  MIN(l1), MIN(cnt), MAX(l1) FROM druid.numfoo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongMinAggregatorFactory("a0", "l1"), new LongMinAggregatorFactory("a1", "cnt"), new LongMaxAggregatorFactory("a2", "l1")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L, 1L, 325323L}));
    }

    @Test
    public void testSimpleDoubleAggregations() throws Exception {
        this.testQuery("SELECT  MIN(d1), MAX(d1) FROM druid.numfoo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleMinAggregatorFactory("a0", "d1"), new DoubleMaxAggregatorFactory("a1", "d1")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0.0, 1.7}));
    }

    @Test
    public void testSimpleFloatAggregations() throws Exception {
        this.testQuery("SELECT  MIN(m1), MAX(m1) FROM druid.numfoo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FloatMinAggregatorFactory("a0", "m1"), new FloatMaxAggregatorFactory("a1", "m1")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(1.0f), Float.valueOf(6.0f)}));
    }

    @Test
    public void testSimpleAggregations() throws Exception {
        this.testQuery("SELECT COUNT(*), COUNT(cnt), COUNT(dim1), AVG(cnt), SUM(cnt), SUM(cnt) + MIN(cnt) + MAX(cnt), COUNT(dim2), COUNT(d1), AVG(d1) FROM druid.numfoo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(this.useDefault ? CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a1"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", null, null))), new LongSumAggregatorFactory("a2:sum", "cnt"), new CountAggregatorFactory("a2:count"), new LongSumAggregatorFactory("a3", "cnt"), new LongMinAggregatorFactory("a4", "cnt"), new LongMaxAggregatorFactory("a5", "cnt"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a6"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim2", null, null))), new DoubleSumAggregatorFactory("a7:sum", "d1"), new CountAggregatorFactory("a7:count")}) : CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a1"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("cnt", null, null))), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a2"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", null, null))), new LongSumAggregatorFactory("a3:sum", "cnt"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a3:count"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("cnt", null, null))), new LongSumAggregatorFactory("a4", "cnt"), new LongMinAggregatorFactory("a5", "cnt"), new LongMaxAggregatorFactory("a6", "cnt"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a7"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim2", null, null))), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a8"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("d1", null, null))), new DoubleSumAggregatorFactory("a9:sum", "d1"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a9:count"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("d1", null, null)))})).postAggregators(new PostAggregator[]{new ArithmeticPostAggregator(this.useDefault ? "a2" : "a3", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, this.useDefault ? "a2:sum" : "a3:sum"), (Object)new FieldAccessPostAggregator(null, this.useDefault ? "a2:count" : "a3:count"))), new ArithmeticPostAggregator(this.useDefault ? "a7" : "a9", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, this.useDefault ? "a7:sum" : "a9:sum"), (Object)new FieldAccessPostAggregator(null, this.useDefault ? "a7:count" : "a9:count"))), CalciteQueryTest.expressionPostAgg("p0", this.useDefault ? "((\"a3\" + \"a4\") + \"a5\")" : "((\"a4\" + \"a5\") + \"a6\")")}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{6L, 6L, 5L, 1L, 6L, 8L, 3L, 6L, 0.45}) : ImmutableList.of((Object)new Object[]{6L, 6L, 6L, 1L, 6L, 8L, 4L, 3L, 0.9})));
    }

    @Test
    public void testGroupByWithSortOnPostAggregationDefault() throws Exception {
        this.testQuery("SELECT dim1, MIN(m1) + MAX(m1) AS x FROM druid.foo GROUP BY dim1 ORDER BY x LIMIT 3", (List<Query>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0")).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new NumericTopNMetricSpec("p0"))).aggregators(new AggregatorFactory[]{new FloatMinAggregatorFactory("a0", "m1"), new FloatMaxAggregatorFactory("a1", "m1")}).postAggregators(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("p0", "(\"a0\" + \"a1\")")}).threshold(3).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", Float.valueOf(2.0f)}, (Object)new Object[]{"10.1", Float.valueOf(4.0f)}, (Object)new Object[]{"2", Float.valueOf(6.0f)}));
    }

    @Test
    public void testGroupByWithSortOnPostAggregationNoTopNConfig() throws Exception {
        this.testQuery(PLANNER_CONFIG_NO_TOPN, "SELECT dim1, MIN(m1) + MAX(m1) AS x FROM druid.foo GROUP BY dim1 ORDER BY x LIMIT 3", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setAggregatorSpecs(new AggregatorFactory[]{new FloatMinAggregatorFactory("a0", "m1"), new FloatMaxAggregatorFactory("a1", "m1")}).setPostAggregatorSpecs((List)ImmutableList.of((Object)CalciteQueryTest.expressionPostAgg("p0", "(\"a0\" + \"a1\")"))).setLimitSpec((LimitSpec)DefaultLimitSpec.builder().orderBy(new OrderByColumnSpec[]{new OrderByColumnSpec("p0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)}).limit(3).build()).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", Float.valueOf(2.0f)}, (Object)new Object[]{"10.1", Float.valueOf(4.0f)}, (Object)new Object[]{"2", Float.valueOf(6.0f)}));
    }

    @Test
    public void testGroupByWithSortOnPostAggregationNoTopNContext() throws Exception {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_NO_TOPN, "SELECT dim1, MIN(m1) + MAX(m1) AS x FROM druid.foo GROUP BY dim1 ORDER BY x LIMIT 3", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setAggregatorSpecs(new AggregatorFactory[]{new FloatMinAggregatorFactory("a0", "m1"), new FloatMaxAggregatorFactory("a1", "m1")}).setPostAggregatorSpecs((List)ImmutableList.of((Object)CalciteQueryTest.expressionPostAgg("p0", "(\"a0\" + \"a1\")"))).setLimitSpec((LimitSpec)DefaultLimitSpec.builder().orderBy(new OrderByColumnSpec[]{new OrderByColumnSpec("p0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)}).limit(3).build()).setContext(QUERY_CONTEXT_NO_TOPN).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", Float.valueOf(2.0f)}, (Object)new Object[]{"10.1", Float.valueOf(4.0f)}, (Object)new Object[]{"2", Float.valueOf(6.0f)}));
    }

    @Test
    public void testFilteredAggregations() throws Exception {
        this.testQuery("SELECT SUM(case dim1 when 'abc' then cnt end), SUM(case dim1 when 'abc' then null else cnt end), SUM(case substring(dim1, 1, 1) when 'a' then cnt end), COUNT(dim2) filter(WHERE dim1 <> '1'), COUNT(CASE WHEN dim1 <> '1' THEN 'dummy' END), SUM(CASE WHEN dim1 <> '1' THEN 1 ELSE 0 END), SUM(cnt) filter(WHERE dim2 = 'a'), SUM(case when dim1 <> '1' then cnt end) filter(WHERE dim2 = 'a'), SUM(CASE WHEN dim1 <> '1' THEN cnt ELSE 0 END), MAX(CASE WHEN dim1 <> '1' THEN cnt END), COUNT(DISTINCT CASE WHEN dim1 <> '1' THEN m1 END), SUM(cnt) filter(WHERE dim2 = 'a' AND dim1 = 'b') FROM druid.foo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("a0", "cnt"), (DimFilter)CalciteQueryTest.selector("dim1", "abc", null)), new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("a1", "cnt"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", "abc", null))), new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("a2", "cnt"), (DimFilter)CalciteQueryTest.selector("dim1", "a", (ExtractionFn)new SubstringDimExtractionFn(0, Integer.valueOf(1)))), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a3"), (DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim2", null, null)), CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", "1", null))})), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a4"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", "1", null))), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a5"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", "1", null))), new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("a6", "cnt"), (DimFilter)CalciteQueryTest.selector("dim2", "a", null)), new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("a7", "cnt"), (DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.selector("dim2", "a", null), CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", "1", null))})), new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("a8", "cnt"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", "1", null))), new FilteredAggregatorFactory((AggregatorFactory)new LongMaxAggregatorFactory("a9", "cnt"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", "1", null))), new FilteredAggregatorFactory((AggregatorFactory)new CardinalityAggregatorFactory("a10", null, CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("m1", "m1", ColumnType.FLOAT)}), false, true), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", "1", null))), new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("a11", "cnt"), (DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.selector("dim2", "a", null), CalciteQueryTest.selector("dim1", "b", null)}))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{1L, 5L, 1L, 2L, 5L, 5L, 2L, 1L, 5L, 1L, 5L, 0L}) : ImmutableList.of((Object)new Object[]{1L, 5L, 1L, 3L, 5L, 5L, 2L, 1L, 5L, 1L, 5L, null})));
    }

    @Test
    public void testCaseFilteredAggregationWithGroupBy() throws Exception {
        this.testQuery("SELECT\n  cnt,\n  SUM(CASE WHEN dim1 <> '1' THEN 1 ELSE 0 END) + SUM(cnt)\nFROM druid.foo\nGROUP BY cnt", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("cnt", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", "1", null))), new LongSumAggregatorFactory("a1", "cnt")})).setPostAggregatorSpecs((List)ImmutableList.of((Object)CalciteQueryTest.expressionPostAgg("p0", "(\"a0\" + \"a1\")"))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, 11L}));
    }

    @Test
    public void testFilteredAggregationWithNotIn() throws Exception {
        this.testQuery("SELECT\nCOUNT(*) filter(WHERE dim1 NOT IN ('1')),\nCOUNT(dim2) filter(WHERE dim1 NOT IN ('1'))\nFROM druid.foo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", "1", null))), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a1"), (DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim2", null, null)), CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", "1", null))}))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{5L, 2L}) : ImmutableList.of((Object)new Object[]{5L, 3L})));
    }

    @Test
    public void testExpressionAggregations() throws Exception {
        this.cannotVectorize();
        ExprMacroTable macroTable = CalciteTests.createExprMacroTable();
        this.testQuery("SELECT\n  SUM(cnt * 3),\n  LN(SUM(cnt) + SUM(m1)),\n  MOD(SUM(cnt), 4),\n  SUM(CHARACTER_LENGTH(CAST(cnt * 10 AS VARCHAR))),\n  MAX(CHARACTER_LENGTH(dim2) + LN(m1)),\n  MIN(CHARACTER_LENGTH(dim2) + LN(m1))\nFROM druid.foo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "(\"cnt\" * 3)", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v1", "strlen(CAST((\"cnt\" * 10), 'STRING'))", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v2", "(strlen(\"dim2\") + log(\"m1\"))", ColumnType.DOUBLE)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "v0", null, macroTable), new LongSumAggregatorFactory("a1", "cnt"), new DoubleSumAggregatorFactory("a2", "m1"), new LongSumAggregatorFactory("a3", "v1", null, macroTable), new DoubleMaxAggregatorFactory("a4", "v2", null, macroTable), new DoubleMinAggregatorFactory("a5", "v2", null, macroTable)})).postAggregators(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("p0", "log((\"a1\" + \"a2\"))"), CalciteQueryTest.expressionPostAgg("p1", "(\"a1\" % 4)")}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{18L, 3.295836866004329, 2, 12L, 3.0 + Math.log(5.0), this.useDefault ? 0.6931471805599453 : 1.0}));
    }

    @Test
    public void testExpressionFilteringAndGrouping() throws Exception {
        this.testQuery("SELECT\n  FLOOR(m1 / 2) * 2,\n  COUNT(*)\nFROM druid.foo\nWHERE FLOOR(m1 / 2) * 2 > -1\nGROUP BY FLOOR(m1 / 2) * 2\nORDER BY 1 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "(floor((\"m1\" / 2)) * 2)", ColumnType.FLOAT)}).setDimFilter((DimFilter)CalciteQueryTest.bound("v0", "-1", null, true, false, null, StringComparators.NUMERIC)).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.FLOAT)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)DefaultLimitSpec.builder().orderBy(new OrderByColumnSpec[]{new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)}).build()).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(6.0f), 1L}, (Object)new Object[]{Float.valueOf(4.0f), 2L}, (Object)new Object[]{Float.valueOf(2.0f), 2L}, (Object)new Object[]{Float.valueOf(0.0f), 1L}));
    }

    @Test
    public void testExpressionFilteringAndGroupingUsingCastToLong() throws Exception {
        this.testQuery("SELECT\n  CAST(m1 AS BIGINT) / 2 * 2,\n  COUNT(*)\nFROM druid.foo\nWHERE CAST(m1 AS BIGINT) / 2 * 2 > -1\nGROUP BY CAST(m1 AS BIGINT) / 2 * 2\nORDER BY 1 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "((CAST(\"m1\", 'LONG') / 2) * 2)", ColumnType.LONG)}).setDimFilter((DimFilter)CalciteQueryTest.bound("v0", "-1", null, true, false, null, StringComparators.NUMERIC)).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L, 1L}, (Object)new Object[]{4L, 2L}, (Object)new Object[]{2L, 2L}, (Object)new Object[]{0L, 1L}));
    }

    @Test
    public void testExpressionFilteringAndGroupingOnStringCastToNumber() throws Exception {
        this.testQuery("SELECT\n  FLOOR(CAST(dim1 AS FLOAT) / 2) * 2,\n  COUNT(*)\nFROM druid.foo\nWHERE FLOOR(CAST(dim1 AS FLOAT) / 2) * 2 > -1\nGROUP BY FLOOR(CAST(dim1 AS FLOAT) / 2) * 2\nORDER BY 1 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "(floor((CAST(\"dim1\", 'DOUBLE') / 2)) * 2)", ColumnType.FLOAT)}).setDimFilter((DimFilter)CalciteQueryTest.bound("v0", "-1", null, true, false, null, StringComparators.NUMERIC)).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.FLOAT)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{Float.valueOf(10.0f), 1L}, (Object)new Object[]{Float.valueOf(2.0f), 1L}, (Object)new Object[]{Float.valueOf(0.0f), 4L}) : ImmutableList.of((Object)new Object[]{Float.valueOf(10.0f), 1L}, (Object)new Object[]{Float.valueOf(2.0f), 1L}, (Object)new Object[]{Float.valueOf(0.0f), 1L})));
    }

    @Test
    public void testInFilter() throws Exception {
        this.testQuery("SELECT dim1, COUNT(*) FROM druid.foo WHERE dim1 IN ('abc', 'def', 'ghi') GROUP BY dim1", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setDimFilter((DimFilter)new InDimFilter("dim1", (Collection)ImmutableList.of((Object)"abc", (Object)"def", (Object)"ghi"), null)).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", 1L}, (Object)new Object[]{"def", 1L}));
    }

    @Test
    public void testInFilterWith23Elements() throws Exception {
        ArrayList<String> elements = new ArrayList<String>();
        elements.add("abc");
        elements.add("def");
        elements.add("ghi");
        for (int i = 0; i < 20; ++i) {
            elements.add("dummy" + i);
        }
        String elementsString = Joiner.on((String)",").join(elements.stream().map(s -> "'" + s + "'").iterator());
        this.testQuery("SELECT dim1, COUNT(*) FROM druid.foo WHERE dim1 IN (" + elementsString + ") GROUP BY dim1", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setDimFilter((DimFilter)new InDimFilter("dim1", elements, null)).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", 1L}, (Object)new Object[]{"def", 1L}));
    }

    @Test
    public void testCountStarWithDegenerateFilter() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE dim2 = 'a' and (dim1 > 'a' OR dim1 < 'b')", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.selector("dim2", "a", null)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}));
    }

    @Test
    public void testCountStarWithNotOfDegenerateFilter() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE dim2 = 'a' and not (dim1 > 'a' OR dim1 < 'b')", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of(), (RowSignature)RowSignature.builder().add("dim1", ColumnType.STRING).add("dim2", ColumnType.STRING).build())).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}));
    }

    @Test
    public void testUnplannableQueries() {
        ImmutableMap queries = ImmutableMap.of((Object)"SELECT dim1 FROM druid.foo ORDER BY dim1", (Object)"Possible error: SQL query requires order by non-time column [dim1 ASC] that is not supported.", (Object)"SELECT foo.dim1, foo.dim2, l.k, l.v\nFROM foo INNER JOIN lookup.lookyloo l ON foo.dim2 <> l.k", (Object)"Possible error: SQL requires a join with 'NOT_EQUALS' condition that is not supported.", (Object)"SELECT foo.dim1, foo.dim2, l.k, l.v\nFROM foo INNER JOIN lookup.lookyloo l ON CHARACTER_LENGTH(foo.dim2 || l.k) > 3\n", (Object)"Possible error: SQL requires a join with 'GREATER_THAN' condition that is not supported.");
        for (Map.Entry queryErrorPair : queries.entrySet()) {
            this.assertQueryIsUnplannable((String)queryErrorPair.getKey(), (String)queryErrorPair.getValue());
        }
    }

    @Test
    public void testCountStarWithBoundFilterSimplifyOnMetric() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE 2.5 < m1 AND m1 < 3.5", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.bound("m1", "2.5", "3.5", true, true, null, StringComparators.NUMERIC)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testCountStarWithBoundFilterSimplifyOr() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE (dim1 >= 'a' and dim1 < 'b') OR dim1 = 'ab'", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.bound("dim1", "a", "b", false, true, null, StringComparators.LEXICOGRAPHIC)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testUnplannableTwoExactCountDistincts() {
        this.assertQueryIsUnplannable(PLANNER_CONFIG_NO_HLL, "SELECT dim2, COUNT(distinct dim1), COUNT(distinct dim2) FROM druid.foo GROUP BY dim2", "Possible error: SQL requires a join with 'IS_NOT_DISTINCT_FROM' condition that is not supported.");
    }

    @Test
    public void testUnplannableExactCountDistinctOnSketch() {
        this.assertQueryIsUnplannable(PLANNER_CONFIG_NO_HLL, "SELECT COUNT(distinct unique_dim1) FROM druid.foo", "Possible error: SQL requires a group-by on a column of type COMPLEX<hyperUnique> that is unsupported.");
    }

    @Test
    public void testArrayAggQueryOnComplexDatatypes() throws Exception {
        try {
            this.testQuery("SELECT ARRAY_AGG(unique_dim1) FROM druid.foo", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
            Assert.fail((String)"query execution should fail");
        }
        catch (SqlPlanningException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot use ARRAY_AGG on complex inputs COMPLEX<hyperUnique>"));
            Assert.assertEquals((Object)SqlPlanningException.PlanningError.VALIDATION_ERROR.getErrorCode(), (Object)e.getErrorCode());
            Assert.assertEquals((Object)SqlPlanningException.PlanningError.VALIDATION_ERROR.getErrorClass(), (Object)e.getErrorClass());
        }
    }

    @Test
    public void testStringAggQueryOnComplexDatatypes() throws Exception {
        try {
            this.testQuery("SELECT STRING_AGG(unique_dim1, ',') FROM druid.foo", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
            Assert.fail((String)"query execution should fail");
        }
        catch (SqlPlanningException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot use STRING_AGG on complex inputs COMPLEX<hyperUnique>"));
            Assert.assertEquals((Object)SqlPlanningException.PlanningError.VALIDATION_ERROR.getErrorCode(), (Object)e.getErrorCode());
            Assert.assertEquals((Object)SqlPlanningException.PlanningError.VALIDATION_ERROR.getErrorClass(), (Object)e.getErrorClass());
        }
    }

    @Test
    public void testCountStarWithBoundFilterSimplifyAnd() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE (dim1 >= 'a' and dim1 < 'b') and dim1 = 'abc'", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.selector("dim1", "abc", null)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testCountStarWithFilterOnCastedString() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE CAST(dim1 AS bigint) = 2", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters(CalciteQueryTest.numericSelector("dim1", "2", null)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testCountStarWithTimeFilter() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE __time >= TIMESTAMP '2000-01-01 00:00:00' AND __time < TIMESTAMP '2001-01-01 00:00:00'", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01/2001-01-01"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testRemoveUselessCaseWhen() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo\nWHERE\n  CASE\n    WHEN __time >= TIME_PARSE('2000-01-01 00:00:00', 'yyyy-MM-dd HH:mm:ss') AND __time < TIMESTAMP '2001-01-01 00:00:00'\n    THEN true\n    ELSE false\n  END\nOR\n  __time >= TIMESTAMP '2010-01-01 00:00:00' AND __time < TIMESTAMP '2011-01-01 00:00:00'", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000/2001"), Intervals.of((String)"2010/2011"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testCountStarWithTimeMillisecondFilters() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo\nWHERE __time = TIMESTAMP '2000-01-01 00:00:00.111'\nOR (__time >= TIMESTAMP '2000-01-01 00:00:00.888' AND __time < TIMESTAMP '2000-01-02 00:00:00.222')", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01T00:00:00.111/2000-01-01T00:00:00.112"), Intervals.of((String)"2000-01-01T00:00:00.888/2000-01-02T00:00:00.222"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testCountStarWithTimeFilterUsingStringLiterals() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo\nWHERE __time >= '2000-01-01 00:00:00' AND __time < '2001-01-01T00:00:00'\nOR __time >= '2001-02-01' AND __time < '2001-02-02'\nOR __time BETWEEN '2001-03-01' AND '2001-03-02'", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01/2001-01-01"), Intervals.of((String)"2001-02-01/2001-02-02"), Intervals.of((String)"2001-03-01/2001-03-02T00:00:00.001"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testCountStarWithTimeFilterUsingStringLiteralsInvalid_isUnplannable() {
        this.assertQueryIsUnplannable("SELECT COUNT(*) FROM druid.foo\nWHERE __time >= 'z2000-01-01 00:00:00' AND __time < '2001-01-01 00:00:00'\n", "Possible error: Illegal TIMESTAMP constant: CAST('z2000-01-01 00:00:00'):TIMESTAMP(3) NOT NULL");
    }

    @Test
    public void testCountStarWithSinglePointInTime() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE __time = TIMESTAMP '2000-01-01 00:00:00'", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01/2000-01-01T00:00:00.001"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testCountStarWithTwoPointsInTime() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE __time = TIMESTAMP '2000-01-01 00:00:00' OR __time = TIMESTAMP '2000-01-01 00:00:00' + INTERVAL '1' DAY", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01/2000-01-01T00:00:00.001"), Intervals.of((String)"2000-01-02/2000-01-02T00:00:00.001"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}));
    }

    @Test
    public void testCountStarWithComplexDisjointTimeFilter() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE dim2 = 'a' and (  (__time >= TIMESTAMP '2000-01-01 00:00:00' AND __time < TIMESTAMP '2001-01-01 00:00:00')  OR (    (__time >= TIMESTAMP '2002-01-01 00:00:00' AND __time < TIMESTAMP '2003-05-01 00:00:00')    and (__time >= TIMESTAMP '2002-05-01 00:00:00' AND __time < TIMESTAMP '2004-01-01 00:00:00')    and dim1 = 'abc'  ))", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000/2001"), Intervals.of((String)"2002-05-01/2003-05-01"))).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.selector("dim2", "a", null), CalciteQueryTest.or(new DimFilter[]{CalciteQueryTest.timeBound("2000/2001"), CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.selector("dim1", "abc", null), CalciteQueryTest.timeBound("2002-05-01/2003-05-01")})})})).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testCountStarWithNotOfComplexDisjointTimeFilter() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE not (dim2 = 'a' and (    (__time >= TIMESTAMP '2000-01-01 00:00:00' AND __time < TIMESTAMP '2001-01-01 00:00:00')    OR (      (__time >= TIMESTAMP '2002-01-01 00:00:00' AND __time < TIMESTAMP '2004-01-01 00:00:00')      and (__time >= TIMESTAMP '2002-05-01 00:00:00' AND __time < TIMESTAMP '2003-05-01 00:00:00')      and dim1 = 'abc'    )  ))", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteQueryTest.or(new DimFilter[]{CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim2", "a", null)), CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.not((DimFilter)CalciteQueryTest.timeBound("2000/2001")), CalciteQueryTest.not((DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.selector("dim1", "abc", null), CalciteQueryTest.timeBound("2002-05-01/2003-05-01")}))})})).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{5L}));
    }

    @Test
    public void testCountStarWithNotTimeFilter() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE dim1 <> 'xxx' and not (    (__time >= TIMESTAMP '2000-01-01 00:00:00' AND __time < TIMESTAMP '2001-01-01 00:00:00')    OR (__time >= TIMESTAMP '2003-01-01 00:00:00' AND __time < TIMESTAMP '2004-01-01 00:00:00'))", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(new Interval((ReadableInstant)DateTimes.MIN, (ReadableInstant)DateTimes.of((String)"2000")), Intervals.of((String)"2001/2003"), new Interval((ReadableInstant)DateTimes.of((String)"2004"), (ReadableInstant)DateTimes.MAX))).filters((DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", "xxx", null))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testCountStarWithTimeAndDimFilter() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE dim2 <> 'a' and __time BETWEEN TIMESTAMP '2000-01-01 00:00:00' AND TIMESTAMP '2000-12-31 23:59:59.999'", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01/2001-01-01"))).filters((DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim2", "a", null))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}));
    }

    @Test
    public void testCountStarWithTimeOrDimFilter() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE dim2 <> 'a' or __time BETWEEN TIMESTAMP '2000-01-01 00:00:00' AND TIMESTAMP '2000-12-31 23:59:59.999'", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteQueryTest.or(new DimFilter[]{CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim2", "a", null)), CalciteQueryTest.bound("__time", String.valueOf(CalciteQueryTest.timestamp("2000-01-01")), String.valueOf(CalciteQueryTest.timestamp("2000-12-31T23:59:59.999")), false, false, null, StringComparators.NUMERIC)})).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{5L}));
    }

    @Test
    public void testCountStarWithTimeFilterOnLongColumnUsingExtractEpoch() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE cnt >= EXTRACT(EPOCH FROM TIMESTAMP '1970-01-01 00:00:00') * 1000 AND cnt < EXTRACT(EPOCH FROM TIMESTAMP '1970-01-02 00:00:00') * 1000", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.bound("cnt", String.valueOf(DateTimes.of((String)"1970-01-01").getMillis()), String.valueOf(DateTimes.of((String)"1970-01-02").getMillis()), false, true, null, StringComparators.NUMERIC)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testCountStarWithTimeFilterOnLongColumnUsingExtractEpochFromDate() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE cnt >= EXTRACT(EPOCH FROM DATE '1970-01-01') * 1000 AND cnt < EXTRACT(EPOCH FROM DATE '1970-01-02') * 1000", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.bound("cnt", String.valueOf(DateTimes.of((String)"1970-01-01").getMillis()), String.valueOf(DateTimes.of((String)"1970-01-02").getMillis()), false, true, null, StringComparators.NUMERIC)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testCountStarWithTimeFilterOnLongColumnUsingTimestampToMillis() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE cnt >= TIMESTAMP_TO_MILLIS(TIMESTAMP '1970-01-01 00:00:00') AND cnt < TIMESTAMP_TO_MILLIS(TIMESTAMP '1970-01-02 00:00:00')", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.bound("cnt", String.valueOf(DateTimes.of((String)"1970-01-01").getMillis()), String.valueOf(DateTimes.of((String)"1970-01-02").getMillis()), false, true, null, StringComparators.NUMERIC)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testSumOfString() throws Exception {
        this.testQuery("SELECT SUM(CAST(dim1 AS INTEGER)) FROM druid.foo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "CAST(\"dim1\", 'LONG')", ColumnType.LONG)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "v0", null, CalciteTests.createExprMacroTable())})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{13L}));
    }

    @Test
    public void testSumOfExtractionFn() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT SUM(CAST(SUBSTRING(dim1, 1, 10) AS INTEGER)) FROM druid.foo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "CAST(substring(\"dim1\", 0, 10), 'LONG')", ColumnType.LONG)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "v0", null, CalciteTests.createExprMacroTable())})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{13L}));
    }

    @Test
    public void testTimeseriesWithTimeFilterOnLongColumnUsingMillisToTimestamp() throws Exception {
        this.testQuery("SELECT\n  FLOOR(MILLIS_TO_TIMESTAMP(cnt) TO YEAR),\n  COUNT(*)\nFROM\n  druid.foo\nWHERE\n  MILLIS_TO_TIMESTAMP(cnt) >= TIMESTAMP '1970-01-01 00:00:00'\n  AND MILLIS_TO_TIMESTAMP(cnt) < TIMESTAMP '1970-01-02 00:00:00'\nGROUP BY\n  FLOOR(MILLIS_TO_TIMESTAMP(cnt) TO YEAR)", (List<Query>)ImmutableList.of((Object)new GroupByQuery.Builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"cnt\",'P1Y',null,'UTC')", ColumnType.LONG)}).setDimFilter((DimFilter)CalciteQueryTest.bound("cnt", String.valueOf(DateTimes.of((String)"1970-01-01").getMillis()), String.valueOf(DateTimes.of((String)"1970-01-02").getMillis()), false, true, null, StringComparators.NUMERIC)).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteQueryTest.timestamp("1970-01-01"), 6L}));
    }

    @Test
    public void testCountDistinct() throws Exception {
        this.testQuery("SELECT SUM(cnt), COUNT(distinct dim2), COUNT(distinct unique_dim1) FROM druid.foo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt"), new CardinalityAggregatorFactory("a1", null, CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", null)}), false, true), new HyperUniquesAggregatorFactory("a2", "unique_dim1", false, true)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L, 3L, 6L}));
    }

    @Test
    public void testCountDistinctOfCaseWhen() throws Exception {
        this.testQuery("SELECT\nCOUNT(DISTINCT CASE WHEN m1 >= 4 THEN m1 END),\nCOUNT(DISTINCT CASE WHEN m1 >= 4 THEN dim1 END),\nCOUNT(DISTINCT CASE WHEN m1 >= 4 THEN unique_dim1 END)\nFROM druid.foo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CardinalityAggregatorFactory("a0", null, (List)ImmutableList.of((Object)new DefaultDimensionSpec("m1", "m1", ColumnType.FLOAT)), false, true), (DimFilter)CalciteQueryTest.bound("m1", "4", null, false, false, null, StringComparators.NUMERIC)), new FilteredAggregatorFactory((AggregatorFactory)new CardinalityAggregatorFactory("a1", null, (List)ImmutableList.of((Object)new DefaultDimensionSpec("dim1", "dim1", ColumnType.STRING)), false, true), (DimFilter)CalciteQueryTest.bound("m1", "4", null, false, false, null, StringComparators.NUMERIC)), new FilteredAggregatorFactory((AggregatorFactory)new HyperUniquesAggregatorFactory("a2", "unique_dim1", false, true), (DimFilter)CalciteQueryTest.bound("m1", "4", null, false, false, null, StringComparators.NUMERIC))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L, 3L, 3L}));
    }

    @Test
    public void testExactCountDistinct() throws Exception {
        this.testQuery(PLANNER_CONFIG_NO_HLL, "SELECT COUNT(distinct dim2) FROM druid.foo", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("d0", null, null)))})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{NullHandling.replaceWithDefault() ? 2L : 3L}));
    }

    @Test
    public void testApproxCountDistinctWhenHllDisabled() throws Exception {
        this.testQuery(PLANNER_CONFIG_NO_HLL, "SELECT APPROX_COUNT_DISTINCT(dim2) FROM druid.foo", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CardinalityAggregatorFactory("a0", null, CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", null)}), false, true)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testApproxCountDistinctBuiltin() throws Exception {
        this.testQuery("SELECT APPROX_COUNT_DISTINCT_BUILTIN(dim2) FROM druid.foo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CardinalityAggregatorFactory("a0", null, CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", null)}), false, true)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testExactCountDistinctWithGroupingAndOtherAggregators() throws Exception {
        this.testQuery(PLANNER_CONFIG_NO_HLL, "SELECT dim2, SUM(cnt), COUNT(distinct dim1) FROM druid.foo GROUP BY dim2", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("d1", "_d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_a0", "a0"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("_a1"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("d0", null, null)))})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"", 3L, 3L}, (Object)new Object[]{"a", 2L, 1L}, (Object)new Object[]{"abc", 1L, 1L}) : ImmutableList.of((Object)new Object[]{null, 2L, 2L}, (Object)new Object[]{"", 1L, 1L}, (Object)new Object[]{"a", 2L, 2L}, (Object)new Object[]{"abc", 1L, 1L})));
    }

    @Test
    public void testMultipleExactCountDistinctWithGroupingAndOtherAggregators() throws Exception {
        this.requireMergeBuffers(4);
        this.testQuery(PLANNER_CONFIG_NO_HLL.withOverrides(new QueryContext((Map)ImmutableMap.of((Object)"useGroupingSetForExactDistinct", (Object)"true"))), "SELECT FLOOR(__time to day), COUNT(distinct city), COUNT(distinct user) FROM druid.visits GROUP BY 1", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("visits").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1D',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("city", "d1"), new DefaultDimensionSpec("user", "d2")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new GroupingAggregatorFactory("a0", Arrays.asList("v0", "city", "user"))})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0", (Object)"d1"), (Object)ImmutableList.of((Object)"d0", (Object)"d2"))).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d0", 0, Granularities.DAY)).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("d0", "_d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("_a0"), (DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("d1", null, null)), CalciteQueryTest.selector("a0", "1", null)})), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("_a1"), (DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("d2", null, null)), CalciteQueryTest.selector("a0", "2", null)}))})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1609459200000L, 3L, 2L}, (Object)new Object[]{1609545600000L, 3L, 4L}, (Object)new Object[]{1609632000000L, 1L, 1L}));
    }

    @Test
    public void testApproxCountDistinct() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT\n  SUM(cnt),\n  APPROX_COUNT_DISTINCT(dim2),\n  approx_count_distinct(dim2) FILTER(WHERE dim2 <> ''),\n  APPROX_COUNT_DISTINCT(SUBSTRING(dim2, 1, 1)),\n  APPROX_COUNT_DISTINCT(SUBSTRING(dim2, 1, 1) || 'x'),\n  approx_count_distinct(unique_dim1)\nFROM druid.foo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "concat(substring(\"dim2\", 0, 1),'x')", ColumnType.STRING)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt"), new CardinalityAggregatorFactory("a1", null, CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "dim2")}), false, true), new FilteredAggregatorFactory((AggregatorFactory)new CardinalityAggregatorFactory("a2", null, CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "dim2")}), false, true), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim2", "", null))), new CardinalityAggregatorFactory("a3", null, CalciteQueryTest.dimensions(new DimensionSpec[]{new ExtractionDimensionSpec("dim2", "dim2", ColumnType.STRING, (ExtractionFn)new SubstringDimExtractionFn(0, Integer.valueOf(1)))}), false, true), new CardinalityAggregatorFactory("a4", null, CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "v0", ColumnType.STRING)}), false, true), new HyperUniquesAggregatorFactory("a5", "unique_dim1", false, true)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{6L, 3L, 2L, 2L, 2L, 6L}) : ImmutableList.of((Object)new Object[]{6L, 3L, 2L, 1L, 1L, 6L})));
    }

    @Test
    public void testApproxCountDistinctOnVectorizableSingleStringExpression() throws Exception {
        this.testQuery("SELECT APPROX_COUNT_DISTINCT(dim1 || 'hello') FROM druid.foo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "concat(\"dim1\",'hello')", ColumnType.STRING)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CardinalityAggregatorFactory("a0", null, CalciteQueryTest.dimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"v0")}), false, true)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testNestedGroupBy() throws Exception {
        this.testQuery("SELECT\n    FLOOR(__time to hour) AS __time,\n    dim1,\n    COUNT(m2)\nFROM (\n    SELECT\n        MAX(__time) AS __time,\n        m2,\n        dim1\n    FROM druid.foo\n    WHERE 1=1\n        AND m1 = '5.0'\n    GROUP BY m2, dim1\n)\nGROUP BY FLOOR(__time to hour), dim1", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("m2", "d1", ColumnType.DOUBLE)})).setDimFilter((DimFilter)new SelectorDimFilter("m1", "5.0", null)).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongMaxAggregatorFactory("a0", "__time")})).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"a0\",'PT1H',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.LONG), new DefaultDimensionSpec("d0", "_d1", ColumnType.STRING)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{this.useDefault ? new CountAggregatorFactory("_a0") : new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("_a0"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("d1", null, null)))})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{978393600000L, "def", 1L}));
    }

    @Test
    public void testDoubleNestedGroupBy() throws Exception {
        this.requireMergeBuffers(3);
        this.testQuery("SELECT SUM(cnt), COUNT(*) FROM (\n  SELECT dim2, SUM(t1.cnt) cnt FROM (\n    SELECT\n      dim1,\n      dim2,\n      COUNT(*) cnt\n    FROM druid.foo\n    GROUP BY dim1, dim2\n  ) t1\n  GROUP BY dim2\n) t2", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("d1", "_d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_a0", "a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "_a0"), new CountAggregatorFactory("a1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{6L, 3L}) : ImmutableList.of((Object)new Object[]{6L, 4L})));
    }

    @Test
    public void testDoubleNestedGroupBy2() throws Exception {
        this.testQuery("SELECT MAX(cnt) FROM (\n  SELECT dim2, MAX(t1.cnt) cnt FROM (\n    SELECT\n      dim1,\n      dim2,\n      COUNT(*) cnt\n    FROM druid.foo\n    GROUP BY dim1, dim2\n  ) t1\n  GROUP BY dim2\n) t2", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("d1", "_d0")}).setAggregatorSpecs(new AggregatorFactory[]{new LongMaxAggregatorFactory("_a0", "a0")}).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(new AggregatorFactory[]{new LongMaxAggregatorFactory("a0", "_a0")}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testExactCountDistinctUsingSubquery() throws Exception {
        this.testQuery("SELECT\n  SUM(cnt),\n  COUNT(*)\nFROM (SELECT dim2, SUM(cnt) AS cnt FROM druid.foo GROUP BY dim2)", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_a0", "a0"), new CountAggregatorFactory("_a1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{6L, 3L}) : ImmutableList.of((Object)new Object[]{6L, 4L})));
    }

    @Test
    public void testExactCountDistinctUsingSubqueryOnUnionAllTables() throws Exception {
        this.testQuery("SELECT\n  SUM(cnt),\n  COUNT(*)\nFROM (\n  SELECT dim2, SUM(cnt) AS cnt\n  FROM (SELECT * FROM druid.foo UNION ALL SELECT * FROM druid.foo)\n  GROUP BY dim2\n)", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource("foo"), (Object)new TableDataSource("foo")))).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_a0", "a0"), new CountAggregatorFactory("_a1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{12L, 3L}) : ImmutableList.of((Object)new Object[]{12L, 4L})));
    }

    @Test
    public void testMinMaxAvgDailyCountWithLimit() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT * FROM (  SELECT max(cnt), min(cnt), avg(cnt), TIME_EXTRACT(max(t), 'EPOCH') last_time, count(1) num_days FROM (\n      SELECT TIME_FLOOR(__time, 'P1D') AS t, count(1) cnt\n      FROM \"foo\"\n      GROUP BY 1\n  )) LIMIT 1\n", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").granularity((Granularity)new PeriodGranularity(Period.days((int)1), null, DateTimeZone.UTC)).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of(), Integer.valueOf(1))).setGranularity(Granularities.ALL).setAggregatorSpecs(this.useDefault ? CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongMaxAggregatorFactory("_a0", "a0"), new LongMinAggregatorFactory("_a1", "a0"), new LongSumAggregatorFactory("_a2:sum", "a0"), new CountAggregatorFactory("_a2:count"), new LongMaxAggregatorFactory("_a3", "d0"), new CountAggregatorFactory("_a4")}) : CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongMaxAggregatorFactory("_a0", "a0"), new LongMinAggregatorFactory("_a1", "a0"), new LongSumAggregatorFactory("_a2:sum", "a0"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("_a2:count"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("a0", null, null))), new LongMaxAggregatorFactory("_a3", "d0"), new CountAggregatorFactory("_a4")})).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ArithmeticPostAggregator("_a2", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "_a2:sum"), (Object)new FieldAccessPostAggregator(null, "_a2:count"))), (Object)CalciteQueryTest.expressionPostAgg("s0", "timestamp_extract(\"_a3\",'EPOCH','UTC')"))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, 1L, 1L, 978480000L, 6L}));
    }

    @Test
    public void testAvgDailyCountDistinct() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT\n  AVG(u)\nFROM (SELECT FLOOR(__time TO DAY), APPROX_COUNT_DISTINCT(cnt) AS u FROM druid.foo GROUP BY 1)", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity((Granularity)new PeriodGranularity(Period.days((int)1), null, DateTimeZone.UTC)).aggregators(new AggregatorFactory[]{new CardinalityAggregatorFactory("a0:a", null, CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("cnt", "cnt", ColumnType.LONG)}), false, true)}).postAggregators((List)ImmutableList.of((Object)new HyperUniqueFinalizingPostAggregator("a0", "a0:a"))).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(this.useDefault ? CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_a0:sum", "a0"), new CountAggregatorFactory("_a0:count")}) : CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_a0:sum", "a0"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("_a0:count"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("a0", null, null)))})).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ArithmeticPostAggregator("_a0", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "_a0:sum"), (Object)new FieldAccessPostAggregator(null, "_a0:count"))))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testExactCountDistinctOfSemiJoinResult() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(*)\nFROM (\n  SELECT DISTINCT dim2\n  FROM druid.foo\n  WHERE SUBSTRING(dim2, 1, 1) IN (\n    SELECT SUBSTRING(dim1, 1, 1) FROM druid.foo WHERE dim1 <> ''\n  ) AND __time >= '2000-01-01' AND __time < '2002-01-01'\n)", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)CalciteQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", "", null))).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new ExtractionDimensionSpec("dim1", "d0", (ExtractionFn)new SubstringDimExtractionFn(0, Integer.valueOf(1)))})).setContext(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteQueryTest.equalsCondition(CalciteQueryTest.makeExpression("substring(\"dim2\", 0, 1)"), DruidExpression.ofColumn((ColumnType)ColumnType.STRING, (String)"j0.d0")), JoinType.INNER)).setInterval(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01/2002-01-01"))).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}));
    }

    @Test
    public void testMaxSubqueryRows() throws Exception {
        this.expectedException.expect(ResourceLimitExceededException.class);
        this.expectedException.expectMessage("Subquery generated results beyond maximum[2]");
        this.testQuery(PLANNER_CONFIG_DEFAULT, (Map<String, Object>)ImmutableMap.of((Object)"maxSubqueryRows", (Object)2), "SELECT COUNT(*)\nFROM druid.foo\nWHERE SUBSTRING(dim2, 1, 1) IN (\n  SELECT SUBSTRING(dim1, 1, 1) FROM druid.foo WHERE dim1 <> ''\n)\n", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testZeroMaxNumericInFilter() throws Exception {
        this.expectedException.expect(UOE.class);
        this.expectedException.expectMessage("[maxNumericInFilters] must be greater than 0");
        this.testQuery(PLANNER_CONFIG_DEFAULT, (Map<String, Object>)ImmutableMap.of((Object)"maxNumericInFilters", (Object)0), "SELECT COUNT(*)\nFROM druid.numfoo\nWHERE dim6 IN (\n1,2,3\n)\n", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testHighestMaxNumericInFilter() throws Exception {
        this.expectedException.expect(UOE.class);
        this.expectedException.expectMessage("Expected parameter[maxNumericInFilters] cannot exceed system set value of [100]");
        this.testQuery(PLANNER_CONFIG_MAX_NUMERIC_IN_FILTER, (Map<String, Object>)ImmutableMap.of((Object)"maxNumericInFilters", (Object)20000), "SELECT COUNT(*)\nFROM druid.numfoo\nWHERE dim6 IN (\n1,2,3\n)\n", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testQueryWithMoreThanMaxNumericInFilter() throws Exception {
        this.expectedException.expect(UOE.class);
        this.expectedException.expectMessage("The number of values in the IN clause for [dim6] in query exceeds configured maxNumericFilter limit of [2] for INs. Cast [3] values of IN clause to String");
        this.testQuery(PLANNER_CONFIG_MAX_NUMERIC_IN_FILTER, (Map<String, Object>)ImmutableMap.of((Object)"maxNumericInFilters", (Object)2), "SELECT COUNT(*)\nFROM druid.numfoo\nWHERE dim6 IN (\n1,2,3\n)\n", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testExplainExactCountDistinctOfSemiJoinResult() throws Exception {
        this.skipVectorize();
        String query = "EXPLAIN PLAN FOR SELECT COUNT(*)\nFROM (\n  SELECT DISTINCT dim2\n  FROM druid.foo\n  WHERE SUBSTRING(dim2, 1, 1) IN (\n    SELECT SUBSTRING(dim1, 1, 1) FROM druid.foo WHERE dim1 IS NOT NULL\n  )\n)";
        String legacyExplanation = "DruidOuterQueryRel(query=[{\"queryType\":\"groupBy\",\"dataSource\":{\"type\":\"query\",\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"__subquery__\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"list\",\"batchSize\":20480,\"filter\":null,\"context\":{},\"descending\":false,\"granularity\":{\"type\":\"all\"}}},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"filter\":null,\"granularity\":{\"type\":\"all\"},\"dimensions\":[],\"aggregations\":[{\"type\":\"count\",\"name\":\"a0\"}],\"postAggregations\":[],\"having\":null,\"limitSpec\":{\"type\":\"NoopLimitSpec\"},\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false}], signature=[{a0:LONG}])\n  DruidJoinQueryRel(condition=[=(SUBSTRING($3, 1, 1), $8)], joinType=[inner], query=[{\"queryType\":\"groupBy\",\"dataSource\":{\"type\":\"table\",\"name\":\"__join__\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"filter\":null,\"granularity\":{\"type\":\"all\"},\"dimensions\":[{\"type\":\"default\",\"dimension\":\"dim2\",\"outputName\":\"d0\",\"outputType\":\"STRING\"}],\"aggregations\":[],\"postAggregations\":[],\"having\":null,\"limitSpec\":{\"type\":\"NoopLimitSpec\"},\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false}], signature=[{d0:STRING}])\n    DruidQueryRel(query=[{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"compactedList\",\"batchSize\":20480,\"filter\":null,\"columns\":[\"__time\",\"cnt\",\"dim1\",\"dim2\",\"dim3\",\"m1\",\"m2\",\"unique_dim1\"],\"legacy\":false,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false,\"granularity\":{\"type\":\"all\"}}], signature=[{__time:LONG, cnt:LONG, dim1:STRING, dim2:STRING, dim3:STRING, m1:FLOAT, m2:DOUBLE, unique_dim1:COMPLEX<hyperUnique>}])\n    DruidQueryRel(query=[{\"queryType\":\"groupBy\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"filter\":{\"type\":\"not\",\"field\":{\"type\":\"selector\",\"dimension\":\"dim1\",\"value\":null,\"extractionFn\":null}},\"granularity\":{\"type\":\"all\"},\"dimensions\":[{\"type\":\"extraction\",\"dimension\":\"dim1\",\"outputName\":\"d0\",\"outputType\":\"STRING\",\"extractionFn\":{\"type\":\"substring\",\"index\":0,\"length\":1}}],\"aggregations\":[],\"postAggregations\":[],\"having\":null,\"limitSpec\":{\"type\":\"NoopLimitSpec\"},\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false}], signature=[{d0:STRING}])\n";
        String explanation = "[{\"query\":{\"queryType\":\"groupBy\",\"dataSource\":{\"type\":\"query\",\"query\":{\"queryType\":\"groupBy\",\"dataSource\":{\"type\":\"join\",\"left\":{\"type\":\"table\",\"name\":\"foo\"},\"right\":{\"type\":\"query\",\"query\":{\"queryType\":\"groupBy\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"filter\":{\"type\":\"not\",\"field\":{\"type\":\"selector\",\"dimension\":\"dim1\",\"value\":null,\"extractionFn\":null}},\"granularity\":{\"type\":\"all\"},\"dimensions\":[{\"type\":\"extraction\",\"dimension\":\"dim1\",\"outputName\":\"d0\",\"outputType\":\"STRING\",\"extractionFn\":{\"type\":\"substring\",\"index\":0,\"length\":1}}],\"aggregations\":[],\"postAggregations\":[],\"having\":null,\"limitSpec\":{\"type\":\"NoopLimitSpec\"},\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false}},\"rightPrefix\":\"j0.\",\"condition\":\"(substring(\\\"dim2\\\", 0, 1) == \\\"j0.d0\\\")\",\"joinType\":\"INNER\",\"leftFilter\":null},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"filter\":null,\"granularity\":{\"type\":\"all\"},\"dimensions\":[{\"type\":\"default\",\"dimension\":\"dim2\",\"outputName\":\"d0\",\"outputType\":\"STRING\"}],\"aggregations\":[],\"postAggregations\":[],\"having\":null,\"limitSpec\":{\"type\":\"NoopLimitSpec\"},\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false}},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"filter\":null,\"granularity\":{\"type\":\"all\"},\"dimensions\":[],\"aggregations\":[{\"type\":\"count\",\"name\":\"a0\"}],\"postAggregations\":[],\"having\":null,\"limitSpec\":{\"type\":\"NoopLimitSpec\"},\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false},\"signature\":[{\"name\":\"a0\",\"type\":\"LONG\"}]}]";
        String resources = "[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]";
        this.testQuery("EXPLAIN PLAN FOR SELECT COUNT(*)\nFROM (\n  SELECT DISTINCT dim2\n  FROM druid.foo\n  WHERE SUBSTRING(dim2, 1, 1) IN (\n    SELECT SUBSTRING(dim1, 1, 1) FROM druid.foo WHERE dim1 IS NOT NULL\n  )\n)", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"DruidOuterQueryRel(query=[{\"queryType\":\"groupBy\",\"dataSource\":{\"type\":\"query\",\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"__subquery__\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"list\",\"batchSize\":20480,\"filter\":null,\"context\":{},\"descending\":false,\"granularity\":{\"type\":\"all\"}}},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"filter\":null,\"granularity\":{\"type\":\"all\"},\"dimensions\":[],\"aggregations\":[{\"type\":\"count\",\"name\":\"a0\"}],\"postAggregations\":[],\"having\":null,\"limitSpec\":{\"type\":\"NoopLimitSpec\"},\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false}], signature=[{a0:LONG}])\n  DruidJoinQueryRel(condition=[=(SUBSTRING($3, 1, 1), $8)], joinType=[inner], query=[{\"queryType\":\"groupBy\",\"dataSource\":{\"type\":\"table\",\"name\":\"__join__\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"filter\":null,\"granularity\":{\"type\":\"all\"},\"dimensions\":[{\"type\":\"default\",\"dimension\":\"dim2\",\"outputName\":\"d0\",\"outputType\":\"STRING\"}],\"aggregations\":[],\"postAggregations\":[],\"having\":null,\"limitSpec\":{\"type\":\"NoopLimitSpec\"},\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false}], signature=[{d0:STRING}])\n    DruidQueryRel(query=[{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"compactedList\",\"batchSize\":20480,\"filter\":null,\"columns\":[\"__time\",\"cnt\",\"dim1\",\"dim2\",\"dim3\",\"m1\",\"m2\",\"unique_dim1\"],\"legacy\":false,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false,\"granularity\":{\"type\":\"all\"}}], signature=[{__time:LONG, cnt:LONG, dim1:STRING, dim2:STRING, dim3:STRING, m1:FLOAT, m2:DOUBLE, unique_dim1:COMPLEX<hyperUnique>}])\n    DruidQueryRel(query=[{\"queryType\":\"groupBy\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"filter\":{\"type\":\"not\",\"field\":{\"type\":\"selector\",\"dimension\":\"dim1\",\"value\":null,\"extractionFn\":null}},\"granularity\":{\"type\":\"all\"},\"dimensions\":[{\"type\":\"extraction\",\"dimension\":\"dim1\",\"outputName\":\"d0\",\"outputType\":\"STRING\",\"extractionFn\":{\"type\":\"substring\",\"index\":0,\"length\":1}}],\"aggregations\":[],\"postAggregations\":[],\"having\":null,\"limitSpec\":{\"type\":\"NoopLimitSpec\"},\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false}], signature=[{d0:STRING}])\n", "[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]"}));
        this.testQuery(PLANNER_CONFIG_NATIVE_QUERY_EXPLAIN, "EXPLAIN PLAN FOR SELECT COUNT(*)\nFROM (\n  SELECT DISTINCT dim2\n  FROM druid.foo\n  WHERE SUBSTRING(dim2, 1, 1) IN (\n    SELECT SUBSTRING(dim1, 1, 1) FROM druid.foo WHERE dim1 IS NOT NULL\n  )\n)", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[{\"query\":{\"queryType\":\"groupBy\",\"dataSource\":{\"type\":\"query\",\"query\":{\"queryType\":\"groupBy\",\"dataSource\":{\"type\":\"join\",\"left\":{\"type\":\"table\",\"name\":\"foo\"},\"right\":{\"type\":\"query\",\"query\":{\"queryType\":\"groupBy\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"filter\":{\"type\":\"not\",\"field\":{\"type\":\"selector\",\"dimension\":\"dim1\",\"value\":null,\"extractionFn\":null}},\"granularity\":{\"type\":\"all\"},\"dimensions\":[{\"type\":\"extraction\",\"dimension\":\"dim1\",\"outputName\":\"d0\",\"outputType\":\"STRING\",\"extractionFn\":{\"type\":\"substring\",\"index\":0,\"length\":1}}],\"aggregations\":[],\"postAggregations\":[],\"having\":null,\"limitSpec\":{\"type\":\"NoopLimitSpec\"},\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false}},\"rightPrefix\":\"j0.\",\"condition\":\"(substring(\\\"dim2\\\", 0, 1) == \\\"j0.d0\\\")\",\"joinType\":\"INNER\",\"leftFilter\":null},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"filter\":null,\"granularity\":{\"type\":\"all\"},\"dimensions\":[{\"type\":\"default\",\"dimension\":\"dim2\",\"outputName\":\"d0\",\"outputType\":\"STRING\"}],\"aggregations\":[],\"postAggregations\":[],\"having\":null,\"limitSpec\":{\"type\":\"NoopLimitSpec\"},\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false}},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"filter\":null,\"granularity\":{\"type\":\"all\"},\"dimensions\":[],\"aggregations\":[{\"type\":\"count\",\"name\":\"a0\"}],\"postAggregations\":[],\"having\":null,\"limitSpec\":{\"type\":\"NoopLimitSpec\"},\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false},\"signature\":[{\"name\":\"a0\",\"type\":\"LONG\"}]}]", "[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]"}));
    }

    @Test
    public void testExplainSelectStarWithOverrides() throws Exception {
        HashMap<String, Object> useRegularExplainContext = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        useRegularExplainContext.put("useNativeQueryExplain", false);
        HashMap<String, Object> useNativeQueryExplain = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        useNativeQueryExplain.put("useNativeQueryExplain", true);
        this.skipVectorize();
        String legacyExplanation = "DruidQueryRel(query=[{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"compactedList\",\"batchSize\":20480,\"filter\":null,\"columns\":[\"__time\",\"cnt\",\"dim1\",\"dim2\",\"dim3\",\"m1\",\"m2\",\"unique_dim1\"],\"legacy\":false,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false,\"granularity\":{\"type\":\"all\"}}], signature=[{__time:LONG, cnt:LONG, dim1:STRING, dim2:STRING, dim3:STRING, m1:FLOAT, m2:DOUBLE, unique_dim1:COMPLEX<hyperUnique>}])\n";
        String legacyExplanationWithContext = "DruidQueryRel(query=[{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"compactedList\",\"batchSize\":20480,\"filter\":null,\"columns\":[\"__time\",\"cnt\",\"dim1\",\"dim2\",\"dim3\",\"m1\",\"m2\",\"unique_dim1\"],\"legacy\":false,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"useNativeQueryExplain\":false},\"descending\":false,\"granularity\":{\"type\":\"all\"}}], signature=[{__time:LONG, cnt:LONG, dim1:STRING, dim2:STRING, dim3:STRING, m1:FLOAT, m2:DOUBLE, unique_dim1:COMPLEX<hyperUnique>}])\n";
        String explanation = "[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"compactedList\",\"batchSize\":20480,\"filter\":null,\"columns\":[\"__time\",\"cnt\",\"dim1\",\"dim2\",\"dim3\",\"m1\",\"m2\",\"unique_dim1\"],\"legacy\":false,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false,\"granularity\":{\"type\":\"all\"}},\"signature\":[{\"name\":\"__time\",\"type\":\"LONG\"},{\"name\":\"cnt\",\"type\":\"LONG\"},{\"name\":\"dim1\",\"type\":\"STRING\"},{\"name\":\"dim2\",\"type\":\"STRING\"},{\"name\":\"dim3\",\"type\":\"STRING\"},{\"name\":\"m1\",\"type\":\"FLOAT\"},{\"name\":\"m2\",\"type\":\"DOUBLE\"},{\"name\":\"unique_dim1\",\"type\":\"COMPLEX<hyperUnique>\"}]}]";
        String explanationWithContext = "[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"compactedList\",\"batchSize\":20480,\"filter\":null,\"columns\":[\"__time\",\"cnt\",\"dim1\",\"dim2\",\"dim3\",\"m1\",\"m2\",\"unique_dim1\"],\"legacy\":false,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"useNativeQueryExplain\":true,\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false,\"granularity\":{\"type\":\"all\"}},\"signature\":[{\"name\":\"__time\",\"type\":\"LONG\"},{\"name\":\"cnt\",\"type\":\"LONG\"},{\"name\":\"dim1\",\"type\":\"STRING\"},{\"name\":\"dim2\",\"type\":\"STRING\"},{\"name\":\"dim3\",\"type\":\"STRING\"},{\"name\":\"m1\",\"type\":\"FLOAT\"},{\"name\":\"m2\",\"type\":\"DOUBLE\"},{\"name\":\"unique_dim1\",\"type\":\"COMPLEX<hyperUnique>\"}]}]";
        String sql = "EXPLAIN PLAN FOR SELECT * FROM druid.foo";
        String resources = "[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]";
        this.testQuery(sql, (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{legacyExplanation, resources}));
        this.testQuery(sql, useNativeQueryExplain, (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{explanationWithContext, resources}));
        this.testQuery(PLANNER_CONFIG_NATIVE_QUERY_EXPLAIN, sql, CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{explanation, resources}));
        this.testQuery(PLANNER_CONFIG_NATIVE_QUERY_EXPLAIN, useRegularExplainContext, sql, CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{legacyExplanationWithContext, resources}));
    }

    @Test
    public void testExplainMultipleTopLevelUnionAllQueries() throws Exception {
        this.skipVectorize();
        String query = "EXPLAIN PLAN FOR SELECT dim1 FROM druid.foo\nUNION ALL (SELECT dim1 FROM druid.foo WHERE dim1 = '42'\nUNION ALL SELECT dim1 FROM druid.foo WHERE dim1 = '44')";
        String legacyExplanation = "DruidUnionRel(limit=[-1])\n  DruidQueryRel(query=[{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"compactedList\",\"batchSize\":20480,\"filter\":null,\"columns\":[\"dim1\"],\"legacy\":false,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false,\"granularity\":{\"type\":\"all\"}}], signature=[{dim1:STRING}])\n  DruidUnionRel(limit=[-1])\n    DruidQueryRel(query=[{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"compactedList\",\"batchSize\":20480,\"filter\":{\"type\":\"selector\",\"dimension\":\"dim1\",\"value\":\"42\",\"extractionFn\":null},\"columns\":[\"dim1\"],\"legacy\":false,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false,\"granularity\":{\"type\":\"all\"}}], signature=[{dim1:STRING}])\n    DruidQueryRel(query=[{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"compactedList\",\"batchSize\":20480,\"filter\":{\"type\":\"selector\",\"dimension\":\"dim1\",\"value\":\"44\",\"extractionFn\":null},\"columns\":[\"dim1\"],\"legacy\":false,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false,\"granularity\":{\"type\":\"all\"}}], signature=[{dim1:STRING}])\n";
        String explanation = "[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"compactedList\",\"batchSize\":20480,\"filter\":null,\"columns\":[\"dim1\"],\"legacy\":false,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false,\"granularity\":{\"type\":\"all\"}},\"signature\":[{\"name\":\"dim1\",\"type\":\"STRING\"}]},{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"compactedList\",\"batchSize\":20480,\"filter\":{\"type\":\"selector\",\"dimension\":\"dim1\",\"value\":\"42\",\"extractionFn\":null},\"columns\":[\"dim1\"],\"legacy\":false,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false,\"granularity\":{\"type\":\"all\"}},\"signature\":[{\"name\":\"dim1\",\"type\":\"STRING\"}]},{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"compactedList\",\"batchSize\":20480,\"filter\":{\"type\":\"selector\",\"dimension\":\"dim1\",\"value\":\"44\",\"extractionFn\":null},\"columns\":[\"dim1\"],\"legacy\":false,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false,\"granularity\":{\"type\":\"all\"}},\"signature\":[{\"name\":\"dim1\",\"type\":\"STRING\"}]}]";
        String resources = "[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]";
        this.testQuery("EXPLAIN PLAN FOR SELECT dim1 FROM druid.foo\nUNION ALL (SELECT dim1 FROM druid.foo WHERE dim1 = '42'\nUNION ALL SELECT dim1 FROM druid.foo WHERE dim1 = '44')", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"DruidUnionRel(limit=[-1])\n  DruidQueryRel(query=[{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"compactedList\",\"batchSize\":20480,\"filter\":null,\"columns\":[\"dim1\"],\"legacy\":false,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false,\"granularity\":{\"type\":\"all\"}}], signature=[{dim1:STRING}])\n  DruidUnionRel(limit=[-1])\n    DruidQueryRel(query=[{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"compactedList\",\"batchSize\":20480,\"filter\":{\"type\":\"selector\",\"dimension\":\"dim1\",\"value\":\"42\",\"extractionFn\":null},\"columns\":[\"dim1\"],\"legacy\":false,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false,\"granularity\":{\"type\":\"all\"}}], signature=[{dim1:STRING}])\n    DruidQueryRel(query=[{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"compactedList\",\"batchSize\":20480,\"filter\":{\"type\":\"selector\",\"dimension\":\"dim1\",\"value\":\"44\",\"extractionFn\":null},\"columns\":[\"dim1\"],\"legacy\":false,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false,\"granularity\":{\"type\":\"all\"}}], signature=[{dim1:STRING}])\n", "[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]"}));
        this.testQuery(PLANNER_CONFIG_NATIVE_QUERY_EXPLAIN, "EXPLAIN PLAN FOR SELECT dim1 FROM druid.foo\nUNION ALL (SELECT dim1 FROM druid.foo WHERE dim1 = '42'\nUNION ALL SELECT dim1 FROM druid.foo WHERE dim1 = '44')", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"compactedList\",\"batchSize\":20480,\"filter\":null,\"columns\":[\"dim1\"],\"legacy\":false,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false,\"granularity\":{\"type\":\"all\"}},\"signature\":[{\"name\":\"dim1\",\"type\":\"STRING\"}]},{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"compactedList\",\"batchSize\":20480,\"filter\":{\"type\":\"selector\",\"dimension\":\"dim1\",\"value\":\"42\",\"extractionFn\":null},\"columns\":[\"dim1\"],\"legacy\":false,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false,\"granularity\":{\"type\":\"all\"}},\"signature\":[{\"name\":\"dim1\",\"type\":\"STRING\"}]},{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[],\"resultFormat\":\"compactedList\",\"batchSize\":20480,\"filter\":{\"type\":\"selector\",\"dimension\":\"dim1\",\"value\":\"44\",\"extractionFn\":null},\"columns\":[\"dim1\"],\"legacy\":false,\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"descending\":false,\"granularity\":{\"type\":\"all\"}},\"signature\":[{\"name\":\"dim1\",\"type\":\"STRING\"}]}]", "[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]"}));
    }

    @Test
    public void testExactCountDistinctUsingSubqueryWithWherePushDown() throws Exception {
        this.testQuery("SELECT\n  SUM(cnt),\n  COUNT(*)\nFROM (SELECT dim2, SUM(cnt) AS cnt FROM druid.foo GROUP BY dim2)\nWHERE dim2 <> ''", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter((DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim2", "", null))).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_a0", "a0"), new CountAggregatorFactory("_a1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{3L, 2L}) : ImmutableList.of((Object)new Object[]{5L, 3L})));
        this.testQuery("SELECT\n  SUM(cnt),\n  COUNT(*)\nFROM (SELECT dim2, SUM(cnt) AS cnt FROM druid.foo GROUP BY dim2)\nWHERE dim2 IS NOT NULL", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter((DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim2", null, null))).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_a0", "a0"), new CountAggregatorFactory("_a1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{3L, 2L}) : ImmutableList.of((Object)new Object[]{4L, 3L})));
    }

    @Test
    public void testExactCountDistinctUsingSubqueryWithWhereToOuterFilter() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT\n  SUM(cnt),\n  COUNT(*)\nFROM (SELECT dim2, SUM(cnt) AS cnt FROM druid.foo GROUP BY dim2 LIMIT 1)WHERE cnt > 0", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)new TopNQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim2", "d0")).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")}).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC)).threshold(1).context(QUERY_CONTEXT_DEFAULT).build())).setDimFilter((DimFilter)CalciteQueryTest.bound("a0", "0", null, true, false, null, StringComparators.NUMERIC)).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_a0", "a0"), new CountAggregatorFactory("_a1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{3L, 1L}) : ImmutableList.of((Object)new Object[]{2L, 1L})));
    }

    @Test
    public void testCompareExactAndApproximateCountDistinctUsingSubquery() throws Exception {
        this.testQuery("SELECT\n  COUNT(*) AS exact_count,\n  COUNT(DISTINCT dim1) AS approx_count,\n  (CAST(1 AS FLOAT) - COUNT(DISTINCT dim1) / COUNT(*)) * 100 AS error_pct\nFROM (SELECT DISTINCT dim1 FROM druid.foo WHERE dim1 <> '')", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", "", null))).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0"), new CardinalityAggregatorFactory("a1", null, CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("d0", null)}), false, true)})).setPostAggregatorSpecs((List)ImmutableList.of((Object)CalciteQueryTest.expressionPostAgg("p0", "((1 - (\"a1\" / \"a0\")) * 100)"))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{5L, 5L, Float.valueOf(0.0f)}));
    }

    @Test
    public void testHistogramUsingSubquery() throws Exception {
        this.testQuery("SELECT\n  CAST(thecnt AS VARCHAR),\n  COUNT(*)\nFROM (SELECT dim2, SUM(cnt) AS thecnt FROM druid.foo GROUP BY dim2)\nGROUP BY CAST(thecnt AS VARCHAR)", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("a0", "_d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("_a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"1", 1L}, (Object)new Object[]{"2", 1L}, (Object)new Object[]{"3", 1L}) : ImmutableList.of((Object)new Object[]{"1", 2L}, (Object)new Object[]{"2", 2L})));
    }

    @Test
    public void testHistogramUsingSubqueryWithSort() throws Exception {
        this.testQuery("SELECT\n  CAST(thecnt AS VARCHAR),\n  COUNT(*)\nFROM (SELECT dim2, SUM(cnt) AS thecnt FROM druid.foo GROUP BY dim2)\nGROUP BY CAST(thecnt AS VARCHAR) ORDER BY CAST(thecnt AS VARCHAR) LIMIT 2", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("a0", "_d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("_a0")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("_d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC)), Integer.valueOf(2))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"1", 1L}, (Object)new Object[]{"2", 1L}) : ImmutableList.of((Object)new Object[]{"1", 2L}, (Object)new Object[]{"2", 2L})));
    }

    @Test
    public void testCountDistinctArithmetic() throws Exception {
        this.testQuery("SELECT\n  SUM(cnt),\n  COUNT(DISTINCT dim2),\n  CAST(COUNT(DISTINCT dim2) AS FLOAT),\n  SUM(cnt) / COUNT(DISTINCT dim2),\n  SUM(cnt) / COUNT(DISTINCT dim2) + 3,\n  CAST(SUM(cnt) AS FLOAT) / CAST(COUNT(DISTINCT dim2) AS FLOAT) + 3\nFROM druid.foo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt"), new CardinalityAggregatorFactory("a1", null, CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", null)}), false, true)})).postAggregators(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("p0", "CAST(\"a1\", 'DOUBLE')"), CalciteQueryTest.expressionPostAgg("p1", "(\"a0\" / \"a1\")"), CalciteQueryTest.expressionPostAgg("p2", "((\"a0\" / \"a1\") + 3)"), CalciteQueryTest.expressionPostAgg("p3", "((CAST(\"a0\", 'DOUBLE') / CAST(\"a1\", 'DOUBLE')) + 3)")}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L, 3L, Float.valueOf(3.0f), 2L, 5L, Float.valueOf(5.0f)}));
    }

    @Test
    public void testCountDistinctOfSubstring() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(DISTINCT SUBSTRING(dim1, 1, 1)) FROM druid.foo WHERE dim1 <> ''", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", "", null))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CardinalityAggregatorFactory("a0", null, CalciteQueryTest.dimensions(new DimensionSpec[]{new ExtractionDimensionSpec("dim1", null, (ExtractionFn)new SubstringDimExtractionFn(0, Integer.valueOf(1)))}), false, true)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{4L}));
    }

    @Test
    public void testCountDistinctOfTrim() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(DISTINCT TRIM(BOTH ' ' FROM dim1)) FROM druid.foo WHERE TRIM(dim1) <> ''", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "trim(\"dim1\",' ')", ColumnType.STRING)}).filters((DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("v0", NullHandling.emptyToNullIfNeeded((String)""), null))).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CardinalityAggregatorFactory("a0", null, CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "v0", ColumnType.STRING)}), false, true)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{5L}));
    }

    @Test
    public void testSillyQuarters() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT CAST((EXTRACT(MONTH FROM __time) - 1 ) / 3 + 1 AS INTEGER) AS quarter, COUNT(*)\nFROM foo\nGROUP BY CAST((EXTRACT(MONTH FROM __time) - 1 ) / 3 + 1 AS INTEGER)", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "(((timestamp_extract(\"__time\",'MONTH','UTC') - 1) / 3) + 1)", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1, 6L}));
    }

    @Test
    public void testRegexpExtract() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT DISTINCT\n  REGEXP_EXTRACT(dim1, '^.'),\n  REGEXP_EXTRACT(dim1, '^(.)', 1)\nFROM foo\nWHERE REGEXP_EXTRACT(dim1, '^(.)', 1) <> 'x'", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", "x", (ExtractionFn)new RegexDimExtractionFn("^(.)", Integer.valueOf(1), Boolean.valueOf(true), null)))).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new ExtractionDimensionSpec("dim1", "d0", (ExtractionFn)new RegexDimExtractionFn("^.", Integer.valueOf(0), Boolean.valueOf(true), null)), new ExtractionDimensionSpec("dim1", "d1", (ExtractionFn)new RegexDimExtractionFn("^(.)", Integer.valueOf(1), Boolean.valueOf(true), null))})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{NULL_STRING, NULL_STRING}, (Object)new Object[]{"1", "1"}, (Object)new Object[]{"2", "2"}, (Object)new Object[]{"a", "a"}, (Object)new Object[]{"d", "d"}));
    }

    @Test
    public void testRegexpExtractFilterViaNotNullCheck() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(*)\nFROM foo\nWHERE REGEXP_EXTRACT(dim1, '^1') IS NOT NULL OR REGEXP_EXTRACT('Z' || dim1, '^Z2') IS NOT NULL", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "regexp_extract(concat('Z',\"dim1\"),'^Z2')", ColumnType.STRING)}).filters((DimFilter)CalciteQueryTest.or(new DimFilter[]{CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", null, (ExtractionFn)new RegexDimExtractionFn("^1", Integer.valueOf(0), Boolean.valueOf(true), null))), CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("v0", null, null))})).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testRegexpLikeFilter() throws Exception {
        this.testQuery("SELECT COUNT(*)\nFROM foo\nWHERE REGEXP_LIKE(dim1, '^1') OR REGEXP_LIKE('Z' || dim1, '^Z2')", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "concat('Z',\"dim1\")", ColumnType.STRING)}).filters((DimFilter)CalciteQueryTest.or(new DimFilter[]{new RegexDimFilter("dim1", "^1", null), new RegexDimFilter("v0", "^Z2", null)})).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testGroupBySortPushDown() throws Exception {
        this.testQuery("SELECT dim2, dim1, SUM(cnt) FROM druid.foo GROUP BY dim2, dim1 ORDER BY dim1 LIMIT 4", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING)), Integer.valueOf(4))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", "", 1L}, (Object)new Object[]{"a", "1", 1L}, (Object)new Object[]{NULL_STRING, "10.1", 1L}, (Object)new Object[]{"", "2", 1L}));
    }

    @Test
    public void testGroupByLimitPushDownWithHavingOnLong() throws Exception {
        this.testQuery("SELECT dim1, dim2, SUM(cnt) AS thecnt FROM druid.foo group by dim1, dim2 having SUM(cnt) = 1 order by dim2 limit 4", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.ASCENDING)), Integer.valueOf(4))).setHavingSpec((HavingSpec)CalciteQueryTest.having((DimFilter)CalciteQueryTest.selector("a0", "1", null))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"10.1", "", 1L}, (Object)new Object[]{"2", "", 1L}, (Object)new Object[]{"abc", "", 1L}, (Object)new Object[]{"", "a", 1L}) : ImmutableList.of((Object)new Object[]{"10.1", null, 1L}, (Object)new Object[]{"abc", null, 1L}, (Object)new Object[]{"2", "", 1L}, (Object)new Object[]{"", "a", 1L})));
    }

    @Test
    public void testGroupByLimitPushdownExtraction() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT dim4, substring(dim5, 1, 1), count(*) FROM druid.numfoo WHERE dim4 = 'a' GROUP BY 1,2 LIMIT 2", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0"), new ExtractionDimensionSpec("dim5", "_d1", (ExtractionFn)new SubstringDimExtractionFn(0, Integer.valueOf(1)))})).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "'a'", ColumnType.STRING)}).setDimFilter((DimFilter)CalciteQueryTest.selector("dim4", "a", null)).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of(), Integer.valueOf(2))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", "a", 2L}, (Object)new Object[]{"a", "b", 1L}));
    }

    @Test
    public void testFilterOnTimeFloor() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo\nWHERE\nFLOOR(__time TO MONTH) = TIMESTAMP '2000-01-01 00:00:00'\nOR FLOOR(__time TO MONTH) = TIMESTAMP '2000-02-01 00:00:00'", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000/P2M"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testGroupAndFilterOnTimeFloorWithTimeZone() throws Exception {
        this.testQuery("SELECT TIME_FLOOR(__time, 'P1M', NULL, 'America/Los_Angeles'), COUNT(*)\nFROM druid.foo\nWHERE\nTIME_FLOOR(__time, 'P1M', NULL, 'America/Los_Angeles') =   TIME_PARSE('2000-01-01 00:00:00', NULL, 'America/Los_Angeles')\nOR TIME_FLOOR(__time, 'P1M', NULL, 'America/Los_Angeles') =   TIME_PARSE('2000-02-01 00:00:00', NULL, 'America/Los_Angeles')\nGROUP BY 1", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01T00-08:00/2000-03-01T00-08:00"))).granularity((Granularity)new PeriodGranularity(Period.months((int)1), null, DateTimes.inferTzFromString((String)"America/Los_Angeles"))).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Calcites.jodaToCalciteTimestamp((DateTime)new DateTime((Object)"2000-01-01", DateTimes.inferTzFromString((String)"America/Los_Angeles")), (DateTimeZone)DateTimeZone.UTC), 2L}));
    }

    @Test
    public void testFilterOnCurrentTimestampWithIntervalArithmetic() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo\nWHERE\n  __time >= CURRENT_TIMESTAMP + INTERVAL '01:02' HOUR TO MINUTE\n  AND __time < TIMESTAMP '2003-02-02 01:00:00' - INTERVAL '1 1' DAY TO HOUR - INTERVAL '1-1' YEAR TO MONTH", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01T01:02/2002"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{5L}));
    }

    @Test
    public void testFilterOnCurrentTimestampLosAngeles() throws Exception {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_LOS_ANGELES, "SELECT COUNT(*) FROM druid.foo\nWHERE __time >= CURRENT_TIMESTAMP + INTERVAL '1' DAY AND __time < TIMESTAMP '2002-01-01 00:00:00'", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-02T00Z/2002-01-01T08Z"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_LOS_ANGELES).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{5L}));
    }

    @Test
    public void testFilterOnCurrentTimestampOnView() throws Exception {
        this.testQuery("SELECT * FROM view.bview", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-02/2002"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{5L}));
    }

    @Test
    public void testFilterOnCurrentTimestampLosAngelesOnView() throws Exception {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_LOS_ANGELES, "SELECT * FROM view.bview", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-02T00Z/2002-01-01T08Z"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_LOS_ANGELES).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{5L}));
    }

    @Test
    public void testFilterOnNotTimeFloor() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo\nWHERE\nFLOOR(__time TO MONTH) <> TIMESTAMP '2001-01-01 00:00:00'", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(new Interval((ReadableInstant)DateTimes.MIN, (ReadableInstant)DateTimes.of((String)"2001-01-01")), new Interval((ReadableInstant)DateTimes.of((String)"2001-02-01"), (ReadableInstant)DateTimes.MAX))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testFilterOnTimeFloorComparison() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo\nWHERE\nFLOOR(__time TO MONTH) < TIMESTAMP '2000-02-01 00:00:00'", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(new Interval((ReadableInstant)DateTimes.MIN, (ReadableInstant)DateTimes.of((String)"2000-02-01")))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testFilterOnTimeFloorComparisonMisaligned() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo\nWHERE\nFLOOR(__time TO MONTH) < TIMESTAMP '2000-02-01 00:00:01'", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(new Interval((ReadableInstant)DateTimes.MIN, (ReadableInstant)DateTimes.of((String)"2000-03-01")))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testFilterOnTimeExtract() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(*) FROM druid.foo\nWHERE EXTRACT(YEAR FROM __time) = 2000\nAND EXTRACT(MONTH FROM __time) = 1", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_extract(\"__time\",'YEAR','UTC')", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v1", "timestamp_extract(\"__time\",'MONTH','UTC')", ColumnType.LONG)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).filters((DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.selector("v0", "2000", null), CalciteQueryTest.selector("v1", "1", null)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testFilterOnTimeExtractWithMultipleDays() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(*) FROM druid.foo\nWHERE EXTRACT(YEAR FROM __time) = 2000\nAND EXTRACT(DAY FROM __time) IN (2, 3, 5)", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_extract(\"__time\",'YEAR','UTC')", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v1", "timestamp_extract(\"__time\",'DAY','UTC')", ColumnType.LONG)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).filters((DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.selector("v0", "2000", null), CalciteQueryTest.in("v1", (List<String>)ImmutableList.of((Object)"2", (Object)"3", (Object)"5"), null)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}));
    }

    @Test
    public void testFilterOnTimeExtractWithVariousTimeUnits() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(*) FROM druid.foo4\nWHERE EXTRACT(YEAR FROM __time) = 2000\nAND EXTRACT(MICROSECOND FROM __time) = 946723\nAND EXTRACT(MILLISECOND FROM __time) = 695\nAND EXTRACT(ISODOW FROM __time) = 6\nAND EXTRACT(ISOYEAR FROM __time) = 2000\nAND EXTRACT(DECADE FROM __time) = 200\nAND EXTRACT(CENTURY FROM __time) = 20\nAND EXTRACT(MILLENNIUM FROM __time) = 2\n", (Map<String, Object>)QUERY_CONTEXT_DEFAULT, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo4").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_extract(\"__time\",'YEAR','UTC')", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v1", "timestamp_extract(\"__time\",'MICROSECOND','UTC')", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v2", "timestamp_extract(\"__time\",'MILLISECOND','UTC')", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v3", "timestamp_extract(\"__time\",'ISODOW','UTC')", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v4", "timestamp_extract(\"__time\",'ISOYEAR','UTC')", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v5", "timestamp_extract(\"__time\",'DECADE','UTC')", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v6", "timestamp_extract(\"__time\",'CENTURY','UTC')", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v7", "timestamp_extract(\"__time\",'MILLENNIUM','UTC')", ColumnType.LONG)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).filters((DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.selector("v0", "2000", null), CalciteQueryTest.selector("v1", "946723", null), CalciteQueryTest.selector("v2", "695", null), CalciteQueryTest.selector("v3", "6", null), CalciteQueryTest.selector("v4", "2000", null), CalciteQueryTest.selector("v5", "200", null), CalciteQueryTest.selector("v6", "20", null), CalciteQueryTest.selector("v7", "2", null)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testFilterOnTimeFloorMisaligned() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE floor(__time TO month) = TIMESTAMP '2000-01-01 00:00:01'", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(new Interval[0])).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}));
    }

    @Test
    public void testGroupByFloor() throws Exception {
        this.testQuery("SELECT floor(CAST(dim1 AS float)), COUNT(*) FROM druid.foo GROUP BY floor(CAST(dim1 AS float))", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "floor(CAST(\"dim1\", 'DOUBLE'))", ColumnType.FLOAT)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.FLOAT)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{NullHandling.defaultFloatValue(), 3L}, (Object)new Object[]{Float.valueOf(1.0f), 1L}, (Object)new Object[]{Float.valueOf(2.0f), 1L}, (Object)new Object[]{Float.valueOf(10.0f), 1L}));
    }

    @Test
    public void testQueryWithSelectProjectAndIdentityProjectDoesNotRename() throws Exception {
        this.cannotVectorize();
        this.requireMergeBuffers(3);
        this.testQuery(PLANNER_CONFIG_NO_HLL.withOverrides(new QueryContext((Map)ImmutableMap.of((Object)"useGroupingSetForExactDistinct", (Object)"true"))), "SELECT\n(SUM(CASE WHEN (TIMESTAMP '2000-01-04 17:00:00'<=__time AND __time<TIMESTAMP '2022-01-05 17:00:00') THEN 1 ELSE 0 END)*1.0/COUNT(DISTINCT CASE WHEN (TIMESTAMP '2000-01-04 17:00:00'<=__time AND __time<TIMESTAMP '2022-01-05 17:00:00') THEN dim1 END))\nFROM druid.foo\nGROUP BY ()", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "case_searched(((947005200000 <= \"__time\") && (\"__time\" < 1641402000000)),\"dim1\",null)", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "case_searched(((947005200000 <= \"__time\") && (\"__time\" < 1641402000000)),1,0)", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "v1", null, ExprMacroTable.nil()), new GroupingAggregatorFactory("a1", (List)ImmutableList.of((Object)"v0"))})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of())).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new LongMinAggregatorFactory("_a0", "a0"), (DimFilter)CalciteQueryTest.selector("a1", "1", null)), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("_a1"), (DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("d0", null, null)), CalciteQueryTest.selector("a1", "0", null)}))})).setPostAggregatorSpecs(Collections.singletonList(new ExpressionPostAggregator("p0", "((\"_a0\" * 1.0) / \"_a1\")", null, ExprMacroTable.nil()))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1.0}));
    }

    @Test
    public void testGroupByFloorWithOrderBy() throws Exception {
        this.testQuery("SELECT floor(CAST(dim1 AS float)) AS fl, COUNT(*) FROM druid.foo GROUP BY floor(CAST(dim1 AS float)) ORDER BY fl DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "floor(CAST(\"dim1\", 'DOUBLE'))", ColumnType.FLOAT)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.FLOAT)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(10.0f), 1L}, (Object)new Object[]{Float.valueOf(2.0f), 1L}, (Object)new Object[]{Float.valueOf(1.0f), 1L}, (Object)new Object[]{NullHandling.defaultFloatValue(), 3L}));
    }

    @Test
    public void testGroupByFloorTimeAndOneOtherDimensionWithOrderBy() throws Exception {
        this.testQuery("SELECT floor(__time TO year), dim2, COUNT(*) FROM druid.foo GROUP BY floor(__time TO year), dim2 ORDER BY floor(__time TO year), dim2, COUNT(*) DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1Y',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("dim2", "d1")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC), (Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC), (Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d0", 0, Granularities.YEAR)).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{CalciteQueryTest.timestamp("2000"), "", 2L}, (Object)new Object[]{CalciteQueryTest.timestamp("2000"), "a", 1L}, (Object)new Object[]{CalciteQueryTest.timestamp("2001"), "", 1L}, (Object)new Object[]{CalciteQueryTest.timestamp("2001"), "a", 1L}, (Object)new Object[]{CalciteQueryTest.timestamp("2001"), "abc", 1L}) : ImmutableList.of((Object)new Object[]{CalciteQueryTest.timestamp("2000"), null, 1L}, (Object)new Object[]{CalciteQueryTest.timestamp("2000"), "", 1L}, (Object)new Object[]{CalciteQueryTest.timestamp("2000"), "a", 1L}, (Object)new Object[]{CalciteQueryTest.timestamp("2001"), null, 1L}, (Object)new Object[]{CalciteQueryTest.timestamp("2001"), "a", 1L}, (Object)new Object[]{CalciteQueryTest.timestamp("2001"), "abc", 1L})));
    }

    @Test
    public void testGroupByStringLength() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT CHARACTER_LENGTH(dim1), COUNT(*) FROM druid.foo GROUP BY CHARACTER_LENGTH(dim1)", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "strlen(\"dim1\")", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0, 1L}, (Object)new Object[]{1, 2L}, (Object)new Object[]{3, 2L}, (Object)new Object[]{4, 1L}));
    }

    @Test
    public void testFilterAndGroupByLookup() throws Exception {
        this.cannotVectorize();
        RegisteredLookupExtractionFn extractionFn = new RegisteredLookupExtractionFn(null, "lookyloo", false, null, null, Boolean.valueOf(true));
        this.testQuery("SELECT LOOKUP(dim1, 'lookyloo'), COUNT(*) FROM foo\nWHERE LOOKUP(dim1, 'lookyloo') <> 'xxx'\nGROUP BY LOOKUP(dim1, 'lookyloo')", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", "xxx", (ExtractionFn)extractionFn))).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new ExtractionDimensionSpec("dim1", "d0", ColumnType.STRING, (ExtractionFn)extractionFn)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{NULL_STRING, 5L}, (Object)new Object[]{"xabc", 1L}));
    }

    @Test
    public void testCountDistinctOfLookup() throws Exception {
        this.cannotVectorize();
        RegisteredLookupExtractionFn extractionFn = new RegisteredLookupExtractionFn(null, "lookyloo", false, null, null, Boolean.valueOf(true));
        this.testQuery("SELECT COUNT(DISTINCT LOOKUP(dim1, 'lookyloo')) FROM foo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CardinalityAggregatorFactory("a0", null, (List)ImmutableList.of((Object)new ExtractionDimensionSpec("dim1", null, (ExtractionFn)extractionFn)), false, true)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{NullHandling.replaceWithDefault() ? 2L : 1L}));
    }

    @Test
    public void testGroupByExpressionFromLookup() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT SUBSTRING(v, 1, 1), COUNT(*) FROM lookup.lookyloo GROUP BY 1", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new LookupDataSource("lookyloo")).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new ExtractionDimensionSpec("v", "d0", (ExtractionFn)new SubstringDimExtractionFn(0, Integer.valueOf(1)))})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"m", 1L}, (Object)new Object[]{"x", 3L}));
    }

    @Test
    public void testTimeseries() throws Exception {
        this.testQuery("SELECT SUM(cnt), gran FROM (\n  SELECT floor(__time TO month) AS gran,\n  cnt FROM druid.foo\n) AS x\nGROUP BY gran\nORDER BY gran", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.MONTH).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L, CalciteQueryTest.timestamp("2000-01-01")}, (Object)new Object[]{3L, CalciteQueryTest.timestamp("2001-01-01")}));
    }

    @Test
    public void testFilteredTimeAggregators() throws Exception {
        this.testQuery("SELECT\n  SUM(cnt) FILTER(WHERE __time >= TIMESTAMP '2000-01-01 00:00:00'\n                    AND __time <  TIMESTAMP '2000-02-01 00:00:00'),\n  SUM(cnt) FILTER(WHERE __time >= TIMESTAMP '2000-01-01 00:00:01'\n                    AND __time <  TIMESTAMP '2000-02-01 00:00:00'),\n  SUM(cnt) FILTER(WHERE __time >= TIMESTAMP '2001-01-01 00:00:00'\n                    AND __time <  TIMESTAMP '2001-02-01 00:00:00')\nFROM foo\nWHERE\n  __time >= TIMESTAMP '2000-01-01 00:00:00'\n  AND __time < TIMESTAMP '2001-02-01 00:00:00'", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01/2001-02-01"))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("a0", "cnt"), (DimFilter)CalciteQueryTest.bound("__time", null, String.valueOf(CalciteQueryTest.timestamp("2000-02-01")), false, true, null, StringComparators.NUMERIC)), new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("a1", "cnt"), (DimFilter)CalciteQueryTest.bound("__time", String.valueOf(CalciteQueryTest.timestamp("2000-01-01T00:00:01")), String.valueOf(CalciteQueryTest.timestamp("2000-02-01")), false, true, null, StringComparators.NUMERIC)), new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("a2", "cnt"), (DimFilter)CalciteQueryTest.bound("__time", String.valueOf(CalciteQueryTest.timestamp("2001-01-01")), String.valueOf(CalciteQueryTest.timestamp("2001-02-01")), false, true, null, StringComparators.NUMERIC))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L, 2L, 3L}));
    }

    @Test
    public void testTimeseriesLosAngelesViaQueryContext() throws Exception {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_LOS_ANGELES, "SELECT SUM(cnt), gran FROM (\n  SELECT FLOOR(__time TO MONTH) AS gran,\n  cnt FROM druid.foo\n) AS x\nGROUP BY gran\nORDER BY gran", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity((Granularity)new PeriodGranularity(Period.months((int)1), null, DateTimes.inferTzFromString((String)"America/Los_Angeles"))).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_LOS_ANGELES, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, CalciteQueryTest.timestamp("1999-12-01", "America/Los_Angeles")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2000-01-01", "America/Los_Angeles")}, (Object)new Object[]{1L, CalciteQueryTest.timestamp("2000-12-01", "America/Los_Angeles")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2001-01-01", "America/Los_Angeles")}));
    }

    @Test
    public void testTimeseriesLosAngelesViaPlannerConfig() throws Exception {
        this.testQuery(PLANNER_CONFIG_LOS_ANGELES, QUERY_CONTEXT_DEFAULT, "SELECT SUM(cnt), gran FROM (\n  SELECT\n    FLOOR(__time TO MONTH) AS gran,\n    cnt\n  FROM druid.foo\n  WHERE __time >= TIME_PARSE('1999-12-01 00:00:00') AND __time < TIME_PARSE('2002-01-01 00:00:00')\n) AS x\nGROUP BY gran\nORDER BY gran", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"1999-12-01T00-08:00/2002-01-01T00-08:00"))).granularity((Granularity)new PeriodGranularity(Period.months((int)1), null, DateTimes.inferTzFromString((String)"America/Los_Angeles"))).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, CalciteQueryTest.timestamp("1999-12-01", "America/Los_Angeles")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2000-01-01", "America/Los_Angeles")}, (Object)new Object[]{1L, CalciteQueryTest.timestamp("2000-12-01", "America/Los_Angeles")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2001-01-01", "America/Los_Angeles")}));
    }

    @Test
    public void testTimeseriesUsingTimeFloor() throws Exception {
        this.testQuery("SELECT SUM(cnt), gran FROM (\n  SELECT TIME_FLOOR(__time, 'P1M') AS gran,\n  cnt FROM druid.foo\n) AS x\nGROUP BY gran\nORDER BY gran", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.MONTH).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L, CalciteQueryTest.timestamp("2000-01-01")}, (Object)new Object[]{3L, CalciteQueryTest.timestamp("2001-01-01")}));
    }

    @Test
    public void testTimeseriesUsingTimeFloorWithTimeShift() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT SUM(cnt), gran FROM (\n  SELECT TIME_FLOOR(TIME_SHIFT(__time, 'P1D', -1), 'P1M') AS gran,\n  cnt FROM druid.foo\n) AS x\nGROUP BY gran\nORDER BY gran", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_floor(timestamp_shift(\"__time\",'P1D',-1,'UTC'),'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, CalciteQueryTest.timestamp("1999-12-01")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2000-01-01")}, (Object)new Object[]{1L, CalciteQueryTest.timestamp("2000-12-01")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2001-01-01")}));
    }

    @Test
    public void testTimeseriesUsingTimeFloorWithTimestampAdd() throws Exception {
        this.testQuery("SELECT SUM(cnt), gran FROM (\n  SELECT TIME_FLOOR(TIMESTAMPADD(DAY, -1, __time), 'P1M') AS gran,\n  cnt FROM druid.foo\n) AS x\nGROUP BY gran\nORDER BY gran", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_floor((\"__time\" + -86400000),'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, CalciteQueryTest.timestamp("1999-12-01")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2000-01-01")}, (Object)new Object[]{1L, CalciteQueryTest.timestamp("2000-12-01")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2001-01-01")}));
    }

    @Test
    public void testTimeseriesUsingTimeFloorWithOrigin() throws Exception {
        this.testQuery("SELECT SUM(cnt), gran FROM (\n  SELECT TIME_FLOOR(__time, 'P1M', TIMESTAMP '1970-01-01 01:02:03') AS gran,\n  cnt FROM druid.foo\n) AS x\nGROUP BY gran\nORDER BY gran", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity((Granularity)new PeriodGranularity(Period.months((int)1), DateTimes.of((String)"1970-01-01T01:02:03"), DateTimeZone.UTC)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, CalciteQueryTest.timestamp("1999-12-01T01:02:03")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2000-01-01T01:02:03")}, (Object)new Object[]{1L, CalciteQueryTest.timestamp("2000-12-01T01:02:03")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2001-01-01T01:02:03")}));
    }

    @Test
    public void testTimeseriesLosAngelesUsingTimeFloorConnectionUtc() throws Exception {
        this.testQuery("SELECT SUM(cnt), gran FROM (\n  SELECT TIME_FLOOR(__time, 'P1M', CAST(NULL AS TIMESTAMP), 'America/Los_Angeles') AS gran,\n  cnt FROM druid.foo\n) AS x\nGROUP BY gran\nORDER BY gran", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity((Granularity)new PeriodGranularity(Period.months((int)1), null, DateTimes.inferTzFromString((String)"America/Los_Angeles"))).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, CalciteQueryTest.timestamp("1999-12-01T08")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2000-01-01T08")}, (Object)new Object[]{1L, CalciteQueryTest.timestamp("2000-12-01T08")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2001-01-01T08")}));
    }

    @Test
    public void testTimeseriesLosAngelesUsingTimeFloorConnectionLosAngeles() throws Exception {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_LOS_ANGELES, "SELECT SUM(cnt), gran FROM (\n  SELECT TIME_FLOOR(__time, 'P1M') AS gran,\n  cnt FROM druid.foo\n) AS x\nGROUP BY gran\nORDER BY gran", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity((Granularity)new PeriodGranularity(Period.months((int)1), null, DateTimes.inferTzFromString((String)"America/Los_Angeles"))).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_LOS_ANGELES, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, CalciteQueryTest.timestamp("1999-12-01", "America/Los_Angeles")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2000-01-01", "America/Los_Angeles")}, (Object)new Object[]{1L, CalciteQueryTest.timestamp("2000-12-01", "America/Los_Angeles")}, (Object)new Object[]{2L, CalciteQueryTest.timestamp("2001-01-01", "America/Los_Angeles")}));
    }

    @Test
    public void testTimeseriesDontSkipEmptyBuckets() throws Exception {
        Long defaultVal = NullHandling.replaceWithDefault() ? Long.valueOf(0L) : null;
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_DONT_SKIP_EMPTY_BUCKETS, "SELECT SUM(cnt), gran FROM (\n  SELECT floor(__time TO HOUR) AS gran, cnt FROM druid.foo\n  WHERE __time >= TIMESTAMP '2000-01-01 00:00:00' AND __time < TIMESTAMP '2000-01-02 00:00:00'\n) AS x\nGROUP BY gran\nORDER BY gran", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000/2000-01-02"))).granularity((Granularity)new PeriodGranularity(Period.hours((int)1), null, DateTimeZone.UTC)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(QUERY_CONTEXT_DONT_SKIP_EMPTY_BUCKETS, "d0")).build()), (List<Object[]>)ImmutableList.builder().add((Object)new Object[]{1L, CalciteQueryTest.timestamp("2000-01-01")}).add((Object)new Object[]{defaultVal, CalciteQueryTest.timestamp("2000-01-01T01")}).add((Object)new Object[]{defaultVal, CalciteQueryTest.timestamp("2000-01-01T02")}).add((Object)new Object[]{defaultVal, CalciteQueryTest.timestamp("2000-01-01T03")}).add((Object)new Object[]{defaultVal, CalciteQueryTest.timestamp("2000-01-01T04")}).add((Object)new Object[]{defaultVal, CalciteQueryTest.timestamp("2000-01-01T05")}).add((Object)new Object[]{defaultVal, CalciteQueryTest.timestamp("2000-01-01T06")}).add((Object)new Object[]{defaultVal, CalciteQueryTest.timestamp("2000-01-01T07")}).add((Object)new Object[]{defaultVal, CalciteQueryTest.timestamp("2000-01-01T08")}).add((Object)new Object[]{defaultVal, CalciteQueryTest.timestamp("2000-01-01T09")}).add((Object)new Object[]{defaultVal, CalciteQueryTest.timestamp("2000-01-01T10")}).add((Object)new Object[]{defaultVal, CalciteQueryTest.timestamp("2000-01-01T11")}).add((Object)new Object[]{defaultVal, CalciteQueryTest.timestamp("2000-01-01T12")}).add((Object)new Object[]{defaultVal, CalciteQueryTest.timestamp("2000-01-01T13")}).add((Object)new Object[]{defaultVal, CalciteQueryTest.timestamp("2000-01-01T14")}).add((Object)new Object[]{defaultVal, CalciteQueryTest.timestamp("2000-01-01T15")}).add((Object)new Object[]{defaultVal, CalciteQueryTest.timestamp("2000-01-01T16")}).add((Object)new Object[]{defaultVal, CalciteQueryTest.timestamp("2000-01-01T17")}).add((Object)new Object[]{defaultVal, CalciteQueryTest.timestamp("2000-01-01T18")}).add((Object)new Object[]{defaultVal, CalciteQueryTest.timestamp("2000-01-01T19")}).add((Object)new Object[]{defaultVal, CalciteQueryTest.timestamp("2000-01-01T20")}).add((Object)new Object[]{defaultVal, CalciteQueryTest.timestamp("2000-01-01T21")}).add((Object)new Object[]{defaultVal, CalciteQueryTest.timestamp("2000-01-01T22")}).add((Object)new Object[]{defaultVal, CalciteQueryTest.timestamp("2000-01-01T23")}).build());
    }

    @Test
    public void testTimeseriesUsingCastAsDate() throws Exception {
        this.testQuery("SELECT SUM(cnt), dt FROM (\n  SELECT CAST(__time AS DATE) AS dt,\n  cnt FROM druid.foo\n) AS x\nGROUP BY dt\nORDER BY dt", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity((Granularity)new PeriodGranularity(Period.days((int)1), null, DateTimeZone.UTC)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, CalciteQueryTest.day("2000-01-01")}, (Object)new Object[]{1L, CalciteQueryTest.day("2000-01-02")}, (Object)new Object[]{1L, CalciteQueryTest.day("2000-01-03")}, (Object)new Object[]{1L, CalciteQueryTest.day("2001-01-01")}, (Object)new Object[]{1L, CalciteQueryTest.day("2001-01-02")}, (Object)new Object[]{1L, CalciteQueryTest.day("2001-01-03")}));
    }

    @Test
    public void testTimeseriesUsingFloorPlusCastAsDate() throws Exception {
        this.testQuery("SELECT SUM(cnt), dt FROM (\n  SELECT CAST(FLOOR(__time TO QUARTER) AS DATE) AS dt,\n  cnt FROM druid.foo\n) AS x\nGROUP BY dt\nORDER BY dt", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity((Granularity)new PeriodGranularity(Period.months((int)3), null, DateTimeZone.UTC)).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L, CalciteQueryTest.day("2000-01-01")}, (Object)new Object[]{3L, CalciteQueryTest.day("2001-01-01")}));
    }

    @Test
    public void testTimeseriesDescending() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT gran, SUM(cnt) FROM (\n  SELECT floor(__time TO month) AS gran,\n  cnt FROM druid.foo\n) AS x\nGROUP BY gran\nORDER BY gran DESC", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.MONTH).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).descending(true).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteQueryTest.timestamp("2001-01-01"), 3L}, (Object)new Object[]{CalciteQueryTest.timestamp("2000-01-01"), 3L}));
    }

    @Test
    public void testTimeseriesEmptyResultsAggregatorDefaultValues() throws Exception {
        Object[] objectArray;
        ImmutableList immutableList = ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteQueryTest.bound("dim2", "0", "0", false, false, null, StringComparators.NUMERIC)).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0"), new CardinalityAggregatorFactory("a1", null, (List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"dim1")), false, true), new CardinalityAggregatorFactory("a2", null, (List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"dim1")), false, true), new DoubleSumAggregatorFactory("a3", "d1"), new DoubleMaxAggregatorFactory("a4", "d1"), new DoubleMinAggregatorFactory("a5", "d1"), new LongSumAggregatorFactory("a6", "l1"), new LongMaxAggregatorFactory("a7", "l1"), new LongMinAggregatorFactory("a8", "l1"), new LongSumAggregatorFactory("a9:sum", "l1"), this.useDefault ? new CountAggregatorFactory("a9:count") : new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a9:count"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("l1", null, null))), new DoubleSumAggregatorFactory("a10:sum", "d1"), this.useDefault ? new CountAggregatorFactory("a10:count") : new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a10:count"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("d1", null, null)))})).postAggregators(new PostAggregator[]{new ArithmeticPostAggregator("a9", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "a9:sum"), (Object)new FieldAccessPostAggregator(null, "a9:count"))), new ArithmeticPostAggregator("a10", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "a10:sum"), (Object)new FieldAccessPostAggregator(null, "a10:count")))}).context(QUERY_CONTEXT_DEFAULT).build());
        if (this.useDefault) {
            Object[] objectArray2 = new Object[11];
            objectArray2[0] = 0L;
            objectArray2[1] = 0L;
            objectArray2[2] = 0L;
            objectArray2[3] = 0.0;
            objectArray2[4] = Double.NEGATIVE_INFINITY;
            objectArray2[5] = Double.POSITIVE_INFINITY;
            objectArray2[6] = 0L;
            objectArray2[7] = Long.MIN_VALUE;
            objectArray2[8] = Long.MAX_VALUE;
            objectArray2[9] = 0L;
            objectArray = objectArray2;
            objectArray2[10] = Double.NaN;
        } else {
            Object[] objectArray3 = new Object[11];
            objectArray3[0] = 0L;
            objectArray3[1] = 0L;
            objectArray3[2] = 0L;
            objectArray3[3] = null;
            objectArray3[4] = null;
            objectArray3[5] = null;
            objectArray3[6] = null;
            objectArray3[7] = null;
            objectArray3[8] = null;
            objectArray3[9] = null;
            objectArray = objectArray3;
            objectArray3[10] = null;
        }
        this.testQuery("SELECT\n count(*),\n COUNT(DISTINCT dim1),\n APPROX_COUNT_DISTINCT(distinct dim1),\n sum(d1),\n max(d1),\n min(d1),\n sum(l1),\n max(l1),\n min(l1),\n avg(l1),\n avg(d1)\nFROM druid.numfoo WHERE dim2 = 0", (List<Query>)immutableList, (List<Object[]>)ImmutableList.of((Object)objectArray));
    }

    @Test
    public void testTimeseriesEmptyResultsAggregatorDefaultValuesNonVectorized() throws Exception {
        Object[] objectArray;
        this.cannotVectorize();
        ImmutableList immutableList = ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteQueryTest.bound("dim2", "0", "0", false, false, null, StringComparators.NUMERIC)).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new StringAnyAggregatorFactory("a0", "dim1", Integer.valueOf(1024)), new LongAnyAggregatorFactory("a1", "l1"), new StringFirstAggregatorFactory("a2", "dim1", null, Integer.valueOf(1024)), new LongFirstAggregatorFactory("a3", "l1", null), new StringLastAggregatorFactory("a4", "dim1", null, Integer.valueOf(1024)), new LongLastAggregatorFactory("a5", "l1", null), new ExpressionLambdaAggregatorFactory("a6", (Set)ImmutableSet.of((Object)"dim3"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim3\")", "array_set_add_all(\"__acc\", \"a6\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a7", (Set)ImmutableSet.of((Object)"dim3"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim3\")", "array_set_add_all(\"__acc\", \"a7\")", null, "if(array_length(o) == 0, null, array_to_string(o, '|'))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim3", null, null))), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a8", (Set)ImmutableSet.of((Object)"l1"), "__acc", "0", "0", Boolean.valueOf(NullHandling.sqlCompatible()), Boolean.valueOf(false), Boolean.valueOf(false), "bitwiseAnd(\"__acc\", \"l1\")", "bitwiseAnd(\"__acc\", \"a8\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("l1", null, null))), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a9", (Set)ImmutableSet.of((Object)"l1"), "__acc", "0", "0", Boolean.valueOf(NullHandling.sqlCompatible()), Boolean.valueOf(false), Boolean.valueOf(false), "bitwiseOr(\"__acc\", \"l1\")", "bitwiseOr(\"__acc\", \"a9\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("l1", null, null))), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a10", (Set)ImmutableSet.of((Object)"l1"), "__acc", "0", "0", Boolean.valueOf(NullHandling.sqlCompatible()), Boolean.valueOf(false), Boolean.valueOf(false), "bitwiseXor(\"__acc\", \"l1\")", "bitwiseXor(\"__acc\", \"a10\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("l1", null, null)))})).context(QUERY_CONTEXT_DEFAULT).build());
        if (this.useDefault) {
            Object[] objectArray2 = new Object[11];
            objectArray2[0] = "";
            objectArray2[1] = 0L;
            objectArray2[2] = "";
            objectArray2[3] = 0L;
            objectArray2[4] = "";
            objectArray2[5] = 0L;
            objectArray2[6] = null;
            objectArray2[7] = "";
            objectArray2[8] = 0L;
            objectArray2[9] = 0L;
            objectArray = objectArray2;
            objectArray2[10] = 0L;
        } else {
            Object[] objectArray3 = new Object[11];
            objectArray3[0] = null;
            objectArray3[1] = null;
            objectArray3[2] = null;
            objectArray3[3] = null;
            objectArray3[4] = null;
            objectArray3[5] = null;
            objectArray3[6] = null;
            objectArray3[7] = null;
            objectArray3[8] = null;
            objectArray3[9] = null;
            objectArray = objectArray3;
            objectArray3[10] = null;
        }
        this.testQuery("SELECT\n ANY_VALUE(dim1, 1024),\n ANY_VALUE(l1),\n EARLIEST(dim1, 1024),\n EARLIEST(l1),\n LATEST(dim1, 1024),\n LATEST(l1),\n ARRAY_AGG(DISTINCT dim3),\n STRING_AGG(DISTINCT dim3, '|'),\n BIT_AND(l1),\n BIT_OR(l1),\n BIT_XOR(l1)\nFROM druid.numfoo WHERE dim2 = 0", (List<Query>)immutableList, (List<Object[]>)ImmutableList.of((Object)objectArray));
    }

    @Test
    public void testGroupByAggregatorDefaultValues() throws Exception {
        Object[] objectArray;
        ImmutableList immutableList = ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter((DimFilter)CalciteQueryTest.selector("dim2", "a", null)).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "'a'", ColumnType.STRING)}).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING)}).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteQueryTest.selector("dim1", "nonexistent", null)), new FilteredAggregatorFactory((AggregatorFactory)new CardinalityAggregatorFactory("a1", null, (List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"dim1")), false, true), (DimFilter)CalciteQueryTest.selector("dim1", "nonexistent", null)), new FilteredAggregatorFactory((AggregatorFactory)new CardinalityAggregatorFactory("a2", null, (List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"dim1")), false, true), (DimFilter)CalciteQueryTest.selector("dim1", "nonexistent", null)), new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("a3", "d1"), (DimFilter)CalciteQueryTest.selector("dim1", "nonexistent", null)), new FilteredAggregatorFactory((AggregatorFactory)new DoubleMaxAggregatorFactory("a4", "d1"), (DimFilter)CalciteQueryTest.selector("dim1", "nonexistent", null)), new FilteredAggregatorFactory((AggregatorFactory)new DoubleMinAggregatorFactory("a5", "d1"), (DimFilter)CalciteQueryTest.selector("dim1", "nonexistent", null)), new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("a6", "l1"), (DimFilter)CalciteQueryTest.selector("dim1", "nonexistent", null)), new FilteredAggregatorFactory((AggregatorFactory)new LongMaxAggregatorFactory("a7", "l1"), (DimFilter)CalciteQueryTest.selector("dim1", "nonexistent", null)), new FilteredAggregatorFactory((AggregatorFactory)new LongMinAggregatorFactory("a8", "l1"), (DimFilter)CalciteQueryTest.selector("dim1", "nonexistent", null)), new FilteredAggregatorFactory((AggregatorFactory)new LongSumAggregatorFactory("a9:sum", "l1"), (DimFilter)CalciteQueryTest.selector("dim1", "nonexistent", null)), this.useDefault ? new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a9:count"), (DimFilter)CalciteQueryTest.selector("dim1", "nonexistent", null)) : new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a9:count"), (DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("l1", null, null)), CalciteQueryTest.selector("dim1", "nonexistent", null)})), new FilteredAggregatorFactory((AggregatorFactory)new DoubleSumAggregatorFactory("a10:sum", "d1"), (DimFilter)CalciteQueryTest.selector("dim1", "nonexistent", null)), this.useDefault ? new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a10:count"), (DimFilter)CalciteQueryTest.selector("dim1", "nonexistent", null)) : new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a10:count"), (DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("d1", null, null)), CalciteQueryTest.selector("dim1", "nonexistent", null)}))})).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ArithmeticPostAggregator("a9", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "a9:sum"), (Object)new FieldAccessPostAggregator(null, "a9:count"))), (Object)new ArithmeticPostAggregator("a10", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "a10:sum"), (Object)new FieldAccessPostAggregator(null, "a10:count"))))).setContext(QUERY_CONTEXT_DEFAULT).build());
        if (this.useDefault) {
            Object[] objectArray2 = new Object[12];
            objectArray2[0] = "a";
            objectArray2[1] = 0L;
            objectArray2[2] = 0L;
            objectArray2[3] = 0L;
            objectArray2[4] = 0.0;
            objectArray2[5] = Double.NEGATIVE_INFINITY;
            objectArray2[6] = Double.POSITIVE_INFINITY;
            objectArray2[7] = 0L;
            objectArray2[8] = Long.MIN_VALUE;
            objectArray2[9] = Long.MAX_VALUE;
            objectArray2[10] = 0L;
            objectArray = objectArray2;
            objectArray2[11] = Double.NaN;
        } else {
            Object[] objectArray3 = new Object[12];
            objectArray3[0] = "a";
            objectArray3[1] = 0L;
            objectArray3[2] = 0L;
            objectArray3[3] = 0L;
            objectArray3[4] = null;
            objectArray3[5] = null;
            objectArray3[6] = null;
            objectArray3[7] = null;
            objectArray3[8] = null;
            objectArray3[9] = null;
            objectArray3[10] = null;
            objectArray = objectArray3;
            objectArray3[11] = null;
        }
        this.testQuery("SELECT\n dim2,\n count(*) FILTER(WHERE dim1 = 'nonexistent'),\n COUNT(DISTINCT dim1) FILTER(WHERE dim1 = 'nonexistent'),\n APPROX_COUNT_DISTINCT(distinct dim1) FILTER(WHERE dim1 = 'nonexistent'),\n sum(d1) FILTER(WHERE dim1 = 'nonexistent'),\n max(d1) FILTER(WHERE dim1 = 'nonexistent'),\n min(d1) FILTER(WHERE dim1 = 'nonexistent'),\n sum(l1) FILTER(WHERE dim1 = 'nonexistent'),\n max(l1) FILTER(WHERE dim1 = 'nonexistent'),\n min(l1) FILTER(WHERE dim1 = 'nonexistent'),\n avg(l1) FILTER(WHERE dim1 = 'nonexistent'),\n avg(d1) FILTER(WHERE dim1 = 'nonexistent')\nFROM druid.numfoo WHERE dim2 = 'a' GROUP BY dim2", (List<Query>)immutableList, (List<Object[]>)ImmutableList.of((Object)objectArray));
    }

    @Test
    public void testGroupByAggregatorDefaultValuesNonVectorized() throws Exception {
        Object[] objectArray;
        this.cannotVectorize();
        ImmutableList immutableList = ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter((DimFilter)CalciteQueryTest.selector("dim2", "a", null)).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "'a'", ColumnType.STRING)}).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING)}).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new StringAnyAggregatorFactory("a0", "dim1", Integer.valueOf(1024)), (DimFilter)CalciteQueryTest.selector("dim1", "nonexistent", null)), new FilteredAggregatorFactory((AggregatorFactory)new LongAnyAggregatorFactory("a1", "l1"), (DimFilter)CalciteQueryTest.selector("dim1", "nonexistent", null)), new FilteredAggregatorFactory((AggregatorFactory)new StringFirstAggregatorFactory("a2", "dim1", null, Integer.valueOf(1024)), (DimFilter)CalciteQueryTest.selector("dim1", "nonexistent", null)), new FilteredAggregatorFactory((AggregatorFactory)new LongFirstAggregatorFactory("a3", "l1", null), (DimFilter)CalciteQueryTest.selector("dim1", "nonexistent", null)), new FilteredAggregatorFactory((AggregatorFactory)new StringLastAggregatorFactory("a4", "dim1", null, Integer.valueOf(1024)), (DimFilter)CalciteQueryTest.selector("dim1", "nonexistent", null)), new FilteredAggregatorFactory((AggregatorFactory)new LongLastAggregatorFactory("a5", "l1", null), (DimFilter)CalciteQueryTest.selector("dim1", "nonexistent", null)), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a6", (Set)ImmutableSet.of((Object)"dim3"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim3\")", "array_set_add_all(\"__acc\", \"a6\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.selector("dim1", "nonexistent", null)), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a7", (Set)ImmutableSet.of((Object)"dim3"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim3\")", "array_set_add_all(\"__acc\", \"a7\")", null, "if(array_length(o) == 0, null, array_to_string(o, '|'))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim3", null, null)), CalciteQueryTest.selector("dim1", "nonexistent", null)})), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a8", (Set)ImmutableSet.of((Object)"l1"), "__acc", "0", "0", Boolean.valueOf(NullHandling.sqlCompatible()), Boolean.valueOf(false), Boolean.valueOf(false), "bitwiseAnd(\"__acc\", \"l1\")", "bitwiseAnd(\"__acc\", \"a8\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("l1", null, null)), CalciteQueryTest.selector("dim1", "nonexistent", null)})), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a9", (Set)ImmutableSet.of((Object)"l1"), "__acc", "0", "0", Boolean.valueOf(NullHandling.sqlCompatible()), Boolean.valueOf(false), Boolean.valueOf(false), "bitwiseOr(\"__acc\", \"l1\")", "bitwiseOr(\"__acc\", \"a9\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("l1", null, null)), CalciteQueryTest.selector("dim1", "nonexistent", null)})), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a10", (Set)ImmutableSet.of((Object)"l1"), "__acc", "0", "0", Boolean.valueOf(NullHandling.sqlCompatible()), Boolean.valueOf(false), Boolean.valueOf(false), "bitwiseXor(\"__acc\", \"l1\")", "bitwiseXor(\"__acc\", \"a10\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("l1", null, null)), CalciteQueryTest.selector("dim1", "nonexistent", null)}))})).setContext(QUERY_CONTEXT_DEFAULT).build());
        if (this.useDefault) {
            Object[] objectArray2 = new Object[12];
            objectArray2[0] = "a";
            objectArray2[1] = "";
            objectArray2[2] = 0L;
            objectArray2[3] = "";
            objectArray2[4] = 0L;
            objectArray2[5] = "";
            objectArray2[6] = 0L;
            objectArray2[7] = null;
            objectArray2[8] = "";
            objectArray2[9] = 0L;
            objectArray2[10] = 0L;
            objectArray = objectArray2;
            objectArray2[11] = 0L;
        } else {
            Object[] objectArray3 = new Object[12];
            objectArray3[0] = "a";
            objectArray3[1] = null;
            objectArray3[2] = null;
            objectArray3[3] = null;
            objectArray3[4] = null;
            objectArray3[5] = null;
            objectArray3[6] = null;
            objectArray3[7] = null;
            objectArray3[8] = null;
            objectArray3[9] = null;
            objectArray3[10] = null;
            objectArray = objectArray3;
            objectArray3[11] = null;
        }
        this.testQuery("SELECT\n dim2,\n ANY_VALUE(dim1, 1024) FILTER(WHERE dim1 = 'nonexistent'),\n ANY_VALUE(l1) FILTER(WHERE dim1 = 'nonexistent'),\n EARLIEST(dim1, 1024) FILTER(WHERE dim1 = 'nonexistent'),\n EARLIEST(l1) FILTER(WHERE dim1 = 'nonexistent'),\n LATEST(dim1, 1024) FILTER(WHERE dim1 = 'nonexistent'),\n LATEST(l1) FILTER(WHERE dim1 = 'nonexistent'),\n ARRAY_AGG(DISTINCT dim3) FILTER(WHERE dim1 = 'nonexistent'),\n STRING_AGG(DISTINCT dim3, '|') FILTER(WHERE dim1 = 'nonexistent'),\n BIT_AND(l1) FILTER(WHERE dim1 = 'nonexistent'),\n BIT_OR(l1) FILTER(WHERE dim1 = 'nonexistent'),\n BIT_XOR(l1) FILTER(WHERE dim1 = 'nonexistent')\nFROM druid.numfoo WHERE dim2 = 'a' GROUP BY dim2", (List<Query>)immutableList, (List<Object[]>)ImmutableList.of((Object)objectArray));
    }

    @Test
    public void testGroupByExtractYear() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT\n  EXTRACT(YEAR FROM __time) AS \"year\",\n  SUM(cnt)\nFROM druid.foo\nGROUP BY EXTRACT(YEAR FROM __time)\nORDER BY 1", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_extract(\"__time\",'YEAR','UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2000L, 3L}, (Object)new Object[]{2001L, 3L}));
    }

    @Test
    public void testGroupByFormatYearAndMonth() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT\n  TIME_FORMAt(__time, 'yyyy MM') AS \"year\",\n  SUM(cnt)\nFROM druid.foo\nGROUP BY TIME_FORMAt(__time, 'yyyy MM')\nORDER BY 1", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_format(\"__time\",'yyyy MM','UTC')", ColumnType.STRING)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"2000 01", 3L}, (Object)new Object[]{"2001 01", 3L}));
    }

    @Test
    public void testGroupByExtractFloorTime() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT\nEXTRACT(YEAR FROM FLOOR(__time TO YEAR)) AS \"year\", SUM(cnt)\nFROM druid.foo\nGROUP BY EXTRACT(YEAR FROM FLOOR(__time TO YEAR))", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_extract(timestamp_floor(\"__time\",'P1Y',null,'UTC'),'YEAR','UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2000L, 3L}, (Object)new Object[]{2001L, 3L}));
    }

    @Test
    public void testGroupByExtractFloorTimeLosAngeles() throws Exception {
        this.cannotVectorize();
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_LOS_ANGELES, "SELECT\nEXTRACT(YEAR FROM FLOOR(__time TO YEAR)) AS \"year\", SUM(cnt)\nFROM druid.foo\nGROUP BY EXTRACT(YEAR FROM FLOOR(__time TO YEAR))", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_extract(timestamp_floor(\"__time\",'P1Y',null,'America/Los_Angeles'),'YEAR','America/Los_Angeles')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_LOS_ANGELES).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1999L, 1L}, (Object)new Object[]{2000L, 3L}, (Object)new Object[]{2001L, 2L}));
    }

    @Test
    public void testTimeseriesWithLimitNoTopN() throws Exception {
        this.testQuery(PLANNER_CONFIG_NO_TOPN, "SELECT gran, SUM(cnt)\nFROM (\n  SELECT floor(__time TO month) AS gran, cnt\n  FROM druid.foo\n) AS x\nGROUP BY gran\nORDER BY gran\nLIMIT 1", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.MONTH).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).limit(1).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteQueryTest.timestamp("2000-01-01"), 3L}));
    }

    @Test
    public void testTimeseriesWithLimit() throws Exception {
        this.testQuery("SELECT gran, SUM(cnt)\nFROM (\n  SELECT floor(__time TO month) AS gran, cnt\n  FROM druid.foo\n) AS x\nGROUP BY gran\nLIMIT 1", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.MONTH).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).limit(1).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteQueryTest.timestamp("2000-01-01"), 3L}));
    }

    @Test
    public void testTimeseriesWithLimitAndOffset() throws Exception {
        this.testQuery("SELECT gran, SUM(cnt)\nFROM (\n  SELECT floor(__time TO month) AS gran, cnt\n  FROM druid.foo\n) AS x\nGROUP BY gran\nLIMIT 2\nOFFSET 1", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)DefaultLimitSpec.builder().offset(1).limit(2).build()).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteQueryTest.timestamp("2001-01-01"), 3L}));
    }

    @Test
    public void testTimeseriesWithOrderByAndLimit() throws Exception {
        this.testQuery("SELECT gran, SUM(cnt)\nFROM (\n  SELECT floor(__time TO month) AS gran, cnt\n  FROM druid.foo\n) AS x\nGROUP BY gran\nORDER BY gran\nLIMIT 1", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.MONTH).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).limit(1).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteQueryTest.timestamp("2000-01-01"), 3L}));
    }

    @Test
    public void testGroupByTimeAndOtherDimension() throws Exception {
        this.testQuery("SELECT dim2, gran, SUM(cnt)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, dim2, cnt FROM druid.foo) AS x\nGROUP BY dim2, gran\nORDER BY dim2, gran", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0"), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING), (Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"", CalciteQueryTest.timestamp("2000-01-01"), 2L}, (Object)new Object[]{"", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteQueryTest.timestamp("2001-01-01"), 1L}) : ImmutableList.of((Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{null, CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"", CalciteQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteQueryTest.timestamp("2001-01-01"), 1L})));
    }

    @Test
    public void testGroupByTimeFloorAndDimOnGroupByTimeFloorAndDim() throws Exception {
        this.testQuery("SELECT dim2, time_floor(gran, 'P1M') gran, sum(s)\nFROM (SELECT time_floor(__time, 'P1D') AS gran, dim2, sum(m1) as s FROM druid.foo GROUP BY 1, 2 HAVING sum(m1) > 1) AS x\nGROUP BY 1, 2\nORDER BY dim2, gran desc", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1D',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("dim2", "d1")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1")})).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d0", 0, Granularities.DAY)).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"d0\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("d1", "_d0"), new DefaultDimensionSpec("v0", "_d1", ColumnType.LONG)})).setDimFilter((DimFilter)new BoundDimFilter("a0", "1", null, Boolean.valueOf(true), null, null, null, StringComparators.NUMERIC)).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("_a0", "a0")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("_d0", OrderByColumnSpec.Direction.ASCENDING), (Object)new OrderByColumnSpec("_d1", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"", CalciteQueryTest.timestamp("2001-01-01"), 6.0}, (Object)new Object[]{"", CalciteQueryTest.timestamp("2000-01-01"), 5.0}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2001-01-01"), 4.0}, (Object)new Object[]{"abc", CalciteQueryTest.timestamp("2001-01-01"), 5.0}) : ImmutableList.of((Object)new Object[]{null, CalciteQueryTest.timestamp("2001-01-01"), 6.0}, (Object)new Object[]{null, CalciteQueryTest.timestamp("2000-01-01"), 2.0}, (Object)new Object[]{"", CalciteQueryTest.timestamp("2000-01-01"), 3.0}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2001-01-01"), 4.0}, (Object)new Object[]{"abc", CalciteQueryTest.timestamp("2001-01-01"), 5.0})));
    }

    @Test
    public void testGroupingSets() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT dim2, gran, SUM(cnt), GROUPING(dim2, gran)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, COALESCE(dim2, '') dim2, cnt FROM druid.foo) AS x\nGROUP BY GROUPING SETS ( (dim2, gran), (dim2), (gran), () )", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "case_searched(notnull(\"dim2\"),\"dim2\",'')", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0"), new DefaultDimensionSpec("v1", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt"), new GroupingAggregatorFactory("a1", Arrays.asList("v0", "v1"))})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0", (Object)"d1"), (Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of((Object)"d1"), (Object)ImmutableList.of())).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", CalciteQueryTest.timestamp("2000-01-01"), 2L, 0L}, (Object)new Object[]{"", CalciteQueryTest.timestamp("2001-01-01"), 1L, 0L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2000-01-01"), 1L, 0L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2001-01-01"), 1L, 0L}, (Object)new Object[]{"abc", CalciteQueryTest.timestamp("2001-01-01"), 1L, 0L}, (Object)new Object[]{"", null, 3L, 1L}, (Object)new Object[]{"a", null, 2L, 1L}, (Object)new Object[]{"abc", null, 1L, 1L}, (Object)new Object[]{NULL_STRING, CalciteQueryTest.timestamp("2000-01-01"), 3L, 2L}, (Object)new Object[]{NULL_STRING, CalciteQueryTest.timestamp("2001-01-01"), 3L, 2L}, (Object)new Object[]{NULL_STRING, null, 6L, 3L}));
    }

    @Test
    public void testGroupingAggregatorDifferentOrder() throws Exception {
        this.requireMergeBuffers(3);
        this.cannotVectorize();
        this.testQuery("SELECT dim2, gran, SUM(cnt), GROUPING(gran, dim2)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, COALESCE(dim2, '') dim2, cnt FROM druid.foo) AS x\nGROUP BY GROUPING SETS ( (dim2, gran), (dim2), (gran), () )", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "case_searched(notnull(\"dim2\"),\"dim2\",'')", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0"), new DefaultDimensionSpec("v1", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt"), new GroupingAggregatorFactory("a1", Arrays.asList("v1", "v0"))})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0", (Object)"d1"), (Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of((Object)"d1"), (Object)ImmutableList.of())).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", CalciteQueryTest.timestamp("2000-01-01"), 2L, 0L}, (Object)new Object[]{"", CalciteQueryTest.timestamp("2001-01-01"), 1L, 0L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2000-01-01"), 1L, 0L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2001-01-01"), 1L, 0L}, (Object)new Object[]{"abc", CalciteQueryTest.timestamp("2001-01-01"), 1L, 0L}, (Object)new Object[]{"", null, 3L, 2L}, (Object)new Object[]{"a", null, 2L, 2L}, (Object)new Object[]{"abc", null, 1L, 2L}, (Object)new Object[]{NULL_STRING, CalciteQueryTest.timestamp("2000-01-01"), 3L, 1L}, (Object)new Object[]{NULL_STRING, CalciteQueryTest.timestamp("2001-01-01"), 3L, 1L}, (Object)new Object[]{NULL_STRING, null, 6L, 3L}));
    }

    @Test
    public void testGroupingAggregatorWithPostAggregator() throws Exception {
        ImmutableList resultList = NullHandling.sqlCompatible() ? ImmutableList.of((Object)new Object[]{NULL_STRING, 2L, 0L, NULL_STRING}, (Object)new Object[]{"", 1L, 0L, ""}, (Object)new Object[]{"a", 2L, 0L, "a"}, (Object)new Object[]{"abc", 1L, 0L, "abc"}, (Object)new Object[]{NULL_STRING, 6L, 1L, "ALL"}) : ImmutableList.of((Object)new Object[]{"", 3L, 0L, ""}, (Object)new Object[]{"a", 2L, 0L, "a"}, (Object)new Object[]{"abc", 1L, 0L, "abc"}, (Object)new Object[]{NULL_STRING, 6L, 1L, "ALL"});
        this.testQuery("SELECT dim2, SUM(cnt), GROUPING(dim2), \nCASE WHEN GROUPING(dim2) = 1 THEN 'ALL' ELSE dim2 END\nFROM druid.foo\nGROUP BY GROUPING SETS ( (dim2), () )", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt"), new GroupingAggregatorFactory("a1", Collections.singletonList("dim2"))})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of())).setPostAggregatorSpecs(Collections.singletonList(new ExpressionPostAggregator("p0", "case_searched((\"a1\" == 1),'ALL',\"d0\")", null, ExprMacroTable.nil()))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)resultList);
    }

    @Test
    public void testGroupingSetsWithNumericDimension() throws Exception {
        this.testQuery("SELECT cnt, COUNT(*)\nFROM foo\nGROUP BY GROUPING SETS ( (cnt), () )", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("cnt", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of())).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, 6L}, (Object)new Object[]{null, 6L}));
    }

    @Test
    public void testGroupByRollup() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT dim2, gran, SUM(cnt)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, COALESCE(dim2, '') dim2, cnt FROM druid.foo) AS x\nGROUP BY ROLLUP (dim2, gran)", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "case_searched(notnull(\"dim2\"),\"dim2\",'')", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0"), new DefaultDimensionSpec("v1", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0", (Object)"d1"), (Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of())).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", CalciteQueryTest.timestamp("2000-01-01"), 2L}, (Object)new Object[]{"", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"", null, 3L}, (Object)new Object[]{"a", null, 2L}, (Object)new Object[]{"abc", null, 1L}, (Object)new Object[]{NULL_STRING, null, 6L}));
    }

    @Test
    public void testGroupByRollupDifferentOrder() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT dim2, gran, SUM(cnt)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, COALESCE(dim2, '') dim2, cnt FROM druid.foo) AS x\nGROUP BY ROLLUP (gran, dim2)", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v1", "case_searched(notnull(\"dim2\"),\"dim2\",'')", ColumnType.STRING)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("v1", "d1")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0", (Object)"d1"), (Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of())).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d0", 0, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", CalciteQueryTest.timestamp("2000-01-01"), 2L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{NULL_STRING, CalciteQueryTest.timestamp("2000-01-01"), 3L}, (Object)new Object[]{NULL_STRING, CalciteQueryTest.timestamp("2001-01-01"), 3L}, (Object)new Object[]{NULL_STRING, null, 6L}));
    }

    @Test
    public void testGroupByCube() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT dim2, gran, SUM(cnt)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, COALESCE(dim2, '') dim2, cnt FROM druid.foo) AS x\nGROUP BY CUBE (dim2, gran)", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "case_searched(notnull(\"dim2\"),\"dim2\",'')", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0"), new DefaultDimensionSpec("v1", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0", (Object)"d1"), (Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of((Object)"d1"), (Object)ImmutableList.of())).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", CalciteQueryTest.timestamp("2000-01-01"), 2L}, (Object)new Object[]{"", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"", null, 3L}, (Object)new Object[]{"a", null, 2L}, (Object)new Object[]{"abc", null, 1L}, (Object)new Object[]{NULL_STRING, CalciteQueryTest.timestamp("2000-01-01"), 3L}, (Object)new Object[]{NULL_STRING, CalciteQueryTest.timestamp("2001-01-01"), 3L}, (Object)new Object[]{NULL_STRING, null, 6L}));
    }

    @Test
    public void testGroupingSetsWithDummyDimension() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT dim2, gran, SUM(cnt)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, COALESCE(dim2, '') dim2, cnt FROM druid.foo) AS x\nGROUP BY GROUPING SETS ( (dim2, 'dummy', gran), (dim2), (gran), ('dummy') )", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "case_searched(notnull(\"dim2\"),\"dim2\",'')", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v2", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0"), new DefaultDimensionSpec("v2", "d2", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0", (Object)"d2"), (Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of(), (Object)ImmutableList.of((Object)"d2"))).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d2", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", CalciteQueryTest.timestamp("2000-01-01"), 2L}, (Object)new Object[]{"", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"", null, 3L}, (Object)new Object[]{"a", null, 2L}, (Object)new Object[]{"abc", null, 1L}, (Object)new Object[]{NULL_STRING, null, 6L}, (Object)new Object[]{NULL_STRING, CalciteQueryTest.timestamp("2000-01-01"), 3L}, (Object)new Object[]{NULL_STRING, CalciteQueryTest.timestamp("2001-01-01"), 3L}));
    }

    @Test
    public void testGroupingSetsNoSuperset() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT dim2, gran, SUM(cnt)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, COALESCE(dim2, '') dim2, cnt FROM druid.foo) AS x\nGROUP BY GROUPING SETS ( (), (dim2), (gran) )", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "case_searched(notnull(\"dim2\"),\"dim2\",'')", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0"), new DefaultDimensionSpec("v1", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of((Object)"d1"), (Object)ImmutableList.of())).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", null, 3L}, (Object)new Object[]{"a", null, 2L}, (Object)new Object[]{"abc", null, 1L}, (Object)new Object[]{NULL_STRING, CalciteQueryTest.timestamp("2000-01-01"), 3L}, (Object)new Object[]{NULL_STRING, CalciteQueryTest.timestamp("2001-01-01"), 3L}, (Object)new Object[]{NULL_STRING, null, 6L}));
    }

    @Test
    public void testGroupingSetsWithOrderByDimension() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT dim2, gran, SUM(cnt)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, COALESCE(dim2, '') dim2, cnt FROM druid.foo) AS x\nGROUP BY GROUPING SETS ( (), (dim2), (gran) )\nORDER BY gran, dim2 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "case_searched(notnull(\"dim2\"),\"dim2\",'')", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0"), new DefaultDimensionSpec("v1", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of((Object)"d1"), (Object)ImmutableList.of())).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC), (Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.LEXICOGRAPHIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", null, 1L}, (Object)new Object[]{"a", null, 2L}, (Object)new Object[]{"", null, 3L}, (Object)new Object[]{NULL_STRING, null, 6L}, (Object)new Object[]{NULL_STRING, CalciteQueryTest.timestamp("2000-01-01"), 3L}, (Object)new Object[]{NULL_STRING, CalciteQueryTest.timestamp("2001-01-01"), 3L}));
    }

    @Test
    public void testGroupingSetsWithOrderByAggregator() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT dim2, gran, SUM(cnt)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, COALESCE(dim2, '') dim2, cnt FROM druid.foo) AS x\nGROUP BY GROUPING SETS ( (), (dim2), (gran) )\nORDER BY SUM(cnt)\n", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "case_searched(notnull(\"dim2\"),\"dim2\",'')", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0"), new DefaultDimensionSpec("v1", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of((Object)"d1"), (Object)ImmutableList.of())).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", null, 1L}, (Object)new Object[]{"a", null, 2L}, (Object)new Object[]{"", null, 3L}, (Object)new Object[]{NULL_STRING, CalciteQueryTest.timestamp("2000-01-01"), 3L}, (Object)new Object[]{NULL_STRING, CalciteQueryTest.timestamp("2001-01-01"), 3L}, (Object)new Object[]{NULL_STRING, null, 6L}));
    }

    @Test
    public void testGroupingSetsWithOrderByAggregatorWithLimit() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT dim2, gran, SUM(cnt)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, COALESCE(dim2, '') dim2, cnt FROM druid.foo) AS x\nGROUP BY GROUPING SETS ( (), (dim2), (gran) )\nORDER BY SUM(cnt)\nLIMIT 1", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "case_searched(notnull(\"dim2\"),\"dim2\",'')", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0"), new DefaultDimensionSpec("v1", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of((Object)"d1"), (Object)ImmutableList.of())).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), Integer.valueOf(1))).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", null, 1L}));
    }

    @Test
    public void testTimeExtractWithTooFewArguments() throws Exception {
        try {
            this.testQuery("SELECT TIME_EXTRACT(__time) FROM druid.foo", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
            Assert.fail((String)"query execution should fail");
        }
        catch (SqlPlanningException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid number of arguments to function 'TIME_EXTRACT'. Was expecting 2 arguments"));
            Assert.assertEquals((Object)SqlPlanningException.PlanningError.VALIDATION_ERROR.getErrorCode(), (Object)e.getErrorCode());
            Assert.assertEquals((Object)SqlPlanningException.PlanningError.VALIDATION_ERROR.getErrorClass(), (Object)e.getErrorClass());
        }
    }

    @Test
    public void testUsingSubqueryAsFilterOnTwoColumns() throws Exception {
        this.testQuery("SELECT __time, cnt, dim1, dim2 FROM druid.foo  WHERE (dim1, dim2) IN (   SELECT dim1, dim2 FROM (     SELECT dim1, dim2, COUNT(*)     FROM druid.foo     WHERE dim2 = 'abc'     GROUP BY dim1, dim2     HAVING COUNT(*) = 1   ) )", (List<Query>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteQueryTest.selector("dim2", "abc", null)).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setPostAggregatorSpecs((List)ImmutableList.of((Object)CalciteQueryTest.expressionPostAgg("p0", "'abc'"))).setHavingSpec((HavingSpec)CalciteQueryTest.having((DimFilter)CalciteQueryTest.selector("a0", "1", null))).setContext(QUERY_CONTEXT_DEFAULT).build()), "j0.", StringUtils.format((String)"(%s && %s)", (Object[])new Object[]{CalciteQueryTest.equalsCondition(CalciteQueryTest.makeColumnExpression("dim1"), CalciteQueryTest.makeColumnExpression("j0.d0")), CalciteQueryTest.equalsCondition(CalciteQueryTest.makeColumnExpression("dim2"), CalciteQueryTest.makeColumnExpression("j0.p0"))}), JoinType.INNER)).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "'abc'", ColumnType.STRING)}).columns(new String[]{"__time", "cnt", "dim1", "v0"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteQueryTest.timestamp("2001-01-02"), 1L, "def", "abc"}));
    }

    @Test
    public void testUsingSubqueryAsFilterWithInnerSort() throws Exception {
        this.testQuery("SELECT dim1, dim2 FROM druid.foo\n WHERE dim2 IN (\n   SELECT dim2\n   FROM druid.foo\n   GROUP BY dim2\n   ORDER BY dim2 DESC\n )", (List<Query>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteQueryTest.equalsCondition(CalciteQueryTest.makeColumnExpression("dim2"), CalciteQueryTest.makeColumnExpression("j0.d0")), JoinType.INNER)).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "dim2"}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"", "a"}, (Object)new Object[]{"1", "a"}, (Object)new Object[]{"def", "abc"}) : ImmutableList.of((Object)new Object[]{"", "a"}, (Object)new Object[]{"2", ""}, (Object)new Object[]{"1", "a"}, (Object)new Object[]{"def", "abc"})));
    }

    @Test
    public void testUsingSubqueryWithLimit() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(*) AS cnt FROM ( SELECT * FROM druid.foo LIMIT 10 ) tmpA", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "0", ColumnType.LONG)}).columns(new String[]{"v0"}).limit(10L).context(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testUsingSubqueryWithoutLimit() throws Exception {
        this.testQuery("SELECT COUNT(*) AS cnt FROM ( SELECT * FROM druid.foo ) tmpA", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testUnicodeFilterAndGroupBy() throws Exception {
        this.testQuery("SELECT\n  dim1,\n  dim2,\n  COUNT(*)\nFROM foo2\nWHERE\n  dim1 LIKE U&'\u05d3\\05E8%'\n  OR dim1 = '\u0434\u0440\u0443\u0438\u0434'\nGROUP BY dim1, dim2", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo2").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteQueryTest.or(new DimFilter[]{new LikeDimFilter("dim1", "\u05d3\u05e8%", null, null), new SelectorDimFilter("dim1", "\u0434\u0440\u0443\u0438\u0434", null)})).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"\u0434\u0440\u0443\u0438\u0434", "ru", 1L}, (Object)new Object[]{"\u05d3\u05e8\u05d5\u05d0\u05d9\u05d3", "he", 1L}));
    }

    @Test
    public void testOrderByAlongWithAliasOrderByTimeGroupByMulti() throws Exception {
        this.testQuery("select  __time as bug, dim2  from druid.foo group by 1, 2 order by 1 limit 1", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("__time", "d0", ColumnType.LONG), new DefaultDimensionSpec("dim2", "d1", ColumnType.STRING)})).setLimitSpec((LimitSpec)new DefaultLimitSpec(Collections.singletonList(new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), Integer.valueOf(1))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L, "a"}));
    }

    @Test
    public void testOrderByAlongWithAliasOrderByTimeGroupByOneCol() throws Exception {
        this.testQuery("select __time as bug from druid.foo group by 1 order by 1 limit 1", (List<Query>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("__time", "d0", ColumnType.LONG)).threshold(1).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.NUMERIC)).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L}));
    }

    @Test
    public void testProjectAfterSort() throws Exception {
        this.testQuery("select dim1 from (select dim1, dim2, count(*) cnt from druid.foo group by dim1, dim2 order by cnt)", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{""}, (Object)new Object[]{"1"}, (Object)new Object[]{"10.1"}, (Object)new Object[]{"2"}, (Object)new Object[]{"abc"}, (Object)new Object[]{"def"}));
    }

    @Test
    public void testProjectAfterSort2() throws Exception {
        this.testQuery("select s / cnt, dim1, dim2, s from (select dim1, dim2, count(*) cnt, sum(m2) s from druid.foo group by dim1, dim2 order by cnt)", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0"), new DoubleSumAggregatorFactory("a1", "m2")})).setPostAggregatorSpecs(Collections.singletonList(CalciteQueryTest.expressionPostAgg("p0", "(\"a1\" / \"a0\")"))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1.0, "", "a", 1.0}, (Object)new Object[]{4.0, "1", "a", 4.0}, (Object)new Object[]{2.0, "10.1", NullHandling.defaultStringValue(), 2.0}, (Object)new Object[]{3.0, "2", "", 3.0}, (Object)new Object[]{6.0, "abc", NullHandling.defaultStringValue(), 6.0}, (Object)new Object[]{5.0, "def", "abc", 5.0}));
    }

    @Test
    @Ignore(value="In Calcite 1.17, this test worked, but after upgrading to Calcite 1.21, this query fails with: org.apache.calcite.sql.validate.SqlValidatorException: Column 'dim1' is ambiguous")
    public void testProjectAfterSort3() throws Exception {
        this.testQuery("select dim1 from (select dim1, dim1, count(*) cnt from druid.foo group by dim1, dim1 order by cnt)", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)new DefaultLimitSpec(Collections.singletonList(new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{""}, (Object)new Object[]{"1"}, (Object)new Object[]{"10.1"}, (Object)new Object[]{"2"}, (Object)new Object[]{"abc"}, (Object)new Object[]{"def"}));
    }

    @Test
    public void testProjectAfterSort3WithoutAmbiguity() throws Exception {
        this.testQuery("select copydim1 from (select dim1, dim1 AS copydim1, count(*) cnt from druid.foo group by dim1, dim1 order by cnt)", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{""}, (Object)new Object[]{"1"}, (Object)new Object[]{"10.1"}, (Object)new Object[]{"2"}, (Object)new Object[]{"abc"}, (Object)new Object[]{"def"}));
    }

    @Test
    public void testSortProjectAfterNestedGroupBy() throws Exception {
        this.testQuery("SELECT   cnt FROM (  SELECT     __time,     dim1,     COUNT(m2) AS cnt   FROM (    SELECT         __time,         m2,         dim1     FROM druid.foo     GROUP BY __time, m2, dim1   )   GROUP BY __time, dim1   ORDER BY cnt)", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(this.useDefault ? CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("__time", "d0", ColumnType.LONG), new DefaultDimensionSpec("m2", "d1", ColumnType.DOUBLE), new DefaultDimensionSpec("dim1", "d2")}) : CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("__time", "d0", ColumnType.LONG), new DefaultDimensionSpec("dim1", "d1"), new DefaultDimensionSpec("m2", "d2", ColumnType.DOUBLE)})).setContext(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(this.useDefault ? CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("d0", "_d0", ColumnType.LONG), new DefaultDimensionSpec("d2", "_d1", ColumnType.STRING)}) : CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("d0", "_d0", ColumnType.LONG), new DefaultDimensionSpec("d1", "_d1", ColumnType.STRING)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{this.useDefault ? new CountAggregatorFactory("a0") : new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("d2", null, null)))})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}, (Object)new Object[]{1L}, (Object)new Object[]{1L}, (Object)new Object[]{1L}, (Object)new Object[]{1L}, (Object)new Object[]{1L}));
    }

    @Test
    public void testPostAggWithTimeseries() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT   FLOOR(__time TO YEAR),   SUM(m1),   SUM(m1) + SUM(m2) FROM   druid.foo WHERE   dim2 = 'a' GROUP BY FLOOR(__time TO YEAR) ORDER BY FLOOR(__time TO YEAR) desc", Collections.singletonList(Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteQueryTest.selector("dim2", "a", null)).granularity(Granularities.YEAR).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1"), new DoubleSumAggregatorFactory("a1", "m2")})).postAggregators(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("p0", "(\"a0\" + \"a1\")")}).descending(true).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{978307200000L, 4.0, 8.0}, (Object)new Object[]{946684800000L, 1.0, 2.0}));
    }

    @Test
    public void testPostAggWithTopN() throws Exception {
        this.testQuery("SELECT   AVG(m2),   SUM(m1) + SUM(m2) FROM   druid.foo WHERE   dim2 = 'a' GROUP BY m1 ORDER BY m1 LIMIT 5", Collections.singletonList(new TopNQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("m1", "d0", ColumnType.FLOAT)).filters("dim2", "a").aggregators(this.useDefault ? CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0:sum", "m2"), new CountAggregatorFactory("a0:count"), new DoubleSumAggregatorFactory("a1", "m1"), new DoubleSumAggregatorFactory("a2", "m2")}) : CalciteQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0:sum", "m2"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0:count"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("m2", null, null))), new DoubleSumAggregatorFactory("a1", "m1"), new DoubleSumAggregatorFactory("a2", "m2")})).postAggregators(new PostAggregator[]{new ArithmeticPostAggregator("a0", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "a0:sum"), (Object)new FieldAccessPostAggregator(null, "a0:count"))), CalciteQueryTest.expressionPostAgg("p0", "(\"a1\" + \"a2\")")}).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.NUMERIC)).threshold(5).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1.0, 2.0}, (Object)new Object[]{4.0, 8.0}));
    }

    @Test
    public void testConcat() throws Exception {
        this.testQuery("SELECT CONCAT(dim1, '-', dim1, '_', dim1) as dimX FROM foo", (List<Query>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "concat(\"dim1\",'-',\"dim1\",'_',\"dim1\")", ColumnType.STRING)}).columns(new String[]{"v0"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"-_"}, (Object)new Object[]{"10.1-10.1_10.1"}, (Object)new Object[]{"2-2_2"}, (Object)new Object[]{"1-1_1"}, (Object)new Object[]{"def-def_def"}, (Object)new Object[]{"abc-abc_abc"}));
        this.testQuery("SELECT CONCAt(dim1, CONCAt(dim2,'x'), m2, 9999, dim1) as dimX FROM foo", (List<Query>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "concat(\"dim1\",concat(\"dim2\",'x'),\"m2\",9999,\"dim1\")", ColumnType.STRING)}).columns(new String[]{"v0"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"ax1.09999"}, (Object)new Object[]{NullHandling.sqlCompatible() ? null : "10.1x2.0999910.1"}, (Object)new Object[]{"2x3.099992"}, (Object)new Object[]{"1ax4.099991"}, (Object)new Object[]{"defabcx5.09999def"}, (Object)new Object[]{NullHandling.sqlCompatible() ? null : "abcx6.09999abc"}));
    }

    @Test
    public void testConcatGroup() throws Exception {
        this.testQuery("SELECT CONCAT(dim1, '-', dim1, '_', dim1) as dimX FROM foo GROUP BY 1", (List<Query>)ImmutableList.of((Object)new GroupByQuery.Builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "concat(\"dim1\",'-',\"dim1\",'_',\"dim1\")", ColumnType.STRING)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setGranularity(Granularities.ALL).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"-_"}, (Object)new Object[]{"1-1_1"}, (Object)new Object[]{"10.1-10.1_10.1"}, (Object)new Object[]{"2-2_2"}, (Object)new Object[]{"abc-abc_abc"}, (Object)new Object[]{"def-def_def"}));
        ImmutableList secondResults = this.useDefault ? ImmutableList.of((Object)new Object[]{"10.1x2.0999910.1"}, (Object)new Object[]{"1ax4.099991"}, (Object)new Object[]{"2x3.099992"}, (Object)new Object[]{"abcx6.09999abc"}, (Object)new Object[]{"ax1.09999"}, (Object)new Object[]{"defabcx5.09999def"}) : ImmutableList.of((Object)new Object[]{null}, (Object)new Object[]{"1ax4.099991"}, (Object)new Object[]{"2x3.099992"}, (Object)new Object[]{"ax1.09999"}, (Object)new Object[]{"defabcx5.09999def"});
        this.testQuery("SELECT CONCAT(dim1, CONCAT(dim2,'x'), m2, 9999, dim1) as dimX FROM foo GROUP BY 1", (List<Query>)ImmutableList.of((Object)new GroupByQuery.Builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "concat(\"dim1\",concat(\"dim2\",'x'),\"m2\",9999,\"dim1\")", ColumnType.STRING)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setGranularity(Granularities.ALL).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)secondResults);
    }

    @Test
    public void testTextcat() throws Exception {
        this.testQuery("SELECT textcat(dim1, dim1) as dimX FROM foo", (List<Query>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "concat(\"dim1\",\"dim1\")", ColumnType.STRING)}).columns(new String[]{"v0"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{""}, (Object)new Object[]{"10.110.1"}, (Object)new Object[]{"22"}, (Object)new Object[]{"11"}, (Object)new Object[]{"defdef"}, (Object)new Object[]{"abcabc"}));
        this.testQuery("SELECT textcat(dim1, CAST(m2 as VARCHAR)) as dimX FROM foo", (List<Query>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "concat(\"dim1\",CAST(\"m2\", 'STRING'))", ColumnType.STRING)}).columns(new String[]{"v0"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"1.0"}, (Object)new Object[]{"10.12.0"}, (Object)new Object[]{"23.0"}, (Object)new Object[]{"14.0"}, (Object)new Object[]{"def5.0"}, (Object)new Object[]{"abc6.0"}));
    }

    @Test
    public void testRequireTimeConditionPositive() throws Exception {
        this.testQuery(PLANNER_CONFIG_REQUIRE_TIME_CONDITION, "SELECT SUM(cnt), gran FROM (\n  SELECT __time as t, floor(__time TO month) AS gran,\n  cnt FROM druid.foo\n) AS x\nWHERE t >= '2000-01-01' and t < '2002-01-01'GROUP BY gran\nORDER BY gran", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Intervals.of((String)"2000-01-01/2002-01-01"))).granularity(Granularities.MONTH).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(CalciteQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L, CalciteQueryTest.timestamp("2000-01-01")}, (Object)new Object[]{3L, CalciteQueryTest.timestamp("2001-01-01")}));
        this.testQuery(PLANNER_CONFIG_REQUIRE_TIME_CONDITION, "SELECT\n  SUM(cnt),\n  COUNT(*)\nFROM (SELECT dim2, SUM(cnt) AS cnt FROM druid.foo WHERE __time >= '2000-01-01' GROUP BY dim2)", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Intervals.utc((long)DateTimes.of((String)"2000-01-01").getMillis(), (long)0x3FFFFFFFFFFFFFFFL))).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("_a0", "a0"), new CountAggregatorFactory("_a1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{6L, 3L}) : ImmutableList.of((Object)new Object[]{6L, 4L})));
        this.cannotVectorize();
        this.testQuery(PLANNER_CONFIG_REQUIRE_TIME_CONDITION, "SELECT COUNT(*) FROM druid.foo\nWHERE __time >= '2000-01-01' AND SUBSTRING(dim2, 1, 1) IN (\n  SELECT SUBSTRING(dim1, 1, 1) FROM druid.foo\n  WHERE dim1 <> '' AND __time >= '2000-01-01'\n)", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Intervals.utc((long)DateTimes.of((String)"2000-01-01").getMillis(), (long)0x3FFFFFFFFFFFFFFFL))).setDimFilter((DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", NullHandling.sqlCompatible() ? "" : null, null))).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new ExtractionDimensionSpec("dim1", "d0", ColumnType.STRING, (ExtractionFn)new SubstringDimExtractionFn(0, Integer.valueOf(1)))}).setContext(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteQueryTest.equalsCondition(CalciteQueryTest.makeExpression("substring(\"dim2\", 0, 1)"), DruidExpression.ofColumn((ColumnType)ColumnType.STRING, (String)"j0.d0")), JoinType.INNER)).intervals(CalciteQueryTest.querySegmentSpec(Intervals.utc((long)DateTimes.of((String)"2000-01-01").getMillis(), (long)0x3FFFFFFFFFFFFFFFL))).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
    }

    @Test
    public void testRequireTimeConditionLogicalValuePositive() throws Exception {
        this.testQuery(PLANNER_CONFIG_REQUIRE_TIME_CONDITION, "SELECT 2 + 2 AS a", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{4L}), (RowSignature)RowSignature.builder().add("a", ColumnType.LONG).build())).columns(new String[]{"a"}).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{4}));
    }

    @Test
    public void testRequireTimeConditionSimpleQueryNegative() throws Exception {
        this.expectedException.expect(CannotBuildQueryException.class);
        this.expectedException.expectMessage("__time column");
        this.testQuery(PLANNER_CONFIG_REQUIRE_TIME_CONDITION, "SELECT SUM(cnt), gran FROM (\n  SELECT __time as t, floor(__time TO month) AS gran,\n  cnt FROM druid.foo\n) AS x\nGROUP BY gran\nORDER BY gran", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testRequireTimeConditionSubQueryNegative() throws Exception {
        this.expectedException.expect(CannotBuildQueryException.class);
        this.expectedException.expectMessage("__time column");
        this.testQuery(PLANNER_CONFIG_REQUIRE_TIME_CONDITION, "SELECT\n  SUM(cnt),\n  COUNT(*)\nFROM (SELECT dim2, SUM(cnt) AS cnt FROM druid.foo GROUP BY dim2)", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testRequireTimeConditionSemiJoinNegative() throws Exception {
        this.expectedException.expect(CannotBuildQueryException.class);
        this.expectedException.expectMessage("__time column");
        this.testQuery(PLANNER_CONFIG_REQUIRE_TIME_CONDITION, "SELECT COUNT(*) FROM druid.foo\nWHERE SUBSTRING(dim2, 1, 1) IN (\n  SELECT SUBSTRING(dim1, 1, 1) FROM druid.foo\n  WHERE dim1 <> '' AND __time >= '2000-01-01'\n)", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testFilterFloatDimension() throws Exception {
        this.testQuery("SELECT dim1 FROM numfoo WHERE f1 = 0.1 LIMIT 1", (List<Query>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1"}).filters((DimFilter)CalciteQueryTest.selector("f1", "0.1", null)).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(1L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1"}));
    }

    @Test
    public void testFilterDoubleDimension() throws Exception {
        this.testQuery("SELECT dim1 FROM numfoo WHERE d1 = 1.7 LIMIT 1", (List<Query>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1"}).filters((DimFilter)CalciteQueryTest.selector("d1", "1.7", null)).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(1L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1"}));
    }

    @Test
    public void testFilterLongDimension() throws Exception {
        this.testQuery("SELECT dim1 FROM numfoo WHERE l1 = 7 LIMIT 1", (List<Query>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1"}).filters((DimFilter)CalciteQueryTest.selector("l1", "7", null)).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(1L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{""}));
    }

    @Test
    public void testTrigonometricFunction() throws Exception {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_DEFAULT, "SELECT exp(count(*)) + 10, sin(pi / 6), cos(pi / 6), tan(pi / 6), cot(pi / 6),asin(exp(count(*)) / 2), acos(exp(count(*)) / 2), atan(exp(count(*)) / 2), atan2(exp(count(*)), 1) FROM druid.foo WHERE  dim2 = 0", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteQueryTest.bound("dim2", "0", "0", false, false, null, StringComparators.NUMERIC)).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).postAggregators(new PostAggregator[]{CalciteQueryTest.expressionPostAgg("p0", "(exp(\"a0\") + 10)"), CalciteQueryTest.expressionPostAgg("p1", "0.49999999999999994"), CalciteQueryTest.expressionPostAgg("p2", "0.8660254037844387"), CalciteQueryTest.expressionPostAgg("p3", "0.5773502691896257"), CalciteQueryTest.expressionPostAgg("p4", "1.7320508075688776"), CalciteQueryTest.expressionPostAgg("p5", "asin((exp(\"a0\") / 2))"), CalciteQueryTest.expressionPostAgg("p6", "acos((exp(\"a0\") / 2))"), CalciteQueryTest.expressionPostAgg("p7", "atan((exp(\"a0\") / 2))"), CalciteQueryTest.expressionPostAgg("p8", "atan2(exp(\"a0\"),1)")}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{11.0, Math.sin(0.5235987755982988), Math.cos(0.5235987755982988), Math.tan(0.5235987755982988), Math.cos(0.5235987755982988) / Math.sin(0.5235987755982988), Math.asin(0.5), Math.acos(0.5), Math.atan(0.5), Math.atan2(1.0, 1.0)}));
    }

    @Test
    public void testRadiansAndDegrees() throws Exception {
        this.testQuery("SELECT RADIANS(m1 * 15)/DEGREES(m2) FROM numfoo WHERE dim1 = '1'", (List<Query>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "(toRadians((\"m1\" * 15)) / toDegrees(\"m2\"))", ColumnType.DOUBLE)}).columns(new String[]{"v0"}).filters((DimFilter)CalciteQueryTest.selector("dim1", "1", null)).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Math.toRadians(60.0) / Math.toDegrees(4.0)}));
    }

    @Test
    public void testTimestampDiff() throws Exception {
        this.testQuery("SELECT TIMESTAMPDIFF(DAY, TIMESTAMP '1999-01-01 00:00:00', __time), \nTIMESTAMPDIFF(DAY, __time, DATE '2001-01-01'), \nTIMESTAMPDIFF(HOUR, TIMESTAMP '1999-12-31 01:00:00', __time), \nTIMESTAMPDIFF(MINUTE, TIMESTAMP '1999-12-31 23:58:03', __time), \nTIMESTAMPDIFF(SECOND, TIMESTAMP '1999-12-31 23:59:03', __time), \nTIMESTAMPDIFF(MONTH, TIMESTAMP '1999-11-01 00:00:00', __time), \nTIMESTAMPDIFF(YEAR, TIMESTAMP '1996-11-01 00:00:00', __time), \nTIMESTAMPDIFF(QUARTER, TIMESTAMP '1996-10-01 00:00:00', __time), \nTIMESTAMPDIFF(WEEK, TIMESTAMP '1998-10-01 00:00:00', __time) \nFROM druid.foo\nLIMIT 2", (List<Query>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "div((\"__time\" - 915148800000),86400000)", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v1", "div((978307200000 - \"__time\"),86400000)", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v2", "div((\"__time\" - 946602000000),3600000)", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v3", "div((\"__time\" - 946684683000),60000)", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v4", "div((\"__time\" - 946684743000),1000)", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v5", "subtract_months(\"__time\",941414400000,'UTC')", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v6", "div(subtract_months(\"__time\",846806400000,'UTC'),12)", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v7", "div(subtract_months(\"__time\",844128000000,'UTC'),3)", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v8", "div(div((\"__time\" - 907200000000),1000),604800)", ColumnType.LONG)}).columns(new String[]{"v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7", "v8"}).limit(2L).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{365, 366, 23, 1, 57, 2, 3, 13, 65}, (Object)new Object[]{366, 365, 47, 1441, 86457, 2, 3, 13, 65}));
    }

    @Test
    public void testTimestampCeil() throws Exception {
        this.testQuery("SELECT CEIL(TIMESTAMP '2000-01-01 00:00:00' TO DAY), \nCEIL(TIMESTAMP '2000-01-01 01:00:00' TO DAY) \nFROM druid.foo\nLIMIT 1", (List<Query>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "946684800000", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v1", "946771200000", ColumnType.LONG)}).columns(new String[]{"v0", "v1"}).limit(1L).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Calcites.jodaToCalciteTimestamp((DateTime)DateTimes.of((String)"2000-01-01"), (DateTimeZone)DateTimeZone.UTC), Calcites.jodaToCalciteTimestamp((DateTime)DateTimes.of((String)"2000-01-02"), (DateTimeZone)DateTimeZone.UTC)}));
    }

    @Test
    public void testNvlColumns() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT NVL(dim2, dim1), COUNT(*) FROM druid.foo GROUP BY NVL(dim2, dim1)\n", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "case_searched(notnull(\"dim2\"),\"dim2\",\"dim1\")", ColumnType.STRING)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"10.1", 1L}, (Object)new Object[]{"2", 1L}, (Object)new Object[]{"a", 2L}, (Object)new Object[]{"abc", 2L}) : ImmutableList.of((Object)new Object[]{"", 1L}, (Object)new Object[]{"10.1", 1L}, (Object)new Object[]{"a", 2L}, (Object)new Object[]{"abc", 2L})));
    }

    @Test
    public void testGroupByWithLiteralInSubqueryGrouping() throws Exception {
        this.testQuery("SELECT \n   t1, t2\n  FROM\n   ( SELECT\n     'dummy' as t1,\n     CASE\n       WHEN \n         dim4 = 'b'\n       THEN dim4\n       ELSE NULL\n     END AS t2\n     FROM\n       numfoo\n     GROUP BY\n       dim4\n   )\n GROUP BY\n   t1,t2\n", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim4", "_d0", ColumnType.STRING)}).setContext(QUERY_CONTEXT_DEFAULT).build()).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "'dummy'", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "case_searched((\"_d0\" == 'b'),\"_d0\",null)", ColumnType.STRING)}).setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING), new DefaultDimensionSpec("v1", "d1", ColumnType.STRING)})).setGranularity(Granularities.ALL).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"dummy", NULL_STRING}, (Object)new Object[]{"dummy", "b"}));
    }

    @Test
    public void testLeftRightStringOperators() throws Exception {
        this.testQuery("SELECT\n  dim1,  LEFT(dim1, 2),\n  RIGHT(dim1, 2)\nFROM druid.foo\nGROUP BY dim1\n", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setPostAggregatorSpecs((List)ImmutableList.of((Object)CalciteQueryTest.expressionPostAgg("p0", "left(\"d0\",2)"), (Object)CalciteQueryTest.expressionPostAgg("p1", "right(\"d0\",2)"))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "", ""}, (Object)new Object[]{"1", "1", "1"}, (Object)new Object[]{"10.1", "10", ".1"}, (Object)new Object[]{"2", "2", "2"}, (Object)new Object[]{"abc", "ab", "bc"}, (Object)new Object[]{"def", "de", "ef"}));
    }

    @Test
    public void testQueryContextOuterLimit() throws Exception {
        HashMap<String, Object> outerLimitContext = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        outerLimitContext.put("sqlOuterLimit", 4);
        TopNQueryBuilder baseBuilder = new TopNQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0")).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC))).context(outerLimitContext);
        ImmutableList results1 = NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{""}, (Object)new Object[]{"def"}, (Object)new Object[]{"abc"}, (Object)new Object[]{"2"}) : ImmutableList.of((Object)new Object[]{"def"}, (Object)new Object[]{"abc"}, (Object)new Object[]{"2"}, (Object)new Object[]{"10.1"});
        this.testQuery(PLANNER_CONFIG_DEFAULT, outerLimitContext, "SELECT dim1 FROM druid.foo GROUP BY dim1 ORDER BY dim1 DESC", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)baseBuilder.threshold(4).build()), (List<Object[]>)results1);
        this.testQuery(PLANNER_CONFIG_DEFAULT, outerLimitContext, "SELECT dim1 FROM druid.foo GROUP BY dim1 ORDER BY dim1 DESC LIMIT 9", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)baseBuilder.threshold(4).build()), (List<Object[]>)results1);
        ImmutableList results2 = NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{""}, (Object)new Object[]{"def"}) : ImmutableList.of((Object)new Object[]{"def"}, (Object)new Object[]{"abc"});
        this.testQuery(PLANNER_CONFIG_DEFAULT, outerLimitContext, "SELECT dim1 FROM druid.foo GROUP BY dim1 ORDER BY dim1 DESC LIMIT 2", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)baseBuilder.threshold(2).build()), (List<Object[]>)results2);
    }

    @Test
    public void testRepeatedIdenticalVirtualExpressionGrouping() throws Exception {
        String query = "SELECT \n\tCASE dim1 WHEN NULL THEN FALSE ELSE TRUE END AS col_a,\n\tCASE dim2 WHEN NULL THEN FALSE ELSE TRUE END AS col_b\nFROM foo\nGROUP BY 1, 2";
        this.testQuery("SELECT \n\tCASE dim1 WHEN NULL THEN FALSE ELSE TRUE END AS col_a,\n\tCASE dim2 WHEN NULL THEN FALSE ELSE TRUE END AS col_b\nFROM foo\nGROUP BY 1, 2", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "1", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG)})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{true, true}));
    }

    @Test
    public void testValidationErrorNullLiteralIllegal() throws Exception {
        this.expectedException.expectMessage("Illegal use of 'NULL'");
        this.testQuery("SELECT REGEXP_LIKE('x', NULL)", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testValidationErrorNonLiteralIllegal() throws Exception {
        this.expectedException.expectMessage("Argument to function 'REGEXP_LIKE' must be a literal");
        this.testQuery("SELECT REGEXP_LIKE('x', dim1) FROM foo", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testValidationErrorWrongTypeLiteral() throws Exception {
        this.expectedException.expectMessage("Cannot apply 'REGEXP_LIKE' to arguments");
        this.testQuery("SELECT REGEXP_LIKE('x', 1) FROM foo", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
    }

    /*
     * Exception decompiling
     */
    @Test
    public void testTimeStampAddZeroDayPeriod() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Test
    public void testTimeStampAddZeroMonthPeriod() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Test
    public void testTimeStampAddZeroYearPeriod() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void testTimeStampAddConversion() throws Exception {
        PeriodGranularity periodGranularity = new PeriodGranularity(new Period((Object)"P1M"), null, null);
        this.testQuery("SELECT TIMESTAMPADD(MONTH, 1, \"__time\") FROM druid.foo", (List<Query>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_shift(\"__time\",'P1M',1,'UTC')", ColumnType.LONG)}).columns(new String[]{"v0"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), CalciteTests.ROWS1.stream().map(r -> new Object[]{periodGranularity.increment(r.getTimestamp()).getMillis()}).collect(Collectors.toList()));
        this.testQuery("SELECT TIMESTAMPADD(MONTH, \"cnt\", \"__time\") FROM druid.foo", (List<Query>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "timestamp_shift(\"__time\",concat('P', (1 * \"cnt\"), 'M'),1,'UTC')", ColumnType.LONG)}).columns(new String[]{"v0"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), CalciteTests.ROWS1.stream().map(row -> new Object[]{periodGranularity.increment(row.getTimestamp()).getMillis()}).collect(Collectors.toList()));
    }

    @Test
    public void testGroupingSetsWithLimit() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT dim2, gran, SUM(cnt)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, COALESCE(dim2, '') dim2, cnt FROM druid.foo) AS x\nGROUP BY GROUPING SETS ( (dim2, gran), (dim2), (gran), () ) LIMIT 100", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "case_searched(notnull(\"dim2\"),\"dim2\",'')", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0"), new DefaultDimensionSpec("v1", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0", (Object)"d1"), (Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of((Object)"d1"), (Object)ImmutableList.of())).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of(), Integer.valueOf(100))).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", CalciteQueryTest.timestamp("2000-01-01"), 2L}, (Object)new Object[]{"", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"", null, 3L}, (Object)new Object[]{"a", null, 2L}, (Object)new Object[]{"abc", null, 1L}, (Object)new Object[]{NULL_STRING, CalciteQueryTest.timestamp("2000-01-01"), 3L}, (Object)new Object[]{NULL_STRING, CalciteQueryTest.timestamp("2001-01-01"), 3L}, (Object)new Object[]{NULL_STRING, null, 6L}));
    }

    @Test
    public void testGroupingSetsWithLimitOrderByGran() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT dim2, gran, SUM(cnt)\nFROM (SELECT FLOOR(__time TO MONTH) AS gran, COALESCE(dim2, '') dim2, cnt FROM druid.foo) AS x\nGROUP BY GROUPING SETS ( (dim2, gran), (dim2), (gran), () ) ORDER BY x.gran LIMIT 100", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "case_searched(notnull(\"dim2\"),\"dim2\",'')", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0"), new DefaultDimensionSpec("v1", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setSubtotalsSpec((List)ImmutableList.of((Object)ImmutableList.of((Object)"d0", (Object)"d1"), (Object)ImmutableList.of((Object)"d0"), (Object)ImmutableList.of((Object)"d1"), (Object)ImmutableList.of())).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.ASCENDING, (StringComparator)new StringComparators.NumericComparator())), Integer.valueOf(100))).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.builder().add((Object[])new Object[][]{{"", null, 2L}, {"a", null, 1L}, {"", null, 1L}, {"a", null, 1L}, {"abc", null, 1L}, {NULL_STRING, null, 6L}, {"", CalciteQueryTest.timestamp("2000-01-01"), 2L}, {"a", CalciteQueryTest.timestamp("2000-01-01"), 1L}, {NULL_STRING, CalciteQueryTest.timestamp("2000-01-01"), 3L}, {"", CalciteQueryTest.timestamp("2001-01-01"), 1L}, {"a", CalciteQueryTest.timestamp("2001-01-01"), 1L}, {"abc", CalciteQueryTest.timestamp("2001-01-01"), 1L}, {NULL_STRING, CalciteQueryTest.timestamp("2001-01-01"), 3L}}).build());
    }

    @Test
    public void testLookupWithNull() throws Exception {
        ImmutableList expected = this.useDefault ? ImmutableList.builder().add((Object[])new Object[][]{{NULL_STRING, NULL_STRING}, {NULL_STRING, NULL_STRING}, {NULL_STRING, NULL_STRING}}).build() : ImmutableList.builder().add((Object[])new Object[][]{{NULL_STRING, NULL_STRING}, {NULL_STRING, NULL_STRING}}).build();
        this.testQuery("SELECT dim2 ,lookup(dim2,'lookyloo') from foo where dim2 is null", (List<Query>)ImmutableList.of((Object)new Druids.ScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "null", ColumnType.STRING)}).columns(new String[]{"v0"}).legacy(Boolean.valueOf(false)).filters((DimFilter)new SelectorDimFilter("dim2", NULL_STRING, null)).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testRoundFuc() throws Exception {
        this.testQuery("SELECT f1, round(f1) FROM druid.numfoo", (List<Query>)ImmutableList.of((Object)new Druids.ScanQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "round(\"f1\")", ColumnType.FLOAT)}).columns(new String[]{"f1", "v0"}).legacy(Boolean.valueOf(false)).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)new Object[]{Float.valueOf(1.0f), Float.valueOf(1.0f)}, (Object)new Object[]{Float.valueOf(0.1f), Float.valueOf(0.0f)}, (Object)new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)}, (Object)new Object[]{null, null}, (Object)new Object[]{null, null}, (Object)new Object[]{null, null}) : ImmutableList.of((Object)new Object[]{Float.valueOf(1.0f), Float.valueOf(1.0f)}, (Object)new Object[]{Float.valueOf(0.1f), Float.valueOf(0.0f)}, (Object)new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)}, (Object)new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)}, (Object)new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)}, (Object)new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)})));
    }

    @Test
    public void testCountAndAverageByConstantVirtualColumn() throws Exception {
        ImmutableList virtualColumns;
        ImmutableList aggs;
        if (this.useDefault) {
            aggs = ImmutableList.of((Object)new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("v0", null, null))), (Object)new LongSumAggregatorFactory("a1:sum", "v1", null, TestExprMacroTable.INSTANCE), (Object)new CountAggregatorFactory("a1:count"));
            virtualColumns = ImmutableList.of((Object)CalciteQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING), (Object)CalciteQueryTest.expressionVirtualColumn("v1", "325323", ColumnType.LONG));
        } else {
            aggs = ImmutableList.of((Object)new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("v0", null, null))), (Object)new LongSumAggregatorFactory("a1:sum", "v1"), (Object)new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a1:count"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("v1", null, null))));
            virtualColumns = ImmutableList.of((Object)CalciteQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING), (Object)CalciteQueryTest.expressionVirtualColumn("v1", "325323", ColumnType.LONG));
        }
        this.testQuery("SELECT dim5, COUNT(dim1), AVG(l1) FROM druid.numfoo WHERE dim1 = '10.1' AND l1 = 325323 GROUP BY dim5", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter((DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.selector("dim1", "10.1", null), CalciteQueryTest.selector("l1", "325323", null)})).setGranularity(Granularities.ALL).setVirtualColumns(VirtualColumns.create((List)virtualColumns)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim5", "_d0", ColumnType.STRING)}).setAggregatorSpecs((List)aggs).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ArithmeticPostAggregator("a1", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "a1:sum"), (Object)new FieldAccessPostAggregator(null, "a1:count"))))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"ab", 1L, 325323L}));
    }

    @Test
    public void testEmptyGroupWithOffsetDoesntInfiniteLoop() throws Exception {
        this.testQuery("SELECT r0.c, r1.c\nFROM (\n  SELECT COUNT(*) AS c\n  FROM \"foo\"\n  GROUP BY ()\n  OFFSET 1\n) AS r0\nLEFT JOIN (\n  SELECT COUNT(*) AS c\n  FROM \"foo\"\n  GROUP BY ()\n) AS r1 ON TRUE LIMIT 10", (List<Query>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)CalciteQueryTest.join((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)DefaultLimitSpec.builder().offset(1).limit(10).build()).setContext(QUERY_CONTEXT_DEFAULT).build()), (DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", "1", JoinType.LEFT, null)).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"a0", "j0.a0"}).limit(10L).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).legacy(Boolean.valueOf(false)).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testJoinWithTimeDimension() throws Exception {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_DEFAULT, "SELECT count(*) FROM druid.foo t1 inner join druid.foo t2 on t1.__time = t2.__time", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)JoinDataSource.create((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)Druids.newScanQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).columns(new String[]{"__time"}).legacy(Boolean.valueOf(false)).context(QUERY_CONTEXT_DEFAULT).build()), (String)"j0.", (String)"(\"__time\" == \"j0.__time\")", (JoinType)JoinType.INNER, null, (ExprMacroTable)ExprMacroTable.nil())).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testExpressionCounts() throws Exception {
        Object[] objectArray;
        this.cannotVectorize();
        ImmutableList immutableList = ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "reverse(\"dim2\")", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "left(\"dim2\",5)", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v2", "(strpos(\"dim2\",'a') + 1)", ColumnType.LONG)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("v0", null, null))), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a1"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("v1", null, null))), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a2"), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("v2", null, null)))})).context(QUERY_CONTEXT_DEFAULT).build());
        if (this.useDefault) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = 3L;
            objectArray2[1] = 3L;
            objectArray = objectArray2;
            objectArray2[2] = 6L;
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = 4L;
            objectArray3[1] = 4L;
            objectArray = objectArray3;
            objectArray3[2] = 4L;
        }
        this.testQuery("SELECT\n COUNT(reverse(dim2)),\n COUNT(left(dim2, 5)),\n COUNT(strpos(dim2, 'a'))\nFROM druid.numfoo", (List<Query>)immutableList, (List<Object[]>)ImmutableList.of((Object)objectArray));
    }

    @Test
    public void testBitwiseAggregatorsTimeseries() throws Exception {
        Object[] objectArray;
        this.cannotVectorize();
        ImmutableList immutableList = ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"l1"), "__acc", "0", "0", Boolean.valueOf(NullHandling.sqlCompatible()), Boolean.valueOf(false), Boolean.valueOf(false), "bitwiseAnd(\"__acc\", \"l1\")", "bitwiseAnd(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("l1", null, null))), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"l1"), "__acc", "0", "0", Boolean.valueOf(NullHandling.sqlCompatible()), Boolean.valueOf(false), Boolean.valueOf(false), "bitwiseOr(\"__acc\", \"l1\")", "bitwiseOr(\"__acc\", \"a1\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("l1", null, null))), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a2", (Set)ImmutableSet.of((Object)"l1"), "__acc", "0", "0", Boolean.valueOf(NullHandling.sqlCompatible()), Boolean.valueOf(false), Boolean.valueOf(false), "bitwiseXor(\"__acc\", \"l1\")", "bitwiseXor(\"__acc\", \"a2\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("l1", null, null)))})).context(QUERY_CONTEXT_DEFAULT).build());
        if (this.useDefault) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = 0L;
            objectArray2[1] = 325327L;
            objectArray = objectArray2;
            objectArray2[2] = 325324L;
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = 0L;
            objectArray3[1] = 325327L;
            objectArray = objectArray3;
            objectArray3[2] = 325324L;
        }
        this.testQuery("SELECT\n BIT_AND(l1),\n BIT_OR(l1),\n BIT_XOR(l1)\nFROM druid.numfoo", (List<Query>)immutableList, (List<Object[]>)ImmutableList.of((Object)objectArray));
    }

    @Test
    public void testBitwiseAggregatorsGroupBy() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT\n dim2,\n BIT_AND(l1),\n BIT_OR(l1),\n BIT_XOR(l1)\nFROM druid.numfoo GROUP BY 1 ORDER BY 4", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "_d0", ColumnType.STRING)}).setAggregatorSpecs(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"l1"), "__acc", "0", "0", Boolean.valueOf(NullHandling.sqlCompatible()), Boolean.valueOf(false), Boolean.valueOf(false), "bitwiseAnd(\"__acc\", \"l1\")", "bitwiseAnd(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("l1", null, null))), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"l1"), "__acc", "0", "0", Boolean.valueOf(NullHandling.sqlCompatible()), Boolean.valueOf(false), Boolean.valueOf(false), "bitwiseOr(\"__acc\", \"l1\")", "bitwiseOr(\"__acc\", \"a1\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("l1", null, null))), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a2", (Set)ImmutableSet.of((Object)"l1"), "__acc", "0", "0", Boolean.valueOf(NullHandling.sqlCompatible()), Boolean.valueOf(false), Boolean.valueOf(false), "bitwiseXor(\"__acc\", \"l1\")", "bitwiseXor(\"__acc\", \"a2\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("l1", null, null)))})).setLimitSpec((LimitSpec)DefaultLimitSpec.builder().orderBy(new OrderByColumnSpec[]{new OrderByColumnSpec("a2", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)}).build()).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(this.useDefault ? ImmutableList.of((Object)new Object[]{"abc", 0L, 0L, 0L}, (Object)new Object[]{"a", 0L, 7L, 7L}, (Object)new Object[]{"", 0L, 325323L, 325323L}) : ImmutableList.of((Object)new Object[]{"abc", null, null, null}, (Object)new Object[]{"", 0L, 0L, 0L}, (Object)new Object[]{"a", 0L, 7L, 7L}, (Object)new Object[]{null, 0L, 325323L, 325323L})));
    }

    @Test
    public void testStringAgg() throws Exception {
        Object[] objectArray;
        this.cannotVectorize();
        ImmutableList immutableList = ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", null, null))).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"dim1"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_append(\"__acc\", \"dim1\")", "array_concat(\"__acc\", \"a0\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", null, null))), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"dim1"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim1\")", "array_set_add_all(\"__acc\", \"a1\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", null, null))), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a2", (Set)ImmutableSet.of((Object)"dim1"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim1\")", "array_set_add_all(\"__acc\", \"a2\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim1", null, null)), CalciteQueryTest.selector("dim1", "shazbot", null)}))})).context(QUERY_CONTEXT_DEFAULT).build());
        if (this.useDefault) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "10.1,2,1,def,abc";
            objectArray2[1] = "1,10.1,2,abc,def";
            objectArray = objectArray2;
            objectArray2[2] = "";
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = ",10.1,2,1,def,abc";
            objectArray3[1] = ",1,10.1,2,abc,def";
            objectArray = objectArray3;
            objectArray3[2] = null;
        }
        this.testQuery("SELECT STRING_AGG(dim1,','), STRING_AGG(DISTINCT dim1, ','), STRING_AGG(DISTINCT dim1,',') FILTER(WHERE dim1 = 'shazbot') FROM foo WHERE dim1 is not null", (List<Query>)immutableList, (List<Object[]>)ImmutableList.of((Object)objectArray));
    }

    @Test
    public void testStringAggMultiValue() throws Exception {
        Object[] objectArray;
        this.cannotVectorize();
        ImmutableList immutableList = ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"dim3"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_append(\"__acc\", \"dim3\")", "array_concat(\"__acc\", \"a0\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim3", null, null))), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"dim3"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim3\")", "array_set_add_all(\"__acc\", \"a1\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("dim3", null, null)))})).context(QUERY_CONTEXT_DEFAULT).build());
        if (this.useDefault) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "a,b,b,c,d";
            objectArray = objectArray2;
            objectArray2[1] = "a,b,c,d";
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = "a,b,b,c,d,";
            objectArray = objectArray3;
            objectArray3[1] = ",a,b,c,d";
        }
        this.testQuery("SELECT STRING_AGG(dim3, ','), STRING_AGG(DISTINCT dim3, ',') FROM foo", (List<Query>)immutableList, (List<Object[]>)ImmutableList.of((Object)objectArray));
    }

    @Test
    public void testStringAggNumeric() throws Exception {
        Object[] objectArray;
        this.cannotVectorize();
        ImmutableList immutableList = ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"l1"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_append(\"__acc\", \"l1\")", "array_concat(\"__acc\", \"a0\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("l1", null, null))), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"l1"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add(\"__acc\", \"l1\")", "array_set_add_all(\"__acc\", \"a1\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("l1", null, null))), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a2", (Set)ImmutableSet.of((Object)"d1"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_append(\"__acc\", \"d1\")", "array_concat(\"__acc\", \"a2\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("d1", null, null))), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a3", (Set)ImmutableSet.of((Object)"d1"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add(\"__acc\", \"d1\")", "array_set_add_all(\"__acc\", \"a3\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("d1", null, null))), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a4", (Set)ImmutableSet.of((Object)"f1"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_append(\"__acc\", \"f1\")", "array_concat(\"__acc\", \"a4\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("f1", null, null))), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a5", (Set)ImmutableSet.of((Object)"f1"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add(\"__acc\", \"f1\")", "array_set_add_all(\"__acc\", \"a5\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("f1", null, null)))})).context(QUERY_CONTEXT_DEFAULT).build());
        if (this.useDefault) {
            Object[] objectArray2 = new Object[6];
            objectArray2[0] = "7,325323,0,0,0,0";
            objectArray2[1] = "0,325323,7";
            objectArray2[2] = "1.0,1.7,0.0,0.0,0.0,0.0";
            objectArray2[3] = "0.0,1.0,1.7";
            objectArray2[4] = "1.0,0.10000000149011612,0.0,0.0,0.0,0.0";
            objectArray = objectArray2;
            objectArray2[5] = "0.0,0.10000000149011612,1.0";
        } else {
            Object[] objectArray3 = new Object[6];
            objectArray3[0] = "7,325323,0";
            objectArray3[1] = "0,325323,7";
            objectArray3[2] = "1.0,1.7,0.0";
            objectArray3[3] = "0.0,1.0,1.7";
            objectArray3[4] = "1.0,0.10000000149011612,0.0";
            objectArray = objectArray3;
            objectArray3[5] = "0.0,0.10000000149011612,1.0";
        }
        this.testQuery("SELECT STRING_AGG(l1, ','), STRING_AGG(DISTINCT l1, ','), STRING_AGG(d1, ','), STRING_AGG(DISTINCT d1, ','), STRING_AGG(f1, ','), STRING_AGG(DISTINCT f1, ',') FROM numfoo", (List<Query>)immutableList, (List<Object[]>)ImmutableList.of((Object)objectArray));
    }

    @Test
    public void testStringAggExpression() throws Exception {
        Object[] objectArray;
        this.cannotVectorize();
        ImmutableList immutableList = ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "concat(\"dim1\",\"dim2\")", ColumnType.STRING)}).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"v0"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add(\"__acc\", \"v0\")", "array_set_add_all(\"__acc\", \"a0\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("v0", null, null))), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"v0"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add(\"__acc\", \"v0\")", "array_set_add_all(\"__acc\", \"a1\")", null, "if(array_length(o) == 0, null, array_to_string(o, '||'))", ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("v0", null, null)))})).context(QUERY_CONTEXT_DEFAULT).build());
        if (this.useDefault) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "10.1,1a,2,a,abc,defabc";
            objectArray = objectArray2;
            objectArray2[1] = "10.1||1a||2||a||abc||defabc";
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = "1a,2,a,defabc";
            objectArray = objectArray3;
            objectArray3[1] = "1a||2||a||defabc";
        }
        this.testQuery("SELECT STRING_AGG(DISTINCT CONCAT(dim1, dim2), ','), STRING_AGG(DISTINCT CONCAT(dim1, dim2), CONCAT('|', '|')) FROM foo", (List<Query>)immutableList, (List<Object[]>)ImmutableList.of((Object)objectArray));
    }

    @Test(expected=RelOptPlanner.CannotPlanException.class)
    public void testStringAggExpressionNonConstantSeparator() throws Exception {
        this.testQuery("SELECT STRING_AGG(DISTINCT CONCAT(dim1, dim2), CONCAT('|', dim1)) FROM foo", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testStringAggMaxBytes() throws Exception {
        Object[] objectArray;
        this.cannotVectorize();
        ImmutableList immutableList = ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"l1"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_append(\"__acc\", \"l1\")", "array_concat(\"__acc\", \"a0\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", new HumanReadableBytes(128L), TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("l1", null, null))), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"l1"), "__acc", "[]", "[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add(\"__acc\", \"l1\")", "array_set_add_all(\"__acc\", \"a1\")", null, "if(array_length(o) == 0, null, array_to_string(o, ','))", new HumanReadableBytes(128L), TestExprMacroTable.INSTANCE), (DimFilter)CalciteQueryTest.not((DimFilter)CalciteQueryTest.selector("l1", null, null)))})).context(QUERY_CONTEXT_DEFAULT).build());
        if (this.useDefault) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "7,325323,0,0,0,0";
            objectArray = objectArray2;
            objectArray2[1] = "0,325323,7";
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = "7,325323,0";
            objectArray = objectArray3;
            objectArray3[1] = "0,325323,7";
        }
        this.testQuery("SELECT STRING_AGG(l1, ',', 128), STRING_AGG(DISTINCT l1, ',', 128) FROM numfoo", (List<Query>)immutableList, (List<Object[]>)ImmutableList.of((Object)objectArray));
    }

    @Test
    public void testHumanReadableFormatFunction() throws Exception {
        this.testQuery("SELECT m1, HUMAN_READABLE_BINARY_BYTE_FORMAT(45678),HUMAN_READABLE_BINARY_BYTE_FORMAT(m1*12345),HUMAN_READABLE_BINARY_BYTE_FORMAT(m1*12345, 0), HUMAN_READABLE_DECIMAL_BYTE_FORMAT(m1*12345), HUMAN_READABLE_DECIMAL_FORMAT(m1*12345), HUMAN_READABLE_BINARY_BYTE_FORMAT(l1),HUMAN_READABLE_DECIMAL_BYTE_FORMAT(l1), HUMAN_READABLE_DECIMAL_FORMAT(l1) FROM numfoo WHERE dim1 = '1' LIMIT 1", (List<Query>)ImmutableList.of((Object)CalciteQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "'44.61 KiB'", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "human_readable_binary_byte_format((\"m1\" * 12345))", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v2", "human_readable_binary_byte_format((\"m1\" * 12345),0)", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v3", "human_readable_decimal_byte_format((\"m1\" * 12345))", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v4", "human_readable_decimal_format((\"m1\" * 12345))", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v5", "human_readable_binary_byte_format(\"l1\")", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v6", "human_readable_decimal_byte_format(\"l1\")", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v7", "human_readable_decimal_format(\"l1\")", ColumnType.STRING)}).columns(new String[]{"m1", "v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7"}).filters((DimFilter)CalciteQueryTest.selector("dim1", "1", null)).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(1L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(4.0f), "44.61 KiB", "48.22 KiB", "48 KiB", "49.38 KB", "49.38 K", NullHandling.replaceWithDefault() ? "0 B" : null, NullHandling.replaceWithDefault() ? "0 B" : null, NullHandling.replaceWithDefault() ? "0" : null}));
    }

    @Test
    public void testHumanReadableFormatFunctionExceptionWithWrongNumberType() throws Exception {
        this.expectedException.expect(SqlPlanningException.class);
        this.expectedException.expectMessage("Supported form(s): HUMAN_READABLE_BINARY_BYTE_FORMAT(Number, [Precision])");
        this.testQuery("SELECT HUMAN_READABLE_BINARY_BYTE_FORMAT('45678')", Collections.emptyList(), Collections.emptyList());
    }

    @Test
    public void testHumanReadableFormatFunctionWithWrongPrecisionType() throws Exception {
        this.expectedException.expect(SqlPlanningException.class);
        this.expectedException.expectMessage("Supported form(s): HUMAN_READABLE_BINARY_BYTE_FORMAT(Number, [Precision])");
        this.testQuery("SELECT HUMAN_READABLE_BINARY_BYTE_FORMAT(45678, '2')", Collections.emptyList(), Collections.emptyList());
    }

    @Test
    public void testHumanReadableFormatFunctionWithInvalidNumberOfArguments() throws Exception {
        this.expectedException.expect(SqlPlanningException.class);
        this.expectedException.expectMessage("Invalid number of arguments to function 'HUMAN_READABLE_BINARY_BYTE_FORMAT'. Was expecting 1 arguments");
        this.testQuery("SELECT HUMAN_READABLE_BINARY_BYTE_FORMAT(45678, 2, 1)", Collections.emptyList(), Collections.emptyList());
    }

    @Test
    public void testCommonVirtualExpressionWithDifferentValueType() throws Exception {
        this.testQuery("select\n dim1,\n sum(cast(0 as bigint)) as s1,\n sum(cast(0 as double)) as s2\nfrom druid.foo\nwhere dim1 = 'none'\ngroup by dim1\nlimit 1", (List<Query>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteQueryTest.selector("dim1", "none", null)).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteQueryTest.expressionVirtualColumn("v0", "'none'", ColumnType.STRING), CalciteQueryTest.expressionVirtualColumn("v1", "0", ColumnType.LONG), CalciteQueryTest.expressionVirtualColumn("v2", "0", ColumnType.DOUBLE)}).dimension((DimensionSpec)new DefaultDimensionSpec("v0", "d0")).aggregators(CalciteQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "v1", null, ExprMacroTable.nil()), new DoubleSumAggregatorFactory("a1", "v2", null, ExprMacroTable.nil())})).context(QUERY_CONTEXT_DEFAULT).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC)).threshold(1).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testReturnEmptyRowWhenGroupByIsConvertedToTimeseriesWithSingleConstantDimension() throws Exception {
        this.skipVectorize();
        this.testQuery("SELECT 'A' from foo WHERE m1 = 50 AND dim1 = 'wat' GROUP BY 'foobar'", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.selector("m1", "50", null), CalciteQueryTest.selector("dim1", "wat", null)})).granularity(Granularities.ALL).postAggregators(new PostAggregator[]{new ExpressionPostAggregator("p0", "'A'", null, ExprMacroTable.nil())}).context(QUERY_CONTEXT_DO_SKIP_EMPTY_BUCKETS).build()), (List<Object[]>)ImmutableList.of());
        this.testQuery("SELECT 'A' from foo WHERE dim1 = 'wat' GROUP BY dim1", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteQueryTest.querySegmentSpec(Intervals.ETERNITY)).setGranularity(Granularities.ALL).addDimension((DimensionSpec)new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING)).setDimFilter((DimFilter)CalciteQueryTest.selector("dim1", "wat", null)).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ExpressionPostAggregator("p0", "'A'", null, ExprMacroTable.nil()))).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testReturnEmptyRowWhenGroupByIsConvertedToTimeseriesWithMutlipleConstantDimensions() throws Exception {
        this.skipVectorize();
        this.testQuery("SELECT 'A', dim1 from foo WHERE m1 = 50 AND dim1 = 'wat' GROUP BY dim1", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.selector("m1", "50", null), CalciteQueryTest.selector("dim1", "wat", null)})).granularity(Granularities.ALL).postAggregators(new PostAggregator[]{new ExpressionPostAggregator("p0", "'A'", null, ExprMacroTable.nil()), new ExpressionPostAggregator("p1", "'wat'", null, ExprMacroTable.nil())}).context(QUERY_CONTEXT_DO_SKIP_EMPTY_BUCKETS).build()), (List<Object[]>)ImmutableList.of());
        this.testQuery("SELECT 'A', dim1 from foo WHERE m1 = 2.0 AND dim1 = '10.1' GROUP BY dim1", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteQueryTest.and(new DimFilter[]{CalciteQueryTest.selector("m1", "2.0", null), CalciteQueryTest.selector("dim1", "10.1", null)})).granularity(Granularities.ALL).postAggregators(new PostAggregator[]{new ExpressionPostAggregator("p0", "'A'", null, ExprMacroTable.nil()), new ExpressionPostAggregator("p1", "'10.1'", null, ExprMacroTable.nil())}).context(QUERY_CONTEXT_DO_SKIP_EMPTY_BUCKETS).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"A", "10.1"}));
    }

    @Test
    public void testSurfaceErrorsWhenInsertingThroughIncorrectSelectStatment() {
        this.assertQueryIsUnplannable("INSERT INTO druid.dst SELECT dim2, dim1, m1 FROM foo2 UNION SELECT dim1, dim2, m1 FROM foo PARTITIONED BY ALL TIME", "Possible error: SQL requires 'UNION' but only 'UNION ALL' is supported.");
    }

    @Test
    public void testPlanWithInFilterLessThanInSubQueryThreshold() throws Exception {
        String query = "SELECT l1 FROM numfoo WHERE l1 IN (4842, 4844, 4845, 14905, 4853, 29064)";
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_DEFAULT, DEFAULT_PARAMETERS, query, CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource("numfoo").columns(new String[]{"l1"}).intervals(CalciteQueryTest.querySegmentSpec(Filtration.eternity())).context(QUERY_CONTEXT_DEFAULT).legacy(Boolean.valueOf(false)).filters((DimFilter)CalciteQueryTest.in("l1", (List<String>)ImmutableList.of((Object)"4842", (Object)"4844", (Object)"4845", (Object)"14905", (Object)"4853", (Object)"29064"), null)).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (sql, result) -> {}, null);
    }
}

