/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.avatica.SqlType;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.having.HavingSpec;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.SqlPlanningException;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.http.SqlParameter;
import org.junit.Test;

public class CalciteParameterQueryTest
extends BaseCalciteQueryTest {
    @Test
    public void testSelectConstantParamGetsConstant() throws Exception {
        this.testQuery("SELECT 1 + ?", (List<Query>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{2L}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.LONG).build())).intervals(CalciteParameterQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2}), (List<SqlParameter>)ImmutableList.of((Object)new SqlParameter(SqlType.INTEGER, (Object)1)));
    }

    @Test
    public void testParamsGetOptimizedIntoConstant() throws Exception {
        this.testQuery("SELECT 1 + ?, dim1 FROM foo LIMIT ?", (List<Query>)ImmutableList.of((Object)CalciteParameterQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteParameterQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteParameterQueryTest.expressionVirtualColumn("v0", "2", ColumnType.LONG)}).columns(new String[]{"dim1", "v0"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(1L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2, ""}), (List<SqlParameter>)ImmutableList.of((Object)new SqlParameter(SqlType.INTEGER, (Object)1), (Object)new SqlParameter(SqlType.INTEGER, (Object)1)));
    }

    @Test
    public void testParametersInSelectAndFilter() throws Exception {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_DEFAULT, (List<SqlParameter>)ImmutableList.of((Object)new SqlParameter(SqlType.INTEGER, (Object)10), (Object)new SqlParameter(SqlType.INTEGER, (Object)0)), "SELECT exp(count(*)) + ?, sum(m2) FROM druid.foo WHERE  dim2 = ?", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteParameterQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteParameterQueryTest.numericSelector("dim2", "0", null)).granularity(Granularities.ALL).aggregators(CalciteParameterQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0"), new DoubleSumAggregatorFactory("a1", "m2")})).postAggregators(new PostAggregator[]{CalciteParameterQueryTest.expressionPostAgg("p0", "(exp(\"a0\") + 10)")}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{11.0, NullHandling.defaultDoubleValue()}));
    }

    @Test
    public void testSelectTrimFamilyWithParameters() throws Exception {
        this.testQuery("SELECT\nTRIM(BOTH ? FROM ?),\nTRIM(TRAILING ? FROM ?),\nTRIM(? FROM ?),\nTRIM(TRAILING FROM ?),\nTRIM(?),\nBTRIM(?),\nBTRIM(?, ?),\nLTRIM(?),\nLTRIM(?, ?),\nRTRIM(?),\nRTRIM(?, ?),\nCOUNT(*)\nFROM foo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteParameterQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteParameterQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).postAggregators(new PostAggregator[]{CalciteParameterQueryTest.expressionPostAgg("p0", "'foo'"), CalciteParameterQueryTest.expressionPostAgg("p1", "'xfoo'"), CalciteParameterQueryTest.expressionPostAgg("p2", "'foo'"), CalciteParameterQueryTest.expressionPostAgg("p3", "' foo'"), CalciteParameterQueryTest.expressionPostAgg("p4", "'foo'"), CalciteParameterQueryTest.expressionPostAgg("p5", "'foo'"), CalciteParameterQueryTest.expressionPostAgg("p6", "'foo'"), CalciteParameterQueryTest.expressionPostAgg("p7", "'foo '"), CalciteParameterQueryTest.expressionPostAgg("p8", "'foox'"), CalciteParameterQueryTest.expressionPostAgg("p9", "' foo'"), CalciteParameterQueryTest.expressionPostAgg("p10", "'xfoo'")}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"foo", "xfoo", "foo", " foo", "foo", "foo", "foo", "foo ", "foox", " foo", "xfoo", 6L}), (List<SqlParameter>)ImmutableList.of((Object)new SqlParameter(SqlType.VARCHAR, (Object)"x"), (Object)new SqlParameter(SqlType.VARCHAR, (Object)"xfoox"), (Object)new SqlParameter(SqlType.VARCHAR, (Object)"x"), (Object)new SqlParameter(SqlType.VARCHAR, (Object)"xfoox"), (Object)new SqlParameter(SqlType.VARCHAR, (Object)" "), (Object)new SqlParameter(SqlType.VARCHAR, (Object)" foo "), (Object)new SqlParameter(SqlType.VARCHAR, (Object)" foo "), (Object)new SqlParameter(SqlType.VARCHAR, (Object)" foo "), (Object)new SqlParameter(SqlType.VARCHAR, (Object)" foo "), (Object)new SqlParameter(SqlType.VARCHAR, (Object)"xfoox"), (Object)new SqlParameter(SqlType.VARCHAR, (Object)"x"), (Object)new SqlParameter(SqlType.VARCHAR, (Object)" foo "), (Object[])new SqlParameter[]{new SqlParameter(SqlType.VARCHAR, (Object)"xfoox"), new SqlParameter(SqlType.VARCHAR, (Object)"x"), new SqlParameter(SqlType.VARCHAR, (Object)" foo "), new SqlParameter(SqlType.VARCHAR, (Object)"xfoox"), new SqlParameter(SqlType.VARCHAR, (Object)"x")}));
    }

    @Test
    public void testParamsInInformationSchema() throws Exception {
        this.testQuery("SELECT\n  COUNT(JDBC_TYPE),\n  SUM(JDBC_TYPE),\n  AVG(JDBC_TYPE),\n  MIN(JDBC_TYPE),\n  MAX(JDBC_TYPE)\nFROM INFORMATION_SCHEMA.COLUMNS\nWHERE TABLE_SCHEMA = ? AND TABLE_NAME = ?", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{8L, 1249L, 156L, -5L, 1111L}), (List<SqlParameter>)ImmutableList.of((Object)new SqlParameter(SqlType.VARCHAR, (Object)"druid"), (Object)new SqlParameter(SqlType.VARCHAR, (Object)"foo")));
    }

    @Test
    public void testParamsInSelectExpressionAndLimit() throws Exception {
        this.testQuery("SELECT SUBSTRING(dim2, ?, ?) FROM druid.foo LIMIT ?", (List<Query>)ImmutableList.of((Object)CalciteParameterQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteParameterQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteParameterQueryTest.expressionVirtualColumn("v0", "substring(\"dim2\", 0, 1)", ColumnType.STRING)}).columns(new String[]{"v0"}).limit(2L).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{NULL_STRING}), (List<SqlParameter>)ImmutableList.of((Object)new SqlParameter(SqlType.INTEGER, (Object)1), (Object)new SqlParameter(SqlType.INTEGER, (Object)1), (Object)new SqlParameter(SqlType.INTEGER, (Object)2)));
    }

    @Test
    public void testParamsTuckedInACast() throws Exception {
        this.testQuery("SELECT dim1, m1, COUNT(*) FROM druid.foo WHERE m1 - CAST(? as INT) = dim1 GROUP BY dim1, m1", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteParameterQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteParameterQueryTest.expressionFilter("((\"m1\" - 1) == CAST(\"dim1\", 'DOUBLE'))")).setDimensions(CalciteParameterQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("m1", "d1", ColumnType.FLOAT)})).setAggregatorSpecs(CalciteParameterQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"", Float.valueOf(1.0f), 1L}, (Object)new Object[]{"2", Float.valueOf(3.0f), 1L}) : ImmutableList.of((Object)new Object[]{"2", Float.valueOf(3.0f), 1L})), (List<SqlParameter>)ImmutableList.of((Object)new SqlParameter(SqlType.INTEGER, (Object)1)));
    }

    @Test
    public void testParametersInStrangePlaces() throws Exception {
        this.testQuery("SELECT\n  dim1,\n  COUNT(*) FILTER(WHERE dim2 <> ?)/COUNT(*) as ratio\nFROM druid.foo\nGROUP BY dim1\nHAVING COUNT(*) FILTER(WHERE dim2 <> ?)/COUNT(*) = ?", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteParameterQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteParameterQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setAggregatorSpecs(CalciteParameterQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteParameterQueryTest.not((DimFilter)CalciteParameterQueryTest.selector("dim2", "a", null))), new CountAggregatorFactory("a1")})).setPostAggregatorSpecs((List)ImmutableList.of((Object)CalciteParameterQueryTest.expressionPostAgg("p0", "(\"a0\" / \"a1\")"))).setHavingSpec((HavingSpec)CalciteParameterQueryTest.having((DimFilter)CalciteParameterQueryTest.expressionFilter("((\"a0\" / \"a1\") == 1)"))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", 1L}, (Object)new Object[]{"2", 1L}, (Object)new Object[]{"abc", 1L}, (Object)new Object[]{"def", 1L}), (List<SqlParameter>)ImmutableList.of((Object)new SqlParameter(SqlType.VARCHAR, (Object)"a"), (Object)new SqlParameter(SqlType.VARCHAR, (Object)"a"), (Object)new SqlParameter(SqlType.INTEGER, (Object)1)));
    }

    @Test
    public void testParametersInCases() throws Exception {
        this.testQuery("SELECT\n  CASE 'foo'\n  WHEN ? THEN SUM(cnt) / CAST(? as INT)\n  WHEN ? THEN SUM(m1) / CAST(? as INT)\n  WHEN ? THEN SUM(m2) / CAST(? as INT)\n  END\nFROM foo", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteParameterQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteParameterQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1")})).postAggregators((List)ImmutableList.of((Object)CalciteParameterQueryTest.expressionPostAgg("p0", "(\"a0\" / 10)"))).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2.1}), (List<SqlParameter>)ImmutableList.of((Object)new SqlParameter(SqlType.VARCHAR, (Object)"bar"), (Object)new SqlParameter(SqlType.INTEGER, (Object)10), (Object)new SqlParameter(SqlType.VARCHAR, (Object)"foo"), (Object)new SqlParameter(SqlType.INTEGER, (Object)10), (Object)new SqlParameter(SqlType.VARCHAR, (Object)"baz"), (Object)new SqlParameter(SqlType.INTEGER, (Object)10)));
    }

    @Test
    public void testTimestamp() throws Exception {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_DEFAULT, (List<SqlParameter>)ImmutableList.of((Object)new SqlParameter(SqlType.INTEGER, (Object)10), (Object)new SqlParameter(SqlType.TIMESTAMP, (Object)DateTimes.of((String)"2999-01-01T00:00:00Z").getMillis())), "SELECT exp(count(*)) + ?, sum(m2)  FROM druid.foo WHERE  __time >= ?", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteParameterQueryTest.querySegmentSpec(Intervals.of((String)"2999-01-01T00:00:00.000Z/146140482-04-24T15:36:27.903Z"))).granularity(Granularities.ALL).aggregators(CalciteParameterQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0"), new DoubleSumAggregatorFactory("a1", "m2")})).postAggregators(new PostAggregator[]{CalciteParameterQueryTest.expressionPostAgg("p0", "(exp(\"a0\") + 10)")}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{11.0, NullHandling.defaultDoubleValue()}));
    }

    @Test
    public void testTimestampString() throws Exception {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_DEFAULT, (List<SqlParameter>)ImmutableList.of((Object)new SqlParameter(SqlType.INTEGER, (Object)10), (Object)new SqlParameter(SqlType.TIMESTAMP, (Object)"2999-01-01 00:00:00")), "SELECT exp(count(*)) + ?, sum(m2)  FROM druid.foo WHERE  __time >= ?", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteParameterQueryTest.querySegmentSpec(Intervals.of((String)"2999-01-01T00:00:00.000Z/146140482-04-24T15:36:27.903Z"))).granularity(Granularities.ALL).aggregators(CalciteParameterQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0"), new DoubleSumAggregatorFactory("a1", "m2")})).postAggregators(new PostAggregator[]{CalciteParameterQueryTest.expressionPostAgg("p0", "(exp(\"a0\") + 10)")}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{11.0, NullHandling.defaultDoubleValue()}));
    }

    @Test
    public void testDate() throws Exception {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_DEFAULT, (List<SqlParameter>)ImmutableList.of((Object)new SqlParameter(SqlType.INTEGER, (Object)10), (Object)new SqlParameter(SqlType.DATE, (Object)"2999-01-01")), "SELECT exp(count(*)) + ?, sum(m2)  FROM druid.foo WHERE  __time >= ?", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteParameterQueryTest.querySegmentSpec(Intervals.of((String)"2999-01-01T00:00:00.000Z/146140482-04-24T15:36:27.903Z"))).granularity(Granularities.ALL).aggregators(CalciteParameterQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0"), new DoubleSumAggregatorFactory("a1", "m2")})).postAggregators(new PostAggregator[]{CalciteParameterQueryTest.expressionPostAgg("p0", "(exp(\"a0\") + 10)")}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{11.0, NullHandling.defaultDoubleValue()}));
    }

    @Test
    public void testDoubles() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE cnt > ? and cnt < ?", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteParameterQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteParameterQueryTest.bound("cnt", "1.1", "100000001", true, true, null, StringComparators.NUMERIC)).aggregators(CalciteParameterQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}), (List<SqlParameter>)ImmutableList.of((Object)new SqlParameter(SqlType.DOUBLE, (Object)1.1), (Object)new SqlParameter(SqlType.FLOAT, (Object)1.00000001E8)));
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE cnt = ? or cnt = ?", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteParameterQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteParameterQueryTest.in("cnt", (List<String>)ImmutableList.of((Object)"1.0", (Object)"100000001"), null)).aggregators(CalciteParameterQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}), (List<SqlParameter>)ImmutableList.of((Object)new SqlParameter(SqlType.DOUBLE, (Object)1.0), (Object)new SqlParameter(SqlType.FLOAT, (Object)1.00000001E8)));
    }

    @Test
    public void testFloats() throws Exception {
        this.testQuery("SELECT COUNT(*) FROM druid.foo WHERE cnt = ?", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteParameterQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteParameterQueryTest.selector("cnt", "1.0", null)).aggregators(CalciteParameterQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}), (List<SqlParameter>)ImmutableList.of((Object)new SqlParameter(SqlType.REAL, (Object)Float.valueOf(1.0f))));
    }

    @Test
    public void testLongs() throws Exception {
        this.testQuery("SELECT COUNT(*)\nFROM druid.numfoo\nWHERE l1 > ?", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteParameterQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteParameterQueryTest.bound("l1", "3", null, true, false, null, StringComparators.NUMERIC)).aggregators(CalciteParameterQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}), (List<SqlParameter>)ImmutableList.of((Object)new SqlParameter(SqlType.BIGINT, (Object)3L)));
    }

    @Test
    public void testMissingParameter() throws Exception {
        this.expectedException.expect(SqlPlanningException.class);
        this.expectedException.expectMessage("Parameter at position[0] is not bound");
        this.testQuery("SELECT COUNT(*)\nFROM druid.numfoo\nWHERE l1 > ?", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}), (List<SqlParameter>)ImmutableList.of());
    }

    @Test
    public void testPartiallyMissingParameter() throws Exception {
        this.expectedException.expect(SqlPlanningException.class);
        this.expectedException.expectMessage("Parameter at position[1] is not bound");
        this.testQuery("SELECT COUNT(*)\nFROM druid.numfoo\nWHERE l1 > ? AND f1 = ?", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}), (List<SqlParameter>)ImmutableList.of((Object)new SqlParameter(SqlType.BIGINT, (Object)3L)));
    }

    @Test
    public void testPartiallyMissingParameterInTheMiddle() throws Exception {
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(null);
        params.add(new SqlParameter(SqlType.INTEGER, (Object)1));
        this.expectedException.expect(SqlPlanningException.class);
        this.expectedException.expectMessage("Parameter at position[0] is not bound");
        this.testQuery("SELECT 1 + ?, dim1 FROM foo LIMIT ?", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of(), params);
    }

    @Test
    public void testWrongTypeParameter() throws Exception {
        if (!this.useDefault) {
            this.cannotVectorize();
        }
        this.testQuery("SELECT COUNT(*)\nFROM druid.numfoo\nWHERE l1 > ? AND f1 = ?", (List<Query>)(this.useDefault ? ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteParameterQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteParameterQueryTest.and(new DimFilter[]{CalciteParameterQueryTest.bound("l1", "3", null, true, false, null, StringComparators.NUMERIC), CalciteParameterQueryTest.selector("f1", this.useDefault ? "0.0" : null, null)})).aggregators(CalciteParameterQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()) : ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of(), (RowSignature)RowSignature.builder().add("f1", ColumnType.FLOAT).add("l1", ColumnType.LONG).build())).intervals(CalciteParameterQueryTest.querySegmentSpec(Filtration.eternity())).aggregators(CalciteParameterQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build())), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}), (List<SqlParameter>)ImmutableList.of((Object)new SqlParameter(SqlType.BIGINT, (Object)3L), (Object)new SqlParameter(SqlType.VARCHAR, (Object)"wat")));
    }

    @Test
    public void testNullParameter() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT COALESCE(dim2, ?, ?), COUNT(*) FROM druid.foo GROUP BY 1\n", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteParameterQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteParameterQueryTest.expressionVirtualColumn("v0", "case_searched(notnull(\"dim2\"),\"dim2\",'parameter')", ColumnType.STRING)}).setDimensions(CalciteParameterQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteParameterQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"a", 2L}, (Object)new Object[]{"abc", 1L}, (Object)new Object[]{"parameter", 3L}) : ImmutableList.of((Object)new Object[]{"", 1L}, (Object)new Object[]{"a", 2L}, (Object)new Object[]{"abc", 1L}, (Object)new Object[]{"parameter", 2L})), (List<SqlParameter>)ImmutableList.of((Object)new SqlParameter(SqlType.VARCHAR, (Object)"parameter"), (Object)new SqlParameter(SqlType.VARCHAR, null)));
        this.testQuery("SELECT COALESCE(dim2, ?, ?), COUNT(*) FROM druid.foo GROUP BY 1\n", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteParameterQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteParameterQueryTest.expressionVirtualColumn("v0", "case_searched(notnull(\"dim2\"),\"dim2\",'parameter')", ColumnType.STRING)}).setDimensions(CalciteParameterQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteParameterQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"a", 2L}, (Object)new Object[]{"abc", 1L}, (Object)new Object[]{"parameter", 3L}) : ImmutableList.of((Object)new Object[]{"", 1L}, (Object)new Object[]{"a", 2L}, (Object)new Object[]{"abc", 1L}, (Object)new Object[]{"parameter", 2L})), (List<SqlParameter>)ImmutableList.of((Object)new SqlParameter(SqlType.VARCHAR, null), (Object)new SqlParameter(SqlType.VARCHAR, (Object)"parameter")));
    }
}

