/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.math.expr.ExpressionProcessing;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.LikeDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.virtual.ListFilteredVirtualColumn;
import org.apache.druid.sql.SqlPlanningException;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.junit.Test;

public class CalciteMultiValueStringQueryTest
extends BaseCalciteQueryTest {
    @Test
    public void testMultiValueStringWorksLikeStringGroupBy() throws Exception {
        this.cannotVectorize();
        HashMap<String, Object> groupByOnMultiValueColumnEnabled = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        groupByOnMultiValueColumnEnabled.put("groupByEnableMultiValueUnnesting", true);
        ImmutableList expected = NullHandling.replaceWithDefault() ? ImmutableList.of((Object)new Object[]{"bfoo", 2L}, (Object)new Object[]{"foo", 2L}, (Object)new Object[]{"", 1L}, (Object)new Object[]{"afoo", 1L}, (Object)new Object[]{"cfoo", 1L}, (Object)new Object[]{"dfoo", 1L}) : ImmutableList.of((Object)new Object[]{null, 2L}, (Object)new Object[]{"bfoo", 2L}, (Object)new Object[]{"afoo", 1L}, (Object)new Object[]{"cfoo", 1L}, (Object)new Object[]{"dfoo", 1L}, (Object)new Object[]{"foo", 1L});
        this.testQuery("SELECT concat(dim3, 'foo'), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", groupByOnMultiValueColumnEnabled, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "concat(\"dim3\",'foo')", ColumnType.STRING)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expected);
    }

    @Test
    public void testMultiValueStringGroupByDoesNotWork() throws Exception {
        this.cannotVectorize();
        HashMap<String, Object> groupByOnMultiValueColumnDisabled = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        groupByOnMultiValueColumnDisabled.put("groupByEnableMultiValueUnnesting", false);
        this.testQueryThrows("SELECT concat(dim3, 'foo'), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", groupByOnMultiValueColumnDisabled, (List<Query>)ImmutableList.of(), exception -> {
            exception.expect(RuntimeException.class);
            this.expectedException.expectMessage(StringUtils.format((String)"Encountered multi-value dimension [%s] that cannot be processed with '%s' set to false. Consider setting '%s' to true in your query context.", (Object[])new Object[]{"v0", "groupByEnableMultiValueUnnesting", "groupByEnableMultiValueUnnesting"}));
        });
    }

    @Test
    public void testMultiValueStringWorksLikeStringGroupByWithFilter() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT concat(dim3, 'foo'), SUM(cnt) FROM druid.numfoo where concat(dim3, 'foo') = 'bfoo' GROUP BY 1 ORDER BY 2 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "concat(\"dim3\",'foo')", ColumnType.STRING)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING)})).setDimFilter((DimFilter)CalciteMultiValueStringQueryTest.selector("v0", "bfoo", null)).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"bfoo", 2L}, (Object)new Object[]{"afoo", 1L}, (Object)new Object[]{"cfoo", 1L}));
    }

    @Test
    public void testMultiValueStringWorksLikeStringScan() throws Exception {
        String nullVal = NullHandling.replaceWithDefault() ? "[\"foo\"]" : "[null]";
        this.testQuery("SELECT concat(dim3, 'foo') FROM druid.numfoo", (List<Query>)ImmutableList.of((Object)new Druids.ScanQueryBuilder().dataSource("numfoo").eternityInterval().virtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "concat(\"dim3\",'foo')", ColumnType.STRING)}).columns((List)ImmutableList.of((Object)"v0")).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"afoo\",\"bfoo\"]"}, (Object)new Object[]{"[\"bfoo\",\"cfoo\"]"}, (Object)new Object[]{"[\"dfoo\"]"}, (Object)new Object[]{"[\"foo\"]"}, (Object)new Object[]{nullVal}, (Object)new Object[]{nullVal}));
    }

    @Test
    public void testMultiValueStringWorksLikeStringSelfConcatScan() throws Exception {
        String nullVal = NullHandling.replaceWithDefault() ? "[\"-lol-\"]" : "[null]";
        this.testQuery("SELECT concat(dim3, '-lol-', dim3) FROM druid.numfoo", (List<Query>)ImmutableList.of((Object)new Druids.ScanQueryBuilder().dataSource("numfoo").eternityInterval().virtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "concat(\"dim3\",'-lol-',\"dim3\")", ColumnType.STRING)}).columns((List)ImmutableList.of((Object)"v0")).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a-lol-a\",\"b-lol-b\"]"}, (Object)new Object[]{"[\"b-lol-b\",\"c-lol-c\"]"}, (Object)new Object[]{"[\"d-lol-d\"]"}, (Object)new Object[]{"[\"-lol-\"]"}, (Object)new Object[]{nullVal}, (Object)new Object[]{nullVal}));
    }

    @Test
    public void testMultiValueStringWorksLikeStringScanWithFilter() throws Exception {
        this.testQuery("SELECT concat(dim3, 'foo') FROM druid.numfoo where concat(dim3, 'foo') = 'bfoo'", (List<Query>)ImmutableList.of((Object)new Druids.ScanQueryBuilder().dataSource("numfoo").eternityInterval().virtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "concat(\"dim3\",'foo')", ColumnType.STRING)}).filters((DimFilter)CalciteMultiValueStringQueryTest.selector("v0", "bfoo", null)).columns((List)ImmutableList.of((Object)"v0")).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"afoo\",\"bfoo\"]"}, (Object)new Object[]{"[\"bfoo\",\"cfoo\"]"}));
    }

    @Test
    public void testMultiValueStringOverlapFilter() throws Exception {
        this.testQuery("SELECT dim3 FROM druid.numfoo WHERE MV_OVERLAP(dim3, ARRAY['a','b']) LIMIT 5", (List<Query>)ImmutableList.of((Object)CalciteMultiValueStringQueryTest.newScanQueryBuilder().dataSource("numfoo").eternityInterval().filters((DimFilter)new InDimFilter("dim3", (Collection)ImmutableList.of((Object)"a", (Object)"b"), null)).columns(new String[]{"dim3"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}, (Object)new Object[]{"[\"b\",\"c\"]"}));
    }

    @Test
    public void testMultiValueStringOverlapFilterNonLiteral() throws Exception {
        this.testQuery("SELECT dim3 FROM druid.numfoo WHERE MV_OVERLAP(dim3, ARRAY[dim2]) LIMIT 5", (List<Query>)ImmutableList.of((Object)CalciteMultiValueStringQueryTest.newScanQueryBuilder().dataSource("numfoo").eternityInterval().filters((DimFilter)CalciteMultiValueStringQueryTest.expressionFilter("array_overlap(\"dim3\",array(\"dim2\"))")).columns(new String[]{"dim3"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}));
    }

    @Test
    public void testMultiValueStringContainsFilter() throws Exception {
        this.testQuery("SELECT dim3 FROM druid.numfoo WHERE MV_CONTAINS(dim3, ARRAY['a','b']) LIMIT 5", (List<Query>)ImmutableList.of((Object)CalciteMultiValueStringQueryTest.newScanQueryBuilder().dataSource("numfoo").eternityInterval().filters((DimFilter)new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim3", "a", null), new SelectorDimFilter("dim3", "b", null)})).columns(new String[]{"dim3"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}));
    }

    @Test
    public void testMultiValueStringContainsArrayOfOneElement() throws Exception {
        this.testQuery("SELECT dim3 FROM druid.numfoo WHERE MV_CONTAINS(dim3, ARRAY['a']) LIMIT 5", (List<Query>)ImmutableList.of((Object)CalciteMultiValueStringQueryTest.newScanQueryBuilder().dataSource("numfoo").eternityInterval().filters((DimFilter)new SelectorDimFilter("dim3", "a", null)).columns(new String[]{"dim3"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}));
    }

    @Test
    public void testMultiValueStringContainsArrayOfNonLiteral() throws Exception {
        this.testQuery("SELECT dim3 FROM druid.numfoo WHERE MV_CONTAINS(dim3, ARRAY[dim2]) LIMIT 5", (List<Query>)ImmutableList.of((Object)CalciteMultiValueStringQueryTest.newScanQueryBuilder().dataSource("numfoo").eternityInterval().filters((DimFilter)CalciteMultiValueStringQueryTest.expressionFilter("array_contains(\"dim3\",array(\"dim2\"))")).columns(new String[]{"dim3"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}));
    }

    @Test
    public void testMultiValueStringSlice() throws Exception {
        this.testQuery("SELECT MV_SLICE(dim3, 1) FROM druid.numfoo", (List<Query>)ImmutableList.of((Object)new Druids.ScanQueryBuilder().dataSource("numfoo").eternityInterval().virtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_slice(\"dim3\",1)", ColumnType.STRING)}).columns((List)ImmutableList.of((Object)"v0")).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"b\"]"}, (Object)new Object[]{"[\"c\"]"}, (Object)new Object[]{"[]"}, (Object)new Object[]{this.useDefault ? NULL_STRING : "[]"}, (Object)new Object[]{NULL_STRING}, (Object)new Object[]{NULL_STRING}));
    }

    @Test
    public void testMultiValueStringLength() throws Exception {
        Object[] objectArray;
        Object[] objectArray2;
        this.cannotVectorize();
        ImmutableList immutableList = ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_length(\"dim3\")", ColumnType.LONG)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "_d0", ColumnType.STRING), new DefaultDimensionSpec("v0", "_d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("_d1", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build());
        Object[] objectArray3 = new Object[]{"", 2, 1L};
        Object[] objectArray4 = new Object[]{"10.1", 2, 1L};
        if (this.useDefault) {
            Object[] objectArray5 = new Object[3];
            objectArray5[0] = "2";
            objectArray5[1] = 1;
            objectArray2 = objectArray5;
            objectArray5[2] = 1L;
        } else {
            Object[] objectArray6 = new Object[3];
            objectArray6[0] = "1";
            objectArray6[1] = 1;
            objectArray2 = objectArray6;
            objectArray6[2] = 1L;
        }
        if (this.useDefault) {
            Object[] objectArray7 = new Object[3];
            objectArray7[0] = "1";
            objectArray7[1] = 0;
            objectArray = objectArray7;
            objectArray7[2] = 1L;
        } else {
            Object[] objectArray8 = new Object[3];
            objectArray8[0] = "2";
            objectArray8[1] = 1;
            objectArray = objectArray8;
            objectArray8[2] = 1L;
        }
        this.testQuery("SELECT dim1, MV_LENGTH(dim3), SUM(cnt) FROM druid.numfoo GROUP BY 1, 2 ORDER BY 2 DESC", (List<Query>)immutableList, (List<Object[]>)ImmutableList.of((Object)objectArray3, (Object)objectArray4, (Object)objectArray2, (Object)objectArray, (Object)new Object[]{"abc", this.useDefault ? Integer.valueOf(0) : null, 1L}, (Object)new Object[]{"def", this.useDefault ? Integer.valueOf(0) : null, 1L}));
    }

    @Test
    public void testMultiValueStringAppend() throws Exception {
        this.cannotVectorize();
        ImmutableList results = this.useDefault ? ImmutableList.of((Object)new Object[]{"", 3L}, (Object)new Object[]{"foo", 3L}, (Object)new Object[]{"b", 2L}, (Object)new Object[]{"a", 1L}, (Object)new Object[]{"c", 1L}, (Object)new Object[]{"d", 1L}) : ImmutableList.of((Object)new Object[]{"foo", 4L}, (Object)new Object[]{null, 2L}, (Object)new Object[]{"b", 2L}, (Object)new Object[]{"", 1L}, (Object)new Object[]{"a", 1L}, (Object)new Object[]{"c", 1L}, (Object)new Object[]{"d", 1L});
        this.testQuery("SELECT MV_APPEND(dim3, 'foo'), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_append(\"dim3\",'foo')", ColumnType.STRING)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)results);
    }

    @Test
    public void testMultiValueStringPrepend() throws Exception {
        this.cannotVectorize();
        ImmutableList results = this.useDefault ? ImmutableList.of((Object)new Object[]{"", 3L}, (Object)new Object[]{"foo", 3L}, (Object)new Object[]{"b", 2L}, (Object)new Object[]{"a", 1L}, (Object)new Object[]{"c", 1L}, (Object)new Object[]{"d", 1L}) : ImmutableList.of((Object)new Object[]{"foo", 4L}, (Object)new Object[]{null, 2L}, (Object)new Object[]{"b", 2L}, (Object)new Object[]{"", 1L}, (Object)new Object[]{"a", 1L}, (Object)new Object[]{"c", 1L}, (Object)new Object[]{"d", 1L});
        this.testQuery("SELECT MV_PREPEND('foo', dim3), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_prepend('foo',\"dim3\")", ColumnType.STRING)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)results);
    }

    @Test
    public void testMultiValueStringPrependAppend() throws Exception {
        this.cannotVectorize();
        ImmutableList results = this.useDefault ? ImmutableList.of((Object)new Object[]{"", "", 3L}, (Object)new Object[]{"foo,a,b", "a,b,foo", 1L}, (Object)new Object[]{"foo,b,c", "b,c,foo", 1L}, (Object)new Object[]{"foo,d", "d,foo", 1L}) : ImmutableList.of((Object)new Object[]{null, null, 2L}, (Object)new Object[]{"foo,", ",foo", 1L}, (Object)new Object[]{"foo,a,b", "a,b,foo", 1L}, (Object)new Object[]{"foo,b,c", "b,c,foo", 1L}, (Object)new Object[]{"foo,d", "d,foo", 1L});
        this.testQuery("SELECT MV_TO_STRING(MV_PREPEND('foo', dim3), ','), MV_TO_STRING(MV_APPEND(dim3, 'foo'), ','), SUM(cnt) FROM druid.numfoo GROUP BY 1,2 ORDER BY 3 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_to_string(array_prepend('foo',\"dim3\"),',')", ColumnType.STRING), CalciteMultiValueStringQueryTest.expressionVirtualColumn("v1", "array_to_string(array_append(\"dim3\",'foo'),',')", ColumnType.STRING)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING), new DefaultDimensionSpec("v1", "_d1", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)results);
    }

    @Test
    public void testMultiValueStringConcat() throws Exception {
        this.cannotVectorize();
        ImmutableList results = this.useDefault ? ImmutableList.of((Object)new Object[]{"b", 4L}, (Object)new Object[]{"", 3L}, (Object)new Object[]{"a", 2L}, (Object)new Object[]{"c", 2L}, (Object)new Object[]{"d", 2L}) : ImmutableList.of((Object)new Object[]{"b", 4L}, (Object)new Object[]{null, 2L}, (Object)new Object[]{"", 2L}, (Object)new Object[]{"a", 2L}, (Object)new Object[]{"c", 2L}, (Object)new Object[]{"d", 2L});
        this.testQuery("SELECT MV_CONCAT(dim3, dim3), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_concat(\"dim3\",\"dim3\")", ColumnType.STRING)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)results);
    }

    @Test
    public void testMultiValueStringConcatBackwardsCompat0dot22andOlder() throws Exception {
        try {
            ExpressionProcessing.initializeForHomogenizeNullMultiValueStrings();
            this.cannotVectorize();
            ImmutableList results = this.useDefault ? ImmutableList.of((Object)new Object[]{"", 6L}, (Object)new Object[]{"b", 4L}, (Object)new Object[]{"a", 2L}, (Object)new Object[]{"c", 2L}, (Object)new Object[]{"d", 2L}) : ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{"b", 4L}, (Object)new Object[]{"", 2L}, (Object)new Object[]{"a", 2L}, (Object)new Object[]{"c", 2L}, (Object)new Object[]{"d", 2L});
            this.testQuery("SELECT MV_CONCAT(dim3, dim3), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_concat(\"dim3\",\"dim3\")", ColumnType.STRING)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)results);
        }
        finally {
            ExpressionProcessing.initializeForTests(null);
        }
    }

    @Test
    public void testMultiValueStringOffset() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT MV_OFFSET(dim3, 1), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_offset(\"dim3\",1)", ColumnType.STRING)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{NullHandling.defaultStringValue(), 4L}, (Object)new Object[]{"b", 1L}, (Object)new Object[]{"c", 1L}));
    }

    @Test
    public void testMultiValueStringOrdinal() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT MV_ORDINAL(dim3, 2), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_ordinal(\"dim3\",2)", ColumnType.STRING)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{NullHandling.defaultStringValue(), 4L}, (Object)new Object[]{"b", 1L}, (Object)new Object[]{"c", 1L}));
    }

    @Test
    public void testMultiValueStringOffsetOf() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT MV_OFFSET_OF(dim3, 'b'), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_offset_of(\"dim3\",'b')", ColumnType.LONG)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(this.useDefault ? ImmutableList.of((Object)new Object[]{0, 4L}, (Object)new Object[]{-1, 1L}, (Object)new Object[]{1, 1L}) : ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{0, 1L}, (Object)new Object[]{1, 1L})));
    }

    @Test
    public void testMultiValueStringOrdinalOf() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT MV_ORDINAL_OF(dim3, 'b'), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_ordinal_of(\"dim3\",'b')", ColumnType.LONG)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(this.useDefault ? ImmutableList.of((Object)new Object[]{0, 3L}, (Object)new Object[]{-1, 1L}, (Object)new Object[]{1, 1L}, (Object)new Object[]{2, 1L}) : ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{1, 1L}, (Object)new Object[]{2, 1L})));
    }

    @Test
    public void testMultiValueStringToString() throws Exception {
        this.cannotVectorize();
        ImmutableList results = this.useDefault ? ImmutableList.of((Object)new Object[]{"", 3L}, (Object)new Object[]{"a,b", 1L}, (Object)new Object[]{"b,c", 1L}, (Object)new Object[]{"d", 1L}) : ImmutableList.of((Object)new Object[]{null, 2L}, (Object)new Object[]{"", 1L}, (Object)new Object[]{"a,b", 1L}, (Object)new Object[]{"b,c", 1L}, (Object)new Object[]{"d", 1L});
        this.testQuery("SELECT MV_TO_STRING(dim3, ','), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_to_string(\"dim3\",',')", ColumnType.STRING)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)results);
    }

    @Test
    public void testMultiValueStringToStringToMultiValueString() throws Exception {
        this.cannotVectorize();
        ImmutableList results = this.useDefault ? ImmutableList.of((Object)new Object[]{"d", 4L}, (Object)new Object[]{"b", 2L}, (Object)new Object[]{"a", 1L}, (Object)new Object[]{"c", 1L}) : ImmutableList.of((Object)new Object[]{"d", 5L}, (Object)new Object[]{"b", 2L}, (Object)new Object[]{"", 1L}, (Object)new Object[]{"a", 1L}, (Object)new Object[]{"c", 1L});
        this.testQuery("SELECT STRING_TO_MV(CONCAT(MV_TO_STRING(dim3, ','), ',d'), ','), SUM(cnt) FROM druid.numfoo WHERE MV_LENGTH(dim3) > 0 GROUP BY 1 ORDER BY 2 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_length(\"dim3\")", ColumnType.LONG), CalciteMultiValueStringQueryTest.expressionVirtualColumn("v1", "string_to_array(concat(array_to_string(\"dim3\",','),',d'),',')", ColumnType.STRING)}).setDimFilter((DimFilter)CalciteMultiValueStringQueryTest.bound("v0", "0", null, true, false, null, StringComparators.NUMERIC)).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "_d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)results);
    }

    @Test
    public void testMultiValueListFilter() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT MV_FILTER_ONLY(dim3, ARRAY['b']), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new ListFilteredVirtualColumn("v0", (DimensionSpec)DefaultDimensionSpec.of((String)"dim3"), (Set)ImmutableSet.of((Object)"b"), Boolean.valueOf(true))}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{NullHandling.defaultStringValue(), 4L}, (Object)new Object[]{"b", 2L}));
    }

    @Test
    public void testMultiValueListFilterDeny() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT MV_FILTER_NONE(dim3, ARRAY['b']), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new ListFilteredVirtualColumn("v0", (DimensionSpec)DefaultDimensionSpec.of((String)"dim3"), (Set)ImmutableSet.of((Object)"b"), Boolean.valueOf(false))}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(this.useDefault ? ImmutableList.of((Object)new Object[]{NullHandling.defaultStringValue(), 3L}, (Object)new Object[]{"a", 1L}, (Object)new Object[]{"c", 1L}, (Object)new Object[]{"d", 1L}) : ImmutableList.of((Object)new Object[]{NullHandling.defaultStringValue(), 2L}, (Object)new Object[]{"", 1L}, (Object)new Object[]{"a", 1L}, (Object)new Object[]{"c", 1L}, (Object)new Object[]{"d", 1L})));
    }

    @Test
    public void testMultiValueListFilterComposed() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT MV_LENGTH(MV_FILTER_ONLY(dim3, ARRAY['b'])), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_length(\"v1\")", ColumnType.LONG), new ListFilteredVirtualColumn("v1", (DimensionSpec)DefaultDimensionSpec.of((String)"dim3"), (Set)ImmutableSet.of((Object)"b"), Boolean.valueOf(true))}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(this.useDefault ? ImmutableList.of((Object)new Object[]{0, 4L}, (Object)new Object[]{1, 2L}) : ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{1, 2L})));
    }

    @Test
    public void testMultiValueListFilterComposedDeny() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT MV_LENGTH(MV_FILTER_NONE(dim3, ARRAY['b'])), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "array_length(\"v1\")", ColumnType.LONG), new ListFilteredVirtualColumn("v1", (DimensionSpec)DefaultDimensionSpec.of((String)"dim3"), (Set)ImmutableSet.of((Object)"b"), Boolean.valueOf(false))}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(this.useDefault ? ImmutableList.of((Object)new Object[]{0, 3L}, (Object)new Object[]{1, 3L}) : ImmutableList.of((Object)new Object[]{1, 4L}, (Object)new Object[]{null, 2L})));
    }

    @Test
    public void testFilterOnMultiValueListFilterNoMatch() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT dim3, SUM(cnt) FROM druid.numfoo WHERE MV_FILTER_ONLY(dim3, ARRAY['b']) = 'a' GROUP BY 1 ORDER BY 2 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new ListFilteredVirtualColumn("v0", (DimensionSpec)DefaultDimensionSpec.of((String)"dim3"), (Set)ImmutableSet.of((Object)"b"), Boolean.valueOf(true))}).setDimFilter((DimFilter)CalciteMultiValueStringQueryTest.selector("v0", "a", null)).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim3", "_d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testFilterOnMultiValueListFilterMatch() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT dim3, SUM(cnt) FROM druid.numfoo WHERE MV_FILTER_ONLY(dim3, ARRAY['b']) = 'b' GROUP BY 1 ORDER BY 2 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new ListFilteredVirtualColumn("v0", (DimensionSpec)DefaultDimensionSpec.of((String)"dim3"), (Set)ImmutableSet.of((Object)"b"), Boolean.valueOf(true))}).setDimFilter((DimFilter)CalciteMultiValueStringQueryTest.selector("v0", "b", null)).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim3", "_d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"b", 2L}, (Object)new Object[]{"a", 1L}, (Object)new Object[]{"c", 1L}));
    }

    @Test
    public void testFilterOnMultiValueListFilterMatchLike() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT dim3, SUM(cnt) FROM druid.numfoo WHERE MV_FILTER_ONLY(dim3, ARRAY['b']) LIKE 'b%' GROUP BY 1 ORDER BY 2 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{new ListFilteredVirtualColumn("v0", (DimensionSpec)DefaultDimensionSpec.of((String)"dim3"), (Set)ImmutableSet.of((Object)"b"), Boolean.valueOf(true))}).setDimFilter((DimFilter)new LikeDimFilter("v0", "b%", null, null)).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim3", "_d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"b", 2L}, (Object)new Object[]{"a", 1L}, (Object)new Object[]{"c", 1L}));
    }

    @Test
    public void testMultiValueToArrayGroupAsArrayWithMultiValueDimension() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT MV_TO_ARRAY(dim3), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "mv_to_array(\"dim3\")", ColumnType.STRING_ARRAY)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING_ARRAY)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)(this.useDefault ? ImmutableList.of((Object)new Object[]{null, 3L}, (Object)new Object[]{ImmutableList.of((Object)"a", (Object)"b"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"b", (Object)"c"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"d"), 1L}) : ImmutableList.of((Object)new Object[]{null, 2L}, (Object)new Object[]{ImmutableList.of((Object)""), 1L}, (Object)new Object[]{ImmutableList.of((Object)"a", (Object)"b"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"b", (Object)"c"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"d"), 1L})));
    }

    @Test
    public void testMultiValueToArrayGroupAsArrayWithSingleValueDim() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT MV_TO_ARRAY(dim1), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "mv_to_array(\"dim1\")", ColumnType.STRING_ARRAY)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING_ARRAY)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)(this.useDefault ? ImmutableList.of((Object)new Object[]{null, 1L}, (Object)new Object[]{ImmutableList.of((Object)"1"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"10.1"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"2"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"abc"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"def"), 1L}) : ImmutableList.of((Object)new Object[]{ImmutableList.of((Object)""), 1L}, (Object)new Object[]{ImmutableList.of((Object)"1"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"10.1"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"2"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"abc"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"def"), 1L})));
    }

    @Test
    public void testMultiValueToArrayGroupAsArrayWithSingleValueDimIsNotConvertedToTopN() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT MV_TO_ARRAY(dim1), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC limit 10", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteMultiValueStringQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteMultiValueStringQueryTest.expressionVirtualColumn("v0", "mv_to_array(\"dim1\")", ColumnType.STRING_ARRAY)}).setDimensions(CalciteMultiValueStringQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING_ARRAY)})).setAggregatorSpecs(CalciteMultiValueStringQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(10))).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)(this.useDefault ? ImmutableList.of((Object)new Object[]{null, 1L}, (Object)new Object[]{ImmutableList.of((Object)"1"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"10.1"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"2"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"abc"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"def"), 1L}) : ImmutableList.of((Object)new Object[]{ImmutableList.of((Object)""), 1L}, (Object)new Object[]{ImmutableList.of((Object)"1"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"10.1"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"2"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"abc"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"def"), 1L})));
    }

    @Test
    public void testMultiValueToArrayMoreArgs() throws Exception {
        this.testQueryThrows("SELECT MV_TO_ARRAY(dim3,dim3) FROM druid.numfoo", exception -> {
            exception.expect(SqlPlanningException.class);
            exception.expectMessage("Invalid number of arguments to function");
        });
    }

    @Test
    public void testMultiValueToArrayNoArgs() throws Exception {
        this.testQueryThrows("SELECT MV_TO_ARRAY() FROM druid.numfoo", exception -> {
            exception.expect(SqlPlanningException.class);
            exception.expectMessage("Invalid number of arguments to function");
        });
    }

    @Test
    public void testMultiValueToArrayArgsWithMultiValueDimFunc() throws Exception {
        this.testQueryThrows("SELECT MV_TO_ARRAY(concat(dim3,'c')) FROM druid.numfoo", exception -> exception.expect(RuntimeException.class));
    }

    @Test
    public void testMultiValueToArrayArgsWithSingleDimFunc() throws Exception {
        this.testQueryThrows("SELECT MV_TO_ARRAY(concat(dim1,'c')) FROM druid.numfoo", exception -> exception.expect(RuntimeException.class));
    }

    @Test
    public void testMultiValueToArrayArgsWithConstant() throws Exception {
        this.testQueryThrows("SELECT MV_TO_ARRAY(concat(dim1,'c')) FROM druid.numfoo", exception -> exception.expect(RuntimeException.class));
    }

    @Test
    public void testMultiValueToArrayArgsWithArray() throws Exception {
        this.testQueryThrows("SELECT MV_TO_ARRAY(Array[1,2]) FROM druid.numfoo", exception -> exception.expect(RuntimeException.class));
    }
}

