/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.GlobalTableDataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryException;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.FloatMinAggregatorFactory;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.query.aggregation.LongMinAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.any.StringAnyAggregatorFactory;
import org.apache.druid.query.aggregation.cardinality.CardinalityAggregatorFactory;
import org.apache.druid.query.aggregation.last.StringLastAggregatorFactory;
import org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.SubstringDimExtractionFn;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.LikeDimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.topn.DimensionTopNMetricSpec;
import org.apache.druid.query.topn.InvertedTopNMetricSpec;
import org.apache.druid.query.topn.NumericTopNMetricSpec;
import org.apache.druid.query.topn.TopNMetricSpec;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.virtual.ListFilteredVirtualColumn;
import org.apache.druid.server.QueryLifecycle;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.security.Access;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class CalciteJoinQueryTest
extends BaseCalciteQueryTest {
    @Test
    public void testInnerJoinWithLimitAndAlias() throws Exception {
        minTopNThreshold = 1;
        HashMap<String, Object> context = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        context.put("useApproximateTopN", false);
        this.testQuery("select t1.b1 from (select __time as b1 from numfoo group by 1 order by 1) as t1 inner join (\n  select __time as b2 from foo group by 1 order by 1\n) as t2 on t1.b1 = t2.b2 ", context, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).dataSource((DataSource)JoinDataSource.create((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDataSource((DataSource)new TableDataSource("numfoo")).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("__time", "_d0", ColumnType.LONG)}).setContext(context).build()), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDataSource((DataSource)new TableDataSource("foo")).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("__time", "d0", ColumnType.LONG)}).setContext(context).build()), (String)"j0.", (String)"(\"_d0\" == \"j0.d0\")", (JoinType)JoinType.INNER, null, (ExprMacroTable)ExprMacroTable.nil())).columns(new String[]{"_d0"}).context(context).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L}, (Object)new Object[]{946771200000L}, (Object)new Object[]{946857600000L}, (Object)new Object[]{978307200000L}, (Object)new Object[]{978393600000L}, (Object)new Object[]{978480000000L}));
    }

    @Test
    public void testExactTopNOnInnerJoinWithLimit() throws Exception {
        minTopNThreshold = 1;
        HashMap<String, Object> context = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        context.put("useApproximateTopN", false);
        this.testQuery("select f1.\"dim4\", sum(\"m1\") from numfoo f1 inner join (\n  select \"dim4\" from numfoo where dim4 <> 'a' group by 1\n) f2 on f1.\"dim4\" = f2.\"dim4\" group by 1 limit 1", context, (List<Query>)ImmutableList.of((Object)new TopNQueryBuilder().intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim4", "_d0")).aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1")}).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC)).threshold(1).dataSource((DataSource)JoinDataSource.create((DataSource)new TableDataSource("numfoo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)new NotDimFilter((DimFilter)new SelectorDimFilter("dim4", "a", null))).setDataSource((DataSource)new TableDataSource("numfoo")).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim4", "_d0")}).setContext(context).build()), (String)"j0.", (String)"(\"dim4\" == \"j0._d0\")", (JoinType)JoinType.INNER, null, (ExprMacroTable)ExprMacroTable.nil())).context(context).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"b", 15.0}));
    }

    @Test
    public void testJoinOuterGroupByAndSubqueryHasLimit() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT dim2, AVG(m2) FROM (SELECT * FROM foo AS t1 INNER JOIN foo AS t2 ON t1.m1 = t2.m1 LIMIT 10) AS t3 GROUP BY dim2", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns((List)ImmutableList.of((Object)"m1")).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"m1"), DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"j0.m1")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).limit(10L).columns(new String[]{"dim2", "m2"}).context(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0", ColumnType.STRING)}).setGranularity(Granularities.ALL).setAggregatorSpecs(this.useDefault ? CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0:sum", "m2"), new CountAggregatorFactory("a0:count")}) : CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0:sum", "m2"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0:count"), (DimFilter)CalciteJoinQueryTest.not((DimFilter)CalciteJoinQueryTest.selector("m2", null, null)))})).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ArithmeticPostAggregator("a0", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "a0:sum"), (Object)new FieldAccessPostAggregator(null, "a0:count"))))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)new Object[]{null, 4.0}, (Object)new Object[]{"", 3.0}, (Object)new Object[]{"a", 2.5}, (Object)new Object[]{"abc", 5.0}) : ImmutableList.of((Object)new Object[]{"", 3.6666666666666665}, (Object)new Object[]{"a", 2.5}, (Object)new Object[]{"abc", 5.0})));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testJoinOuterGroupByAndSubqueryNoLimit(Map<String, Object> queryContext) throws Exception {
        if (!CalciteJoinQueryTest.isRewriteJoinToFilter(queryContext)) {
            this.cannotVectorize();
        }
        this.testQuery("SELECT dim2, AVG(m2) FROM (SELECT * FROM foo AS t1 INNER JOIN foo AS t2 ON t1.m1 = t2.m1) AS t3 GROUP BY dim2", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns((List)ImmutableList.of((Object)"m1")).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build().withOverriddenContext(queryContext)), "j0.", CalciteJoinQueryTest.equalsCondition(DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"m1"), DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"j0.m1")), JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0", ColumnType.STRING)}).setGranularity(Granularities.ALL).setAggregatorSpecs(this.useDefault ? CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0:sum", "m2"), new CountAggregatorFactory("a0:count")}) : CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0:sum", "m2"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0:count"), (DimFilter)CalciteJoinQueryTest.not((DimFilter)CalciteJoinQueryTest.selector("m2", null, null)))})).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ArithmeticPostAggregator("a0", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "a0:sum"), (Object)new FieldAccessPostAggregator(null, "a0:count"))))).setContext(QUERY_CONTEXT_DEFAULT).build().withOverriddenContext(queryContext)), (List<Object[]>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)new Object[]{null, 4.0}, (Object)new Object[]{"", 3.0}, (Object)new Object[]{"a", 2.5}, (Object)new Object[]{"abc", 5.0}) : ImmutableList.of((Object)new Object[]{"", 3.6666666666666665}, (Object)new Object[]{"a", 2.5}, (Object)new Object[]{"abc", 5.0})));
    }

    @Test
    public void testJoinWithLimitBeforeJoining() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT t1.dim2, AVG(t1.m2) FROM (SELECT * FROM foo LIMIT 10) AS t1 INNER JOIN foo AS t2 ON t1.m1 = t2.m1 GROUP BY t1.dim2", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim2", "m1", "m2"}).context(QUERY_CONTEXT_DEFAULT).limit(10L).build()), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns((List)ImmutableList.of((Object)"m1")).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"m1"), DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"j0.m1")), JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0", ColumnType.STRING)}).setGranularity(Granularities.ALL).setAggregatorSpecs(this.useDefault ? CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0:sum", "m2"), new CountAggregatorFactory("a0:count")}) : CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0:sum", "m2"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0:count"), (DimFilter)CalciteJoinQueryTest.not((DimFilter)CalciteJoinQueryTest.selector("m2", null, null)))})).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ArithmeticPostAggregator("a0", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "a0:sum"), (Object)new FieldAccessPostAggregator(null, "a0:count"))))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)new Object[]{null, 4.0}, (Object)new Object[]{"", 3.0}, (Object)new Object[]{"a", 2.5}, (Object)new Object[]{"abc", 5.0}) : ImmutableList.of((Object)new Object[]{"", 3.6666666666666665}, (Object)new Object[]{"a", 2.5}, (Object)new Object[]{"abc", 5.0})));
    }

    @Test
    public void testJoinOnTimeseriesWithFloorOnTime() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT CAST(__time AS BIGINT), m1, ANY_VALUE(dim3, 100) FROM foo WHERE (TIME_FLOOR(__time, 'PT1H'), m1) IN\n   (\n     SELECT TIME_FLOOR(__time, 'PT1H') AS t1, MIN(m1) AS t2 FROM foo WHERE dim3 = 'b'\n         AND __time BETWEEN '1994-04-29 00:00:00' AND '2020-01-11 00:00:00' GROUP BY 1\n    )\nGROUP BY 1, 2\n", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Intervals.of((String)"1994-04-29/2020-01-11T00:00:00.001Z"))).filters((DimFilter)CalciteJoinQueryTest.selector("dim3", "b", null)).granularity((Granularity)new PeriodGranularity(Period.hours((int)1), null, DateTimeZone.UTC)).aggregators(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new FloatMinAggregatorFactory("a0", "m1")})).context(CalciteJoinQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), "j0.", "((timestamp_floor(\"__time\",'PT1H',null,'UTC') == \"j0.d0\") && (\"m1\" == \"j0.a0\"))", JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("__time", "d0", ColumnType.LONG), new DefaultDimensionSpec("m1", "d1", ColumnType.FLOAT)}).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new StringAnyAggregatorFactory("a0", "dim3", Integer.valueOf(100))})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L, Float.valueOf(1.0f), "[a, b]"}, (Object)new Object[]{946771200000L, Float.valueOf(2.0f), "[b, c]"}));
    }

    @Test
    public void testJoinOnGroupByInsteadOfTimeseriesWithFloorOnTime() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT CAST(__time AS BIGINT), m1, ANY_VALUE(dim3, 100) FROM foo WHERE (CAST(TIME_FLOOR(__time, 'PT1H') AS BIGINT), m1) IN\n   (\n     SELECT CAST(TIME_FLOOR(__time, 'PT1H') AS BIGINT) + 0 AS t1, MIN(m1) AS t2 FROM foo WHERE dim3 = 'b'\n         AND __time BETWEEN '1994-04-29 00:00:00' AND '2020-01-11 00:00:00' GROUP BY 1\n    )\nGROUP BY 1, 2\n", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteJoinQueryTest.querySegmentSpec(Intervals.of((String)"1994-04-29/2020-01-11T00:00:00.001Z"))).setVirtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "(timestamp_floor(\"__time\",'PT1H',null,'UTC') + 0)", ColumnType.LONG)}).setDimFilter((DimFilter)CalciteJoinQueryTest.selector("dim3", "b", null)).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new FloatMinAggregatorFactory("a0", "m1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), "j0.", "((timestamp_floor(\"__time\",'PT1H',null,'UTC') == \"j0.d0\") && (\"m1\" == \"j0.a0\"))", JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("__time", "d0", ColumnType.LONG), new DefaultDimensionSpec("m1", "d1", ColumnType.FLOAT)}).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new StringAnyAggregatorFactory("a0", "dim3", Integer.valueOf(100))})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L, Float.valueOf(1.0f), "[a, b]"}, (Object)new Object[]{946771200000L, Float.valueOf(2.0f), "[b, c]"}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testFilterAndGroupByLookupUsingJoinOperatorWithValueFilterPushdownMatchesNothig(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT lookyloo.k, COUNT(*)\nFROM foo LEFT JOIN lookup.lookyloo ON foo.dim2 = lookyloo.k\nWHERE lookyloo.v = '123'\nGROUP BY lookyloo.k", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.LEFT)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter((DimFilter)CalciteJoinQueryTest.selector("j0.v", "123", null)).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("j0.k", "d0")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testFilterAndGroupByLookupUsingJoinOperatorAllowNulls(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT lookyloo.v, COUNT(*)\nFROM foo LEFT JOIN lookup.lookyloo ON foo.dim2 = lookyloo.k\nWHERE lookyloo.v <> 'xa' OR lookyloo.v IS NULL\nGROUP BY lookyloo.v", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.LEFT)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteJoinQueryTest.or(new DimFilter[]{CalciteJoinQueryTest.not((DimFilter)CalciteJoinQueryTest.selector("j0.v", "xa", null)), CalciteJoinQueryTest.selector("j0.v", null, null)})).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("j0.v", "d0")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{NULL_STRING, 3L}, (Object)new Object[]{"xabc", 1L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testFilterAndGroupByLookupUsingJoinOperatorBackwards(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT lookyloo.v, COUNT(*)\nFROM lookup.lookyloo RIGHT JOIN foo ON foo.dim2 = lookyloo.k\nWHERE lookyloo.v <> 'xa'\nGROUP BY lookyloo.v", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new LookupDataSource("lookyloo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim2"}).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("k"), CalciteJoinQueryTest.makeColumnExpression("j0.dim2")), JoinType.RIGHT)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter((DimFilter)CalciteJoinQueryTest.not((DimFilter)CalciteJoinQueryTest.selector("v", "xa", null))).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v", "d0")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{NULL_STRING, 3L}, (Object)new Object[]{"xabc", 1L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testFilterAndGroupByLookupUsingJoinOperatorWithNotFilter(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT lookyloo.v, COUNT(*)\nFROM foo LEFT JOIN lookup.lookyloo ON foo.dim2 = lookyloo.k\nWHERE lookyloo.v <> 'xa'\nGROUP BY lookyloo.v", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.LEFT)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter((DimFilter)CalciteJoinQueryTest.not((DimFilter)CalciteJoinQueryTest.selector("j0.v", "xa", null))).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("j0.v", "d0")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{NULL_STRING, 3L}, (Object)new Object[]{"xabc", 1L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testJoinUnionTablesOnLookup(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT lookyloo.v, COUNT(*)\nFROM\n  (SELECT dim2 FROM foo UNION ALL SELECT dim2 FROM numfoo) u\n  LEFT JOIN lookup.lookyloo ON u.dim2 = lookyloo.k\nWHERE lookyloo.v <> 'xa'\nGROUP BY lookyloo.v", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource("foo"), (Object)new TableDataSource("numfoo"))), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.LEFT)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter((DimFilter)CalciteJoinQueryTest.not((DimFilter)CalciteJoinQueryTest.selector("j0.v", "xa", null))).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("j0.v", "d0")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{NULL_STRING, 6L}, (Object)new Object[]{"xabc", 2L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testFilterAndGroupByLookupUsingJoinOperator(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT lookyloo.k, COUNT(*)\nFROM foo LEFT JOIN lookup.lookyloo ON foo.dim2 = lookyloo.k\nWHERE lookyloo.v = 'xa'\nGROUP BY lookyloo.k", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.LEFT)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter((DimFilter)CalciteJoinQueryTest.selector("j0.v", "xa", null)).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("j0.k", "d0")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", 2L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testFilterAndGroupByLookupUsingPostAggregationJoinOperator(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT base.dim2, lookyloo.v, base.cnt FROM (\n  SELECT dim2, COUNT(*) cnt FROM foo GROUP BY dim2\n) base\nLEFT JOIN lookup.lookyloo ON base.dim2 = lookyloo.k\nWHERE lookyloo.v <> 'xa' OR lookyloo.v IS NULL", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(queryContext).build()), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("d0"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.LEFT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteJoinQueryTest.or(new DimFilter[]{CalciteJoinQueryTest.not((DimFilter)CalciteJoinQueryTest.selector("j0.v", "xa", null)), CalciteJoinQueryTest.selector("j0.v", null, null)})).columns(new String[]{"a0", "d0", "j0.v"}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(NullHandling.sqlCompatible() ? ImmutableList.of((Object)new Object[]{NULL_STRING, NULL_STRING, 2L}, (Object)new Object[]{"", NULL_STRING, 1L}, (Object)new Object[]{"abc", "xabc", 1L}) : ImmutableList.of((Object)new Object[]{NULL_STRING, NULL_STRING, 3L}, (Object)new Object[]{"abc", "xabc", 1L})));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testGroupByInnerJoinOnLookupUsingJoinOperator(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT lookyloo.v, COUNT(*)\nFROM foo INNER JOIN lookup.lookyloo ON foo.dim1 = lookyloo.k\nGROUP BY lookyloo.v", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("j0.v", "d0")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testSelectOnLookupUsingInnerJoinOperator(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT dim2, lookyloo.*\nFROM foo INNER JOIN lookup.lookyloo ON foo.dim2 = lookyloo.k\n", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim2", "j0.k", "j0.v"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", "a", "xa"}, (Object)new Object[]{"a", "a", "xa"}, (Object)new Object[]{"abc", "abc", "xabc"}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testLeftJoinTwoLookupsUsingJoinOperator(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT dim1, dim2, l1.v, l2.v\nFROM foo\nLEFT JOIN lookup.lookyloo l1 ON foo.dim1 = l1.k\nLEFT JOIN lookup.lookyloo l2 ON foo.dim2 = l2.k\n", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.LEFT), (DataSource)new LookupDataSource("lookyloo"), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_j0.k")), JoinType.LEFT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"_j0.v", "dim1", "dim2", "j0.v"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", NULL_STRING, "xa"}, (Object)new Object[]{"10.1", NULL_STRING, NULL_STRING, NULL_STRING}, (Object)new Object[]{"2", "", NULL_STRING, NULL_STRING}, (Object)new Object[]{"1", "a", NULL_STRING, "xa"}, (Object)new Object[]{"def", "abc", NULL_STRING, "xabc"}, (Object)new Object[]{"abc", NULL_STRING, "xabc", NULL_STRING}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testInnerJoinTableLookupLookupWithFilterWithOuterLimit(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT dim1\nFROM foo\nINNER JOIN lookup.lookyloo l ON foo.dim2 = l.k\nINNER JOIN lookup.lookyloo l2 ON foo.dim2 = l2.k\nWHERE l.v = 'xa'\nLIMIT 100\n", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).limit(100L).filters((DimFilter)CalciteJoinQueryTest.selector("j0.v", "xa", null)).columns(new String[]{"dim1"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{""}, (Object)new Object[]{"1"}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testInnerJoinTableLookupLookupWithFilterWithoutLimit(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT dim1\nFROM foo\nINNER JOIN lookup.lookyloo l ON foo.dim2 = l.k\nINNER JOIN lookup.lookyloo l2 ON foo.dim2 = l2.k\nWHERE l.v = 'xa'\n", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteJoinQueryTest.selector("j0.v", "xa", null)).columns(new String[]{"dim1"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{""}, (Object)new Object[]{"1"}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testInnerJoinTableLookupLookupWithFilterWithOuterLimitWithAllColumns(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT __time, cnt, dim1, dim2, dim3, m1, m2, unique_dim1\nFROM foo\nINNER JOIN lookup.lookyloo l ON foo.dim2 = l.k\nINNER JOIN lookup.lookyloo l2 ON foo.dim2 = l2.k\nWHERE l.v = 'xa'\nLIMIT 100\n", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).limit(100L).filters((DimFilter)CalciteJoinQueryTest.selector("j0.v", "xa", null)).columns(new String[]{"__time", "cnt", "dim1", "dim2", "dim3", "m1", "m2", "unique_dim1"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L, 1L, "", "a", "[\"a\",\"b\"]", Float.valueOf(1.0f), 1.0, "\"AQAAAEAAAA==\""}, (Object)new Object[]{978307200000L, 1L, "1", "a", "", Float.valueOf(4.0f), 4.0, "\"AQAAAQAAAAFREA==\""}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testInnerJoinTableLookupLookupWithFilterWithoutLimitWithAllColumns(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT __time, cnt, dim1, dim2, dim3, m1, m2, unique_dim1\nFROM foo\nINNER JOIN lookup.lookyloo l ON foo.dim2 = l.k\nINNER JOIN lookup.lookyloo l2 ON foo.dim2 = l2.k\nWHERE l.v = 'xa'\n", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteJoinQueryTest.selector("j0.v", "xa", null)).columns(new String[]{"__time", "cnt", "dim1", "dim2", "dim3", "m1", "m2", "unique_dim1"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L, 1L, "", "a", "[\"a\",\"b\"]", Float.valueOf(1.0f), 1.0, "\"AQAAAEAAAA==\""}, (Object)new Object[]{978307200000L, 1L, "1", "a", "", Float.valueOf(4.0f), 4.0, "\"AQAAAQAAAAFREA==\""}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testManyManyInnerJoinOnManyManyLookup(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT dim1\nFROM foo\nINNER JOIN lookup.lookyloo l ON foo.dim2 = l.k\nINNER JOIN lookup.lookyloo l2 ON foo.dim2 = l2.k\nINNER JOIN lookup.lookyloo l3 ON foo.dim2 = l3.k\nINNER JOIN lookup.lookyloo l4 ON foo.dim2 = l4.k\nINNER JOIN lookup.lookyloo l5 ON foo.dim2 = l5.k\nINNER JOIN lookup.lookyloo l6 ON foo.dim2 = l6.k\nINNER JOIN lookup.lookyloo l7 ON foo.dim2 = l7.k\nINNER JOIN lookup.lookyloo l8 ON foo.dim2 = l8.k\nINNER JOIN lookup.lookyloo l9 ON foo.dim2 = l9.k\nINNER JOIN lookup.lookyloo l10 ON foo.dim2 = l10.k\nINNER JOIN lookup.lookyloo l11 ON foo.dim2 = l11.k\nINNER JOIN lookup.lookyloo l12 ON foo.dim2 = l12.k\nINNER JOIN lookup.lookyloo l13 ON foo.dim2 = l13.k\nINNER JOIN lookup.lookyloo l14 ON foo.dim2 = l14.k\nINNER JOIN lookup.lookyloo l15 ON foo.dim2 = l15.k\nINNER JOIN lookup.lookyloo l16 ON foo.dim2 = l16.k\nINNER JOIN lookup.lookyloo l17 ON foo.dim2 = l17.k\nINNER JOIN lookup.lookyloo l18 ON foo.dim2 = l18.k\nINNER JOIN lookup.lookyloo l19 ON foo.dim2 = l19.k\nWHERE l.v = 'xa'\n", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "__j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("__j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "___j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("___j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "____j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("____j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "_____j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_____j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "______j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("______j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "_______j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_______j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "________j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("________j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "_________j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_________j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "__________j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("__________j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "___________j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("___________j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "____________j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("____________j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "_____________j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_____________j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "______________j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("______________j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "_______________j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_______________j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "________________j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("________________j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "_________________j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_________________j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "__________________j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("__________________j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteJoinQueryTest.selector("j0.v", "xa", null)).columns(new String[]{"dim1"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{""}, (Object)new Object[]{"1"}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testInnerJoinQueryOfLookup(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT dim1, dim2, t1.v, t1.v\nFROM foo\nINNER JOIN \n  (SELECT SUBSTRING(k, 1, 1) k, LATEST(v, 10) v FROM lookup.lookyloo GROUP BY 1) t1\n  ON foo.dim2 = t1.k", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new LookupDataSource("lookyloo")).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new ExtractionDimensionSpec("k", "d0", (ExtractionFn)new SubstringDimExtractionFn(0, Integer.valueOf(1)))}).setAggregatorSpecs(new AggregatorFactory[]{new StringLastAggregatorFactory("a0", "v", null, Integer.valueOf(10))}).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.d0")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "dim2", "j0.a0"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", "xabc", "xabc"}, (Object)new Object[]{"1", "a", "xabc", "xabc"}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testInnerJoinQueryOfLookupRemovable(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT dim1, dim2, t1.sk\nFROM foo\nINNER JOIN \n  (SELECT k, SUBSTRING(v, 1, 3) sk FROM lookup.lookyloo) t1\n  ON foo.dim2 = t1.k", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "substring(\"j0.v\", 0, 3)", ColumnType.STRING)}).columns(new String[]{"dim1", "dim2", "v0"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", "xa"}, (Object)new Object[]{"1", "a", "xa"}, (Object)new Object[]{"def", "abc", "xab"}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testInnerJoinTwoLookupsToTableUsingNumericColumn(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(*)\nFROM foo\nINNER JOIN lookup.lookyloo l1 ON l1.k = foo.m1\nINNER JOIN lookup.lookyloo l2 ON l2.k = l1.k", queryContext, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)new LookupDataSource("lookyloo")).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "CAST(\"k\", 'DOUBLE')", ColumnType.FLOAT)}).columns(new String[]{"k", "v0"}).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"m1"), DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"j0.v0")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("j0.k"), CalciteJoinQueryTest.makeColumnExpression("_j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testInnerJoinTwoLookupsToTableUsingNumericColumnInReverse(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(*)\nFROM lookup.lookyloo l1\nINNER JOIN lookup.lookyloo l2 ON l1.k = l2.k\nINNER JOIN foo on l2.k = foo.m1", queryContext, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new LookupDataSource("lookyloo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("k"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"m1"}).context(QUERY_CONTEXT_DEFAULT).build()), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeExpression(ColumnType.DOUBLE, "CAST(\"j0.k\", 'DOUBLE')"), DruidExpression.ofColumn((ColumnType)ColumnType.DOUBLE, (String)"_j0.m1")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testInnerJoinLookupTableTable(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT l.k, l.v, SUM(f.m1), SUM(nf.m1)\nFROM lookup.lookyloo l\nINNER JOIN druid.foo f on f.dim1 = l.k\nINNER JOIN druid.numfoo nf on nf.dim1 = l.k\nGROUP BY 1, 2 ORDER BY 2", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new LookupDataSource("lookyloo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "m1"}).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("k"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.INNER), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "m1"}).context(QUERY_CONTEXT_DEFAULT).build()), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("k"), CalciteJoinQueryTest.makeColumnExpression("_j0.dim1")), JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("k", "d0"), new DefaultDimensionSpec("v", "d1")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "j0.m1"), new DoubleSumAggregatorFactory("a1", "_j0.m1")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.ASCENDING)), null)).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", "xabc", 6.0, 6.0}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testInnerJoinLookupTableTableChained(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT l.k, l.v, SUM(f.m1), SUM(nf.m1)\nFROM lookup.lookyloo l\nINNER JOIN druid.foo f on f.dim1 = l.k\nINNER JOIN druid.numfoo nf on nf.dim1 = f.dim1\nGROUP BY 1, 2 ORDER BY 2", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new LookupDataSource("lookyloo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "m1"}).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("k"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.INNER), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "m1"}).context(QUERY_CONTEXT_DEFAULT).build()), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("j0.dim1"), CalciteJoinQueryTest.makeColumnExpression("_j0.dim1")), JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("k", "d0"), new DefaultDimensionSpec("v", "d1")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "j0.m1"), new DoubleSumAggregatorFactory("a1", "_j0.m1")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.ASCENDING)), null)).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", "xabc", 6.0, 6.0}));
    }

    @Test
    public void testWhereInSelectNullFromLookup() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT * FROM foo where dim1 IN (SELECT NULL FROM lookup.lookyloo)", (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new LookupDataSource("lookyloo")).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setVirtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "null", ColumnType.STRING)}).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.d0")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "null", ColumnType.STRING)}).columns(new String[]{"__time", "cnt", "dim2", "dim3", "m1", "m2", "unique_dim1", "v0"}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testCommaJoinLeftFunction() throws Exception {
        this.testQuery("SELECT foo.dim1, foo.dim2, l.k, l.v\nFROM foo, lookup.lookyloo l\nWHERE SUBSTRING(foo.dim2, 1, 1) = l.k\n", (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeExpression("substring(\"dim2\", 0, 1)"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "dim2", "j0.k", "j0.v"}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", "a", "xa"}, (Object)new Object[]{"1", "a", "a", "xa"}, (Object)new Object[]{"def", "abc", "a", "xa"}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testCommaJoinTableLookupTableMismatchedTypes(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(*)\nFROM foo, lookup.lookyloo l, numfoo\nWHERE foo.cnt = l.k AND l.k = numfoo.cnt\n", queryContext, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", "1", JoinType.INNER), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).columns(new String[]{"cnt"}).context(QUERY_CONTEXT_DEFAULT).build()), "_j0.", "1", JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).filters((DimFilter)CalciteJoinQueryTest.and(new DimFilter[]{CalciteJoinQueryTest.expressionFilter("(\"cnt\" == CAST(\"j0.k\", 'LONG'))"), CalciteJoinQueryTest.expressionFilter("(CAST(\"j0.k\", 'LONG') == \"_j0.cnt\")")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testJoinTableLookupTableMismatchedTypesWithoutComma(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(*)\nFROM foo\nINNER JOIN lookup.lookyloo l ON foo.cnt = l.k\nINNER JOIN numfoo ON l.k = numfoo.cnt\n", queryContext, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)new LookupDataSource("lookyloo")).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "CAST(\"k\", 'LONG')", ColumnType.LONG)}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).columns(new String[]{"k", "v0"}).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"cnt"), DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"j0.v0")), JoinType.INNER), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).columns(new String[]{"cnt"}).context(queryContext).build()), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeExpression(ColumnType.LONG, "CAST(\"j0.k\", 'LONG')"), DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"_j0.cnt")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testInnerJoinCastLeft(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT foo.m1, l.k, l.v\nFROM foo\nINNER JOIN lookup.lookyloo l ON CAST(foo.m1 AS VARCHAR) = l.k\n", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeExpression("CAST(\"m1\", 'STRING')"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"j0.k", "j0.v", "m1"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testInnerJoinCastRight(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT foo.m1, l.k, l.v\nFROM foo\nINNER JOIN lookup.lookyloo l ON foo.m1 = CAST(l.k AS FLOAT)\n", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)new LookupDataSource("lookyloo")).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "CAST(\"k\", 'DOUBLE')", ColumnType.FLOAT)}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).columns(new String[]{"k", "v", "v0"}).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"m1"), DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"j0.v0")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"j0.k", "j0.v", "m1"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(6.0f), "6", "x6"}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testInnerJoinMismatchedTypes(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT foo.m1, l.k, l.v\nFROM foo\nINNER JOIN lookup.lookyloo l ON foo.m1 = l.k\n", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)new LookupDataSource("lookyloo")).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "CAST(\"k\", 'DOUBLE')", ColumnType.FLOAT)}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).columns(new String[]{"k", "v", "v0"}).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"m1"), DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"j0.v0")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"j0.k", "j0.v", "m1"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(6.0f), "6", "x6"}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testInnerJoinLeftFunction(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT foo.dim1, foo.dim2, l.k, l.v\nFROM foo\nINNER JOIN lookup.lookyloo l ON SUBSTRING(foo.dim2, 1, 1) = l.k\n", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeExpression("substring(\"dim2\", 0, 1)"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "dim2", "j0.k", "j0.v"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", "a", "xa"}, (Object)new Object[]{"1", "a", "a", "xa"}, (Object)new Object[]{"def", "abc", "a", "xa"}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testInnerJoinRightFunction(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT foo.dim1, foo.dim2, l.k, l.v\nFROM foo\nINNER JOIN lookup.lookyloo l ON foo.dim2 = SUBSTRING(l.k, 1, 2)\n", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)new LookupDataSource("lookyloo")).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "substring(\"k\", 0, 2)", ColumnType.STRING)}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).columns(new String[]{"k", "v", "v0"}).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.v0")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "dim2", "j0.k", "j0.v"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", "a", "xa"}, (Object)new Object[]{"1", "a", "a", "xa"}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testLeftJoinLookupOntoLookupUsingJoinOperator(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT dim2, l1.v, l2.v\nFROM foo\nLEFT JOIN lookup.lookyloo l1 ON foo.dim2 = l1.k\nLEFT JOIN lookup.lookyloo l2 ON l1.k = l2.k", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.LEFT), (DataSource)new LookupDataSource("lookyloo"), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("j0.k"), CalciteJoinQueryTest.makeColumnExpression("_j0.k")), JoinType.LEFT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"_j0.v", "dim2", "j0.v"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", "xa", "xa"}, (Object)new Object[]{NULL_STRING, NULL_STRING, NULL_STRING}, (Object)new Object[]{"", NULL_STRING, NULL_STRING}, (Object)new Object[]{"a", "xa", "xa"}, (Object)new Object[]{"abc", "xabc", "xabc"}, (Object)new Object[]{NULL_STRING, NULL_STRING, NULL_STRING}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testLeftJoinThreeLookupsUsingJoinOperator(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT dim1, dim2, l1.v, l2.v, l3.v\nFROM foo\nLEFT JOIN lookup.lookyloo l1 ON foo.dim1 = l1.k\nLEFT JOIN lookup.lookyloo l2 ON foo.dim2 = l2.k\nLEFT JOIN lookup.lookyloo l3 ON l2.k = l3.k", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.LEFT), (DataSource)new LookupDataSource("lookyloo"), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_j0.k")), JoinType.LEFT), (DataSource)new LookupDataSource("lookyloo"), "__j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("_j0.k"), CalciteJoinQueryTest.makeColumnExpression("__j0.k")), JoinType.LEFT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__j0.v", "_j0.v", "dim1", "dim2", "j0.v"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", NULL_STRING, "xa", "xa"}, (Object)new Object[]{"10.1", NULL_STRING, NULL_STRING, NULL_STRING, NULL_STRING}, (Object)new Object[]{"2", "", NULL_STRING, NULL_STRING, NULL_STRING}, (Object)new Object[]{"1", "a", NULL_STRING, "xa", "xa"}, (Object)new Object[]{"def", "abc", NULL_STRING, "xabc", "xabc"}, (Object)new Object[]{"abc", NULL_STRING, "xabc", NULL_STRING, NULL_STRING}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testSelectOnLookupUsingLeftJoinOperator(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT dim1, lookyloo.*\nFROM foo LEFT JOIN lookup.lookyloo ON foo.dim1 = lookyloo.k\nWHERE lookyloo.v <> 'xxx' OR lookyloo.v IS NULL", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.LEFT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteJoinQueryTest.or(new DimFilter[]{CalciteJoinQueryTest.not((DimFilter)CalciteJoinQueryTest.selector("j0.v", "xxx", null)), CalciteJoinQueryTest.selector("j0.v", null, null)})).columns(new String[]{"dim1", "j0.k", "j0.v"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", NULL_STRING, NULL_STRING}, (Object)new Object[]{"10.1", NULL_STRING, NULL_STRING}, (Object)new Object[]{"2", NULL_STRING, NULL_STRING}, (Object)new Object[]{"1", NULL_STRING, NULL_STRING}, (Object)new Object[]{"def", NULL_STRING, NULL_STRING}, (Object)new Object[]{"abc", "abc", "xabc"}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testSelectOnLookupUsingRightJoinOperator(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT dim1, lookyloo.*\nFROM foo RIGHT JOIN lookup.lookyloo ON foo.dim1 = lookyloo.k\nWHERE lookyloo.v <> 'xxx' OR lookyloo.v IS NULL", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.RIGHT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteJoinQueryTest.or(new DimFilter[]{CalciteJoinQueryTest.not((DimFilter)CalciteJoinQueryTest.selector("j0.v", "xxx", null)), CalciteJoinQueryTest.selector("j0.v", null, null)})).columns(new String[]{"dim1", "j0.k", "j0.v"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", "abc", "xabc"}, (Object)new Object[]{NULL_STRING, "a", "xa"}, (Object)new Object[]{NULL_STRING, "nosuchkey", "mysteryvalue"}, (Object)new Object[]{NULL_STRING, "6", "x6"}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testSelectOnLookupUsingFullJoinOperator(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT dim1, m1, cnt, lookyloo.*\nFROM foo FULL JOIN lookup.lookyloo ON foo.dim1 = lookyloo.k\nWHERE lookyloo.v <> 'xxx' OR lookyloo.v IS NULL", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.FULL)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteJoinQueryTest.or(new DimFilter[]{CalciteJoinQueryTest.not((DimFilter)CalciteJoinQueryTest.selector("j0.v", "xxx", null)), CalciteJoinQueryTest.selector("j0.v", null, null)})).columns(new String[]{"cnt", "dim1", "j0.k", "j0.v", "m1"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", Float.valueOf(1.0f), 1L, NULL_STRING, NULL_STRING}, (Object)new Object[]{"10.1", Float.valueOf(2.0f), 1L, NULL_STRING, NULL_STRING}, (Object)new Object[]{"2", Float.valueOf(3.0f), 1L, NULL_STRING, NULL_STRING}, (Object)new Object[]{"1", Float.valueOf(4.0f), 1L, NULL_STRING, NULL_STRING}, (Object)new Object[]{"def", Float.valueOf(5.0f), 1L, NULL_STRING, NULL_STRING}, (Object)new Object[]{"abc", Float.valueOf(6.0f), 1L, "abc", "xabc"}, (Object)new Object[]{NULL_STRING, NULL_FLOAT, NULL_LONG, "a", "xa"}, (Object)new Object[]{NULL_STRING, NULL_FLOAT, NULL_LONG, "nosuchkey", "mysteryvalue"}, (Object)new Object[]{NULL_STRING, NULL_FLOAT, NULL_LONG, "6", "x6"}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testInAggregationSubquery(Map<String, Object> queryContext) throws Exception {
        if (!CalciteJoinQueryTest.isRewriteJoinToFilter(queryContext)) {
            this.cannotVectorize();
        }
        this.testQuery("SELECT DISTINCT __time FROM druid.foo WHERE __time IN (SELECT MAX(__time) FROM druid.foo)", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new LongMaxAggregatorFactory("a0", "__time")}).context(QUERY_CONTEXT_DEFAULT).build().withOverriddenContext(queryContext)), "j0.", CalciteJoinQueryTest.equalsCondition(DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"__time"), DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"j0.a0")), JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("__time", "d0", ColumnType.LONG)})).setContext(QUERY_CONTEXT_DEFAULT).build().withOverriddenContext(queryContext)), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteJoinQueryTest.timestamp("2001-01-03")}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testNotInAggregationSubquery(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT DISTINCT __time FROM druid.foo WHERE __time NOT IN (SELECT MAX(__time) FROM druid.foo)", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new LongMaxAggregatorFactory("a0", "__time")}).context(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("_a0"), NullHandling.sqlCompatible() ? new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("_a1"), (DimFilter)CalciteJoinQueryTest.not((DimFilter)CalciteJoinQueryTest.selector("a0", null, null))) : new CountAggregatorFactory("_a1")}).setContext(queryContext).build()), "j0.", "1", JoinType.INNER), (DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new LongMaxAggregatorFactory("a0", "__time")}).postAggregators(new PostAggregator[]{CalciteJoinQueryTest.expressionPostAgg("p0", "1")}).context(QUERY_CONTEXT_DEFAULT).build()), "_j0.", "(\"__time\" == \"_j0.a0\")", JoinType.LEFT)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteJoinQueryTest.or(new DimFilter[]{CalciteJoinQueryTest.selector("j0._a0", "0", null), CalciteJoinQueryTest.and(new DimFilter[]{CalciteJoinQueryTest.selector("_j0.p0", null, null), CalciteJoinQueryTest.expressionFilter("(\"j0._a1\" >= \"j0._a0\")")})})).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("__time", "d0", ColumnType.LONG)})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteJoinQueryTest.timestamp("2000-01-01")}, (Object)new Object[]{CalciteJoinQueryTest.timestamp("2000-01-02")}, (Object)new Object[]{CalciteJoinQueryTest.timestamp("2000-01-03")}, (Object)new Object[]{CalciteJoinQueryTest.timestamp("2001-01-01")}, (Object)new Object[]{CalciteJoinQueryTest.timestamp("2001-01-02")}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testUsingSubqueryWithExtractionFns(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT dim2, COUNT(*) FROM druid.foo WHERE substring(dim2, 1, 1) IN (SELECT substring(dim1, 1, 1) FROM druid.foo WHERE dim1 <> '')group by dim2", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteJoinQueryTest.not((DimFilter)CalciteJoinQueryTest.selector("dim1", "", null))).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new ExtractionDimensionSpec("dim1", "d0", (ExtractionFn)new SubstringDimExtractionFn(0, Integer.valueOf(1)))})).setContext(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeExpression("substring(\"dim2\", 0, 1)"), CalciteJoinQueryTest.makeColumnExpression("j0.d0")), JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", 2L}, (Object)new Object[]{"abc", 1L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testInnerJoinWithIsNullFilter(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT dim1, l.v from druid.foo f inner join lookup.lookyloo l on f.dim1 = l.k where f.dim2 is null", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteJoinQueryTest.selector("dim2", null, null)).columns(new String[]{"dim1", "j0.v"}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", "xabc"}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    @Ignore
    public void testInnerJoinOnMultiValueColumn(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT dim3, l.v, count(*) from druid.foo f inner join lookup.lookyloo l on f.dim3 = l.k group by 1, 2", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim3"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim3", "d0"), new DefaultDimensionSpec("j0.v", "d1")})).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"2", "x2", 1L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testLeftJoinOnTwoInlineDataSourcesWithTimeFilter(Map<String, Object> queryContext) throws Exception {
        this.testQuery("with abc as\n(\n  SELECT dim1, \"__time\", m1 from foo WHERE \"dim1\" = '10.1' AND \"__time\" >= '1999'\n)\nSELECT t1.dim1, t1.\"__time\" from abc as t1 LEFT JOIN abc as t2 on t1.dim1 = t2.dim1 WHERE t1.dim1 = '10.1'\n", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Intervals.utc((long)DateTimes.of((String)"1999-01-01").getMillis(), (long)0x3FFFFFFFFFFFFFFFL))).filters((DimFilter)new SelectorDimFilter("dim1", "10.1", null)).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns((List)ImmutableList.of((Object)"__time", (Object)"v0")).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Intervals.utc((long)DateTimes.of((String)"1999-01-01").getMillis(), (long)0x3FFFFFFFFFFFFFFFL))).filters((DimFilter)new SelectorDimFilter("dim1", "10.1", null)).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns((List)ImmutableList.of((Object)"v0")).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("v0"), CalciteJoinQueryTest.makeColumnExpression("j0.v0")), JoinType.LEFT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("_v0", "'10.1'", ColumnType.STRING)}).columns(new String[]{"__time", "_v0"}).filters((DimFilter)new SelectorDimFilter("v0", "10.1", null)).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", 946771200000L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testLeftJoinOnTwoInlineDataSourcesWithTimeFilter_withLeftDirectAccess(Map<String, Object> queryContext) throws Exception {
        queryContext = this.withLeftDirectAccessEnabled(queryContext);
        this.testQuery("with abc as\n(\n  SELECT dim1, \"__time\", m1 from foo WHERE \"dim1\" = '10.1' AND \"__time\" >= '1999'\n)\nSELECT t1.dim1, t1.\"__time\" from abc as t1 LEFT JOIN abc as t2 on t1.dim1 = t2.dim1 WHERE t1.dim1 = '10.1'\n", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Intervals.utc((long)DateTimes.of((String)"1999-01-01").getMillis(), (long)0x3FFFFFFFFFFFFFFFL))).filters((DimFilter)new SelectorDimFilter("dim1", "10.1", null)).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns((List)ImmutableList.of((Object)"v0")).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeExpression("'10.1'"), CalciteJoinQueryTest.makeColumnExpression("j0.v0")), JoinType.LEFT, (DimFilter)CalciteJoinQueryTest.selector("dim1", "10.1", null))).intervals(CalciteJoinQueryTest.querySegmentSpec(Intervals.utc((long)DateTimes.of((String)"1999-01-01").getMillis(), (long)0x3FFFFFFFFFFFFFFFL))).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns(new String[]{"__time", "v0"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", 946771200000L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testLeftJoinOnTwoInlineDataSourcesWithOuterWhere(Map<String, Object> queryContext) throws Exception {
        this.testQuery("with abc as\n(\n  SELECT dim1, \"__time\", m1 from foo WHERE \"dim1\" = '10.1'\n)\nSELECT t1.dim1, t1.\"__time\" from abc as t1 LEFT JOIN abc as t2 on t1.dim1 = t2.dim1 WHERE t1.dim1 = '10.1'\n", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)new SelectorDimFilter("dim1", "10.1", null)).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns((List)ImmutableList.of((Object)"__time", (Object)"v0")).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)new SelectorDimFilter("dim1", "10.1", null)).columns((List)ImmutableList.of((Object)"dim1")).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("v0"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.LEFT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("_v0", "'10.1'", ColumnType.STRING)}).columns(new String[]{"__time", "_v0"}).filters((DimFilter)new SelectorDimFilter("v0", "10.1", null)).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", 946771200000L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testLeftJoinOnTwoInlineDataSourcesWithOuterWhere_withLeftDirectAccess(Map<String, Object> queryContext) throws Exception {
        queryContext = this.withLeftDirectAccessEnabled(queryContext);
        this.testQuery("with abc as\n(\n  SELECT dim1, \"__time\", m1 from foo WHERE \"dim1\" = '10.1'\n)\nSELECT t1.dim1, t1.\"__time\" from abc as t1 LEFT JOIN abc as t2 on t1.dim1 = t2.dim1 WHERE t1.dim1 = '10.1'\n", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)new SelectorDimFilter("dim1", "10.1", null)).columns((List)ImmutableList.of((Object)"dim1")).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeExpression("'10.1'"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.LEFT, (DimFilter)CalciteJoinQueryTest.selector("dim1", "10.1", null))).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns(new String[]{"__time", "v0"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", 946771200000L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testLeftJoinOnTwoInlineDataSources(Map<String, Object> queryContext) throws Exception {
        this.testQuery("with abc as\n(\n  SELECT dim1, \"__time\", m1 from foo WHERE \"dim1\" = '10.1'\n)\nSELECT t1.dim1, t1.\"__time\" from abc as t1 LEFT JOIN abc as t2 on t1.dim1 = t2.dim1\n", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)new SelectorDimFilter("dim1", "10.1", null)).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns((List)ImmutableList.of((Object)"__time", (Object)"v0")).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)new SelectorDimFilter("dim1", "10.1", null)).columns((List)ImmutableList.of((Object)"dim1")).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("v0"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.LEFT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("_v0", "'10.1'", ColumnType.STRING)}).columns(new String[]{"__time", "_v0"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", 946771200000L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testLeftJoinOnTwoInlineDataSources_withLeftDirectAccess(Map<String, Object> queryContext) throws Exception {
        queryContext = this.withLeftDirectAccessEnabled(queryContext);
        this.testQuery("with abc as\n(\n  SELECT dim1, \"__time\", m1 from foo WHERE \"dim1\" = '10.1'\n)\nSELECT t1.dim1, t1.\"__time\" from abc as t1 LEFT JOIN abc as t2 on t1.dim1 = t2.dim1\n", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)new SelectorDimFilter("dim1", "10.1", null)).columns((List)ImmutableList.of((Object)"dim1")).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeExpression("'10.1'"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.LEFT, (DimFilter)CalciteJoinQueryTest.selector("dim1", "10.1", null))).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns(new String[]{"__time", "v0"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", 946771200000L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testInnerJoinOnTwoInlineDataSourcesWithOuterWhere(Map<String, Object> queryContext) throws Exception {
        Druids.ScanQueryBuilder baseScanBuilder = CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").eternityInterval().filters((DimFilter)new SelectorDimFilter("dim1", "10.1", null)).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns((List)ImmutableList.of((Object)"__time", (Object)"v0")).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").eternityInterval().filters((DimFilter)new SelectorDimFilter("dim1", "10.1", null)).columns((List)ImmutableList.of((Object)"dim1")).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("v0"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("_v0", "'10.1'", ColumnType.STRING)}).columns(new String[]{"__time", "_v0"}).context(queryContext);
        this.testQuery("with abc as\n(\n  SELECT dim1, \"__time\", m1 from foo WHERE \"dim1\" = '10.1'\n)\nSELECT t1.dim1, t1.\"__time\" from abc as t1 INNER JOIN abc as t2 on t1.dim1 = t2.dim1 WHERE t1.dim1 = '10.1'\n", queryContext, (List<Query>)ImmutableList.of((Object)(NullHandling.sqlCompatible() ? baseScanBuilder.build() : baseScanBuilder.filters((DimFilter)new NotDimFilter((DimFilter)new SelectorDimFilter("v0", null, null))).build())), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", 946771200000L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testInnerJoinOnTwoInlineDataSourcesWithOuterWhere_withLeftDirectAccess(Map<String, Object> queryContext) throws Exception {
        queryContext = this.withLeftDirectAccessEnabled(queryContext);
        this.testQuery("with abc as\n(\n  SELECT dim1, \"__time\", m1 from foo WHERE \"dim1\" = '10.1'\n)\nSELECT t1.dim1, t1.\"__time\" from abc as t1 INNER JOIN abc as t2 on t1.dim1 = t2.dim1 WHERE t1.dim1 = '10.1'\n", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)new SelectorDimFilter("dim1", "10.1", null)).columns((List)ImmutableList.of((Object)"dim1")).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeExpression("'10.1'"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.INNER, (DimFilter)CalciteJoinQueryTest.selector("dim1", "10.1", null))).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns(new String[]{"__time", "v0"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", 946771200000L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testInnerJoinOnTwoInlineDataSources(Map<String, Object> queryContext) throws Exception {
        this.testQuery("with abc as\n(\n  SELECT dim1, \"__time\", m1 from foo WHERE \"dim1\" = '10.1'\n)\nSELECT t1.dim1, t1.\"__time\" from abc as t1 INNER JOIN abc as t2 on t1.dim1 = t2.dim1\n", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)new SelectorDimFilter("dim1", "10.1", null)).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns((List)ImmutableList.of((Object)"__time", (Object)"v0")).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)new SelectorDimFilter("dim1", "10.1", null)).columns((List)ImmutableList.of((Object)"dim1")).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("v0"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("_v0", "'10.1'", ColumnType.STRING)}).columns(new String[]{"__time", "_v0"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", 946771200000L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testInnerJoinOnTwoInlineDataSources_withLeftDirectAccess(Map<String, Object> queryContext) throws Exception {
        queryContext = this.withLeftDirectAccessEnabled(queryContext);
        this.testQuery("with abc as\n(\n  SELECT dim1, \"__time\", m1 from foo WHERE \"dim1\" = '10.1'\n)\nSELECT t1.dim1, t1.\"__time\" from abc as t1 INNER JOIN abc as t2 on t1.dim1 = t2.dim1\n", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)new SelectorDimFilter("dim1", "10.1", null)).columns((List)ImmutableList.of((Object)"dim1")).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeExpression("'10.1'"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.INNER, (DimFilter)CalciteJoinQueryTest.selector("dim1", "10.1", null))).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns(new String[]{"__time", "v0"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", 946771200000L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testJoinOnConstantShouldFail(Map<String, Object> queryContext) {
        this.assertQueryIsUnplannable("SELECT t1.dim1 from foo as t1 LEFT JOIN foo as t2 on t1.dim1 = '10.1'", "Possible error: SQL is resulting in a join that has unsupported operand types.");
    }

    @Test
    public void testLeftJoinRightTableCanBeEmpty() throws Exception {
        this.cannotVectorize();
        Object rightTable = this.useDefault ? InlineDataSource.fromIterable((Iterable)ImmutableList.of(), (RowSignature)RowSignature.builder().add("dim2", ColumnType.STRING).add("m2", ColumnType.DOUBLE).build()) : new QueryDataSource((Query)Druids.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).filters((DimFilter)new SelectorDimFilter("m2", null, null)).columns(new String[]{"dim2"}).legacy(Boolean.valueOf(false)).build());
        this.testQuery("SELECT v1.dim2, count(1) FROM (SELECT * FROM foo where m1 > 2) v1 LEFT OUTER JOIN (  select dim2 from (select * from foo where m2 is null)) sm ON v1.dim2 = sm.dim2 group by 1", (List<Query>)ImmutableList.of((Object)new GroupByQuery.Builder().setDataSource((DataSource)JoinDataSource.create((DataSource)new QueryDataSource((Query)Druids.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).filters((DimFilter)new BoundDimFilter("m1", "2", null, Boolean.valueOf(true), Boolean.valueOf(false), null, null, StringComparators.NUMERIC)).columns(new String[]{"dim2"}).legacy(Boolean.valueOf(false)).build()), (DataSource)rightTable, (String)"j0.", (String)"(\"dim2\" == \"j0.dim2\")", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil())).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0", ColumnType.STRING)}).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(this.useDefault ? ImmutableList.of((Object)new Object[]{"", 2L}, (Object)new Object[]{"a", 1L}, (Object)new Object[]{"abc", 1L}) : ImmutableList.of((Object)new Object[]{null, 1L}, (Object)new Object[]{"", 1L}, (Object)new Object[]{"a", 1L}, (Object)new Object[]{"abc", 1L})));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testLeftJoinSubqueryWithNullKeyFilter(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        ScanQuery nullCompatibleModePlan = CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new LookupDataSource("lookyloo")).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "concat(\"k\",'')", ColumnType.STRING)}).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")}).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.d0")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "j0.d0"}).context(queryContext).build();
        ScanQuery nonNullCompatibleModePlan = CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new LookupDataSource("lookyloo")).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "concat(\"k\",'')", ColumnType.STRING)}).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")}).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.d0")), JoinType.LEFT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "j0.d0"}).filters((DimFilter)new NotDimFilter((DimFilter)new SelectorDimFilter("j0.d0", null, null))).context(queryContext).build();
        boolean isJoinFilterRewriteEnabled = queryContext.getOrDefault("enableJoinFilterRewrite", true).toString().equals("true");
        this.testQuery("SELECT dim1, l1.k\nFROM foo\nLEFT JOIN (select k || '' as k from lookup.lookyloo group by 1) l1 ON foo.dim1 = l1.k\nWHERE l1.k IS NOT NULL\n", queryContext, (List<Query>)ImmutableList.of((Object)(NullHandling.sqlCompatible() ? nullCompatibleModePlan : nonNullCompatibleModePlan)), (List<Object[]>)(NullHandling.sqlCompatible() || !isJoinFilterRewriteEnabled ? ImmutableList.of((Object)new Object[]{"abc", "abc"}) : ImmutableList.of((Object)new Object[]{"10.1", ""}, (Object)new Object[]{"2", ""}, (Object)new Object[]{"1", ""}, (Object)new Object[]{"def", ""}, (Object)new Object[]{"abc", "abc"})));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testLeftJoinSubqueryWithSelectorFilter(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        queryContext = BaseCalciteQueryTest.QueryContextForJoinProvider.withOverrides(queryContext, (Map<String, Object>)ImmutableMap.of((Object)"computeInnerJoinCostAsFilter", (Object)"false"));
        this.testQuery("SELECT dim1, l1.k\nFROM foo\nLEFT JOIN (select k || '' as k from lookup.lookyloo group by 1) l1 ON foo.dim1 = l1.k\nWHERE l1.k = 'abc'\n", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new LookupDataSource("lookyloo")).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "concat(\"k\",'')", ColumnType.STRING)}).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")}).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.d0")), JoinType.LEFT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "j0.d0"}).filters((DimFilter)CalciteJoinQueryTest.selector("j0.d0", "abc", null)).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", "abc"}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testLeftJoinWithNotNullFilter(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT s.dim1, t.dim1\nFROM foo as s\nLEFT JOIN foo as t ON s.dim1 = t.dim1 and s.dim1 IS NOT NULL\n", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns((List)ImmutableList.of((Object)"dim1")).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.LEFT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "j0.dim1"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", ""}, (Object)new Object[]{"10.1", "10.1"}, (Object)new Object[]{"2", "2"}, (Object)new Object[]{"1", "1"}, (Object)new Object[]{"def", "def"}, (Object)new Object[]{"abc", "abc"}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testInnerJoinSubqueryWithSelectorFilter(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT dim1, l1.k FROM foo INNER JOIN (select k || '' as k from lookup.lookyloo group by 1) l1 ON foo.dim1 = l1.k and l1.k = 'abc'", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new LookupDataSource("lookyloo")).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "concat(\"k\",'')", ColumnType.STRING)}).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")}).build()), "j0.", StringUtils.format((String)"(%s && %s)", (Object[])new Object[]{CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.d0")), CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeExpression("'abc'"), CalciteJoinQueryTest.makeColumnExpression("j0.d0"))}), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "j0.d0"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", "abc"}));
    }

    @Test
    public void testSemiJoinWithOuterTimeExtractScan() throws Exception {
        this.testQuery("SELECT dim1, EXTRACT(MONTH FROM __time) FROM druid.foo\n WHERE dim2 IN (\n   SELECT dim2\n   FROM druid.foo\n   WHERE dim1 = 'def'\n ) AND dim1 <> ''", (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setDimFilter((DimFilter)CalciteJoinQueryTest.selector("dim1", "def", null)).setContext(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.d0")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "timestamp_extract(\"__time\",'MONTH','UTC')", ColumnType.LONG)}).filters((DimFilter)CalciteJoinQueryTest.not((DimFilter)CalciteJoinQueryTest.selector("dim1", "", null))).columns(new String[]{"dim1", "v0"}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"def", 1L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testTwoSemiJoinsSimultaneously(Map<String, Object> queryContext) throws Exception {
        if (!CalciteJoinQueryTest.isRewriteJoinToFilter(queryContext)) {
            this.cannotVectorize();
        }
        this.testQuery("SELECT dim1, COUNT(*) FROM foo\nWHERE dim1 IN ('abc', 'def')AND __time IN (SELECT MAX(__time) FROM foo WHERE cnt = 1)\nAND __time IN (SELECT MAX(__time) FROM foo WHERE cnt <> 2)\nGROUP BY 1", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteJoinQueryTest.selector("cnt", "1", null)).aggregators(new AggregatorFactory[]{new LongMaxAggregatorFactory("a0", "__time")}).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", "(\"__time\" == \"j0.a0\")", JoinType.INNER), (DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteJoinQueryTest.not((DimFilter)CalciteJoinQueryTest.selector("cnt", "2", null))).aggregators(new AggregatorFactory[]{new LongMaxAggregatorFactory("a0", "__time")}).context(QUERY_CONTEXT_DEFAULT).build()), "_j0.", "(\"__time\" == \"_j0.a0\")", JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteJoinQueryTest.in("dim1", (List<String>)ImmutableList.of((Object)"abc", (Object)"def"), null)).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", 1L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testSemiAndAntiJoinSimultaneouslyUsingWhereInSubquery(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT dim1, COUNT(*) FROM foo\nWHERE dim1 IN ('abc', 'def')\nAND __time IN (SELECT MAX(__time) FROM foo)\nAND __time NOT IN (SELECT MIN(__time) FROM foo)\nGROUP BY 1", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new LongMaxAggregatorFactory("a0", "__time")}).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", "(\"__time\" == \"j0.a0\")", JoinType.INNER), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new LongMinAggregatorFactory("a0", "__time")}).context(QUERY_CONTEXT_DEFAULT).build())).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("_a0"), NullHandling.sqlCompatible() ? new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("_a1"), (DimFilter)CalciteJoinQueryTest.not((DimFilter)CalciteJoinQueryTest.selector("a0", null, null))) : new CountAggregatorFactory("_a1")}).setContext(QUERY_CONTEXT_DEFAULT).build()), "_j0.", "1", JoinType.INNER), (DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new LongMinAggregatorFactory("a0", "__time")}).postAggregators(new PostAggregator[]{CalciteJoinQueryTest.expressionPostAgg("p0", "1")}).context(QUERY_CONTEXT_DEFAULT).build()), "__j0.", "(\"__time\" == \"__j0.a0\")", JoinType.LEFT)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteJoinQueryTest.and(new DimFilter[]{CalciteJoinQueryTest.in("dim1", (List<String>)ImmutableList.of((Object)"abc", (Object)"def"), null), CalciteJoinQueryTest.or(new DimFilter[]{CalciteJoinQueryTest.selector("_j0._a0", "0", null), CalciteJoinQueryTest.and(new DimFilter[]{CalciteJoinQueryTest.selector("__j0.p0", null, null), CalciteJoinQueryTest.expressionFilter("(\"_j0._a1\" >= \"_j0._a0\")")})})})).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", 1L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testSemiAndAntiJoinSimultaneouslyUsingExplicitJoins(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT dim1, COUNT(*) FROM\nfoo\nINNER JOIN (SELECT MAX(__time) t FROM foo) t0 on t0.t = foo.__time\nLEFT JOIN (SELECT MIN(__time) t FROM foo) t1 on t1.t = foo.__time\nWHERE dim1 IN ('abc', 'def') AND t1.t is null\nGROUP BY 1", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new LongMaxAggregatorFactory("a0", "__time")}).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", "(\"__time\" == \"j0.a0\")", JoinType.INNER), (DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new LongMinAggregatorFactory("a0", "__time")}).context(QUERY_CONTEXT_DEFAULT).build()), "_j0.", "(\"__time\" == \"_j0.a0\")", JoinType.LEFT)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteJoinQueryTest.and(new DimFilter[]{CalciteJoinQueryTest.in("dim1", (List<String>)ImmutableList.of((Object)"abc", (Object)"def"), null), CalciteJoinQueryTest.selector("_j0.a0", null, null)})).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", 1L}));
    }

    @Test
    public void testSemiJoinWithOuterTimeExtractAggregateWithOrderBy() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(DISTINCT dim1), EXTRACT(MONTH FROM __time) FROM druid.foo\n WHERE dim2 IN (\n   SELECT dim2\n   FROM druid.foo\n   WHERE dim1 = 'def'\n ) AND dim1 <> ''GROUP BY EXTRACT(MONTH FROM __time)\nORDER BY EXTRACT(MONTH FROM __time)", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setDimFilter((DimFilter)CalciteJoinQueryTest.selector("dim1", "def", null)).setContext(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.d0")), JoinType.INNER)).setVirtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "timestamp_extract(\"__time\",'MONTH','UTC')", ColumnType.LONG)}).setDimFilter((DimFilter)CalciteJoinQueryTest.not((DimFilter)CalciteJoinQueryTest.selector("dim1", "", null))).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CardinalityAggregatorFactory("a0", null, (List)ImmutableList.of((Object)new DefaultDimensionSpec("dim1", "dim1", ColumnType.STRING)), false, true)})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, 1L}));
    }

    @Test(expected=QueryException.class)
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testJoinOnMultiValuedColumnShouldThrowException(Map<String, Object> queryContext) throws Exception {
        String query = "SELECT dim3, l.v from druid.foo f inner join lookup.lookyloo l on f.dim3 = l.k\n";
        this.testQuery("SELECT dim3, l.v from druid.foo f inner join lookup.lookyloo l on f.dim3 = l.k\n", queryContext, (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testUnionAllTwoQueriesLeftQueryIsJoin(Map<String, Object> queryContext) throws Exception {
        if (!CalciteJoinQueryTest.isRewriteJoinToFilter(queryContext)) {
            this.cannotVectorize();
        }
        this.testQuery("(SELECT COUNT(*) FROM foo INNER JOIN lookup.lookyloo ON foo.dim1 = lookyloo.k)  UNION ALL SELECT SUM(cnt) FROM foo", queryContext, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build().withOverriddenContext(queryContext), (Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(QUERY_CONTEXT_DEFAULT).build().withOverriddenContext(queryContext)), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}, (Object)new Object[]{6L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testUnionAllTwoQueriesRightQueryIsJoin(Map<String, Object> queryContext) throws Exception {
        if (!CalciteJoinQueryTest.isRewriteJoinToFilter(queryContext)) {
            this.cannotVectorize();
        }
        this.testQuery("(SELECT SUM(cnt) FROM foo UNION ALL SELECT COUNT(*) FROM foo INNER JOIN lookup.lookyloo ON foo.dim1 = lookyloo.k) ", queryContext, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(QUERY_CONTEXT_DEFAULT).build().withOverriddenContext(queryContext), (Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build().withOverriddenContext(queryContext)), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}, (Object)new Object[]{1L}));
    }

    @Test
    public void testUnionAllTwoQueriesBothQueriesAreJoin() throws Exception {
        this.cannotVectorize();
        this.testQuery("(SELECT COUNT(*) FROM foo LEFT JOIN lookup.lookyloo ON foo.dim1 = lookyloo.k                                UNION ALL                                       SELECT COUNT(*) FROM foo INNER JOIN lookup.lookyloo ON foo.dim1 = lookyloo.k) ", (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.LEFT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build(), (Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}, (Object)new Object[]{1L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testTopNFilterJoin(Map<String, Object> queryContext) throws Exception {
        if (!CalciteJoinQueryTest.isRewriteJoinToFilter(queryContext)) {
            this.cannotVectorize();
        }
        this.testQuery("SELECT t1.dim1, SUM(t1.cnt)\nFROM druid.foo t1\n  INNER JOIN (\n  SELECT\n    SUM(cnt) AS sum_cnt,\n    dim2\n  FROM druid.foo\n  GROUP BY dim2\n  ORDER BY 1 DESC\n  LIMIT 2\n) t2 ON (t1.dim2 = t2.dim2)\nGROUP BY t1.dim1\nORDER BY 1\n", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)new TopNQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim2", "d0")).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")}).metric("a0").threshold(2).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.d0")), JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", 1L}, (Object)new Object[]{"1", 1L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testTopNFilterJoinWithProjection(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT SUBSTRING(t1.dim1, 1, 10), SUM(t1.cnt)\nFROM druid.foo t1\n  INNER JOIN (\n  SELECT\n    SUM(cnt) AS sum_cnt,\n    dim2\n  FROM druid.foo\n  GROUP BY dim2\n  ORDER BY 1 DESC\n  LIMIT 2\n) t2 ON (t1.dim2 = t2.dim2)\nGROUP BY SUBSTRING(t1.dim1, 1, 10)", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)new TopNQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim2", "d0")).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")}).metric("a0").threshold(2).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.d0")), JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new ExtractionDimensionSpec("dim1", "d0", ColumnType.STRING, (ExtractionFn)new SubstringDimExtractionFn(0, Integer.valueOf(10)))})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{NULL_STRING, 1L}, (Object)new Object[]{"1", 1L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    @Ignore(value="Stopped working after the ability to join on subqueries was added to DruidJoinRule")
    public void testRemovableLeftJoin(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT t1.dim1, SUM(t1.cnt)\nFROM druid.foo t1\n  LEFT JOIN (\n  SELECT\n    SUM(cnt) AS sum_cnt,\n    dim2\n  FROM druid.foo\n  GROUP BY dim2\n  ORDER BY 1 DESC\n  LIMIT 2\n) t2 ON (t1.dim2 = t2.dim2)\nGROUP BY t1.dim1\nORDER BY 1\n", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", 1L}, (Object)new Object[]{"1", 1L}, (Object)new Object[]{"10.1", 1L}, (Object)new Object[]{"2", 1L}, (Object)new Object[]{"abc", 1L}, (Object)new Object[]{"def", 1L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testCountDistinctOfLookupUsingJoinOperator(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(DISTINCT lookyloo.v)\nFROM foo LEFT JOIN lookup.lookyloo ON foo.dim1 = lookyloo.k", queryContext, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.LEFT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CardinalityAggregatorFactory("a0", null, (List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"j0.v")), false, true)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{NullHandling.replaceWithDefault() ? 2L : 1L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testUsingSubqueryAsPartOfAndFilter(Map<String, Object> queryContext) throws Exception {
        if (!CalciteJoinQueryTest.isRewriteJoinToFilter(queryContext)) {
            this.cannotVectorize();
        }
        this.testQuery("SELECT dim1, dim2, COUNT(*) FROM druid.foo\nWHERE dim2 IN (SELECT dim1 FROM druid.foo WHERE dim1 <> '')\nAND dim1 <> 'xxx'\ngroup by dim1, dim2 ORDER BY dim2", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteJoinQueryTest.not((DimFilter)CalciteJoinQueryTest.selector("dim1", "", null))).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.d0")), JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteJoinQueryTest.not((DimFilter)CalciteJoinQueryTest.selector("dim1", "xxx", null))).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.ASCENDING)), Integer.valueOf(Integer.MAX_VALUE))).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"def", "abc", 1L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testUsingSubqueryAsPartOfOrFilter(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT dim1, dim2, COUNT(*) FROM druid.foo\nWHERE dim1 = 'xxx' OR dim2 IN (SELECT dim1 FROM druid.foo WHERE dim1 LIKE '%bc')\ngroup by dim1, dim2 ORDER BY dim2", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)new LikeDimFilter("dim1", "%bc", null, null)).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", "1", JoinType.INNER), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "1", ColumnType.LONG)}).setDimFilter((DimFilter)new LikeDimFilter("dim1", "%bc", null, null)).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG)})).setContext(queryContext).build()), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_j0.d0")), JoinType.LEFT)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteJoinQueryTest.or(new DimFilter[]{CalciteJoinQueryTest.selector("dim1", "xxx", null), CalciteJoinQueryTest.and(new DimFilter[]{CalciteJoinQueryTest.not((DimFilter)CalciteJoinQueryTest.selector("j0.a0", "0", null)), CalciteJoinQueryTest.not((DimFilter)CalciteJoinQueryTest.selector("_j0.d1", null, null)), CalciteJoinQueryTest.not((DimFilter)CalciteJoinQueryTest.selector("dim2", null, null))})})).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.ASCENDING)), Integer.valueOf(Integer.MAX_VALUE))).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"def", "abc", 1L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testNestedGroupByOnInlineDataSourceWithFilter(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        this.testQuery("with abc as(  SELECT dim1, m2 from druid.foo where \"__time\" >= '2001-01-02'), def as(  SELECT t1.dim1, SUM(t2.m2) as \"metricSum\"   from abc as t1 inner join abc as t2 on t1.dim1 = t2.dim1  where t1.dim1='def'  group by 1)SELECT count(*) from def", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Intervals.of((String)"2001-01-02T00:00:00.000Z/146140482-04-24T15:36:27.903Z"))).columns(new String[]{"dim1"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Intervals.of((String)"2001-01-02T00:00:00.000Z/146140482-04-24T15:36:27.903Z"))).columns(new String[]{"dim1", "m2"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.INNER)).setGranularity(Granularities.ALL).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter((DimFilter)CalciteJoinQueryTest.selector("dim1", "def", null)).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setVirtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'def'", ColumnType.STRING)}).build()).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setGranularity(Granularities.ALL).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testGroupByJoinAsNativeQueryWithUnoptimizedFilter(Map<String, Object> queryContext) {
        GroupByQuery query = GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Intervals.of((String)"2001-01-02T00:00:00.000Z/146140482-04-24T15:36:27.903Z"))).columns(new String[]{"dim1"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Intervals.of((String)"2001-01-02T00:00:00.000Z/146140482-04-24T15:36:27.903Z"))).columns(new String[]{"dim1", "m2"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.INNER)).setGranularity(Granularities.ALL).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter((DimFilter)CalciteJoinQueryTest.in("dim1", Collections.singletonList("def"), null)).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setVirtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'def'", ColumnType.STRING)}).build();
        QueryLifecycleFactory qlf = CalciteTests.createMockQueryLifecycleFactory(this.walker, conglomerate);
        QueryLifecycle ql = qlf.factorize();
        Sequence seq = ql.runSimple((Query)query, CalciteTests.SUPER_USER_AUTH_RESULT, Access.OK);
        List results = seq.toList();
        Assert.assertEquals((Object)ImmutableList.of((Object)ResultRow.of((Object[])new Object[]{"def"})), (Object)results);
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testCountOnSemiJoinSingleColumn(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT dim1 FROM foo WHERE dim1 IN (SELECT dim1 FROM foo WHERE dim1 = '10.1')\n", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter((DimFilter)CalciteJoinQueryTest.selector("dim1", "10.1", null)).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setContext(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.d0")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns(new String[]{"v0"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1"}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testTopNOnStringWithNonSortedOrUniqueDictionary(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT druid.broadcast.dim4, COUNT(*)\nFROM druid.numfoo\nINNER JOIN druid.broadcast ON numfoo.dim4 = broadcast.dim4\nGROUP BY 1 ORDER BY 2 LIMIT 4", queryContext, (List<Query>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("numfoo"), (DataSource)new GlobalTableDataSource("broadcast"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim4"), CalciteJoinQueryTest.makeColumnExpression("j0.dim4")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).dimension((DimensionSpec)new DefaultDimensionSpec("j0.dim4", "_d0", ColumnType.STRING)).threshold(4).aggregators(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(queryContext).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new NumericTopNMetricSpec("a0"))).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", 9L}, (Object)new Object[]{"b", 9L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testTopNOnStringWithNonSortedOrUniqueDictionaryOrderByDim(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT druid.broadcast.dim4, COUNT(*)\nFROM druid.numfoo\nINNER JOIN druid.broadcast ON numfoo.dim4 = broadcast.dim4\nGROUP BY 1 ORDER BY 1 DESC LIMIT 4", queryContext, (List<Query>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("numfoo"), (DataSource)new GlobalTableDataSource("broadcast"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim4"), CalciteJoinQueryTest.makeColumnExpression("j0.dim4")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).dimension((DimensionSpec)new DefaultDimensionSpec("j0.dim4", "_d0", ColumnType.STRING)).threshold(4).aggregators(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(queryContext).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC))).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"b", 9L}, (Object)new Object[]{"a", 9L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testVirtualColumnOnMVFilterJoinExpression(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT foo1.dim3, foo2.dim3 FROM druid.numfoo as foo1 INNER JOIN druid.numfoo as foo2 ON MV_FILTER_ONLY(foo1.dim3, ARRAY['a']) = MV_FILTER_ONLY(foo2.dim3, ARRAY['a'])\n", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("numfoo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteJoinQueryTest.querySegmentSpec(Intervals.of((String)"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z"))).virtualColumns(new VirtualColumn[]{new ListFilteredVirtualColumn("v0", (DimensionSpec)new DefaultDimensionSpec("dim3", "dim3", ColumnType.STRING), (Set)ImmutableSet.of((Object)"a"), Boolean.valueOf(true))}).columns(new String[]{"dim3", "v0"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("v0"), CalciteJoinQueryTest.makeColumnExpression("j0.v0")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{new ListFilteredVirtualColumn("v0", (DimensionSpec)new DefaultDimensionSpec("dim3", "dim3", ColumnType.STRING), (Set)ImmutableSet.of((Object)"a"), Boolean.valueOf(true))}).columns(new String[]{"dim3", "j0.dim3"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]", "[\"a\",\"b\"]"}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testVirtualColumnOnMVFilterMultiJoinExpression(Map<String, Object> queryContext) throws Exception {
        this.testQuery("SELECT foo1.dim3, foo2.dim3 FROM druid.numfoo as foo1 INNER JOIN (SELECT foo3.dim3 FROM druid.numfoo as foo3 INNER JOIN druid.numfoo as foo4    ON MV_FILTER_ONLY(foo3.dim3, ARRAY['a']) = MV_FILTER_ONLY(foo4.dim3, ARRAY['a'])) as foo2 ON MV_FILTER_ONLY(foo1.dim3, ARRAY['a']) = MV_FILTER_ONLY(foo2.dim3, ARRAY['a'])\n", queryContext, (List<Query>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("numfoo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("numfoo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteJoinQueryTest.querySegmentSpec(Intervals.of((String)"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z"))).virtualColumns(new VirtualColumn[]{new ListFilteredVirtualColumn("v0", (DimensionSpec)new DefaultDimensionSpec("dim3", "dim3", ColumnType.STRING), (Set)ImmutableSet.of((Object)"a"), Boolean.valueOf(true))}).columns(new String[]{"v0"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("v0"), CalciteJoinQueryTest.makeColumnExpression("j0.v0")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{new ListFilteredVirtualColumn("v0", (DimensionSpec)new DefaultDimensionSpec("dim3", "dim3", ColumnType.STRING), (Set)ImmutableSet.of((Object)"a"), Boolean.valueOf(true))}).columns(new String[]{"dim3", "v0"}).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("v0"), CalciteJoinQueryTest.makeColumnExpression("j0.v0")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{new ListFilteredVirtualColumn("v0", (DimensionSpec)new DefaultDimensionSpec("dim3", "dim3", ColumnType.STRING), (Set)ImmutableSet.of((Object)"a"), Boolean.valueOf(true))}).columns(new String[]{"dim3", "j0.dim3"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]", "[\"a\",\"b\"]"}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testInnerJoinWithFilterPushdownAndManyFiltersEmptyResults(Map<String, Object> queryContext) throws Exception {
        ScanQuery query = CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)new TableDataSource("foo")).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).columns(new String[]{"m1"}).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"m1"), DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"j0.m1")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"j0.m1", "m1"}).filters((DimFilter)new OrDimFilter(new DimFilter[]{new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "A", null), new SelectorDimFilter("dim2", "B", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "C", null), new SelectorDimFilter("dim2", "D", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "A", null), new SelectorDimFilter("dim2", "C", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "C", null), new SelectorDimFilter("dim2", "E", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "D", null), new SelectorDimFilter("dim2", "H", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "A", null), new SelectorDimFilter("dim2", "D", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "B", null), new SelectorDimFilter("dim2", "C", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "H", null), new SelectorDimFilter("dim2", "E", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "I", null), new SelectorDimFilter("dim2", "J", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "I", null), new SelectorDimFilter("dim2", "K", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "J", null), new SelectorDimFilter("dim2", "I", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "Q", null), new SelectorDimFilter("dim2", "R", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "Q", null), new SelectorDimFilter("dim2", "S", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "S", null), new SelectorDimFilter("dim2", "Q", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "X", null), new SelectorDimFilter("dim2", "Y", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "Z", null), new SelectorDimFilter("dim2", "U", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "U", null), new SelectorDimFilter("dim2", "Z", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "P", null), new SelectorDimFilter("dim2", "Q", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "X", null), new SelectorDimFilter("dim2", "A", null)})})).context(queryContext).build();
        assert (QueryContexts.getEnableJoinFilterPushDown((Query)query));
        this.testQuery("SELECT f1.m1, f2.m1\nFROM foo f1\nINNER JOIN foo f2 ON f1.m1 = f2.m1 where (f1.dim1, f1.dim2) in (('A', 'B'), ('C', 'D'), ('A', 'C'), ('C', 'E'), ('D', 'H'), ('A', 'D'), ('B', 'C'), \n('H', 'E'), ('I', 'J'), ('I', 'K'), ('J', 'I'), ('Q', 'R'), ('Q', 'S'), ('S', 'Q'), ('X', 'Y'), ('Z', 'U'), ('U', 'Z'), ('P', 'Q'), ('X', 'A'))\n", queryContext, (List<Query>)ImmutableList.of((Object)query), (List<Object[]>)ImmutableList.of());
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testInnerJoinWithFilterPushdownAndManyFiltersNonEmptyResults(Map<String, Object> queryContext) throws Exception {
        ScanQuery query = CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)new TableDataSource("foo")).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).columns(new String[]{"m1"}).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"m1"), DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"j0.m1")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"j0.m1", "m1"}).filters((DimFilter)new OrDimFilter(new DimFilter[]{new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "1", null), new SelectorDimFilter("dim2", "a", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "C", null), new SelectorDimFilter("dim2", "D", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "A", null), new SelectorDimFilter("dim2", "C", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "C", null), new SelectorDimFilter("dim2", "E", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "D", null), new SelectorDimFilter("dim2", "H", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "A", null), new SelectorDimFilter("dim2", "D", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "B", null), new SelectorDimFilter("dim2", "C", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "H", null), new SelectorDimFilter("dim2", "E", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "I", null), new SelectorDimFilter("dim2", "J", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "I", null), new SelectorDimFilter("dim2", "K", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "J", null), new SelectorDimFilter("dim2", "I", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "Q", null), new SelectorDimFilter("dim2", "R", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "Q", null), new SelectorDimFilter("dim2", "S", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "S", null), new SelectorDimFilter("dim2", "Q", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "X", null), new SelectorDimFilter("dim2", "Y", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "Z", null), new SelectorDimFilter("dim2", "U", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "U", null), new SelectorDimFilter("dim2", "Z", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "P", null), new SelectorDimFilter("dim2", "Q", null)}), new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim1", "X", null), new SelectorDimFilter("dim2", "A", null)})})).context(queryContext).build();
        assert (QueryContexts.getEnableJoinFilterPushDown((Query)query));
        this.testQuery("SELECT f1.m1, f2.m1\nFROM foo f1\nINNER JOIN foo f2 ON f1.m1 = f2.m1 where (f1.dim1, f1.dim2) in (('1', 'a'), ('C', 'D'), ('A', 'C'), ('C', 'E'), ('D', 'H'), ('A', 'D'), ('B', 'C'), \n('H', 'E'), ('I', 'J'), ('I', 'K'), ('J', 'I'), ('Q', 'R'), ('Q', 'S'), ('S', 'Q'), ('X', 'Y'), ('Z', 'U'), ('U', 'Z'), ('P', 'Q'), ('X', 'A'))\n", queryContext, (List<Query>)ImmutableList.of((Object)query), (List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(4.0f), Float.valueOf(4.0f)}));
    }

    @Test
    public void testPlanWithInFilterMoreThanInSubQueryThreshold() throws Exception {
        String query = "SELECT l1 FROM numfoo WHERE l1 IN (4842, 4844, 4845, 14905, 4853, 29064)";
        HashMap<String, Object> queryContext = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        queryContext.put("inSubQueryThreshold", 3);
        this.testQuery(PLANNER_CONFIG_DEFAULT, queryContext, DEFAULT_PARAMETERS, query, CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)JoinDataSource.create((DataSource)new TableDataSource("numfoo"), (DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{4842L}, (Object)new Object[]{4844L}, (Object)new Object[]{4845L}, (Object)new Object[]{14905L}, (Object)new Object[]{4853L}, (Object)new Object[]{29064L}), (RowSignature)RowSignature.builder().add("ROW_VALUE", ColumnType.LONG).build()), (String)"j0.", (String)"(\"l1\" == \"j0.ROW_VALUE\")", (JoinType)JoinType.INNER, null, (ExprMacroTable)ExprMacroTable.nil())).columns(new String[]{"l1"}).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).context(queryContext).legacy(Boolean.valueOf(false)).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (sql, result) -> {}, null);
    }
}

