/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.InlineInputSource;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.SqlLifecycle;
import org.apache.druid.sql.SqlLifecycleFactory;
import org.apache.druid.sql.SqlPlanningException;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.external.ExternalDataSource;
import org.apache.druid.sql.calcite.external.ExternalOperatorConversion;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;

public class CalciteInsertDmlTest
extends BaseCalciteQueryTest {
    private static final Map<String, Object> DEFAULT_CONTEXT = ImmutableMap.builder().put((Object)"sqlQueryId", (Object)"dummy").build();
    private static final RowSignature FOO_TABLE_SIGNATURE = RowSignature.builder().addTimeColumn().add("cnt", ColumnType.LONG).add("dim1", ColumnType.STRING).add("dim2", ColumnType.STRING).add("dim3", ColumnType.STRING).add("m1", ColumnType.FLOAT).add("m2", ColumnType.DOUBLE).add("unique_dim1", HyperUniquesAggregatorFactory.TYPE).build();
    private final ExternalDataSource externalDataSource = new ExternalDataSource((InputSource)new InlineInputSource("a,b,1\nc,d,2\n"), (InputFormat)new CsvInputFormat((List)ImmutableList.of((Object)"x", (Object)"y", (Object)"z"), null, Boolean.valueOf(false), Boolean.valueOf(false), 0), RowSignature.builder().add("x", ColumnType.STRING).add("y", ColumnType.STRING).add("z", ColumnType.LONG).build());
    private static final Map<String, Object> PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT = ImmutableMap.of((Object)"sqlInsertSegmentGranularity", (Object)"{\"type\":\"all\"}");
    private boolean didTest = false;

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        if (!this.didTest) {
            throw new ISE("Test was not run; did you call verify() on a tester?", new Object[0]);
        }
    }

    @Test
    public void testInsertFromTable() {
        this.testInsertQuery().sql("INSERT INTO dst SELECT * FROM foo PARTITIONED BY ALL TIME").expectTarget("dst", FOO_TABLE_SIGNATURE).expectResources(CalciteInsertDmlTest.dataSourceRead("foo"), CalciteInsertDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "cnt", "dim1", "dim2", "dim3", "m1", "m2", "unique_dim1"}).context(PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testInsertFromView() {
        this.testInsertQuery().sql("INSERT INTO dst SELECT * FROM view.aview PARTITIONED BY ALL TIME").expectTarget("dst", RowSignature.builder().add("dim1_firstchar", ColumnType.STRING).build()).expectResources(CalciteInsertDmlTest.viewRead("aview"), CalciteInsertDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteInsertDmlTest.expressionVirtualColumn("v0", "substring(\"dim1\", 0, 1)", ColumnType.STRING)}).filters((DimFilter)CalciteInsertDmlTest.selector("dim2", "a", null)).columns(new String[]{"v0"}).context(PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testInsertIntoExistingTable() {
        this.testInsertQuery().sql("INSERT INTO foo SELECT * FROM foo PARTITIONED BY ALL TIME").expectTarget("foo", FOO_TABLE_SIGNATURE).expectResources(CalciteInsertDmlTest.dataSourceRead("foo"), CalciteInsertDmlTest.dataSourceWrite("foo")).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "cnt", "dim1", "dim2", "dim3", "m1", "m2", "unique_dim1"}).context(PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testInsertIntoQualifiedTable() {
        this.testInsertQuery().sql("INSERT INTO druid.dst SELECT * FROM foo PARTITIONED BY ALL TIME").expectTarget("dst", FOO_TABLE_SIGNATURE).expectResources(CalciteInsertDmlTest.dataSourceRead("foo"), CalciteInsertDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "cnt", "dim1", "dim2", "dim3", "m1", "m2", "unique_dim1"}).context(PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testInsertIntoInvalidDataSourceName() {
        this.testInsertQuery().sql("INSERT INTO \"in/valid\" SELECT dim1, dim2 FROM foo PARTITIONED BY ALL TIME").expectValidationError(SqlPlanningException.class, "INSERT dataSource cannot contain the '/' character.").verify();
    }

    @Test
    public void testInsertUsingColumnList() {
        this.testInsertQuery().sql("INSERT INTO dst (foo, bar) SELECT dim1, dim2 FROM foo PARTITIONED BY ALL TIME").expectValidationError(SqlPlanningException.class, "INSERT with target column list is not supported.").verify();
    }

    @Test
    public void testUpsert() {
        this.testInsertQuery().sql("UPSERT INTO dst SELECT * FROM foo PARTITIONED BY ALL TIME").expectValidationError(SqlPlanningException.class, "UPSERT is not supported.").verify();
    }

    @Test
    public void testInsertIntoSystemTable() {
        this.testInsertQuery().sql("INSERT INTO INFORMATION_SCHEMA.COLUMNS SELECT * FROM foo PARTITIONED BY ALL TIME").expectValidationError(SqlPlanningException.class, "Cannot INSERT into [INFORMATION_SCHEMA.COLUMNS] because it is not a Druid datasource.").verify();
    }

    @Test
    public void testInsertIntoView() {
        this.testInsertQuery().sql("INSERT INTO view.aview SELECT * FROM foo PARTITIONED BY ALL TIME").expectValidationError(SqlPlanningException.class, "Cannot INSERT into [view.aview] because it is not a Druid datasource.").verify();
    }

    @Test
    public void testInsertFromUnauthorizedDataSource() {
        this.testInsertQuery().sql("INSERT INTO dst SELECT * FROM \"%s\" PARTITIONED BY ALL TIME", "forbiddenDatasource", new Object[0]).expectValidationError(ForbiddenException.class).verify();
    }

    @Test
    public void testInsertIntoUnauthorizedDataSource() {
        this.testInsertQuery().sql("INSERT INTO \"%s\" SELECT * FROM foo PARTITIONED BY ALL TIME", "forbiddenDatasource", new Object[0]).expectValidationError(ForbiddenException.class).verify();
    }

    @Test
    public void testInsertIntoNonexistentSchema() {
        this.testInsertQuery().sql("INSERT INTO nonexistent.dst SELECT * FROM foo PARTITIONED BY ALL TIME").expectValidationError(SqlPlanningException.class, "Cannot INSERT into [nonexistent.dst] because it is not a Druid datasource.").verify();
    }

    @Test
    public void testInsertFromExternal() {
        this.testInsertQuery().sql("INSERT INTO dst SELECT * FROM %s PARTITIONED BY ALL TIME", this.externSql(this.externalDataSource), new Object[0]).authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", this.externalDataSource.getSignature()).expectResources(CalciteInsertDmlTest.dataSourceWrite("dst"), ExternalOperatorConversion.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource((DataSource)this.externalDataSource).intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"x", "y", "z"}).context(PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testInsertWithPartitionedBy() {
        RowSignature targetRowSignature = RowSignature.builder().add("__time", ColumnType.LONG).add("floor_m1", ColumnType.FLOAT).add("dim1", ColumnType.STRING).build();
        this.testInsertQuery().sql("INSERT INTO druid.dst SELECT __time, FLOOR(m1) as floor_m1, dim1 FROM foo PARTITIONED BY TIME_FLOOR(__time, 'PT1H')").expectTarget("dst", targetRowSignature).expectResources(CalciteInsertDmlTest.dataSourceRead("foo"), CalciteInsertDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "v0"}).virtualColumns(new VirtualColumn[]{CalciteInsertDmlTest.expressionVirtualColumn("v0", "floor(\"m1\")", ColumnType.FLOAT)}).context(this.queryContextWithGranularity(Granularities.HOUR)).build()).verify();
    }

    @Test
    public void testPartitionedBySupportedClauses() {
        RowSignature targetRowSignature = RowSignature.builder().add("__time", ColumnType.LONG).add("dim1", ColumnType.STRING).build();
        ImmutableMap partitionedByArgumentToGranularityMap = ImmutableMap.builder().put((Object)"HOUR", (Object)Granularities.HOUR).put((Object)"DAY", (Object)Granularities.DAY).put((Object)"MONTH", (Object)Granularities.MONTH).put((Object)"YEAR", (Object)Granularities.YEAR).put((Object)"ALL", (Object)Granularities.ALL).put((Object)"ALL TIME", (Object)Granularities.ALL).put((Object)"FLOOR(__time TO QUARTER)", (Object)Granularities.QUARTER).put((Object)"TIME_FLOOR(__time, 'PT1H')", (Object)Granularities.HOUR).build();
        partitionedByArgumentToGranularityMap.forEach((partitionedByArgument, expectedGranularity) -> {
            ImmutableMap queryContext = null;
            try {
                queryContext = ImmutableMap.of((Object)"sqlInsertSegmentGranularity", (Object)this.queryJsonMapper.writeValueAsString(expectedGranularity));
            }
            catch (JsonProcessingException e) {
                Assert.fail((String)e.getMessage());
            }
            this.testInsertQuery().sql(StringUtils.format((String)"INSERT INTO druid.dst SELECT __time, dim1 FROM foo PARTITIONED BY %s", (Object[])new Object[]{partitionedByArgument})).expectTarget("dst", targetRowSignature).expectResources(CalciteInsertDmlTest.dataSourceRead("foo"), CalciteInsertDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1"}).context((Map)queryContext).build()).verify();
            this.didTest = false;
        });
        this.didTest = true;
    }

    @Test
    public void testInsertWithClusteredBy() {
        RowSignature targetRowSignature = RowSignature.builder().add("__time", ColumnType.LONG).add("floor_m1", ColumnType.FLOAT).add("dim1", ColumnType.STRING).add("EXPR$3", ColumnType.DOUBLE).build();
        this.testInsertQuery().sql("INSERT INTO druid.dst SELECT __time, FLOOR(m1) as floor_m1, dim1, CEIL(m2) FROM foo PARTITIONED BY FLOOR(__time TO DAY) CLUSTERED BY 2, dim1 DESC, CEIL(m2)").expectTarget("dst", targetRowSignature).expectResources(CalciteInsertDmlTest.dataSourceRead("foo"), CalciteInsertDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "v0", "v1"}).virtualColumns(new VirtualColumn[]{CalciteInsertDmlTest.expressionVirtualColumn("v0", "floor(\"m1\")", ColumnType.FLOAT), CalciteInsertDmlTest.expressionVirtualColumn("v1", "ceil(\"m2\")", ColumnType.DOUBLE)}).orderBy((List)ImmutableList.of((Object)new ScanQuery.OrderBy("v0", ScanQuery.Order.ASCENDING), (Object)new ScanQuery.OrderBy("dim1", ScanQuery.Order.DESCENDING), (Object)new ScanQuery.OrderBy("v1", ScanQuery.Order.ASCENDING))).context(this.queryContextWithGranularity(Granularities.DAY)).build()).verify();
    }

    @Test
    public void testInsertWithPartitionedByAndClusteredBy() {
        RowSignature targetRowSignature = RowSignature.builder().add("__time", ColumnType.LONG).add("floor_m1", ColumnType.FLOAT).add("dim1", ColumnType.STRING).build();
        this.testInsertQuery().sql("INSERT INTO druid.dst SELECT __time, FLOOR(m1) as floor_m1, dim1 FROM foo PARTITIONED BY DAY CLUSTERED BY 2, dim1").expectTarget("dst", targetRowSignature).expectResources(CalciteInsertDmlTest.dataSourceRead("foo"), CalciteInsertDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "v0"}).virtualColumns(new VirtualColumn[]{CalciteInsertDmlTest.expressionVirtualColumn("v0", "floor(\"m1\")", ColumnType.FLOAT)}).orderBy((List)ImmutableList.of((Object)new ScanQuery.OrderBy("v0", ScanQuery.Order.ASCENDING), (Object)new ScanQuery.OrderBy("dim1", ScanQuery.Order.ASCENDING))).context(this.queryContextWithGranularity(Granularities.DAY)).build()).verify();
    }

    @Test
    public void testInsertWithPartitionedByAndLimitOffset() {
        RowSignature targetRowSignature = RowSignature.builder().add("__time", ColumnType.LONG).add("floor_m1", ColumnType.FLOAT).add("dim1", ColumnType.STRING).build();
        this.testInsertQuery().sql("INSERT INTO druid.dst SELECT __time, FLOOR(m1) as floor_m1, dim1 FROM foo LIMIT 10 OFFSET 20 PARTITIONED BY DAY").expectTarget("dst", targetRowSignature).expectResources(CalciteInsertDmlTest.dataSourceRead("foo"), CalciteInsertDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "v0"}).virtualColumns(new VirtualColumn[]{CalciteInsertDmlTest.expressionVirtualColumn("v0", "floor(\"m1\")", ColumnType.FLOAT)}).limit(10L).offset(20L).context(this.queryContextWithGranularity(Granularities.DAY)).build()).verify();
    }

    @Test
    public void testInsertWithClusteredByAndOrderBy() throws Exception {
        try {
            this.testQuery(StringUtils.format((String)"INSERT INTO dst SELECT * FROM %s ORDER BY 2 PARTITIONED BY ALL TIME", (Object[])new Object[]{this.externSql(this.externalDataSource)}), (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
            Assert.fail((String)"Exception should be thrown");
        }
        catch (SqlPlanningException e) {
            Assert.assertEquals((Object)"Cannot have ORDER BY on an INSERT query, use CLUSTERED BY instead.", (Object)e.getMessage());
        }
        this.didTest = true;
    }

    @Test
    public void testInsertWithPartitionedByContainingInvalidGranularity() throws Exception {
        try {
            this.testQuery("INSERT INTO dst SELECT * FROM foo PARTITIONED BY 'invalid_granularity'", (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
            Assert.fail((String)"Exception should be thrown");
        }
        catch (SqlPlanningException e) {
            Assert.assertEquals((Object)"Encountered 'invalid_granularity' after PARTITIONED BY. Expected HOUR, DAY, MONTH, YEAR, ALL TIME, FLOOR function or TIME_FLOOR function", (Object)e.getMessage());
        }
        this.didTest = true;
    }

    @Test
    public void testInsertWithOrderBy() throws Exception {
        try {
            this.testQuery(StringUtils.format((String)"INSERT INTO dst SELECT * FROM %s ORDER BY 2 PARTITIONED BY ALL TIME", (Object[])new Object[]{this.externSql(this.externalDataSource)}), (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
            Assert.fail((String)"Exception should be thrown");
        }
        catch (SqlPlanningException e) {
            Assert.assertEquals((Object)"Cannot have ORDER BY on an INSERT query, use CLUSTERED BY instead.", (Object)e.getMessage());
        }
        finally {
            this.didTest = true;
        }
    }

    @Test
    public void testInsertWithoutPartitionedBy() {
        SqlPlanningException e = (SqlPlanningException)Assert.assertThrows(SqlPlanningException.class, () -> this.testQuery(StringUtils.format((String)"INSERT INTO dst SELECT * FROM %s", (Object[])new Object[]{this.externSql(this.externalDataSource)}), (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of()));
        Assert.assertEquals((Object)"INSERT statements must specify PARTITIONED BY clause explicitly", (Object)e.getMessage());
        this.didTest = true;
    }

    @Test
    public void testExplainInsertFromExternal() throws Exception {
        this.skipVectorize();
        ScanQuery expectedQuery = CalciteInsertDmlTest.newScanQueryBuilder().dataSource((DataSource)this.externalDataSource).intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"x", "y", "z"}).context((Map)this.queryJsonMapper.readValue("{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlInsertSegmentGranularity\":\"{\\\"type\\\":\\\"all\\\"}\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"}", JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT)).build();
        String expectedExplanation = "DruidQueryRel(query=[" + this.queryJsonMapper.writeValueAsString((Object)expectedQuery) + "], signature=[{x:STRING, y:STRING, z:LONG}])\n";
        this.testQuery(new PlannerConfig(), StringUtils.format((String)"EXPLAIN PLAN FOR INSERT INTO dst SELECT * FROM %s PARTITIONED BY ALL TIME", (Object[])new Object[]{this.externSql(this.externalDataSource)}), CalciteTests.SUPER_USER_AUTH_RESULT, (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{expectedExplanation, "[{\"name\":\"EXTERNAL\",\"type\":\"EXTERNAL\"},{\"name\":\"dst\",\"type\":\"DATASOURCE\"}]"}));
        this.didTest = true;
    }

    @Test
    public void testExplainInsertFromExternalUnauthorized() {
        Assert.assertThrows(ForbiddenException.class, () -> this.testQuery(StringUtils.format((String)"EXPLAIN PLAN FOR INSERT INTO dst SELECT * FROM %s PARTITIONED BY ALL TIME", (Object[])new Object[]{this.externSql(this.externalDataSource)}), (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of()));
        this.didTest = true;
    }

    @Test
    public void testInsertFromExternalUnauthorized() {
        this.testInsertQuery().sql("INSERT INTO dst SELECT * FROM %s PARTITIONED BY ALL TIME", this.externSql(this.externalDataSource), new Object[0]).expectValidationError(ForbiddenException.class).verify();
    }

    @Test
    public void testInsertFromExternalProjectSort() {
        this.testInsertQuery().sql("INSERT INTO dst SELECT x || y AS xy, z FROM %s PARTITIONED BY ALL TIME CLUSTERED BY 1, 2", this.externSql(this.externalDataSource), new Object[0]).authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", RowSignature.builder().add("xy", ColumnType.STRING).add("z", ColumnType.LONG).build()).expectResources(CalciteInsertDmlTest.dataSourceWrite("dst"), ExternalOperatorConversion.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource((DataSource)this.externalDataSource).intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteInsertDmlTest.expressionVirtualColumn("v0", "concat(\"x\",\"y\")", ColumnType.STRING)}).columns(new String[]{"v0", "z"}).orderBy((List)ImmutableList.of((Object)new ScanQuery.OrderBy("v0", ScanQuery.Order.ASCENDING), (Object)new ScanQuery.OrderBy("z", ScanQuery.Order.ASCENDING))).context(PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testInsertFromExternalAggregate() {
        this.testInsertQuery().sql("INSERT INTO dst SELECT x, SUM(z) AS sum_z, COUNT(*) AS cnt FROM %s GROUP BY 1 PARTITIONED BY ALL TIME", this.externSql(this.externalDataSource), new Object[0]).authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", RowSignature.builder().add("x", ColumnType.STRING).add("sum_z", ColumnType.LONG).add("cnt", ColumnType.LONG).build()).expectResources(CalciteInsertDmlTest.dataSourceWrite("dst"), ExternalOperatorConversion.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)GroupByQuery.builder().setDataSource((DataSource)this.externalDataSource).setInterval(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteInsertDmlTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("x", "d0")})).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "z"), new CountAggregatorFactory("a1")}).setContext(PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testInsertFromExternalAggregateAll() {
        this.testInsertQuery().sql("INSERT INTO dst SELECT COUNT(*) AS cnt FROM %s PARTITIONED BY ALL TIME", this.externSql(this.externalDataSource), new Object[0]).authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", RowSignature.builder().add("cnt", ColumnType.LONG).build()).expectResources(CalciteInsertDmlTest.dataSourceWrite("dst"), ExternalOperatorConversion.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)GroupByQuery.builder().setDataSource((DataSource)this.externalDataSource).setInterval(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testInsertWithInvalidSelectStatement() {
        this.testInsertQuery().sql("INSERT INTO t SELECT channel, added as count FROM foo PARTITIONED BY ALL").expectValidationError((Matcher<Throwable>)CoreMatchers.allOf((Matcher)CoreMatchers.instanceOf(SqlPlanningException.class), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.startsWith((String)"Encountered \"as count\"")))).verify();
    }

    private String externSql(ExternalDataSource externalDataSource) {
        try {
            return StringUtils.format((String)"TABLE(extern(%s, %s, %s))", (Object[])new Object[]{Calcites.escapeStringLiteral((String)this.queryJsonMapper.writeValueAsString((Object)externalDataSource.getInputSource())), Calcites.escapeStringLiteral((String)this.queryJsonMapper.writeValueAsString((Object)externalDataSource.getInputFormat())), Calcites.escapeStringLiteral((String)this.queryJsonMapper.writeValueAsString((Object)externalDataSource.getSignature()))});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, Object> queryContextWithGranularity(Granularity granularity) {
        String granularityString = null;
        try {
            granularityString = this.queryJsonMapper.writeValueAsString((Object)granularity);
        }
        catch (JsonProcessingException e) {
            Assert.fail((String)e.getMessage());
        }
        return ImmutableMap.of((Object)"sqlInsertSegmentGranularity", (Object)granularityString);
    }

    private InsertDmlTester testInsertQuery() {
        return new InsertDmlTester();
    }

    private static ResourceAction viewRead(String viewName) {
        return new ResourceAction(new Resource(viewName, "VIEW"), Action.READ);
    }

    private static ResourceAction dataSourceRead(String dataSource) {
        return new ResourceAction(new Resource(dataSource, "DATASOURCE"), Action.READ);
    }

    private static ResourceAction dataSourceWrite(String dataSource) {
        return new ResourceAction(new Resource(dataSource, "DATASOURCE"), Action.WRITE);
    }

    static /* synthetic */ Map access$200() {
        return DEFAULT_CONTEXT;
    }

    public class InsertDmlTester {
        private String sql;
        private PlannerConfig plannerConfig = new PlannerConfig();
        private Map<String, Object> queryContext = CalciteInsertDmlTest.access$200();
        private AuthenticationResult authenticationResult = CalciteTests.REGULAR_USER_AUTH_RESULT;
        private String expectedTargetDataSource;
        private RowSignature expectedTargetSignature;
        private List<ResourceAction> expectedResources;
        private Query expectedQuery;
        private Matcher<Throwable> validationErrorMatcher;

        private InsertDmlTester() {
        }

        public InsertDmlTester sql(String sql) {
            this.sql = sql;
            return this;
        }

        private InsertDmlTester sql(String sqlPattern, Object arg, Object ... otherArgs) {
            Object[] args = new Object[otherArgs.length + 1];
            args[0] = arg;
            System.arraycopy(otherArgs, 0, args, 1, otherArgs.length);
            this.sql = StringUtils.format((String)sqlPattern, (Object[])args);
            return this;
        }

        public InsertDmlTester context(Map<String, Object> context) {
            this.queryContext = context;
            return this;
        }

        public InsertDmlTester authentication(AuthenticationResult authenticationResult) {
            this.authenticationResult = authenticationResult;
            return this;
        }

        public InsertDmlTester expectTarget(String expectedTargetDataSource, RowSignature expectedTargetSignature) {
            this.expectedTargetDataSource = (String)Preconditions.checkNotNull((Object)expectedTargetDataSource, (Object)"expectedTargetDataSource");
            this.expectedTargetSignature = (RowSignature)Preconditions.checkNotNull((Object)expectedTargetSignature, (Object)"expectedTargetSignature");
            return this;
        }

        public InsertDmlTester expectResources(ResourceAction ... expectedResources) {
            this.expectedResources = Arrays.asList(expectedResources);
            return this;
        }

        public InsertDmlTester expectQuery(Query expectedQuery) {
            this.expectedQuery = expectedQuery;
            return this;
        }

        public InsertDmlTester expectValidationError(Matcher<Throwable> validationErrorMatcher) {
            this.validationErrorMatcher = validationErrorMatcher;
            return this;
        }

        public InsertDmlTester expectValidationError(Class<? extends Throwable> clazz) {
            return this.expectValidationError((Matcher<Throwable>)CoreMatchers.instanceOf(clazz));
        }

        public InsertDmlTester expectValidationError(Class<? extends Throwable> clazz, String message) {
            return this.expectValidationError((Matcher<Throwable>)CoreMatchers.allOf((Matcher)CoreMatchers.instanceOf(clazz), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)message))));
        }

        public void verify() {
            if (CalciteInsertDmlTest.this.didTest) {
                throw new ISE("Use one @Test method per tester", new Object[0]);
            }
            CalciteInsertDmlTest.this.didTest = true;
            if (this.sql == null) {
                throw new ISE("Test must have SQL statement", new Object[0]);
            }
            try {
                BaseCalciteQueryTest.log.info("SQL: %s", new Object[]{this.sql});
                CalciteInsertDmlTest.this.queryLogHook.clearRecordedQueries();
                if (this.validationErrorMatcher != null) {
                    this.verifyValidationError();
                } else {
                    this.verifySuccess();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void verifyValidationError() {
            if (this.expectedTargetDataSource != null) {
                throw new ISE("Test must not have expectedTargetDataSource", new Object[0]);
            }
            if (this.expectedResources != null) {
                throw new ISE("Test must not have expectedResources", new Object[0]);
            }
            if (this.expectedQuery != null) {
                throw new ISE("Test must not have expectedQuery", new Object[0]);
            }
            SqlLifecycleFactory sqlLifecycleFactory = CalciteInsertDmlTest.this.getSqlLifecycleFactory(this.plannerConfig, new AuthConfig(), CalciteInsertDmlTest.this.createOperatorTable(), CalciteInsertDmlTest.this.createMacroTable(), CalciteTests.TEST_AUTHORIZER_MAPPER, CalciteInsertDmlTest.this.queryJsonMapper);
            SqlLifecycle sqlLifecycle = sqlLifecycleFactory.factorize();
            sqlLifecycle.initialize(this.sql, new QueryContext(this.queryContext));
            Throwable e = Assert.assertThrows(Throwable.class, () -> sqlLifecycle.validateAndAuthorize(this.authenticationResult));
            MatcherAssert.assertThat((Object)e, this.validationErrorMatcher);
            Assert.assertTrue((boolean)CalciteInsertDmlTest.this.queryLogHook.getRecordedQueries().isEmpty());
        }

        private void verifySuccess() throws Exception {
            if (this.expectedTargetDataSource == null) {
                throw new ISE("Test must have expectedTargetDataSource", new Object[0]);
            }
            if (this.expectedResources == null) {
                throw new ISE("Test must have expectedResources", new Object[0]);
            }
            List<Query> expectedQueries = this.expectedQuery == null ? Collections.emptyList() : Collections.singletonList(BaseCalciteQueryTest.recursivelyOverrideContext(this.expectedQuery, this.queryContext));
            Assert.assertEquals((Object)ImmutableSet.copyOf(this.expectedResources), CalciteInsertDmlTest.this.analyzeResources(this.plannerConfig, this.sql, this.authenticationResult));
            List<Object[]> results = CalciteInsertDmlTest.this.getResults(this.plannerConfig, this.queryContext, Collections.emptyList(), this.sql, this.authenticationResult);
            CalciteInsertDmlTest.this.verifyResults(this.sql, expectedQueries, Collections.singletonList(new Object[]{this.expectedTargetDataSource, this.expectedTargetSignature}), results);
        }
    }
}

