/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.AllGranularity;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.any.LongAnyAggregatorFactory;
import org.apache.druid.query.aggregation.cardinality.CardinalityAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniqueFinalizingPostAggregator;
import org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class CalciteCorrelatedQueryTest
extends BaseCalciteQueryTest {
    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testCorrelatedSubquery(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        queryContext = this.withLeftDirectAccessEnabled(queryContext);
        this.testQuery("select country, ANY_VALUE(\n        select avg(\"users\") from (\n            select floor(__time to day), count(distinct user) \"users\" from visits f where f.country = visits.country group by 1\n        )\n     ) as \"DAU\"\nfrom visits \ngroup by 1", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteCorrelatedQueryTest.join((DataSource)new TableDataSource("visits"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("visits").setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1D',null,'UTC')", ColumnType.LONG, TestExprMacroTable.INSTANCE)}).setDimFilter((DimFilter)CalciteCorrelatedQueryTest.not((DimFilter)CalciteCorrelatedQueryTest.selector("country", null, null))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("country", "d1")}).setAggregatorSpecs(new AggregatorFactory[]{new CardinalityAggregatorFactory("a0:a", null, Collections.singletonList(new DefaultDimensionSpec("user", "user")), false, true)}).setPostAggregatorSpecs(Collections.singletonList(new HyperUniqueFinalizingPostAggregator("a0", "a0:a"))).setContext(this.withTimestampResultContext(queryContext, "d0", Granularities.DAY)).setGranularity((Granularity)new AllGranularity()).build()).setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("d1", "_d0")}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("_a0:sum", "a0"), this.useDefault ? new CountAggregatorFactory("_a0:count") : new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("_a0:count"), (DimFilter)CalciteCorrelatedQueryTest.not((DimFilter)CalciteCorrelatedQueryTest.selector("a0", null, null)))}).setPostAggregatorSpecs(Collections.singletonList(new ArithmeticPostAggregator("_a0", "quotient", Arrays.asList(new FieldAccessPostAggregator(null, "_a0:sum"), new FieldAccessPostAggregator(null, "_a0:count"))))).setGranularity((Granularity)new AllGranularity()).setContext(queryContext).build()), "j0.", CalciteCorrelatedQueryTest.equalsCondition(CalciteCorrelatedQueryTest.makeColumnExpression("country"), CalciteCorrelatedQueryTest.makeColumnExpression("j0._d0")), JoinType.LEFT)).setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("country", "d0")}).setAggregatorSpecs(new AggregatorFactory[]{new LongAnyAggregatorFactory("a0", "j0._a0")}).setGranularity((Granularity)new AllGranularity()).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"India", 2L}, (Object)new Object[]{"USA", 1L}, (Object)new Object[]{"canada", 3L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testCorrelatedSubqueryWithLeftFilter(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        queryContext = this.withLeftDirectAccessEnabled(queryContext);
        this.testQuery("select country, ANY_VALUE(\n        select max(\"users\") from (\n            select floor(__time to day), count(*) \"users\" from visits f where f.country = visits.country group by 1\n        )\n     ) as \"dailyVisits\"\nfrom visits \n where city = 'B' and __time between '2021-01-01 01:00:00' AND '2021-01-02 23:59:59' group by 1", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteCorrelatedQueryTest.join((DataSource)new TableDataSource("visits"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("visits").setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1D',null,'UTC')", ColumnType.LONG, TestExprMacroTable.INSTANCE)}).setDimFilter((DimFilter)CalciteCorrelatedQueryTest.not((DimFilter)CalciteCorrelatedQueryTest.selector("country", null, null))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("country", "d1")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(this.withTimestampResultContext(queryContext, "d0", Granularities.DAY)).setGranularity((Granularity)new AllGranularity()).build()).setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("d1", "_d0")}).setAggregatorSpecs(new AggregatorFactory[]{new LongMaxAggregatorFactory("_a0", "a0")}).setGranularity((Granularity)new AllGranularity()).setContext(queryContext).build()), "j0.", CalciteCorrelatedQueryTest.equalsCondition(CalciteCorrelatedQueryTest.makeColumnExpression("country"), CalciteCorrelatedQueryTest.makeColumnExpression("j0._d0")), JoinType.LEFT, (DimFilter)CalciteCorrelatedQueryTest.selector("city", "B", null))).setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.of((String)"2021-01-01T01:00:00.000Z/2021-01-02T23:59:59.001Z"))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("country", "d0")}).setAggregatorSpecs(new AggregatorFactory[]{new LongAnyAggregatorFactory("a0", "j0._a0")}).setGranularity((Granularity)new AllGranularity()).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"canada", 4L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testCorrelatedSubqueryWithLeftFilter_leftDirectAccessDisabled(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        this.testQuery("select country, ANY_VALUE(\n        select max(\"users\") from (\n            select floor(__time to day), count(*) \"users\" from visits f where f.country = visits.country group by 1\n        )\n     ) as \"dailyVisits\"\nfrom visits \n where city = 'B' and __time between '2021-01-01 01:00:00' AND '2021-01-02 23:59:59' group by 1", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteCorrelatedQueryTest.join((DataSource)new QueryDataSource((Query)CalciteCorrelatedQueryTest.newScanQueryBuilder().dataSource("visits").intervals(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.of((String)"2021-01-01T01:00:00.000Z/2021-01-02T23:59:59.001Z"))).filters((DimFilter)CalciteCorrelatedQueryTest.selector("city", "B", null)).columns(new String[]{"__time", "city", "country"}).build()), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("visits").setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1D',null,'UTC')", ColumnType.LONG, TestExprMacroTable.INSTANCE)}).setDimFilter((DimFilter)CalciteCorrelatedQueryTest.not((DimFilter)CalciteCorrelatedQueryTest.selector("country", null, null))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("country", "d1")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(this.withTimestampResultContext(queryContext, "d0", Granularities.DAY)).setGranularity((Granularity)new AllGranularity()).build()).setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("d1", "_d0")}).setAggregatorSpecs(new AggregatorFactory[]{new LongMaxAggregatorFactory("_a0", "a0")}).setGranularity((Granularity)new AllGranularity()).setContext(queryContext).build()), "j0.", CalciteCorrelatedQueryTest.equalsCondition(CalciteCorrelatedQueryTest.makeColumnExpression("country"), CalciteCorrelatedQueryTest.makeColumnExpression("j0._d0")), JoinType.LEFT)).setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("country", "d0")}).setAggregatorSpecs(new AggregatorFactory[]{new LongAnyAggregatorFactory("a0", "j0._a0")}).setGranularity((Granularity)new AllGranularity()).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"canada", 4L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testCorrelatedSubqueryWithCorrelatedQueryFilter(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        queryContext = this.withLeftDirectAccessEnabled(queryContext);
        this.testQuery("select country, ANY_VALUE(\n        select max(\"users\") from (\n            select floor(__time to day), count(user) \"users\" from visits f where f.country = visits.country and f.city = 'A' group by 1\n        )\n     ) as \"dailyVisits\"\nfrom visits \n where city = 'B' group by 1", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteCorrelatedQueryTest.join((DataSource)new TableDataSource("visits"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("visits").setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1D',null,'UTC')", ColumnType.LONG, TestExprMacroTable.INSTANCE)}).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("country", "d1")}).setAggregatorSpecs(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteCorrelatedQueryTest.not((DimFilter)CalciteCorrelatedQueryTest.selector("user", null, null)))}).setDimFilter((DimFilter)CalciteCorrelatedQueryTest.and(new DimFilter[]{CalciteCorrelatedQueryTest.selector("city", "A", null), CalciteCorrelatedQueryTest.not((DimFilter)CalciteCorrelatedQueryTest.selector("country", null, null))})).setContext(this.withTimestampResultContext(queryContext, "d0", Granularities.DAY)).setGranularity((Granularity)new AllGranularity()).build()).setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("d1", "_d0")}).setAggregatorSpecs(new AggregatorFactory[]{new LongMaxAggregatorFactory("_a0", "a0")}).setGranularity((Granularity)new AllGranularity()).setContext(queryContext).build()), "j0.", CalciteCorrelatedQueryTest.equalsCondition(CalciteCorrelatedQueryTest.makeColumnExpression("country"), CalciteCorrelatedQueryTest.makeColumnExpression("j0._d0")), JoinType.LEFT, (DimFilter)CalciteCorrelatedQueryTest.selector("city", "B", null))).setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("country", "d0")}).setAggregatorSpecs(new AggregatorFactory[]{new LongAnyAggregatorFactory("a0", "j0._a0")}).setGranularity((Granularity)new AllGranularity()).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"canada", 2L}));
    }

    @Test
    @Parameters(source=BaseCalciteQueryTest.QueryContextForJoinProvider.class)
    public void testCorrelatedSubqueryWithCorrelatedQueryFilter_Scan(Map<String, Object> queryContext) throws Exception {
        this.cannotVectorize();
        queryContext = this.withLeftDirectAccessEnabled(queryContext);
        this.testQuery("select country, ANY_VALUE(\n        select max(\"users\") from (\n            select floor(__time to day), count(user) \"users\" from visits f where f.country = visits.country and f.city = 'A' group by 1\n        )\n     ) as \"dailyVisits\"\nfrom visits \n where city = 'B' group by 1", queryContext, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteCorrelatedQueryTest.join((DataSource)new TableDataSource("visits"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("visits").setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setVirtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1D',null,'UTC')", ColumnType.LONG, TestExprMacroTable.INSTANCE)}).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("country", "d1")}).setAggregatorSpecs(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteCorrelatedQueryTest.not((DimFilter)CalciteCorrelatedQueryTest.selector("user", null, null)))}).setDimFilter((DimFilter)CalciteCorrelatedQueryTest.and(new DimFilter[]{CalciteCorrelatedQueryTest.selector("city", "A", null), CalciteCorrelatedQueryTest.not((DimFilter)CalciteCorrelatedQueryTest.selector("country", null, null))})).setContext(this.withTimestampResultContext(queryContext, "d0", Granularities.DAY)).setGranularity((Granularity)new AllGranularity()).build()).setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("d1", "_d0")}).setAggregatorSpecs(new AggregatorFactory[]{new LongMaxAggregatorFactory("_a0", "a0")}).setGranularity((Granularity)new AllGranularity()).setContext(queryContext).build()), "j0.", CalciteCorrelatedQueryTest.equalsCondition(CalciteCorrelatedQueryTest.makeColumnExpression("country"), CalciteCorrelatedQueryTest.makeColumnExpression("j0._d0")), JoinType.LEFT, (DimFilter)CalciteCorrelatedQueryTest.selector("city", "B", null))).setQuerySegmentSpec(CalciteCorrelatedQueryTest.querySegmentSpec(Intervals.ETERNITY)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("country", "d0")}).setAggregatorSpecs(new AggregatorFactory[]{new LongAnyAggregatorFactory("a0", "j0._a0")}).setGranularity((Granularity)new AllGranularity()).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"canada", 2L}));
    }

    private Map<String, Object> withTimestampResultContext(Map<String, Object> input, String timestampResultField, Granularity granularity) {
        HashMap<String, Object> output = new HashMap<String, Object>(input);
        output.put("timestampResultField", timestampResultField);
        output.put("timestampResultFieldGranularity", granularity);
        output.put("timestampResultFieldInOriginalDimensions", 0);
        return output;
    }
}

