/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionProcessing;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.ExpressionLambdaAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.ExpressionDimFilter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.NoopLimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.topn.DimensionTopNMetricSpec;
import org.apache.druid.query.topn.TopNMetricSpec;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.junit.Assert;
import org.junit.Test;

public class CalciteArraysQueryTest
extends BaseCalciteQueryTest {
    @Test
    public void testSelectConstantArrayExpressionFromTable() throws Exception {
        this.testQuery("SELECT ARRAY[1,2] as arr, dim1 FROM foo LIMIT 1", (List<Query>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array(1,2)", ColumnType.LONG_ARRAY)}).columns(new String[]{"dim1", "v0"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(1L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[1,2]", ""}));
    }

    @Test
    public void testGroupByArrayFromCase() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT CASE WHEN dim4 = 'a' THEN ARRAY['foo','bar','baz'] END as mv_value, count(1) from numfoo GROUP BY 1", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "case_searched((\"dim4\" == 'a'),array('foo','bar','baz'),null)", ColumnType.STRING_ARRAY)}).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING_ARRAY)}).setGranularity(Granularities.ALL).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 3L}, (Object)new Object[]{ImmutableList.of((Object)"foo", (Object)"bar", (Object)"baz"), 3L}));
    }

    @Test
    public void testSelectNonConstantArrayExpressionFromTable() throws Exception {
        this.testQuery("SELECT ARRAY[CONCAT(dim1, 'word'),'up'] as arr, dim1 FROM foo LIMIT 5", (List<Query>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array(concat(\"dim1\",'word'),'up')", ColumnType.STRING_ARRAY)}).columns(new String[]{"dim1", "v0"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"word\",\"up\"]", ""}, (Object)new Object[]{"[\"10.1word\",\"up\"]", "10.1"}, (Object)new Object[]{"[\"2word\",\"up\"]", "2"}, (Object)new Object[]{"[\"1word\",\"up\"]", "1"}, (Object)new Object[]{"[\"defword\",\"up\"]", "def"}));
    }

    @Test
    public void testSelectNonConstantArrayExpressionFromTableForMultival() throws Exception {
        String sql = "SELECT ARRAY[CONCAT(dim3, 'word'),'up'] as arr, dim1 FROM foo LIMIT 5";
        ScanQuery scanQuery = CalciteArraysQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array(concat(\"dim3\",'word'),'up')", ColumnType.STRING_ARRAY)}).columns(new String[]{"dim1", "v0"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build();
        try {
            Object[] objectArray;
            ExpressionProcessing.initializeForTests((Boolean)true);
            ImmutableList immutableList = ImmutableList.of((Object)scanQuery);
            Object[] objectArray2 = new Object[]{"[[\"aword\",\"up\"],[\"bword\",\"up\"]]", ""};
            Object[] objectArray3 = new Object[]{"[[\"bword\",\"up\"],[\"cword\",\"up\"]]", "10.1"};
            Object[] objectArray4 = new Object[]{"[[\"dword\",\"up\"]]", "2"};
            Object[] objectArray5 = new Object[]{"[[\"word\",\"up\"]]", "1"};
            if (this.useDefault) {
                Object[] objectArray6 = new Object[2];
                objectArray6[0] = "[[\"word\",\"up\"]]";
                objectArray = objectArray6;
                objectArray6[1] = "def";
            } else {
                Object[] objectArray7 = new Object[2];
                objectArray7[0] = "[[null,\"up\"]]";
                objectArray = objectArray7;
                objectArray7[1] = "def";
            }
            this.testQuery("SELECT ARRAY[CONCAT(dim3, 'word'),'up'] as arr, dim1 FROM foo LIMIT 5", (List<Query>)immutableList, (List<Object[]>)ImmutableList.of((Object)objectArray2, (Object)objectArray3, (Object)objectArray4, (Object)objectArray5, (Object)objectArray));
        }
        finally {
            ExpressionProcessing.initializeForTests(null);
        }
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Cannot create a nested array type [ARRAY<ARRAY<STRING>>], 'druid.expressions.allowNestedArrays' must be set to true");
        this.testQuery("SELECT ARRAY[CONCAT(dim3, 'word'),'up'] as arr, dim1 FROM foo LIMIT 5", (List<Query>)ImmutableList.of((Object)scanQuery), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testSomeArrayFunctionsWithScanQuery() throws Exception {
        ImmutableList expectedResults = this.useDefault ? ImmutableList.of((Object)new Object[]{"", "a", "[\"a\",\"b\"]", 7L, 0L, 1.0, 0.0, "[\"a\",\"b\",\"c\"]", "[1,2,3]", "[1.9,2.2,4.3]", "[\"a\",\"b\",\"foo\"]", "[\"foo\",\"a\"]", "[1,2,7]", "[0,1,2]", "[1.2,2.2,1.0]", "[0.0,1.1,2.2]", "[\"a\",\"a\",\"b\"]", "[7,0]", "[1.0,0.0]", "7", "1.0", "7", "1.0"}) : ImmutableList.of((Object)new Object[]{"", "a", "[\"a\",\"b\"]", 7L, null, 1.0, null, "[\"a\",\"b\",\"c\"]", "[1,2,3]", "[1.9,2.2,4.3]", "[\"a\",\"b\",\"foo\"]", "[\"foo\",\"a\"]", "[1,2,7]", "[null,1,2]", "[1.2,2.2,1.0]", "[null,1.1,2.2]", "[\"a\",\"a\",\"b\"]", "[7,null]", "[1.0,null]", "7", "1.0", "7", "1.0"});
        this.testQuery("SELECT dim1, dim2, dim3, l1, l2, d1, d2, ARRAY['a', 'b', 'c'], ARRAY[1,2,3], ARRAY[1.9, 2.2, 4.3], ARRAY_APPEND(dim3, 'foo'), ARRAY_PREPEND('foo', ARRAY[dim2]), ARRAY_APPEND(ARRAY[1,2], l1), ARRAY_PREPEND(l2, ARRAY[1,2]), ARRAY_APPEND(ARRAY[1.2,2.2], d1), ARRAY_PREPEND(d2, ARRAY[1.1,2.2]), ARRAY_CONCAT(dim2,dim3), ARRAY_CONCAT(ARRAY[l1],ARRAY[l2]), ARRAY_CONCAT(ARRAY[d1],ARRAY[d2]), ARRAY_OFFSET(ARRAY[l1],0), ARRAY_OFFSET(ARRAY[d1],0), ARRAY_ORDINAL(ARRAY[l1],1), ARRAY_ORDINAL(ARRAY[d1],1) FROM druid.numfoo LIMIT 1", (List<Query>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array('a','b','c')", ColumnType.STRING_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v1", "array(1,2,3)", ColumnType.LONG_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v10", "array_concat(array(\"l1\"),array(\"l2\"))", ColumnType.LONG_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v11", "array_concat(array(\"d1\"),array(\"d2\"))", ColumnType.DOUBLE_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v12", "array_offset(array(\"l1\"),0)", ColumnType.LONG_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v13", "array_offset(array(\"d1\"),0)", ColumnType.DOUBLE_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v14", "array_ordinal(array(\"l1\"),1)", ColumnType.LONG_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v15", "array_ordinal(array(\"d1\"),1)", ColumnType.DOUBLE_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v2", "array(1.9,2.2,4.3)", ColumnType.DOUBLE_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v3", "array_append(\"dim3\",'foo')", ColumnType.STRING_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v4", "array_prepend('foo',array(\"dim2\"))", ColumnType.STRING_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v5", "array_append(array(1,2),\"l1\")", ColumnType.LONG_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v6", "array_prepend(\"l2\",array(1,2))", ColumnType.LONG_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v7", "array_append(array(1.2,2.2),\"d1\")", ColumnType.DOUBLE_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v8", "array_prepend(\"d2\",array(1.1,2.2))", ColumnType.DOUBLE_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v9", "array_concat(\"dim2\",\"dim3\")", ColumnType.STRING_ARRAY)}).columns(new String[]{"d1", "d2", "dim1", "dim2", "dim3", "l1", "l2", "v0", "v1", "v10", "v11", "v12", "v13", "v14", "v15", "v2", "v3", "v4", "v5", "v6", "v7", "v8", "v9"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(1L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expectedResults);
    }

    @Test
    public void testSomeArrayFunctionsWithScanQueryNoStringify() throws Exception {
        ImmutableList expectedResults = this.useDefault ? ImmutableList.of((Object)new Object[]{"", "a", "[\"a\",\"b\"]", Arrays.asList("a", "b", "c"), Arrays.asList(1L, 2L, 3L), Arrays.asList(1.9, 2.2, 4.3), Arrays.asList("a", "b", "foo"), Arrays.asList("foo", "a"), Arrays.asList(1L, 2L, 7L), Arrays.asList(0L, 1L, 2L), Arrays.asList(1.2, 2.2, 1.0), Arrays.asList(0.0, 1.1, 2.2), Arrays.asList("a", "a", "b"), Arrays.asList(7L, 0L), Arrays.asList(1.0, 0.0)}) : ImmutableList.of((Object)new Object[]{"", "a", "[\"a\",\"b\"]", Arrays.asList("a", "b", "c"), Arrays.asList(1L, 2L, 3L), Arrays.asList(1.9, 2.2, 4.3), Arrays.asList("a", "b", "foo"), Arrays.asList("foo", "a"), Arrays.asList(1L, 2L, 7L), Arrays.asList(null, 1L, 2L), Arrays.asList(1.2, 2.2, 1.0), Arrays.asList(null, 1.1, 2.2), Arrays.asList("a", "a", "b"), Arrays.asList(7L, null), Arrays.asList(1.0, null)});
        this.testQuery("SELECT dim1, dim2, dim3, ARRAY['a', 'b', 'c'], ARRAY[1,2,3], ARRAY[1.9, 2.2, 4.3], ARRAY_APPEND(dim3, 'foo'), ARRAY_PREPEND('foo', ARRAY[dim2]), ARRAY_APPEND(ARRAY[1,2], l1), ARRAY_PREPEND(l2, ARRAY[1,2]), ARRAY_APPEND(ARRAY[1.2,2.2], d1), ARRAY_PREPEND(d2, ARRAY[1.1,2.2]), ARRAY_CONCAT(dim2,dim3), ARRAY_CONCAT(ARRAY[l1],ARRAY[l2]), ARRAY_CONCAT(ARRAY[d1],ARRAY[d2]) FROM druid.numfoo LIMIT 1", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array('a','b','c')", ColumnType.STRING_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v1", "array(1,2,3)", ColumnType.LONG_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v10", "array_concat(array(\"l1\"),array(\"l2\"))", ColumnType.LONG_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v11", "array_concat(array(\"d1\"),array(\"d2\"))", ColumnType.DOUBLE_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v2", "array(1.9,2.2,4.3)", ColumnType.DOUBLE_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v3", "array_append(\"dim3\",'foo')", ColumnType.STRING_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v4", "array_prepend('foo',array(\"dim2\"))", ColumnType.STRING_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v5", "array_append(array(1,2),\"l1\")", ColumnType.LONG_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v6", "array_prepend(\"l2\",array(1,2))", ColumnType.LONG_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v7", "array_append(array(1.2,2.2),\"d1\")", ColumnType.DOUBLE_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v8", "array_prepend(\"d2\",array(1.1,2.2))", ColumnType.DOUBLE_ARRAY), CalciteArraysQueryTest.expressionVirtualColumn("v9", "array_concat(\"dim2\",\"dim3\")", ColumnType.STRING_ARRAY)}).columns(new String[]{"dim1", "dim2", "dim3", "v0", "v1", "v10", "v11", "v2", "v3", "v4", "v5", "v6", "v7", "v8", "v9"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(1L).context(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)expectedResults);
    }

    @Test
    public void testArrayOverlapFilter() throws Exception {
        this.testQuery("SELECT dim3 FROM druid.numfoo WHERE ARRAY_OVERLAP(dim3, ARRAY['a','b']) LIMIT 5", (List<Query>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)new InDimFilter("dim3", (Collection)ImmutableList.of((Object)"a", (Object)"b"), null)).columns(new String[]{"dim3"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}, (Object)new Object[]{"[\"b\",\"c\"]"}));
    }

    @Test
    public void testArrayOverlapFilterNonLiteral() throws Exception {
        this.testQuery("SELECT dim3 FROM druid.numfoo WHERE ARRAY_OVERLAP(dim3, ARRAY[dim2]) LIMIT 5", (List<Query>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteArraysQueryTest.expressionFilter("array_overlap(\"dim3\",array(\"dim2\"))")).columns(new String[]{"dim3"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}));
    }

    @Test
    public void testArrayContainsFilter() throws Exception {
        this.testQuery("SELECT dim3 FROM druid.numfoo WHERE ARRAY_CONTAINS(dim3, ARRAY['a','b']) LIMIT 5", (List<Query>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)new AndDimFilter(new DimFilter[]{new SelectorDimFilter("dim3", "a", null), new SelectorDimFilter("dim3", "b", null)})).columns(new String[]{"dim3"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}));
    }

    @Test
    public void testArrayContainsArrayOfOneElement() throws Exception {
        this.testQuery("SELECT dim3 FROM druid.numfoo WHERE ARRAY_CONTAINS(dim3, ARRAY['a']) LIMIT 5", (List<Query>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)new SelectorDimFilter("dim3", "a", null)).columns(new String[]{"dim3"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}));
    }

    @Test
    public void testArrayContainsArrayOfNonLiteral() throws Exception {
        this.testQuery("SELECT dim3 FROM druid.numfoo WHERE ARRAY_CONTAINS(dim3, ARRAY[dim2]) LIMIT 5", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query>)ImmutableList.of((Object)CalciteArraysQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteArraysQueryTest.expressionFilter("array_contains(\"dim3\",array(\"dim2\"))")).columns(new String[]{"dim3"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(5L).context(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]"}));
    }

    @Test
    public void testArraySlice() throws Exception {
        this.testQuery("SELECT ARRAY_SLICE(dim3, 1) FROM druid.numfoo", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query>)ImmutableList.of((Object)new Druids.ScanQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_slice(\"dim3\",1)", ColumnType.STRING_ARRAY)}).columns((List)ImmutableList.of((Object)"v0")).context(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Collections.singletonList("b")}, (Object)new Object[]{Collections.singletonList("c")}, (Object)new Object[]{Collections.emptyList()}, (Object)new Object[]{this.useDefault ? null : Collections.emptyList()}, (Object)new Object[]{null}, (Object)new Object[]{null}));
    }

    @Test
    public void testArrayLength() throws Exception {
        Object[] objectArray;
        Object[] objectArray2;
        this.cannotVectorize();
        ImmutableList immutableList = ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_length(\"dim3\")", ColumnType.LONG)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "_d0", ColumnType.STRING), new DefaultDimensionSpec("v0", "_d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("_d1", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build());
        Object[] objectArray3 = new Object[]{"", 2, 1L};
        Object[] objectArray4 = new Object[]{"10.1", 2, 1L};
        if (this.useDefault) {
            Object[] objectArray5 = new Object[3];
            objectArray5[0] = "2";
            objectArray5[1] = 1;
            objectArray2 = objectArray5;
            objectArray5[2] = 1L;
        } else {
            Object[] objectArray6 = new Object[3];
            objectArray6[0] = "1";
            objectArray6[1] = 1;
            objectArray2 = objectArray6;
            objectArray6[2] = 1L;
        }
        if (this.useDefault) {
            Object[] objectArray7 = new Object[3];
            objectArray7[0] = "1";
            objectArray7[1] = 0;
            objectArray = objectArray7;
            objectArray7[2] = 1L;
        } else {
            Object[] objectArray8 = new Object[3];
            objectArray8[0] = "2";
            objectArray8[1] = 1;
            objectArray = objectArray8;
            objectArray8[2] = 1L;
        }
        this.testQuery("SELECT dim1, ARRAY_LENGTH(dim3), SUM(cnt) FROM druid.numfoo GROUP BY 1, 2 ORDER BY 2 DESC", (List<Query>)immutableList, (List<Object[]>)ImmutableList.of((Object)objectArray3, (Object)objectArray4, (Object)objectArray2, (Object)objectArray, (Object)new Object[]{"abc", this.useDefault ? Integer.valueOf(0) : null, 1L}, (Object)new Object[]{"def", this.useDefault ? Integer.valueOf(0) : null, 1L}));
    }

    @Test
    public void testArrayAppend() throws Exception {
        this.cannotVectorize();
        ImmutableList results = this.useDefault ? ImmutableList.of((Object)new Object[]{null, 3L}, (Object)new Object[]{ImmutableList.of((Object)"a", (Object)"b", (Object)"foo"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"b", (Object)"c", (Object)"foo"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"d", (Object)"foo"), 1L}) : ImmutableList.of((Object)new Object[]{null, 2L}, (Object)new Object[]{ImmutableList.of((Object)"", (Object)"foo"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"a", (Object)"b", (Object)"foo"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"b", (Object)"c", (Object)"foo"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"d", (Object)"foo"), 1L});
        this.testQuery("SELECT ARRAY_APPEND(dim3, 'foo'), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_append(\"dim3\",'foo')", ColumnType.STRING_ARRAY)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING_ARRAY)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)results);
    }

    @Test
    public void testArrayPrepend() throws Exception {
        this.cannotVectorize();
        ImmutableList results = this.useDefault ? ImmutableList.of((Object)new Object[]{null, 3L}, (Object)new Object[]{ImmutableList.of((Object)"foo", (Object)"a", (Object)"b"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"foo", (Object)"b", (Object)"c"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"foo", (Object)"d"), 1L}) : ImmutableList.of((Object)new Object[]{null, 2L}, (Object)new Object[]{ImmutableList.of((Object)"foo", (Object)""), 1L}, (Object)new Object[]{ImmutableList.of((Object)"foo", (Object)"a", (Object)"b"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"foo", (Object)"b", (Object)"c"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"foo", (Object)"d"), 1L});
        this.testQuery("SELECT ARRAY_PREPEND('foo', dim3), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_prepend('foo',\"dim3\")", ColumnType.STRING_ARRAY)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING_ARRAY)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)results);
    }

    @Test
    public void testArrayPrependAppend() throws Exception {
        this.cannotVectorize();
        ImmutableList results = this.useDefault ? ImmutableList.of((Object)new Object[]{"", "", 3L}, (Object)new Object[]{"foo,a,b", "a,b,foo", 1L}, (Object)new Object[]{"foo,b,c", "b,c,foo", 1L}, (Object)new Object[]{"foo,d", "d,foo", 1L}) : ImmutableList.of((Object)new Object[]{null, null, 2L}, (Object)new Object[]{"foo,", ",foo", 1L}, (Object)new Object[]{"foo,a,b", "a,b,foo", 1L}, (Object)new Object[]{"foo,b,c", "b,c,foo", 1L}, (Object)new Object[]{"foo,d", "d,foo", 1L});
        this.testQuery("SELECT ARRAY_TO_STRING(ARRAY_PREPEND('foo', dim3), ','), ARRAY_TO_STRING(ARRAY_APPEND(dim3, 'foo'), ','), SUM(cnt) FROM druid.numfoo GROUP BY 1,2 ORDER BY 3 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_to_string(array_prepend('foo',\"dim3\"),',')", ColumnType.STRING), CalciteArraysQueryTest.expressionVirtualColumn("v1", "array_to_string(array_append(\"dim3\",'foo'),',')", ColumnType.STRING)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING), new DefaultDimensionSpec("v1", "_d1", ColumnType.STRING)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)results);
    }

    @Test
    public void testArrayConcat() throws Exception {
        this.cannotVectorize();
        ImmutableList results = this.useDefault ? ImmutableList.of((Object)new Object[]{null, 3L}, (Object)new Object[]{ImmutableList.of((Object)"a", (Object)"b", (Object)"a", (Object)"b"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"b", (Object)"c", (Object)"b", (Object)"c"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"d", (Object)"d"), 1L}) : ImmutableList.of((Object)new Object[]{null, 2L}, (Object)new Object[]{ImmutableList.of((Object)"", (Object)""), 1L}, (Object)new Object[]{ImmutableList.of((Object)"a", (Object)"b", (Object)"a", (Object)"b"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"b", (Object)"c", (Object)"b", (Object)"c"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"d", (Object)"d"), 1L});
        this.testQuery("SELECT ARRAY_CONCAT(dim3, dim3), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_concat(\"dim3\",\"dim3\")", ColumnType.STRING_ARRAY)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING_ARRAY)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)results);
    }

    @Test
    public void testArrayOffset() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT ARRAY_OFFSET(dim3, 1), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_offset(\"dim3\",1)", ColumnType.STRING)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{NullHandling.defaultStringValue(), 4L}, (Object)new Object[]{"b", 1L}, (Object)new Object[]{"c", 1L}));
    }

    @Test
    public void testArrayGroupAsLongArray() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT ARRAY[l1], SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array(\"l1\")", ColumnType.LONG_ARRAY)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.LONG_ARRAY)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)(this.useDefault ? ImmutableList.of((Object)new Object[]{ImmutableList.of((Object)0L), 4L}, (Object)new Object[]{ImmutableList.of((Object)7L), 1L}, (Object)new Object[]{ImmutableList.of((Object)325323L), 1L}) : ImmutableList.of((Object)new Object[]{Collections.singletonList(null), 3L}, (Object)new Object[]{ImmutableList.of((Object)0L), 1L}, (Object)new Object[]{ImmutableList.of((Object)7L), 1L}, (Object)new Object[]{ImmutableList.of((Object)325323L), 1L})));
    }

    @Test
    public void testArrayGroupAsDoubleArray() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT ARRAY[d1], SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array(\"d1\")", ColumnType.DOUBLE_ARRAY)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.DOUBLE_ARRAY)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)(this.useDefault ? ImmutableList.of((Object)new Object[]{ImmutableList.of((Object)0.0), 4L}, (Object)new Object[]{ImmutableList.of((Object)1.0), 1L}, (Object)new Object[]{ImmutableList.of((Object)1.7), 1L}) : ImmutableList.of((Object)new Object[]{Collections.singletonList(null), 3L}, (Object)new Object[]{ImmutableList.of((Object)0.0), 1L}, (Object)new Object[]{ImmutableList.of((Object)1.0), 1L}, (Object)new Object[]{ImmutableList.of((Object)1.7), 1L})));
    }

    @Test
    public void testArrayGroupAsFloatArray() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT ARRAY[f1], SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array(\"f1\")", ColumnType.ofArray((ColumnType)ColumnType.FLOAT))}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.ofArray((ColumnType)ColumnType.FLOAT))})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)(this.useDefault ? ImmutableList.of((Object)new Object[]{ImmutableList.of((Object)Float.valueOf(0.0f)), 4L}, (Object)new Object[]{ImmutableList.of((Object)Float.valueOf(0.1f)), 1L}, (Object)new Object[]{ImmutableList.of((Object)Float.valueOf(1.0f)), 1L}) : ImmutableList.of((Object)new Object[]{Collections.singletonList(null), 3L}, (Object)new Object[]{ImmutableList.of((Object)Float.valueOf(0.0f)), 1L}, (Object)new Object[]{ImmutableList.of((Object)Float.valueOf(0.1f)), 1L}, (Object)new Object[]{ImmutableList.of((Object)Float.valueOf(1.0f)), 1L})));
    }

    @Test
    public void testArrayGroupAsArrayWithFunction() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT ARRAY[ARRAY_ORDINAL(dim3, 2)], SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array(array_ordinal(\"dim3\",2))", ColumnType.STRING_ARRAY)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING_ARRAY)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Collections.singletonList(null), 4L}, (Object)new Object[]{ImmutableList.of((Object)"b"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"c"), 1L}));
    }

    @Test
    public void testArrayOrdinal() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT ARRAY_ORDINAL(dim3, 2), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_ordinal(\"dim3\",2)", ColumnType.STRING)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{NullHandling.defaultStringValue(), 4L}, (Object)new Object[]{"b", 1L}, (Object)new Object[]{"c", 1L}));
    }

    @Test
    public void testArrayOffsetOf() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT ARRAY_OFFSET_OF(dim3, 'b'), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_offset_of(\"dim3\",'b')", ColumnType.LONG)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(this.useDefault ? ImmutableList.of((Object)new Object[]{0, 4L}, (Object)new Object[]{-1, 1L}, (Object)new Object[]{1, 1L}) : ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{0, 1L}, (Object)new Object[]{1, 1L})));
    }

    @Test
    public void testArrayOrdinalOf() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT ARRAY_ORDINAL_OF(dim3, 'b'), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_ordinal_of(\"dim3\",'b')", ColumnType.LONG)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)(this.useDefault ? ImmutableList.of((Object)new Object[]{0, 3L}, (Object)new Object[]{-1, 1L}, (Object)new Object[]{1, 1L}, (Object)new Object[]{2, 1L}) : ImmutableList.of((Object)new Object[]{null, 4L}, (Object)new Object[]{1, 1L}, (Object)new Object[]{2, 1L})));
    }

    @Test
    public void testArrayToString() throws Exception {
        this.cannotVectorize();
        ImmutableList results = this.useDefault ? ImmutableList.of((Object)new Object[]{"", 3L}, (Object)new Object[]{"a,b", 1L}, (Object)new Object[]{"b,c", 1L}, (Object)new Object[]{"d", 1L}) : ImmutableList.of((Object)new Object[]{null, 2L}, (Object)new Object[]{"", 1L}, (Object)new Object[]{"a,b", 1L}, (Object)new Object[]{"b,c", 1L}, (Object)new Object[]{"d", 1L});
        this.testQuery("SELECT ARRAY_TO_STRING(dim3, ','), SUM(cnt) FROM druid.numfoo GROUP BY 1 ORDER BY 2 DESC", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_to_string(\"dim3\",',')", ColumnType.STRING)}).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)results);
    }

    @Test
    public void testArrayToStringToMultiValueString() throws Exception {
        this.cannotVectorize();
        ImmutableList results = this.useDefault ? ImmutableList.of((Object)new Object[]{ImmutableList.of((Object)"a", (Object)"b", (Object)"d"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"b", (Object)"c", (Object)"d"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"d", (Object)"d"), 1L}) : ImmutableList.of((Object)new Object[]{ImmutableList.of((Object)"", (Object)"d"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"a", (Object)"b", (Object)"d"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"b", (Object)"c", (Object)"d"), 1L}, (Object)new Object[]{ImmutableList.of((Object)"d", (Object)"d"), 1L});
        this.testQuery("SELECT STRING_TO_ARRAY(CONCAT(ARRAY_TO_STRING(dim3, ','), ',d'), ','), SUM(cnt) FROM druid.numfoo WHERE ARRAY_LENGTH(dim3) > 0 GROUP BY 1 ORDER BY 2 DESC", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_length(\"dim3\")", ColumnType.LONG), CalciteArraysQueryTest.expressionVirtualColumn("v1", "string_to_array(concat(array_to_string(\"dim3\",','),',d'),',')", ColumnType.STRING_ARRAY)}).setDimFilter((DimFilter)CalciteArraysQueryTest.bound("v0", "0", null, true, false, null, StringComparators.NUMERIC)).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v1", "_d0", ColumnType.STRING_ARRAY)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("a0", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)results);
    }

    @Test
    public void testArrayAgg() throws Exception {
        Object[] objectArray;
        this.cannotVectorize();
        ImmutableList immutableList = ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteArraysQueryTest.not((DimFilter)CalciteArraysQueryTest.selector("dim1", null, null))).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"dim1"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"dim1\")", "array_concat(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"dim1"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim1\")", "array_set_add_all(\"__acc\", \"a1\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new FilteredAggregatorFactory((AggregatorFactory)new ExpressionLambdaAggregatorFactory("a2", (Set)ImmutableSet.of((Object)"dim1"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim1\")", "array_set_add_all(\"__acc\", \"a2\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), (DimFilter)CalciteArraysQueryTest.selector("dim1", "shazbot", null))})).context(QUERY_CONTEXT_DEFAULT).build());
        if (this.useDefault) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "[\"10.1\",\"2\",\"1\",\"def\",\"abc\"]";
            objectArray2[1] = "[\"1\",\"10.1\",\"2\",\"abc\",\"def\"]";
            objectArray = objectArray2;
            objectArray2[2] = null;
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = "[\"\",\"10.1\",\"2\",\"1\",\"def\",\"abc\"]";
            objectArray3[1] = "[\"\",\"1\",\"10.1\",\"2\",\"abc\",\"def\"]";
            objectArray = objectArray3;
            objectArray3[2] = null;
        }
        this.testQuery("SELECT ARRAY_AGG(dim1), ARRAY_AGG(DISTINCT dim1), ARRAY_AGG(DISTINCT dim1) FILTER(WHERE dim1 = 'shazbot') FROM foo WHERE dim1 is not null", (List<Query>)immutableList, (List<Object[]>)ImmutableList.of((Object)objectArray));
    }

    @Test
    public void testArrayAggMultiValue() throws Exception {
        Object[] objectArray;
        this.cannotVectorize();
        ImmutableList immutableList = ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"dim3"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"dim3\")", "array_concat(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"dim3"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim3\")", "array_set_add_all(\"__acc\", \"a1\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE)})).context(QUERY_CONTEXT_DEFAULT).build());
        if (this.useDefault) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "[\"a\",\"b\",\"b\",\"c\",\"d\",null,null,null]";
            objectArray = objectArray2;
            objectArray2[1] = "[null,\"a\",\"b\",\"c\",\"d\"]";
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = "[\"a\",\"b\",\"b\",\"c\",\"d\",\"\",null,null]";
            objectArray = objectArray3;
            objectArray3[1] = "[null,\"\",\"a\",\"b\",\"c\",\"d\"]";
        }
        this.testQuery("SELECT ARRAY_AGG(dim3), ARRAY_AGG(DISTINCT dim3) FROM foo", (List<Query>)immutableList, (List<Object[]>)ImmutableList.of((Object)objectArray));
    }

    @Test
    public void testArrayAggNumeric() throws Exception {
        Object[] objectArray;
        this.cannotVectorize();
        ImmutableList immutableList = ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"l1"), "__acc", "ARRAY<LONG>[]", "ARRAY<LONG>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"l1\")", "array_concat(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"l1"), "__acc", "ARRAY<LONG>[]", "ARRAY<LONG>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"l1\")", "array_set_add_all(\"__acc\", \"a1\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("a2", (Set)ImmutableSet.of((Object)"d1"), "__acc", "ARRAY<DOUBLE>[]", "ARRAY<DOUBLE>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"d1\")", "array_concat(\"__acc\", \"a2\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("a3", (Set)ImmutableSet.of((Object)"d1"), "__acc", "ARRAY<DOUBLE>[]", "ARRAY<DOUBLE>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"d1\")", "array_set_add_all(\"__acc\", \"a3\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("a4", (Set)ImmutableSet.of((Object)"f1"), "__acc", "ARRAY<DOUBLE>[]", "ARRAY<DOUBLE>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"f1\")", "array_concat(\"__acc\", \"a4\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("a5", (Set)ImmutableSet.of((Object)"f1"), "__acc", "ARRAY<DOUBLE>[]", "ARRAY<DOUBLE>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"f1\")", "array_set_add_all(\"__acc\", \"a5\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE)})).context(QUERY_CONTEXT_DEFAULT).build());
        if (this.useDefault) {
            Object[] objectArray2 = new Object[6];
            objectArray2[0] = "[7,325323,0,0,0,0]";
            objectArray2[1] = "[0,7,325323]";
            objectArray2[2] = "[1.0,1.7,0.0,0.0,0.0,0.0]";
            objectArray2[3] = "[0.0,1.0,1.7]";
            objectArray2[4] = "[1.0,0.10000000149011612,0.0,0.0,0.0,0.0]";
            objectArray = objectArray2;
            objectArray2[5] = "[0.0,0.10000000149011612,1.0]";
        } else {
            Object[] objectArray3 = new Object[6];
            objectArray3[0] = "[7,325323,0,null,null,null]";
            objectArray3[1] = "[null,0,7,325323]";
            objectArray3[2] = "[1.0,1.7,0.0,null,null,null]";
            objectArray3[3] = "[null,0.0,1.0,1.7]";
            objectArray3[4] = "[1.0,0.10000000149011612,0.0,null,null,null]";
            objectArray = objectArray3;
            objectArray3[5] = "[null,0.0,0.10000000149011612,1.0]";
        }
        this.testQuery("SELECT ARRAY_AGG(l1), ARRAY_AGG(DISTINCT l1), ARRAY_AGG(d1), ARRAY_AGG(DISTINCT d1), ARRAY_AGG(f1), ARRAY_AGG(DISTINCT f1) FROM numfoo", (List<Query>)immutableList, (List<Object[]>)ImmutableList.of((Object)objectArray));
    }

    @Test
    public void testArrayAggArrays() throws Exception {
        try {
            ExpressionProcessing.initializeForTests((Boolean)true);
            this.cannotVectorize();
            this.testQuery("SELECT ARRAY_AGG(ARRAY[l1, l2]), ARRAY_AGG(DISTINCT ARRAY[l1, l2]) FROM numfoo", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array(\"l1\",\"l2\")", ColumnType.LONG_ARRAY)}).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"v0"), "__acc", "ARRAY<ARRAY<LONG>>[]", "ARRAY<ARRAY<LONG>>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"v0\")", "array_concat(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"v0"), "__acc", "ARRAY<ARRAY<LONG>>[]", "ARRAY<ARRAY<LONG>>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"v0\")", "array_set_add_all(\"__acc\", \"a1\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE)})).context(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (String sql, List<Object[]> results) -> {
                Object[] objectArray;
                if (this.useDefault) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = Arrays.asList(Arrays.asList(7L, 0L), Arrays.asList(325323L, 325323L), Arrays.asList(0L, 0L), Arrays.asList(0L, 0L), Arrays.asList(0L, 0L), Arrays.asList(0L, 0L));
                    objectArray = objectArray2;
                    objectArray2[1] = Arrays.asList(Arrays.asList(0L, 0L), Arrays.asList(7L, 0L), Arrays.asList(325323L, 325323L));
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = Arrays.asList(Arrays.asList(7L, null), Arrays.asList(325323L, 325323L), Arrays.asList(0L, 0L), Arrays.asList(null, null), Arrays.asList(null, null), Arrays.asList(null, null));
                    objectArray = objectArray3;
                    objectArray3[1] = Arrays.asList(Arrays.asList(null, null), Arrays.asList(0L, 0L), Arrays.asList(7L, null), Arrays.asList(325323L, 325323L));
                }
                ImmutableList expected = ImmutableList.of((Object)objectArray);
                CalciteArraysQueryTest.assertResultsDeepEquals(sql, (List<Object[]>)expected, results);
            });
        }
        finally {
            ExpressionProcessing.initializeForTests(null);
        }
    }

    @Test
    public void testArrayAggArraysNoNest() throws Exception {
        this.cannotVectorize();
        this.testQueryThrows("SELECT ARRAY_AGG(ARRAY[l1, l2]), ARRAY_AGG(DISTINCT ARRAY[l1, l2]) FROM numfoo", QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array(\"l1\",\"l2\")", ColumnType.LONG_ARRAY)}).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"v0"), "__acc", "ARRAY<ARRAY<LONG>>[]", "ARRAY<ARRAY<LONG>>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"v0\")", "array_concat(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"v0"), "__acc", "ARRAY<ARRAY<LONG>>[]", "ARRAY<ARRAY<LONG>>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"v0\")", "array_set_add_all(\"__acc\", \"a1\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE)})).context(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), expected -> {
            expected.expect(IAE.class);
            expected.expectMessage("Cannot create a nested array type [ARRAY<ARRAY<LONG>>], 'druid.expressions.allowNestedArrays' must be set to true");
        });
    }

    @Test
    public void testArrayConcatAggArrays() throws Exception {
        Object[] objectArray;
        this.cannotVectorize();
        ImmutableList immutableList = ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array(\"l1\",\"l2\")", ColumnType.LONG_ARRAY)}).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"v0"), "__acc", "ARRAY<LONG>[]", "ARRAY<LONG>[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_concat(\"__acc\", \"v0\")", "array_concat(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"v0"), "__acc", "ARRAY<LONG>[]", "ARRAY<LONG>[]", Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), "array_set_add_all(\"__acc\", \"v0\")", "array_set_add_all(\"__acc\", \"a1\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE)})).context(QUERY_CONTEXT_DEFAULT).build());
        if (this.useDefault) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "[7,0,325323,325323,0,0,0,0,0,0,0,0]";
            objectArray = objectArray2;
            objectArray2[1] = "[0,7,325323]";
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = "[7,null,325323,325323,0,0,null,null,null,null,null,null]";
            objectArray = objectArray3;
            objectArray3[1] = "[null,0,7,325323]";
        }
        this.testQuery("SELECT ARRAY_CONCAT_AGG(ARRAY[l1, l2]), ARRAY_CONCAT_AGG(DISTINCT ARRAY[l1, l2]) FROM numfoo", (List<Query>)immutableList, (List<Object[]>)ImmutableList.of((Object)objectArray));
    }

    @Test
    public void testArrayAggToString() throws Exception {
        Object[] objectArray;
        this.cannotVectorize();
        ImmutableList immutableList = ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteArraysQueryTest.not((DimFilter)CalciteArraysQueryTest.selector("dim1", null, null))).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"dim1"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim1\")", "array_set_add_all(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE)})).postAggregators(new PostAggregator[]{CalciteArraysQueryTest.expressionPostAgg("p0", "array_to_string(\"a0\",',')")}).context(QUERY_CONTEXT_DEFAULT).build());
        if (this.useDefault) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = "1,10.1,2,abc,def";
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = ",1,10.1,2,abc,def";
        }
        this.testQuery("SELECT ARRAY_TO_STRING(ARRAY_AGG(DISTINCT dim1), ',') FROM foo WHERE dim1 is not null", (List<Query>)immutableList, (List<Object[]>)ImmutableList.of((Object)objectArray));
    }

    @Test
    public void testArrayAggExpression() throws Exception {
        Object[] objectArray;
        this.cannotVectorize();
        ImmutableList immutableList = ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "concat(\"dim1\",\"dim2\")", ColumnType.STRING)}).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"v0"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"v0\")", "array_set_add_all(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE)})).postAggregators(new PostAggregator[]{CalciteArraysQueryTest.expressionPostAgg("p0", "array_to_string(\"a0\",',')")}).context(QUERY_CONTEXT_DEFAULT).build());
        if (this.useDefault) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = "10.1,1a,2,a,abc,defabc";
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = "null,1a,2,a,defabc";
        }
        this.testQuery("SELECT ARRAY_TO_STRING(ARRAY_AGG(DISTINCT CONCAT(dim1, dim2)), ',') FROM foo", (List<Query>)immutableList, (List<Object[]>)ImmutableList.of((Object)objectArray));
    }

    @Test
    public void testArrayAggMaxBytes() throws Exception {
        Object[] objectArray;
        this.cannotVectorize();
        ImmutableList immutableList = ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("numfoo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"l1"), "__acc", "ARRAY<LONG>[]", "ARRAY<LONG>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"l1\")", "array_concat(\"__acc\", \"a0\")", null, null, new HumanReadableBytes(128L), TestExprMacroTable.INSTANCE), new ExpressionLambdaAggregatorFactory("a1", (Set)ImmutableSet.of((Object)"l1"), "__acc", "ARRAY<LONG>[]", "ARRAY<LONG>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"l1\")", "array_set_add_all(\"__acc\", \"a1\")", null, null, new HumanReadableBytes(128L), TestExprMacroTable.INSTANCE)})).context(QUERY_CONTEXT_DEFAULT).build());
        if (this.useDefault) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "[7,325323,0,0,0,0]";
            objectArray = objectArray2;
            objectArray2[1] = "[0,7,325323]";
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = "[7,325323,0,null,null,null]";
            objectArray = objectArray3;
            objectArray3[1] = "[null,0,7,325323]";
        }
        this.testQuery("SELECT ARRAY_AGG(l1, 128), ARRAY_AGG(DISTINCT l1, 128) FROM numfoo", (List<Query>)immutableList, (List<Object[]>)ImmutableList.of((Object)objectArray));
    }

    @Test
    public void testArrayAggAsArrayFromJoin() throws Exception {
        this.cannotVectorize();
        ImmutableList expectedResults = this.useDefault ? ImmutableList.of((Object)new Object[]{"a", "[\"10.1\",\"2\"]", "10.1,2"}, (Object)new Object[]{"a", "[\"10.1\",\"2\"]", "10.1,2"}, (Object)new Object[]{"a", "[\"10.1\",\"2\"]", "10.1,2"}, (Object)new Object[]{"b", "[\"1\",\"abc\",\"def\"]", "1,abc,def"}, (Object)new Object[]{"b", "[\"1\",\"abc\",\"def\"]", "1,abc,def"}, (Object)new Object[]{"b", "[\"1\",\"abc\",\"def\"]", "1,abc,def"}) : ImmutableList.of((Object)new Object[]{"a", "[\"\",\"10.1\",\"2\"]", ",10.1,2"}, (Object)new Object[]{"a", "[\"\",\"10.1\",\"2\"]", ",10.1,2"}, (Object)new Object[]{"a", "[\"\",\"10.1\",\"2\"]", ",10.1,2"}, (Object)new Object[]{"b", "[\"1\",\"abc\",\"def\"]", "1,abc,def"}, (Object)new Object[]{"b", "[\"1\",\"abc\",\"def\"]", "1,abc,def"}, (Object)new Object[]{"b", "[\"1\",\"abc\",\"def\"]", "1,abc,def"});
        this.testQuery("SELECT numfoo.dim4, j.arr, ARRAY_TO_STRING(j.arr, ',') FROM numfoo INNER JOIN (SELECT dim4, ARRAY_AGG(DISTINCT dim1) as arr FROM numfoo WHERE dim1 is not null GROUP BY 1) as j ON numfoo.dim4 = j.dim4", (List<Query>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)CalciteArraysQueryTest.join((DataSource)new TableDataSource("numfoo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("numfoo").setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteArraysQueryTest.not((DimFilter)CalciteArraysQueryTest.selector("dim1", null, null))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim4", "_d0")}).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"dim1"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim1\")", "array_set_add_all(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE)})).setContext(QUERY_CONTEXT_DEFAULT).build()), "j0.", "(\"dim4\" == \"j0._d0\")", JoinType.INNER, null)).virtualColumns(new VirtualColumn[]{CalciteArraysQueryTest.expressionVirtualColumn("v0", "array_to_string(\"j0.a0\",',')", ColumnType.STRING)}).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim4", "j0.a0", "v0"}).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false)).build()), (List<Object[]>)expectedResults);
    }

    @Test
    public void testArrayAggGroupByArrayAggFromSubquery() throws Exception {
        this.cannotVectorize();
        this.testQuery("SELECT dim2, arr, COUNT(*) FROM (SELECT dim2, ARRAY_AGG(DISTINCT dim1) as arr FROM foo WHERE dim1 is not null GROUP BY 1 LIMIT 5) GROUP BY 1,2", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)new TopNQuery((DataSource)new TableDataSource("foo"), null, (DimensionSpec)new DefaultDimensionSpec("dim2", "d0", ColumnType.STRING), (TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC), 5, CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity()), (DimFilter)new NotDimFilter((DimFilter)new SelectorDimFilter("dim1", null, null)), Granularities.ALL, CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"dim1"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim1\")", "array_set_add_all(\"__acc\", \"a0\")", null, null, new HumanReadableBytes(1024L), ExprMacroTable.nil())}), null, QUERY_CONTEXT_NO_STRINGIFY_ARRAY)).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter(null).setGranularity(Granularities.ALL).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("d0", "_d0", ColumnType.STRING), new DefaultDimensionSpec("a0", "_d1", ColumnType.STRING_ARRAY)})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("_a0")})).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).build()), (List<Object[]>)(this.useDefault ? ImmutableList.of((Object)new Object[]{"", ImmutableList.of((Object)"10.1", (Object)"2", (Object)"abc"), 1L}, (Object)new Object[]{"a", ImmutableList.of((Object)"1"), 1L}, (Object)new Object[]{"abc", ImmutableList.of((Object)"def"), 1L}) : ImmutableList.of((Object)new Object[]{null, ImmutableList.of((Object)"10.1", (Object)"abc"), 1L}, (Object)new Object[]{"", ImmutableList.of((Object)"2"), 1L}, (Object)new Object[]{"a", ImmutableList.of((Object)"", (Object)"1"), 1L}, (Object)new Object[]{"abc", ImmutableList.of((Object)"def"), 1L})));
    }

    @Test
    public void testArrayAggGroupByArrayAggOfLongsFromSubquery() throws Exception {
        this.requireMergeBuffers(3);
        this.cannotVectorize();
        this.testQuery("select cntarray, count(*) from ( select dim1, dim2, ARRAY_AGG(cnt) as cntarray from ( select dim1, dim2, dim3, count(*) as cnt from foo group by 1, 2, 3 ) group by 1, 2 ) group by 1", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new TableDataSource("foo")).setQuerySegmentSpec(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1"), new DefaultDimensionSpec("dim3", "d2")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).build())).setQuerySegmentSpec(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("d0", "_d0"), new DefaultDimensionSpec("d1", "_d1")}).setAggregatorSpecs(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("_a0", (Set)ImmutableSet.of((Object)"a0"), "__acc", "ARRAY<LONG>[]", "ARRAY<LONG>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"a0\")", "array_concat(\"__acc\", \"_a0\")", null, null, new HumanReadableBytes(1024L), ExprMacroTable.nil())}).build())).setQuerySegmentSpec(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("_a0", "d0", ColumnType.LONG_ARRAY)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{ImmutableList.of((Object)1L), 4L}, (Object)new Object[]{ImmutableList.of((Object)1L, (Object)1L), 2L}));
    }

    @Test
    public void testArrayAggGroupByArrayAggOfStringsFromSubquery() throws Exception {
        this.requireMergeBuffers(3);
        this.cannotVectorize();
        this.testQuery("select cntarray, count(*) from ( select dim1, dim2, ARRAY_AGG(cnt) as cntarray from ( select dim1, dim2, dim3, cast( count(*) as VARCHAR ) as cnt from foo group by 1, 2, 3 ) group by 1, 2 ) group by 1", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new TableDataSource("foo")).setQuerySegmentSpec(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1"), new DefaultDimensionSpec("dim3", "d2")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).build())).setQuerySegmentSpec(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("d0", "_d0"), new DefaultDimensionSpec("d1", "_d1")}).setAggregatorSpecs(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("_a0", (Set)ImmutableSet.of((Object)"a0"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"a0\")", "array_concat(\"__acc\", \"_a0\")", null, null, new HumanReadableBytes(1024L), ExprMacroTable.nil())}).build())).setQuerySegmentSpec(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("_a0", "d0", ColumnType.STRING_ARRAY)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{ImmutableList.of((Object)"1"), 4L}, (Object)new Object[]{ImmutableList.of((Object)"1", (Object)"1"), 2L}));
    }

    @Test
    public void testArrayAggGroupByArrayAggOfDoubleFromSubquery() throws Exception {
        this.requireMergeBuffers(3);
        this.cannotVectorize();
        this.testQuery("select cntarray, count(*) from ( select dim1, dim2, ARRAY_AGG(cnt) as cntarray from ( select dim1, dim2, dim3, cast( count(*) as DOUBLE ) as cnt from foo group by 1, 2, 3 ) group by 1, 2 ) group by 1", (Map<String, Object>)QUERY_CONTEXT_NO_STRINGIFY_ARRAY, (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new TableDataSource("foo")).setQuerySegmentSpec(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1"), new DefaultDimensionSpec("dim3", "d2")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).build())).setQuerySegmentSpec(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("d0", "_d0"), new DefaultDimensionSpec("d1", "_d1")}).setAggregatorSpecs(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("_a0", (Set)ImmutableSet.of((Object)"a0"), "__acc", "ARRAY<DOUBLE>[]", "ARRAY<DOUBLE>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_append(\"__acc\", \"a0\")", "array_concat(\"__acc\", \"_a0\")", null, null, new HumanReadableBytes(1024L), ExprMacroTable.nil())}).build())).setQuerySegmentSpec(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setContext(QUERY_CONTEXT_NO_STRINGIFY_ARRAY).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("_a0", "d0", ColumnType.DOUBLE_ARRAY)}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{ImmutableList.of((Object)1.0), 4L}, (Object)new Object[]{ImmutableList.of((Object)1.0, (Object)1.0), 2L}));
    }

    @Test
    public void testArrayAggArrayContainsSubquery() throws Exception {
        this.cannotVectorize();
        ImmutableList expectedResults = this.useDefault ? ImmutableList.of((Object)new Object[]{"10.1", ""}, (Object)new Object[]{"2", ""}, (Object)new Object[]{"1", "a"}, (Object)new Object[]{"def", "abc"}, (Object)new Object[]{"abc", ""}) : ImmutableList.of((Object)new Object[]{"", "a"}, (Object)new Object[]{"10.1", null}, (Object)new Object[]{"2", ""}, (Object)new Object[]{"1", "a"}, (Object)new Object[]{"def", "abc"}, (Object)new Object[]{"abc", null});
        this.testQuery("SELECT dim1,dim2 FROM foo WHERE ARRAY_CONTAINS((SELECT ARRAY_AGG(DISTINCT dim1) FROM foo WHERE dim1 is not null), dim1)", (List<Query>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)CalciteArraysQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteArraysQueryTest.not((DimFilter)CalciteArraysQueryTest.selector("dim1", null, null))).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"dim1"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim1\")", "array_set_add_all(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE)})).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", "1", JoinType.LEFT, null)).intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)new ExpressionDimFilter("array_contains(\"j0.a0\",\"dim1\")", TestExprMacroTable.INSTANCE)).columns(new String[]{"dim1", "dim2"}).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false)).build()), (List<Object[]>)expectedResults);
    }

    @Test
    public void testArrayAggGroupByArrayContainsSubquery() throws Exception {
        this.cannotVectorize();
        ImmutableList expectedResults = this.useDefault ? ImmutableList.of((Object)new Object[]{"", 3L}, (Object)new Object[]{"a", 1L}, (Object)new Object[]{"abc", 1L}) : ImmutableList.of((Object)new Object[]{null, 2L}, (Object)new Object[]{"", 1L}, (Object)new Object[]{"a", 2L}, (Object)new Object[]{"abc", 1L});
        this.testQuery("SELECT dim2, COUNT(*) FROM foo WHERE ARRAY_CONTAINS((SELECT ARRAY_AGG(DISTINCT dim1) FROM foo WHERE dim1 is not null), dim1) GROUP BY 1", (List<Query>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteArraysQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).filters((DimFilter)CalciteArraysQueryTest.not((DimFilter)CalciteArraysQueryTest.selector("dim1", null, null))).aggregators(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new ExpressionLambdaAggregatorFactory("a0", (Set)ImmutableSet.of((Object)"dim1"), "__acc", "ARRAY<STRING>[]", "ARRAY<STRING>[]", Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), "array_set_add(\"__acc\", \"dim1\")", "array_set_add_all(\"__acc\", \"a0\")", null, null, ExpressionLambdaAggregatorFactory.DEFAULT_MAX_SIZE_BYTES, TestExprMacroTable.INSTANCE)})).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", "1", JoinType.LEFT, null)).setInterval(CalciteArraysQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter((DimFilter)new ExpressionDimFilter("array_contains(\"j0.a0\",\"dim1\")", TestExprMacroTable.INSTANCE)).setDimensions(CalciteArraysQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteArraysQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setGranularity(Granularities.ALL).setLimitSpec((LimitSpec)NoopLimitSpec.instance()).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)expectedResults);
    }

    public static void assertResultsDeepEquals(String sql, List<Object[]> expected, List<Object[]> results) {
        for (int row = 0; row < results.size(); ++row) {
            for (int col = 0; col < results.get(row).length; ++col) {
                String rowString = StringUtils.format((String)"result #%d: %s", (Object[])new Object[]{row + 1, sql});
                CalciteArraysQueryTest.assertDeepEquals(rowString + " - column: " + col + ":", expected.get(row)[col], results.get(row)[col]);
            }
        }
    }

    public static void assertDeepEquals(String path, Object expected, Object actual) {
        if (expected instanceof List && actual instanceof List) {
            List expectedList = (List)expected;
            List actualList = (List)actual;
            Assert.assertEquals((String)(path + " arrays length mismatch"), (long)expectedList.size(), (long)actualList.size());
            for (int i = 0; i < expectedList.size(); ++i) {
                CalciteArraysQueryTest.assertDeepEquals(path + "[" + i + "]", expectedList.get(i), actualList.get(i));
            }
        } else {
            Assert.assertEquals((String)path, (Object)expected, (Object)actual);
        }
    }
}

