/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.hll.VersionOneHyperLogLogCollector;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.Druids;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.post.ExpressionPostAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.CascadeExtractionFn;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.ExpressionDimFilter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.groupby.having.DimFilterHavingSpec;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.query.lookup.LookupSerdeModule;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.SqlLifecycle;
import org.apache.druid.sql.SqlLifecycleFactory;
import org.apache.druid.sql.calcite.TestQueryMakerFactory;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.external.ExternalDataSource;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.run.QueryMakerFactory;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.schema.DruidSchemaManager;
import org.apache.druid.sql.calcite.schema.NoopDruidSchemaManager;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.calcite.util.QueryLogHook;
import org.apache.druid.sql.calcite.util.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.sql.calcite.view.InProcessViewManager;
import org.apache.druid.sql.calcite.view.ViewManager;
import org.apache.druid.sql.http.SqlParameter;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.chrono.ISOChronology;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class BaseCalciteQueryTest
extends CalciteTestBase {
    public static String NULL_STRING;
    public static Float NULL_FLOAT;
    public static Long NULL_LONG;
    public static final String HLLC_STRING;
    public static final Logger log;
    public static final PlannerConfig PLANNER_CONFIG_DEFAULT;
    public static final PlannerConfig PLANNER_CONFIG_DEFAULT_NO_COMPLEX_SERDE;
    public static final PlannerConfig PLANNER_CONFIG_REQUIRE_TIME_CONDITION;
    public static final PlannerConfig PLANNER_CONFIG_NO_TOPN;
    public static final PlannerConfig PLANNER_CONFIG_NO_HLL;
    public static final PlannerConfig PLANNER_CONFIG_LOS_ANGELES;
    public static final PlannerConfig PLANNER_CONFIG_AUTHORIZE_SYS_TABLES;
    public static final PlannerConfig PLANNER_CONFIG_NATIVE_QUERY_EXPLAIN;
    public static final int MAX_NUM_IN_FILTERS = 100;
    public static final PlannerConfig PLANNER_CONFIG_MAX_NUMERIC_IN_FILTER;
    public static final String DUMMY_SQL_ID = "dummy";
    public static final String LOS_ANGELES = "America/Los_Angeles";
    private static final ImmutableMap.Builder<String, Object> DEFAULT_QUERY_CONTEXT_BUILDER;
    public static final Map<String, Object> QUERY_CONTEXT_DEFAULT;
    public static final Map<String, Object> QUERY_CONTEXT_NO_STRINGIFY_ARRAY;
    public static final Map<String, Object> QUERY_CONTEXT_DONT_SKIP_EMPTY_BUCKETS;
    public static final Map<String, Object> QUERY_CONTEXT_DO_SKIP_EMPTY_BUCKETS;
    public static final Map<String, Object> QUERY_CONTEXT_NO_TOPN;
    public static final Map<String, Object> QUERY_CONTEXT_LOS_ANGELES;
    public static final Map<String, Object> TIMESERIES_CONTEXT_BY_GRAN;
    public static final Map<String, Object> TIMESERIES_CONTEXT_LOS_ANGELES;
    public static final Map<String, Object> OUTER_LIMIT_CONTEXT;
    public static QueryRunnerFactoryConglomerate conglomerate;
    public static Closer resourceCloser;
    public static int minTopNThreshold;
    final boolean useDefault = NullHandling.replaceWithDefault();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    public boolean cannotVectorize = false;
    public boolean skipVectorize = false;
    public ObjectMapper queryJsonMapper;
    public SpecificSegmentsQuerySegmentWalker walker = null;
    public QueryLogHook queryLogHook;

    @BeforeClass
    public static void setupNullValues() {
        NULL_STRING = NullHandling.defaultStringValue();
        NULL_FLOAT = NullHandling.defaultFloatValue();
        NULL_LONG = NullHandling.defaultLongValue();
    }

    public static Map<String, Object> getTimeseriesContextWithFloorTime(Map<String, Object> context, String timestampResultField) {
        return ImmutableMap.builder().putAll(context).put((Object)"timestampResultField", (Object)timestampResultField).build();
    }

    public static long timestamp(String timeString) {
        return Calcites.jodaToCalciteTimestamp((DateTime)DateTimes.of((String)timeString), (DateTimeZone)DateTimeZone.UTC);
    }

    public static long timestamp(String timeString, String timeZoneString) {
        DateTimeZone timeZone = DateTimes.inferTzFromString((String)timeZoneString);
        return Calcites.jodaToCalciteTimestamp((DateTime)new DateTime((Object)timeString, timeZone), (DateTimeZone)timeZone);
    }

    public static int day(String dayString) {
        return (int)(Intervals.utc((long)BaseCalciteQueryTest.timestamp("1970"), (long)BaseCalciteQueryTest.timestamp(dayString)).toDurationMillis() / 86400000L);
    }

    public static QuerySegmentSpec querySegmentSpec(Interval ... intervals) {
        return new MultipleIntervalSegmentSpec(Arrays.asList(intervals));
    }

    public static AndDimFilter and(DimFilter ... filters) {
        return new AndDimFilter(Arrays.asList(filters));
    }

    public static OrDimFilter or(DimFilter ... filters) {
        return new OrDimFilter(Arrays.asList(filters));
    }

    public static NotDimFilter not(DimFilter filter) {
        return new NotDimFilter(filter);
    }

    public static InDimFilter in(String dimension, List<String> values, ExtractionFn extractionFn) {
        return new InDimFilter(dimension, values, extractionFn);
    }

    public static SelectorDimFilter selector(String fieldName, String value, ExtractionFn extractionFn) {
        return new SelectorDimFilter(fieldName, value, extractionFn);
    }

    public static ExpressionDimFilter expressionFilter(String expression) {
        return new ExpressionDimFilter(expression, CalciteTests.createExprMacroTable());
    }

    public static DimFilter numericSelector(String fieldName, String value, ExtractionFn extractionFn) {
        return BaseCalciteQueryTest.bound(fieldName, value, value, false, false, extractionFn, StringComparators.NUMERIC);
    }

    public static BoundDimFilter bound(String fieldName, String lower, String upper, boolean lowerStrict, boolean upperStrict, ExtractionFn extractionFn, StringComparator comparator) {
        return new BoundDimFilter(fieldName, lower, upper, Boolean.valueOf(lowerStrict), Boolean.valueOf(upperStrict), null, extractionFn, comparator);
    }

    public static BoundDimFilter timeBound(Object intervalObj) {
        Interval interval = new Interval(intervalObj, (Chronology)ISOChronology.getInstanceUTC());
        return new BoundDimFilter("__time", String.valueOf(interval.getStartMillis()), String.valueOf(interval.getEndMillis()), Boolean.valueOf(false), Boolean.valueOf(true), null, null, StringComparators.NUMERIC);
    }

    public static CascadeExtractionFn cascade(ExtractionFn ... fns) {
        return new CascadeExtractionFn(fns);
    }

    public static List<DimensionSpec> dimensions(DimensionSpec ... dimensionSpecs) {
        return Arrays.asList(dimensionSpecs);
    }

    public static List<AggregatorFactory> aggregators(AggregatorFactory ... aggregators) {
        return Arrays.asList(aggregators);
    }

    public static DimFilterHavingSpec having(DimFilter filter) {
        return new DimFilterHavingSpec(filter, Boolean.valueOf(true));
    }

    public static ExpressionVirtualColumn expressionVirtualColumn(String name, String expression, ColumnType outputType) {
        return new ExpressionVirtualColumn(name, expression, outputType, CalciteTests.createExprMacroTable());
    }

    public static JoinDataSource join(DataSource left, DataSource right, String rightPrefix, String condition, JoinType joinType, DimFilter filter) {
        return JoinDataSource.create((DataSource)left, (DataSource)right, (String)rightPrefix, (String)condition, (JoinType)joinType, (DimFilter)filter, (ExprMacroTable)CalciteTests.createExprMacroTable());
    }

    public static JoinDataSource join(DataSource left, DataSource right, String rightPrefix, String condition, JoinType joinType) {
        return BaseCalciteQueryTest.join(left, right, rightPrefix, condition, joinType, null);
    }

    public static String equalsCondition(DruidExpression left, DruidExpression right) {
        return StringUtils.format((String)"(%s == %s)", (Object[])new Object[]{left.getExpression(), right.getExpression()});
    }

    public static ExpressionPostAggregator expressionPostAgg(String name, String expression) {
        return new ExpressionPostAggregator(name, expression, null, CalciteTests.createExprMacroTable());
    }

    public static Druids.ScanQueryBuilder newScanQueryBuilder() {
        return new Druids.ScanQueryBuilder().resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).legacy(Boolean.valueOf(false));
    }

    @BeforeClass
    public static void setUpClass() {
        resourceCloser = Closer.create();
        conglomerate = QueryStackTests.createQueryRunnerFactoryConglomerate((Closer)resourceCloser, () -> minTopNThreshold);
    }

    @AfterClass
    public static void tearDownClass() throws IOException {
        resourceCloser.close();
    }

    @Rule
    public QueryLogHook getQueryLogHook() {
        this.queryJsonMapper = this.createQueryJsonMapper();
        this.queryLogHook = QueryLogHook.create(this.queryJsonMapper);
        return this.queryLogHook;
    }

    @Before
    public void setUp() throws Exception {
        this.walker = this.createQuerySegmentWalker();
        ObjectMapper mapper = CalciteTests.getJsonMapper();
        mapper.registerModules(this.getJacksonModules());
        this.setMapperInjectableValues(mapper, this.getJacksonInjectables());
    }

    @After
    public void tearDown() throws Exception {
        this.walker.close();
        this.walker = null;
    }

    public SpecificSegmentsQuerySegmentWalker createQuerySegmentWalker() throws IOException {
        return CalciteTests.createMockWalker(conglomerate, this.temporaryFolder.newFolder());
    }

    public ObjectMapper createQueryJsonMapper() {
        ObjectMapper mapper = new DefaultObjectMapper().registerModules(this.getJacksonModules());
        this.setMapperInjectableValues(mapper, this.getJacksonInjectables());
        return mapper;
    }

    public DruidOperatorTable createOperatorTable() {
        return CalciteTests.createOperatorTable();
    }

    public ExprMacroTable createMacroTable() {
        return CalciteTests.createExprMacroTable();
    }

    public Map<String, Object> getJacksonInjectables() {
        return new HashMap<String, Object>();
    }

    public final void setMapperInjectableValues(ObjectMapper mapper, Map<String, Object> injectables) {
        LookupExtractorFactoryContainerProvider lookupProvider = (LookupExtractorFactoryContainerProvider)CalciteTests.INJECTOR.getInstance(LookupExtractorFactoryContainerProvider.class);
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std(injectables).addValue(ExprMacroTable.class.getName(), (Object)this.createMacroTable()).addValue(ObjectMapper.class.getName(), (Object)mapper).addValue(DataSegment.PruneSpecsHolder.class, (Object)DataSegment.PruneSpecsHolder.DEFAULT).addValue(LookupExtractorFactoryContainerProvider.class.getName(), (Object)lookupProvider));
    }

    public Iterable<? extends Module> getJacksonModules() {
        ArrayList<SimpleModule> modules = new ArrayList<SimpleModule>(new LookupSerdeModule().getJacksonModules());
        modules.add(new SimpleModule().registerSubtypes(new Class[]{ExternalDataSource.class}));
        return modules;
    }

    public void assertQueryIsUnplannable(String sql, String expectedError) {
        this.assertQueryIsUnplannable(PLANNER_CONFIG_DEFAULT, sql, expectedError);
    }

    public void assertQueryIsUnplannable(PlannerConfig plannerConfig, String sql, String expectedError) {
        Exception e = null;
        try {
            this.testQuery(plannerConfig, sql, CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
        }
        catch (Exception e1) {
            e = e1;
        }
        if (!(e instanceof RelOptPlanner.CannotPlanException)) {
            log.error((Throwable)e, "Expected CannotPlanException for query: %s", new Object[]{sql});
            Assert.fail((String)sql);
        }
        Assert.assertEquals((String)sql, (Object)StringUtils.format((String)"Cannot build plan for query: %s. %s", (Object[])new Object[]{sql, expectedError}), (Object)e.getMessage());
    }

    public void assertQueryIsForbidden(String sql, AuthenticationResult authenticationResult) {
        this.assertQueryIsForbidden(PLANNER_CONFIG_DEFAULT, sql, authenticationResult);
    }

    public void assertQueryIsForbidden(PlannerConfig plannerConfig, String sql, AuthenticationResult authenticationResult) {
        Exception e = null;
        try {
            this.testQuery(plannerConfig, sql, authenticationResult, (List<Query>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
        }
        catch (Exception e1) {
            e = e1;
        }
        if (!(e instanceof ForbiddenException)) {
            log.error((Throwable)e, "Expected ForbiddenException for query: %s with authResult: %s", new Object[]{sql, authenticationResult});
            Assert.fail((String)sql);
        }
    }

    public void testQuery(String sql, List<Query> expectedQueries, List<Object[]> expectedResults) throws Exception {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_DEFAULT, DEFAULT_PARAMETERS, sql, CalciteTests.REGULAR_USER_AUTH_RESULT, expectedQueries, expectedResults);
    }

    public void testQuery(String sql, Map<String, Object> context, List<Query> expectedQueries, List<Object[]> expectedResults) throws Exception {
        this.testQuery(PLANNER_CONFIG_DEFAULT, context, DEFAULT_PARAMETERS, sql, CalciteTests.REGULAR_USER_AUTH_RESULT, expectedQueries, expectedResults);
    }

    public void testQuery(String sql, List<Query> expectedQueries, List<Object[]> expectedResults, List<SqlParameter> parameters) throws Exception {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_DEFAULT, parameters, sql, CalciteTests.REGULAR_USER_AUTH_RESULT, expectedQueries, expectedResults);
    }

    public void testQuery(PlannerConfig plannerConfig, String sql, AuthenticationResult authenticationResult, List<Query> expectedQueries, List<Object[]> expectedResults) throws Exception {
        this.testQuery(plannerConfig, QUERY_CONTEXT_DEFAULT, DEFAULT_PARAMETERS, sql, authenticationResult, expectedQueries, expectedResults);
    }

    public void testQuery(String sql, Map<String, Object> context, List<Query> expectedQueries, ResultsVerifier expectedResultsVerifier) throws Exception {
        this.testQuery(PLANNER_CONFIG_DEFAULT, context, DEFAULT_PARAMETERS, sql, CalciteTests.REGULAR_USER_AUTH_RESULT, expectedQueries, expectedResultsVerifier, null);
    }

    public void testQuery(PlannerConfig plannerConfig, Map<String, Object> queryContext, String sql, AuthenticationResult authenticationResult, List<Query> expectedQueries, List<Object[]> expectedResults) throws Exception {
        log.info("SQL: %s", new Object[]{sql});
        this.queryLogHook.clearRecordedQueries();
        List<Object[]> plannerResults = this.getResults(plannerConfig, queryContext, DEFAULT_PARAMETERS, sql, authenticationResult);
        this.verifyResults(sql, expectedQueries, expectedResults, plannerResults);
    }

    public void testQuery(PlannerConfig plannerConfig, Map<String, Object> queryContext, List<SqlParameter> parameters, String sql, AuthenticationResult authenticationResult, List<Query> expectedQueries, List<Object[]> expectedResults) throws Exception {
        this.testQuery(plannerConfig, queryContext, parameters, sql, authenticationResult, expectedQueries, new DefaultResultsVerifier(expectedResults), null);
    }

    public void testQuery(PlannerConfig plannerConfig, Map<String, Object> queryContext, List<SqlParameter> parameters, String sql, AuthenticationResult authenticationResult, List<Query> expectedQueries, ResultsVerifier expectedResultsVerifier, @Nullable Consumer<ExpectedException> expectedExceptionInitializer) throws Exception {
        log.info("SQL: %s", new Object[]{sql});
        ArrayList<String> vectorizeValues = new ArrayList<String>();
        vectorizeValues.add("false");
        if (!this.skipVectorize) {
            vectorizeValues.add("force");
        }
        for (String vectorize : vectorizeValues) {
            this.queryLogHook.clearRecordedQueries();
            HashMap<String, Object> theQueryContext = new HashMap<String, Object>(queryContext);
            theQueryContext.put("vectorize", vectorize);
            theQueryContext.put("vectorizeVirtualColumns", vectorize);
            if (!"false".equals(vectorize)) {
                theQueryContext.put("vectorSize", 2);
            }
            ArrayList<Query> theQueries = new ArrayList<Query>();
            for (Query query : expectedQueries) {
                theQueries.add(BaseCalciteQueryTest.recursivelyOverrideContext(query, theQueryContext));
            }
            if (this.cannotVectorize && "force".equals(vectorize)) {
                this.expectedException.expect(RuntimeException.class);
                this.expectedException.expectMessage("Cannot vectorize");
            } else if (expectedExceptionInitializer != null) {
                expectedExceptionInitializer.accept(this.expectedException);
            }
            List<Object[]> plannerResults = this.getResults(plannerConfig, theQueryContext, parameters, sql, authenticationResult);
            this.verifyResults(sql, theQueries, plannerResults, expectedResultsVerifier);
        }
    }

    public List<Object[]> getResults(PlannerConfig plannerConfig, Map<String, Object> queryContext, List<SqlParameter> parameters, String sql, AuthenticationResult authenticationResult) throws Exception {
        return this.getResults(plannerConfig, queryContext, parameters, sql, authenticationResult, this.createOperatorTable(), this.createMacroTable(), CalciteTests.TEST_AUTHORIZER_MAPPER, this.queryJsonMapper);
    }

    public List<Object[]> getResults(PlannerConfig plannerConfig, Map<String, Object> queryContext, List<SqlParameter> parameters, String sql, AuthenticationResult authenticationResult, DruidOperatorTable operatorTable, ExprMacroTable macroTable, AuthorizerMapper authorizerMapper, ObjectMapper objectMapper) throws Exception {
        SqlLifecycleFactory sqlLifecycleFactory = this.getSqlLifecycleFactory(plannerConfig, new AuthConfig(), operatorTable, macroTable, authorizerMapper, objectMapper);
        return sqlLifecycleFactory.factorize().runSimple(sql, queryContext, parameters, authenticationResult).toList();
    }

    public void verifyResults(String sql, List<Query> expectedQueries, List<Object[]> expectedResults, List<Object[]> results) {
        this.verifyResults(sql, expectedQueries, results, new DefaultResultsVerifier(expectedResults));
    }

    public void verifyResults(String sql, List<Query> expectedQueries, List<Object[]> results, ResultsVerifier expectedResultsVerifier) {
        for (int i = 0; i < results.size(); ++i) {
            log.info("row #%d: %s", new Object[]{i, Arrays.toString(results.get(i))});
        }
        expectedResultsVerifier.verify(sql, results);
        this.verifyQueries(sql, expectedQueries);
    }

    private void verifyQueries(String sql, @Nullable List<Query> expectedQueries) {
        if (expectedQueries != null) {
            List<Query> recordedQueries = this.queryLogHook.getRecordedQueries();
            Assert.assertEquals((String)StringUtils.format((String)"query count: %s", (Object[])new Object[]{sql}), (long)expectedQueries.size(), (long)recordedQueries.size());
            for (int i = 0; i < expectedQueries.size(); ++i) {
                Assert.assertEquals((String)StringUtils.format((String)"query #%d: %s", (Object[])new Object[]{i + 1, sql}), (Object)expectedQueries.get(i), (Object)recordedQueries.get(i));
                try {
                    String recordedString = this.queryJsonMapper.writeValueAsString((Object)recordedQueries.get(i));
                    Query stringAndBack = (Query)this.queryJsonMapper.readValue(recordedString, Query.class);
                    String expectedString = this.queryJsonMapper.writeValueAsString((Object)expectedQueries.get(i));
                    Query expectedStringAndBack = (Query)this.queryJsonMapper.readValue(expectedString, Query.class);
                    Assert.assertEquals((Object)expectedStringAndBack, (Object)stringAndBack);
                    continue;
                }
                catch (JsonProcessingException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        }
    }

    public void assertResultsEquals(String sql, List<Object[]> expectedResults, List<Object[]> results) {
        for (int i = 0; i < results.size(); ++i) {
            Assert.assertArrayEquals((String)StringUtils.format((String)"result #%d: %s", (Object[])new Object[]{i + 1, sql}), (Object[])expectedResults.get(i), (Object[])results.get(i));
        }
    }

    public void testQueryThrows(String sql, Consumer<ExpectedException> expectedExceptionInitializer) throws Exception {
        this.testQueryThrows(sql, new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT), (List<Query>)ImmutableList.of(), expectedExceptionInitializer);
    }

    public void testQueryThrows(String sql, Map<String, Object> queryContext, List<Query> expectedQueries, Consumer<ExpectedException> expectedExceptionInitializer) throws Exception {
        this.testQuery(PLANNER_CONFIG_DEFAULT, queryContext, DEFAULT_PARAMETERS, sql, CalciteTests.REGULAR_USER_AUTH_RESULT, expectedQueries, (query, results) -> {}, expectedExceptionInitializer);
    }

    public Set<ResourceAction> analyzeResources(PlannerConfig plannerConfig, String sql, AuthenticationResult authenticationResult) {
        return this.analyzeResources(plannerConfig, new AuthConfig(), sql, (Map<String, Object>)ImmutableMap.of(), authenticationResult);
    }

    public Set<ResourceAction> analyzeResources(PlannerConfig plannerConfig, AuthConfig authConfig, String sql, Map<String, Object> contexts, AuthenticationResult authenticationResult) {
        SqlLifecycleFactory lifecycleFactory = this.getSqlLifecycleFactory(plannerConfig, authConfig, this.createOperatorTable(), this.createMacroTable(), CalciteTests.TEST_AUTHORIZER_MAPPER, this.queryJsonMapper);
        SqlLifecycle lifecycle = lifecycleFactory.factorize();
        lifecycle.initialize(sql, new QueryContext(contexts));
        return lifecycle.runAnalyzeResources(authenticationResult).getResourceActions();
    }

    public SqlLifecycleFactory getSqlLifecycleFactory(PlannerConfig plannerConfig, AuthConfig authConfig, DruidOperatorTable operatorTable, ExprMacroTable macroTable, AuthorizerMapper authorizerMapper, ObjectMapper objectMapper) {
        InProcessViewManager viewManager = new InProcessViewManager(CalciteTests.DRUID_VIEW_MACRO_FACTORY);
        DruidSchemaCatalog rootSchema = CalciteTests.createMockRootSchema(conglomerate, this.walker, plannerConfig, (ViewManager)viewManager, (DruidSchemaManager)new NoopDruidSchemaManager(), authorizerMapper);
        PlannerFactory plannerFactory = new PlannerFactory(rootSchema, (QueryMakerFactory)new TestQueryMakerFactory(CalciteTests.createMockQueryLifecycleFactory(this.walker, conglomerate), objectMapper), operatorTable, macroTable, plannerConfig, authorizerMapper, objectMapper, "druid");
        SqlLifecycleFactory sqlLifecycleFactory = CalciteTests.createSqlLifecycleFactory(plannerFactory, authConfig);
        viewManager.createView(plannerFactory, "aview", "SELECT SUBSTRING(dim1, 1, 1) AS dim1_firstchar FROM foo WHERE dim2 = 'a'");
        viewManager.createView(plannerFactory, "bview", "SELECT COUNT(*) FROM druid.foo\nWHERE __time >= CURRENT_TIMESTAMP + INTERVAL '1' DAY AND __time < TIMESTAMP '2002-01-01 00:00:00'");
        viewManager.createView(plannerFactory, "cview", "SELECT SUBSTRING(bar.dim1, 1, 1) AS dim1_firstchar, bar.dim2 as dim2, dnf.l2 as l2\nFROM (SELECT * from foo WHERE dim2 = 'a') as bar INNER JOIN druid.numfoo dnf ON bar.dim2 = dnf.dim2");
        viewManager.createView(plannerFactory, "dview", "SELECT SUBSTRING(dim1, 1, 1) AS numfoo FROM foo WHERE dim2 = 'a'");
        viewManager.createView(plannerFactory, "forbiddenView", "SELECT __time, SUBSTRING(dim1, 1, 1) AS dim1_firstchar, dim2 FROM foo WHERE dim2 = 'a'");
        viewManager.createView(plannerFactory, "restrictedView", "SELECT __time, dim1, dim2, m1 FROM druid.forbiddenDatasource WHERE dim2 = 'a'");
        viewManager.createView(plannerFactory, "invalidView", "SELECT __time, dim1, dim2, m1 FROM druid.invalidDatasource WHERE dim2 = 'a'");
        return sqlLifecycleFactory;
    }

    protected void cannotVectorize() {
        this.cannotVectorize = true;
    }

    protected void skipVectorize() {
        this.skipVectorize = true;
    }

    protected static boolean isRewriteJoinToFilter(Map<String, Object> queryContext) {
        return (Boolean)queryContext.getOrDefault("enableRewriteJoinToFilter", false);
    }

    public static <T> Query<T> recursivelyOverrideContext(Query<T> query, Map<String, Object> context) {
        return query.withDataSource(BaseCalciteQueryTest.recursivelyOverrideContext(query.getDataSource(), context)).withOverriddenContext(context);
    }

    private static DataSource recursivelyOverrideContext(DataSource dataSource, Map<String, Object> context) {
        if (dataSource instanceof QueryDataSource) {
            Query subquery = ((QueryDataSource)dataSource).getQuery();
            return new QueryDataSource(BaseCalciteQueryTest.recursivelyOverrideContext(subquery, context));
        }
        return dataSource.withChildren(dataSource.getChildren().stream().map(ds -> BaseCalciteQueryTest.recursivelyOverrideContext(ds, context)).collect(Collectors.toList()));
    }

    protected Map<String, Object> withLeftDirectAccessEnabled(Map<String, Object> context) {
        HashMap<String, Object> newContext = new HashMap<String, Object>(context);
        newContext.put("enableJoinLeftTableScanDirect", true);
        return newContext;
    }

    protected void requireMergeBuffers(int numMergeBuffers) throws IOException {
        conglomerate = QueryStackTests.createQueryRunnerFactoryConglomerate((Closer)resourceCloser, (DruidProcessingConfig)QueryStackTests.getProcessingConfig((boolean)true, (int)numMergeBuffers));
        this.walker = CalciteTests.createMockWalker(conglomerate, this.temporaryFolder.newFolder());
    }

    protected Map<String, Object> withTimestampResultContext(Map<String, Object> input, String timestampResultField, int timestampResultFieldIndex, Granularity granularity) {
        HashMap<String, Object> output = new HashMap<String, Object>(input);
        output.put("timestampResultField", timestampResultField);
        output.put("timestampResultFieldGranularity", granularity);
        output.put("timestampResultFieldInOriginalDimensions", timestampResultFieldIndex);
        return output;
    }

    static {
        HLLC_STRING = VersionOneHyperLogLogCollector.class.getName();
        log = new Logger(BaseCalciteQueryTest.class);
        PLANNER_CONFIG_DEFAULT = new PlannerConfig();
        PLANNER_CONFIG_DEFAULT_NO_COMPLEX_SERDE = new PlannerConfig(){

            public boolean shouldSerializeComplexValues() {
                return false;
            }
        };
        PLANNER_CONFIG_REQUIRE_TIME_CONDITION = new PlannerConfig(){

            public boolean isRequireTimeCondition() {
                return true;
            }
        };
        PLANNER_CONFIG_NO_TOPN = new PlannerConfig(){

            public int getMaxTopNLimit() {
                return 0;
            }
        };
        PLANNER_CONFIG_NO_HLL = new PlannerConfig(){

            public boolean isUseApproximateCountDistinct() {
                return false;
            }
        };
        PLANNER_CONFIG_LOS_ANGELES = new PlannerConfig(){

            public DateTimeZone getSqlTimeZone() {
                return DateTimes.inferTzFromString((String)BaseCalciteQueryTest.LOS_ANGELES);
            }
        };
        PLANNER_CONFIG_AUTHORIZE_SYS_TABLES = new PlannerConfig(){

            public boolean isAuthorizeSystemTablesDirectly() {
                return true;
            }
        };
        PLANNER_CONFIG_NATIVE_QUERY_EXPLAIN = new PlannerConfig(){

            public boolean isUseNativeQueryExplain() {
                return true;
            }
        };
        PLANNER_CONFIG_MAX_NUMERIC_IN_FILTER = new PlannerConfig(){

            public int getMaxNumericInFilters() {
                return 100;
            }
        };
        DEFAULT_QUERY_CONTEXT_BUILDER = ImmutableMap.builder().put((Object)"sqlQueryId", (Object)DUMMY_SQL_ID).put((Object)"sqlCurrentTimestamp", (Object)"2000-01-01T00:00:00Z").put((Object)"defaultTimeout", (Object)QueryContexts.DEFAULT_TIMEOUT_MILLIS).put((Object)"maxScatterGatherBytes", (Object)Long.MAX_VALUE);
        QUERY_CONTEXT_DEFAULT = DEFAULT_QUERY_CONTEXT_BUILDER.build();
        QUERY_CONTEXT_NO_STRINGIFY_ARRAY = DEFAULT_QUERY_CONTEXT_BUILDER.put((Object)"sqlStringifyArrays", (Object)false).build();
        QUERY_CONTEXT_DONT_SKIP_EMPTY_BUCKETS = ImmutableMap.of((Object)"sqlQueryId", (Object)DUMMY_SQL_ID, (Object)"sqlCurrentTimestamp", (Object)"2000-01-01T00:00:00Z", (Object)"skipEmptyBuckets", (Object)false, (Object)"defaultTimeout", (Object)QueryContexts.DEFAULT_TIMEOUT_MILLIS, (Object)"maxScatterGatherBytes", (Object)Long.MAX_VALUE);
        QUERY_CONTEXT_DO_SKIP_EMPTY_BUCKETS = ImmutableMap.of((Object)"sqlQueryId", (Object)DUMMY_SQL_ID, (Object)"sqlCurrentTimestamp", (Object)"2000-01-01T00:00:00Z", (Object)"skipEmptyBuckets", (Object)true, (Object)"defaultTimeout", (Object)QueryContexts.DEFAULT_TIMEOUT_MILLIS, (Object)"maxScatterGatherBytes", (Object)Long.MAX_VALUE);
        QUERY_CONTEXT_NO_TOPN = ImmutableMap.of((Object)"sqlQueryId", (Object)DUMMY_SQL_ID, (Object)"sqlCurrentTimestamp", (Object)"2000-01-01T00:00:00Z", (Object)"useApproximateTopN", (Object)"false", (Object)"defaultTimeout", (Object)QueryContexts.DEFAULT_TIMEOUT_MILLIS, (Object)"maxScatterGatherBytes", (Object)Long.MAX_VALUE);
        QUERY_CONTEXT_LOS_ANGELES = ImmutableMap.of((Object)"sqlQueryId", (Object)DUMMY_SQL_ID, (Object)"sqlCurrentTimestamp", (Object)"2000-01-01T00:00:00Z", (Object)"sqlTimeZone", (Object)LOS_ANGELES, (Object)"defaultTimeout", (Object)QueryContexts.DEFAULT_TIMEOUT_MILLIS, (Object)"maxScatterGatherBytes", (Object)Long.MAX_VALUE);
        TIMESERIES_CONTEXT_BY_GRAN = ImmutableMap.of((Object)"sqlQueryId", (Object)DUMMY_SQL_ID, (Object)"sqlCurrentTimestamp", (Object)"2000-01-01T00:00:00Z", (Object)"skipEmptyBuckets", (Object)true, (Object)"defaultTimeout", (Object)QueryContexts.DEFAULT_TIMEOUT_MILLIS, (Object)"maxScatterGatherBytes", (Object)Long.MAX_VALUE);
        TIMESERIES_CONTEXT_LOS_ANGELES = new HashMap<String, Object>();
        OUTER_LIMIT_CONTEXT = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        minTopNThreshold = 1000;
        TIMESERIES_CONTEXT_LOS_ANGELES.put("sqlQueryId", DUMMY_SQL_ID);
        TIMESERIES_CONTEXT_LOS_ANGELES.put("sqlCurrentTimestamp", "2000-01-01T00:00:00Z");
        TIMESERIES_CONTEXT_LOS_ANGELES.put("sqlTimeZone", LOS_ANGELES);
        TIMESERIES_CONTEXT_LOS_ANGELES.put("skipEmptyBuckets", true);
        TIMESERIES_CONTEXT_LOS_ANGELES.put("defaultTimeout", QueryContexts.DEFAULT_TIMEOUT_MILLIS);
        TIMESERIES_CONTEXT_LOS_ANGELES.put("maxScatterGatherBytes", Long.MAX_VALUE);
        OUTER_LIMIT_CONTEXT.put("sqlOuterLimit", 2);
    }

    public class DefaultResultsVerifier
    implements ResultsVerifier {
        protected final List<Object[]> expectedResults;

        public DefaultResultsVerifier(List<Object[]> expectedResults) {
            this.expectedResults = expectedResults;
        }

        @Override
        public void verify(String sql, List<Object[]> results) {
            Assert.assertEquals((String)StringUtils.format((String)"result count: %s", (Object[])new Object[]{sql}), (long)this.expectedResults.size(), (long)results.size());
            BaseCalciteQueryTest.this.assertResultsEquals(sql, this.expectedResults, results);
        }
    }

    @FunctionalInterface
    public static interface ResultsVerifier {
        public void verify(String var1, List<Object[]> var2);
    }

    public static class QueryContextForJoinProvider {
        public static Object[] provideQueryContexts() {
            return new Object[]{QUERY_CONTEXT_DEFAULT, new ImmutableMap.Builder().putAll(QUERY_CONTEXT_DEFAULT).put((Object)"enableJoinFilterRewriteValueColumnFilters", (Object)true).put((Object)"enableJoinFilterRewrite", (Object)true).put((Object)"enableRewriteJoinToFilter", (Object)true).build(), new ImmutableMap.Builder().putAll(QUERY_CONTEXT_DEFAULT).put((Object)"enableJoinFilterRewriteValueColumnFilters", (Object)false).put((Object)"enableJoinFilterRewrite", (Object)true).put((Object)"enableRewriteJoinToFilter", (Object)true).build(), new ImmutableMap.Builder().putAll(QUERY_CONTEXT_DEFAULT).put((Object)"enableJoinFilterRewriteValueColumnFilters", (Object)false).put((Object)"enableJoinFilterRewrite", (Object)false).put((Object)"enableRewriteJoinToFilter", (Object)true).build(), new ImmutableMap.Builder().putAll(QUERY_CONTEXT_DEFAULT).put((Object)"enableJoinFilterRewriteValueColumnFilters", (Object)true).put((Object)"enableJoinFilterRewrite", (Object)false).put((Object)"enableRewriteJoinToFilter", (Object)true).build(), new ImmutableMap.Builder().putAll(QUERY_CONTEXT_DEFAULT).put((Object)"enableJoinFilterRewriteValueColumnFilters", (Object)true).put((Object)"enableJoinFilterRewrite", (Object)true).put((Object)"enableRewriteJoinToFilter", (Object)false).build(), new ImmutableMap.Builder().putAll(QUERY_CONTEXT_DEFAULT).put((Object)"enableJoinFilterRewriteValueColumnFilters", (Object)false).put((Object)"enableJoinFilterRewrite", (Object)false).put((Object)"enableRewriteJoinToFilter", (Object)false).build()};
        }

        public static Map<String, Object> withOverrides(Map<String, Object> originalContext, Map<String, Object> overrides) {
            HashMap<String, Object> contextWithOverrides = new HashMap<String, Object>(originalContext);
            contextWithOverrides.putAll(overrides);
            return contextWithOverrides;
        }
    }
}

