/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.avatica;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.Meta;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.security.AllowAllAuthenticator;
import org.apache.druid.server.security.AuthTestUtils;
import org.apache.druid.sql.SqlLifecycleFactory;
import org.apache.druid.sql.avatica.DruidStatement;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.calcite.util.QueryLogHook;
import org.apache.druid.sql.calcite.util.SpecificSegmentsQuerySegmentWalker;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class DruidStatementTest
extends CalciteTestBase {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public QueryLogHook queryLogHook = QueryLogHook.create();
    private static QueryRunnerFactoryConglomerate conglomerate;
    private static Closer resourceCloser;
    private SpecificSegmentsQuerySegmentWalker walker;
    private SqlLifecycleFactory sqlLifecycleFactory;

    @BeforeClass
    public static void setUpClass() {
        resourceCloser = Closer.create();
        conglomerate = QueryStackTests.createQueryRunnerFactoryConglomerate((Closer)resourceCloser);
    }

    @AfterClass
    public static void tearDownClass() throws IOException {
        resourceCloser.close();
    }

    @Before
    public void setUp() throws Exception {
        this.walker = CalciteTests.createMockWalker(conglomerate, this.temporaryFolder.newFolder());
        PlannerConfig plannerConfig = new PlannerConfig();
        DruidOperatorTable operatorTable = CalciteTests.createOperatorTable();
        ExprMacroTable macroTable = CalciteTests.createExprMacroTable();
        DruidSchemaCatalog rootSchema = CalciteTests.createMockRootSchema(conglomerate, this.walker, plannerConfig, AuthTestUtils.TEST_AUTHORIZER_MAPPER);
        PlannerFactory plannerFactory = new PlannerFactory(rootSchema, CalciteTests.createMockQueryMakerFactory(this.walker, conglomerate), operatorTable, macroTable, plannerConfig, AuthTestUtils.TEST_AUTHORIZER_MAPPER, CalciteTests.getJsonMapper(), "druid");
        this.sqlLifecycleFactory = CalciteTests.createSqlLifecycleFactory(plannerFactory);
    }

    @After
    public void tearDown() throws Exception {
        this.walker.close();
        this.walker = null;
    }

    @Test
    public void testSignature() {
        String sql = "SELECT * FROM druid.foo";
        try (DruidStatement statement = this.statement("SELECT * FROM druid.foo");){
            Meta.Signature signature = statement.getSignature();
            Assert.assertEquals((Object)Meta.CursorFactory.ARRAY, (Object)signature.cursorFactory);
            Assert.assertEquals((Object)Meta.StatementType.SELECT, (Object)signature.statementType);
            Assert.assertEquals((Object)"SELECT * FROM druid.foo", (Object)signature.sql);
            Assert.assertEquals((Object)Lists.newArrayList((Object[])new ArrayList[]{Lists.newArrayList((Object[])new String[]{"__time", "TIMESTAMP", "java.lang.Long"}), Lists.newArrayList((Object[])new String[]{"cnt", "BIGINT", "java.lang.Number"}), Lists.newArrayList((Object[])new String[]{"dim1", "VARCHAR", "java.lang.String"}), Lists.newArrayList((Object[])new String[]{"dim2", "VARCHAR", "java.lang.String"}), Lists.newArrayList((Object[])new String[]{"dim3", "VARCHAR", "java.lang.String"}), Lists.newArrayList((Object[])new String[]{"m1", "FLOAT", "java.lang.Float"}), Lists.newArrayList((Object[])new String[]{"m2", "DOUBLE", "java.lang.Double"}), Lists.newArrayList((Object[])new String[]{"unique_dim1", "OTHER", "java.lang.Object"})}), (Object)Lists.transform((List)signature.columns, (Function)new Function<ColumnMetaData, List<String>>(){

                public List<String> apply(ColumnMetaData columnMetaData) {
                    return Lists.newArrayList((Object[])new String[]{columnMetaData.label, columnMetaData.type.name, columnMetaData.type.rep.clazz.getName()});
                }
            }));
        }
    }

    @Test
    public void testSubQueryWithOrderBy() {
        String sql = "select T20.F13 as F22  from (SELECT DISTINCT dim1 as F13 FROM druid.foo T10) T20 order by T20.F13 ASC";
        try (DruidStatement statement = this.statement("select T20.F13 as F22  from (SELECT DISTINCT dim1 as F13 FROM druid.foo T10) T20 order by T20.F13 ASC");){
            Meta.Frame frame = statement.execute(Collections.emptyList()).nextFrame(0L, 6);
            Assert.assertEquals((Object)Meta.Frame.create((long)0L, (boolean)true, (List)Lists.newArrayList((Object[])new Object[]{new Object[]{""}, new Object[]{"1"}, new Object[]{"10.1"}, new Object[]{"2"}, new Object[]{"abc"}, new Object[]{"def"}})), (Object)frame);
            Assert.assertTrue((boolean)statement.isDone());
        }
    }

    @Test
    public void testSelectAllInFirstFrame() {
        String sql = "SELECT __time, cnt, dim1, dim2, m1 FROM druid.foo";
        try (DruidStatement statement = this.statement("SELECT __time, cnt, dim1, dim2, m1 FROM druid.foo");){
            Meta.Frame frame = statement.execute(Collections.emptyList()).nextFrame(0L, 6);
            Assert.assertEquals((Object)Meta.Frame.create((long)0L, (boolean)true, (List)Lists.newArrayList((Object[])new Object[]{new Object[]{DateTimes.of((String)"2000-01-01").getMillis(), 1L, "", "a", Float.valueOf(1.0f)}, new Object[]{DateTimes.of((String)"2000-01-02").getMillis(), 1L, "10.1", NullHandling.defaultStringValue(), Float.valueOf(2.0f)}, new Object[]{DateTimes.of((String)"2000-01-03").getMillis(), 1L, "2", "", Float.valueOf(3.0f)}, new Object[]{DateTimes.of((String)"2001-01-01").getMillis(), 1L, "1", "a", Float.valueOf(4.0f)}, new Object[]{DateTimes.of((String)"2001-01-02").getMillis(), 1L, "def", "abc", Float.valueOf(5.0f)}, new Object[]{DateTimes.of((String)"2001-01-03").getMillis(), 1L, "abc", NullHandling.defaultStringValue(), Float.valueOf(6.0f)}})), (Object)frame);
            Assert.assertTrue((boolean)statement.isDone());
        }
    }

    @Test
    public void testSelectSplitOverTwoFrames() {
        String sql = "SELECT __time, cnt, dim1, dim2, m1 FROM druid.foo";
        try (DruidStatement statement = this.statement("SELECT __time, cnt, dim1, dim2, m1 FROM druid.foo");){
            Meta.Frame frame = statement.execute(Collections.emptyList()).nextFrame(0L, 2);
            Assert.assertEquals((Object)Meta.Frame.create((long)0L, (boolean)false, (List)Lists.newArrayList((Object[])new Object[]{new Object[]{DateTimes.of((String)"2000-01-01").getMillis(), 1L, "", "a", Float.valueOf(1.0f)}, new Object[]{DateTimes.of((String)"2000-01-02").getMillis(), 1L, "10.1", NullHandling.defaultStringValue(), Float.valueOf(2.0f)}})), (Object)frame);
            Assert.assertFalse((boolean)statement.isDone());
            frame = statement.nextFrame(2L, 10);
            Assert.assertEquals((Object)Meta.Frame.create((long)2L, (boolean)true, (List)Lists.newArrayList((Object[])new Object[]{new Object[]{DateTimes.of((String)"2000-01-03").getMillis(), 1L, "2", "", Float.valueOf(3.0f)}, new Object[]{DateTimes.of((String)"2001-01-01").getMillis(), 1L, "1", "a", Float.valueOf(4.0f)}, new Object[]{DateTimes.of((String)"2001-01-02").getMillis(), 1L, "def", "abc", Float.valueOf(5.0f)}, new Object[]{DateTimes.of((String)"2001-01-03").getMillis(), 1L, "abc", NullHandling.defaultStringValue(), Float.valueOf(6.0f)}})), (Object)frame);
            Assert.assertTrue((boolean)statement.isDone());
        }
    }

    private DruidStatement statement(String sql) {
        return new DruidStatement("", 0, new QueryContext(), this.sqlLifecycleFactory.factorize(), () -> {}).prepare(sql, -1L, AllowAllAuthenticator.ALLOW_ALL_RESULT);
    }
}

