/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.avatica;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.InetSocketAddress;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.calcite.avatica.AvaticaClientRuntimeException;
import org.apache.calcite.avatica.AvaticaSqlException;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.MissingResultsException;
import org.apache.calcite.avatica.NoSuchStatementException;
import org.apache.calcite.avatica.server.AbstractAvaticaHandler;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.initialization.Initialization;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.QuerySchedulerProvider;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.RequestLogLine;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.log.TestRequestLogger;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.server.security.AuthTestUtils;
import org.apache.druid.server.security.AuthenticatorMapper;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.Escalator;
import org.apache.druid.sql.avatica.AvaticaServerConfig;
import org.apache.druid.sql.avatica.DruidMeta;
import org.apache.druid.sql.avatica.ErrorHandler;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.run.NativeQueryMakerFactory;
import org.apache.druid.sql.calcite.run.QueryMakerFactory;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.schema.DruidSchemaName;
import org.apache.druid.sql.calcite.schema.NamedSchema;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.calcite.util.QueryLogHook;
import org.apache.druid.sql.calcite.util.SpecificSegmentsQuerySegmentWalker;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public abstract class DruidAvaticaHandlerTest
extends CalciteTestBase {
    private static final AvaticaServerConfig AVATICA_CONFIG = new AvaticaServerConfig(){

        public int getMaxConnections() {
            return 4;
        }

        public int getMaxStatementsPerConnection() {
            return 4;
        }
    };
    private static final String DUMMY_SQL_QUERY_ID = "dummy";
    private static QueryRunnerFactoryConglomerate conglomerate;
    private static Closer resourceCloser;
    private final boolean nullNumeric = !NullHandling.replaceWithDefault();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public QueryLogHook queryLogHook = QueryLogHook.create();
    private SpecificSegmentsQuerySegmentWalker walker;
    private Server server;
    private Connection client;
    private Connection clientNoTrailingSlash;
    private Connection superuserClient;
    private Connection clientLosAngeles;
    private DruidMeta druidMeta;
    private String url;
    private Injector injector;
    private TestRequestLogger testRequestLogger;

    @BeforeClass
    public static void setUpClass() {
        resourceCloser = Closer.create();
        conglomerate = QueryStackTests.createQueryRunnerFactoryConglomerate((Closer)resourceCloser);
    }

    @AfterClass
    public static void tearDownClass() throws IOException {
        resourceCloser.close();
    }

    @Before
    public void setUp() throws Exception {
        this.walker = CalciteTests.createMockWalker(conglomerate, this.temporaryFolder.newFolder());
        final PlannerConfig plannerConfig = new PlannerConfig();
        final DruidOperatorTable operatorTable = CalciteTests.createOperatorTable();
        final ExprMacroTable macroTable = CalciteTests.createExprMacroTable();
        final DruidSchemaCatalog rootSchema = CalciteTests.createMockRootSchema(conglomerate, this.walker, plannerConfig, CalciteTests.TEST_AUTHORIZER_MAPPER);
        this.testRequestLogger = new TestRequestLogger();
        this.injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("test");
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(0);
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(-1);
                binder.bind(AuthenticatorMapper.class).toInstance((Object)CalciteTests.TEST_AUTHENTICATOR_MAPPER);
                binder.bind(AuthorizerMapper.class).toInstance((Object)CalciteTests.TEST_AUTHORIZER_MAPPER);
                binder.bind(Escalator.class).toInstance((Object)CalciteTests.TEST_AUTHENTICATOR_ESCALATOR);
                binder.bind(RequestLogger.class).toInstance((Object)DruidAvaticaHandlerTest.this.testRequestLogger);
                binder.bind(DruidSchemaCatalog.class).toInstance((Object)rootSchema);
                for (NamedSchema schema : rootSchema.getNamedSchemas().values()) {
                    Multibinder.newSetBinder((Binder)binder, NamedSchema.class).addBinding().toInstance((Object)schema);
                }
                binder.bind(QueryLifecycleFactory.class).toInstance((Object)CalciteTests.createMockQueryLifecycleFactory(DruidAvaticaHandlerTest.this.walker, conglomerate));
                binder.bind(DruidOperatorTable.class).toInstance((Object)operatorTable);
                binder.bind(ExprMacroTable.class).toInstance((Object)macroTable);
                binder.bind(PlannerConfig.class).toInstance((Object)plannerConfig);
                binder.bind(String.class).annotatedWith(DruidSchemaName.class).toInstance((Object)"druid");
                binder.bind(AvaticaServerConfig.class).toInstance((Object)AVATICA_CONFIG);
                binder.bind(ServiceEmitter.class).to(NoopServiceEmitter.class);
                binder.bind(QuerySchedulerProvider.class).in(LazySingleton.class);
                binder.bind(QueryScheduler.class).toProvider(QuerySchedulerProvider.class).in(LazySingleton.class);
                binder.bind(QueryMakerFactory.class).to(NativeQueryMakerFactory.class);
            }
        }));
        this.druidMeta = (DruidMeta)this.injector.getInstance(DruidMeta.class);
        AbstractAvaticaHandler handler = this.getAvaticaHandler(this.druidMeta);
        int port = ThreadLocalRandom.current().nextInt(9999) + 10000;
        this.server = new Server(new InetSocketAddress("127.0.0.1", port));
        this.server.setHandler((Handler)handler);
        this.server.start();
        this.url = this.getJdbcConnectionString(port);
        this.client = DriverManager.getConnection(this.url, "regularUser", "druid");
        this.superuserClient = DriverManager.getConnection(this.url, "testSuperuser", "druid");
        this.clientNoTrailingSlash = DriverManager.getConnection(StringUtils.maybeRemoveTrailingSlash((String)this.url), "testSuperuser", "druid");
        Properties propertiesLosAngeles = new Properties();
        propertiesLosAngeles.setProperty("sqlTimeZone", "America/Los_Angeles");
        propertiesLosAngeles.setProperty("user", "regularUserLA");
        propertiesLosAngeles.setProperty("sqlQueryId", DUMMY_SQL_QUERY_ID);
        this.clientLosAngeles = DriverManager.getConnection(this.url, propertiesLosAngeles);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
        this.clientLosAngeles.close();
        this.clientNoTrailingSlash.close();
        this.server.stop();
        this.walker.close();
        this.walker = null;
        this.client = null;
        this.clientLosAngeles = null;
        this.clientNoTrailingSlash = null;
        this.server = null;
    }

    @Test
    public void testSelectCount() throws Exception {
        ResultSet resultSet = this.client.createStatement().executeQuery("SELECT COUNT(*) AS cnt FROM druid.foo");
        List<Map<String, Object>> rows = DruidAvaticaHandlerTest.getRows(resultSet);
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)6L)), rows);
    }

    @Test
    public void testSelectCountNoTrailingSlash() throws Exception {
        ResultSet resultSet = this.clientNoTrailingSlash.createStatement().executeQuery("SELECT COUNT(*) AS cnt FROM druid.foo");
        List<Map<String, Object>> rows = DruidAvaticaHandlerTest.getRows(resultSet);
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)6L)), rows);
    }

    @Test
    public void testSelectCountAlternateStyle() throws Exception {
        ResultSet resultSet = this.client.prepareStatement("SELECT COUNT(*) AS cnt FROM druid.foo").executeQuery();
        List<Map<String, Object>> rows = DruidAvaticaHandlerTest.getRows(resultSet);
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)6L)), rows);
    }

    @Test
    public void testTimestampsInResponse() throws Exception {
        ResultSet resultSet = this.client.createStatement().executeQuery("SELECT __time, CAST(__time AS DATE) AS t2 FROM druid.foo LIMIT 1");
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"__time", (Object)new Timestamp(DateTimes.of((String)"2000-01-01T00:00:00.000Z").getMillis()), (Object)"t2", (Object)new Date(DateTimes.of((String)"2000-01-01").getMillis()))), DruidAvaticaHandlerTest.getRows(resultSet));
    }

    @Test
    public void testTimestampsInResponseLosAngelesTimeZone() throws Exception {
        ResultSet resultSet = this.clientLosAngeles.createStatement().executeQuery("SELECT __time, CAST(__time AS DATE) AS t2 FROM druid.foo LIMIT 1");
        DateTimeZone timeZone = DateTimes.inferTzFromString((String)"America/Los_Angeles");
        DateTime localDateTime = new DateTime((Object)"2000-01-01T00Z", timeZone);
        List<Map<String, Object>> resultRows = DruidAvaticaHandlerTest.getRows(resultSet);
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"__time", (Object)new Timestamp(Calcites.jodaToCalciteTimestamp((DateTime)localDateTime, (DateTimeZone)timeZone)), (Object)"t2", (Object)new Date(Calcites.jodaToCalciteTimestamp((DateTime)localDateTime.dayOfMonth().roundFloorCopy(), (DateTimeZone)timeZone)))), resultRows);
    }

    @Test
    public void testFieldAliasingSelect() throws Exception {
        ResultSet resultSet = this.client.createStatement().executeQuery("SELECT dim2 AS \"x\", dim2 AS \"y\" FROM druid.foo LIMIT 1");
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"x", (Object)"a", (Object)"y", (Object)"a")), DruidAvaticaHandlerTest.getRows(resultSet));
    }

    @Test
    public void testSelectBoolean() throws Exception {
        ResultSet resultSet = this.client.createStatement().executeQuery("SELECT dim2, dim2 IS NULL AS isnull FROM druid.foo LIMIT 1");
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"dim2", (Object)"a", (Object)"isnull", (Object)false)), DruidAvaticaHandlerTest.getRows(resultSet));
    }

    @Test
    public void testExplainSelectCount() throws Exception {
        ResultSet resultSet = this.clientLosAngeles.createStatement().executeQuery("EXPLAIN PLAN FOR SELECT COUNT(*) AS cnt FROM druid.foo");
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"PLAN", (Object)StringUtils.format((String)"DruidQueryRel(query=[{\"queryType\":\"timeseries\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"descending\":false,\"virtualColumns\":[],\"filter\":null,\"granularity\":{\"type\":\"all\"},\"aggregations\":[{\"type\":\"count\",\"name\":\"a0\"}],\"postAggregations\":[],\"limit\":2147483647,\"context\":{\"sqlQueryId\":\"%s\",\"sqlStringifyArrays\":false,\"sqlTimeZone\":\"America/Los_Angeles\"}}], signature=[{a0:LONG}])\n", (Object[])new Object[]{DUMMY_SQL_QUERY_ID}), (Object)"RESOURCES", (Object)"[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]")), DruidAvaticaHandlerTest.getRows(resultSet));
    }

    @Test
    public void testDatabaseMetaDataCatalogs() throws Exception {
        DatabaseMetaData metaData = this.client.getMetaData();
        Assert.assertEquals((Object)ImmutableList.of(DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"))), DruidAvaticaHandlerTest.getRows(metaData.getCatalogs()));
    }

    @Test
    public void testDatabaseMetaDataSchemas() throws Exception {
        DatabaseMetaData metaData = this.client.getMetaData();
        Assert.assertEquals((Object)ImmutableList.of(DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CATALOG", (Object)"druid"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"))), DruidAvaticaHandlerTest.getRows(metaData.getSchemas(null, "druid")));
    }

    @Test
    public void testDatabaseMetaDataTables() throws Exception {
        DatabaseMetaData metaData = this.client.getMetaData();
        Assert.assertEquals((Object)ImmutableList.of(DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"broadcast"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo2"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo4"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"lotsocolumns"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"numfoo"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"somexdatasource"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"visits"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE"))), DruidAvaticaHandlerTest.getRows(metaData.getTables(null, "druid", "%", null), (Set<String>)ImmutableSet.of((Object)"TABLE_CAT", (Object)"TABLE_NAME", (Object)"TABLE_SCHEM", (Object)"TABLE_TYPE")));
    }

    @Test
    public void testDatabaseMetaDataTablesAsSuperuser() throws Exception {
        DatabaseMetaData metaData = this.superuserClient.getMetaData();
        Assert.assertEquals((Object)ImmutableList.of(DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"broadcast"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo2"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo4"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"forbiddenDatasource"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"lotsocolumns"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"numfoo"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"somexdatasource"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"visits"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE"))), DruidAvaticaHandlerTest.getRows(metaData.getTables(null, "druid", "%", null), (Set<String>)ImmutableSet.of((Object)"TABLE_CAT", (Object)"TABLE_NAME", (Object)"TABLE_SCHEM", (Object)"TABLE_TYPE")));
    }

    @Test
    public void testDatabaseMetaDataColumns() throws Exception {
        DatabaseMetaData metaData = this.client.getMetaData();
        Assert.assertEquals((Object)ImmutableList.of(DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo"), Pair.of((Object)"COLUMN_NAME", (Object)"__time"), Pair.of((Object)"DATA_TYPE", (Object)93), Pair.of((Object)"TYPE_NAME", (Object)"TIMESTAMP"), Pair.of((Object)"IS_NULLABLE", (Object)"NO")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo"), Pair.of((Object)"COLUMN_NAME", (Object)"cnt"), Pair.of((Object)"DATA_TYPE", (Object)-5), Pair.of((Object)"TYPE_NAME", (Object)"BIGINT"), Pair.of((Object)"IS_NULLABLE", (Object)(this.nullNumeric ? "YES" : "NO"))), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo"), Pair.of((Object)"COLUMN_NAME", (Object)"dim1"), Pair.of((Object)"DATA_TYPE", (Object)12), Pair.of((Object)"TYPE_NAME", (Object)"VARCHAR"), Pair.of((Object)"IS_NULLABLE", (Object)"YES")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo"), Pair.of((Object)"COLUMN_NAME", (Object)"dim2"), Pair.of((Object)"DATA_TYPE", (Object)12), Pair.of((Object)"TYPE_NAME", (Object)"VARCHAR"), Pair.of((Object)"IS_NULLABLE", (Object)"YES")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo"), Pair.of((Object)"COLUMN_NAME", (Object)"dim3"), Pair.of((Object)"DATA_TYPE", (Object)12), Pair.of((Object)"TYPE_NAME", (Object)"VARCHAR"), Pair.of((Object)"IS_NULLABLE", (Object)"YES")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo"), Pair.of((Object)"COLUMN_NAME", (Object)"m1"), Pair.of((Object)"DATA_TYPE", (Object)6), Pair.of((Object)"TYPE_NAME", (Object)"FLOAT"), Pair.of((Object)"IS_NULLABLE", (Object)(this.nullNumeric ? "YES" : "NO"))), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo"), Pair.of((Object)"COLUMN_NAME", (Object)"m2"), Pair.of((Object)"DATA_TYPE", (Object)8), Pair.of((Object)"TYPE_NAME", (Object)"DOUBLE"), Pair.of((Object)"IS_NULLABLE", (Object)(this.nullNumeric ? "YES" : "NO"))), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo"), Pair.of((Object)"COLUMN_NAME", (Object)"unique_dim1"), Pair.of((Object)"DATA_TYPE", (Object)1111), Pair.of((Object)"TYPE_NAME", (Object)"COMPLEX<hyperUnique>"), Pair.of((Object)"IS_NULLABLE", (Object)"YES"))), DruidAvaticaHandlerTest.getRows(metaData.getColumns(null, "dr_id", "foo", null), (Set<String>)ImmutableSet.of((Object)"IS_NULLABLE", (Object)"TABLE_NAME", (Object)"TABLE_SCHEM", (Object)"COLUMN_NAME", (Object)"DATA_TYPE", (Object)"TYPE_NAME", (Object[])new String[0])));
    }

    @Test
    public void testDatabaseMetaDataColumnsOnForbiddenDatasource() throws Exception {
        DatabaseMetaData metaData = this.client.getMetaData();
        Assert.assertEquals((Object)ImmutableList.of(), DruidAvaticaHandlerTest.getRows(metaData.getColumns(null, "dr_id", "forbiddenDatasource", null), (Set<String>)ImmutableSet.of((Object)"IS_NULLABLE", (Object)"TABLE_NAME", (Object)"TABLE_SCHEM", (Object)"COLUMN_NAME", (Object)"DATA_TYPE", (Object)"TYPE_NAME", (Object[])new String[0])));
    }

    @Test
    public void testDatabaseMetaDataColumnsWithSuperuser() throws Exception {
        DatabaseMetaData metaData = this.superuserClient.getMetaData();
        Assert.assertEquals((Object)ImmutableList.of(DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"forbiddenDatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"__time"), Pair.of((Object)"DATA_TYPE", (Object)93), Pair.of((Object)"TYPE_NAME", (Object)"TIMESTAMP"), Pair.of((Object)"IS_NULLABLE", (Object)"NO")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"forbiddenDatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"cnt"), Pair.of((Object)"DATA_TYPE", (Object)-5), Pair.of((Object)"TYPE_NAME", (Object)"BIGINT"), Pair.of((Object)"IS_NULLABLE", (Object)(this.nullNumeric ? "YES" : "NO"))), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"forbiddenDatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"dim1"), Pair.of((Object)"DATA_TYPE", (Object)12), Pair.of((Object)"TYPE_NAME", (Object)"VARCHAR"), Pair.of((Object)"IS_NULLABLE", (Object)"YES")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"forbiddenDatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"dim2"), Pair.of((Object)"DATA_TYPE", (Object)12), Pair.of((Object)"TYPE_NAME", (Object)"VARCHAR"), Pair.of((Object)"IS_NULLABLE", (Object)"YES")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"forbiddenDatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"m1"), Pair.of((Object)"DATA_TYPE", (Object)6), Pair.of((Object)"TYPE_NAME", (Object)"FLOAT"), Pair.of((Object)"IS_NULLABLE", (Object)(this.nullNumeric ? "YES" : "NO"))), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"forbiddenDatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"m2"), Pair.of((Object)"DATA_TYPE", (Object)8), Pair.of((Object)"TYPE_NAME", (Object)"DOUBLE"), Pair.of((Object)"IS_NULLABLE", (Object)(this.nullNumeric ? "YES" : "NO"))), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"forbiddenDatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"unique_dim1"), Pair.of((Object)"DATA_TYPE", (Object)1111), Pair.of((Object)"TYPE_NAME", (Object)"COMPLEX<hyperUnique>"), Pair.of((Object)"IS_NULLABLE", (Object)"YES"))), DruidAvaticaHandlerTest.getRows(metaData.getColumns(null, "dr_id", "forbiddenDatasource", null), (Set<String>)ImmutableSet.of((Object)"IS_NULLABLE", (Object)"TABLE_NAME", (Object)"TABLE_SCHEM", (Object)"COLUMN_NAME", (Object)"DATA_TYPE", (Object)"TYPE_NAME", (Object[])new String[0])));
    }

    @Test(timeout=90000L)
    public void testConcurrentQueries() throws Exception {
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(AVATICA_CONFIG.getMaxStatementsPerConnection()));
        for (int i = 0; i < 2000; ++i) {
            String query = StringUtils.format((String)"SELECT COUNT(*) + %s AS ci FROM foo", (Object[])new Object[]{i});
            futures.add(exec.submit(() -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }));
        }
        List integers = (List)Futures.allAsList(futures).get();
        for (int i = 0; i < 2000; ++i) {
            Assert.assertEquals((long)(i + 6), (long)((Integer)integers.get(i)).intValue());
        }
    }

    @Test
    public void testTooManyStatements() throws Exception {
        Statement statement1 = this.client.createStatement();
        Statement statement2 = this.client.createStatement();
        Statement statement3 = this.client.createStatement();
        Statement statement4 = this.client.createStatement();
        this.expectedException.expect(AvaticaClientRuntimeException.class);
        this.expectedException.expectMessage("Too many open statements, limit is[4]");
        Statement statement5 = this.client.createStatement();
    }

    @Test
    public void testNotTooManyStatementsWhenYouCloseThem() throws Exception {
        this.client.createStatement().close();
        this.client.createStatement().close();
        this.client.createStatement().close();
        this.client.createStatement().close();
        this.client.createStatement().close();
        this.client.createStatement().close();
        this.client.createStatement().close();
        this.client.createStatement().close();
        this.client.createStatement().close();
        this.client.createStatement().close();
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testNotTooManyStatementsWhenYouFullyIterateThem() throws Exception {
        for (int i = 0; i < 50; ++i) {
            ResultSet resultSet = this.client.createStatement().executeQuery("SELECT COUNT(*) AS cnt FROM druid.foo");
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)6L)), DruidAvaticaHandlerTest.getRows(resultSet));
        }
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testNotTooManyStatementsWhenTheyThrowErrors() throws Exception {
        for (int i = 0; i < 50; ++i) {
            Exception thrown = null;
            try {
                this.client.createStatement().executeQuery("SELECT SUM(nonexistent) FROM druid.foo");
            }
            catch (Exception e) {
                thrown = e;
            }
            Assert.assertNotNull((Object)thrown);
            ResultSet resultSet = this.client.createStatement().executeQuery("SELECT COUNT(*) AS cnt FROM druid.foo");
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)6L)), DruidAvaticaHandlerTest.getRows(resultSet));
        }
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testAutoReconnectOnNoSuchConnection() throws Exception {
        for (int i = 0; i < 50; ++i) {
            ResultSet resultSet = this.client.createStatement().executeQuery("SELECT COUNT(*) AS cnt FROM druid.foo");
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)6L)), DruidAvaticaHandlerTest.getRows(resultSet));
            this.druidMeta.closeAllConnections();
        }
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testTooManyConnections() throws Exception {
        this.client.createStatement();
        this.clientLosAngeles.createStatement();
        this.superuserClient.createStatement();
        this.clientNoTrailingSlash.createStatement();
        this.expectedException.expect(AvaticaClientRuntimeException.class);
        this.expectedException.expectMessage("Too many connections");
        Connection connection5 = DriverManager.getConnection(this.url);
    }

    @Test
    public void testNotTooManyConnectionsWhenTheyAreEmpty() throws Exception {
        Connection connection1 = DriverManager.getConnection(this.url);
        connection1.createStatement().close();
        Connection connection2 = DriverManager.getConnection(this.url);
        connection2.createStatement().close();
        Connection connection3 = DriverManager.getConnection(this.url);
        connection3.createStatement().close();
        Connection connection4 = DriverManager.getConnection(this.url);
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testMaxRowsPerFrame() throws Exception {
        AvaticaServerConfig smallFrameConfig = new AvaticaServerConfig(){

            public int getMaxConnections() {
                return 2;
            }

            public int getMaxStatementsPerConnection() {
                return 4;
            }

            public int getMaxRowsPerFrame() {
                return 2;
            }
        };
        PlannerConfig plannerConfig = new PlannerConfig();
        DruidOperatorTable operatorTable = CalciteTests.createOperatorTable();
        ExprMacroTable macroTable = CalciteTests.createExprMacroTable();
        final ArrayList frames = new ArrayList();
        DruidSchemaCatalog rootSchema = CalciteTests.createMockRootSchema(conglomerate, this.walker, plannerConfig, AuthTestUtils.TEST_AUTHORIZER_MAPPER);
        DruidMeta smallFrameDruidMeta = new DruidMeta(CalciteTests.createSqlLifecycleFactory(new PlannerFactory(rootSchema, CalciteTests.createMockQueryMakerFactory(this.walker, conglomerate), operatorTable, macroTable, plannerConfig, AuthTestUtils.TEST_AUTHORIZER_MAPPER, CalciteTests.getJsonMapper(), "druid")), smallFrameConfig, new ErrorHandler(new ServerConfig()), this.injector){

            public Meta.Frame fetch(Meta.StatementHandle statement, long offset, int fetchMaxRowCount) throws NoSuchStatementException, MissingResultsException {
                Meta.Frame frame = super.fetch(statement, offset, fetchMaxRowCount);
                frames.add(frame);
                return frame;
            }
        };
        AbstractAvaticaHandler handler = this.getAvaticaHandler(smallFrameDruidMeta);
        int port = ThreadLocalRandom.current().nextInt(9999) + 20000;
        Server smallFrameServer = new Server(new InetSocketAddress("127.0.0.1", port));
        smallFrameServer.setHandler((Handler)handler);
        smallFrameServer.start();
        String smallFrameUrl = this.getJdbcConnectionString(port);
        Connection smallFrameClient = DriverManager.getConnection(smallFrameUrl, "regularUser", "druid");
        ResultSet resultSet = smallFrameClient.createStatement().executeQuery("SELECT dim1 FROM druid.foo");
        List<Map<String, Object>> rows = DruidAvaticaHandlerTest.getRows(resultSet);
        Assert.assertEquals((long)2L, (long)frames.size());
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"dim1", (Object)""), (Object)ImmutableMap.of((Object)"dim1", (Object)"10.1"), (Object)ImmutableMap.of((Object)"dim1", (Object)"2"), (Object)ImmutableMap.of((Object)"dim1", (Object)"1"), (Object)ImmutableMap.of((Object)"dim1", (Object)"def"), (Object)ImmutableMap.of((Object)"dim1", (Object)"abc")), rows);
    }

    @Test
    public void testMinRowsPerFrame() throws Exception {
        int minFetchSize = 1000;
        AvaticaServerConfig smallFrameConfig = new AvaticaServerConfig(){

            public int getMaxConnections() {
                return 2;
            }

            public int getMaxStatementsPerConnection() {
                return 4;
            }

            public int getMinRowsPerFrame() {
                return 1000;
            }
        };
        PlannerConfig plannerConfig = new PlannerConfig();
        DruidOperatorTable operatorTable = CalciteTests.createOperatorTable();
        ExprMacroTable macroTable = CalciteTests.createExprMacroTable();
        final ArrayList frames = new ArrayList();
        DruidSchemaCatalog rootSchema = CalciteTests.createMockRootSchema(conglomerate, this.walker, plannerConfig, AuthTestUtils.TEST_AUTHORIZER_MAPPER);
        DruidMeta smallFrameDruidMeta = new DruidMeta(CalciteTests.createSqlLifecycleFactory(new PlannerFactory(rootSchema, CalciteTests.createMockQueryMakerFactory(this.walker, conglomerate), operatorTable, macroTable, plannerConfig, AuthTestUtils.TEST_AUTHORIZER_MAPPER, CalciteTests.getJsonMapper(), "druid")), smallFrameConfig, new ErrorHandler(new ServerConfig()), this.injector){

            public Meta.Frame fetch(Meta.StatementHandle statement, long offset, int fetchMaxRowCount) throws NoSuchStatementException, MissingResultsException {
                Assert.assertEquals((long)1000L, (long)fetchMaxRowCount);
                Meta.Frame frame = super.fetch(statement, offset, fetchMaxRowCount);
                frames.add(frame);
                return frame;
            }
        };
        AbstractAvaticaHandler handler = this.getAvaticaHandler(smallFrameDruidMeta);
        int port = ThreadLocalRandom.current().nextInt(9999) + 20000;
        Server smallFrameServer = new Server(new InetSocketAddress("127.0.0.1", port));
        smallFrameServer.setHandler((Handler)handler);
        smallFrameServer.start();
        String smallFrameUrl = this.getJdbcConnectionString(port);
        Connection smallFrameClient = DriverManager.getConnection(smallFrameUrl, "regularUser", "druid");
        PreparedStatement statement = smallFrameClient.prepareStatement("SELECT dim1 FROM druid.foo");
        statement.setFetchSize(2);
        ResultSet resultSet = statement.executeQuery();
        List<Map<String, Object>> rows = DruidAvaticaHandlerTest.getRows(resultSet);
        Assert.assertEquals((long)0L, (long)frames.size());
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"dim1", (Object)""), (Object)ImmutableMap.of((Object)"dim1", (Object)"10.1"), (Object)ImmutableMap.of((Object)"dim1", (Object)"2"), (Object)ImmutableMap.of((Object)"dim1", (Object)"1"), (Object)ImmutableMap.of((Object)"dim1", (Object)"def"), (Object)ImmutableMap.of((Object)"dim1", (Object)"abc")), rows);
    }

    @Test
    public void testSqlRequestLog() throws Exception {
        for (int i = 0; i < 3; ++i) {
            this.client.createStatement().executeQuery("SELECT COUNT(*) AS cnt FROM druid.foo");
        }
        Assert.assertEquals((long)3L, (long)this.testRequestLogger.getSqlQueryLogs().size());
        for (RequestLogLine logLine : this.testRequestLogger.getSqlQueryLogs()) {
            Map stats = logLine.getQueryStats().getStats();
            Assert.assertEquals((Object)true, stats.get("success"));
            Assert.assertEquals((Object)"regularUser", stats.get("identity"));
            Assert.assertTrue((boolean)stats.containsKey("sqlQuery/time"));
            Assert.assertTrue((boolean)stats.containsKey("sqlQuery/bytes"));
        }
        this.testRequestLogger.clear();
        try {
            this.client.createStatement().executeQuery("SELECT notexist FROM druid.foo");
            Assert.fail((String)"invalid SQL should throw SQLException");
        }
        catch (SQLException i) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)this.testRequestLogger.getSqlQueryLogs().size());
        Map stats = ((RequestLogLine)this.testRequestLogger.getSqlQueryLogs().get(0)).getQueryStats().getStats();
        Assert.assertEquals((Object)false, stats.get("success"));
        Assert.assertEquals((Object)"regularUser", stats.get("identity"));
        Assert.assertTrue((boolean)stats.containsKey("exception"));
        this.testRequestLogger.clear();
        try {
            this.client.createStatement().executeQuery("SELECT count(*) FROM druid.forbiddenDatasource");
            Assert.fail((String)"unauthorzed SQL should throw SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.testRequestLogger.getSqlQueryLogs().size());
    }

    @Test
    public void testParameterBinding() throws Exception {
        PreparedStatement statement = this.client.prepareStatement("SELECT COUNT(*) AS cnt FROM druid.foo WHERE dim1 = ? OR dim1 = ?");
        statement.setString(1, "abc");
        statement.setString(2, "def");
        ResultSet resultSet = statement.executeQuery();
        List<Map<String, Object>> rows = DruidAvaticaHandlerTest.getRows(resultSet);
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)2L)), rows);
    }

    @Test
    public void testSysTableParameterBindingRegularUser() throws Exception {
        PreparedStatement statement = this.client.prepareStatement("SELECT COUNT(*) AS cnt FROM sys.servers WHERE servers.host = ?");
        statement.setString(1, DUMMY_SQL_QUERY_ID);
        Assert.assertThrows((String)"Insufficient permission to view servers", AvaticaSqlException.class, statement::executeQuery);
    }

    @Test
    public void testSysTableParameterBindingSuperUser() throws Exception {
        PreparedStatement statement = this.superuserClient.prepareStatement("SELECT COUNT(*) AS cnt FROM sys.servers WHERE servers.host = ?");
        statement.setString(1, DUMMY_SQL_QUERY_ID);
        ResultSet resultSet = statement.executeQuery();
        List<Map<String, Object>> rows = DruidAvaticaHandlerTest.getRows(resultSet);
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)1L)), rows);
    }

    @Test
    public void testExtendedCharacters() throws Exception {
        ResultSet resultSet = this.client.createStatement().executeQuery("SELECT COUNT(*) AS cnt FROM druid.lotsocolumns WHERE dimMultivalEnumerated = '\u3151 \u3153 \u3155 \u3157 \u315b \u315c \u3160 \u3161 \u3163'");
        List<Map<String, Object>> rows = DruidAvaticaHandlerTest.getRows(resultSet);
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)1L)), rows);
        PreparedStatement statement = this.client.prepareStatement("SELECT COUNT(*) AS cnt FROM druid.lotsocolumns WHERE dimMultivalEnumerated = ?");
        statement.setString(1, "\u3151 \u3153 \u3155 \u3157 \u315b \u315c \u3160 \u3161 \u3163");
        ResultSet resultSet2 = statement.executeQuery();
        List<Map<String, Object>> rows2 = DruidAvaticaHandlerTest.getRows(resultSet2);
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)1L)), rows);
        Assert.assertEquals(rows, rows2);
    }

    @Test
    public void testEscapingForGetColumns() throws Exception {
        DatabaseMetaData metaData = this.client.getMetaData();
        ImmutableList someDatasourceColumns = ImmutableList.of(DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource"), Pair.of((Object)"COLUMN_NAME", (Object)"__time")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource"), Pair.of((Object)"COLUMN_NAME", (Object)"cnt")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource"), Pair.of((Object)"COLUMN_NAME", (Object)"dim1")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource"), Pair.of((Object)"COLUMN_NAME", (Object)"dim2")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource"), Pair.of((Object)"COLUMN_NAME", (Object)"dim3")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource"), Pair.of((Object)"COLUMN_NAME", (Object)"m1")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource"), Pair.of((Object)"COLUMN_NAME", (Object)"m2")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource"), Pair.of((Object)"COLUMN_NAME", (Object)"unique_dim1")));
        Assert.assertEquals((Object)someDatasourceColumns, DruidAvaticaHandlerTest.getRows(metaData.getColumns(null, "dr_id", "some\\_datasource", null), (Set<String>)ImmutableSet.of((Object)"TABLE_NAME", (Object)"TABLE_SCHEM", (Object)"COLUMN_NAME")));
        ImmutableList someXDatasourceColumns = ImmutableList.of(DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"somexdatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"__time")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"somexdatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"cnt_x")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"somexdatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"m1_x")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"somexdatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"m2_x")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"somexdatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"unique_dim1_x")));
        Assert.assertEquals((Object)someXDatasourceColumns, DruidAvaticaHandlerTest.getRows(metaData.getColumns(null, "dr_id", "somexdatasource", null), (Set<String>)ImmutableSet.of((Object)"TABLE_NAME", (Object)"TABLE_SCHEM", (Object)"COLUMN_NAME")));
        ArrayList columnsOfBothTables = new ArrayList(someDatasourceColumns);
        columnsOfBothTables.addAll(someXDatasourceColumns);
        Assert.assertEquals(columnsOfBothTables, DruidAvaticaHandlerTest.getRows(metaData.getColumns(null, "dr_id", "some_datasource", null), (Set<String>)ImmutableSet.of((Object)"TABLE_NAME", (Object)"TABLE_SCHEM", (Object)"COLUMN_NAME")));
        Assert.assertEquals((Object)ImmutableList.of(DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"somexdatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"m1_x")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"somexdatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"m2_x"))), DruidAvaticaHandlerTest.getRows(metaData.getColumns("druid", "dr_id", "somexdatasource", "m_\\_x"), (Set<String>)ImmutableSet.of((Object)"TABLE_NAME", (Object)"TABLE_SCHEM", (Object)"COLUMN_NAME")));
        Assert.assertEquals((Object)ImmutableList.of(DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource"), Pair.of((Object)"COLUMN_NAME", (Object)"m1")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource"), Pair.of((Object)"COLUMN_NAME", (Object)"m2")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"somexdatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"m1_x")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"somexdatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"m2_x"))), DruidAvaticaHandlerTest.getRows(metaData.getColumns("druid", "dr_id", "some_datasource", "m%"), (Set<String>)ImmutableSet.of((Object)"TABLE_NAME", (Object)"TABLE_SCHEM", (Object)"COLUMN_NAME")));
    }

    @Test
    public void testEscapingForGetTables() throws Exception {
        DatabaseMetaData metaData = this.client.getMetaData();
        Assert.assertEquals((Object)ImmutableList.of(DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource"))), DruidAvaticaHandlerTest.getRows(metaData.getTables("druid", "dr_id", "some\\_datasource", null), (Set<String>)ImmutableSet.of((Object)"TABLE_SCHEM", (Object)"TABLE_NAME")));
        Assert.assertEquals((Object)ImmutableList.of(DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"somexdatasource"))), DruidAvaticaHandlerTest.getRows(metaData.getTables("druid", "dr_id", "somexdatasource", null), (Set<String>)ImmutableSet.of((Object)"TABLE_SCHEM", (Object)"TABLE_NAME")));
        Assert.assertEquals((Object)ImmutableList.of(DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"somexdatasource"))), DruidAvaticaHandlerTest.getRows(metaData.getTables("druid", "dr_id", "some_datasource", null), (Set<String>)ImmutableSet.of((Object)"TABLE_SCHEM", (Object)"TABLE_NAME")));
    }

    @Test
    public void testArrayStuffs() throws Exception {
        PreparedStatement statement = this.client.prepareStatement("SELECT ARRAY_AGG(dim2) AS arr1, ARRAY_AGG(l1) AS arr2, ARRAY_AGG(d1)  AS arr3, ARRAY_AGG(f1) AS arr4 FROM druid.numfoo");
        ResultSet resultSet = statement.executeQuery();
        List<Map<String, Object>> rows = DruidAvaticaHandlerTest.getRows(resultSet);
        Assert.assertEquals((long)1L, (long)rows.size());
        Assert.assertTrue((boolean)rows.get(0).containsKey("arr1"));
        Assert.assertTrue((boolean)rows.get(0).containsKey("arr2"));
        Assert.assertTrue((boolean)rows.get(0).containsKey("arr3"));
        Assert.assertTrue((boolean)rows.get(0).containsKey("arr4"));
        if (NullHandling.sqlCompatible()) {
            Assert.assertArrayEquals((Object[])new Object[]{"a", null, "", "a", "abc", null}, (Object[])((Object[])rows.get(0).get("arr1")));
            Assert.assertArrayEquals((Object[])new Object[]{7L, 325323L, 0L, null, null, null}, (Object[])((Object[])rows.get(0).get("arr2")));
            Assert.assertArrayEquals((Object[])new Object[]{1.0, 1.7, 0.0, null, null, null}, (Object[])((Object[])rows.get(0).get("arr3")));
            Assert.assertArrayEquals((Object[])new Object[]{Float.valueOf(1.0f), Float.valueOf(0.1f), Float.valueOf(0.0f), null, null, null}, (Object[])((Object[])rows.get(0).get("arr4")));
        } else {
            Assert.assertArrayEquals((Object[])new Object[]{"a", null, null, "a", "abc", null}, (Object[])((Object[])rows.get(0).get("arr1")));
            Assert.assertArrayEquals((Object[])new Object[]{7L, 325323L, 0L, 0L, 0L, 0L}, (Object[])((Object[])rows.get(0).get("arr2")));
            Assert.assertArrayEquals((Object[])new Object[]{1.0, 1.7, 0.0, 0.0, 0.0, 0.0}, (Object[])((Object[])rows.get(0).get("arr3")));
            Assert.assertArrayEquals((Object[])new Object[]{Float.valueOf(1.0f), Float.valueOf(0.1f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)}, (Object[])((Object[])rows.get(0).get("arr4")));
        }
    }

    protected abstract String getJdbcConnectionString(int var1);

    protected abstract AbstractAvaticaHandler getAvaticaHandler(DruidMeta var1);

    private static List<Map<String, Object>> getRows(ResultSet resultSet) throws SQLException {
        return DruidAvaticaHandlerTest.getRows(resultSet, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Map<String, Object>> getRows(ResultSet resultSet, Set<String> returnKeys) throws SQLException {
        try {
            ResultSetMetaData metaData = resultSet.getMetaData();
            ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
            while (resultSet.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                for (int i = 0; i < metaData.getColumnCount(); ++i) {
                    if (returnKeys != null && !returnKeys.contains(metaData.getColumnLabel(i + 1))) continue;
                    Object result = resultSet.getObject(i + 1);
                    if (result instanceof Array) {
                        row.put(metaData.getColumnLabel(i + 1), ((Array)result).getArray());
                        continue;
                    }
                    row.put(metaData.getColumnLabel(i + 1), result);
                }
                rows.add(row);
            }
            ArrayList<Map<String, Object>> arrayList = rows;
            return arrayList;
        }
        finally {
            resultSet.close();
        }
    }

    private static Map<String, Object> row(Pair<String, ?> ... entries) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (Pair<String, ?> entry : entries) {
            m.put((String)entry.lhs, entry.rhs);
        }
        return m;
    }
}

