/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.calcite.avatica.SqlType;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.query.QueryContext;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.RequestLogLine;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.sql.SqlLifecycle;
import org.apache.druid.sql.SqlLifecycleFactory;
import org.apache.druid.sql.calcite.planner.DruidPlanner;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.planner.PlannerResult;
import org.apache.druid.sql.calcite.planner.PrepareResult;
import org.apache.druid.sql.calcite.planner.ValidationResult;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.http.SqlParameter;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SqlLifecycleTest {
    private PlannerFactory plannerFactory;
    private ServiceEmitter serviceEmitter;
    private RequestLogger requestLogger;
    private SqlLifecycleFactory sqlLifecycleFactory;

    @Before
    public void setup() {
        this.plannerFactory = (PlannerFactory)EasyMock.createMock(PlannerFactory.class);
        this.serviceEmitter = (ServiceEmitter)EasyMock.createMock(ServiceEmitter.class);
        this.requestLogger = (RequestLogger)EasyMock.createMock(RequestLogger.class);
        this.sqlLifecycleFactory = new SqlLifecycleFactory(this.plannerFactory, this.serviceEmitter, this.requestLogger, QueryStackTests.DEFAULT_NOOP_SCHEDULER, new AuthConfig());
    }

    @Test
    public void testIgnoredQueryContextParametersAreIgnored() {
        SqlLifecycle lifecycle = this.sqlLifecycleFactory.factorize();
        String sql = "select 1 + ?";
        ImmutableMap queryContext = ImmutableMap.of((Object)"bySegment", (Object)"true");
        lifecycle.initialize("select 1 + ?", new QueryContext((Map)queryContext));
        Assert.assertEquals((Object)SqlLifecycle.State.INITIALIZED, (Object)lifecycle.getState());
        Assert.assertEquals((long)1L, (long)lifecycle.getQueryContext().getMergedParams().size());
        Assert.assertTrue((boolean)lifecycle.getQueryContext().getMergedParams().containsKey("sqlQueryId"));
    }

    @Test
    public void testStateTransition() throws ValidationException, SqlParseException, RelConversionException, IOException {
        SqlLifecycle lifecycle = this.sqlLifecycleFactory.factorize();
        String sql = "select 1 + ?";
        Assert.assertEquals((Object)SqlLifecycle.State.NEW, (Object)lifecycle.getState());
        lifecycle.initialize("select 1 + ?", new QueryContext());
        Assert.assertEquals((Object)SqlLifecycle.State.INITIALIZED, (Object)lifecycle.getState());
        ImmutableList parameters = ImmutableList.of((Object)new SqlParameter(SqlType.BIGINT, (Object)1L).getTypedValue());
        lifecycle.setParameters((List)parameters);
        Assert.assertEquals((Object)SqlLifecycle.State.INITIALIZED, (Object)lifecycle.getState());
        DruidPlanner mockPlanner = (DruidPlanner)EasyMock.createMock(DruidPlanner.class);
        PlannerContext mockPlannerContext = (PlannerContext)EasyMock.createMock(PlannerContext.class);
        ValidationResult validationResult = new ValidationResult(Collections.emptySet());
        EasyMock.expect((Object)this.plannerFactory.createPlanner((String)EasyMock.eq((Object)"select 1 + ?"), (QueryContext)EasyMock.anyObject())).andReturn((Object)mockPlanner).once();
        EasyMock.expect((Object)mockPlanner.getPlannerContext()).andReturn((Object)mockPlannerContext).once();
        mockPlannerContext.setAuthenticationResult(CalciteTests.REGULAR_USER_AUTH_RESULT);
        EasyMock.expectLastCall();
        mockPlannerContext.setParameters((List)parameters);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.plannerFactory.getAuthorizerMapper()).andReturn((Object)CalciteTests.TEST_AUTHORIZER_MAPPER).once();
        mockPlannerContext.setAuthorizationResult(Access.OK);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)mockPlanner.validate(false)).andReturn((Object)validationResult).once();
        mockPlanner.close();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext});
        lifecycle.validateAndAuthorize(CalciteTests.REGULAR_USER_AUTH_RESULT);
        Assert.assertEquals((Object)SqlLifecycle.State.AUTHORIZED, (Object)lifecycle.getState());
        EasyMock.verify((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext});
        EasyMock.reset((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext});
        PrepareResult mockPrepareResult = (PrepareResult)EasyMock.createMock(PrepareResult.class);
        EasyMock.expect((Object)this.plannerFactory.createPlannerWithContext((PlannerContext)EasyMock.eq((Object)mockPlannerContext))).andReturn((Object)mockPlanner).once();
        EasyMock.expect((Object)mockPlanner.prepare()).andReturn((Object)mockPrepareResult).once();
        mockPlanner.close();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, mockPrepareResult});
        lifecycle.prepare();
        Assert.assertEquals((Object)SqlLifecycle.State.AUTHORIZED, (Object)lifecycle.getState());
        EasyMock.verify((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, mockPrepareResult});
        EasyMock.reset((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, mockPrepareResult});
        PlannerResult mockPlanResult = (PlannerResult)EasyMock.createMock(PlannerResult.class);
        EasyMock.expect((Object)this.plannerFactory.createPlannerWithContext((PlannerContext)EasyMock.eq((Object)mockPlannerContext))).andReturn((Object)mockPlanner).once();
        EasyMock.expect((Object)mockPlanner.plan()).andReturn((Object)mockPlanResult).once();
        mockPlanner.close();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, mockPrepareResult, mockPlanResult});
        lifecycle.plan();
        Assert.assertEquals((Object)mockPlannerContext, (Object)lifecycle.getPlannerContext());
        Assert.assertEquals((Object)SqlLifecycle.State.PLANNED, (Object)lifecycle.getState());
        EasyMock.verify((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, mockPrepareResult, mockPlanResult});
        EasyMock.reset((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, mockPrepareResult, mockPlanResult});
        EasyMock.expect((Object)mockPlanResult.run()).andReturn((Object)Sequences.simple((Iterable)ImmutableList.of((Object)new Object[]{2L}))).once();
        EasyMock.replay((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, mockPrepareResult, mockPlanResult});
        lifecycle.execute();
        Assert.assertEquals((Object)SqlLifecycle.State.EXECUTING, (Object)lifecycle.getState());
        EasyMock.verify((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, mockPrepareResult, mockPlanResult});
        EasyMock.reset((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, mockPrepareResult, mockPlanResult});
        EasyMock.expect((Object)mockPlannerContext.getSqlQueryId()).andReturn((Object)"id").once();
        CopyOnWriteArrayList nativeQueryIds = new CopyOnWriteArrayList(ImmutableList.of((Object)"id"));
        EasyMock.expect((Object)mockPlannerContext.getNativeQueryIds()).andReturn(nativeQueryIds).times(2);
        EasyMock.expect((Object)mockPlannerContext.getAuthenticationResult()).andReturn((Object)CalciteTests.REGULAR_USER_AUTH_RESULT).once();
        this.serviceEmitter.emit((ServiceEventBuilder)EasyMock.anyObject(ServiceEventBuilder.class));
        EasyMock.expectLastCall();
        this.serviceEmitter.emit((ServiceEventBuilder)EasyMock.anyObject(ServiceEventBuilder.class));
        EasyMock.expectLastCall();
        this.requestLogger.logSqlQuery((RequestLogLine)EasyMock.anyObject());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, mockPrepareResult, mockPlanResult});
        lifecycle.finalizeStateAndEmitLogsAndMetrics(null, null, 10L);
        Assert.assertEquals((Object)SqlLifecycle.State.DONE, (Object)lifecycle.getState());
        EasyMock.verify((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, mockPrepareResult, mockPlanResult});
        EasyMock.reset((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, mockPrepareResult, mockPlanResult});
    }

    @Test
    public void testStateTransitionHttpRequest() throws ValidationException, SqlParseException, RelConversionException, IOException {
        SqlLifecycle lifecycle = this.sqlLifecycleFactory.factorize();
        String sql = "select 1 + ?";
        Assert.assertEquals((Object)SqlLifecycle.State.NEW, (Object)lifecycle.getState());
        lifecycle.initialize("select 1 + ?", new QueryContext());
        Assert.assertEquals((Object)SqlLifecycle.State.INITIALIZED, (Object)lifecycle.getState());
        ImmutableList parameters = ImmutableList.of((Object)new SqlParameter(SqlType.BIGINT, (Object)1L).getTypedValue());
        lifecycle.setParameters((List)parameters);
        Assert.assertEquals((Object)SqlLifecycle.State.INITIALIZED, (Object)lifecycle.getState());
        DruidPlanner mockPlanner = (DruidPlanner)EasyMock.createMock(DruidPlanner.class);
        PlannerContext mockPlannerContext = (PlannerContext)EasyMock.createMock(PlannerContext.class);
        ValidationResult validationResult = new ValidationResult(Collections.emptySet());
        EasyMock.expect((Object)this.plannerFactory.createPlanner((String)EasyMock.eq((Object)"select 1 + ?"), (QueryContext)EasyMock.anyObject())).andReturn((Object)mockPlanner).once();
        EasyMock.expect((Object)mockPlanner.getPlannerContext()).andReturn((Object)mockPlannerContext).once();
        mockPlannerContext.setAuthenticationResult(CalciteTests.REGULAR_USER_AUTH_RESULT);
        EasyMock.expectLastCall();
        mockPlannerContext.setParameters((List)parameters);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.plannerFactory.getAuthorizerMapper()).andReturn((Object)CalciteTests.TEST_AUTHORIZER_MAPPER).once();
        mockPlannerContext.setAuthorizationResult(Access.OK);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)mockPlanner.validate(false)).andReturn((Object)validationResult).once();
        mockPlanner.close();
        EasyMock.expectLastCall();
        HttpServletRequest request = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        EasyMock.expect((Object)request.getAttribute("Druid-Authentication-Result")).andReturn((Object)CalciteTests.REGULAR_USER_AUTH_RESULT).times(2);
        EasyMock.expect((Object)request.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).once();
        EasyMock.expect((Object)request.getAttribute("Druid-Authorization-Checked")).andReturn(null).once();
        request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, request});
        lifecycle.validateAndAuthorize(request);
        Assert.assertEquals((Object)SqlLifecycle.State.AUTHORIZED, (Object)lifecycle.getState());
        EasyMock.verify((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, request});
        EasyMock.reset((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, request});
        PrepareResult mockPrepareResult = (PrepareResult)EasyMock.createMock(PrepareResult.class);
        EasyMock.expect((Object)this.plannerFactory.createPlannerWithContext((PlannerContext)EasyMock.eq((Object)mockPlannerContext))).andReturn((Object)mockPlanner).once();
        EasyMock.expect((Object)mockPlanner.prepare()).andReturn((Object)mockPrepareResult).once();
        mockPlanner.close();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, mockPrepareResult});
        lifecycle.prepare();
        Assert.assertEquals((Object)SqlLifecycle.State.AUTHORIZED, (Object)lifecycle.getState());
        EasyMock.verify((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, mockPrepareResult});
        EasyMock.reset((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, mockPrepareResult});
        PlannerResult mockPlanResult = (PlannerResult)EasyMock.createMock(PlannerResult.class);
        EasyMock.expect((Object)this.plannerFactory.createPlannerWithContext((PlannerContext)EasyMock.eq((Object)mockPlannerContext))).andReturn((Object)mockPlanner).once();
        EasyMock.expect((Object)mockPlanner.plan()).andReturn((Object)mockPlanResult).once();
        mockPlanner.close();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, mockPrepareResult, mockPlanResult});
        lifecycle.plan();
        Assert.assertEquals((Object)mockPlannerContext, (Object)lifecycle.getPlannerContext());
        Assert.assertEquals((Object)SqlLifecycle.State.PLANNED, (Object)lifecycle.getState());
        EasyMock.verify((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, mockPrepareResult, mockPlanResult});
        EasyMock.reset((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, mockPrepareResult, mockPlanResult});
        EasyMock.expect((Object)mockPlanResult.run()).andReturn((Object)Sequences.simple((Iterable)ImmutableList.of((Object)new Object[]{2L}))).once();
        EasyMock.replay((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, mockPrepareResult, mockPlanResult});
        lifecycle.execute();
        Assert.assertEquals((Object)SqlLifecycle.State.EXECUTING, (Object)lifecycle.getState());
        EasyMock.verify((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, mockPrepareResult, mockPlanResult});
        EasyMock.reset((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, mockPrepareResult, mockPlanResult});
        EasyMock.expect((Object)mockPlannerContext.getSqlQueryId()).andReturn((Object)"id").once();
        CopyOnWriteArrayList nativeQueryIds = new CopyOnWriteArrayList(ImmutableList.of((Object)"id"));
        EasyMock.expect((Object)mockPlannerContext.getNativeQueryIds()).andReturn(nativeQueryIds).times(2);
        EasyMock.expect((Object)mockPlannerContext.getAuthenticationResult()).andReturn((Object)CalciteTests.REGULAR_USER_AUTH_RESULT).once();
        this.serviceEmitter.emit((ServiceEventBuilder)EasyMock.anyObject(ServiceEventBuilder.class));
        EasyMock.expectLastCall();
        this.serviceEmitter.emit((ServiceEventBuilder)EasyMock.anyObject(ServiceEventBuilder.class));
        EasyMock.expectLastCall();
        this.requestLogger.logSqlQuery((RequestLogLine)EasyMock.anyObject());
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, mockPrepareResult, mockPlanResult});
        lifecycle.finalizeStateAndEmitLogsAndMetrics(null, null, 10L);
        Assert.assertEquals((Object)SqlLifecycle.State.DONE, (Object)lifecycle.getState());
        EasyMock.verify((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, mockPrepareResult, mockPlanResult});
        EasyMock.reset((Object[])new Object[]{this.plannerFactory, this.serviceEmitter, this.requestLogger, mockPlanner, mockPlannerContext, mockPrepareResult, mockPlanResult});
    }
}

