/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.druid.sql.SqlLifecycle;
import org.apache.druid.sql.SqlLifecycleManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class SqlLifecycleManagerTest {
    private SqlLifecycleManager lifecycleManager;

    @Before
    public void setup() {
        this.lifecycleManager = new SqlLifecycleManager();
    }

    @Test
    public void testAddNonAuthorizedLifeCycle() {
        SqlLifecycle lifecycle = SqlLifecycleManagerTest.mockLifecycle(SqlLifecycle.State.INITIALIZED);
        Assert.assertThrows(AssertionError.class, () -> this.lifecycleManager.add("sqlId", lifecycle));
    }

    @Test
    public void testAddAuthorizedLifecycle() {
        String sqlId = "sqlId";
        SqlLifecycle lifecycle = SqlLifecycleManagerTest.mockLifecycle(SqlLifecycle.State.AUTHORIZED);
        this.lifecycleManager.add("sqlId", lifecycle);
        Assert.assertEquals((Object)ImmutableList.of((Object)lifecycle), (Object)this.lifecycleManager.getAll("sqlId"));
    }

    @Test
    public void testRemoveValidLifecycle() {
        String sqlId = "sqlId";
        SqlLifecycle lifecycle = SqlLifecycleManagerTest.mockLifecycle(SqlLifecycle.State.AUTHORIZED);
        this.lifecycleManager.add("sqlId", lifecycle);
        Assert.assertEquals((Object)ImmutableList.of((Object)lifecycle), (Object)this.lifecycleManager.getAll("sqlId"));
        this.lifecycleManager.remove("sqlId", lifecycle);
        Assert.assertEquals((Object)ImmutableList.of(), (Object)this.lifecycleManager.getAll("sqlId"));
    }

    @Test
    public void testRemoveInvalidSqlQueryId() {
        String sqlId = "sqlId";
        SqlLifecycle lifecycle = SqlLifecycleManagerTest.mockLifecycle(SqlLifecycle.State.AUTHORIZED);
        this.lifecycleManager.add("sqlId", lifecycle);
        Assert.assertEquals((Object)ImmutableList.of((Object)lifecycle), (Object)this.lifecycleManager.getAll("sqlId"));
        this.lifecycleManager.remove("invalid", lifecycle);
        Assert.assertEquals((Object)ImmutableList.of((Object)lifecycle), (Object)this.lifecycleManager.getAll("sqlId"));
    }

    @Test
    public void testRemoveValidSqlQueryIdDifferntLifecycleObject() {
        String sqlId = "sqlId";
        SqlLifecycle lifecycle = SqlLifecycleManagerTest.mockLifecycle(SqlLifecycle.State.AUTHORIZED);
        this.lifecycleManager.add("sqlId", lifecycle);
        Assert.assertEquals((Object)ImmutableList.of((Object)lifecycle), (Object)this.lifecycleManager.getAll("sqlId"));
        this.lifecycleManager.remove("sqlId", SqlLifecycleManagerTest.mockLifecycle(SqlLifecycle.State.AUTHORIZED));
        Assert.assertEquals((Object)ImmutableList.of((Object)lifecycle), (Object)this.lifecycleManager.getAll("sqlId"));
    }

    @Test
    public void testRemoveAllValidSqlQueryIdSubsetOfLifecycles() {
        String sqlId = "sqlId";
        ImmutableList lifecycles = ImmutableList.of((Object)SqlLifecycleManagerTest.mockLifecycle(SqlLifecycle.State.AUTHORIZED), (Object)SqlLifecycleManagerTest.mockLifecycle(SqlLifecycle.State.AUTHORIZED), (Object)SqlLifecycleManagerTest.mockLifecycle(SqlLifecycle.State.AUTHORIZED));
        lifecycles.forEach(lifecycle -> this.lifecycleManager.add("sqlId", lifecycle));
        Assert.assertEquals((Object)lifecycles, (Object)this.lifecycleManager.getAll("sqlId"));
        this.lifecycleManager.removeAll("sqlId", (List)ImmutableList.of(lifecycles.get(0), lifecycles.get(1)));
        Assert.assertEquals((Object)ImmutableList.of(lifecycles.get(2)), (Object)this.lifecycleManager.getAll("sqlId"));
    }

    @Test
    public void testRemoveAllInvalidSqlQueryId() {
        String sqlId = "sqlId";
        ImmutableList lifecycles = ImmutableList.of((Object)SqlLifecycleManagerTest.mockLifecycle(SqlLifecycle.State.AUTHORIZED), (Object)SqlLifecycleManagerTest.mockLifecycle(SqlLifecycle.State.AUTHORIZED), (Object)SqlLifecycleManagerTest.mockLifecycle(SqlLifecycle.State.AUTHORIZED));
        lifecycles.forEach(lifecycle -> this.lifecycleManager.add("sqlId", lifecycle));
        Assert.assertEquals((Object)lifecycles, (Object)this.lifecycleManager.getAll("sqlId"));
        this.lifecycleManager.removeAll("invalid", (List)ImmutableList.of(lifecycles.get(0), lifecycles.get(1)));
        Assert.assertEquals((Object)lifecycles, (Object)this.lifecycleManager.getAll("sqlId"));
    }

    @Test
    public void testGetAllReturnsListCopy() {
        String sqlId = "sqlId";
        ImmutableList lifecycles = ImmutableList.of((Object)SqlLifecycleManagerTest.mockLifecycle(SqlLifecycle.State.AUTHORIZED), (Object)SqlLifecycleManagerTest.mockLifecycle(SqlLifecycle.State.AUTHORIZED), (Object)SqlLifecycleManagerTest.mockLifecycle(SqlLifecycle.State.AUTHORIZED));
        lifecycles.forEach(lifecycle -> this.lifecycleManager.add("sqlId", lifecycle));
        List lifecyclesFromGetAll = this.lifecycleManager.getAll("sqlId");
        this.lifecycleManager.removeAll("sqlId", lifecyclesFromGetAll);
        Assert.assertEquals((Object)lifecycles, (Object)lifecyclesFromGetAll);
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("sqlId").isEmpty());
    }

    private static SqlLifecycle mockLifecycle(SqlLifecycle.State state) {
        SqlLifecycle lifecycle = (SqlLifecycle)Mockito.mock(SqlLifecycle.class);
        Mockito.when((Object)lifecycle.getState()).thenReturn((Object)state);
        return lifecycle;
    }
}

