/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.github.rvesse.airline.annotations.Arguments;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.restrictions.Required;
import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.List;
import org.apache.druid.cli.GuiceRunnable;
import org.apache.druid.guice.DruidProcessingModule;
import org.apache.druid.guice.QueryRunnerFactoryModule;
import org.apache.druid.guice.QueryableModule;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.IndexIO;

@Command(name="validate-segments", description="Compare two segments for validation")
public class ValidateSegments
extends GuiceRunnable {
    private static final Logger log = new Logger(ValidateSegments.class);
    @Arguments(description="Two directories where each directory contains segment files to validate.")
    @Required
    public List<String> directories;

    public ValidateSegments() {
        super(log);
    }

    @Override
    public void run() {
        if (this.directories.size() != 2) {
            throw new IAE("Please provide two segment directories to compare", new Object[0]);
        }
        Injector injector = this.makeInjector();
        IndexIO indexIO = (IndexIO)injector.getInstance(IndexIO.class);
        try {
            String dir1 = this.directories.get(0);
            String dir2 = this.directories.get(1);
            indexIO.validateTwoSegments(new File(dir1), new File(dir2));
            log.info("Segments [%s] and [%s] are identical", new Object[]{dir1, dir2});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new DruidProcessingModule(), (Object)new QueryableModule(), (Object)new QueryRunnerFactoryModule(), binder -> {
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/tool");
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(9999);
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(-1);
        });
    }
}

