/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.restrictions.Required;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import java.util.List;
import org.apache.druid.cli.GuiceRunnable;
import org.apache.druid.guice.DruidProcessingModule;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.QueryRunnerFactoryModule;
import org.apache.druid.guice.QueryableModule;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.MetadataStorageConnector;
import org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.server.DruidNode;

@Command(name="metadata-init", description="Initialize Metadata Storage")
public class CreateTables
extends GuiceRunnable {
    @Option(name={"--connectURI"}, description="Database JDBC connection string")
    @Required
    private String connectURI;
    @Option(name={"--user"}, description="Database username")
    @Required
    private String user;
    @Option(name={"--password"}, description="Database password")
    @Required
    private String password;
    @Option(name={"--base"}, description="Base table name")
    private String base;
    private static final Logger log = new Logger(CreateTables.class);

    public CreateTables() {
        super(log);
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new DruidProcessingModule(), (Object)new QueryableModule(), (Object)new QueryRunnerFactoryModule(), binder -> {
            JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(MetadataStorageConnectorConfig.class), (Object)new MetadataStorageConnectorConfig(){

                public String getConnectURI() {
                    return CreateTables.this.connectURI;
                }

                public String getUser() {
                    return CreateTables.this.user;
                }

                public String getPassword() {
                    return CreateTables.this.password;
                }
            });
            JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(MetadataStorageTablesConfig.class), (Object)MetadataStorageTablesConfig.fromBase((String)this.base));
            JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)new DruidNode("tools", "localhost", false, Integer.valueOf(-1), null, true, false));
        });
    }

    @Override
    public void run() {
        Injector injector = this.makeInjector();
        MetadataStorageConnector dbConnector = (MetadataStorageConnector)injector.getInstance(MetadataStorageConnector.class);
        dbConnector.createDataSourceTable();
        dbConnector.createPendingSegmentsTable();
        dbConnector.createSegmentTable();
        dbConnector.createUpgradeSegmentsTable();
        dbConnector.createRulesTable();
        dbConnector.createConfigTable();
        dbConnector.createTaskTables();
        dbConnector.createAuditTable();
        dbConnector.createSupervisorsTable();
    }
}

