/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.calcite.avatica.remote.ProtobufTranslation;
import org.apache.calcite.avatica.remote.ProtobufTranslationImpl;
import org.apache.calcite.avatica.remote.Service;
import org.apache.commons.io.IOUtils;
import org.apache.druid.client.selector.Server;
import org.apache.druid.common.exception.SanitizableException;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.guice.http.DruidHttpClientConfig;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.DruidMetrics;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.druid.server.JettyUtils;
import org.apache.druid.server.QueryStats;
import org.apache.druid.server.RequestLogLine;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.initialization.jetty.StandardResponseHeaderFilterHolder;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.metrics.QueryCountStatsProvider;
import org.apache.druid.server.router.QueryHostFinder;
import org.apache.druid.server.router.Router;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Authenticator;
import org.apache.druid.server.security.AuthenticatorMapper;
import org.apache.druid.sql.http.SqlQuery;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.proxy.AsyncProxyServlet;
import org.eclipse.jetty.proxy.ProxyServlet;
import org.joda.time.DateTime;

public class AsyncQueryForwardingServlet
extends AsyncProxyServlet
implements QueryCountStatsProvider {
    private static final EmittingLogger LOG = new EmittingLogger(AsyncQueryForwardingServlet.class);
    @Deprecated
    private static final String APPLICATION_SMILE = "application/smile";
    private static final String AVATICA_CONNECTION_ID = "connectionId";
    private static final String AVATICA_STATEMENT_HANDLE = "statementHandle";
    private static final String HOST_ATTRIBUTE = "org.apache.druid.proxy.to.host";
    private static final String SCHEME_ATTRIBUTE = "org.apache.druid.proxy.to.host.scheme";
    private static final String QUERY_ATTRIBUTE = "org.apache.druid.proxy.query";
    private static final String AVATICA_QUERY_ATTRIBUTE = "org.apache.druid.proxy.avaticaQuery";
    private static final String SQL_QUERY_ATTRIBUTE = "org.apache.druid.proxy.sqlQuery";
    private static final String OBJECTMAPPER_ATTRIBUTE = "org.apache.druid.proxy.objectMapper";
    private static final String PROPERTY_SQL_ENABLE = "druid.router.sql.enable";
    private static final String PROPERTY_SQL_ENABLE_DEFAULT = "false";
    private static final int CANCELLATION_TIMEOUT_MILLIS = 500;
    private final AtomicLong successfulQueryCount = new AtomicLong();
    private final AtomicLong failedQueryCount = new AtomicLong();
    private final AtomicLong interruptedQueryCount = new AtomicLong();
    private final QueryToolChestWarehouse warehouse;
    private final ObjectMapper jsonMapper;
    private final ObjectMapper smileMapper;
    private final QueryHostFinder hostFinder;
    private final Provider<HttpClient> httpClientProvider;
    private final DruidHttpClientConfig httpClientConfig;
    private final ServiceEmitter emitter;
    private final RequestLogger requestLogger;
    private final GenericQueryMetricsFactory queryMetricsFactory;
    private final AuthenticatorMapper authenticatorMapper;
    private final ProtobufTranslation protobufTranslation;
    private final ServerConfig serverConfig;
    private final boolean routeSqlByStrategy;
    private HttpClient broadcastClient;

    @VisibleForTesting
    void handleException(HttpServletResponse response, ObjectMapper objectMapper, Exception exception) throws IOException {
        QueryInterruptedException exceptionToReport = QueryInterruptedException.wrapIfNeeded((Throwable)exception);
        LOG.warn((Throwable)exceptionToReport, "Unexpected exception occurs", new Object[0]);
        if (!response.isCommitted()) {
            response.resetBuffer();
            response.setStatus(500);
            objectMapper.writeValue((OutputStream)response.getOutputStream(), (Object)this.serverConfig.getErrorResponseTransformStrategy().transformIfNeeded((SanitizableException)exceptionToReport));
        }
        response.flushBuffer();
    }

    @Inject
    public AsyncQueryForwardingServlet(QueryToolChestWarehouse warehouse, @Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, QueryHostFinder hostFinder, @Router Provider<HttpClient> httpClientProvider, @Router DruidHttpClientConfig httpClientConfig, ServiceEmitter emitter, RequestLogger requestLogger, GenericQueryMetricsFactory queryMetricsFactory, AuthenticatorMapper authenticatorMapper, Properties properties, ServerConfig serverConfig) {
        this.warehouse = warehouse;
        this.jsonMapper = jsonMapper;
        this.smileMapper = smileMapper;
        this.hostFinder = hostFinder;
        this.httpClientProvider = httpClientProvider;
        this.httpClientConfig = httpClientConfig;
        this.emitter = emitter;
        this.requestLogger = requestLogger;
        this.queryMetricsFactory = queryMetricsFactory;
        this.authenticatorMapper = authenticatorMapper;
        this.protobufTranslation = new ProtobufTranslationImpl();
        this.routeSqlByStrategy = Boolean.parseBoolean(properties.getProperty(PROPERTY_SQL_ENABLE, PROPERTY_SQL_ENABLE_DEFAULT));
        this.serverConfig = serverConfig;
    }

    public void init() throws ServletException {
        super.init();
        this.broadcastClient = this.newHttpClient();
        try {
            this.broadcastClient.start();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        super.destroy();
        try {
            this.broadcastClient.stop();
        }
        catch (Exception e) {
            LOG.warn((Throwable)e, "Error stopping servlet", new Object[0]);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Server targetServer;
        boolean isSmile = "application/x-jackson-smile".equals(request.getContentType()) || APPLICATION_SMILE.equals(request.getContentType());
        ObjectMapper objectMapper = isSmile ? this.smileMapper : this.jsonMapper;
        request.setAttribute(OBJECTMAPPER_ATTRIBUTE, (Object)objectMapper);
        String requestURI = request.getRequestURI();
        String method = request.getMethod();
        boolean isNativeQueryEndpoint = requestURI.startsWith("/druid/v2") && !requestURI.startsWith("/druid/v2/sql");
        boolean isSqlQueryEndpoint = requestURI.startsWith("/druid/v2/sql");
        boolean isAvaticaJson = requestURI.startsWith("/druid/v2/sql/avatica");
        boolean isAvaticaPb = requestURI.startsWith("/druid/v2/sql/avatica-protobuf");
        if (isAvaticaPb) {
            byte[] requestBytes = IOUtils.toByteArray((InputStream)request.getInputStream());
            Service.Request protobufRequest = this.protobufTranslation.parseRequest(requestBytes);
            String connectionId = AsyncQueryForwardingServlet.getAvaticaProtobufConnectionId(protobufRequest);
            targetServer = this.hostFinder.findServerAvatica(connectionId);
            request.setAttribute(AVATICA_QUERY_ATTRIBUTE, (Object)requestBytes);
            LOG.debug("Forwarding protobuf JDBC connection [%s] to broker [%s]", new Object[]{connectionId, targetServer});
        } else if (isAvaticaJson) {
            Map requestMap = (Map)objectMapper.readValue((InputStream)request.getInputStream(), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
            String connectionId = AsyncQueryForwardingServlet.getAvaticaConnectionId(requestMap);
            targetServer = this.hostFinder.findServerAvatica(connectionId);
            byte[] requestBytes = objectMapper.writeValueAsBytes((Object)requestMap);
            request.setAttribute(AVATICA_QUERY_ATTRIBUTE, (Object)requestBytes);
            LOG.debug("Forwarding JDBC connection [%s] to broker [%s]", new Object[]{connectionId, targetServer.getHost()});
        } else if (HttpMethod.DELETE.is(method)) {
            targetServer = this.hostFinder.pickDefaultServer();
            this.broadcastQueryCancelRequest(request, targetServer);
            LOG.debug("Broadcasting cancellation request to all brokers", new Object[0]);
        } else if (isNativeQueryEndpoint && HttpMethod.POST.is(method)) {
            try {
                Query inputQuery = (Query)objectMapper.readValue((InputStream)request.getInputStream(), Query.class);
                if (inputQuery != null) {
                    targetServer = this.hostFinder.pickServer(inputQuery);
                    if (inputQuery.getId() == null) {
                        inputQuery = inputQuery.withId(UUID.randomUUID().toString());
                    }
                    LOG.debug("Forwarding JSON query [%s] to broker [%s]", new Object[]{inputQuery.getId(), targetServer.getHost()});
                } else {
                    targetServer = this.hostFinder.pickDefaultServer();
                    LOG.debug("Forwarding JSON request to broker [%s]", new Object[]{targetServer.getHost()});
                }
                request.setAttribute(QUERY_ATTRIBUTE, (Object)inputQuery);
            }
            catch (IOException e) {
                this.handleQueryParseException(request, response, objectMapper, e, true);
                return;
            }
            catch (Exception e) {
                this.handleException(response, objectMapper, e);
                return;
            }
        } else if (isSqlQueryEndpoint && HttpMethod.POST.is(method)) {
            try {
                SqlQuery inputSqlQuery = (SqlQuery)objectMapper.readValue((InputStream)request.getInputStream(), SqlQuery.class);
                inputSqlQuery = this.buildSqlQueryWithId(inputSqlQuery);
                request.setAttribute(SQL_QUERY_ATTRIBUTE, (Object)inputSqlQuery);
                targetServer = this.routeSqlByStrategy ? this.hostFinder.findServerSql(inputSqlQuery) : this.hostFinder.pickDefaultServer();
                LOG.debug("Forwarding SQL query to broker [%s]", new Object[]{targetServer.getHost()});
            }
            catch (IOException e) {
                this.handleQueryParseException(request, response, objectMapper, e, false);
                return;
            }
            catch (Exception e) {
                this.handleException(response, objectMapper, e);
                return;
            }
        } else {
            targetServer = this.hostFinder.pickDefaultServer();
            LOG.debug("Forwarding query to broker [%s]", new Object[]{targetServer.getHost()});
        }
        request.setAttribute(HOST_ATTRIBUTE, (Object)targetServer.getHost());
        request.setAttribute(SCHEME_ATTRIBUTE, (Object)targetServer.getScheme());
        this.doService(request, response);
    }

    private SqlQuery buildSqlQueryWithId(SqlQuery sqlQuery) {
        HashMap<String, String> context = new HashMap<String, String>(sqlQuery.getContext());
        String sqlQueryId = context.getOrDefault("sqlQueryId", UUID.randomUUID().toString());
        String queryId = context.getOrDefault("queryId", sqlQueryId);
        context.put("sqlQueryId", sqlQueryId);
        context.put("queryId", queryId);
        return sqlQuery.withOverridenContext(context);
    }

    private void broadcastQueryCancelRequest(HttpServletRequest request, Server targetServer) {
        for (Server server : this.hostFinder.getAllServers()) {
            if (server.getHost().equals(targetServer.getHost())) continue;
            Response.CompleteListener completeListener = result -> {
                if (result.isFailed()) {
                    LOG.warn(result.getFailure(), "Failed to forward cancellation request to [%s]", new Object[]{server.getHost()});
                }
            };
            Request broadcastReq = this.broadcastClient.newRequest(this.rewriteURI(request, server.getScheme(), server.getHost())).method(HttpMethod.DELETE).timeout(500L, TimeUnit.MILLISECONDS);
            this.copyRequestHeaders(request, broadcastReq);
            broadcastReq.send(completeListener);
        }
        this.interruptedQueryCount.incrementAndGet();
    }

    @VisibleForTesting
    void handleQueryParseException(HttpServletRequest request, HttpServletResponse response, ObjectMapper objectMapper, IOException parseException, boolean isNativeQuery) throws IOException {
        String errorMessage;
        QueryInterruptedException exceptionToReport = QueryInterruptedException.wrapIfNeeded((Throwable)parseException);
        LOG.warn((Throwable)exceptionToReport, "Exception parsing query", new Object[0]);
        String string = errorMessage = exceptionToReport.getMessage() == null ? "no error message" : exceptionToReport.getMessage();
        if (isNativeQuery) {
            this.requestLogger.logNativeQuery(RequestLogLine.forNative(null, (DateTime)DateTimes.nowUtc(), (String)request.getRemoteAddr(), (QueryStats)new QueryStats((Map)ImmutableMap.of((Object)"success", (Object)false, (Object)"exception", (Object)errorMessage))));
        } else {
            this.requestLogger.logSqlQuery(RequestLogLine.forSql(null, null, (DateTime)DateTimes.nowUtc(), (String)request.getRemoteAddr(), (QueryStats)new QueryStats((Map)ImmutableMap.of((Object)"success", (Object)false, (Object)"exception", (Object)errorMessage))));
        }
        response.setStatus(400);
        response.setContentType("application/json");
        objectMapper.writeValue((OutputStream)response.getOutputStream(), (Object)this.serverConfig.getErrorResponseTransformStrategy().transformIfNeeded((SanitizableException)exceptionToReport));
    }

    protected void doService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.service(request, response);
    }

    protected void sendProxyRequest(HttpServletRequest clientRequest, HttpServletResponse proxyResponse, Request proxyRequest) {
        proxyRequest.timeout(this.httpClientConfig.getReadTimeout().getMillis(), TimeUnit.MILLISECONDS);
        proxyRequest.idleTimeout(this.httpClientConfig.getReadTimeout().getMillis(), TimeUnit.MILLISECONDS);
        byte[] avaticaQuery = (byte[])clientRequest.getAttribute(AVATICA_QUERY_ATTRIBUTE);
        if (avaticaQuery != null) {
            proxyRequest.content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{avaticaQuery}));
        }
        Query query = (Query)clientRequest.getAttribute(QUERY_ATTRIBUTE);
        SqlQuery sqlQuery = (SqlQuery)clientRequest.getAttribute(SQL_QUERY_ATTRIBUTE);
        if (query != null) {
            this.setProxyRequestContent(proxyRequest, clientRequest, query);
        } else if (sqlQuery != null) {
            this.setProxyRequestContent(proxyRequest, clientRequest, sqlQuery);
        }
        clientRequest.setAttribute("Druid-Authorization-Checked", (Object)true);
        AuthenticationResult authenticationResult = (AuthenticationResult)clientRequest.getAttribute("Druid-Authentication-Result");
        if (authenticationResult != null && authenticationResult.getAuthenticatedBy() != null) {
            Authenticator authenticator = (Authenticator)this.authenticatorMapper.getAuthenticatorMap().get(authenticationResult.getAuthenticatedBy());
            if (authenticator != null) {
                authenticator.decorateProxyRequest(clientRequest, proxyResponse, proxyRequest);
            } else {
                LOG.error("Can not find Authenticator with Name [%s]", new Object[]{authenticationResult.getAuthenticatedBy()});
            }
        }
        super.sendProxyRequest(clientRequest, proxyResponse, proxyRequest);
    }

    private void setProxyRequestContent(Request proxyRequest, HttpServletRequest clientRequest, Object content) {
        ObjectMapper objectMapper = (ObjectMapper)clientRequest.getAttribute(OBJECTMAPPER_ATTRIBUTE);
        try {
            byte[] bytes = objectMapper.writeValueAsBytes(content);
            proxyRequest.content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{bytes}));
            proxyRequest.getHeaders().put(HttpHeader.CONTENT_LENGTH, String.valueOf(bytes.length));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    protected Response.Listener newProxyResponseListener(HttpServletRequest request, HttpServletResponse response) {
        boolean isJDBC = request.getAttribute(AVATICA_QUERY_ATTRIBUTE) != null;
        return this.newMetricsEmittingProxyResponseListener(request, response, (Query)request.getAttribute(QUERY_ATTRIBUTE), (SqlQuery)request.getAttribute(SQL_QUERY_ATTRIBUTE), isJDBC, System.nanoTime());
    }

    protected String rewriteTarget(HttpServletRequest request) {
        return this.rewriteURI(request, (String)request.getAttribute(SCHEME_ATTRIBUTE), (String)request.getAttribute(HOST_ATTRIBUTE));
    }

    protected String rewriteURI(HttpServletRequest request, String scheme, String host) {
        return AsyncQueryForwardingServlet.makeURI(scheme, host, request.getRequestURI(), request.getQueryString());
    }

    @VisibleForTesting
    static String makeURI(String scheme, String host, String requestURI, String rawQueryString) {
        return JettyUtils.concatenateForRewrite((String)(scheme + "://" + host), (String)requestURI, (String)rawQueryString);
    }

    protected HttpClient newHttpClient() {
        return (HttpClient)this.httpClientProvider.get();
    }

    protected HttpClient createHttpClient() throws ServletException {
        HttpClient client = super.createHttpClient();
        this.setTimeout(this.httpClientConfig.getReadTimeout().getMillis());
        return client;
    }

    private Response.Listener newMetricsEmittingProxyResponseListener(HttpServletRequest request, HttpServletResponse response, @Nullable Query query, @Nullable SqlQuery sqlQuery, boolean isJDBC, long startNs) {
        return new MetricsEmittingProxyResponseListener(request, response, query, sqlQuery, isJDBC, startNs);
    }

    public long getSuccessfulQueryCount() {
        return this.successfulQueryCount.get();
    }

    public long getFailedQueryCount() {
        return this.failedQueryCount.get();
    }

    public long getInterruptedQueryCount() {
        return this.interruptedQueryCount.get();
    }

    public long getTimedOutQueryCount() {
        return 0L;
    }

    protected void onServerResponseHeaders(HttpServletRequest clientRequest, HttpServletResponse proxyResponse, Response serverResponse) {
        StandardResponseHeaderFilterHolder.deduplicateHeadersInProxyServlet((HttpServletResponse)proxyResponse, (Response)serverResponse);
        super.onServerResponseHeaders(clientRequest, proxyResponse, serverResponse);
    }

    @VisibleForTesting
    static String getAvaticaConnectionId(Map<String, Object> requestMap) {
        Object statementHandle;
        Object connectionIdObj = requestMap.get(AVATICA_CONNECTION_ID);
        if (connectionIdObj == null && (statementHandle = requestMap.get(AVATICA_STATEMENT_HANDLE)) != null && statementHandle instanceof Map) {
            connectionIdObj = ((Map)statementHandle).get(AVATICA_CONNECTION_ID);
        }
        if (connectionIdObj == null) {
            throw new IAE("Received an Avatica request without a %s.", new Object[]{AVATICA_CONNECTION_ID});
        }
        if (!(connectionIdObj instanceof String)) {
            throw new IAE("Received an Avatica request with a non-String %s.", new Object[]{AVATICA_CONNECTION_ID});
        }
        return (String)connectionIdObj;
    }

    static String getAvaticaProtobufConnectionId(Service.Request request) {
        if (request instanceof Service.CatalogsRequest) {
            return ((Service.CatalogsRequest)request).connectionId;
        }
        if (request instanceof Service.SchemasRequest) {
            return ((Service.SchemasRequest)request).connectionId;
        }
        if (request instanceof Service.TablesRequest) {
            return ((Service.TablesRequest)request).connectionId;
        }
        if (request instanceof Service.TypeInfoRequest) {
            return ((Service.TypeInfoRequest)request).connectionId;
        }
        if (request instanceof Service.ColumnsRequest) {
            return ((Service.ColumnsRequest)request).connectionId;
        }
        if (request instanceof Service.ExecuteRequest) {
            return ((Service.ExecuteRequest)request).statementHandle.connectionId;
        }
        if (request instanceof Service.TableTypesRequest) {
            return ((Service.TableTypesRequest)request).connectionId;
        }
        if (request instanceof Service.PrepareRequest) {
            return ((Service.PrepareRequest)request).connectionId;
        }
        if (request instanceof Service.PrepareAndExecuteRequest) {
            return ((Service.PrepareAndExecuteRequest)request).connectionId;
        }
        if (request instanceof Service.FetchRequest) {
            return ((Service.FetchRequest)request).connectionId;
        }
        if (request instanceof Service.CreateStatementRequest) {
            return ((Service.CreateStatementRequest)request).connectionId;
        }
        if (request instanceof Service.CloseStatementRequest) {
            return ((Service.CloseStatementRequest)request).connectionId;
        }
        if (request instanceof Service.OpenConnectionRequest) {
            return ((Service.OpenConnectionRequest)request).connectionId;
        }
        if (request instanceof Service.CloseConnectionRequest) {
            return ((Service.CloseConnectionRequest)request).connectionId;
        }
        if (request instanceof Service.ConnectionSyncRequest) {
            return ((Service.ConnectionSyncRequest)request).connectionId;
        }
        if (request instanceof Service.DatabasePropertyRequest) {
            return ((Service.DatabasePropertyRequest)request).connectionId;
        }
        if (request instanceof Service.SyncResultsRequest) {
            return ((Service.SyncResultsRequest)request).connectionId;
        }
        if (request instanceof Service.CommitRequest) {
            return ((Service.CommitRequest)request).connectionId;
        }
        if (request instanceof Service.RollbackRequest) {
            return ((Service.RollbackRequest)request).connectionId;
        }
        if (request instanceof Service.PrepareAndExecuteBatchRequest) {
            return ((Service.PrepareAndExecuteBatchRequest)request).connectionId;
        }
        if (request instanceof Service.ExecuteBatchRequest) {
            return ((Service.ExecuteBatchRequest)request).connectionId;
        }
        throw new IAE("Received an unknown Avatica protobuf request", new Object[0]);
    }

    private class MetricsEmittingProxyResponseListener<T>
    extends ProxyServlet.ProxyResponseListener {
        private final HttpServletRequest req;
        @Nullable
        private final Query<T> query;
        @Nullable
        private final SqlQuery sqlQuery;
        private final boolean isJDBC;
        private final long startNs;

        public MetricsEmittingProxyResponseListener(HttpServletRequest request, @Nullable HttpServletResponse response, @Nullable Query<T> query, SqlQuery sqlQuery, boolean isJDBC, long startNs) {
            super((ProxyServlet)AsyncQueryForwardingServlet.this, request, response);
            this.req = request;
            this.query = query;
            this.sqlQuery = sqlQuery;
            this.isJDBC = isJDBC;
            this.startNs = startNs;
        }

        public void onComplete(Result result) {
            long requestTimeNs = System.nanoTime() - this.startNs;
            String queryId = null;
            String sqlQueryId = null;
            if (this.isJDBC) {
                sqlQueryId = result.getResponse().getHeaders().get("X-Druid-SQL-Query-Id");
            } else if (this.sqlQuery != null) {
                sqlQueryId = this.sqlQuery.getContext().getOrDefault("sqlQueryId", null);
                queryId = this.sqlQuery.getContext().getOrDefault("queryId", null);
            } else if (this.query != null) {
                queryId = this.query.getId();
            }
            if (queryId == null && sqlQueryId == null) {
                super.onComplete(result);
                return;
            }
            boolean success = result.isSucceeded();
            if (success) {
                AsyncQueryForwardingServlet.this.successfulQueryCount.incrementAndGet();
            } else {
                AsyncQueryForwardingServlet.this.failedQueryCount.incrementAndGet();
            }
            this.emitQueryTime(requestTimeNs, success, sqlQueryId, queryId);
            if (sqlQueryId != null) {
                if (this.sqlQuery != null) {
                    try {
                        AsyncQueryForwardingServlet.this.requestLogger.logSqlQuery(RequestLogLine.forSql((String)this.sqlQuery.getQuery(), (Map)this.sqlQuery.getContext(), (DateTime)DateTimes.nowUtc(), (String)this.req.getRemoteAddr(), (QueryStats)new QueryStats((Map)ImmutableMap.of((Object)"query/time", (Object)TimeUnit.NANOSECONDS.toMillis(requestTimeNs), (Object)"success", (Object)(success && result.getResponse().getStatus() == Response.Status.OK.getStatusCode() ? 1 : 0)))));
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e, "Unable to log SQL query [%s]!", new Object[]{this.sqlQuery});
                    }
                }
                super.onComplete(result);
                return;
            }
            try {
                AsyncQueryForwardingServlet.this.requestLogger.logNativeQuery(RequestLogLine.forNative(this.query, (DateTime)DateTimes.nowUtc(), (String)this.req.getRemoteAddr(), (QueryStats)new QueryStats((Map)ImmutableMap.of((Object)"query/time", (Object)TimeUnit.NANOSECONDS.toMillis(requestTimeNs), (Object)"success", (Object)(success && result.getResponse().getStatus() == Response.Status.OK.getStatusCode() ? 1 : 0)))));
            }
            catch (Exception e) {
                LOG.error((Throwable)e, "Unable to log query [%s]!", new Object[]{this.query});
            }
            super.onComplete(result);
        }

        public void onFailure(Response response, Throwable failure) {
            long requestTimeNs = System.nanoTime() - this.startNs;
            String errorMessage = failure.getMessage();
            String queryId = null;
            String sqlQueryId = null;
            if (this.isJDBC) {
                sqlQueryId = response.getHeaders().get("X-Druid-SQL-Query-Id");
            } else if (this.sqlQuery != null) {
                sqlQueryId = this.sqlQuery.getContext().getOrDefault("sqlQueryId", null);
                queryId = this.sqlQuery.getContext().getOrDefault("queryId", null);
            } else if (this.query != null) {
                queryId = this.query.getId();
            }
            if (queryId == null && sqlQueryId == null) {
                super.onFailure(response, failure);
                return;
            }
            AsyncQueryForwardingServlet.this.failedQueryCount.incrementAndGet();
            this.emitQueryTime(requestTimeNs, false, sqlQueryId, queryId);
            if (sqlQueryId != null) {
                if (this.sqlQuery != null) {
                    try {
                        AsyncQueryForwardingServlet.this.requestLogger.logSqlQuery(RequestLogLine.forSql((String)this.sqlQuery.getQuery(), (Map)this.sqlQuery.getContext(), (DateTime)DateTimes.nowUtc(), (String)this.req.getRemoteAddr(), (QueryStats)new QueryStats((Map)ImmutableMap.of((Object)"success", (Object)false, (Object)"exception", (Object)(errorMessage == null ? "no message" : errorMessage)))));
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e, "Unable to log SQL query [%s]!", new Object[]{this.sqlQuery});
                    }
                    LOG.makeAlert(failure, "Exception handling request", new Object[0]).addData("exception", (Object)failure.toString()).addData("sqlQuery", (Object)this.sqlQuery).addData("peer", (Object)this.req.getRemoteAddr()).emit();
                }
                super.onFailure(response, failure);
                return;
            }
            try {
                AsyncQueryForwardingServlet.this.requestLogger.logNativeQuery(RequestLogLine.forNative(this.query, (DateTime)DateTimes.nowUtc(), (String)this.req.getRemoteAddr(), (QueryStats)new QueryStats((Map)ImmutableMap.of((Object)"success", (Object)false, (Object)"exception", (Object)(errorMessage == null ? "no message" : errorMessage)))));
            }
            catch (IOException logError) {
                LOG.error((Throwable)logError, "Unable to log query [%s]!", new Object[]{this.query});
            }
            LOG.makeAlert(failure, "Exception handling request", new Object[0]).addData("exception", (Object)failure.toString()).addData("query", this.query).addData("peer", (Object)this.req.getRemoteAddr()).emit();
            super.onFailure(response, failure);
        }

        private void emitQueryTime(long requestTimeNs, boolean success, @Nullable String sqlQueryId, @Nullable String queryId) {
            QueryMetrics queryMetrics;
            if (sqlQueryId != null) {
                queryMetrics = AsyncQueryForwardingServlet.this.queryMetricsFactory.makeMetrics();
                queryMetrics.remoteAddress(this.req.getRemoteAddr());
                queryMetrics.sqlQueryId(sqlQueryId);
                if (queryId != null) {
                    queryMetrics.queryId(queryId);
                }
            } else {
                queryMetrics = DruidMetrics.makeRequestMetrics((GenericQueryMetricsFactory)AsyncQueryForwardingServlet.this.queryMetricsFactory, (QueryToolChest)AsyncQueryForwardingServlet.this.warehouse.getToolChest(this.query), this.query, (String)this.req.getRemoteAddr());
            }
            queryMetrics.success(success);
            queryMetrics.reportQueryTime(requestTimeNs).emit(AsyncQueryForwardingServlet.this.emitter);
        }
    }
}

