/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.rvesse.airline.annotations.Command;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.util.Providers;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.Filter;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.cli.ServerRunnable;
import org.apache.druid.cli.WebConsoleJettyServerInitializer;
import org.apache.druid.client.indexing.IndexingService;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.IndexingServiceFirehoseModule;
import org.apache.druid.guice.IndexingServiceInputSourceModule;
import org.apache.druid.guice.IndexingServiceModuleHelper;
import org.apache.druid.guice.IndexingServiceTaskLogsModule;
import org.apache.druid.guice.IndexingServiceTuningConfigModule;
import org.apache.druid.guice.JacksonConfigProvider;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.ListProvider;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.PolyBind;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.indexing.common.RetryPolicyFactory;
import org.apache.druid.indexing.common.TaskStorageDirTracker;
import org.apache.druid.indexing.common.actions.LocalTaskActionClientFactory;
import org.apache.druid.indexing.common.actions.TaskActionClientFactory;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.actions.TaskAuditLogConfig;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.config.TaskStorageConfig;
import org.apache.druid.indexing.common.stats.DropwizardRowIngestionMetersFactory;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClientProvider;
import org.apache.druid.indexing.common.task.batch.parallel.ShuffleClient;
import org.apache.druid.indexing.common.tasklogs.SwitchingTaskLogStreamer;
import org.apache.druid.indexing.common.tasklogs.TaskRunnerTaskLogStreamer;
import org.apache.druid.indexing.overlord.ForkingTaskRunnerFactory;
import org.apache.druid.indexing.overlord.HeapMemoryTaskStorage;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageAdapter;
import org.apache.druid.indexing.overlord.MetadataTaskStorage;
import org.apache.druid.indexing.overlord.RemoteTaskRunnerFactory;
import org.apache.druid.indexing.overlord.TaskLockbox;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.indexing.overlord.TaskRunnerFactory;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.TaskStorageQueryAdapter;
import org.apache.druid.indexing.overlord.autoscaling.PendingTaskBasedWorkerProvisioningConfig;
import org.apache.druid.indexing.overlord.autoscaling.PendingTaskBasedWorkerProvisioningStrategy;
import org.apache.druid.indexing.overlord.autoscaling.ProvisioningSchedulerConfig;
import org.apache.druid.indexing.overlord.autoscaling.ProvisioningStrategy;
import org.apache.druid.indexing.overlord.autoscaling.SimpleWorkerProvisioningConfig;
import org.apache.druid.indexing.overlord.autoscaling.SimpleWorkerProvisioningStrategy;
import org.apache.druid.indexing.overlord.config.DefaultTaskConfig;
import org.apache.druid.indexing.overlord.config.TaskLockConfig;
import org.apache.druid.indexing.overlord.config.TaskQueueConfig;
import org.apache.druid.indexing.overlord.duty.OverlordDuty;
import org.apache.druid.indexing.overlord.duty.TaskLogAutoCleaner;
import org.apache.druid.indexing.overlord.duty.TaskLogAutoCleanerConfig;
import org.apache.druid.indexing.overlord.hrtr.HttpRemoteTaskRunnerFactory;
import org.apache.druid.indexing.overlord.hrtr.HttpRemoteTaskRunnerResource;
import org.apache.druid.indexing.overlord.http.OverlordRedirectInfo;
import org.apache.druid.indexing.overlord.http.OverlordResource;
import org.apache.druid.indexing.overlord.sampler.SamplerModule;
import org.apache.druid.indexing.overlord.setup.WorkerBehaviorConfig;
import org.apache.druid.indexing.overlord.supervisor.SupervisorManager;
import org.apache.druid.indexing.overlord.supervisor.SupervisorModule;
import org.apache.druid.indexing.overlord.supervisor.SupervisorResource;
import org.apache.druid.indexing.worker.config.WorkerConfig;
import org.apache.druid.indexing.worker.shuffle.DeepStorageIntermediaryDataManager;
import org.apache.druid.indexing.worker.shuffle.IntermediaryDataManager;
import org.apache.druid.indexing.worker.shuffle.LocalIntermediaryDataManager;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.input.InputSourceModule;
import org.apache.druid.query.lookup.LookupSerdeModule;
import org.apache.druid.segment.incremental.RowIngestionMetersFactory;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.segment.realtime.appenderator.DummyForInjectionAppenderatorsManager;
import org.apache.druid.segment.realtime.firehose.ChatHandlerProvider;
import org.apache.druid.segment.realtime.firehose.NoopChatHandlerProvider;
import org.apache.druid.server.audit.AuditManagerProvider;
import org.apache.druid.server.coordinator.CoordinatorOverlordServiceConfig;
import org.apache.druid.server.http.RedirectFilter;
import org.apache.druid.server.http.RedirectInfo;
import org.apache.druid.server.http.SelfDiscoveryResource;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.initialization.jetty.JettyServerInitUtils;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.druid.server.metrics.TaskCountStatsProvider;
import org.apache.druid.server.metrics.TaskSlotCountStatsProvider;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthenticationUtils;
import org.apache.druid.server.security.AuthenticatorMapper;
import org.apache.druid.tasklogs.TaskLogStreamer;
import org.apache.druid.tasklogs.TaskLogs;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

@Command(name="overlord", description="Runs an Overlord node, see https://druid.apache.org/docs/latest/Indexing-Service.html for a description")
public class CliOverlord
extends ServerRunnable {
    private static Logger log = new Logger(CliOverlord.class);
    protected static final List<String> UNSECURED_PATHS = ImmutableList.of((Object)"/druid/indexer/v1/isLeader", (Object)"/status/health");

    public CliOverlord() {
        super(log);
    }

    @Override
    protected Set<NodeRole> getNodeRoles(Properties properties) {
        return ImmutableSet.of((Object)NodeRole.OVERLORD);
    }

    @Override
    protected List<? extends Module> getModules() {
        return this.getModules(true);
    }

    protected List<? extends Module> getModules(final boolean standalone) {
        return ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                if (standalone) {
                    binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/overlord");
                    binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(8090);
                    binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(8290);
                }
                JsonConfigProvider.bind((Binder)binder, (String)"druid.coordinator.asOverlord", CoordinatorOverlordServiceConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.queue", TaskQueueConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.tasklock", TaskLockConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.task", TaskConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.task.default", DefaultTaskConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.auditlog", TaskAuditLogConfig.class);
                binder.bind(RetryPolicyFactory.class).in(LazySingleton.class);
                binder.bind(TaskMaster.class).in(ManageLifecycle.class);
                binder.bind(TaskCountStatsProvider.class).to(TaskMaster.class);
                binder.bind(TaskSlotCountStatsProvider.class).to(TaskMaster.class);
                binder.bind(TaskLogStreamer.class).to(SwitchingTaskLogStreamer.class).in(LazySingleton.class);
                binder.bind((TypeLiteral)new TypeLiteral<List<TaskLogStreamer>>(){}).toProvider((Provider)new ListProvider().add(TaskLogs.class)).in(LazySingleton.class);
                binder.bind(TaskLogStreamer.class).annotatedWith((Annotation)Names.named((String)"taskstreamer")).to(TaskRunnerTaskLogStreamer.class).in(LazySingleton.class);
                binder.bind(TaskActionClientFactory.class).to(LocalTaskActionClientFactory.class).in(LazySingleton.class);
                binder.bind(TaskActionToolbox.class).in(LazySingleton.class);
                binder.bind(TaskLockbox.class).in(LazySingleton.class);
                binder.bind(TaskStorageQueryAdapter.class).in(LazySingleton.class);
                binder.bind(IndexerMetadataStorageAdapter.class).in(LazySingleton.class);
                binder.bind(SupervisorManager.class).in(LazySingleton.class);
                binder.bind(ParallelIndexSupervisorTaskClientProvider.class).toProvider(Providers.of(null));
                binder.bind(ShuffleClient.class).toProvider(Providers.of(null));
                binder.bind(ChatHandlerProvider.class).toProvider(Providers.of((Object)new NoopChatHandlerProvider()));
                PolyBind.createChoice((Binder)binder, (String)"druid.indexer.task.rowIngestionMeters.type", (Key)Key.get(RowIngestionMetersFactory.class), (Key)Key.get(DropwizardRowIngestionMetersFactory.class));
                MapBinder rowIngestionMetersHandlerProviderBinder = PolyBind.optionBinder((Binder)binder, (Key)Key.get(RowIngestionMetersFactory.class));
                rowIngestionMetersHandlerProviderBinder.addBinding((Object)"dropwizard").to(DropwizardRowIngestionMetersFactory.class).in(LazySingleton.class);
                binder.bind(DropwizardRowIngestionMetersFactory.class).in(LazySingleton.class);
                this.configureTaskStorage(binder);
                this.configureIntermediaryData(binder);
                this.configureAutoscale(binder);
                binder.install(this.runnerConfigModule());
                this.configureOverlordHelpers(binder);
                binder.bind(AuditManager.class).toProvider(AuditManagerProvider.class).in(ManageLifecycle.class);
                if (standalone) {
                    binder.bind(RedirectFilter.class).in(LazySingleton.class);
                    binder.bind(RedirectInfo.class).to(OverlordRedirectInfo.class).in(LazySingleton.class);
                    binder.bind(JettyServerInitializer.class).to(OverlordJettyServerInitializer.class).in(LazySingleton.class);
                }
                Jerseys.addResource((Binder)binder, OverlordResource.class);
                Jerseys.addResource((Binder)binder, SupervisorResource.class);
                Jerseys.addResource((Binder)binder, HttpRemoteTaskRunnerResource.class);
                binder.bind(AppenderatorsManager.class).to(DummyForInjectionAppenderatorsManager.class).in(LazySingleton.class);
                if (standalone) {
                    LifecycleModule.register((Binder)binder, Server.class);
                    ServerRunnable.bindAnnouncer(binder, IndexingService.class, ServerRunnable.DiscoverySideEffectsProvider.create());
                }
                Jerseys.addResource((Binder)binder, SelfDiscoveryResource.class);
                LifecycleModule.registerKey((Binder)binder, (Key)Key.get(SelfDiscoveryResource.class));
            }

            private void configureTaskStorage(Binder binder) {
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.storage", TaskStorageConfig.class);
                PolyBind.createChoice((Binder)binder, (String)"druid.indexer.storage.type", (Key)Key.get(TaskStorage.class), (Key)Key.get(HeapMemoryTaskStorage.class));
                MapBinder storageBinder = PolyBind.optionBinder((Binder)binder, (Key)Key.get(TaskStorage.class));
                storageBinder.addBinding((Object)"local").to(HeapMemoryTaskStorage.class);
                binder.bind(HeapMemoryTaskStorage.class).in(LazySingleton.class);
                storageBinder.addBinding((Object)"metadata").to(MetadataTaskStorage.class).in(ManageLifecycle.class);
                binder.bind(MetadataTaskStorage.class).in(LazySingleton.class);
            }

            private void configureIntermediaryData(Binder binder) {
                PolyBind.createChoice((Binder)binder, (String)"druid.processing.intermediaryData.storage.type", (Key)Key.get(IntermediaryDataManager.class), (Key)Key.get(LocalIntermediaryDataManager.class));
                MapBinder biddy = PolyBind.optionBinder((Binder)binder, (Key)Key.get(IntermediaryDataManager.class));
                biddy.addBinding((Object)"local").to(LocalIntermediaryDataManager.class);
                biddy.addBinding((Object)"deepstore").to(DeepStorageIntermediaryDataManager.class).in(LazySingleton.class);
            }

            private Module runnerConfigModule() {
                return new Module(){

                    public void configure(Binder binder) {
                        JsonConfigProvider.bind((Binder)binder, (String)"druid.worker", WorkerConfig.class);
                        PolyBind.createChoice((Binder)binder, (String)"druid.indexer.runner.type", (Key)Key.get(TaskRunnerFactory.class), (Key)Key.get(HttpRemoteTaskRunnerFactory.class));
                        MapBinder biddy = PolyBind.optionBinder((Binder)binder, (Key)Key.get(TaskRunnerFactory.class));
                        IndexingServiceModuleHelper.configureTaskRunnerConfigs((Binder)binder);
                        biddy.addBinding((Object)"local").to(ForkingTaskRunnerFactory.class);
                        binder.bind(ForkingTaskRunnerFactory.class).in(LazySingleton.class);
                        biddy.addBinding((Object)"remote").to(RemoteTaskRunnerFactory.class).in(LazySingleton.class);
                        binder.bind(RemoteTaskRunnerFactory.class).in(LazySingleton.class);
                        biddy.addBinding((Object)"httpRemote").to(HttpRemoteTaskRunnerFactory.class).in(LazySingleton.class);
                        binder.bind(HttpRemoteTaskRunnerFactory.class).in(LazySingleton.class);
                        JacksonConfigProvider.bind((Binder)binder, (String)"worker.config", WorkerBehaviorConfig.class, null);
                    }

                    @Provides
                    @ManageLifecycle
                    public TaskStorageDirTracker getTaskStorageDirTracker(WorkerConfig workerConfig, TaskConfig taskConfig) {
                        return TaskStorageDirTracker.fromConfigs((WorkerConfig)workerConfig, (TaskConfig)taskConfig);
                    }

                    @Provides
                    @LazySingleton
                    @Named(value="heartbeat")
                    public Supplier<Map<String, Object>> getHeartbeatSupplier(TaskMaster taskMaster) {
                        return () -> {
                            HashMap<String, Integer> heartbeatTags = new HashMap<String, Integer>();
                            heartbeatTags.put("leader", taskMaster.isLeader() ? 1 : 0);
                            return heartbeatTags;
                        };
                    }
                };
            }

            private void configureAutoscale(Binder binder) {
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.autoscale", ProvisioningSchedulerConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.autoscale", PendingTaskBasedWorkerProvisioningConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.autoscale", SimpleWorkerProvisioningConfig.class);
                PolyBind.createChoice((Binder)binder, (String)"druid.indexer.autoscale.strategy.type", (Key)Key.get(ProvisioningStrategy.class), (Key)Key.get(SimpleWorkerProvisioningStrategy.class));
                MapBinder biddy = PolyBind.optionBinder((Binder)binder, (Key)Key.get(ProvisioningStrategy.class));
                biddy.addBinding((Object)"simple").to(SimpleWorkerProvisioningStrategy.class);
                biddy.addBinding((Object)"pendingTaskBased").to(PendingTaskBasedWorkerProvisioningStrategy.class);
            }

            private void configureOverlordHelpers(Binder binder) {
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.logs.kill", TaskLogAutoCleanerConfig.class);
                Multibinder.newSetBinder((Binder)binder, OverlordDuty.class).addBinding().to(TaskLogAutoCleaner.class);
            }
        }, (Object)new IndexingServiceFirehoseModule(), (Object)new IndexingServiceInputSourceModule(), (Object)new IndexingServiceTaskLogsModule(), (Object)new IndexingServiceTuningConfigModule(), (Object)new InputSourceModule(), (Object)new SupervisorModule(), (Object)new LookupSerdeModule(), (Object)new SamplerModule());
    }

    private static class OverlordJettyServerInitializer
    implements JettyServerInitializer {
        private final AuthConfig authConfig;
        private final ServerConfig serverConfig;

        @Inject
        OverlordJettyServerInitializer(AuthConfig authConfig, ServerConfig serverConfig) {
            this.authConfig = authConfig;
            this.serverConfig = serverConfig;
        }

        public void initialize(Server server, Injector injector) {
            ServletContextHandler root = new ServletContextHandler(1);
            root.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
            ServletHolder holderPwd = new ServletHolder("default", DefaultServlet.class);
            root.addServlet(holderPwd, "/");
            ObjectMapper jsonMapper = (ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Json.class));
            AuthenticatorMapper authenticatorMapper = (AuthenticatorMapper)injector.getInstance(AuthenticatorMapper.class);
            JettyServerInitUtils.addQosFilters((ServletContextHandler)root, (Injector)injector);
            AuthenticationUtils.addSecuritySanityCheckFilter((ServletContextHandler)root, (ObjectMapper)jsonMapper);
            AuthenticationUtils.addNoopAuthenticationAndAuthorizationFilters((ServletContextHandler)root, UNSECURED_PATHS);
            WebConsoleJettyServerInitializer.intializeServerForWebConsoleRoot(root);
            AuthenticationUtils.addNoopAuthenticationAndAuthorizationFilters((ServletContextHandler)root, (List)this.authConfig.getUnsecuredPaths());
            List authenticators = authenticatorMapper.getAuthenticatorChain();
            AuthenticationUtils.addAuthenticationFilterChain((ServletContextHandler)root, (List)authenticators);
            AuthenticationUtils.addAllowOptionsFilter((ServletContextHandler)root, (boolean)this.authConfig.isAllowUnauthenticatedHttpOptions());
            JettyServerInitUtils.addAllowHttpMethodsFilter((ServletContextHandler)root, (List)this.serverConfig.getAllowedHttpMethods());
            JettyServerInitUtils.addExtensionFilters((ServletContextHandler)root, (Injector)injector);
            AuthenticationUtils.addPreResponseAuthorizationCheckFilter((ServletContextHandler)root, (List)authenticators, (ObjectMapper)jsonMapper);
            root.addFilter(GuiceFilter.class, "/status/*", null);
            root.addFilter(GuiceFilter.class, "/druid-internal/*", null);
            root.addFilter(new FilterHolder((Filter)injector.getInstance(RedirectFilter.class)), "/*", null);
            root.addFilter(GuiceFilter.class, "/druid/*", null);
            root.addFilter(GuiceFilter.class, "/druid-ext/*", null);
            RewriteHandler rewriteHandler = WebConsoleJettyServerInitializer.createWebConsoleRewriteHandler();
            JettyServerInitUtils.maybeAddHSTSPatternRule((ServerConfig)this.serverConfig, (RewriteHandler)rewriteHandler);
            HandlerList handlerList = new HandlerList();
            handlerList.setHandlers(new Handler[]{rewriteHandler, JettyServerInitUtils.getJettyRequestLogHandler(), JettyServerInitUtils.wrapWithDefaultGzipHandler((Handler)root, (int)this.serverConfig.getInflateBufferSize(), (int)this.serverConfig.getCompressionLevel())});
            server.setHandler((Handler)handlerList);
        }
    }
}

