/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.druid.cli.GuiceRunnable;
import org.apache.druid.curator.discovery.ServiceAnnouncer;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeAnnouncer;
import org.apache.druid.discovery.DruidService;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.server.DruidNode;

public abstract class ServerRunnable
extends GuiceRunnable {
    private static final EmittingLogger log = new EmittingLogger(ServerRunnable.class);

    public ServerRunnable(Logger log) {
        super(log);
    }

    @Override
    public void run() {
        Injector injector = this.makeInjector(this.getNodeRoles(this.getProperties()));
        Lifecycle lifecycle = this.initLifecycle(injector);
        try {
            lifecycle.join();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract Set<NodeRole> getNodeRoles(Properties var1);

    public static void bindAnnouncer(Binder binder, DiscoverySideEffectsProvider provider) {
        binder.bind(DiscoverySideEffectsProvider.Child.class).toProvider((Provider)provider).in(LazySingleton.class);
        LifecycleModule.registerKey((Binder)binder, (Key)Key.get(DiscoverySideEffectsProvider.Child.class));
    }

    public static void bindAnnouncer(Binder binder, Class<? extends Annotation> annotation, DiscoverySideEffectsProvider provider) {
        binder.bind(DiscoverySideEffectsProvider.Child.class).annotatedWith(annotation).toProvider((Provider)provider).in(LazySingleton.class);
        LifecycleModule.registerKey((Binder)binder, (Key)Key.get(DiscoverySideEffectsProvider.Child.class, annotation));
    }

    public static class DiscoverySideEffectsProvider
    implements Provider<Child> {
        @Inject
        @Self
        private DruidNode druidNode;
        @Inject
        private DruidNodeAnnouncer announcer;
        @Inject
        private ServiceAnnouncer legacyAnnouncer;
        @Inject
        private Lifecycle lifecycle;
        @Inject
        private Injector injector;
        @Inject
        @Self
        private Set<NodeRole> nodeRoles;
        @Inject
        private Map<NodeRole, Set<Class<? extends DruidService>>> serviceClasses;
        private final boolean useLegacyAnnouncer;

        public static DiscoverySideEffectsProvider create() {
            return new DiscoverySideEffectsProvider(false);
        }

        public static DiscoverySideEffectsProvider withLegacyAnnouncer() {
            return new DiscoverySideEffectsProvider(true);
        }

        private DiscoverySideEffectsProvider(boolean useLegacyAnnouncer) {
            this.useLegacyAnnouncer = useLegacyAnnouncer;
        }

        public Child get() {
            for (NodeRole nodeRole : this.nodeRoles) {
                ImmutableMap.Builder builder = new ImmutableMap.Builder();
                for (Class clazz : this.serviceClasses.getOrDefault(nodeRole, Collections.emptySet())) {
                    DruidService service = (DruidService)this.injector.getInstance(clazz);
                    if (service.isDiscoverable()) {
                        builder.put((Object)service.getName(), (Object)service);
                        continue;
                    }
                    log.info("Service[%s] is not discoverable. This will not be listed as a service provided by this node.", new Object[]{service.getName()});
                }
                final DiscoveryDruidNode discoveryDruidNode = new DiscoveryDruidNode(this.druidNode, nodeRole, (Map)builder.build());
                this.lifecycle.addHandler(new Lifecycle.Handler(){

                    public void start() {
                        announcer.announce(discoveryDruidNode);
                        if (useLegacyAnnouncer) {
                            legacyAnnouncer.announce(discoveryDruidNode.getDruidNode());
                        }
                    }

                    public void stop() {
                        if (useLegacyAnnouncer) {
                            legacyAnnouncer.unannounce(discoveryDruidNode.getDruidNode());
                        }
                        announcer.unannounce(discoveryDruidNode);
                    }
                }, Lifecycle.Stage.ANNOUNCEMENTS);
            }
            return new Child();
        }

        public static class Child {
        }
    }
}

