/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.druid.initialization.Initialization;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.log.StartupLoggingConfig;
import org.apache.druid.utils.JvmUtils;

public abstract class GuiceRunnable
implements Runnable {
    private final Logger log;
    private Injector baseInjector;

    public GuiceRunnable(Logger log) {
        this.log = log;
    }

    @Override
    public abstract void run();

    @Inject
    public void configure(Injector injector) {
        this.baseInjector = injector;
    }

    protected abstract List<? extends Module> getModules();

    public Injector makeInjector() {
        try {
            return Initialization.makeInjectorWithModules((Injector)this.baseInjector, this.getModules());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Lifecycle initLifecycle(Injector injector) {
        try {
            Lifecycle lifecycle = (Lifecycle)injector.getInstance(Lifecycle.class);
            StartupLoggingConfig startupLoggingConfig = (StartupLoggingConfig)injector.getInstance(StartupLoggingConfig.class);
            Long directSizeBytes = null;
            try {
                directSizeBytes = JvmUtils.getRuntimeInfo().getDirectMemorySizeBytes();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.log.info("Starting up with processors[%,d], memory[%,d], maxMemory[%,d]%s.", new Object[]{JvmUtils.getRuntimeInfo().getAvailableProcessors(), JvmUtils.getRuntimeInfo().getTotalHeapSizeBytes(), JvmUtils.getRuntimeInfo().getMaxHeapSizeBytes(), directSizeBytes != null ? StringUtils.format((String)", directMemory[%,d]", (Object[])new Object[]{directSizeBytes}) : ""});
            if (startupLoggingConfig.isLogProperties()) {
                HashSet maskProperties = Sets.newHashSet((Iterable)startupLoggingConfig.getMaskProperties());
                Properties props = (Properties)injector.getInstance(Properties.class);
                for (String propertyName : Ordering.natural().sortedCopy(props.stringPropertyNames())) {
                    String property = props.getProperty(propertyName);
                    for (String masked : maskProperties) {
                        if (!propertyName.contains(masked)) continue;
                        property = "<masked>";
                        break;
                    }
                    this.log.info("* %s: %s", new Object[]{propertyName, property});
                }
            }
            try {
                lifecycle.start();
            }
            catch (Throwable t) {
                this.log.error(t, "Error when starting up.  Failing.", new Object[0]);
                System.exit(1);
            }
            return lifecycle;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

