/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.name.Names;
import io.airlift.airline.Command;
import java.lang.annotation.Annotation;
import java.util.List;
import org.apache.druid.cli.QueryJettyServerInitializer;
import org.apache.druid.cli.ServerRunnable;
import org.apache.druid.client.BrokerSegmentWatcherConfig;
import org.apache.druid.client.BrokerServerView;
import org.apache.druid.client.CachingClusteredClient;
import org.apache.druid.client.HttpServerInventoryViewResource;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CacheMonitor;
import org.apache.druid.client.selector.CustomTierSelectorStrategyConfig;
import org.apache.druid.client.selector.ServerSelectorStrategy;
import org.apache.druid.client.selector.TierSelectorStrategy;
import org.apache.druid.discovery.DruidService;
import org.apache.druid.discovery.LookupNodeService;
import org.apache.druid.discovery.NodeType;
import org.apache.druid.guice.CacheModule;
import org.apache.druid.guice.DruidProcessingModule;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.QueryRunnerFactoryModule;
import org.apache.druid.guice.QueryableModule;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.RetryQueryRunnerConfig;
import org.apache.druid.query.lookup.LookupModule;
import org.apache.druid.server.BrokerQueryResource;
import org.apache.druid.server.ClientInfoResource;
import org.apache.druid.server.ClientQuerySegmentWalker;
import org.apache.druid.server.http.BrokerResource;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.druid.server.metrics.MetricsModule;
import org.apache.druid.server.metrics.QueryCountStatsProvider;
import org.apache.druid.sql.guice.SqlModule;
import org.apache.druid.timeline.PruneLoadSpec;
import org.eclipse.jetty.server.Server;

@Command(name="broker", description="Runs a broker node, see https://druid.apache.org/docs/latest/Broker.html for a description")
public class CliBroker
extends ServerRunnable {
    private static final Logger log = new Logger(CliBroker.class);

    public CliBroker() {
        super(log);
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new DruidProcessingModule(), (Object)new QueryableModule(), (Object)new QueryRunnerFactoryModule(), binder -> {
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/broker");
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(8082);
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(8282);
            binder.bindConstant().annotatedWith(PruneLoadSpec.class).to(true);
            binder.bind(CachingClusteredClient.class).in(LazySingleton.class);
            LifecycleModule.register((Binder)binder, BrokerServerView.class);
            binder.bind(TimelineServerView.class).to(BrokerServerView.class).in(LazySingleton.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.cache", CacheConfig.class);
            binder.install((Module)new CacheModule());
            JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.select", TierSelectorStrategy.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.select.tier.custom", CustomTierSelectorStrategyConfig.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.balancer", ServerSelectorStrategy.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.retryPolicy", RetryQueryRunnerConfig.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.broker.segment", BrokerSegmentWatcherConfig.class);
            binder.bind(QuerySegmentWalker.class).to(ClientQuerySegmentWalker.class).in(LazySingleton.class);
            binder.bind(JettyServerInitializer.class).to(QueryJettyServerInitializer.class).in(LazySingleton.class);
            binder.bind(BrokerQueryResource.class).in(LazySingleton.class);
            Jerseys.addResource((Binder)binder, BrokerQueryResource.class);
            binder.bind(QueryCountStatsProvider.class).to(BrokerQueryResource.class).in(LazySingleton.class);
            Jerseys.addResource((Binder)binder, BrokerResource.class);
            Jerseys.addResource((Binder)binder, ClientInfoResource.class);
            LifecycleModule.register((Binder)binder, BrokerQueryResource.class);
            Jerseys.addResource((Binder)binder, HttpServerInventoryViewResource.class);
            MetricsModule.register((Binder)binder, CacheMonitor.class);
            LifecycleModule.register((Binder)binder, Server.class);
            CliBroker.bindAnnouncer(binder, ServerRunnable.DiscoverySideEffectsProvider.builder(NodeType.BROKER).serviceClasses((List<Class<? extends DruidService>>)ImmutableList.of(LookupNodeService.class)).useLegacyAnnouncer(true).build());
        }, (Object)new LookupModule(), (Object)new SqlModule());
    }
}

