/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.google.inject.Injector;
import io.airlift.airline.Cli;
import io.airlift.airline.Help;
import io.airlift.airline.ParseException;
import io.netty.util.SuppressForbidden;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.druid.cli.CliBroker;
import org.apache.druid.cli.CliCommandCreator;
import org.apache.druid.cli.CliCoordinator;
import org.apache.druid.cli.CliHadoopIndexer;
import org.apache.druid.cli.CliHistorical;
import org.apache.druid.cli.CliInternalHadoopIndexer;
import org.apache.druid.cli.CliMiddleManager;
import org.apache.druid.cli.CliOverlord;
import org.apache.druid.cli.CliPeon;
import org.apache.druid.cli.CliRealtime;
import org.apache.druid.cli.CliRealtimeExample;
import org.apache.druid.cli.CliRouter;
import org.apache.druid.cli.CreateTables;
import org.apache.druid.cli.DumpSegment;
import org.apache.druid.cli.ExportMetadata;
import org.apache.druid.cli.PropertyChecker;
import org.apache.druid.cli.PullDependencies;
import org.apache.druid.cli.ResetCluster;
import org.apache.druid.cli.ValidateSegments;
import org.apache.druid.cli.Version;
import org.apache.druid.cli.validate.DruidJsonValidator;
import org.apache.druid.guice.ExtensionsConfig;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.initialization.Initialization;

public class Main {
    @SuppressForbidden(reason="System#out")
    public static void main(String[] args) {
        Cli.CliBuilder builder = Cli.builder((String)"druid");
        builder.withDescription("Druid command-line runner.").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{Version.class});
        List<Class> serverCommands = Arrays.asList(CliCoordinator.class, CliHistorical.class, CliBroker.class, CliRealtime.class, CliOverlord.class, CliMiddleManager.class, CliRouter.class);
        builder.withGroup("server").withDescription("Run one of the Druid server types.").withDefaultCommand(Help.class).withCommands(serverCommands);
        builder.withGroup("example").withDescription("Run an example").withDefaultCommand(Help.class).withCommands(CliRealtimeExample.class, new Class[0]);
        List<Class> toolCommands = Arrays.asList(DruidJsonValidator.class, PullDependencies.class, CreateTables.class, DumpSegment.class, ResetCluster.class, ValidateSegments.class, ExportMetadata.class);
        builder.withGroup("tools").withDescription("Various tools for working with Druid").withDefaultCommand(Help.class).withCommands(toolCommands);
        builder.withGroup("index").withDescription("Run indexing for druid").withDefaultCommand(Help.class).withCommands(CliHadoopIndexer.class, new Class[0]);
        builder.withGroup("internal").withDescription("Processes that Druid runs \"internally\", you should rarely use these directly").withDefaultCommand(Help.class).withCommands(CliPeon.class, new Class[]{CliInternalHadoopIndexer.class});
        Injector injector = GuiceInjectors.makeStartupInjector();
        ExtensionsConfig config = (ExtensionsConfig)injector.getInstance(ExtensionsConfig.class);
        Collection extensionCommands = Initialization.getFromExtensions((ExtensionsConfig)config, CliCommandCreator.class);
        for (CliCommandCreator creator : extensionCommands) {
            creator.addCommands(builder);
        }
        Cli cli = builder.build();
        try {
            Runnable command = (Runnable)cli.parse(args);
            if (!(command instanceof Help)) {
                injector.injectMembers((Object)command);
            }
            command.run();
        }
        catch (ParseException e) {
            System.out.println("ERROR!!!!");
            System.out.println(e.getMessage());
            System.out.println("===");
            ((Runnable)cli.parse(new String[]{"help"})).run();
            System.exit(1);
        }
    }

    static {
        ServiceLoader<PropertyChecker> serviceLoader = ServiceLoader.load(PropertyChecker.class);
        for (PropertyChecker propertyChecker : serviceLoader) {
            propertyChecker.checkProperties(System.getProperties());
        }
    }
}

