/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicates;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import io.airlift.airline.Command;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.apache.curator.framework.CuratorFramework;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.cli.CliOverlord;
import org.apache.druid.cli.CoordinatorJettyServerInitializer;
import org.apache.druid.cli.CoordinatorOverlordRedirectInfo;
import org.apache.druid.cli.ServerRunnable;
import org.apache.druid.client.CoordinatorSegmentWatcherConfig;
import org.apache.druid.client.CoordinatorServerView;
import org.apache.druid.client.HttpServerInventoryViewResource;
import org.apache.druid.client.coordinator.Coordinator;
import org.apache.druid.client.indexing.HttpIndexingServiceClient;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.discovery.NodeType;
import org.apache.druid.guice.ConditionalMultibind;
import org.apache.druid.guice.ConfigProvider;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.CoordinatorIndexingServiceHelper;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.guice.http.JettyHttpClientModule;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.metadata.MetadataRuleManagerConfig;
import org.apache.druid.metadata.MetadataRuleManagerProvider;
import org.apache.druid.metadata.MetadataSegmentManager;
import org.apache.druid.metadata.MetadataSegmentManagerConfig;
import org.apache.druid.metadata.MetadataSegmentManagerProvider;
import org.apache.druid.metadata.MetadataStorage;
import org.apache.druid.metadata.MetadataStorageProvider;
import org.apache.druid.query.lookup.LookupSerdeModule;
import org.apache.druid.server.audit.AuditManagerProvider;
import org.apache.druid.server.coordinator.BalancerStrategyFactory;
import org.apache.druid.server.coordinator.CachingCostBalancerStrategyConfig;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.DruidCoordinatorCleanupPendingSegments;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.LoadQueueTaskMaster;
import org.apache.druid.server.coordinator.helper.DruidCoordinatorHelper;
import org.apache.druid.server.coordinator.helper.DruidCoordinatorSegmentKiller;
import org.apache.druid.server.http.ClusterResource;
import org.apache.druid.server.http.CoordinatorCompactionConfigsResource;
import org.apache.druid.server.http.CoordinatorDynamicConfigsResource;
import org.apache.druid.server.http.CoordinatorRedirectInfo;
import org.apache.druid.server.http.CoordinatorResource;
import org.apache.druid.server.http.DataSourcesResource;
import org.apache.druid.server.http.IntervalsResource;
import org.apache.druid.server.http.LookupCoordinatorResource;
import org.apache.druid.server.http.MetadataResource;
import org.apache.druid.server.http.RedirectFilter;
import org.apache.druid.server.http.RedirectInfo;
import org.apache.druid.server.http.RulesResource;
import org.apache.druid.server.http.ServersResource;
import org.apache.druid.server.http.TiersResource;
import org.apache.druid.server.initialization.ZkPathsConfig;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.druid.server.lookup.cache.LookupCoordinatorManager;
import org.apache.druid.server.lookup.cache.LookupCoordinatorManagerConfig;
import org.eclipse.jetty.server.Server;

@Command(name="coordinator", description="Runs the Coordinator, see http://druid.io/docs/latest/Coordinator.html for a description.")
public class CliCoordinator
extends ServerRunnable {
    private static final Logger log = new Logger(CliCoordinator.class);
    private Properties properties;
    private boolean beOverlord;

    public CliCoordinator() {
        super(log);
    }

    @Inject
    public void configure(Properties properties) {
        this.properties = properties;
        this.beOverlord = CliCoordinator.isOverlord(properties);
        if (this.beOverlord) {
            log.info("Coordinator is configured to act as Overlord as well.", new Object[0]);
        }
    }

    @Override
    protected List<? extends Module> getModules() {
        ArrayList<Object> modules = new ArrayList<Object>();
        modules.add(JettyHttpClientModule.global());
        modules.add(new Module(){

            public void configure(Binder binder) {
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/coordinator");
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(8081);
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(8281);
                ConfigProvider.bind((Binder)binder, DruidCoordinatorConfig.class);
                binder.bind(MetadataStorage.class).toProvider(MetadataStorageProvider.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.manager.segments", MetadataSegmentManagerConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.manager.rules", MetadataRuleManagerConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.manager.lookups", LookupCoordinatorManagerConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.coordinator.balancer", BalancerStrategyFactory.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.coordinator.segment", CoordinatorSegmentWatcherConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.coordinator.balancer.cachingCost", CachingCostBalancerStrategyConfig.class);
                binder.bind(RedirectFilter.class).in(LazySingleton.class);
                if (CliCoordinator.this.beOverlord) {
                    binder.bind(RedirectInfo.class).to(CoordinatorOverlordRedirectInfo.class).in(LazySingleton.class);
                } else {
                    binder.bind(RedirectInfo.class).to(CoordinatorRedirectInfo.class).in(LazySingleton.class);
                }
                binder.bind(MetadataSegmentManager.class).toProvider(MetadataSegmentManagerProvider.class).in(ManageLifecycle.class);
                binder.bind(MetadataRuleManager.class).toProvider(MetadataRuleManagerProvider.class).in(ManageLifecycle.class);
                binder.bind(AuditManager.class).toProvider(AuditManagerProvider.class).in(ManageLifecycle.class);
                binder.bind(IndexingServiceClient.class).to(HttpIndexingServiceClient.class).in(LazySingleton.class);
                binder.bind(LookupCoordinatorManager.class).in(LazySingleton.class);
                binder.bind(CoordinatorServerView.class);
                binder.bind(DruidCoordinator.class);
                LifecycleModule.register((Binder)binder, CoordinatorServerView.class);
                LifecycleModule.register((Binder)binder, MetadataStorage.class);
                LifecycleModule.register((Binder)binder, DruidCoordinator.class);
                binder.bind(JettyServerInitializer.class).to(CoordinatorJettyServerInitializer.class);
                Jerseys.addResource((Binder)binder, CoordinatorResource.class);
                Jerseys.addResource((Binder)binder, CoordinatorDynamicConfigsResource.class);
                Jerseys.addResource((Binder)binder, CoordinatorCompactionConfigsResource.class);
                Jerseys.addResource((Binder)binder, TiersResource.class);
                Jerseys.addResource((Binder)binder, RulesResource.class);
                Jerseys.addResource((Binder)binder, ServersResource.class);
                Jerseys.addResource((Binder)binder, DataSourcesResource.class);
                Jerseys.addResource((Binder)binder, MetadataResource.class);
                Jerseys.addResource((Binder)binder, IntervalsResource.class);
                Jerseys.addResource((Binder)binder, LookupCoordinatorResource.class);
                Jerseys.addResource((Binder)binder, ClusterResource.class);
                Jerseys.addResource((Binder)binder, HttpServerInventoryViewResource.class);
                LifecycleModule.register((Binder)binder, Server.class);
                LifecycleModule.register((Binder)binder, DataSourcesResource.class);
                ConditionalMultibind conditionalMultibind = ConditionalMultibind.create((Properties)CliCoordinator.this.properties, (Binder)binder, DruidCoordinatorHelper.class, CoordinatorIndexingServiceHelper.class);
                if (conditionalMultibind.matchCondition("druid.coordinator.merge.on", Predicates.equalTo((Object)"true"))) {
                    throw new UnsupportedOperationException("'druid.coordinator.merge.on' is not supported anymore. Please consider using Coordinator's automatic compaction instead. See http://druid.io/docs/latest/operations/segment-optimization.html and http://druid.io/docs/latest/operations/api-reference.html#compaction-configuration for more details about compaction.");
                }
                conditionalMultibind.addConditionBinding("druid.coordinator.kill.on", Predicates.equalTo((Object)"true"), DruidCoordinatorSegmentKiller.class).addConditionBinding("druid.coordinator.kill.pendingSegments.on", Predicates.equalTo((Object)"true"), DruidCoordinatorCleanupPendingSegments.class);
                ServerRunnable.bindAnnouncer(binder, Coordinator.class, ServerRunnable.DiscoverySideEffectsProvider.builder(NodeType.COORDINATOR).build());
            }

            @Provides
            @LazySingleton
            public LoadQueueTaskMaster getLoadQueueTaskMaster(CuratorFramework curator, ObjectMapper jsonMapper, ScheduledExecutorFactory factory, DruidCoordinatorConfig config, @EscalatedGlobal HttpClient httpClient, ZkPathsConfig zkPaths) {
                boolean useHttpLoadQueuePeon = "http".equalsIgnoreCase(config.getLoadQueuePeonType());
                ExecutorService callBackExec = useHttpLoadQueuePeon ? Execs.singleThreaded((String)"LoadQueuePeon-callbackexec--%d") : Execs.multiThreaded((int)config.getNumCuratorCallBackThreads(), (String)"LoadQueuePeon-callbackexec--%d");
                return new LoadQueueTaskMaster(curator, jsonMapper, factory.create(1, "Master-PeonExec--%d"), callBackExec, config, httpClient, zkPaths);
            }
        });
        if (this.beOverlord) {
            modules.addAll(new CliOverlord().getModules(false));
        } else {
            modules.add(new LookupSerdeModule());
        }
        return modules;
    }

    public static boolean isOverlord(Properties properties) {
        return Boolean.parseBoolean(properties.getProperty("druid.coordinator.asOverlord.enabled"));
    }
}

