/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.druid.cli.GuiceRunnable;
import org.apache.druid.guice.DruidProcessingModule;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.QueryRunnerFactoryModule;
import org.apache.druid.guice.QueryableModule;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.loading.DataSegmentFinder;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.server.DruidNode;
import org.apache.druid.timeline.DataSegment;

@Command(name="insert-segment-to-db", description="insert a segment into metadata storage")
public class InsertSegment
extends GuiceRunnable {
    private static final Logger log = new Logger(InsertSegment.class);
    @Option(name={"--workingDir"}, description="The directory path where segments are stored. This tool will recursively look for segments underneath this directory and insert/update these segments in metdata storage.", required=true)
    private String workingDirPath;
    @Option(name={"--updateDescriptor"}, description="if set to true, this tool will update loadSpec field in descriptor.json (partitionNum_descriptor.json for HDFS data storage) if the path in loadSpec is different from where desciptor.json (partitionNum_descriptor.json for HDFS data storage) was found. Default value is true", required=false)
    private String updateDescriptor;
    private IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator;

    public InsertSegment() {
        super(log);
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new DruidProcessingModule(), (Object)new QueryableModule(), (Object)new QueryRunnerFactoryModule(), binder -> JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)new DruidNode("tools", "localhost", false, Integer.valueOf(-1), null, true, false)));
    }

    @Override
    public void run() {
        Injector injector = this.makeInjector();
        this.indexerMetadataStorageCoordinator = (IndexerMetadataStorageCoordinator)injector.getInstance(IndexerMetadataStorageCoordinator.class);
        DataSegmentFinder dataSegmentFinder = (DataSegmentFinder)injector.getInstance(DataSegmentFinder.class);
        log.info("Start searching segments under [%s]", new Object[]{this.workingDirPath});
        Set segments = null;
        try {
            segments = dataSegmentFinder.findSegments(this.workingDirPath, Boolean.valueOf(this.updateDescriptor).booleanValue());
        }
        catch (SegmentLoadingException e) {
            Throwables.propagate((Throwable)e);
        }
        log.info("Done searching segments under [%s], [%d] segments were found", new Object[]{this.workingDirPath, segments.size()});
        try {
            this.insertSegments(segments);
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        log.info("Done processing [%d] segments", new Object[]{segments.size()});
    }

    private void insertSegments(Set<DataSegment> segments) throws IOException {
        Set segmentsInserted = this.indexerMetadataStorageCoordinator.announceHistoricalSegments(segments);
        for (DataSegment dataSegment : segmentsInserted) {
            log.info("Sucessfully inserted Segment [%s] into metadata storage", new Object[]{dataSegment.getId()});
        }
        Sets.SetView segmentsAlreadyExist = Sets.difference(segments, (Set)segmentsInserted);
        if (!segmentsAlreadyExist.isEmpty()) {
            for (DataSegment dataSegment : segmentsAlreadyExist) {
                log.info("Segment [%s] already exists in metadata storage, updating the payload", new Object[]{dataSegment.getId()});
            }
            this.indexerMetadataStorageCoordinator.updateSegmentMetadata((Set)segmentsAlreadyExist);
        }
    }
}

