/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.security;

import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.server.security.AuthValidator;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class AuthValidatorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    public AuthValidator target;

    @Before
    public void setUp() {
        this.target = new AuthValidator();
    }

    @Test
    public void testAuthorizerNameWithEmptyIsInvalid() {
        DruidExceptionMatcher.invalidInput().expectMessageIs("Invalid value for field [authorizerName]: must not be null").assertThrowsAndMatches(() -> this.target.validateAuthorizerName(""));
    }

    @Test
    public void testAuthorizerNameWithNullIsInvalid() {
        DruidExceptionMatcher.invalidInput().expectMessageIs("Invalid value for field [authorizerName]: must not be null").assertThrowsAndMatches(() -> this.target.validateAuthorizerName(null));
    }

    @Test
    public void testAuthorizerNameStartsWithDotIsInValid() {
        DruidExceptionMatcher.invalidInput().expectMessageIs("Invalid value for field [authorizerName]: Value [.test] cannot start with '.'.").assertThrowsAndMatches(() -> this.target.validateAuthorizerName(".test"));
    }

    @Test
    public void testAuthorizerNameWithSlashIsInvalid() {
        DruidExceptionMatcher.invalidInput().expectMessageIs("Invalid value for field [authorizerName]: Value [tes/t] cannot contain '/'.").assertThrowsAndMatches(() -> this.target.validateAuthorizerName("tes/t"));
    }

    @Test
    public void testAuthorizerNameWithWhitespaceIsInvalid() {
        DruidExceptionMatcher.invalidInput().expectMessageIs("Invalid value for field [authorizerName]: Value [tes\tt] contains illegal whitespace characters.  Only space is allowed.").assertThrowsAndMatches(() -> this.target.validateAuthorizerName("tes\tt"));
    }

    @Test
    public void testAuthorizerNameWithAllowedCharactersIsValid() {
        this.target.validateAuthorizerName("t.e.$\\, \u0420\u043e\u0441\u0441\u0438\u044f \ud55c\uad6d\u4e2d\u56fd!?");
    }

    @Test
    public void testAuthenticatorNameWithAllowedCharactersIsValid() {
        this.target.validateAuthenticatorName("t.e.$\\, \u0420\u043e\u0441\u0441\u0438\u044f \ud55c\uad6d\u4e2d\u56fd!?");
    }

    @Test
    public void testAuthenticatorNameWithWhitespaceIsInvalid() {
        DruidExceptionMatcher.invalidInput().expectMessageIs("Invalid value for field [authenticatorName]: Value [tes\tt] contains illegal whitespace characters.  Only space is allowed.").assertThrowsAndMatches(() -> this.target.validateAuthenticatorName("tes\tt"));
    }
}

