/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.security;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.server.security.AuthConfig;
import org.junit.Assert;
import org.junit.Test;

public class AuthConfigTest {
    @Test
    public void testEquals() {
        EqualsVerifier.configure().usingGetClass().forClass(AuthConfig.class).verify();
    }

    @Test
    public void testContextSecurity() {
        AuthConfig config = new AuthConfig();
        ImmutableSet keys = ImmutableSet.of((Object)"a", (Object)"b", (Object)"sqlQueryId");
        Assert.assertTrue((boolean)config.contextKeysToAuthorize((Set)keys).isEmpty());
        config = AuthConfig.newBuilder().setAuthorizeQueryContextParams(true).build();
        keys = ImmutableSet.of((Object)"a", (Object)"b", (Object)"sqlQueryId");
        Assert.assertEquals((Object)ImmutableSet.of((Object)"a", (Object)"b"), (Object)config.contextKeysToAuthorize((Set)keys));
        config = AuthConfig.newBuilder().setAuthorizeQueryContextParams(true).setUnsecuredContextKeys((Set)ImmutableSet.of((Object)"a")).build();
        keys = ImmutableSet.of((Object)"a", (Object)"b", (Object)"sqlQueryId");
        Assert.assertEquals((Object)ImmutableSet.of((Object)"b"), (Object)config.contextKeysToAuthorize((Set)keys));
        config = AuthConfig.newBuilder().setAuthorizeQueryContextParams(true).setSecuredContextKeys((Set)ImmutableSet.of((Object)"a")).build();
        keys = ImmutableSet.of((Object)"a", (Object)"b", (Object)"sqlQueryId");
        Assert.assertEquals((Object)ImmutableSet.of((Object)"a"), (Object)config.contextKeysToAuthorize((Set)keys));
        config = AuthConfig.newBuilder().setAuthorizeQueryContextParams(true).setUnsecuredContextKeys((Set)ImmutableSet.of((Object)"a", (Object)"b")).setSecuredContextKeys((Set)ImmutableSet.of((Object)"b", (Object)"c")).build();
        keys = ImmutableSet.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"sqlQueryId");
        Assert.assertEquals((Object)ImmutableSet.of((Object)"c"), (Object)config.contextKeysToAuthorize((Set)keys));
    }
}

