/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.scheduling;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.server.scheduling.NoQueryLaningStrategy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NoQueryLaningStrategyTest {
    private Druids.TimeseriesQueryBuilder queryBuilder;
    private NoQueryLaningStrategy strategy;

    @Before
    public void setup() {
        this.queryBuilder = Druids.newTimeseriesQueryBuilder().dataSource("test").intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).granularity(Granularities.DAY).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")});
        this.strategy = new NoQueryLaningStrategy();
    }

    @Test
    public void testDoesntSetLane() {
        TimeseriesQuery query = this.queryBuilder.context((Map)ImmutableMap.of()).build();
        Assert.assertFalse((boolean)this.strategy.computeLane(QueryPlus.wrap((Query)query), (Set)ImmutableSet.of()).isPresent());
    }

    @Test
    public void testPreservesManualLaneFromContext() {
        String someLane = "some-lane";
        TimeseriesQuery query = this.queryBuilder.context((Map)ImmutableMap.of((Object)"priority", (Object)100, (Object)"lane", (Object)"some-lane")).build();
        Assert.assertEquals((Object)"some-lane", this.strategy.computeLane(QueryPlus.wrap((Query)query), (Set)ImmutableSet.of()).get());
    }
}

