/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.scheduling;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.server.QueryLaningStrategy;
import org.apache.druid.server.scheduling.ManualQueryLaningStrategy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ManualQueryLaningStrategyTest {
    private Druids.TimeseriesQueryBuilder queryBuilder;
    private QueryLaningStrategy exactStrategy;
    private QueryLaningStrategy percentStrategy;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setup() {
        this.queryBuilder = Druids.newTimeseriesQueryBuilder().dataSource("test").intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).granularity(Granularities.DAY).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")});
        this.exactStrategy = new ManualQueryLaningStrategy((Map)ImmutableMap.of((Object)"one", (Object)1, (Object)"ten", (Object)10), null);
        this.percentStrategy = new ManualQueryLaningStrategy((Map)ImmutableMap.of((Object)"one", (Object)1, (Object)"ten", (Object)10, (Object)"one-hundred", (Object)100), Boolean.valueOf(true));
    }

    @Test
    public void testLanesMustBeSet() {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("lanes must be set");
        new ManualQueryLaningStrategy(null, null);
    }

    @Test
    public void testMustDefineAtLeastOneLane() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("lanes must define at least one lane");
        new ManualQueryLaningStrategy((Map)ImmutableMap.of(), null);
    }

    @Test
    public void testMustNotUseTotalName() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Lane cannot be named 'total'");
        new ManualQueryLaningStrategy((Map)ImmutableMap.of((Object)"total", (Object)12), null);
    }

    @Test
    public void testMustNotUseDefaultName() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Lane cannot be named 'default'");
        new ManualQueryLaningStrategy((Map)ImmutableMap.of((Object)"default", (Object)12), null);
    }

    @Test
    public void testExactLaneLimitsMustBeAboveZero() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("All lane limits must be greater than 0");
        new ManualQueryLaningStrategy((Map)ImmutableMap.of((Object)"zero", (Object)0, (Object)"one", (Object)1), null);
    }

    @Test
    public void testPercentLaneLimitsMustBeAboveZero() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("All lane limits must be in the range 1 to 100");
        new ManualQueryLaningStrategy((Map)ImmutableMap.of((Object)"zero", (Object)0, (Object)"one", (Object)25), Boolean.valueOf(true));
    }

    @Test
    public void testPercentLaneLimitsMustBeLessThanOneHundred() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("All lane limits must be in the range 1 to 100");
        new ManualQueryLaningStrategy((Map)ImmutableMap.of((Object)"one", (Object)1, (Object)"one-hundred-and-one", (Object)101), Boolean.valueOf(true));
    }

    @Test
    public void testExactLimits() {
        Object2IntMap exactLanes = this.exactStrategy.getLaneLimits(50);
        Assert.assertEquals((long)1L, (long)exactLanes.getInt((Object)"one"));
        Assert.assertEquals((long)10L, (long)exactLanes.getInt((Object)"ten"));
    }

    @Test
    public void testPercentLimits() {
        Object2IntMap exactLanes = this.percentStrategy.getLaneLimits(50);
        Assert.assertEquals((long)1L, (long)exactLanes.getInt((Object)"one"));
        Assert.assertEquals((long)5L, (long)exactLanes.getInt((Object)"ten"));
        Assert.assertEquals((long)50L, (long)exactLanes.getInt((Object)"one-hundred"));
    }

    @Test
    public void testDoesntSetLane() {
        TimeseriesQuery query = this.queryBuilder.context((Map)ImmutableMap.of()).build();
        Assert.assertFalse((boolean)this.exactStrategy.computeLane(QueryPlus.wrap((Query)query), (Set)ImmutableSet.of()).isPresent());
        Assert.assertFalse((boolean)this.percentStrategy.computeLane(QueryPlus.wrap((Query)query), (Set)ImmutableSet.of()).isPresent());
    }

    @Test
    public void testPreservesManualLaneFromContextThatArentInMapAndIgnoresThem() {
        String someLane = "some-lane";
        TimeseriesQuery query = this.queryBuilder.context((Map)ImmutableMap.of((Object)"lane", (Object)"some-lane")).build();
        Assert.assertEquals((Object)"some-lane", this.exactStrategy.computeLane(QueryPlus.wrap((Query)query), (Set)ImmutableSet.of()).get());
        Assert.assertEquals((Object)"some-lane", this.percentStrategy.computeLane(QueryPlus.wrap((Query)query), (Set)ImmutableSet.of()).get());
    }

    @Test
    public void testPreservesManualLaneFromContext() {
        String someLane = "ten";
        TimeseriesQuery query = this.queryBuilder.context((Map)ImmutableMap.of((Object)"lane", (Object)"ten")).build();
        Assert.assertEquals((Object)"ten", this.exactStrategy.computeLane(QueryPlus.wrap((Query)query), (Set)ImmutableSet.of()).get());
        Assert.assertEquals((Object)"ten", this.percentStrategy.computeLane(QueryPlus.wrap((Query)query), (Set)ImmutableSet.of()).get());
    }
}

