/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.DefaultBlockingPool;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.server.metrics.QueryCountStatsMonitor;
import org.apache.druid.server.metrics.QueryCountStatsProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueryCountStatsMonitorTest {
    private QueryCountStatsProvider queryCountStatsProvider;
    private BlockingPool<ByteBuffer> mergeBufferPool;
    private ExecutorService executorService;

    @Before
    public void setUp() {
        this.queryCountStatsProvider = new QueryCountStatsProvider(){
            private long successEmitCount = 0L;
            private long failedEmitCount = 0L;
            private long interruptedEmitCount = 0L;
            private long timedOutEmitCount = 0L;

            public long getSuccessfulQueryCount() {
                ++this.successEmitCount;
                return this.successEmitCount;
            }

            public long getFailedQueryCount() {
                this.failedEmitCount += 2L;
                return this.failedEmitCount;
            }

            public long getInterruptedQueryCount() {
                this.interruptedEmitCount += 3L;
                return this.interruptedEmitCount;
            }

            public long getTimedOutQueryCount() {
                this.timedOutEmitCount += 4L;
                return this.timedOutEmitCount;
            }
        };
        this.mergeBufferPool = new DefaultBlockingPool(() -> ByteBuffer.allocate(1024), 1);
        this.executorService = Executors.newSingleThreadExecutor();
    }

    @After
    public void tearDown() {
        this.executorService.shutdown();
    }

    @Test
    public void testMonitor() {
        QueryCountStatsMonitor monitor = new QueryCountStatsMonitor(this.queryCountStatsProvider, this.mergeBufferPool);
        StubServiceEmitter emitter = new StubServiceEmitter("service", "host");
        monitor.doMonitor((ServiceEmitter)emitter);
        emitter.flush();
        monitor.doMonitor((ServiceEmitter)emitter);
        Map<String, Long> resultMap = emitter.getEvents().stream().collect(Collectors.toMap(event -> (String)event.toMap().get((Object)"metric"), event -> (Long)event.toMap().get((Object)"value")));
        Assert.assertEquals((long)6L, (long)resultMap.size());
        Assert.assertEquals((long)1L, (long)resultMap.get("query/success/count"));
        Assert.assertEquals((long)2L, (long)resultMap.get("query/failed/count"));
        Assert.assertEquals((long)3L, (long)resultMap.get("query/interrupted/count"));
        Assert.assertEquals((long)4L, (long)resultMap.get("query/timeout/count"));
        Assert.assertEquals((long)10L, (long)resultMap.get("query/count"));
        Assert.assertEquals((long)0L, (long)resultMap.get("mergeBuffer/pendingRequests"));
    }

    @Test(timeout=2000L)
    public void testMonitoringMergeBuffer() {
        this.executorService.submit(() -> this.mergeBufferPool.takeBatch(10));
        int count = 0;
        try {
            while (this.mergeBufferPool.getPendingRequests() == 0L) {
                Thread.sleep(100L);
                if (++count < 20) continue;
            }
            QueryCountStatsMonitor monitor = new QueryCountStatsMonitor(this.queryCountStatsProvider, this.mergeBufferPool);
            StubServiceEmitter emitter = new StubServiceEmitter("DummyService", "DummyHost");
            boolean ret = monitor.doMonitor((ServiceEmitter)emitter);
            Assert.assertTrue((boolean)ret);
            List numbers = emitter.getMetricValues("mergeBuffer/pendingRequests", Collections.emptyMap());
            Assert.assertEquals((long)1L, (long)numbers.size());
            Assert.assertEquals((long)1L, (long)((Number)numbers.get(0)).intValue());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

