/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.lookup.cache;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.lookup.cache.LookupLoadingSpec;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class LookupLoadingSpecTest {
    @Test
    public void testLoadingAllLookups() {
        LookupLoadingSpec spec = LookupLoadingSpec.ALL;
        Assert.assertEquals((Object)LookupLoadingSpec.Mode.ALL, (Object)spec.getMode());
        Assert.assertNull((Object)spec.getLookupsToLoad());
    }

    @Test
    public void testLoadingNoLookups() {
        LookupLoadingSpec spec = LookupLoadingSpec.NONE;
        Assert.assertEquals((Object)LookupLoadingSpec.Mode.NONE, (Object)spec.getMode());
        Assert.assertNull((Object)spec.getLookupsToLoad());
    }

    @Test
    public void testLoadingOnlyRequiredLookups() {
        ImmutableSet lookupsToLoad = ImmutableSet.of((Object)"lookupName1", (Object)"lookupName2");
        LookupLoadingSpec spec = LookupLoadingSpec.loadOnly((Set)lookupsToLoad);
        Assert.assertEquals((Object)LookupLoadingSpec.Mode.ONLY_REQUIRED, (Object)spec.getMode());
        Assert.assertEquals((Object)lookupsToLoad, (Object)spec.getLookupsToLoad());
    }

    @Test
    public void testLoadingOnlyRequiredLookupsWithNullList() {
        DruidException exception = (DruidException)Assert.assertThrows(DruidException.class, () -> LookupLoadingSpec.loadOnly(null));
        Assert.assertEquals((Object)"Expected non-null set of lookups to load.", (Object)exception.getMessage());
    }

    @Test
    public void testCreateLookupLoadingSpecFromEmptyContext() {
        Assert.assertEquals((Object)LookupLoadingSpec.ALL, (Object)LookupLoadingSpec.createFromContext((Map)ImmutableMap.of(), (LookupLoadingSpec)LookupLoadingSpec.ALL));
        Assert.assertEquals((Object)LookupLoadingSpec.NONE, (Object)LookupLoadingSpec.createFromContext((Map)ImmutableMap.of(), (LookupLoadingSpec)LookupLoadingSpec.NONE));
    }

    @Test
    public void testCreateLookupLoadingSpecFromNullContext() {
        Assert.assertEquals((Object)LookupLoadingSpec.NONE, (Object)LookupLoadingSpec.createFromContext(null, (LookupLoadingSpec)LookupLoadingSpec.NONE));
        Assert.assertEquals((Object)LookupLoadingSpec.ALL, (Object)LookupLoadingSpec.createFromContext(null, (LookupLoadingSpec)LookupLoadingSpec.ALL));
    }

    @Test
    public void testCreateLookupLoadingSpecFromContext() {
        Assert.assertEquals((Object)LookupLoadingSpec.loadOnly((Set)ImmutableSet.of((Object)"lookup1", (Object)"lookup2")), (Object)LookupLoadingSpec.createFromContext((Map)ImmutableMap.of((Object)"lookupsToLoad", Arrays.asList("lookup1", "lookup2"), (Object)"lookupLoadingMode", (Object)LookupLoadingSpec.Mode.ONLY_REQUIRED), (LookupLoadingSpec)LookupLoadingSpec.ALL));
        Assert.assertEquals((Object)LookupLoadingSpec.NONE, (Object)LookupLoadingSpec.createFromContext((Map)ImmutableMap.of((Object)"lookupLoadingMode", (Object)LookupLoadingSpec.Mode.NONE), (LookupLoadingSpec)LookupLoadingSpec.ALL));
        Assert.assertEquals((Object)LookupLoadingSpec.ALL, (Object)LookupLoadingSpec.createFromContext((Map)ImmutableMap.of((Object)"lookupLoadingMode", (Object)LookupLoadingSpec.Mode.ALL), (LookupLoadingSpec)LookupLoadingSpec.NONE));
    }

    @Test
    @Parameters(value={"NONE1", "A", "Random mode", "all", "only required", "none"})
    public void testCreateLookupLoadingSpecFromInvalidModeInContext(String mode) {
        DruidException exception = (DruidException)Assert.assertThrows(DruidException.class, () -> LookupLoadingSpec.createFromContext((Map)ImmutableMap.of((Object)"lookupLoadingMode", (Object)mode), (LookupLoadingSpec)LookupLoadingSpec.ALL));
        Assert.assertEquals((Object)StringUtils.format((String)"Invalid value of %s[%s]. Allowed values are [ALL, NONE, ONLY_REQUIRED]", (Object[])new Object[]{"lookupLoadingMode", mode}), (Object)exception.getMessage());
    }

    @Test
    @Parameters(value={"foo bar", "foo]"})
    public void testCreateLookupLoadingSpecFromInvalidLookupsInContext(Object lookupsToLoad) {
        DruidException exception = (DruidException)Assert.assertThrows(DruidException.class, () -> LookupLoadingSpec.createFromContext((Map)ImmutableMap.of((Object)"lookupsToLoad", (Object)lookupsToLoad, (Object)"lookupLoadingMode", (Object)LookupLoadingSpec.Mode.ONLY_REQUIRED), (LookupLoadingSpec)LookupLoadingSpec.ALL));
        Assert.assertEquals((Object)StringUtils.format((String)"Invalid value of %s[%s]. Please provide a comma-separated list of lookup names. For example: [\"lookupName1\", \"lookupName2\"]", (Object[])new Object[]{"lookupsToLoad", lookupsToLoad}), (Object)exception.getMessage());
    }
}

