/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.log;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.druid.server.RequestLogLine;
import org.apache.druid.server.log.RequestLogger;

public class TestRequestLogger
implements RequestLogger {
    private final List<RequestLogLine> nativeQuerylogs;
    private final List<RequestLogLine> sqlQueryLogs;
    private final AtomicBoolean started = new AtomicBoolean();

    public TestRequestLogger() {
        this.nativeQuerylogs = new ArrayList<RequestLogLine>();
        this.sqlQueryLogs = new ArrayList<RequestLogLine>();
    }

    public void start() {
        this.started.set(true);
    }

    public void stop() {
        this.started.set(false);
    }

    public boolean isStarted() {
        return this.started.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logNativeQuery(RequestLogLine requestLogLine) {
        List<RequestLogLine> list = this.nativeQuerylogs;
        synchronized (list) {
            this.nativeQuerylogs.add(requestLogLine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logSqlQuery(RequestLogLine requestLogLine) {
        List<RequestLogLine> list = this.sqlQueryLogs;
        synchronized (list) {
            this.sqlQueryLogs.add(requestLogLine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RequestLogLine> getNativeQuerylogs() {
        List<RequestLogLine> list = this.nativeQuerylogs;
        synchronized (list) {
            return ImmutableList.copyOf(this.nativeQuerylogs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RequestLogLine> getSqlQueryLogs() {
        List<RequestLogLine> list = this.sqlQueryLogs;
        synchronized (list) {
            return ImmutableList.copyOf(this.sqlQueryLogs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<RequestLogLine> list = this.nativeQuerylogs;
        synchronized (list) {
            this.nativeQuerylogs.clear();
        }
        list = this.sqlQueryLogs;
        synchronized (list) {
            this.sqlQueryLogs.clear();
        }
    }
}

