/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization.jetty;

import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.server.initialization.jetty.JettyServerModule;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.junit.Test;
import org.mockito.Mockito;

public class JettyServerModuleTest {
    @Test
    public void testJettyServerModule() {
        QueuedThreadPool jettyServerThreadPool = (QueuedThreadPool)Mockito.mock(QueuedThreadPool.class);
        JettyServerModule.setJettyServerThreadPool((QueuedThreadPool)jettyServerThreadPool);
        Mockito.when((Object)jettyServerThreadPool.getThreads()).thenReturn((Object)100);
        Mockito.when((Object)jettyServerThreadPool.getIdleThreads()).thenReturn((Object)40);
        Mockito.when((Object)jettyServerThreadPool.isLowOnThreads()).thenReturn((Object)true);
        Mockito.when((Object)jettyServerThreadPool.getMinThreads()).thenReturn((Object)30);
        Mockito.when((Object)jettyServerThreadPool.getMaxThreads()).thenReturn((Object)100);
        Mockito.when((Object)jettyServerThreadPool.getQueueSize()).thenReturn((Object)50);
        Mockito.when((Object)jettyServerThreadPool.getBusyThreads()).thenReturn((Object)60);
        JettyServerModule.JettyMonitor jettyMonitor = new JettyServerModule.JettyMonitor("ds", "t0");
        StubServiceEmitter serviceEmitter = new StubServiceEmitter("service", "host");
        jettyMonitor.doMonitor((ServiceEmitter)serviceEmitter);
        serviceEmitter.verifyValue("jetty/numOpenConnections", (Number)0);
        serviceEmitter.verifyValue("jetty/threadPool/total", (Number)100);
        serviceEmitter.verifyValue("jetty/threadPool/idle", (Number)40);
        serviceEmitter.verifyValue("jetty/threadPool/isLowOnThreads", (Number)1);
        serviceEmitter.verifyValue("jetty/threadPool/min", (Number)30);
        serviceEmitter.verifyValue("jetty/threadPool/max", (Number)100);
        serviceEmitter.verifyValue("jetty/threadPool/queueSize", (Number)50);
        serviceEmitter.verifyValue("jetty/threadPool/busy", (Number)60);
    }
}

