/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.server.http.DataSegmentPlus;
import org.apache.druid.timeline.CompactionState;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataSegmentPlusTest {
    private static final ObjectMapper MAPPER = new DefaultObjectMapper();
    private static final int TEST_VERSION = 9;

    @Before
    public void setUp() {
        InjectableValues.Std injectableValues = new InjectableValues.Std();
        injectableValues.addValue(DataSegment.PruneSpecsHolder.class, (Object)DataSegment.PruneSpecsHolder.DEFAULT);
        MAPPER.setInjectableValues((InjectableValues)injectableValues);
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(DataSegmentPlus.class).withNonnullFields(new String[]{"dataSegment", "createdDate"}).usingGetClass().verify();
    }

    @Test
    public void testSerde() throws JsonProcessingException {
        Interval interval = Intervals.of((String)"2011-10-01/2011-10-02");
        ImmutableMap loadSpec = ImmutableMap.of((Object)"something", (Object)"or_other");
        String createdDateStr = "2024-01-20T00:00:00.701Z";
        String usedStatusLastUpdatedDateStr = "2024-01-20T01:00:00.701Z";
        DateTime createdDate = DateTimes.of((String)createdDateStr);
        DateTime usedStatusLastUpdatedDate = DateTimes.of((String)usedStatusLastUpdatedDateStr);
        DataSegmentPlus segmentPlus = new DataSegmentPlus(new DataSegment("something", interval, "1", (Map)loadSpec, Arrays.asList("dim1", "dim2"), Arrays.asList("met1", "met2"), (ShardSpec)new NumberedShardSpec(3, 0), new CompactionState((PartitionsSpec)new HashedPartitionsSpec(Integer.valueOf(100000), null, (List)ImmutableList.of((Object)"dim1")), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"dim1", (Object)"bar", (Object)"foo"))), (List)ImmutableList.of((Object)ImmutableMap.of((Object)"type", (Object)"count", (Object)"name", (Object)"count")), (Map)ImmutableMap.of((Object)"filter", (Object)ImmutableMap.of((Object)"type", (Object)"selector", (Object)"dimension", (Object)"dim1", (Object)"value", (Object)"foo")), (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), Integer.valueOf(9), 1L), createdDate, usedStatusLastUpdatedDate, null, null, null, null);
        Map objectMap = (Map)MAPPER.readValue(MAPPER.writeValueAsString((Object)segmentPlus), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        Assert.assertEquals((long)7L, (long)objectMap.size());
        Map segmentObjectMap = (Map)MAPPER.readValue(MAPPER.writeValueAsString((Object)segmentPlus.getDataSegment()), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        Assert.assertEquals((long)11L, (long)segmentObjectMap.size());
        Assert.assertEquals((Object)"something", segmentObjectMap.get("dataSource"));
        Assert.assertEquals((Object)interval.toString(), segmentObjectMap.get("interval"));
        Assert.assertEquals((Object)"1", segmentObjectMap.get("version"));
        Assert.assertEquals((Object)loadSpec, segmentObjectMap.get("loadSpec"));
        Assert.assertEquals((Object)"dim1,dim2", segmentObjectMap.get("dimensions"));
        Assert.assertEquals((Object)"met1,met2", segmentObjectMap.get("metrics"));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"type", (Object)"numbered", (Object)"partitionNum", (Object)3, (Object)"partitions", (Object)0), segmentObjectMap.get("shardSpec"));
        Assert.assertEquals((Object)9, segmentObjectMap.get("binaryVersion"));
        Assert.assertEquals((Object)1, segmentObjectMap.get("size"));
        Assert.assertEquals((long)6L, (long)((Map)segmentObjectMap.get("lastCompactionState")).size());
        Assert.assertEquals((Object)createdDateStr, objectMap.get("createdDate"));
        Assert.assertEquals((Object)usedStatusLastUpdatedDateStr, objectMap.get("usedStatusLastUpdatedDate"));
        DataSegmentPlus deserializedSegmentPlus = (DataSegmentPlus)MAPPER.readValue(MAPPER.writeValueAsString((Object)segmentPlus), DataSegmentPlus.class);
        Assert.assertEquals((Object)segmentPlus.getDataSegment().getDataSource(), (Object)deserializedSegmentPlus.getDataSegment().getDataSource());
        Assert.assertEquals((Object)segmentPlus.getDataSegment().getInterval(), (Object)deserializedSegmentPlus.getDataSegment().getInterval());
        Assert.assertEquals((Object)segmentPlus.getDataSegment().getVersion(), (Object)deserializedSegmentPlus.getDataSegment().getVersion());
        Assert.assertEquals((Object)segmentPlus.getDataSegment().getLoadSpec(), (Object)deserializedSegmentPlus.getDataSegment().getLoadSpec());
        Assert.assertEquals((Object)segmentPlus.getDataSegment().getDimensions(), (Object)deserializedSegmentPlus.getDataSegment().getDimensions());
        Assert.assertEquals((Object)segmentPlus.getDataSegment().getMetrics(), (Object)deserializedSegmentPlus.getDataSegment().getMetrics());
        Assert.assertEquals((Object)segmentPlus.getDataSegment().getShardSpec(), (Object)deserializedSegmentPlus.getDataSegment().getShardSpec());
        Assert.assertEquals((long)segmentPlus.getDataSegment().getSize(), (long)deserializedSegmentPlus.getDataSegment().getSize());
        Assert.assertEquals((Object)segmentPlus.getDataSegment().getId(), (Object)deserializedSegmentPlus.getDataSegment().getId());
        Assert.assertEquals((Object)segmentPlus.getDataSegment().getLastCompactionState(), (Object)deserializedSegmentPlus.getDataSegment().getLastCompactionState());
        Assert.assertEquals((Object)segmentPlus.getCreatedDate(), (Object)deserializedSegmentPlus.getCreatedDate());
        Assert.assertEquals((Object)segmentPlus.getUsedStatusLastUpdatedDate(), (Object)deserializedSegmentPlus.getUsedStatusLastUpdatedDate());
    }
}

