/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.duty.DutyGroupStatus;
import org.apache.druid.server.coordinator.loading.TestLoadQueuePeon;
import org.apache.druid.server.http.CoordinatorDutyStatus;
import org.apache.druid.server.http.CoordinatorResource;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CoordinatorResourceTest {
    private DruidCoordinator mock;

    @Before
    public void setUp() {
        this.mock = (DruidCoordinator)EasyMock.createStrictMock(DruidCoordinator.class);
    }

    @After
    public void tearDown() {
        EasyMock.verify((Object[])new Object[]{this.mock});
    }

    @Test
    public void testLeader() {
        EasyMock.expect((Object)this.mock.getCurrentLeader()).andReturn((Object)"boz").once();
        EasyMock.replay((Object[])new Object[]{this.mock});
        Response response = new CoordinatorResource(this.mock).getLeader();
        Assert.assertEquals((Object)"boz", (Object)response.getEntity());
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testIsLeader() {
        EasyMock.expect((Object)this.mock.isLeader()).andReturn((Object)true).once();
        EasyMock.expect((Object)this.mock.isLeader()).andReturn((Object)false).once();
        EasyMock.replay((Object[])new Object[]{this.mock});
        Response response1 = new CoordinatorResource(this.mock).isLeader();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"leader", (Object)true), (Object)response1.getEntity());
        Assert.assertEquals((long)200L, (long)response1.getStatus());
        Response response2 = new CoordinatorResource(this.mock).isLeader();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"leader", (Object)false), (Object)response2.getEntity());
        Assert.assertEquals((long)404L, (long)response2.getStatus());
    }

    @Test
    public void testGetLoadStatusSimple() {
        EasyMock.expect((Object)this.mock.getLoadManagementPeons()).andReturn((Object)ImmutableMap.of((Object)"hist1", (Object)new TestLoadQueuePeon())).once();
        EasyMock.replay((Object[])new Object[]{this.mock});
        Response response = new CoordinatorResource(this.mock).getLoadQueue("true", null);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"hist1", (Object)ImmutableMap.of((Object)"segmentsToDrop", (Object)0, (Object)"segmentsToLoad", (Object)0, (Object)"segmentsToLoadSize", (Object)0L, (Object)"segmentsToDropSize", (Object)0L, (Object)"expectedLoadTimeMillis", (Object)0L)), (Object)response.getEntity());
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testGetStatusOfDuties() {
        DateTime now = DateTimes.nowUtc();
        DutyGroupStatus dutyGroupStatus = new DutyGroupStatus("HistoricalManagementDuties", Duration.standardMinutes((long)1L), Collections.singletonList("org.apache.druid.duty.RunRules"), now.minusMinutes(5), now, 100L, 500L);
        EasyMock.expect((Object)this.mock.getStatusOfDuties()).andReturn(Collections.singletonList(dutyGroupStatus)).once();
        EasyMock.replay((Object[])new Object[]{this.mock});
        Response response = new CoordinatorResource(this.mock).getStatusOfDuties();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Object payload = response.getEntity();
        Assert.assertTrue((boolean)(payload instanceof CoordinatorDutyStatus));
        List observedDutyGroups = ((CoordinatorDutyStatus)payload).getDutyGroups();
        Assert.assertEquals((long)1L, (long)observedDutyGroups.size());
        DutyGroupStatus observedStatus = (DutyGroupStatus)observedDutyGroups.get(0);
        Assert.assertEquals((Object)"HistoricalManagementDuties", (Object)observedStatus.getName());
        Assert.assertEquals((Object)Duration.standardMinutes((long)1L), (Object)observedStatus.getPeriod());
        Assert.assertEquals(Collections.singletonList("org.apache.druid.duty.RunRules"), (Object)observedStatus.getDutyNames());
        Assert.assertEquals((Object)now.minusMinutes(5), (Object)observedStatus.getLastRunStart());
        Assert.assertEquals((Object)now, (Object)observedStatus.getLastRunEnd());
        Assert.assertEquals((long)100L, (long)observedStatus.getAvgRuntimeMillis());
        Assert.assertEquals((long)500L, (long)observedStatus.getAvgRunGapMillis());
    }
}

