/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.simulate;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.server.coordination.DataSegmentChangeCallback;
import org.apache.druid.server.coordination.DataSegmentChangeHandler;
import org.apache.druid.server.coordination.DataSegmentChangeRequest;
import org.apache.druid.server.coordination.DataSegmentChangeResponse;
import org.apache.druid.server.coordination.SegmentChangeStatus;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.joda.time.Duration;

public class TestSegmentLoadingHttpClient
implements HttpClient {
    private static final HttpResponseHandler.TrafficCop NOOP_TRAFFIC_COP = checkNum -> 0L;
    private static final DataSegmentChangeCallback NOOP_CALLBACK = () -> {};
    private final ObjectMapper objectMapper;
    private final Function<String, DataSegmentChangeHandler> hostToHandler;
    private final ListeningScheduledExecutorService executorService;

    public TestSegmentLoadingHttpClient(ObjectMapper objectMapper, Function<String, DataSegmentChangeHandler> hostToHandler, ScheduledExecutorService executorService) {
        this.objectMapper = objectMapper;
        this.hostToHandler = hostToHandler;
        this.executorService = MoreExecutors.listeningDecorator((ScheduledExecutorService)executorService);
    }

    public <Intermediate, Final> ListenableFuture<Final> go(Request request, HttpResponseHandler<Intermediate, Final> handler) {
        return this.go(request, handler, null);
    }

    public <Intermediate, Final> ListenableFuture<Final> go(Request request, HttpResponseHandler<Intermediate, Final> handler, Duration readTimeout) {
        return this.executorService.submit(() -> this.processRequest(request, handler));
    }

    private <Intermediate, Final> Final processRequest(Request request, HttpResponseHandler<Intermediate, Final> handler) {
        try {
            byte[] serializedContent;
            DataSegmentChangeHandler changeHandler = this.hostToHandler.apply(request.getUrl().getHost());
            if (changeHandler == null) {
                DefaultHttpResponse failureResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
                failureResponse.setContent(ChannelBuffers.EMPTY_BUFFER);
                handler.handleResponse((HttpResponse)failureResponse, NOOP_TRAFFIC_COP);
                return (Final)new ByteArrayInputStream(new byte[0]);
            }
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                this.objectMapper.writeValue((OutputStream)baos, this.processRequest(request, changeHandler));
                serializedContent = baos.toByteArray();
            }
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            response.setContent(ChannelBuffers.EMPTY_BUFFER);
            handler.handleResponse((HttpResponse)response, NOOP_TRAFFIC_COP);
            return (Final)new ByteArrayInputStream(serializedContent);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<DataSegmentChangeResponse> processRequest(Request request, DataSegmentChangeHandler changeHandler) throws IOException {
        List changeRequests = (List)this.objectMapper.readValue(request.getContent().array(), (TypeReference)new TypeReference<List<DataSegmentChangeRequest>>(){});
        return changeRequests.stream().map(changeRequest -> this.processRequest((DataSegmentChangeRequest)changeRequest, changeHandler)).collect(Collectors.toList());
    }

    private DataSegmentChangeResponse processRequest(DataSegmentChangeRequest request, DataSegmentChangeHandler handler) {
        SegmentChangeStatus status;
        try {
            request.go(handler, NOOP_CALLBACK);
            status = SegmentChangeStatus.SUCCESS;
        }
        catch (Exception e) {
            status = SegmentChangeStatus.failed((String)e.getMessage());
        }
        return new DataSegmentChangeResponse(request, status);
    }
}

